/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.split;

import java.util.Random;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.test.NominalTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class NArySplit
extends NominalSplit {
    ClusStatistic m_MStat;

    @Override
    public void initialize(ClusStatManager manager) {
        this.m_MStat = manager.createClusteringStat();
    }

    @Override
    public void setSDataSize(int size) {
        this.m_MStat.setSDataSize(size);
    }

    @Override
    public void findSplit(CurrentBestTestAndHeuristic node, NominalAttrType type) {
        double unk_freq = 0.0;
        int nbvalues = type.getNbValues();
        if (type.hasMissing()) {
            ClusStatistic unknown = node.m_TestStat[nbvalues];
            this.m_MStat.copy(node.m_TotStat);
            this.m_MStat.subtractFromThis(unknown);
            unk_freq = unknown.getTotalWeight() / node.getTotWeight();
        } else {
            this.m_MStat.copy(node.m_TotStat);
        }
        double mheur = node.calcHeuristic(this.m_MStat, node.m_TestStat, nbvalues);
        if (mheur > node.m_BestHeur + 1.0E-6) {
            node.m_UnknownFreq = unk_freq;
            node.m_BestHeur = mheur;
            node.m_TestType = 1;
            double[] freq = this.createFreqList(this.m_MStat.getTotalWeight(), node.m_TestStat, nbvalues);
            node.m_BestTest = new NominalTest(type, freq);
        }
    }

    @Override
    public void findRandomSplit(CurrentBestTestAndHeuristic node, NominalAttrType type, Random rn) {
        try {
            throw new ClusException("Not implemented yet!");
        }
        catch (ClusException e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public void findExtraTreeSplit(CurrentBestTestAndHeuristic node, NominalAttrType type, Random rn) {
        try {
            throw new ClusException("Not implemented yet!");
        }
        catch (ClusException e) {
            e.printStackTrace();
            return;
        }
    }
}

