/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.split;

import java.util.Random;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.algo.split.NArySplit;
import si.ijs.kt.clus.algo.split.NominalSplit;
import si.ijs.kt.clus.algo.split.SubsetSplit;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.RowDataSortHelper;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.heuristic.GISHeuristic;
import si.ijs.kt.clus.heuristic.VarianceReductionHeuristicCompatibility;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.ClusRandomNonstatic;
import si.ijs.kt.clus.util.exception.ClusException;

public class FindBestTest {
    public CurrentBestTestAndHeuristic m_BestTest;
    protected RowDataSortHelper m_SortHelper = new RowDataSortHelper();
    protected ClusStatManager m_StatManager;
    protected NominalSplit m_Split;
    protected int m_MaxStats;
    public double hMaxB = Double.NEGATIVE_INFINITY;
    public double hMinB = Double.POSITIVE_INFINITY;

    public FindBestTest(ClusStatManager mgr) {
        this.m_StatManager = mgr;
        this.m_MaxStats = this.getSchema().getMaxNbStats();
        this.m_BestTest = new CurrentBestTestAndHeuristic(mgr.getSettings());
    }

    public FindBestTest(ClusStatManager mgr, NominalSplit split) {
        this(mgr);
        this.m_Split = split;
    }

    public ClusSchema getSchema() {
        return this.getStatManager().getSchema();
    }

    public ClusStatManager getStatManager() {
        return this.m_StatManager;
    }

    public RowDataSortHelper getSortHelper() {
        return this.m_SortHelper;
    }

    public Settings getSettings() {
        return this.getStatManager().getSettings();
    }

    public CurrentBestTestAndHeuristic getBestTest() {
        return this.m_BestTest;
    }

    public void cleanSplit() {
        this.m_Split = null;
    }

    public void rememberMinMax(NominalAttrType at, RowData data) throws ClusException {
        this.findNominal(at, data, null);
        ClusStatistic m_CStat = this.m_StatManager.createClusteringStat();
        m_CStat.add(this.m_BestTest.m_TestStat[0]);
        double heur = this.m_BestTest.calcHeuristic(this.m_BestTest.m_TotStat, m_CStat);
        if (heur != Double.POSITIVE_INFINITY && heur != Double.NEGATIVE_INFINITY) {
            if (heur > this.hMaxB) {
                this.hMaxB = heur;
            }
            if (heur < this.hMinB) {
                this.hMinB = heur;
            }
        }
    }

    public void findNominal(NominalAttrType at, RowData data, ClusRandomNonstatic rnd) throws ClusException {
        RowData sample = this.createSample(data, rnd);
        int nbvalues = at.getNbValues();
        this.m_BestTest.reset(nbvalues + 1);
        int nb_rows = sample.getNbRows();
        if (!data.getSchema().getSettings().getAttribute().isNullGIS()) {
            Integer[] indicesSorted = new Integer[nb_rows];
            for (int i = 0; i < nb_rows; ++i) {
                indicesSorted[i] = i;
            }
            try {
                ClusAttrType[] arr;
                ClusHeuristic gisHeuristic;
                ClusHeuristic m_Heuristic = this.m_StatManager.getHeuristic();
                if (m_Heuristic instanceof VarianceReductionHeuristicCompatibility) {
                    gisHeuristic = (VarianceReductionHeuristicCompatibility)m_Heuristic;
                    arr = at.getSchema().getAllAttrUse(ClusAttrType.AttributeUseType.GIS);
                    if (arr.length == 1) {
                        ((VarianceReductionHeuristicCompatibility)gisHeuristic).readMatrixFromFile(sample);
                    } else {
                        ((VarianceReductionHeuristicCompatibility)gisHeuristic).generateMatrix(sample);
                    }
                } else if (m_Heuristic instanceof GISHeuristic) {
                    gisHeuristic = (GISHeuristic)m_Heuristic;
                    arr = at.getSchema().getAllAttrUse(ClusAttrType.AttributeUseType.GIS);
                    if (arr.length == 1) {
                        ((GISHeuristic)gisHeuristic).readMatrixFromFile(sample);
                    } else {
                        ((GISHeuristic)gisHeuristic).generateMatrix(sample, indicesSorted);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ClusException("Error calculating GISHEuristics!");
            }
            this.m_BestTest.m_PosStat.setData(sample);
            this.m_BestTest.m_TotStat.setData(sample);
            this.m_BestTest.m_TotStat.setSplitIndex(sample.getNbRows());
            this.m_BestTest.m_PosStat.setPrevIndex(0);
            this.m_BestTest.m_PosStat.initializeSum();
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = sample.getTuple(i);
                int value = at.getNominal(tuple);
                this.m_BestTest.m_TestStat[value].setData(sample);
                this.m_BestTest.m_TestStat[value].initializeSum();
                this.m_BestTest.m_TestStat[value].setPrevIndex(0);
            }
        }
        if (nbvalues == 2 && !at.hasMissing()) {
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = sample.getTuple(i);
                int value = at.getNominal(tuple);
                if (value != 0) continue;
                this.m_BestTest.m_TestStat[0].updateWeighted(tuple, i);
                this.m_BestTest.m_TestStat[0].setSplitIndex(i + 1);
            }
            this.m_BestTest.m_TestStat[1].copy(this.m_BestTest.m_TotStat);
            this.m_BestTest.m_TestStat[1].subtractFromThis(this.m_BestTest.m_TestStat[0]);
        } else {
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = sample.getTuple(i);
                int value = at.getNominal(tuple);
                this.m_BestTest.m_TestStat[value].updateWeighted(tuple, i);
                this.m_BestTest.m_TestStat[value].setSplitIndex(i + 1);
            }
        }
        this.m_Split.findSplit(this.m_BestTest, at);
    }

    public void findNominalExtraTree(NominalAttrType at, RowData data, ClusRandomNonstatic rnd) throws ClusException {
        Random rn;
        if (rnd == null) {
            rn = ClusRandom.getRandom(7);
            ClusEnsembleInduce.giveParallelisationWarning(ClusEnsembleInduce.ParallelTrap.StaticRandom);
        } else {
            rn = rnd.getRandom(0);
        }
        RowData sample = this.createSample(data, rnd);
        int nbvalues = at.getNbValues();
        this.m_BestTest.reset(nbvalues + 1);
        int nb_rows = sample.getNbRows();
        for (int i = 0; i < nb_rows; ++i) {
            DataTuple tuple = sample.getTuple(i);
            int value = at.getNominal(tuple);
            this.m_BestTest.m_TestStat[value].updateWeighted(tuple, i);
        }
        this.m_Split.findExtraTreeSplit(this.m_BestTest, at, rn);
    }

    public void findNumeric(NumericAttrType at, RowData data, ClusRandomNonstatic rnd) throws Exception {
        boolean isGIS;
        DataTuple tuple;
        int pos;
        RowData sample = this.createSample(data, rnd);
        Integer[] indicesSorted = sample.smartSort(at);
        this.m_BestTest.reset(2);
        int nb_rows = sample.getNbRows();
        this.m_BestTest.copyTotal();
        if (at.isMissing(sample.getTuple(indicesSorted[pos]))) {
            for (pos = 0; pos < nb_rows && at.isMissing(tuple = sample.getTuple(indicesSorted[pos])); ++pos) {
                this.m_BestTest.m_MissingStat.updateWeighted(tuple, indicesSorted[pos]);
            }
            this.m_BestTest.subtractMissing();
        }
        double prev = Double.NaN;
        boolean bl = isGIS = !data.getSchema().getSettings().getAttribute().isNullGIS();
        if (isGIS) {
            this.gisMatrixForFindNumberic(sample, nb_rows, pos, indicesSorted, at);
        }
        double minValue = pos < nb_rows ? at.getNumeric(sample.getTuple(indicesSorted[nb_rows - 1])) : Double.NaN;
        boolean isSparseAtr = at.isSparse();
        double tot_corr_SVarS = 0.0;
        boolean middleSplits = data.getSchema().getSettings().getTree().getSplitPosition().equals((Object)SettingsTree.SplitPositions.Middle);
        if (isGIS) {
            for (int i = pos; i < nb_rows; ++i) {
                tuple = sample.getTuple(indicesSorted[i]);
                double value = at.getNumeric(tuple);
                if (value != prev) {
                    this.m_BestTest.updateNumericGIS(value, at, indicesSorted);
                    prev = value;
                    this.m_BestTest.m_PosStat.setPrevIndex(i);
                }
                this.m_BestTest.m_PosStat.updateWeighted(tuple, i);
                this.m_BestTest.m_PosStat.setSplitIndex(i + 1);
                if (!isSparseAtr || value != minValue) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = pos; i < nb_rows; ++i) {
                tuple = sample.getTuple(indicesSorted[i]);
                double value = at.getNumeric(tuple);
                if (value != prev) {
                    double middle = prev + (value - prev) / 2.0;
                    if (middleSplits && FindBestTest.isFinite(middle)) {
                        this.m_BestTest.updateNumeric(middle, at, tot_corr_SVarS, false);
                    } else {
                        this.m_BestTest.updateNumeric(value, at, tot_corr_SVarS, false);
                    }
                    prev = value;
                }
                this.m_BestTest.m_PosStat.updateWeighted(tuple, indicesSorted[i]);
                if (!isSparseAtr || value != minValue) {
                    continue;
                }
                break;
            }
        }
    }

    private void gisMatrixForFindNumberic(RowData sample, int nb_rows, int pos, Integer[] indicesSorted, NumericAttrType at) throws ClusException {
        double prev = Double.NaN;
        this.m_BestTest.m_PosStat.setData(sample);
        this.m_BestTest.m_TotCorrStat.setData(sample);
        this.m_BestTest.m_TotCorrStat.setSplitIndex(sample.getNbRows());
        this.m_BestTest.m_PosStat.setPrevIndex(0);
        this.m_BestTest.m_PosStat.initializeSum();
        this.m_BestTest.m_TotCorrStat.initializeSum();
        if ((this.m_BestTest.m_Heuristic instanceof GISHeuristic || this.m_BestTest.m_Heuristic instanceof VarianceReductionHeuristicCompatibility) && SettingsTree.ALPHA != 1.0) {
            for (int i = pos; i < nb_rows; ++i) {
                DataTuple tuple = sample.getTuple(indicesSorted[i]);
                double value = at.getNumeric(tuple);
                if (value != prev) {
                    if (!Double.isNaN(value)) {
                        this.m_BestTest.calculateHMinMax(value, at);
                    }
                    prev = value;
                    this.m_BestTest.m_PosStat.setPrevIndex(i);
                }
                this.m_BestTest.m_PosStat.updateWeighted(tuple, i);
                this.m_BestTest.m_PosStat.setSplitIndex(i + 1);
            }
            prev = Double.NaN;
            this.m_BestTest.m_PosStat.setData(sample);
            this.m_BestTest.m_TotCorrStat.setData(sample);
            this.m_BestTest.m_TotCorrStat.setSplitIndex(sample.getNbRows());
            this.m_BestTest.m_PosStat.reset();
            this.m_BestTest.m_PosStat.setPrevIndex(0);
            this.m_BestTest.m_PosStat.initializeSum();
        }
        try {
            ClusAttrType[] arr;
            ClusHeuristic m_Heuristic = this.m_StatManager.getHeuristic();
            if (SettingsTree.ALPHA != 1.0 && m_Heuristic instanceof VarianceReductionHeuristicCompatibility) {
                VarianceReductionHeuristicCompatibility gisHeuristic = (VarianceReductionHeuristicCompatibility)m_Heuristic;
                arr = at.getSchema().getAllAttrUse(ClusAttrType.AttributeUseType.GIS);
                if (arr.length == 1) {
                    gisHeuristic.readMatrixFromFile(sample);
                } else {
                    gisHeuristic.generateMatrix(sample);
                }
            }
            if (m_Heuristic instanceof GISHeuristic && SettingsTree.ALPHA != 1.0) {
                GISHeuristic gisHeuristic = (GISHeuristic)m_Heuristic;
                arr = at.getSchema().getAllAttrUse(ClusAttrType.AttributeUseType.GIS);
                if (arr.length == 1) {
                    gisHeuristic.readMatrixFromFile(sample);
                } else {
                    gisHeuristic.generateMatrix(sample, indicesSorted);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ClusException("Error calculating GISHEuristics!");
        }
    }

    public void findNumericExtraTree(NumericAttrType at, RowData orig_data, ClusRandomNonstatic rnd) throws ClusException {
        DataTuple tuple;
        int pos;
        Random rn;
        if (rnd == null) {
            rn = ClusRandom.getRandom(7);
            ClusEnsembleInduce.giveParallelisationWarning(ClusEnsembleInduce.ParallelTrap.StaticRandom);
        } else {
            rn = rnd.getRandom(0);
        }
        RowData data = this.createSample(orig_data, rnd);
        int idx = at.getArrayIndex();
        Integer[] indicesSorted = data.smartSort(at);
        this.m_BestTest.reset(2);
        int nb_rows = data.getNbRows();
        this.m_BestTest.copyTotal();
        if (at.hasMissing()) {
            for (pos = 0; pos < nb_rows && (tuple = data.getTuple(indicesSorted[pos])).hasNumMissing(idx); ++pos) {
                this.m_BestTest.m_MissingStat.updateWeighted(tuple, indicesSorted[pos]);
            }
            this.m_BestTest.subtractMissing();
        }
        if (pos == nb_rows) {
            this.m_BestTest.m_BestHeur = Double.NEGATIVE_INFINITY;
        } else {
            double min_value = at.getNumeric(data.getTuple(indicesSorted[nb_rows - 1]));
            double max_value = at.getNumeric(data.getTuple(indicesSorted[pos]));
            double split_value = (max_value - min_value) * rn.nextDouble() + min_value;
            for (int i = pos; i < nb_rows && !(at.getNumeric(tuple = data.getTuple(indicesSorted[i])) <= split_value); ++i) {
                this.m_BestTest.m_PosStat.updateWeighted(tuple, indicesSorted[i]);
            }
            this.m_BestTest.updateNumeric(split_value, at);
        }
    }

    public void initSelectorAndSplit(ClusStatistic totstat) throws ClusException {
        this.m_BestTest.create(this.m_StatManager, this.m_MaxStats);
        this.m_BestTest.setRootStatistic(totstat);
        this.m_Split = this.getSettings().getTree().isBinarySplit() ? new SubsetSplit() : new NArySplit();
        this.m_Split.initialize(this.m_StatManager);
    }

    public boolean initSelectorAndStopCrit(ClusStatistic total, RowData data) {
        this.m_BestTest.initTestSelector(total, data);
        this.m_Split.setSDataSize(data.getNbRows());
        return this.m_BestTest.stopCrit();
    }

    public void setInitialData(ClusStatistic total, RowData data) throws ClusException {
        this.m_BestTest.setInitialData(total, data);
    }

    public void resetMinMax() {
        this.hMaxB = Double.NEGATIVE_INFINITY;
        this.hMinB = Double.POSITIVE_INFINITY;
    }

    private RowData createSample(RowData original, ClusRandomNonstatic rnd) {
        int N = this.getSettings().getTree().getTreeSplitSampling();
        if (N == 0) {
            return original.sample(N, rnd);
        }
        String message = String.format("The value of SplitSampling = %d will result in wrong results.\nUse SplitSampling = 0 or correct the code.", N);
        throw new RuntimeException(message);
    }

    public void setParentStatsToChildren() {
        this.m_BestTest.setParentStatsToTests();
    }

    public void setParentStatsToThis(ClusStatistic stat) {
        this.m_BestTest.setParentStatsToTotal(stat);
    }

    private static boolean isFinite(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }
}

