/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.split;

import java.util.ArrayList;
import java.util.HashMap;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.heuristic.GISHeuristic;
import si.ijs.kt.clus.heuristic.VarianceReductionHeuristicCompatibility;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.test.InverseNumericTest;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.model.test.NumericTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;

public class CurrentBestTestAndHeuristic {
    private Settings m_Sett;
    private static int SHOW_TESTS_IN_OUTPUT = 3;
    public static final int TYPE_NONE = -1;
    public static final int TYPE_NUMERIC = 0;
    public static final int TYPE_TEST = 1;
    public static final int TYPE_INVERSE_NUMERIC = 2;
    public ClusStatistic m_TotStat;
    public ClusStatistic m_TotCorrStat;
    public ClusStatistic m_MissingStat;
    public ClusStatistic m_PosStat;
    public ClusStatistic[] m_TestStat;
    public ClusHeuristic m_Heuristic;
    public ClusAttributeWeights m_ClusteringWeights;
    public NodeTest m_BestTest;
    public int m_TestType;
    public double m_BestHeur;
    public double m_UnknownFreq;
    public ClusAttrType m_SplitAttr;
    private ArrayList<NodeTest> m_AlternativeBest = new ArrayList();
    public boolean m_IsAcceptable = true;
    public double m_BestSplit;
    public double m_PosFreq;
    public double m_BestI;
    public double m_BestC;
    public static HashMap<String, Double> mins = new HashMap();
    public static HashMap<String, Double> maxes = new HashMap();
    public double hMinB = Double.POSITIVE_INFINITY;
    public double hMaxB = Double.NEGATIVE_INFINITY;
    public double hMin = Double.POSITIVE_INFINITY;
    public double hMax = Double.NEGATIVE_INFINITY;

    public CurrentBestTestAndHeuristic(Settings sett) {
        this.m_Sett = sett;
    }

    public String toString() {
        return this.m_PosStat.getString2();
    }

    public final boolean hasBestTest() {
        return this.m_IsAcceptable && this.m_TestType != -1;
    }

    public final String getTestString() {
        return this.m_BestTest.getString();
    }

    public final NodeTest updateTest() {
        if (this.m_TestType == 0) {
            this.m_TestType = 1;
            this.m_BestTest = new NumericTest(this.m_SplitAttr.getType(), this.m_BestSplit, this.m_PosFreq);
        } else if (this.m_TestType == 2) {
            this.m_TestType = 1;
            this.m_BestTest = new InverseNumericTest(this.m_SplitAttr.getType(), this.m_BestSplit, this.m_PosFreq);
        }
        if (this.m_BestTest == null) {
            ClusLogger.info("Best test is null");
        }
        this.m_BestTest.preprocess(1);
        this.m_BestTest.setUnknownFreq(this.m_UnknownFreq);
        this.m_BestTest.setHeuristicValue(this.m_BestHeur);
        return this.m_BestTest;
    }

    public void setInitialData(ClusStatistic totstat, RowData data) throws ClusException {
        this.m_Heuristic.setInitialData(totstat, data);
    }

    public final void initTestSelector(ClusStatistic totstat, RowData subset) {
        this.initTestSelector(totstat);
        for (int i = 0; i < this.m_TestStat.length; ++i) {
            this.m_TestStat[i].setSDataSize(subset.getNbRows());
        }
        this.m_Heuristic.setData(subset);
    }

    public final void initTestSelector(ClusStatistic totstat) {
        this.m_TotStat = totstat;
        this.resetBestTest();
    }

    public final void resetBestTest() {
        this.m_BestTest = null;
        this.m_TestType = -1;
        this.m_BestHeur = Double.NEGATIVE_INFINITY;
        this.m_UnknownFreq = 0.0;
        this.m_SplitAttr = null;
        this.m_BestI = Double.NEGATIVE_INFINITY;
        this.m_BestC = Double.POSITIVE_INFINITY;
        this.resetAlternativeBest();
    }

    public final void resetAlternativeBest() {
        this.m_AlternativeBest.clear();
    }

    public final void addAlternativeBest(NodeTest nt) {
        this.m_AlternativeBest.add(nt);
    }

    public final void setBestHeur(double value) {
        this.m_BestHeur = value;
    }

    public final void reset(int nb) {
        this.hMax = Double.NEGATIVE_INFINITY;
        this.hMin = Double.POSITIVE_INFINITY;
        for (int i = 0; i < nb; ++i) {
            this.m_TestStat[i].reset();
        }
        this.m_MissingStat = this.m_TestStat[nb - 1];
    }

    public final void reset() {
        this.m_PosStat.reset();
    }

    public void setParentStatsToTests() {
        for (int i = 0; i < this.m_TestStat.length; ++i) {
            this.m_TestStat[i].setParentStat(this.m_TotStat);
        }
    }

    public void setParentStatsToTotal(ClusStatistic stat) {
        this.m_TotCorrStat.setParentStat(stat);
    }

    public final void create(ClusStatManager smanager, int nbstat) throws ClusException {
        this.m_TotStat = null;
        this.m_Heuristic = smanager.getHeuristic();
        this.m_TestStat = new ClusStatistic[nbstat];
        for (int i = 0; i < nbstat; ++i) {
            this.m_TestStat[i] = smanager.createClusteringStat();
        }
        this.m_ClusteringWeights = smanager.getClusteringWeights();
        this.m_TotCorrStat = smanager.createClusteringStat();
        this.m_PosStat = this.m_TestStat[0];
    }

    public final void setHeuristic(ClusHeuristic heur) {
        this.m_Heuristic = heur;
    }

    public final double getPosWeight() {
        return this.m_PosStat.getTotalWeight();
    }

    public final double getTotWeight() {
        return this.m_TotStat.getTotalWeight();
    }

    public final double getTotNoUnkW() {
        return this.m_TotCorrStat.getTotalWeight();
    }

    public final void subtractMissing() {
        this.m_TotCorrStat.subtractFromThis(this.m_MissingStat);
    }

    public final void copyTotal() {
        this.m_TotCorrStat.copy(this.m_TotStat);
    }

    public final void calcPosFreq() {
        this.m_PosFreq = this.m_PosStat.getTotalWeight() / this.m_TotStat.getTotalWeight();
    }

    public final ClusStatistic getStat(int i) {
        return this.m_TestStat[i];
    }

    public final ClusStatistic getPosStat() {
        return this.m_PosStat;
    }

    public final ClusStatistic getMissStat() {
        return this.m_MissingStat;
    }

    public final ClusStatistic getTotStat() {
        return this.m_TotStat;
    }

    public final ArrayList<NodeTest> getAlternativeBest() {
        return this.m_AlternativeBest;
    }

    public final boolean stopCrit() {
        return false;
    }

    public final void updateNumeric(double val, ClusStatistic pos, ClusAttrType at) throws ClusException {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, pos, this.m_MissingStat);
        if (heur > this.m_BestHeur + 1.0E-6) {
            double tot_w = this.getTotWeight();
            double tot_no_unk = this.getTotNoUnkW();
            this.m_UnknownFreq = (tot_w - tot_no_unk) / tot_w;
            this.m_TestType = 0;
            this.m_PosFreq = pos.getTotalWeight() / tot_no_unk;
            this.m_BestSplit = val;
            this.m_BestHeur = heur;
            this.m_SplitAttr = at;
        }
    }

    public final void calcMinMax(ClusAttrType at, double value) throws ClusException {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat);
        if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
            ClusLogger.info("Heur: " + heur + " nb: " + this.m_PosStat.getTotalWeight());
        }
        if (heur != Double.NEGATIVE_INFINITY) {
            Double currentMax;
            Double currentMin = mins.get(at.getName());
            if (currentMin == null) {
                currentMin = Double.POSITIVE_INFINITY;
            }
            if (heur < currentMin) {
                mins.put(at.getName(), heur);
            }
            if ((currentMax = maxes.get(at.getName())) == null) {
                currentMax = Double.NEGATIVE_INFINITY;
            }
            if (heur > currentMax) {
                maxes.put(at.getName(), heur);
            }
        }
    }

    public final void calculateHMinMax(double val, ClusAttrType at) throws ClusException {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat);
        if (heur == Double.POSITIVE_INFINITY || heur == Double.NEGATIVE_INFINITY) {
            return;
        }
        if (heur > this.hMax) {
            this.hMax = heur;
        }
        if (heur < this.hMin) {
            this.hMin = heur;
        }
    }

    public final void updateNumericGIS(double val, ClusAttrType at, Integer[] permutation) throws Exception {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat);
        if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
            ClusLogger.info("Heur: " + heur + " nb: " + this.m_PosStat.getTotalWeight());
        }
        double I = 0.0;
        double alpha = SettingsTree.ALPHA;
        if (!at.getSettings().getAttribute().isNullGIS()) {
            ClusHeuristic gisHeuristic;
            if (this.m_Heuristic instanceof VarianceReductionHeuristicCompatibility && SettingsTree.ALPHA != 1.0) {
                gisHeuristic = (VarianceReductionHeuristicCompatibility)this.m_Heuristic;
                I = ((VarianceReductionHeuristicCompatibility)gisHeuristic).calcI(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat, permutation);
                if (alpha != 0.0) {
                    heur = 2.0 * (heur - this.hMin) / (this.hMax - this.hMin);
                    heur = alpha * heur + (1.0 - alpha) * I;
                } else {
                    heur = I;
                }
            } else if (this.m_Heuristic instanceof GISHeuristic && SettingsTree.ALPHA != 1.0) {
                gisHeuristic = (GISHeuristic)this.m_Heuristic;
                I = ((GISHeuristic)gisHeuristic).calcI(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat, permutation);
                if (alpha != 0.0) {
                    heur = 2.0 * (heur - this.hMin) / (this.hMax - this.hMin);
                    heur = alpha * heur + (1.0 - alpha) * I;
                } else {
                    heur = I;
                }
            }
        } else {
            throw new RuntimeException("Use the standard updateNumeric!");
        }
        if (heur > this.m_BestHeur + 1.0E-6) {
            if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
                ClusLogger.info("Better.");
            }
            double tot_w = this.getTotWeight();
            double tot_no_unk = this.getTotNoUnkW();
            if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
                ClusLogger.info(" tot_w: " + tot_w + " tot_no_unk: " + tot_no_unk);
            }
            this.m_UnknownFreq = (tot_w - tot_no_unk) / tot_w;
            this.m_TestType = 0;
            this.m_PosFreq = this.getPosWeight() / tot_no_unk;
            this.m_BestSplit = val;
            this.m_BestHeur = heur;
            this.m_SplitAttr = at;
            this.m_BestI = I;
        }
    }

    public final void updateNumeric(double val, ClusAttrType at, double ss_tot, boolean isEfficient) throws ClusException {
        double heur;
        double d = heur = isEfficient ? this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat, ss_tot) : this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat);
        if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
            ClusLogger.info("Heur: " + heur + " nb: " + this.m_PosStat.getTotalWeight());
        }
        if (heur > this.m_BestHeur + 1.0E-6) {
            if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
                ClusLogger.info("Better.");
            }
            double tot_w = this.getTotWeight();
            double tot_no_unk = this.getTotNoUnkW();
            if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
                ClusLogger.info(" tot_w: " + tot_w + " tot_no_unk: " + tot_no_unk);
            }
            this.m_UnknownFreq = (tot_w - tot_no_unk) / tot_w;
            this.m_TestType = 0;
            this.m_PosFreq = this.getPosWeight() / tot_no_unk;
            this.m_BestSplit = val;
            this.m_BestHeur = heur;
            this.m_SplitAttr = at;
        }
    }

    public final void updateNumeric(double val, ClusAttrType at) throws ClusException {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat);
        if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
            ClusLogger.info("Heur: " + heur + " nb: " + this.m_PosStat.getTotalWeight());
        }
        if (heur > this.m_BestHeur + 1.0E-6) {
            if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
                ClusLogger.info("Better.");
            }
            double tot_w = this.getTotWeight();
            double tot_no_unk = this.getTotNoUnkW();
            if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
                ClusLogger.info(" tot_w: " + tot_w + " tot_no_unk: " + tot_no_unk);
            }
            this.m_UnknownFreq = (tot_w - tot_no_unk) / tot_w;
            this.m_TestType = 0;
            this.m_PosFreq = this.getPosWeight() / tot_no_unk;
            this.m_BestSplit = val;
            this.m_BestHeur = heur;
            this.m_SplitAttr = at;
        }
    }

    public final void updateInverseNumeric(double val, ClusAttrType at) throws ClusException {
        double heur = this.m_Heuristic.calcHeuristic(this.m_TotCorrStat, this.m_PosStat, this.m_MissingStat);
        if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
            ClusLogger.info("Heur: " + heur + " nb: " + this.m_PosStat.getTotalWeight());
        }
        if (heur > this.m_BestHeur + 1.0E-6) {
            if (this.m_Sett.getGeneral().getVerbose() >= SHOW_TESTS_IN_OUTPUT) {
                ClusLogger.info("Better.");
            }
            double tot_w = this.getTotWeight();
            double tot_no_unk = this.getTotNoUnkW();
            this.m_UnknownFreq = (tot_w - tot_no_unk) / tot_w;
            this.m_TestType = 2;
            this.m_PosFreq = this.getPosWeight() / tot_no_unk;
            this.m_BestSplit = val;
            this.m_BestHeur = heur;
            this.m_SplitAttr = at;
        }
    }

    public final double calcHeuristic(ClusStatistic stat) throws ClusException {
        return this.m_Heuristic.calcHeuristic(this.m_TotStat, stat, this.m_MissingStat);
    }

    public final double calcHeuristic(ClusStatistic tot, ClusStatistic pos) throws ClusException {
        if (this.m_Sett.getTree().getMissingClusteringAttrHandling().equals((Object)SettingsTree.MissingClusteringAttributeHandlingType.EstimateFromParentNode)) {
            tot.setParentStat(this.m_TotStat.getParentStat());
            pos.setParentStat(this.m_PosStat.getParentStat());
        }
        return this.m_Heuristic.calcHeuristic(tot, pos, this.m_MissingStat);
    }

    public final double calcHeuristic(ClusStatistic tot, ClusStatistic[] set, int arity) {
        return this.m_Heuristic.calcHeuristic(tot, set, arity);
    }

    public final ClusHeuristic getHeuristic() {
        return this.m_Heuristic;
    }

    public final double getHeuristicValue() {
        return this.m_BestHeur;
    }

    public void checkAcceptable(ClusStatistic tot, ClusStatistic pos) {
        this.m_IsAcceptable = this.m_Heuristic.isAcceptable(tot, pos, this.m_MissingStat);
    }

    public final void setRootStatistic(ClusStatistic stat) {
        this.m_Heuristic.setRootStatistic(stat);
        for (int i = 0; i < this.m_TestStat.length; ++i) {
            this.m_TestStat[i].setTrainingStat(stat);
        }
        this.m_TotCorrStat.setTrainingStat(stat);
    }

    public final void statOnData(RowData data) {
        this.setSDataSize(data.getNbRows());
        this.m_Heuristic.setData(data);
    }

    private final void setSDataSize(int nbex) {
        this.m_TotStat.setSDataSize(nbex);
        int nbstat = this.m_TestStat.length;
        for (int i = 0; i < nbstat; ++i) {
            this.m_TestStat[i].setSDataSize(nbex);
        }
    }
}

