/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules.probabilistic;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.util.ClusLogger;

public class ClusRuleHelperMethods {
    static void debug_RemoveExistingData(String folderName) {
        try {
            if (new File(folderName).exists()) {
                for (File ff : new File(folderName).listFiles()) {
                    ff.delete();
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    static void debug_PrintToFile(String data, String folderName, String fileName) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(folderName + "/" + fileName);
        pw.print(data);
        pw.flush();
        pw.close();
    }

    static void debug_PrintInitialRules(ClusRuleSet ruleSet, String folderName, String fileName, boolean removeExistingData) throws FileNotFoundException {
        if (removeExistingData) {
            ClusRuleHelperMethods.debug_RemoveExistingData(folderName);
        }
        ClusRuleHelperMethods.debug_PrintRuleSet(ruleSet, folderName, fileName + "_rules.txt", false, false);
        ClusRuleHelperMethods.debug_PrintRuleSet(ruleSet, folderName, fileName + "_tests.txt", false, true);
    }

    static void debug_PrintRuleSet(ClusRuleSet ruleSet, String folderName, String fileName, boolean printDefaultRule, boolean printTests) {
        try {
            File f = new File(folderName);
            boolean cancel = false;
            if (!f.exists() || f.exists() && !f.isDirectory()) {
                if (f.mkdir()) {
                    ClusLogger.info("Created rules.debug directory.");
                } else {
                    ClusLogger.info("Unable to create rules.debug directory.\nWill not write rule debug info.");
                    cancel = true;
                }
            }
            if (!cancel) {
                PrintWriter pw = new PrintWriter(folderName + "/" + fileName);
                boolean tmp = ruleSet.getSettings().getRules().isPrintAllRules();
                if (printDefaultRule) {
                    ruleSet.getSettings().getRules().setPrintAllRules(true);
                    ruleSet.printModel(pw);
                    ruleSet.getSettings().getRules().setPrintAllRules(tmp);
                } else {
                    for (int i = 0; i < ruleSet.getModelSize(); ++i) {
                        if (printTests) {
                            ruleSet.getRule(i).printModelTests(pw);
                            continue;
                        }
                        ruleSet.getRule(i).printModel(pw);
                        pw.print("\r\n\r\n");
                    }
                }
                pw.flush();
                pw.close();
            }
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
        }
    }

    static HashMap<Integer, ArrayList<Integer>> CalculateCounts(ClusRuleSet rs) {
        HashMap<Integer, ArrayList<Integer>> hm = new HashMap<Integer, ArrayList<Integer>>();
        for (int i = 0; i < rs.getModelSize(); ++i) {
            ArrayList<Integer> indicesOfRulesWithCardinality_i = hm.getOrDefault(rs.getRule(i).getModelSize(), new ArrayList());
            indicesOfRulesWithCardinality_i.add(i);
            hm.put(rs.getRule(i).getModelSize(), indicesOfRulesWithCardinality_i);
        }
        return hm;
    }

    List<ClusRule> generateInitialRuleCombinations(ArrayList<NodeTest> tests, int numberOfTestsPerRule_Max, ClusStatManager manager) {
        ArrayList<ClusRule> generatedRules = new ArrayList<ClusRule>();
        for (int i = 1; i <= numberOfTestsPerRule_Max; ++i) {
            generatedRules.addAll(this.generateCombinations(tests, i, manager));
        }
        return generatedRules;
    }

    List<ClusRule> generateCombinations(ArrayList<NodeTest> tests, int numberOfTestsPerRule, ClusStatManager manager) {
        ArrayList<ClusRule> subsets = new ArrayList<ClusRule>();
        int[] s = new int[numberOfTestsPerRule];
        if (numberOfTestsPerRule <= tests.size()) {
            int i = 0;
            while ((s[i] = i) < numberOfTestsPerRule - 1) {
                ++i;
            }
            subsets.add(this.getSubset(tests, s, manager));
            while (true) {
                for (i = numberOfTestsPerRule - 1; i >= 0 && s[i] == tests.size() - numberOfTestsPerRule + i; --i) {
                }
                if (i < 0) break;
                int n = i++;
                s[n] = s[n] + 1;
                while (i < numberOfTestsPerRule) {
                    s[i] = s[i - 1] + 1;
                    ++i;
                }
                subsets.add(this.getSubset(tests, s, manager));
            }
        }
        return subsets;
    }

    ClusRule getSubset(ArrayList<NodeTest> tests, int[] subset, ClusStatManager manager) {
        ClusRule rule = new ClusRule(manager);
        for (int i = 0; i < subset.length; ++i) {
            rule.addTest(tests.get(subset[i]));
        }
        return rule;
    }
}

