/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import java.io.IOException;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.model.test.SubsetTest;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public class ClusRulesForAttrs {
    double m_SigLevel = 0.05;

    public ClusRuleSet constructRules(ClusRun cr) throws IOException, ClusException, InterruptedException {
        ClusStatManager mgr = cr.getStatManager();
        ClusRuleSet res = new ClusRuleSet(mgr);
        RowData train = (RowData)cr.getTrainingSet();
        RowData valid = (RowData)cr.getPruneSet();
        WHTDStatistic global_valid = (WHTDStatistic)mgr.createStatistic(ClusAttrType.AttributeUseType.Target);
        valid.calcTotalStatBitVector(global_valid);
        global_valid.calcMean();
        ClusSchema schema = train.getSchema();
        NominalAttrType[] descr = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Descriptive);
        for (int i = 0; i < descr.length; ++i) {
            NominalAttrType attr = descr[i];
            for (int j = 0; j < attr.getNbValues(); ++j) {
                boolean[] isin = new boolean[attr.getNbValues()];
                isin[j] = true;
                ClusRule rule = new ClusRule(mgr);
                rule.addTest(new SubsetTest(attr, 1, isin, 0.0));
                WHTDStatistic stat = (WHTDStatistic)mgr.createStatistic(ClusAttrType.AttributeUseType.Target);
                rule.computeCoverStat(train, stat);
                WHTDStatistic valid_stat = (WHTDStatistic)mgr.createStatistic(ClusAttrType.AttributeUseType.Target);
                rule.computeCoverStat(valid, valid_stat);
                valid_stat.calcMean();
                stat.setValidationStat(valid_stat);
                stat.setGlobalStat(global_valid);
                stat.setSigLevel(this.m_SigLevel);
                stat.calcMean();
                if (!stat.isValidPrediction()) continue;
                rule.setTargetStat(stat);
                res.add(rule);
            }
        }
        res.removeEmptyRules();
        res.simplifyRules();
        return res;
    }
}

