/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.ClusRuleLinearTerm;
import si.ijs.kt.clus.algo.rules.RuleNormalization;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.processor.ClusModelProcessor;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.statistic.WHTDStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.cloner.Cloner;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.util.MyArray;
import si.ijs.kt.clus.util.tools.optimization.OptimizationProblem;

public class ClusRuleSet
implements ClusModel,
Serializable {
    public static final long serialVersionUID = 1L;
    protected ClusStatistic m_TargetStat;
    protected boolean m_allCoveringRuleExists = false;
    protected ArrayList<ClusRule> m_Rules = new ArrayList();
    protected ArrayList m_DefaultData = new ArrayList();
    protected ClusStatManager m_StatManager;
    protected boolean m_HasRuleErrors;
    protected String m_Comment;
    protected double m_optWeightBestTValue = 0.0;
    protected double m_optWeightBestFitness = 0.0;
    static final double EQUAL_MAX_DIFFER = 1.0E-6;

    public ClusRuleSet(ClusStatManager statmanager) {
        this.m_StatManager = statmanager;
    }

    public ClusRuleSet cloneRuleSet() {
        ClusRuleSet new_ruleset = new ClusRuleSet(this.m_StatManager);
        for (int i = 0; i < this.getModelSize(); ++i) {
            new_ruleset.add(this.getRule(i));
        }
        return new_ruleset;
    }

    public ClusRuleSet cloneRuleSetNonUnique() {
        ClusRuleSet new_ruleset = new ClusRuleSet(this.m_StatManager);
        new_ruleset.m_Rules = (ArrayList)this.m_Rules.clone();
        return new_ruleset;
    }

    public ClusRuleSet cloneDeep() {
        ClusRuleSet new_ruleset = new ClusRuleSet(this.m_StatManager);
        Cloner c = new Cloner();
        new_ruleset = c.deepClone(this);
        return new_ruleset;
    }

    public ClusRuleSet cloneRuleSetWithThreshold(double threshold) {
        ClusRuleSet new_ruleset = new ClusRuleSet(this.m_StatManager);
        for (int i = 0; i < this.getModelSize(); ++i) {
            ClusRule newRule = this.getRule(i).cloneRule();
            WHTDStatistic stat = (WHTDStatistic)this.getRule(i).getTargetStat();
            WHTDStatistic new_stat = (WHTDStatistic)stat.cloneStat();
            new_stat.copyAll(stat);
            new_stat.setThreshold(threshold);
            new_stat.calcMean();
            newRule.setTargetStat(new_stat);
            new_ruleset.add(newRule);
        }
        return new_ruleset;
    }

    public void add(ClusRule rule) {
        if (this.getSettings().getRules().isWeightedCovering()) {
            if (this.unique(rule)) {
                this.m_Rules.add(rule);
            }
        } else {
            this.m_Rules.add(rule);
        }
    }

    public void remove(ClusRule rule) {
        this.m_Rules.remove(rule);
    }

    public void removeLastRule() {
        this.m_Rules.remove(this.getModelSize() - 1);
    }

    public boolean addIfUnique(ClusRule rule) {
        if (this.unique(rule)) {
            this.m_Rules.add(rule);
            return true;
        }
        return false;
    }

    public boolean unique(ClusRule rule) {
        boolean res = true;
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            if (!this.m_Rules.get(i).equals(rule)) continue;
            res = false;
        }
        return res;
    }

    public boolean addIfUniqueDeeply(ClusRule rule) {
        if (this.uniqueDeeply(rule)) {
            this.m_Rules.add(rule);
            return true;
        }
        return false;
    }

    public boolean uniqueDeeply(ClusRule rule) {
        boolean isUnique = true;
        for (int i = 0; i < this.m_Rules.size() && isUnique; ++i) {
            if (!this.m_Rules.get(i).equalsDeeply(rule)) continue;
            isUnique = false;
        }
        return isUnique;
    }

    public ClusStatistic predictWeightedSLS(DataTuple tuple) throws ClusException {
        ClusRule rule;
        int i;
        boolean covered = false;
        ClusStatistic stat = this.m_TargetStat.cloneSimple();
        double weight_sum = 0.0;
        for (i = 0; i < this.getModelSize(); ++i) {
            rule = this.getRule(i);
            if (!rule.m_CoverageBits.get(tuple.getIndex())) continue;
            weight_sum += this.getAppropriateWeight(rule);
        }
        for (i = 0; i < this.getModelSize(); ++i) {
            rule = this.getRule(i);
            if (!rule.m_CoverageBits.get(tuple.getIndex())) continue;
            ClusStatistic rulestat = rule.predictWeighted(tuple);
            double weight = this.getAppropriateWeight(rule) / weight_sum;
            ClusStatistic norm_rulestat = rulestat.normalizedCopy();
            stat.addPrediction(norm_rulestat, weight);
            covered = true;
        }
        if (covered) {
            stat.computePrediction();
            return stat;
        }
        return this.m_TargetStat;
    }

    @Override
    public ClusStatistic predictWeighted(DataTuple tuple) throws ClusException {
        ClusRule rule;
        int i;
        boolean covered = false;
        SettingsRules.RulePredictionMethod pred_method = this.getSettings().getRules().getRulePredictionMethod();
        if (pred_method.equals((Object)SettingsRules.RulePredictionMethod.DecisionList)) {
            for (int i2 = 0; i2 < this.getModelSize(); ++i2) {
                ClusRule rule2 = this.getRule(i2);
                if (!rule2.covers(tuple)) continue;
                return rule2.getTargetStat();
            }
            return this.m_TargetStat;
        }
        if (pred_method.equals((Object)SettingsRules.RulePredictionMethod.Union)) {
            ClusStatistic stat = this.m_TargetStat.cloneSimple();
            stat.unionInit();
            for (int i3 = 0; i3 < this.getModelSize(); ++i3) {
                ClusRule rule3 = this.getRule(i3);
                if (!rule3.covers(tuple)) continue;
                stat.union(rule3.getTargetStat());
                covered = true;
            }
            stat.unionDone();
            return covered ? stat : this.m_TargetStat;
        }
        if (this.getSettings().getRules().isRulePredictionOptimized()) {
            ClusRule firstRule = this.getRule(0);
            ClusStatistic prediction = firstRule.predictWeighted(tuple).copyNormalizedWeighted(this.getAppropriateWeight(firstRule));
            for (int iBaseRule = 1; iBaseRule < this.getModelSize(); ++iBaseRule) {
                ClusRule rule4 = this.getRule(iBaseRule);
                if (!rule4.covers(tuple)) continue;
                ClusStatistic rulestat = rule4.predictWeighted(tuple);
                ClusStatistic norm_rulestat = rulestat.normalizedCopy();
                prediction.addPrediction(norm_rulestat, this.getAppropriateWeight(rule4));
            }
            return prediction;
        }
        ClusStatistic stat = this.m_TargetStat.cloneSimple();
        double weight_sum = 0.0;
        for (i = 0; i < this.getModelSize(); ++i) {
            rule = this.getRule(i);
            if (!rule.covers(tuple)) continue;
            weight_sum += this.getAppropriateWeight(rule);
        }
        for (i = 0; i < this.getModelSize(); ++i) {
            rule = this.getRule(i);
            if (!rule.covers(tuple)) continue;
            ClusStatistic rulestat = rule.predictWeighted(tuple);
            double weight = this.getAppropriateWeight(rule) / weight_sum;
            ClusStatistic norm_rulestat = rulestat.normalizedCopy();
            stat.addPrediction(norm_rulestat, weight);
            covered = true;
        }
        if (covered) {
            stat.computePrediction();
            return stat;
        }
        return this.m_TargetStat;
    }

    public double getAppropriateWeight(ClusRule rule) {
        switch (this.getSettings().getRules().getRulePredictionMethod()) {
            case CoverageWeighted: {
                return rule.m_TargetStat.getTotalWeight();
            }
            case TotCoverageWeighted: {
                return rule.getCoverage()[0];
            }
            case AccCovWeighted: {
                return rule.m_TargetStat.getTotalWeight() * (1.0 - rule.getTrainErrorScore());
            }
            case AccuracyWeighted: {
                return 1.0 - rule.getTrainErrorScore();
            }
            case Optimized: 
            case GDOptimized: 
            case GDOptimizedBinary: {
                return rule.getOptWeight();
            }
        }
        throw new RuntimeException("si.ijs.kt.clus.algo.rules.ClusRuleSet.getAppropriateWeight(ClusRule): Unknown weighted prediction method!");
    }

    public void removeEmptyRules() {
        for (int i = this.getModelSize() - 1; i >= 0; --i) {
            if (!this.getRule(i).isEmpty()) continue;
            this.m_Rules.remove(i);
        }
    }

    public int removeLowWeightRules() {
        double threshold = this.getSettings().getRules().getOptRuleWeightThreshold();
        boolean binarizeWeights = this.getSettings().getRules().getOptRuleWeightBinarization();
        if (binarizeWeights) {
            System.err.println("Weight binarization will be used.");
        }
        int nb_rules = this.getModelSize();
        ClusRule r = null;
        for (int i = nb_rules - 1; i >= 0; --i) {
            if (i == 0 && this.m_allCoveringRuleExists) continue;
            r = this.getRule(i);
            if (binarizeWeights) {
                if (Math.abs(r.getOptWeight()) > threshold) {
                    r.setOptWeight(1.0);
                    continue;
                }
                this.m_Rules.remove(i);
                continue;
            }
            if (!(Math.abs(this.getRule(i).getOptWeight()) < threshold) && this.getRule(i).getOptWeight() != 0.0) continue;
            this.m_Rules.remove(i);
        }
        ClusLogger.info("Rules left: " + this.getModelSize() + " out of " + nb_rules);
        return nb_rules - 1;
    }

    public void convertToPlainLinearTerms() {
        RegressionStat firstRuleStat = (RegressionStat)this.getRule((int)0).m_TargetStat;
        if (this.getRule(0).getOptWeight() == 0.0) {
            for (int iTarget = 0; iTarget < firstRuleStat.getNbAttributes(); ++iTarget) {
                firstRuleStat.m_Means[iTarget] = 0.0;
            }
            this.getRule(0).setOptWeight(1.0);
        }
        double defaultWeight = this.getRule(0).getOptWeight();
        ClusStatistic tar_stat = this.m_StatManager.getStatistic(ClusAttrType.AttributeUseType.Target);
        double[] addToDefaultPred = new double[tar_stat.getNbAttributes()];
        for (int iRule = 0; iRule < this.getModelSize(); ++iRule) {
            ClusRule cursor = this.getRule(iRule);
            if (cursor.isRegularRule()) continue;
            addToDefaultPred = ((ClusRuleLinearTerm)cursor).convertToPlainTerm(addToDefaultPred, defaultWeight);
        }
        for (int iTarget = 0; iTarget < firstRuleStat.getNbAttributes(); ++iTarget) {
            int n = iTarget;
            firstRuleStat.m_Means[n] = firstRuleStat.m_Means[n] + addToDefaultPred[iTarget];
            firstRuleStat.m_SumValues[iTarget] = firstRuleStat.m_Means[iTarget];
            firstRuleStat.m_SumWeights[iTarget] = 1.0;
        }
    }

    public void simplifyRules() {
        for (int i = this.getModelSize() - 1; i >= 0; --i) {
            this.getRule(i).simplify();
        }
    }

    @Override
    public void attachModel(HashMap table) throws ClusException {
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.m_Rules.get(i);
            rule.attachModel(table);
        }
    }

    @Override
    public void printModel(PrintWriter wrt) {
        this.printModel(wrt, StatisticPrintInfo.getInstance());
    }

    @Override
    public void printModel(PrintWriter wrt, StatisticPrintInfo info) {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        boolean headers = true;
        double[][] avg_dispersion = new double[2][3];
        double[] avg_coverage = new double[2];
        double[][] avg_prod = new double[2][3];
        if (!this.getSettings().getRules().isPrintAllRules()) {
            wrt.println("Set of " + this.m_Rules.size() + " rules." + System.lineSeparator());
        }
        if (this.getSettings().getRules().getRulePredictionMethod().equals((Object)SettingsRules.RulePredictionMethod.GDOptimized) && this.getSettings().getRules().getOptGDNbOfTParameterTry() > 1) {
            wrt.println("Gradient descent optimization: Smallest test fitness of " + fr.format(this.m_optWeightBestFitness) + " with T value: " + fr.format(this.m_optWeightBestTValue) + System.lineSeparator());
        }
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.m_Rules.get(i);
            if (headers) {
                if (this.getSettings().getRules().isPrintAllRules()) {
                    String head = new String("Rule " + (i + 1) + ":");
                    char[] underline = new char[head.length()];
                    for (int j = 0; j < head.length(); ++j) {
                        underline[j] = 61;
                    }
                    wrt.println(head);
                    wrt.println(new String(underline));
                }
                if (this.getSettings().getRules().computeDispersion()) {
                    double[] dArray = avg_dispersion[0];
                    dArray[0] = dArray[0] + rule.m_CombStat[0].dispersionCalc();
                    double[] dArray2 = avg_dispersion[0];
                    dArray2[1] = dArray2[1] + rule.m_CombStat[0].dispersionNum(1);
                    double[] dArray3 = avg_dispersion[0];
                    dArray3[2] = dArray3[2] + rule.m_CombStat[0].dispersionNom(1);
                    avg_coverage[0] = avg_coverage[0] + rule.m_Coverage[0];
                    double[] dArray4 = avg_prod[0];
                    dArray4[0] = dArray4[0] + rule.m_CombStat[0].dispersionCalc() * rule.m_Coverage[0];
                    double[] dArray5 = avg_prod[0];
                    dArray5[1] = dArray5[1] + rule.m_CombStat[0].dispersionNum(1) * rule.m_Coverage[0];
                    double[] dArray6 = avg_prod[0];
                    dArray6[2] = dArray6[2] + rule.m_CombStat[0].dispersionNom(1) * rule.m_Coverage[0];
                    if (rule.m_CombStat[1] != null) {
                        double[] dArray7 = avg_dispersion[1];
                        dArray7[0] = dArray7[0] + rule.m_CombStat[1].dispersionCalc();
                        double[] dArray8 = avg_dispersion[1];
                        dArray8[1] = dArray8[1] + rule.m_CombStat[1].dispersionNum(1);
                        double[] dArray9 = avg_dispersion[1];
                        dArray9[2] = dArray9[2] + rule.m_CombStat[1].dispersionNom(1);
                        avg_coverage[1] = avg_coverage[1] + rule.m_Coverage[1];
                        double[] dArray10 = avg_prod[1];
                        dArray10[0] = dArray10[0] + rule.m_CombStat[1].dispersionCalc() * rule.m_Coverage[1];
                        double[] dArray11 = avg_prod[1];
                        dArray11[1] = dArray11[1] + rule.m_CombStat[1].dispersionNum(1) * rule.m_Coverage[1];
                        double[] dArray12 = avg_prod[1];
                        dArray12[2] = dArray12[2] + rule.m_CombStat[1].dispersionNom(1) * rule.m_Coverage[1];
                    }
                }
            }
            if (!this.getSettings().getRules().isPrintAllRules()) continue;
            rule.printModel(wrt, info);
            wrt.println();
        }
        if (this.m_TargetStat != null && this.m_TargetStat.isValidPrediction()) {
            if (headers) {
                wrt.println("Default rule" + (this.m_Comment == null ? "" : this.m_Comment + ":"));
                wrt.println("=============");
            }
            wrt.println("Default = " + (this.m_TargetStat == null ? "N/A" : this.m_TargetStat.getString()));
        }
        if (headers && this.getSettings().getRules().computeDispersion()) {
            wrt.println(System.lineSeparator() + System.lineSeparator() + "Rule set dispersion:");
            wrt.println("=====================");
            avg_dispersion[0][0] = avg_dispersion[0][0] == 0.0 ? 0.0 : avg_dispersion[0][0] / (double)this.m_Rules.size();
            avg_dispersion[0][1] = avg_dispersion[0][1] == 0.0 ? 0.0 : avg_dispersion[0][1] / (double)this.m_Rules.size();
            avg_dispersion[0][2] = avg_dispersion[0][2] == 0.0 ? 0.0 : avg_dispersion[0][2] / (double)this.m_Rules.size();
            avg_coverage[0] = avg_coverage[0] == 0.0 ? 0.0 : avg_coverage[0] / (double)this.m_Rules.size();
            avg_prod[0][0] = avg_prod[0][0] == 0.0 ? 0.0 : avg_prod[0][0] / (double)this.m_Rules.size();
            avg_prod[0][1] = avg_prod[0][1] == 0.0 ? 0.0 : avg_prod[0][1] / (double)this.m_Rules.size();
            avg_prod[0][2] = avg_prod[0][2] == 0.0 ? 0.0 : avg_prod[0][2] / (double)this.m_Rules.size();
            avg_dispersion[1][0] = avg_dispersion[1][0] == 0.0 ? 0.0 : avg_dispersion[1][0] / (double)this.m_Rules.size();
            avg_dispersion[1][1] = avg_dispersion[1][1] == 0.0 ? 0.0 : avg_dispersion[1][1] / (double)this.m_Rules.size();
            avg_dispersion[1][2] = avg_dispersion[1][2] == 0.0 ? 0.0 : avg_dispersion[1][2] / (double)this.m_Rules.size();
            avg_coverage[1] = avg_coverage[1] == 0.0 ? 0.0 : avg_coverage[1] / (double)this.m_Rules.size();
            avg_prod[1][0] = avg_prod[1][0] == 0.0 ? 0.0 : avg_prod[1][0] / (double)this.m_Rules.size();
            avg_prod[1][1] = avg_prod[1][1] == 0.0 ? 0.0 : avg_prod[1][1] / (double)this.m_Rules.size();
            avg_prod[1][2] = avg_prod[1][2] == 0.0 ? 0.0 : avg_prod[1][2] / (double)this.m_Rules.size();
            wrt.println("   Avg_Dispersion  (train): " + fr.format(avg_dispersion[0][0]) + " = " + fr.format(avg_dispersion[0][1]) + " + " + fr.format(avg_dispersion[0][2]));
            wrt.println("   Avg_Coverage    (train): " + fr.format(avg_coverage[0]));
            wrt.println("   Avg_Cover*Disp  (train): " + fr.format(avg_prod[0][0]) + " = " + fr.format(avg_prod[0][1]) + " + " + fr.format(avg_prod[0][2]));
            wrt.println("   Avg_Dispersion  (test):  " + fr.format(avg_dispersion[1][0]) + " = " + fr.format(avg_dispersion[1][1]) + " + " + fr.format(avg_dispersion[1][2]));
            wrt.println("   Avg_Coverage    (test):  " + fr.format(avg_coverage[1]));
            wrt.println("   Avg_Cover*Disp  (test):  " + fr.format(avg_prod[1][0]) + " = " + fr.format(avg_prod[1][1]) + " + " + fr.format(avg_prod[1][2]));
        }
    }

    public void printModelAndExamples(PrintWriter wrt, StatisticPrintInfo info, ClusSchema schema) {
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.m_Rules.get(i);
            rule.printModel(wrt, info);
            wrt.println();
            wrt.println("Covered examples:");
            ArrayList data = rule.getData();
            ClusAttrType[] attrs = schema.getAllAttrUse(ClusAttrType.AttributeUseType.Target);
            ClusAttrType[] key = schema.getAllAttrUse(ClusAttrType.AttributeUseType.Key);
            for (int k = 0; k < data.size(); ++k) {
                int j;
                DataTuple tuple = (DataTuple)data.get(k);
                wrt.print(String.valueOf(k + 1) + ": ");
                boolean hasval = false;
                for (j = 0; j < key.length; ++j) {
                    if (hasval) {
                        wrt.print(",");
                    }
                    wrt.print(key[j].getString(tuple));
                    hasval = true;
                }
                for (j = 0; j < attrs.length; ++j) {
                    if (hasval) {
                        wrt.print(",");
                    }
                    wrt.print(attrs[j].getString(tuple));
                    hasval = true;
                }
                wrt.println();
            }
            wrt.println();
        }
        wrt.println("Default = " + (this.m_TargetStat == null ? "None" : this.m_TargetStat.getString()));
    }

    @Override
    public void printModelAndExamples(PrintWriter wrt, StatisticPrintInfo info, RowData examples) {
        this.addDataToRules(examples);
        this.printModelAndExamples(wrt, info, examples.getSchema());
        this.removeDataFromRules();
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> indices) {
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> indices, String modelIdentifier) {
    }

    @Override
    public JsonObject getModelJSON() {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info) {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info, RowData examples) {
        return null;
    }

    @Override
    public void printModelToQuery(PrintWriter wrt, ClusRun cr, int starttree, int startitem, boolean ex) {
    }

    @Override
    public int getModelSize() {
        return this.m_Rules.size();
    }

    public Settings getSettings() {
        return this.m_StatManager.getSettings();
    }

    public ClusRule getRule(int i) {
        return this.m_Rules.get(i);
    }

    public ArrayList<ClusRule> getRules() {
        return this.m_Rules;
    }

    public int getNbLiterals() {
        int count = 0;
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.m_Rules.get(i);
            if (!rule.isRegularRule()) continue;
            count += rule.getModelSize();
        }
        return count;
    }

    private int getNbLinearTerms() {
        int count = 0;
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.m_Rules.get(i);
            if (rule.isRegularRule()) continue;
            ++count;
        }
        return count;
    }

    public void setTargetStat(ClusStatistic def) {
        this.m_TargetStat = def;
    }

    public ClusStatistic getTargetStat() {
        return this.m_TargetStat;
    }

    public void postProc() throws ClusException {
        this.m_TargetStat.calcMean();
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.m_Rules.get(i);
            rule.postProc();
        }
    }

    @Override
    public String getModelInfo() {
        return "Rules = " + this.getModelSize() + " (Tests: " + this.getNbLiterals() + " and linear terms: " + this.getNbLinearTerms() + ")";
    }

    public void computeDispersion(int mode) {
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.m_Rules.get(i);
            rule.computeDispersion(mode);
        }
    }

    public double computeErrorScore(RowData data) throws ClusException {
        ClusStatistic tar_stat = this.m_StatManager.getStatistic(ClusAttrType.AttributeUseType.Target);
        if (tar_stat instanceof ClassificationStat) {
            double result = 0.0;
            int nb_rows = data.getNbRows();
            int nb_tar = tar_stat.getNbNominalAttributes();
            int[] nb_right = new int[nb_tar];
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = data.getTuple(i);
                int[] predictions = this.predictWeighted(tuple).getNominalPred();
                NominalAttrType[] targetAttrs = data.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
                for (int j = 0; j < nb_tar; ++j) {
                    int true_value = targetAttrs[j].getNominal(tuple);
                    if (predictions[j] != true_value) continue;
                    int n = j;
                    nb_right[n] = nb_right[n] + 1;
                }
            }
            for (int j = 0; j < nb_tar; ++j) {
                result += (1.0 * (double)nb_rows - (double)nb_right[j]) / (double)nb_rows;
            }
            return result /= (double)nb_tar;
        }
        if (tar_stat instanceof RegressionStat) {
            double result = 0.0;
            int nb_rows = data.getNbRows();
            int nb_tar = tar_stat.getNbNumericAttributes();
            double[] sum_sqr_err = new double[nb_tar];
            NumericAttrType[] targetAttrs = data.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = data.getTuple(i);
                double[] predictions = ((RegressionStat)this.predictWeighted(tuple)).getNumericPred();
                int j = 0;
                while (j < nb_tar) {
                    double diff = predictions[j] - targetAttrs[j].getNumeric(tuple);
                    int n = j++;
                    sum_sqr_err[n] = sum_sqr_err[n] + diff * diff;
                }
            }
            for (int j = 0; j < nb_tar; ++j) {
                result += Math.sqrt(sum_sqr_err[j] / (double)nb_rows);
            }
            return result /= (double)nb_tar;
        }
        return -1.0;
    }

    public void setTrainErrorScore() throws ClusException {
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            this.m_Rules.get(i).setTrainErrorScore();
        }
    }

    public boolean addDataToRules(DataTuple tuple) {
        boolean covered = false;
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.m_Rules.get(i);
            if (!rule.covers(tuple)) continue;
            rule.addDataTuple(tuple);
            covered = true;
        }
        return covered;
    }

    public void addDataToRules(RowData data) {
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            if (this.addDataToRules(tuple)) continue;
            this.m_DefaultData.add(tuple);
        }
    }

    public void removeDataFromRules() {
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            this.m_Rules.get(i).removeDataTuples();
        }
        this.m_DefaultData.clear();
    }

    public ArrayList getDefaultData() {
        return this.m_DefaultData;
    }

    @Override
    public void applyModelProcessors(DataTuple tuple, MyArray mproc) throws IOException, ClusException {
        for (int i = 0; i < this.getModelSize(); ++i) {
            ClusRule rule = this.getRule(i);
            if (!rule.covers(tuple)) continue;
            for (int j = 0; j < mproc.size(); ++j) {
                ClusModelProcessor proc = (ClusModelProcessor)mproc.elementAt(j);
                proc.modelUpdate(tuple, rule);
            }
        }
    }

    public final void applyModelProcessor(DataTuple tuple, ClusModelProcessor proc) throws IOException, ClusException {
        for (int i = 0; i < this.getModelSize(); ++i) {
            ClusRule rule = this.getRule(i);
            if (!rule.covers(tuple)) continue;
            proc.modelUpdate(tuple, rule);
        }
    }

    public void setError(ClusErrorList error, int subset) throws ClusException {
        this.m_HasRuleErrors = true;
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.getRule(i);
            if (error != null) {
                rule.setError(error.getErrorClone(), subset);
                continue;
            }
            rule.setError(null, subset);
        }
    }

    public boolean hasRuleErrors() {
        return this.m_HasRuleErrors;
    }

    @Override
    public int getID() {
        return 0;
    }

    public void numberRules() {
        for (int i = 0; i < this.m_Rules.size(); ++i) {
            ClusRule rule = this.getRule(i);
            rule.setID(i + 1);
        }
    }

    @Override
    public ClusModel prune(int prunetype) {
        return this;
    }

    public void retrieveStatistics(ArrayList list) {
    }

    public OptimizationProblem.OptimizationParameter giveFormForWeightOptimization(PrintWriter outLogFile, RowData data) throws ClusException {
        ClusSchema schema = data.getSchema();
        double[] defaultPred = null;
        defaultPred = this.addDefaultRuleToRuleSet();
        if (this.getSettings().getRules().isOptDefaultShiftPred()) {
            this.shiftRulePredictions(defaultPred);
        }
        if (this.getSettings().getRules().isOptOmitRulePredictions()) {
            this.omitRulePredictions();
        }
        if (this.getSettings().getRules().isOptWeightGenerality()) {
            this.weightGeneralityForPredictions(data.getNbRows());
        }
        if (this.getSettings().getRules().isOptAddLinearTerms()) {
            ClusRuleLinearTerm.initializeClass(data, this.m_StatManager);
            if (this.getSettings().getRules().getOptAddLinearTerms().equals((Object)SettingsRules.OptimizationGDAddLinearTerms.Yes)) {
                this.addLinearTermsToRuleSet();
            }
        }
        ClusStatistic tar_stat = this.m_StatManager.getStatistic(ClusAttrType.AttributeUseType.Target);
        int nb_target = tar_stat.getNbAttributes();
        int nb_baseFunctions = this.getModelSize();
        int nb_rows = data.getNbRows();
        ClusAttrType[] trueValuesTemp = new ClusAttrType[nb_target];
        switch (this.m_StatManager.getTargetMode()) {
            case CLASSIFY: {
                trueValuesTemp = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
                break;
            }
            case REGRESSION: {
                trueValuesTemp = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
                break;
            }
            default: {
                throw new ClusException("si.ijs.kt.clus.algo.rules.ClusRuleSet.giveFormForWeightOptimization(PrintWriter, RowData): not implemented");
            }
        }
        OptimizationProblem.TrueValues[] trueValues = new OptimizationProblem.TrueValues[nb_rows];
        for (int iRows = 0; iRows < nb_rows; ++iRows) {
            DataTuple tuple = data.getTuple(iRows);
            OptimizationProblem.TrueValues newTrueTargets = null;
            newTrueTargets = this.getSettings().getRules().getOptAddLinearTerms().equals((Object)SettingsRules.OptimizationGDAddLinearTerms.YesSaveMemory) ? new OptimizationProblem.TrueValues(nb_target, tuple) : new OptimizationProblem.TrueValues(nb_target, null);
            trueValues[iRows] = newTrueTargets;
            block17: for (int kTargets = 0; kTargets < nb_target; ++kTargets) {
                switch (this.m_StatManager.getTargetMode()) {
                    case CLASSIFY: {
                        trueValues[iRows].m_targets[kTargets] = ((NominalAttrType)trueValuesTemp[kTargets]).getNominal(tuple);
                        continue block17;
                    }
                    case REGRESSION: {
                        trueValues[iRows].m_targets[kTargets] = ((NumericAttrType)trueValuesTemp[kTargets]).getNumeric(tuple);
                        continue block17;
                    }
                    default: {
                        throw new ClusException("si.ijs.kt.clus.algo.rules.ClusRuleSet.giveFormForWeightOptimization(PrintWriter, RowData): not implemented");
                    }
                }
            }
        }
        boolean allRulesScrolled = false;
        int nbOfRegularRules = 0;
        for (int jRules = 0; jRules < nb_baseFunctions; ++jRules) {
            ClusRule rule = this.getRule(jRules);
            if (rule.isRegularRule()) {
                ++nbOfRegularRules;
                if (!allRulesScrolled) continue;
                throw new ClusException("Error: Order of rule set is wrong. Rules have to be before linear terms etc.");
            }
            allRulesScrolled = true;
        }
        int[] nb_values = new int[nb_target];
        block19: for (int iTarget = 0; iTarget < nb_target; ++iTarget) {
            switch (this.m_StatManager.getTargetMode()) {
                case CLASSIFY: {
                    nb_values[iTarget] = ((ClassificationStat)this.m_TargetStat).getAttribute(0).getNbValues();
                    continue block19;
                }
                case REGRESSION: {
                    nb_values[iTarget] = 1;
                    continue block19;
                }
                default: {
                    throw new ClusException("si.ijs.kt.clus.algo.rules.ClusRuleSet.giveFormForWeightOptimization(PrintWriter, RowData): not implemented");
                }
            }
        }
        DecimalFormat mf = new DecimalFormat("#00.000");
        mf.setPositivePrefix("+");
        double[][][][] nonrule_pred = new double[nb_baseFunctions - nbOfRegularRules][nb_rows][nb_target][];
        OptimizationProblem.RulePred[] rule_pred = new OptimizationProblem.RulePred[nbOfRegularRules];
        for (int jRules = 0; jRules < nbOfRegularRules; ++jRules) {
            rule_pred[jRules] = new OptimizationProblem.RulePred(nb_rows, nb_target);
            ClusRule rule = this.getRule(jRules);
            double[] targets = ((RegressionStat)rule.predictWeighted(null)).normalizedCopy().getNumericPred();
            for (int iTarget = 0; iTarget < nb_target; ++iTarget) {
                rule_pred[jRules].m_prediction[iTarget][0] = targets[iTarget];
            }
        }
        if (outLogFile != null) {
            DecimalFormat format6 = new DecimalFormat("000000");
            for (int jRules = 0; jRules < nb_baseFunctions; ++jRules) {
                if (this.getRule(jRules).isRegularRule()) {
                    outLogFile.print("R  " + format6.format(jRules + 1));
                } else {
                    outLogFile.print("L  " + format6.format(jRules + 1));
                }
                for (int iTarget = 1; iTarget < nb_target; ++iTarget) {
                    outLogFile.print("         ");
                }
            }
            outLogFile.println();
        }
        for (int iRows = 0; iRows < nb_rows; ++iRows) {
            DataTuple tuple = data.getTuple(iRows);
            for (int jRules = 0; jRules < nb_baseFunctions; ++jRules) {
                int nonRegIndex;
                block44: {
                    block43: {
                        ClusRule rule = this.getRule(jRules);
                        if (rule.isRegularRule()) {
                            if (rule.covers(tuple)) {
                                rule_pred[jRules].m_cover.set(iRows);
                            }
                            this.printRuleToFile(outLogFile, mf, rule_pred[jRules].m_prediction, rule_pred[jRules].m_cover.get(iRows));
                            continue;
                        }
                        nonRegIndex = jRules - nbOfRegularRules;
                        for (int iTarget = 0; iTarget < nb_target; ++iTarget) {
                            nonrule_pred[nonRegIndex][iRows][iTarget] = new double[nb_values[iTarget]];
                        }
                        if (!rule.covers(tuple)) break block43;
                        switch (this.m_StatManager.getTargetMode()) {
                            case CLASSIFY: {
                                nonrule_pred[nonRegIndex][iRows] = ((ClassificationStat)rule.predictWeighted(tuple)).normalizedCopy().getClassCounts();
                                break block44;
                            }
                            case REGRESSION: {
                                double[] targets = ((RegressionStat)rule.predictWeighted(tuple)).normalizedCopy().getNumericPred();
                                for (int kTargets = 0; kTargets < nb_target; ++kTargets) {
                                    nonrule_pred[nonRegIndex][iRows][kTargets][0] = targets[kTargets];
                                }
                                break block44;
                            }
                            default: {
                                throw new ClusException("si.ijs.kt.clus.algo.rules.ClusRuleSet.giveFormForWeightOptimization(PrintWriter, RowData): not implemented");
                            }
                        }
                    }
                    for (int kTargets = 0; kTargets < nb_target; ++kTargets) {
                        for (int lValues = 0; lValues < nb_values[kTargets]; ++lValues) {
                            nonrule_pred[nonRegIndex][iRows][kTargets][lValues] = Double.NaN;
                        }
                    }
                }
                this.printPredictionsToFile(outLogFile, mf, nonrule_pred[nonRegIndex][iRows]);
            }
            if (outLogFile == null) continue;
            outLogFile.print(" :: [");
            for (int kTargets = 0; kTargets < nb_target; ++kTargets) {
                outLogFile.print(mf.format(trueValues[iRows].m_targets[kTargets]));
                if (kTargets >= nb_target - 1) continue;
                outLogFile.print("; ");
            }
            outLogFile.print("]" + System.lineSeparator());
        }
        if (outLogFile != null) {
            outLogFile.flush();
        }
        OptimizationProblem.OptimizationParameter param = new OptimizationProblem.OptimizationParameter(rule_pred, nonrule_pred, trueValues, ClusRuleLinearTerm.returnImplicitLinearTermsIfNeeded(data));
        return param;
    }

    private void printRuleToFile(PrintWriter outLogFile, DecimalFormat mf, double[][] prediction, boolean covers) {
        if (outLogFile == null) {
            return;
        }
        if (covers) {
            this.printPredictionsToFile(outLogFile, mf, prediction);
        } else {
            double[][] tempPreds = new double[prediction.length][prediction[0].length];
            this.printPredictionsToFile(outLogFile, mf, tempPreds);
        }
    }

    private void printPredictionsToFile(PrintWriter outLogFile, DecimalFormat mf, double[][] targets) {
        if (outLogFile == null) {
            return;
        }
        boolean isClassification = targets[0].length > 1;
        outLogFile.print("[");
        for (int kTargets = 0; kTargets < targets.length; ++kTargets) {
            if (isClassification) {
                outLogFile.print("{");
            }
            for (int lValues = 0; lValues < targets[kTargets].length; ++lValues) {
                outLogFile.print(mf.format(targets[kTargets][lValues]));
                if (lValues >= targets[kTargets].length - 1) continue;
                outLogFile.print("; ");
            }
            if (isClassification) {
                outLogFile.print("}");
            }
            if (kTargets >= targets.length - 1) continue;
            outLogFile.print("; ");
        }
        outLogFile.print("]");
    }

    private void shiftRulePredictions(double[] defaultPred) {
        ClusLogger.info("Shifting rule predictions according to the default prediction.");
        for (int iRule = 1; iRule < this.getModelSize(); ++iRule) {
            ClusRule rule = this.getRule(iRule);
            if (!rule.isRegularRule()) continue;
            if (!(rule.m_TargetStat instanceof RegressionStat)) {
                throw new RuntimeException("Error: GD optimization is implemented regression only.");
            }
            RegressionStat stat = (RegressionStat)rule.m_TargetStat;
            for (int iTarget = 0; iTarget < stat.getNbAttributes(); ++iTarget) {
                int n = iTarget;
                stat.m_Means[n] = stat.m_Means[n] - defaultPred[iTarget];
                stat.m_SumValues[iTarget] = stat.m_Means[iTarget];
                stat.m_SumWeights[iTarget] = 1.0;
            }
        }
    }

    private void omitRulePredictions() {
        ClusLogger.info("Omitting rule predictions for optimization.");
        int iRule = 0;
        if (this.getSettings().getRules().isOptNormalization() && !this.getSettings().getRules().getOptNormalization().equals((Object)SettingsRules.OptimizationNormalization.OnlyScaling)) {
            iRule = 1;
        }
        while (iRule < this.getModelSize()) {
            ClusRule rule = this.getRule(iRule);
            if (rule.isRegularRule()) {
                if (!(rule.m_TargetStat instanceof RegressionStat)) {
                    throw new RuntimeException("Error: GD optimization is implemented regression only.");
                }
                RegressionStat stat = (RegressionStat)rule.m_TargetStat;
                if (stat.getNbAttributes() > 1) {
                    int iTarget;
                    Double scalingValue = null;
                    double chi = 0.0;
                    for (iTarget = 0; iTarget < stat.getNbAttributes(); ++iTarget) {
                        double tmp = stat.m_Means[iTarget] / (2.0 * this.getTargetStdDev(iTarget));
                        if (!(Math.abs(tmp) > Math.abs(chi))) continue;
                        chi = tmp;
                        scalingValue = stat.m_Means[iTarget];
                        if (!this.getSettings().getRules().isOptNormalization()) continue;
                        scalingValue = scalingValue / (2.0 * this.getTargetStdDev(iTarget));
                    }
                    if (scalingValue == null) {
                        scalingValue = 1.0;
                    }
                    for (iTarget = 0; iTarget < stat.getNbAttributes(); ++iTarget) {
                        int n = iTarget;
                        stat.m_Means[n] = stat.m_Means[n] / scalingValue;
                        stat.m_SumValues[iTarget] = stat.m_Means[iTarget];
                        stat.m_SumWeights[iTarget] = 1.0;
                    }
                } else {
                    stat.m_Means[0] = this.getSettings().getRules().isOptNormalization() ? 2.0 * this.getTargetStdDev(0) : 1.0;
                    stat.m_SumValues[0] = stat.m_Means[0];
                    stat.m_SumWeights[0] = 1.0;
                }
            }
            ++iRule;
        }
    }

    private double getTargetStdDev(int iTarg) {
        return RuleNormalization.getTargStdDev(iTarg);
    }

    private void weightGeneralityForPredictions(int nbOfExamples) {
        ClusLogger.info("Scaling the rule predictions for generalization weighting.");
        for (int iRule = 0; iRule < this.getModelSize(); ++iRule) {
            ClusRule rule = this.getRule(iRule);
            if (!rule.isRegularRule()) continue;
            if (!(rule.m_TargetStat instanceof RegressionStat)) {
                throw new RuntimeException("Error: GD optimization is implemented regression only.");
            }
            RegressionStat stat = (RegressionStat)rule.m_TargetStat;
            double scalingFactor = stat.getTotalWeight() / (double)nbOfExamples;
            for (int iTarget = 0; iTarget < stat.getNbAttributes(); ++iTarget) {
                int n = iTarget;
                stat.m_Means[n] = stat.m_Means[n] * scalingFactor;
                stat.m_SumValues[iTarget] = stat.m_Means[iTarget];
                stat.m_SumWeights[iTarget] = 1.0;
            }
        }
    }

    public int addRuleSet(ClusRuleSet newRules) {
        return this.addRuleSet(newRules, true);
    }

    public int addRuleSet(ClusRuleSet newRules, boolean addOnlyUnique) {
        int numberAdded = 0;
        SettingsRules setr = this.getSettings().getRules();
        SettingsEnsemble sete = this.getSettings().getEnsemble();
        boolean deep = sete.isEnsembleROSEnabled() && sete.getEnsembleROSVotingType().equals((Object)SettingsEnsemble.EnsembleROSVotingType.SubspaceAveraging) && setr.isRulePredictionOptimized() && setr.isOptOmitRulePredictions() || !sete.isEnsembleROSEnabled() && (setr.isRulePredictionOptimized() && setr.isOptOmitRulePredictions() || setr.getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.SampledRuleSet));
        for (int iRule = 0; iRule < newRules.getModelSize(); ++iRule) {
            if (addOnlyUnique) {
                if (!deep) {
                    if (!this.addIfUnique(newRules.getRule(iRule))) continue;
                    ++numberAdded;
                    continue;
                }
                if (!this.addIfUniqueDeeply(newRules.getRule(iRule))) continue;
                ++numberAdded;
                continue;
            }
            this.m_Rules.add(newRules.getRule(iRule));
            ++numberAdded;
        }
        return numberAdded;
    }

    public double[] addDefaultRuleToRuleSet() {
        ClusLogger.info("Adding default rule explicitly to rule set.");
        ClusRule defaultRuleForFIREEnsemble = new ClusRule(this.m_StatManager);
        defaultRuleForFIREEnsemble.m_TargetStat = this.m_TargetStat;
        int nbOfTargetAtts = this.m_StatManager.getStatistic(ClusAttrType.AttributeUseType.Target).getNbAttributes();
        double[] newPred = new double[nbOfTargetAtts];
        Arrays.setAll(newPred, idx -> RuleNormalization.getTargMean(idx));
        defaultRuleForFIREEnsemble.setNumericPrediction(newPred);
        this.m_Rules.add(0, defaultRuleForFIREEnsemble);
        this.m_TargetStat = null;
        this.m_allCoveringRuleExists = true;
        return newPred;
    }

    private void addLinearTermsToRuleSet() {
        ClusLogger.info("Adding linear terms as rules.");
        int nbTargets = this.m_StatManager.getStatistic(ClusAttrType.AttributeUseType.Target).getNbAttributes();
        int nbDescrAttr = this.m_StatManager.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive).length;
        for (int iDescriptDim = 0; iDescriptDim < nbDescrAttr; ++iDescriptDim) {
            for (int iTargetDim = 0; iTargetDim < nbTargets; ++iTargetDim) {
                ClusRuleLinearTerm newTerm = new ClusRuleLinearTerm(this.m_StatManager, iDescriptDim, iTargetDim);
                this.m_Rules.add(newTerm);
            }
        }
        ClusLogger.info("Added " + nbDescrAttr + " linear terms for each target, total " + nbDescrAttr * nbTargets + " terms.");
    }

    private void addSingleLinearTerm(int iDescriptDim, int iTargetDim, double weight) {
        ClusRuleLinearTerm newTerm = new ClusRuleLinearTerm(this.m_StatManager, iDescriptDim, iTargetDim);
        newTerm.setOptWeight(weight);
        this.m_Rules.add(newTerm);
    }

    public void addImplicitLinearTermsExplicitly(ArrayList<Double> weights, int indFirstLinTerm) {
        double threshold = this.getSettings().getRules().getOptRuleWeightThreshold();
        int nbOfTargetAtts = this.m_StatManager.getStatistic(ClusAttrType.AttributeUseType.Target).getNbAttributes();
        int addedTerms = 0;
        for (int iLinTerm = indFirstLinTerm; iLinTerm < weights.size(); ++iLinTerm) {
            if (!(Math.abs(weights.get(iLinTerm)) >= threshold) || weights.get(iLinTerm) == 0.0) continue;
            this.addSingleLinearTerm((int)Math.floor((double)(iLinTerm - indFirstLinTerm) / (double)nbOfTargetAtts), (iLinTerm - indFirstLinTerm) % nbOfTargetAtts, weights.get(iLinTerm));
            ++addedTerms;
        }
        ClusLogger.info("Added " + addedTerms + " linear terms explicitly to the set.");
        ClusRuleLinearTerm.DeleteImplicitLinearTerms();
    }

    public int getSupport(DataTuple tuple) {
        int support = 0;
        for (ClusRule rule : this.getRules()) {
            if (!rule.covers(tuple)) continue;
            ++support;
        }
        return support;
    }

    public ArrayList<NodeTest> getRuleSetTests() {
        ArrayList<NodeTest> tests = new ArrayList<NodeTest>();
        for (int i = 0; i < this.getModelSize(); ++i) {
            for (NodeTest t : this.getRule(i).getModelTests()) {
                if (tests.contains(t)) continue;
                tests.add(t);
            }
        }
        return tests;
    }

    public BitSet getUncovered(int numberOfExamples) {
        BitSet covered = new BitSet(numberOfExamples);
        for (int rule = 0; rule < this.getModelSize() && covered.cardinality() < numberOfExamples; ++rule) {
            covered.or(this.getRule((int)rule).m_CoverageBits);
        }
        covered.flip(0, numberOfExamples);
        return covered;
    }

    public void calculateCoverageBitVectors(RowData trainData) {
        for (int i = 0; i < this.getModelSize(); ++i) {
            this.getRule(i).computeCoverageBits(trainData);
        }
    }

    public int correctCoverRuleCount(DataTuple tuple) {
        int correctRuleCount = 0;
        for (ClusRule r : this.getRules()) {
            if (!r.coversCorrect(tuple)) continue;
            ++correctRuleCount;
        }
        return correctRuleCount;
    }

    public int incorrectCoverAcrossAllRules() {
        int count = 0;
        for (ClusRule r : this.getRules()) {
            count += r.coversIncorrect();
        }
        return count;
    }
}

