/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Random;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.rules.FindBestTestRules;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicDispersion;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.selection.BagSelection;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.tools.optimization.OptimizationAlgorithm;
import si.ijs.kt.clus.util.tools.optimization.OptimizationProblem;
import si.ijs.kt.clus.util.tools.optimization.de.DEAlgorithm;
import si.ijs.kt.clus.util.tools.optimization.gd.CallExternGD;
import si.ijs.kt.clus.util.tools.optimization.gd.GDAlgorithm;

public class ClusRuleInduce
extends ClusInductionAlgorithm {
    protected boolean m_BeamChanged;
    protected FindBestTestRules m_FindBestTest = new FindBestTestRules(this.getStatManager());
    protected ClusHeuristic m_Heuristic;

    public ClusRuleInduce(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
    }

    void resetAll() {
        this.m_BeamChanged = false;
    }

    public void setHeuristic(ClusHeuristic heur) {
        this.m_Heuristic = heur;
    }

    public double estimateBeamMeasure(ClusRule rule) throws ClusException {
        return this.m_Heuristic.calcHeuristic(null, rule.getClusteringStat(), null);
    }

    public boolean isBeamChanged() {
        return this.m_BeamChanged;
    }

    public void setBeamChanged(boolean change) {
        this.m_BeamChanged = change;
    }

    ClusBeam initializeBeam(RowData data) throws ClusException {
        Settings sett = this.getSettings();
        ClusBeam beam = new ClusBeam(sett.getBeamSearch().getBeamWidth(), sett.getBeamSearch().getBeamRemoveEqualHeur());
        ClusStatistic stat = this.createTotalClusteringStat(data);
        ClusRule rule = new ClusRule(this.getStatManager());
        rule.setClusteringStat(stat);
        rule.setVisitor(data);
        double value = this.estimateBeamMeasure(rule);
        beam.addModel(new ClusBeamModel(value, rule));
        return beam;
    }

    public void refineModel(ClusBeamModel model, ClusBeam beam, int model_idx) throws ClusException {
        ClusRule rule = (ClusRule)model.getModel();
        RowData data = (RowData)rule.getVisitor();
        if (this.m_FindBestTest.initSelectorAndStopCrit(rule.getClusteringStat(), data)) {
            model.setFinished(true);
            return;
        }
        CurrentBestTestAndHeuristic sel = this.m_FindBestTest.getBestTest();
        ClusAttrType[] attrs = data.getSchema().getDescriptiveAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            double new_heur;
            sel.resetBestTest();
            double beam_min_value = beam.getMinValue();
            sel.setBestHeur(beam_min_value);
            ClusAttrType at = attrs[i];
            if (at instanceof NominalAttrType) {
                this.m_FindBestTest.findNominal((NominalAttrType)at, data);
            } else {
                this.m_FindBestTest.findNumeric((NumericAttrType)at, data);
            }
            if (!sel.hasBestTest()) continue;
            NodeTest test = sel.updateTest();
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("  Test: " + test.getString() + " -> " + sel.m_BestHeur);
            }
            RowData subset = data.apply(test, 0);
            ClusRule ref_rule = rule.cloneRule();
            ref_rule.addTest(test);
            ref_rule.setVisitor(subset);
            ref_rule.setClusteringStat(this.createTotalClusteringStat(subset));
            if (this.getSettings().getRules().isHeurRuleDist()) {
                int[] subset_idx = new int[subset.getNbRows()];
                for (int j = 0; j < subset_idx.length; ++j) {
                    subset_idx[j] = subset.getTuple(j).getIndex();
                }
                ((ClusRuleHeuristicDispersion)this.m_Heuristic).setDataIndexes(subset_idx);
            }
            if (!((new_heur = this.getSettings().getTimeSeries().isTimeSeriesProtoComlexityExact() ? this.sanityCheck(sel.m_BestHeur, ref_rule) : sel.m_BestHeur) > beam_min_value)) continue;
            ClusBeamModel new_model = new ClusBeamModel(new_heur, ref_rule);
            new_model.setParentModelIndex(model_idx);
            beam.addModel(new_model);
            this.setBeamChanged(true);
        }
    }

    public void refineBeam(ClusBeam beam) throws ClusException {
        this.setBeamChanged(false);
        ArrayList models = beam.toArray();
        for (int i = 0; i < models.size(); ++i) {
            ClusBeamModel model = (ClusBeamModel)models.get(i);
            if (model.isRefined() || model.isFinished()) continue;
            this.refineModel(model, beam, i);
            model.setRefined(true);
            model.setParentModelIndex(-1);
        }
    }

    public ClusRule learnOneRule(RowData data) throws ClusException {
        ClusBeam beam = this.initializeBeam(data);
        int i = 0;
        System.out.print("Step: ");
        while (true) {
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Step: " + i);
            } else {
                if (i != 0) {
                    System.out.print(",");
                }
                System.out.print(i);
            }
            System.out.flush();
            this.refineBeam(beam);
            if (!this.isBeamChanged()) break;
            ++i;
        }
        ClusLogger.info();
        double best = beam.getBestModel().getValue();
        double worst = beam.getWorstModel().getValue();
        ClusLogger.info("Worst = " + worst + " Best = " + best);
        ClusRule result = (ClusRule)beam.getBestAndSmallestModel().getModel();
        RowData rule_data = (RowData)result.getVisitor();
        result.setTargetStat(this.createTotalTargetStat(rule_data));
        result.setVisitor(null);
        return result;
    }

    public ClusRule learnEmptyRule(RowData data) {
        ClusRule result = new ClusRule(this.getStatManager());
        return result;
    }

    public ClusRule[] learnBeamOfRules(RowData data) throws ClusException {
        ClusBeam beam = this.initializeBeam(data);
        int i = 0;
        System.out.print("Step: ");
        while (true) {
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Step: " + i);
            } else {
                if (i != 0) {
                    System.out.print(",");
                }
                System.out.print(i);
            }
            System.out.flush();
            this.refineBeam(beam);
            if (!this.isBeamChanged()) break;
            ++i;
        }
        ClusLogger.info();
        double best = beam.getBestModel().getValue();
        double worst = beam.getWorstModel().getValue();
        ClusLogger.info("Worst = " + worst + " Best = " + best);
        ArrayList beam_models = beam.toArray();
        ClusRule[] result = new ClusRule[beam_models.size()];
        for (int j = 0; j < beam_models.size(); ++j) {
            int k = beam_models.size() - j - 1;
            ClusRule rule = (ClusRule)((ClusBeamModel)beam_models.get(k)).getModel();
            RowData rule_data = (RowData)rule.getVisitor();
            rule.setTargetStat(this.createTotalTargetStat(rule_data));
            rule.setVisitor(null);
            rule.simplify();
            result[j] = rule;
        }
        return result;
    }

    public void separateAndConquor(ClusRuleSet rset, RowData data) throws ClusException {
        ClusStatistic left_over;
        ClusRule rule;
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        for (int i = 0; data.getNbRows() > 0 && i < max_rules && !(rule = this.learnOneRule(data)).isEmpty(); ++i) {
            rule.computePrediction();
            rule.printModel();
            ClusLogger.info();
            rset.add(rule);
            data = rule.removeCovered(data);
        }
        if (data.getNbRows() > 0) {
            left_over = this.createTotalTargetStat(data);
            left_over.calcMean();
        } else {
            ClusLogger.info("All training examples covered - default rule on entire training set!");
            rset.m_Comment = new String(" (on entire training set)");
            left_over = this.getStatManager().getTrainSetStat(ClusAttrType.AttributeUseType.Target).cloneStat();
            left_over.copy(this.getStatManager().getTrainSetStat(ClusAttrType.AttributeUseType.Target));
            left_over.calcMean();
            System.err.println(left_over.toString());
        }
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public void separateAndConquorWeighted(ClusRuleSet rset, RowData data) throws ClusException {
        ClusStatistic left_over;
        ClusRule rule;
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        int i = 0;
        RowData data_copy = data.deepCloneData();
        ArrayList<boolean[]> bit_vect_array = new ArrayList<boolean[]>();
        while (data.getNbRows() > 0 && i < max_rules && !(rule = this.learnOneRule(data)).isEmpty()) {
            rule.computePrediction();
            if (this.getSettings().getRules().isPrintAllRules()) {
                rule.printModel();
            }
            ClusLogger.info();
            rset.add(rule);
            data = rule.reweighCovered(data);
            ++i;
            if (!this.getSettings().getRules().isHeurRuleDist()) continue;
            boolean[] bit_vect = new boolean[data_copy.getNbRows()];
            block1: for (int j = 0; j < bit_vect.length; ++j) {
                if (bit_vect[j]) continue;
                for (int k = 0; k < rset.getModelSize(); ++k) {
                    if (!rset.getRule(k).covers(data_copy.getTuple(j))) continue;
                    bit_vect[j] = true;
                    continue block1;
                }
            }
            bit_vect_array.add(bit_vect);
            ((ClusRuleHeuristicDispersion)this.m_Heuristic).setCoveredBitVectArray(bit_vect_array);
        }
        if (data.getNbRows() > 0) {
            left_over = this.createTotalTargetStat(data);
            left_over.calcMean();
        } else {
            ClusLogger.info("All training examples covered - default rule on entire training set!");
            rset.m_Comment = new String(" (on entire training set)");
            left_over = this.getStatManager().getTrainSetStat(ClusAttrType.AttributeUseType.Target).cloneStat();
            left_over.copy(this.getStatManager().getTrainSetStat(ClusAttrType.AttributeUseType.Target));
            left_over.calcMean();
            System.err.println(left_over.toString());
        }
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public void separateAndConquorAddRulesIfBetter(ClusRuleSet rset, RowData data) throws ClusException {
        ClusRule rule;
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        int i = 0;
        RowData data_copy = data.deepCloneData();
        ArrayList<boolean[]> bit_vect_array = new ArrayList<boolean[]>();
        ClusStatistic left_over = this.createTotalTargetStat(data_copy);
        left_over.calcMean();
        ClusStatistic new_left_over = left_over;
        rset.setTargetStat(left_over);
        double err_score = rset.computeErrorScore(data_copy);
        while (data.getNbRows() > 0 && i < max_rules && !(rule = this.learnOneRule(data)).isEmpty()) {
            rule.computePrediction();
            ClusRuleSet new_rset = rset.cloneRuleSet();
            new_rset.add(rule);
            data = rule.reweighCovered(data);
            left_over = new_left_over;
            new_left_over = this.createTotalTargetStat(data);
            new_left_over.calcMean();
            new_rset.setTargetStat(new_left_over);
            double new_err_score = new_rset.computeErrorScore(data_copy);
            if (!(err_score - new_err_score > 1.0E-6)) break;
            ++i;
            rule.printModel();
            ClusLogger.info();
            err_score = new_err_score;
            rset.add(rule);
            if (!this.getSettings().getRules().isHeurRuleDist()) continue;
            boolean[] bit_vect = new boolean[data_copy.getNbRows()];
            block1: for (int j = 0; j < bit_vect.length; ++j) {
                if (bit_vect[j]) continue;
                for (int k = 0; k < rset.getModelSize(); ++k) {
                    if (!rset.getRule(k).covers(data_copy.getTuple(j))) continue;
                    bit_vect[j] = true;
                    continue block1;
                }
            }
            bit_vect_array.add(bit_vect);
            ((ClusRuleHeuristicDispersion)this.m_Heuristic).setCoveredBitVectArray(bit_vect_array);
        }
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public void separateAndConquorAddRulesIfBetterFromBeam(ClusRuleSet rset, RowData data) throws ClusException {
        ClusStatistic left_over;
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        int i = 0;
        RowData data_copy = data.deepCloneData();
        ArrayList<boolean[]> bit_vect_array = new ArrayList<boolean[]>();
        ClusStatistic new_left_over = left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        rset.setTargetStat(left_over);
        int nb_tar = left_over.getNbAttributes();
        boolean cls_task = false;
        if (left_over instanceof ClassificationStat) {
            cls_task = true;
        }
        int[] def_maj_class = new int[nb_tar];
        if (cls_task) {
            for (int t = 0; t < nb_tar; ++t) {
                def_maj_class[t] = left_over.getNominalPred()[t];
            }
        }
        double err_score = rset.computeErrorScore(data);
        while (data_copy.getNbRows() > 0 && i < max_rules) {
            ClusRule[] rules = this.learnBeamOfRules(data_copy);
            left_over = new_left_over;
            int rule_added = -1;
            for (int j = 0; j < rules.length; ++j) {
                if (rules[j].isEmpty()) continue;
                rules[j].computePrediction();
                ClusRuleSet new_rset = rset.cloneRuleSet();
                new_rset.add(rules[j]);
                RowData data_copy2 = data_copy.deepCloneData();
                data_copy2 = rules[j].reweighCovered(data_copy2);
                ClusStatistic new_left_over2 = this.createTotalTargetStat(data_copy2);
                new_left_over2.calcMean();
                new_rset.setTargetStat(new_left_over2);
                double new_err_score = new_rset.computeErrorScore(data);
                boolean add_anyway = false;
                if (cls_task) {
                    for (int t = 0; t < nb_tar; ++t) {
                        if (def_maj_class[t] != rules[j].getTargetStat().getNominalPred()[t]) continue;
                        add_anyway = true;
                    }
                }
                if (!(err_score - new_err_score > 1.0E-6) && !add_anyway) continue;
                err_score = new_err_score;
                rule_added = j;
                data_copy = data_copy2;
                new_left_over = new_left_over2;
            }
            if (rule_added == -1) break;
            ++i;
            rules[rule_added].printModel();
            ClusLogger.info();
            rset.add(rules[rule_added]);
            if (!this.getSettings().getRules().isHeurRuleDist()) continue;
            boolean[] bit_vect = new boolean[data.getNbRows()];
            block4: for (int j = 0; j < bit_vect.length; ++j) {
                if (bit_vect[j]) continue;
                for (int k = 0; k < rset.getModelSize(); ++k) {
                    if (!rset.getRule(k).covers(data.getTuple(j))) continue;
                    bit_vect[j] = true;
                    continue block4;
                }
            }
            bit_vect_array.add(bit_vect);
            ((ClusRuleHeuristicDispersion)this.m_Heuristic).setCoveredBitVectArray(bit_vect_array);
        }
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public void separateAndConquorBootstraped(ClusRuleSet rset, RowData data) throws ClusException {
        int nb_sets = 10;
        int nb_rows = data.getNbRows();
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        max_rules /= nb_sets;
        RowData data_not_covered = (RowData)data.cloneData();
        for (int z = 0; z < nb_sets; ++z) {
            ClusRule rule;
            RowData data_sel = (RowData)data.cloneData();
            BagSelection msel = new BagSelection(nb_rows, this.getSettings().getEnsemble().getEnsembleBagSize(), null);
            data_sel.update(msel);
            if (this.getSettings().getRules().isHeurRuleDist()) {
                int[] data_idx = new int[data_sel.getNbRows()];
                for (int j = 0; j < data_sel.getNbRows(); ++j) {
                    data_sel.getTuple(j).setIndex(j);
                    data_idx[j] = j;
                }
                ((ClusRuleHeuristicDispersion)this.m_Heuristic).setDataIndexes(data_idx);
                ((ClusRuleHeuristicDispersion)this.m_Heuristic).initCoveredBitVectArray(data_sel.getNbRows());
            }
            int i = 0;
            RowData data_sel_copy = (RowData)data_sel.cloneData();
            ArrayList<boolean[]> bit_vect_array = new ArrayList<boolean[]>();
            while (data_sel.getNbRows() > 0 && i < max_rules && !(rule = this.learnOneRule(data_sel)).isEmpty()) {
                rule.computePrediction();
                rule.printModel();
                ClusLogger.info();
                rset.addIfUnique(rule);
                data_sel = rule.removeCovered(data_sel);
                data_not_covered = rule.removeCovered(data_not_covered);
                ++i;
                if (!this.getSettings().getRules().isHeurRuleDist()) continue;
                boolean[] bit_vect = new boolean[data_sel_copy.getNbRows()];
                block3: for (int j = 0; j < bit_vect.length; ++j) {
                    if (bit_vect[j]) continue;
                    for (int k = 0; k < rset.getModelSize(); ++k) {
                        if (!rset.getRule(k).covers(data_sel_copy.getTuple(j))) continue;
                        bit_vect[j] = true;
                        continue block3;
                    }
                }
                bit_vect_array.add(bit_vect);
                ((ClusRuleHeuristicDispersion)this.m_Heuristic).setCoveredBitVectArray(bit_vect_array);
            }
        }
        ClusStatistic left_over = this.createTotalTargetStat(data_not_covered);
        left_over.calcMean();
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public void separateAndConquorRandomly(ClusRuleSet rset, RowData data) throws ClusException {
        ClusStatistic left_over;
        int nb_rules = 100;
        int max_def_rules = 10;
        ClusRule[] rules = new ClusRule[nb_rules];
        Random rn = new Random(42L);
        for (int k = 0; k < nb_rules; ++k) {
            ClusRule rule = this.generateOneRandomRule(data, rn);
            rule.computePrediction();
            rules[k] = rule;
        }
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        int i = 0;
        RowData data_copy = data.deepCloneData();
        ClusStatistic new_left_over = left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        rset.setTargetStat(left_over);
        int nb_tar = left_over.getNbAttributes();
        boolean cls_task = false;
        if (left_over instanceof ClassificationStat) {
            cls_task = true;
        }
        int[] def_maj_class = new int[nb_tar];
        if (cls_task) {
            for (int t = 0; t < nb_tar; ++t) {
                def_maj_class[t] = left_over.getNominalPred()[t];
            }
        }
        double err_score = rset.computeErrorScore(data);
        int nb_def_rules = 0;
        boolean add_anyway = false;
        while (i < max_rules) {
            left_over = new_left_over;
            int rule_added = -1;
            for (int j = 0; j < rules.length; ++j) {
                double err_d;
                if (rules[j] == null || rules[j].isEmpty()) continue;
                rules[j].computePrediction();
                ClusRuleSet new_rset = rset.cloneRuleSet();
                new_rset.add(rules[j]);
                RowData data_copy2 = data_copy.deepCloneData();
                data_copy2 = rules[j].reweighCovered(data_copy2);
                ClusStatistic new_left_over2 = this.createTotalTargetStat(data_copy2);
                new_left_over2.calcMean();
                new_rset.setTargetStat(new_left_over2);
                double new_err_score = new_rset.computeErrorScore(data);
                add_anyway = false;
                if (cls_task) {
                    for (int t = 0; t < nb_tar; ++t) {
                        if (def_maj_class[t] != rules[j].getTargetStat().getNominalPred()[t]) continue;
                        add_anyway = true;
                    }
                }
                if (!((err_d = err_score - new_err_score) > 1.0E-6) && nb_def_rules >= max_def_rules) continue;
                if (add_anyway) {
                    ++nb_def_rules;
                }
                err_score = new_err_score;
                rule_added = j;
                data_copy = data_copy2;
                new_left_over = new_left_over2;
            }
            if (rule_added == -1) break;
            ++i;
            rules[rule_added].printModel();
            ClusLogger.info();
            rset.addIfUnique(rules[rule_added]);
            rules[rule_added] = null;
        }
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public void separateAndConquorAddRulesIfBetterFromBeam2(ClusRuleSet rset, RowData data) throws ClusException {
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        RowData data_copy = data.deepCloneData();
        ClusStatistic left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        rset.setTargetStat(left_over);
        ClusRule empty_rule = this.learnEmptyRule(data_copy);
        empty_rule.setTargetStat(left_over);
        data_copy = empty_rule.reweighCovered(data_copy);
        double err_score = rset.computeErrorScore(data);
        for (int i = 0; data.getNbRows() > 0 && i < max_rules; ++i) {
            ClusRule[] rules = this.learnBeamOfRules(data_copy);
            int rule_added = -1;
            for (int j = 0; j < rules.length; ++j) {
                if (rules[j].isEmpty()) continue;
                rules[j].computePrediction();
                ClusRuleSet new_rset = rset.cloneRuleSet();
                new_rset.add(rules[j]);
                RowData data_copy2 = data_copy.deepCloneData();
                data_copy2 = rules[j].reweighCovered(data_copy2);
                new_rset.setTargetStat(left_over);
                double new_err_score = new_rset.computeErrorScore(data);
                if (!(err_score - new_err_score > 1.0E-6)) continue;
                err_score = new_err_score;
                rule_added = j;
                data_copy = data_copy2;
            }
            if (rule_added == -1) break;
            rules[rule_added].printModel();
            ClusLogger.info();
            rset.add(rules[rule_added]);
        }
        ClusLogger.info("Left Over: " + left_over);
    }

    public void separateAndConquorWithHeuristic(ClusRuleSet rset, RowData data) throws ClusException {
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        ArrayList<boolean[]> bit_vect_array = new ArrayList<boolean[]>();
        int i = 0;
        while (i < max_rules) {
            ClusRule[] rules = this.learnBeamOfRules(data);
            ClusRule rule = rules[0];
            for (int l = 0; l < rules.length - 1 && !rset.unique(rule = rules[l + 1]); ++l) {
            }
            if (rule.isEmpty() || !rset.unique(rule)) break;
            rule.computePrediction();
            rule.printModel();
            ClusLogger.info();
            rset.add(rule);
            ++i;
            boolean[] bit_vect = new boolean[data.getNbRows()];
            block2: for (int j = 0; j < bit_vect.length; ++j) {
                if (bit_vect[j]) continue;
                for (int k = 0; k < rset.getModelSize(); ++k) {
                    if (!rset.getRule(k).covers(data.getTuple(j))) continue;
                    bit_vect[j] = true;
                    continue block2;
                }
            }
            bit_vect_array.add(bit_vect);
            ((ClusRuleHeuristicDispersion)this.m_Heuristic).setCoveredBitVectArray(bit_vect_array);
        }
        this.updateDefaultRule(rset, data);
    }

    public double sanityCheck(double value, ClusRule rule) throws ClusException {
        double expected = this.estimateBeamMeasure(rule);
        if (Math.abs(value - expected) > 1.0E-6) {
            ClusLogger.info("Bug in heurisitc: " + value + " <> " + expected);
            PrintWriter wrt = new PrintWriter(System.out);
            rule.printModel(wrt);
            wrt.close();
            System.out.flush();
            throw new ClusException("sanity check failed");
        }
        return expected;
    }

    public ClusModel induce(ClusRun run) throws ClusException, IOException, InterruptedException {
        SettingsRules.CoveringMethod method = this.getSettings().getRules().getCoveringMethod();
        SettingsRules.RuleAddingMethod add_method = this.getSettings().getRules().getRuleAddingMethod();
        RowData data = (RowData)run.getTrainingSet();
        ClusStatistic stat = this.createTotalClusteringStat(data);
        this.m_FindBestTest.initSelectorAndSplit(stat);
        this.setHeuristic(this.m_FindBestTest.getBestTest().getHeuristic());
        if (this.getSettings().getRules().isHeurRuleDist()) {
            int[] data_idx = new int[data.getNbRows()];
            for (int i = 0; i < data.getNbRows(); ++i) {
                data.getTuple(i).setIndex(i);
                data_idx[i] = i;
            }
            ((ClusRuleHeuristicDispersion)this.m_Heuristic).setDataIndexes(data_idx);
            ((ClusRuleHeuristicDispersion)this.m_Heuristic).initCoveredBitVectArray(data.getNbRows());
        }
        ClusRuleSet rset = new ClusRuleSet(this.getStatManager());
        if (method.equals((Object)SettingsRules.CoveringMethod.Standard)) {
            this.separateAndConquor(rset, data);
        } else if (method.equals((Object)SettingsRules.CoveringMethod.BeamRuleDefSet)) {
            this.separateAndConquorAddRulesIfBetterFromBeam2(rset, data);
        } else if (method.equals((Object)SettingsRules.CoveringMethod.RandomRuleSet)) {
            this.separateAndConquorRandomly(rset, data);
        } else if (method.equals((Object)SettingsRules.CoveringMethod.StandardBootstrap)) {
            this.separateAndConquorBootstraped(rset, data);
        } else if (method.equals((Object)SettingsRules.CoveringMethod.HeurOnly)) {
            this.separateAndConquorWithHeuristic(rset, data);
        } else if (add_method.equals((Object)SettingsRules.RuleAddingMethod.IfBetter)) {
            this.separateAndConquorAddRulesIfBetter(rset, data);
        } else if (add_method.equals((Object)SettingsRules.RuleAddingMethod.IfBetterBeam)) {
            this.separateAndConquorAddRulesIfBetterFromBeam(rset, data);
        } else {
            this.separateAndConquorWeighted(rset, data);
        }
        rset.postProc();
        if (this.getSettings().getRules().isRulePredictionOptimized()) {
            rset = this.optimizeRuleSet(rset, data);
        }
        rset.setTrainErrorScore();
        rset.addDataToRules(data);
        if (this.getSettings().getRules().computeDispersion()) {
            rset.computeDispersion(0);
            rset.removeDataFromRules();
            if (run.getTestIter() != null) {
                RowData testdata = run.getTestSet();
                rset.addDataToRules(testdata);
                rset.computeDispersion(1);
                rset.removeDataFromRules();
            }
        }
        rset.numberRules();
        return rset;
    }

    public ClusRuleSet optimizeRuleSet(ClusRuleSet rset, RowData data) throws ClusException, IOException {
        PrintWriter wrt_pred = null;
        OptimizationAlgorithm optAlg = null;
        OptimizationProblem.OptimizationParameter param = rset.giveFormForWeightOptimization(wrt_pred, data);
        ArrayList<Double> weights = null;
        ClusLogger.info("Preparing for optimization.");
        switch (this.getSettings().getRules().getRulePredictionMethod()) {
            case GDOptimized: {
                optAlg = new GDAlgorithm(this.getStatManager(), param, rset);
                break;
            }
            case Optimized: {
                optAlg = new DEAlgorithm(this.getStatManager(), param, rset);
                break;
            }
            case GDOptimizedBinary: {
                weights = CallExternGD.main(this.getStatManager(), param, rset);
                break;
            }
        }
        if (!this.getSettings().getRules().getRulePredictionMethod().equals((Object)SettingsRules.RulePredictionMethod.GDOptimizedBinary)) {
            ClusLogger.info("Preparations ended. Starting optimization.");
            if (this.getSettings().getRules().getRulePredictionMethod().equals((Object)SettingsRules.RulePredictionMethod.GDOptimized) && this.getSettings().getRules().getOptGDNbOfTParameterTry() > 1) {
                GDAlgorithm gdalg = (GDAlgorithm)optAlg;
                double firstTVal = 1.0;
                double lastTVal = this.getSettings().getRules().getOptGDGradTreshold();
                double interTVal = (lastTVal - firstTVal) / (double)(this.getSettings().getRules().getOptGDNbOfTParameterTry() - 1);
                double minFitness = Double.POSITIVE_INFINITY;
                for (int tau = 0; tau < this.getSettings().getRules().getOptGDNbOfTParameterTry(); ++tau) {
                    if (tau == this.getSettings().getRules().getOptGDNbOfTParameterTry() - 1) {
                        this.getSettings().getRules().setOptGDGradTreshold(lastTVal);
                    } else {
                        this.getSettings().getRules().setOptGDGradTreshold(firstTVal + (double)tau * interTVal);
                    }
                    gdalg.initGDForNewRunWithSamePredictions();
                    ArrayList<Double> newWeights = gdalg.optimize();
                    String s = "The T value " + (firstTVal + (double)tau * interTVal) + " has a test fitness: " + gdalg.getBestFitness();
                    if (gdalg.getBestFitness() < minFitness) {
                        weights = newWeights;
                        minFitness = gdalg.getBestFitness();
                        rset.m_optWeightBestTValue = firstTVal + (double)tau * interTVal;
                        rset.m_optWeightBestFitness = minFitness;
                        ClusLogger.finer(s + " - best so far!");
                        continue;
                    }
                    if (!this.getSettings().getRules().getOptGDEarlyTTryStop() || !(gdalg.getBestFitness() > this.getSettings().getRules().getOptGDEarlyStopTreshold() * minFitness)) continue;
                    ClusLogger.finer(s + " - early T value stop reached.");
                    break;
                }
                this.getSettings().getRules().setOptGDGradTreshold(lastTVal);
            } else {
                weights = optAlg.optimize();
            }
        }
        for (int j = 0; j < rset.getModelSize(); ++j) {
            rset.getRule(j).setOptWeight(weights.get(j));
        }
        if (!this.getSettings().getRules().getRulePredictionMethod().equals((Object)SettingsRules.RulePredictionMethod.GDOptimizedBinary)) {
            optAlg.postProcess(rset);
        }
        StringBuffer buf = new StringBuffer();
        int cnt = 0;
        for (int j = 0; j < weights.size(); ++j) {
            if (!(weights.get(j) > 0.0)) continue;
            buf.append(weights.get(j) + ", ");
            ++cnt;
        }
        buf.insert(0, String.format("The weights for rules (%d rules): ", cnt));
        ClusLogger.info(buf.toString());
        int indexOfLastHandledWeight = rset.removeLowWeightRules() + 1;
        if (this.getSettings().getRules().getOptAddLinearTerms().equals((Object)SettingsRules.OptimizationGDAddLinearTerms.YesSaveMemory)) {
            rset.addImplicitLinearTermsExplicitly(weights, indexOfLastHandledWeight);
        }
        if (this.getSettings().getRules().isOptAddLinearTerms() && this.getSettings().getRules().getOptNormalizeLinearTerms().equals((Object)SettingsRules.OptimizationLinearTermNormalizeValues.YesAndConvert)) {
            rset.convertToPlainLinearTerms();
        }
        RowData data_copy = (RowData)data.cloneData();
        this.updateDefaultRule(rset, data_copy);
        return rset;
    }

    public void updateDefaultRule(ClusRuleSet rset, RowData data) throws ClusException {
        for (int i = 0; i < rset.getModelSize(); ++i) {
            data = rset.getRule(i).removeCovered(data);
        }
        ClusStatistic left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public ClusModel induceRandomly(ClusRun run) throws ClusException, IOException, InterruptedException {
        int number = this.getSettings().getRules().nbRandomRules();
        RowData data = (RowData)run.getTrainingSet();
        ClusStatistic stat = this.createTotalClusteringStat(data);
        this.m_FindBestTest.initSelectorAndSplit(stat);
        this.setHeuristic(this.m_FindBestTest.getBestTest().getHeuristic());
        ClusRuleSet rset = new ClusRuleSet(this.getStatManager());
        Random rn = new Random(42L);
        for (int i = 0; i < number; ++i) {
            ClusRule rule = this.generateOneRandomRule(data, rn);
            rule.computePrediction();
            rule.printModel();
            ClusLogger.info();
            if (rset.addIfUnique(rule)) continue;
            --i;
        }
        if (this.getSettings().getRules().isRulePredictionOptimized()) {
            rset = this.optimizeRuleSet(rset, data);
        }
        ClusStatistic left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
        rset.postProc();
        rset.setTrainErrorScore();
        if (this.getSettings().getRules().computeDispersion()) {
            rset.addDataToRules(data);
            rset.computeDispersion(0);
            rset.removeDataFromRules();
            if (run.getTestIter() != null) {
                RowData testdata = run.getTestSet();
                rset.addDataToRules(testdata);
                rset.computeDispersion(1);
                rset.removeDataFromRules();
            }
        }
        return rset;
    }

    private ClusRule generateOneRandomRule(RowData data, Random rn) throws ClusException {
        ClusStatManager mgr = this.getStatManager();
        ClusRule result = new ClusRule(mgr);
        ClusAttrType[] attrs = data.getSchema().getDescriptiveAttributes();
        RowData orig_data = data;
        int nb_tests = attrs.length > 1 ? rn.nextInt(attrs.length - 1) + 1 : 1;
        int[] test_atts = new int[nb_tests];
        for (int i = 0; i < nb_tests; ++i) {
            int att_idx;
            boolean unique;
            do {
                att_idx = rn.nextInt(attrs.length);
                unique = true;
                for (int j = 0; j < i; ++j) {
                    if (att_idx != test_atts[j]) continue;
                    unique = false;
                }
            } while (!unique);
            test_atts[i] = att_idx;
        }
        CurrentBestTestAndHeuristic sel = this.m_FindBestTest.getBestTest();
        for (int i = 0; i < test_atts.length; ++i) {
            result.setClusteringStat(this.createTotalClusteringStat(data));
            if (this.m_FindBestTest.initSelectorAndStopCrit(result.getClusteringStat(), data)) break;
            sel.resetBestTest();
            sel.setBestHeur(Double.NEGATIVE_INFINITY);
            ClusAttrType at = attrs[test_atts[i]];
            if (at instanceof NominalAttrType) {
                this.m_FindBestTest.findNominalRandom((NominalAttrType)at, data, rn);
            } else {
                this.m_FindBestTest.findNumericRandom((NumericAttrType)at, data, orig_data, rn);
            }
            if (!sel.hasBestTest()) continue;
            NodeTest test = sel.updateTest();
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("  Test: " + test.getString() + " -> " + sel.m_BestHeur);
            }
            result.addTest(test);
            data = data.apply(test, 0);
        }
        result.setTargetStat(this.createTotalTargetStat(data));
        result.setClusteringStat(this.createTotalClusteringStat(data));
        return result;
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws ClusException, IOException, InterruptedException, Exception {
        this.resetAll();
        if (!this.getSettings().getRules().isRandomRules()) {
            return this.induce(cr);
        }
        return this.induceRandomly(cr);
    }

    @Override
    public void induceAll(ClusRun cr) throws Exception {
        RowData trainData = (RowData)cr.getTrainingSet();
        this.getStatManager().getHeuristic().setTrainData(trainData);
        ClusStatistic trainStat = this.getStatManager().getTrainSetStat(ClusAttrType.AttributeUseType.Clustering);
        double value = trainStat.getDispersion(this.getStatManager().getClusteringWeights(), trainData);
        this.getStatManager().getHeuristic().setTrainDataHeurValue(value);
        ClusModel model = this.induceSingleUnpruned(cr);
        ClusModelInfo pruned_model = cr.addModelInfo(1);
        pruned_model.setModel(model);
        pruned_model.setName("Original");
    }
}

