/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.rules.ClusRule;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.rules.FindBestTestRules;
import si.ijs.kt.clus.algo.split.CurrentBestTestAndHeuristic;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.attweights.ClusNormalizedAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.MemoryTupleIterator;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.beamsearch.ClusBeam;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamModel;
import si.ijs.kt.clus.ext.ilevelc.ILevelCStatistic;
import si.ijs.kt.clus.ext.ilevelc.ILevelConstraint;
import si.ijs.kt.clus.heuristic.ClusHeuristic;
import si.ijs.kt.clus.heuristic.rules.ClusRuleHeuristicDispersion;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.test.ClusRuleConstraintInduceTest;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.tools.optimization.OptimizationAlgorithm;
import si.ijs.kt.clus.util.tools.optimization.OptimizationProblem;
import si.ijs.kt.clus.util.tools.optimization.de.DEAlgorithm;
import si.ijs.kt.clus.util.tools.optimization.gd.GDAlgorithm;

public class ClusRuleConstraintInduce
extends ClusInductionAlgorithm {
    protected boolean m_BeamChanged;
    protected FindBestTestRules m_FindBestTest = new FindBestTestRules(this.getStatManager());
    protected ClusHeuristic m_Heuristic;
    protected ArrayList<ILevelConstraint> m_Constraints;
    protected int size;
    protected ClusRuleConstraintInduceTest m_BestTest;
    protected double m_BestHeur;
    protected ArrayList<ILevelConstraint> m_BestConstraints;
    protected ClusNormalizedAttributeWeights m_Scale;
    protected RowData m_Data;
    private double m_Global_Var;
    protected double m_Alfa = 0.1;
    protected double m_Gamma = 0.5;
    private int m_MaxNbClasses;

    public ClusRuleConstraintInduce(ClusSchema schema, Settings sett) throws ClusException, IOException {
        super(schema, sett);
    }

    void resetAll() {
        this.m_BeamChanged = false;
    }

    public void setHeuristic(ClusHeuristic heur) {
        this.m_Heuristic = heur;
    }

    public double estimateBeamMeasure(ClusRule rule) {
        ClusStatistic cs = rule.m_ClusteringStat;
        double var = cs.getSVarS(this.m_Scale) / this.m_Global_Var;
        double con1 = rule.getNumberOfViolatedConstraintsRCCC();
        double con2 = rule.getConstraints().size();
        double con = con2 != 0.0 ? con1 / con2 : 0.0;
        double cov1 = ((RowData)rule.getVisitor()).toArrayList().size();
        double cov2 = this.m_Data.getNbRows();
        double cov = cov1 / cov2;
        double gamma = this.m_Gamma;
        double alfa = this.m_Alfa;
        double result = (1.0 - ((1.0 - gamma) * var + gamma * con)) * Math.pow(cov, alfa);
        return result;
    }

    public boolean isBeamChanged() {
        return this.m_BeamChanged;
    }

    public void setBeamChanged(boolean change) {
        this.m_BeamChanged = change;
    }

    ClusBeam initializeBeam(RowData data) throws ClusException {
        Settings sett = this.getSettings();
        ClusBeam beam = new ClusBeam(sett.getBeamSearch().getBeamWidth(), sett.getBeamSearch().getBeamRemoveEqualHeur());
        ClusStatistic stat = this.createTotalClusteringStat(data);
        ClusRule rule = new ClusRule(this.getStatManager());
        rule.setClusteringStat(stat);
        rule.setVisitor(data);
        Iterator<ILevelConstraint> i = this.m_Constraints.iterator();
        ArrayList<ILevelConstraint> c = new ArrayList<ILevelConstraint>();
        ArrayList<DataTuple> ds = data.toArrayList();
        while (i.hasNext()) {
            ILevelConstraint ilc = i.next();
            if (!ds.contains(ilc.getT1()) && !ds.contains(ilc.getT2())) continue;
            c.add(ilc);
        }
        rule.setConstraints(c);
        double value = this.estimateBeamMeasure(rule);
        beam.addModel(new ClusBeamModel(value, rule));
        return beam;
    }

    public void refineModel(ClusBeamModel model, ClusBeam beam, int model_idx) throws ClusException {
        ClusRule rule = (ClusRule)model.getModel();
        RowData data = (RowData)rule.getVisitor();
        ArrayList<ILevelConstraint> constraints = rule.getConstraints();
        if (this.m_FindBestTest.initSelectorAndStopCrit(rule.getClusteringStat(), data)) {
            model.setFinished(true);
            return;
        }
        if (((RowData)rule.getVisitor()).getNbRows() <= 2) {
            model.setFinished(true);
            return;
        }
        ClusAttrType[] attrs = data.getSchema().getDescriptiveAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            double new_heur;
            double beam_min_value = beam.getMinValue();
            ClusAttrType at = attrs[i];
            if (at instanceof NominalAttrType) {
                this.findNominal((NominalAttrType)at, data, constraints);
            } else {
                try {
                    this.findNumeric((NumericAttrType)at, data, constraints, rule, this.size);
                }
                catch (ClusException clusException) {
                    // empty catch block
                }
            }
            ClusLogger.info("Best test: " + this.m_BestTest);
            if (this.m_BestTest == null || this.m_BestHeur == Double.NEGATIVE_INFINITY) continue;
            ClusRuleConstraintInduceTest test = this.m_BestTest;
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("  Test: " + test.getString() + " -> " + this.m_BestHeur);
            }
            RowData subset = test.isSmallerThanTest() ? data.applyConstraint(test, 1) : data.applyConstraint(test, 0);
            ClusRule ref_rule = rule.cloneRule();
            ref_rule.addTest(test);
            ref_rule.setVisitor(subset);
            ref_rule.setClusteringStat(this.createTotalClusteringStat(subset));
            ref_rule.setConstraints(this.m_BestConstraints);
            if (this.getSettings().getRules().isHeurRuleDist()) {
                int[] subset_idx = new int[subset.getNbRows()];
                for (int j = 0; j < subset_idx.length; ++j) {
                    subset_idx[j] = subset.getTuple(j).getIndex();
                }
                ((ClusRuleHeuristicDispersion)this.m_Heuristic).setDataIndexes(subset_idx);
            }
            if (!((new_heur = this.sanityCheck(this.m_BestHeur, ref_rule)) > beam_min_value)) continue;
            ClusBeamModel new_model = new ClusBeamModel(new_heur, ref_rule);
            new_model.setParentModelIndex(model_idx);
            beam.addModel(new_model);
            this.setBeamChanged(true);
        }
    }

    public void refineBeam(ClusBeam beam) throws ClusException {
        this.setBeamChanged(false);
        ArrayList models = beam.toArray();
        this.m_BestTest = null;
        this.m_BestHeur = Double.NEGATIVE_INFINITY;
        this.m_BestConstraints = null;
        for (int i = 0; i < models.size(); ++i) {
            ClusBeamModel model = (ClusBeamModel)models.get(i);
            if (model.isRefined() || model.isFinished()) continue;
            this.refineModel(model, beam, i);
            model.setRefined(true);
            model.setParentModelIndex(-1);
        }
    }

    public ClusRule learnOneRule(RowData data) throws ClusException {
        ClusBeam beam = this.initializeBeam(data);
        int i = 0;
        while (true) {
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Step: " + i);
            } else {
                if (i != 0) {
                    System.out.print(",");
                }
                System.out.print(i);
            }
            System.out.flush();
            this.refineBeam(beam);
            ClusLogger.info();
            if (!this.isBeamChanged()) break;
            ++i;
        }
        ClusLogger.info();
        double best = beam.getBestModel().getValue();
        double worst = beam.getWorstModel().getValue();
        ClusLogger.info("Worst = " + worst + " Best = " + best);
        ClusRule result = (ClusRule)beam.getBestAndSmallestModel().getModel();
        RowData rule_data = (RowData)result.getVisitor();
        result.setTargetStat(this.createTotalTargetStat(rule_data));
        return result;
    }

    public ClusRule learnEmptyRule(RowData data) {
        ClusRule result = new ClusRule(this.getStatManager());
        return result;
    }

    public ClusRule[] learnBeamOfRules(RowData data) throws ClusException {
        ClusBeam beam = this.initializeBeam(data);
        int i = 0;
        System.out.print("Step: ");
        while (true) {
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Step: " + i);
            } else {
                if (i != 0) {
                    System.out.print(",");
                }
                System.out.print(i);
            }
            System.out.flush();
            this.refineBeam(beam);
            if (!this.isBeamChanged()) break;
            ++i;
        }
        ClusLogger.info();
        double best = beam.getBestModel().getValue();
        double worst = beam.getWorstModel().getValue();
        ClusLogger.info("Worst = " + worst + " Best = " + best);
        ArrayList beam_models = beam.toArray();
        ClusRule[] result = new ClusRule[beam_models.size()];
        for (int j = 0; j < beam_models.size(); ++j) {
            int k = beam_models.size() - j - 1;
            ClusRule rule = (ClusRule)((ClusBeamModel)beam_models.get(k)).getModel();
            RowData rule_data = (RowData)rule.getVisitor();
            rule.setTargetStat(this.createTotalTargetStat(rule_data));
            rule.setVisitor(null);
            rule.simplify();
            result[j] = rule;
        }
        return result;
    }

    public void separateAndConquor(ClusRuleSet rset, RowData data) throws ClusException {
        ClusRule rule;
        while (data.getNbRows() > 0 && !(rule = this.learnOneRule(data)).isEmpty()) {
            rule.computePrediction();
            rule.printModel();
            ClusLogger.info();
            rset.add(rule);
            data = rule.removeCovered(data);
        }
        ClusStatistic left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public void separateAndConquorWeighted(ClusRuleSet rset, RowData data) throws ClusException {
        ClusRule rule;
        int max_rules = this.getSettings().getRules().getMaxRulesNb();
        int i = 0;
        RowData data_copy = data.deepCloneData();
        ArrayList<boolean[]> bit_vect_array = new ArrayList<boolean[]>();
        while (data.getNbRows() > 0 && i < max_rules && !(rule = this.learnOneRule(data)).isEmpty()) {
            rule.computePrediction();
            rule.printModel();
            ClusLogger.info();
            rset.add(rule);
            data = rule.reweighCovered(data);
            ++i;
            if (!this.getSettings().getRules().isHeurRuleDist()) continue;
            boolean[] bit_vect = new boolean[data_copy.getNbRows()];
            block1: for (int j = 0; j < bit_vect.length; ++j) {
                if (bit_vect[j]) continue;
                for (int k = 0; k < rset.getModelSize(); ++k) {
                    if (!rset.getRule(k).covers(data_copy.getTuple(j))) continue;
                    bit_vect[j] = true;
                    continue block1;
                }
            }
            bit_vect_array.add(bit_vect);
            ((ClusRuleHeuristicDispersion)this.m_Heuristic).setCoveredBitVectArray(bit_vect_array);
        }
        ClusStatistic left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public double sanityCheck(double value, ClusRule rule) throws ClusException {
        double expected = this.estimateBeamMeasure(rule);
        if (Math.abs(value - expected) > 1.0E-6) {
            ClusLogger.info("Bug in heurisitc: " + value + " <> " + expected);
            PrintWriter wrt = new PrintWriter(System.out);
            rule.printModel(wrt);
            wrt.close();
            System.out.flush();
            throw new ClusException("sanityCheck failed");
        }
        return expected;
    }

    public ClusModel induce(ClusRun run) throws ClusException, IOException, InterruptedException {
        SettingsRules.CoveringMethod method = this.getSettings().getRules().getCoveringMethod();
        RowData data = (RowData)run.getTrainingSet();
        ClusStatistic stat = this.createTotalClusteringStat(data);
        this.m_FindBestTest.initSelectorAndSplit(stat);
        this.setHeuristic(this.m_FindBestTest.getBestTest().getHeuristic());
        ClusRuleSet rset = new ClusRuleSet(this.getStatManager());
        if (method.equals((Object)SettingsRules.CoveringMethod.Standard)) {
            this.separateAndConquor(rset, data);
        } else {
            this.separateAndConquorWeighted(rset, data);
        }
        rset.postProc();
        if (this.getSettings().getRules().getRulePredictionMethod().equals((Object)SettingsRules.RulePredictionMethod.Optimized)) {
            rset = this.optimizeRuleSet(rset, data);
        }
        if (this.getSettings().getRules().computeDispersion()) {
            rset.addDataToRules(data);
            rset.computeDispersion(0);
            rset.removeDataFromRules();
            if (run.getTestIter() != null) {
                RowData testdata = run.getTestSet();
                rset.addDataToRules(testdata);
                rset.computeDispersion(1);
                rset.removeDataFromRules();
            }
        }
        rset.numberRules();
        return rset;
    }

    public ClusRuleSet optimizeRuleSet(ClusRuleSet rset, RowData data) throws ClusException, IOException {
        String fname = this.getSettings().getData().getDataFile();
        PrintWriter wrt_pred = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fname + ".r-pred")));
        OptimizationAlgorithm optAlg = null;
        OptimizationProblem.OptimizationParameter param = rset.giveFormForWeightOptimization(wrt_pred, data);
        optAlg = this.getSettings().getRules().getRulePredictionMethod().equals((Object)SettingsRules.RulePredictionMethod.GDOptimized) ? new GDAlgorithm(this.getStatManager(), param, rset) : new DEAlgorithm(this.getStatManager(), param, rset);
        ArrayList<Double> weights = optAlg.optimize();
        System.out.print("The weights for rules:");
        for (int j = 0; j < rset.getModelSize(); ++j) {
            rset.getRule(j).setOptWeight(weights.get(j));
            System.out.print(weights.get(j) + "; ");
        }
        System.out.print("\n");
        rset.removeLowWeightRules();
        RowData data_copy = (RowData)data.cloneData();
        this.updateDefaultRule(rset, data_copy);
        return rset;
    }

    public void updateDefaultRule(ClusRuleSet rset, RowData data) throws ClusException {
        for (int i = 0; i < rset.getModelSize(); ++i) {
            data = rset.getRule(i).removeCovered(data);
        }
        ClusStatistic left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
    }

    public ClusModel induceRandomly(ClusRun run) throws ClusException, IOException, InterruptedException {
        int number = this.getSettings().getRules().nbRandomRules();
        RowData data = (RowData)run.getTrainingSet();
        ClusStatistic stat = this.createTotalClusteringStat(data);
        this.m_FindBestTest.initSelectorAndSplit(stat);
        this.setHeuristic(this.m_FindBestTest.getBestTest().getHeuristic());
        ClusRuleSet rset = new ClusRuleSet(this.getStatManager());
        Random rn = new Random(42L);
        for (int i = 0; i < number; ++i) {
            ClusRule rule = this.generateOneRandomRule(data, rn);
            rule.computePrediction();
            rule.printModel();
            ClusLogger.info();
            if (rset.addIfUnique(rule)) continue;
            --i;
        }
        ClusStatistic left_over = this.createTotalTargetStat(data);
        left_over.calcMean();
        ClusLogger.info("Left Over: " + left_over);
        rset.setTargetStat(left_over);
        rset.postProc();
        if (this.getSettings().getRules().computeDispersion()) {
            rset.addDataToRules(data);
            rset.computeDispersion(0);
            rset.removeDataFromRules();
            if (run.getTestIter() != null) {
                RowData testdata = run.getTestSet();
                rset.addDataToRules(testdata);
                rset.computeDispersion(1);
                rset.removeDataFromRules();
            }
        }
        return rset;
    }

    private ClusRule generateOneRandomRule(RowData data, Random rn) throws ClusException {
        ClusStatManager mgr = this.getStatManager();
        ClusRule result = new ClusRule(mgr);
        ClusAttrType[] attrs = data.getSchema().getDescriptiveAttributes();
        RowData orig_data = data;
        int nb_tests = attrs.length > 1 ? rn.nextInt(attrs.length - 1) + 1 : 1;
        int[] test_atts = new int[nb_tests];
        for (int i = 0; i < nb_tests; ++i) {
            int att_idx;
            boolean unique;
            do {
                att_idx = rn.nextInt(attrs.length);
                unique = true;
                for (int j = 0; j < i; ++j) {
                    if (att_idx != test_atts[j]) continue;
                    unique = false;
                }
            } while (!unique);
            test_atts[i] = att_idx;
        }
        CurrentBestTestAndHeuristic sel = this.m_FindBestTest.getBestTest();
        for (int i = 0; i < test_atts.length; ++i) {
            result.setClusteringStat(this.createTotalClusteringStat(data));
            if (this.m_FindBestTest.initSelectorAndStopCrit(result.getClusteringStat(), data)) break;
            sel.resetBestTest();
            sel.setBestHeur(Double.NEGATIVE_INFINITY);
            ClusAttrType at = attrs[test_atts[i]];
            if (at instanceof NominalAttrType) {
                this.m_FindBestTest.findNominalRandom((NominalAttrType)at, data, rn);
            } else {
                this.m_FindBestTest.findNumericRandom((NumericAttrType)at, data, orig_data, rn);
            }
            if (!sel.hasBestTest()) continue;
            NodeTest test = sel.updateTest();
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("  Test: " + test.getString() + " -> " + sel.m_BestHeur);
            }
            result.addTest(test);
            data = data.apply(test, 0);
        }
        result.setTargetStat(this.createTotalTargetStat(data));
        result.setClusteringStat(this.createTotalClusteringStat(data));
        return result;
    }

    @Override
    public ClusModel induceSingleUnpruned(ClusRun cr) throws ClusException, IOException, InterruptedException {
        this.resetAll();
        if (!this.getSettings().getRules().isRandomRules()) {
            return this.induce(cr);
        }
        return this.induceRandomly(cr);
    }

    @Override
    public void induceAll(ClusRun cr) throws ClusException, IOException, InterruptedException {
        ClusRandom.reset(4);
        RowData data = (RowData)cr.getTrainingSet();
        int nbRows = data.getNbRows();
        RowData test = cr.getTestSet();
        if (test != null) {
            ArrayList<DataTuple> allData = new ArrayList<DataTuple>();
            data.addTo(allData);
            test.addTo(allData);
            data = new RowData(allData, data.getSchema());
        }
        ClusLogger.info("All data: " + data.getNbRows());
        this.size = data.getNbRows();
        data.addIndices();
        ArrayList<DataTuple> points = data.toArrayList();
        if (this.getSettings().getILevelC().hasILevelCFile()) {
            String fname = this.getSettings().getILevelC().getILevelCFile();
            this.m_Constraints = ILevelConstraint.loadConstraints(fname, points);
            ClusAttrType type = this.getSchema().getAttrType(this.getSchema().getNbAttributes() - 1);
            if (type.getAttributeType().equals((Object)ClusAttrType.AttributeType.Nominal)) {
                NominalAttrType cls = (NominalAttrType)type;
                this.m_MaxNbClasses = cls.getNbValues();
            }
        } else {
            this.m_Constraints = this.createConstraints(data, nbRows);
        }
        ClusLogger.info("All constraints: " + this.m_Constraints.size());
        this.m_Scale = (ClusNormalizedAttributeWeights)this.getStatManager().getClusteringWeights();
        this.m_Data = data;
        ClusStatistic allStat = this.getStatManager().createStatistic(ClusAttrType.AttributeUseType.Descriptive);
        data.calcTotalStat(allStat);
        this.m_Global_Var = allStat.getSVarS(this.m_Scale);
        ClusLogger.info("Global Variance: " + this.m_Global_Var);
        ClusModel model = this.induceSingleUnpruned(cr);
        ClusRuleSet crs = (ClusRuleSet)model;
        this.labelRules(crs);
        ClusModelInfo pruned_model = cr.addModelInfo(1);
        pruned_model.setModel(model);
        pruned_model.setName("Original");
    }

    private void labelRulesKMeansInit(ClusRuleSet crs) {
        int i;
        int iterations = 50;
        ArrayList<int[]> labels = new ArrayList<int[]>();
        for (int i2 = 0; i2 < iterations; ++i2) {
            int[] l = this.labelRulesKMeans(crs);
            labels.add(l);
        }
        int bestfreq = 0;
        int[] bestLabel = new int[crs.getModelSize()];
        for (i = 0; i < iterations; ++i) {
            int[] l = (int[])labels.get(i);
            int freq = 1;
            for (int j = i + 1; j < iterations; ++j) {
                int[] c = (int[])labels.get(j);
                if (!this.sameLabeling(c, l)) continue;
                ++freq;
            }
            if (bestfreq >= freq) continue;
            bestfreq = freq;
            bestLabel = l;
        }
        for (i = 0; i < crs.getModelSize(); ++i) {
            ClusRule rule = crs.getRule(i);
            ((ILevelCStatistic)rule.getTargetStat()).setClusterID(bestLabel[i]);
        }
    }

    private boolean sameLabeling(int[] c, int[] l) {
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == l[i]) continue;
            return false;
        }
        return true;
    }

    private int[] labelRulesKMeans(ClusRuleSet crs) {
        ArrayList<ArrayList<Double>> averages = new ArrayList<ArrayList<Double>>();
        Hashtable<ClusRule, ArrayList<Double>> hash = new Hashtable<ClusRule, ArrayList<Double>>();
        Hashtable<ArrayList<Double>, int[]> weights = new Hashtable<ArrayList<Double>, int[]>();
        Hashtable<ArrayList<Double>, ArrayList<Double>> assign = new Hashtable<ArrayList<Double>, ArrayList<Double>>();
        for (int i = 0; i < crs.getModelSize(); ++i) {
            ClusRule rule = crs.getRule(i);
            int[] w = new int[]{((RowData)rule.getVisitor()).toArrayList().size()};
            ArrayList<Double> av = this.computeAverage(rule);
            weights.put(av, w);
            averages.add(av);
            hash.put(rule, av);
        }
        ArrayList<Double> min = this.getMinima(averages);
        ArrayList<Double> max = this.getMaxima(averages);
        ArrayList<ArrayList<Double>> centers = this.createCenters(min, max, averages, crs);
        for (int i = 0; i < averages.size(); ++i) {
            assign.put(averages.get(i), centers.get(0));
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = 0; i < averages.size(); ++i) {
                ArrayList<Double> closest = this.getClosestCenter(averages.get(i), centers, min, max);
                if (assign.get(averages.get(i)).equals(closest)) continue;
                changed = true;
                assign.remove(averages.get(i));
                assign.put(averages.get(i), closest);
            }
            if (!changed) continue;
            centers = this.computeAverage(averages, centers, assign, weights);
        }
        int[] labeling = new int[crs.getModelSize()];
        for (int i = 0; i < crs.getModelSize(); ++i) {
            ClusRule rule = crs.getRule(i);
            ArrayList av = (ArrayList)hash.get(rule);
            ArrayList<Double> center = assign.get(av);
            labeling[i] = centers.indexOf(center) + 1;
        }
        return labeling;
    }

    private ArrayList<ArrayList<Double>> computeAverage(ArrayList<ArrayList<Double>> averages, ArrayList<ArrayList<Double>> centers, Hashtable<ArrayList<Double>, ArrayList<Double>> assign, Hashtable<ArrayList<Double>, int[]> weights) {
        ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
        for (int i = 0; i < centers.size(); ++i) {
            ArrayList<Double> average = new ArrayList<Double>();
            int totalWeight = 0;
            ArrayList<Double> center = centers.get(i);
            for (int z = 0; z < center.size(); ++z) {
                average.add(0.0);
            }
            for (int j = 0; j < averages.size(); ++j) {
                ArrayList<Double> c = assign.get(averages.get(j));
                if (!center.equals(c)) continue;
                ++totalWeight;
                for (int x = 0; x < center.size(); ++x) {
                    double y = (Double)average.get(x);
                    average.set(x, y += averages.get(j).get(x).doubleValue());
                }
            }
            if (totalWeight > 0) {
                for (int x = 0; x < center.size(); ++x) {
                    double y = (Double)average.get(x);
                    average.set(x, y /= (double)totalWeight);
                }
                result.add(average);
                continue;
            }
            result.add(centers.get(i));
        }
        return result;
    }

    private ArrayList<Double> getClosestCenter(ArrayList<Double> point, ArrayList<ArrayList<Double>> centers, ArrayList<Double> min, ArrayList<Double> max) {
        ArrayList<Double> closest = new ArrayList<Double>();
        double distance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < centers.size(); ++i) {
            double d = this.calculateDistance(point, centers.get(i), min, max);
            if (!(d < distance)) continue;
            distance = d;
            closest = centers.get(i);
        }
        return closest;
    }

    private double calculateDistance(ArrayList<Double> point, ArrayList<Double> center, ArrayList<Double> min, ArrayList<Double> max) {
        double distance = 0.0;
        for (int i = 0; i < center.size(); ++i) {
            double norm = max.get(i) - min.get(i);
            double s = point.get(i) - center.get(i);
            distance += Math.pow(s / norm, 2.0);
        }
        return Math.sqrt(distance);
    }

    private ArrayList<ArrayList<Double>> createCenters(ArrayList<Double> min, ArrayList<Double> max, ArrayList<ArrayList<Double>> averages, ClusRuleSet crs) {
        ArrayList<ArrayList<Double>> centers = new ArrayList<ArrayList<Double>>();
        for (int i = 0; i < this.m_MaxNbClasses; ++i) {
            ArrayList<Double> c = new ArrayList<Double>();
            for (int j = 0; j < min.size(); ++j) {
                double p = ClusRandom.nextDouble(4) * (max.get(j) - min.get(j)) + min.get(j);
                c.add(p);
            }
            centers.add(c);
        }
        return centers;
    }

    private ArrayList<ArrayList<Double>> createCentersFrequencyBased(ArrayList<ArrayList<Double>> averages, ClusRuleSet crs) {
        ArrayList<ArrayList<Double>> centers = new ArrayList<ArrayList<Double>>();
        ArrayList clone = (ArrayList)averages.clone();
        double m = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.m_MaxNbClasses; ++i) {
            int c = this.getMostFrequentClone(clone, crs, m);
            ClusRule rule = crs.getRule(c);
            m = ((RowData)rule.getVisitor()).toArrayList().size();
            centers.add((ArrayList)clone.get(c));
        }
        return centers;
    }

    private int getMostFrequentClone(ArrayList<ArrayList<Double>> clone, ClusRuleSet crs, double m) {
        int highestFreq = 0;
        int c = -1;
        ClusLogger.info("max" + m);
        for (int i = 0; i < clone.size(); ++i) {
            ClusRule rule = crs.getRule(i);
            int freq = ((RowData)rule.getVisitor()).toArrayList().size();
            ClusLogger.info(freq);
            if (freq <= highestFreq || !((double)freq < m)) continue;
            c = i;
            highestFreq = freq;
        }
        ClusLogger.info("freq:" + highestFreq);
        ClusLogger.info(c);
        return c;
    }

    private ArrayList<Double> getMinima(ArrayList<ArrayList<Double>> averages) {
        ArrayList<Double> min = new ArrayList<Double>();
        Iterator<ArrayList<Double>> i = averages.iterator();
        ArrayList<Double> l1 = i.next();
        for (int j = 0; j < l1.size(); ++j) {
            double a = l1.get(j);
            min.add(a);
        }
        while (i.hasNext()) {
            ArrayList<Double> l = i.next();
            for (int j = 0; j < l.size(); ++j) {
                double a = l.get(j);
                if (!(a < min.get(j))) continue;
                min.set(j, a);
            }
        }
        return min;
    }

    private ArrayList<Double> getMaxima(ArrayList<ArrayList<Double>> averages) {
        ArrayList<Double> max = new ArrayList<Double>();
        Iterator<ArrayList<Double>> i = averages.iterator();
        ArrayList<Double> l1 = i.next();
        for (int j = 0; j < l1.size(); ++j) {
            double a = l1.get(j);
            max.add(a);
        }
        while (i.hasNext()) {
            ArrayList<Double> l = i.next();
            for (int j = 0; j < l.size(); ++j) {
                double a = l.get(j);
                if (!(a > max.get(j))) continue;
                max.set(j, a);
            }
        }
        return max;
    }

    private ArrayList<Double> computeAverage(ClusRule rule) {
        RowData data = (RowData)rule.getVisitor();
        ClusAttrType[] attrs = data.getSchema().getDescriptiveAttributes();
        ArrayList<Double> average = new ArrayList<Double>();
        for (int i = 0; i < attrs.length; ++i) {
            average.add(0.0);
        }
        ArrayList<DataTuple> tuples = ((RowData)rule.getVisitor()).toArrayList();
        for (DataTuple t : tuples) {
            for (int j = 0; j < attrs.length; ++j) {
                Double a = average.get(j);
                a = a + t.getDoubleVal(j);
                average.set(j, a);
            }
        }
        for (int j = 0; j < attrs.length; ++j) {
            Double a = average.get(j);
            a = a / (double)tuples.size();
            average.set(j, a);
        }
        return average;
    }

    private void labelRules(ClusRuleSet crs) throws ClusException {
        int i;
        ArrayList clusters = new ArrayList();
        for (i = 0; i < crs.getModelSize(); ++i) {
            ArrayList<ClusRule> cr = new ArrayList<ClusRule>();
            ClusRule rule = crs.getRule(i);
            cr.add(rule);
            clusters.add(cr);
        }
        while (clusters.size() > this.m_MaxNbClasses) {
            int best_I = -1;
            int best_J = -1;
            double best_score = Double.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < clusters.size(); ++i2) {
                for (int j = 0; j < i2; ++j) {
                    ClusRule rule1 = this.getRule((ArrayList)clusters.get(i2));
                    ClusRule rule2 = this.getRule((ArrayList)clusters.get(j));
                    ArrayList<ClusRule> c = new ArrayList<ClusRule>();
                    c.add(rule1);
                    c.add(rule2);
                    ClusRule combo = this.getRule(c);
                    double scoreC = this.calcNewHeur(combo);
                    if (!(scoreC > best_score)) continue;
                    best_I = i2;
                    best_J = j;
                    best_score = scoreC;
                }
            }
            ArrayList r = (ArrayList)clusters.get(best_I);
            ((ArrayList)clusters.get(best_J)).addAll(r);
            clusters.remove(best_I);
        }
        for (i = 0; i < clusters.size(); ++i) {
            ArrayList c = (ArrayList)clusters.get(i);
            for (int j = 0; j < c.size(); ++j) {
                ClusRule rule = (ClusRule)c.get(j);
                ((ILevelCStatistic)rule.getTargetStat()).setClusterID(i + 1);
            }
        }
    }

    private ClusRule getRule(ArrayList<ClusRule> c) throws ClusException {
        ClusRule n = c.get(0);
        for (int i = 1; i < c.size(); ++i) {
            ClusRule combo = new ClusRule(this.getStatManager());
            ClusRule rule = c.get(i);
            RowData data = new RowData(this.getSchema());
            data.addAll((RowData)rule.getVisitor(), (RowData)n.getVisitor());
            ClusStatistic stat = this.createTotalClusteringStat(data);
            combo.setClusteringStat(stat);
            combo.setVisitor(data);
            ArrayList cons = (ArrayList)n.getConstraints().clone();
            for (ILevelConstraint ilc : rule.getConstraints()) {
                if (cons.contains(ilc)) continue;
                cons.add(ilc);
            }
            combo.setConstraints(cons);
            n = combo;
        }
        return n;
    }

    private double calcNewHeur(ClusRule rule) {
        ClusStatistic cs = rule.m_ClusteringStat;
        double var = cs.getSVarS(this.m_Scale) / this.m_Global_Var;
        double con1 = rule.getNumberOfViolatedConstraintsRCCC();
        double con2 = rule.getConstraints().size();
        double con = con2 != 0.0 ? con1 / con2 : 0.0;
        double cov1 = ((RowData)rule.getVisitor()).toArrayList().size();
        double cov2 = this.m_Data.getNbRows();
        double cov = cov1 / cov2;
        double gamma = this.m_Gamma;
        double alfa = this.m_Alfa;
        double result = (1.0 - ((1.0 - gamma) * var + gamma * con)) * Math.pow(cov, alfa);
        return result;
    }

    public ArrayList<ILevelConstraint> createConstraints(RowData data, int nbRows) {
        ArrayList<ILevelConstraint> constr = new ArrayList<ILevelConstraint>();
        ClusAttrType type = this.getSchema().getAttrType(this.getSchema().getNbAttributes() - 1);
        if (type.getAttributeType().equals((Object)ClusAttrType.AttributeType.Nominal)) {
            NominalAttrType cls = (NominalAttrType)type;
            this.m_MaxNbClasses = cls.getNbValues();
            int nbConstraints = this.getSettings().getILevelC().getILevelCNbRandomConstraints();
            for (int i = 0; i < nbConstraints; ++i) {
                int t1i = 0;
                int t2i = 0;
                while (t1i == t2i) {
                    t1i = ClusRandom.nextInt(4, nbRows);
                    t2i = ClusRandom.nextInt(4, nbRows);
                }
                DataTuple t1 = data.getTuple(t1i);
                DataTuple t2 = data.getTuple(t2i);
                if (cls.getNominal(t1) == cls.getNominal(t2)) {
                    constr.add(new ILevelConstraint(t1, t2, 0));
                    continue;
                }
                constr.add(new ILevelConstraint(t1, t2, 1));
            }
        }
        return constr;
    }

    public void findNominal(NominalAttrType type, RowData data, ArrayList<ILevelConstraint> constraints) {
    }

    public void findNumeric(NumericAttrType at, RowData data, ArrayList<ILevelConstraint> constraints, ClusRule rule, int size) throws ClusException {
        if (at.isSparse()) {
            throw new ClusException("input voor sortSparse aangepast!");
        }
        data.sort(at);
        if (at.hasMissing()) {
            throw new ClusException("Does not support attributes with missing values: " + at.getName());
        }
        this.m_BestHeur = Double.NEGATIVE_INFINITY;
        ILevelCStatistic cs = (ILevelCStatistic)rule.getClusteringStat();
        RegressionStat s = new RegressionStat(this.getSettings(), cs.getAttributes());
        RegressionStat s_I = new RegressionStat(this.getSettings(), cs.getAttributes());
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            s.updateWeighted(tuple, tuple.getWeight());
            s_I.updateWeighted(tuple, tuple.getWeight());
        }
        int idx = at.getArrayIndex();
        int Cviol = 0;
        Hashtable<DataTuple, ArrayList<ILevelConstraint>> hash = new Hashtable<DataTuple, ArrayList<ILevelConstraint>>(data.getNbRows());
        MemoryTupleIterator dataIterator = data.getIterator();
        for (int a = 0; a < dataIterator.getNbExamples(); ++a) {
            DataTuple d = dataIterator.readTuple();
            hash.put(d, new ArrayList());
        }
        Iterator<ILevelConstraint> it = constraints.iterator();
        ArrayList<ILevelConstraint> ML = new ArrayList<ILevelConstraint>();
        ArrayList<ILevelConstraint> CL = new ArrayList<ILevelConstraint>();
        ArrayList<DataTuple> d = data.toArrayList();
        while (it.hasNext()) {
            ArrayList cons;
            DataTuple t2;
            DataTuple t1;
            ILevelConstraint c = it.next();
            if (c.getType() == 0) {
                ML.add(c);
                t1 = c.getT1();
                t2 = c.getT2();
                if (hash.containsKey(t1)) {
                    cons = (ArrayList)hash.get(t1);
                    cons.add(c);
                    hash.put(t1, cons);
                }
                if (hash.containsKey(t2)) {
                    cons = (ArrayList)hash.get(t2);
                    cons.add(c);
                    hash.put(t2, cons);
                }
                if (!d.contains(t1) || !d.contains(t2)) {
                    ++Cviol;
                }
                if (!t1.equals(null) || !t2.equals(null)) continue;
                ClusLogger.info("ML should have been removed");
                continue;
            }
            CL.add(c);
            t1 = c.getT1();
            t2 = c.getT2();
            if (hash.containsKey(t1)) {
                cons = (ArrayList)hash.get(t1);
                cons.add(c);
                hash.put(t1, cons);
            }
            if (hash.containsKey(t2)) {
                cons = (ArrayList)hash.get(t2);
                cons.add(c);
                hash.put(t2, cons);
            }
            if (d.contains(t1) && d.contains(t2)) {
                ++Cviol;
                continue;
            }
            if (d.contains(t1) || d.contains(t2)) continue;
            ClusLogger.info("CL should have been removed");
        }
        ArrayList ML_I = (ArrayList)ML.clone();
        ArrayList CL_I = (ArrayList)CL.clone();
        Hashtable hash_I = (Hashtable)hash.clone();
        int Dtot = size;
        int Dcov = data.getNbRows();
        int Ctot = constraints.size();
        int Dcov_I = Dcov;
        int Cviol_I = Cviol;
        int Ctot_I = Ctot;
        this.findNumericNormal(at, data, s, idx, Cviol, hash, ML, CL, Dtot, Dcov, Ctot);
        this.findNumericInverse(at, data, s_I, idx, Cviol_I, hash_I, ML_I, CL_I, Dtot, Dcov_I, Ctot_I);
    }

    private void findNumericInverse(NumericAttrType at, RowData data, RegressionStat s, int idx, int Cviol, Hashtable<DataTuple, ArrayList<ILevelConstraint>> hash, ArrayList<ILevelConstraint> ML, ArrayList<ILevelConstraint> CL, int Dtot, int Dcov, int Ctot) {
        double prev = Double.NaN;
        for (int i = data.getNbRows() - 1; i >= 0; --i) {
            double heuristic;
            DataTuple tuple = data.getTuple(i);
            double value = tuple.getDoubleVal(idx);
            if (value != prev && prev > Double.NEGATIVE_INFINITY && Dcov > 1 && (heuristic = this.computeHeuristic(Dtot, Dcov, Ctot, Cviol, s, ML, CL, hash)) > this.m_BestHeur) {
                this.m_BestHeur = heuristic;
                double splitpoint = (value + prev) / 2.0;
                this.m_BestTest = new ClusRuleConstraintInduceTest(at, splitpoint, false);
                this.m_BestConstraints = (ArrayList)ML.clone();
                this.m_BestConstraints.addAll((ArrayList)CL.clone());
            }
            prev = value;
            s.updateWeighted(tuple, -1.0 * tuple.getWeight());
            for (ILevelConstraint ilc : hash.get(tuple)) {
                DataTuple toCheck = tuple.getIndex() == ilc.getT1().getIndex() ? ilc.getT2() : ilc.getT1();
                if (ilc.getType() == 0) {
                    if (hash.containsKey(toCheck)) {
                        ++Cviol;
                        continue;
                    }
                    ML.remove(ilc);
                    --Cviol;
                    --Ctot;
                    continue;
                }
                if (hash.containsKey(toCheck)) {
                    --Cviol;
                    continue;
                }
                CL.remove(ilc);
                --Ctot;
            }
            hash.remove(tuple);
            --Dcov;
        }
    }

    private void findNumericNormal(NumericAttrType at, RowData data, RegressionStat s, int idx, int Cviol, Hashtable<DataTuple, ArrayList<ILevelConstraint>> hash, ArrayList<ILevelConstraint> ML, ArrayList<ILevelConstraint> CL, int Dtot, int Dcov, int Ctot) {
        double prev = Double.NaN;
        for (int i = 0; i < data.getNbRows(); ++i) {
            double heuristic;
            DataTuple tuple = data.getTuple(i);
            double value = tuple.getDoubleVal(idx);
            if (value != prev && prev > Double.NEGATIVE_INFINITY && Dcov > 1 && (heuristic = this.computeHeuristic(Dtot, Dcov, Ctot, Cviol, s, ML, CL, hash)) > this.m_BestHeur) {
                this.m_BestHeur = heuristic;
                double splitpoint = (value + prev) / 2.0;
                this.m_BestTest = new ClusRuleConstraintInduceTest(at, splitpoint, true);
                this.m_BestConstraints = (ArrayList)ML.clone();
                this.m_BestConstraints.addAll((ArrayList)CL.clone());
            }
            prev = value;
            s.updateWeighted(tuple, -1.0 * tuple.getWeight());
            for (ILevelConstraint ilc : hash.get(tuple)) {
                DataTuple toCheck = tuple.getIndex() == ilc.getT1().getIndex() ? ilc.getT2() : ilc.getT1();
                if (ilc.getType() == 0) {
                    if (hash.containsKey(toCheck)) {
                        ++Cviol;
                        continue;
                    }
                    ML.remove(ilc);
                    --Cviol;
                    --Ctot;
                    continue;
                }
                if (hash.containsKey(toCheck)) {
                    --Cviol;
                    continue;
                }
                CL.remove(ilc);
                --Ctot;
            }
            hash.remove(tuple);
            --Dcov;
        }
    }

    private double computeHeuristic(double dtot, double dcov, double ctot, double cviol, RegressionStat s, ArrayList<ILevelConstraint> ml, ArrayList<ILevelConstraint> cl, Hashtable<DataTuple, ArrayList<ILevelConstraint>> hash) {
        double var = s.getSVarS(this.m_Scale) / this.m_Global_Var;
        double con = ctot == 0.0 ? 0.0 : cviol / ctot;
        double data = dcov / dtot;
        double g = this.m_Gamma;
        double a = this.m_Alfa;
        double h = (1.0 - ((1.0 - g) * var + g * con)) * Math.pow(data, a);
        return h;
    }
}

