/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import java.io.IOException;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.ClusInductionAlgorithmType;
import si.ijs.kt.clus.algo.rules.ClusRuleConstraintInduce;
import si.ijs.kt.clus.algo.rules.ClusRuleFromTreeInduce;
import si.ijs.kt.clus.algo.rules.ClusRuleInduce;
import si.ijs.kt.clus.algo.rules.RuleNormalization;
import si.ijs.kt.clus.algo.rules.probabilistic.ClusRuleProbabilisticRuleSetInduce;
import si.ijs.kt.clus.algo.tdidt.ClusDecisionTree;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgs;

public class ClusRuleClassifier
extends ClusInductionAlgorithmType {
    public ClusRuleClassifier(Clus clus) {
        super(clus);
    }

    @Override
    public ClusInductionAlgorithm createInduce(ClusSchema schema, Settings sett, CMDLineArgs cargs) throws ClusException, IOException {
        ClusInductionAlgorithm induce;
        if (sett.getRules().isRulePredictionOptimized()) {
            NumericAttrType[] descrNumTypes = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive);
            NumericAttrType[] tarNumTypes = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
            RuleNormalization.initialize(Clus.calcStdDevsForTheSet(this.getClus().getData(), descrNumTypes), Clus.calcStdDevsForTheSet(this.getClus().getData(), tarNumTypes));
        }
        if (sett.getRules().getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.RulesFromTree)) {
            induce = new ClusRuleFromTreeInduce(schema, sett, this.getClus());
        } else {
            induce = sett.getRules().getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.SampledRuleSet) ? new ClusRuleProbabilisticRuleSetInduce(schema, sett, this.getClus()) : (sett.getILevelC().isSectionILevelCEnabled() ? new ClusRuleConstraintInduce(schema, sett) : new ClusRuleInduce(schema, sett));
            induce.getStatManager().setRuleInduceOnly(true);
        }
        induce.getStatManager().initRuleSettings();
        return induce;
    }

    @Override
    public void printInfo() {
        if (this.getSettings().getRules().getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.SampledRuleSet)) {
            ClusLogger.info("RuleSystem based on sampling from initial set of rules generated by: " + this.getSettings().getRules().getInitialRuleGeneratingMethod().toString());
        } else if (this.getSettings().getRules().isRandomRules()) {
            ClusLogger.info("RuleSystem generating random rules");
        } else if (this.getSettings().getRules().getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.RulesFromTree) && this.getSettings().getRules().getRulePredictionMethod().equals((Object)SettingsRules.RulePredictionMethod.GDOptimized)) {
            if (this.getSettings().getEnsemble().isEnsembleROSEnabled()) {
                ClusLogger.info("Fitted Rule Ensemble with Random Output Selections (FIRE-ROS)");
            } else {
                ClusLogger.info("Fitted Rule Ensemble (FIRE)");
            }
        } else {
            ClusLogger.info("RuleSystem based on CN2");
            ClusLogger.info("Heuristic: " + this.getStatManager().getHeuristicName());
        }
    }

    @Override
    public void pruneAll(ClusRun cr) throws ClusException, IOException {
    }

    @Override
    public ClusModel pruneSingle(ClusModel model, ClusRun cr) throws ClusException, IOException {
        return model;
    }

    @Override
    public void postProcess(ClusRun cr) throws ClusException, IOException, InterruptedException {
        if (!this.getSettings().getRules().getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.RulesFromTree) && !this.getSettings().getRules().getCoveringMethod().equals((Object)SettingsRules.CoveringMethod.SampledRuleSet)) {
            ClusModelInfo def_model = cr.addModelInfo(0);
            def_model.setModel(ClusDecisionTree.induceDefault(cr));
        }
    }
}

