/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.rules;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import si.ijs.kt.clus.data.attweights.ClusAttributeWeights;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.ext.ensemble.ros.ClusROSModelInfo;
import si.ijs.kt.clus.ext.ilevelc.ILevelConstraint;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsRules;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.test.NodeTest;
import si.ijs.kt.clus.statistic.ClassificationStat;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.CombStat;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.statistic.StatisticPrintInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.util.MyArray;

public class ClusRule
implements ClusModel,
Serializable {
    public static final long serialVersionUID = 1L;
    protected int m_ID;
    protected Object m_Visitor;
    protected ArrayList<ILevelConstraint> m_Constraint;
    protected ClusStatistic m_TargetStat;
    protected ClusStatistic m_ClusteringStat;
    protected ArrayList<NodeTest> m_Tests = new ArrayList();
    protected ClusStatManager m_StatManager;
    protected ClusErrorList[] m_Errors;
    protected ArrayList<DataTuple> m_Data = new ArrayList();
    protected CombStat[] m_CombStat = new CombStat[2];
    protected double[] m_Coverage = new double[2];
    protected BitSet m_CoverageBits = null;
    protected BitSet m_CoverageCorrectBits = null;
    protected double m_TrainErrorScore;
    protected double m_OptWeight;
    private ClusROSModelInfo m_ROSModelInfo;
    private static final double EQUAL_MAX_DIFFER = 1.0E-6;

    public ClusRule(ClusStatManager statManager) {
        this.m_StatManager = statManager;
        this.m_TrainErrorScore = -1.0;
        this.m_OptWeight = -1.0;
    }

    @Override
    public int getID() {
        return this.m_ID;
    }

    public void setID(int id) {
        this.m_ID = id;
    }

    public ClusROSModelInfo getROSModelInfo() {
        return this.m_ROSModelInfo;
    }

    @Override
    public ClusStatistic predictWeighted(DataTuple tuple) {
        return this.m_TargetStat;
    }

    public void computePrediction() throws ClusException {
        this.m_TargetStat.calcMean();
        this.m_ClusteringStat.calcMean();
    }

    public ClusRule cloneRule() {
        ClusRule new_rule = new ClusRule(this.m_StatManager);
        for (int i = 0; i < this.getModelSize(); ++i) {
            new_rule.addTest(this.getTest(i));
        }
        return new_rule;
    }

    public boolean equals(Object other) {
        ClusRule o = (ClusRule)other;
        if (o.getModelSize() != this.getModelSize()) {
            return false;
        }
        for (int i = 0; i < this.getModelSize(); ++i) {
            boolean has_test = false;
            for (int j = 0; j < this.getModelSize() && !has_test; ++j) {
                if (!this.getTest(i).equals(o.getTest(j))) continue;
                has_test = true;
            }
            if (has_test) continue;
            return false;
        }
        return true;
    }

    public boolean equalsDeeply(Object other) {
        ClusRule o = (ClusRule)other;
        if (o.getModelSize() != this.getModelSize()) {
            return false;
        }
        for (int i = 0; i < this.getModelSize(); ++i) {
            boolean has_test = false;
            for (int j = 0; j < this.getModelSize() && !has_test; ++j) {
                if (!this.getTest(i).equals(o.getTest(j))) continue;
                has_test = true;
            }
            if (has_test) continue;
            return false;
        }
        double[] ruleTarget = ((RegressionStat)o.m_TargetStat).m_Means;
        boolean targetsAreSimilar = true;
        for (int iTarget = 0; iTarget < ruleTarget.length && targetsAreSimilar; ++iTarget) {
            if (!(Math.abs(ruleTarget[iTarget] - ((RegressionStat)this.m_TargetStat).m_Means[iTarget]) >= 1.0E-6)) continue;
            targetsAreSimilar = false;
        }
        return targetsAreSimilar;
    }

    public int hashCode() {
        int hashCode = 1234;
        for (int i = 0; i < this.getModelSize(); ++i) {
            hashCode += this.getTest(i).hashCode();
        }
        return hashCode;
    }

    public boolean covers(DataTuple tuple) {
        for (int i = 0; i < this.getModelSize(); ++i) {
            NodeTest test = this.getTest(i);
            int res = test.predictWeighted(tuple);
            if (res == 0) continue;
            return false;
        }
        return true;
    }

    public void simplify() {
        for (int i = this.getModelSize() - 1; i >= 0; --i) {
            boolean found = false;
            NodeTest test_i = this.getTest(i);
            for (int j = 0; j < i && !found; ++j) {
                NodeTest test_j = this.getTest(j);
                NodeTest simplify = test_j.simplifyConjunction(test_i);
                if (simplify == null) continue;
                this.setTest(j, simplify);
                found = true;
            }
            if (!found) continue;
            this.removeTest(i);
        }
    }

    public RowData removeCovered(RowData data) {
        int covered = 0;
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            if (!this.covers(tuple)) continue;
            ++covered;
        }
        int idx = 0;
        RowData res = new RowData(data.getSchema(), data.getNbRows() - covered);
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            if (this.covers(tuple)) continue;
            res.setTuple(tuple, idx++);
        }
        return res;
    }

    public RowData computeCovered(RowData data) {
        RowData res = new RowData(data.getSchema());
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            if (!this.covers(tuple)) continue;
            res.add(tuple);
        }
        return res;
    }

    public void computeCoverageBits(RowData data) {
        int nbRows = data.getNbRows();
        this.m_CoverageBits = new BitSet(nbRows);
        this.m_CoverageCorrectBits = new BitSet(nbRows);
        boolean correctCoverage = false;
        if (this.m_TargetStat instanceof ClassificationStat) {
            NominalAttrType[] targetAttributes = this.m_StatManager.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
            for (int i = 0; i < nbRows; ++i) {
                DataTuple tuple = data.getTuple(i);
                if (!this.covers(tuple)) continue;
                this.m_CoverageBits.set(i);
                int[] predictions = this.predictWeighted(tuple).getNominalPred();
                NominalAttrType[] targetAttrs = data.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
                for (int j = 0; j < targetAttributes.length; ++j) {
                    int true_value = targetAttrs[j].getNominal(tuple);
                    if (predictions[j] != true_value) continue;
                    this.m_CoverageCorrectBits.set(j);
                }
            }
        } else if (this.m_TargetStat instanceof RegressionStat) {
            NumericAttrType[] targetAttributes = this.m_StatManager.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
            for (int i = 0; i < nbRows; ++i) {
                DataTuple tuple = data.getTuple(i);
                if (!this.covers(tuple)) continue;
                this.m_CoverageBits.set(i);
                double[] predictions = ((RegressionStat)this.predictWeighted(tuple)).getNumericPred();
                correctCoverage = true;
                for (int j = 0; j < targetAttributes.length; ++j) {
                    double variance = ((RegressionStat)this.m_TargetStat).getVariance(j);
                    double diff = Math.abs(predictions[j] - ((ClusAttrType)targetAttributes[j]).getNumeric(tuple));
                    if (!(diff > variance)) continue;
                    correctCoverage = false;
                    break;
                }
                if (!correctCoverage) continue;
                this.m_CoverageCorrectBits.set(i);
            }
        } else {
            throw new RuntimeException("Mixed classification and regression not yet implemented");
        }
    }

    public RowData removeCoveredEnough(RowData data) {
        double threshold = this.getSettings().getRules().getInstCoveringWeightThreshold();
        double covered = 0.0;
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            if (!(tuple.m_Weight < threshold)) continue;
            covered += 1.0;
        }
        int idx = 0;
        RowData res = new RowData(data.getSchema(), (int)((double)data.getNbRows() - covered));
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            if (tuple.m_Weight < threshold) continue;
            res.setTuple(tuple, idx++);
        }
        return res;
    }

    public RowData reweighCovered(RowData data) throws ClusException {
        SettingsRules.CoveringMethod cov_method = this.getSettings().getRules().getCoveringMethod();
        double cov_w_par = this.getSettings().getRules().getCoveringWeight();
        int nb_rows = data.getNbRows();
        RowData result = new RowData(data.getSchema(), nb_rows);
        if (cov_w_par >= 1.0 || cov_w_par < 0.0) {
            throw new ClusException("Weighted covering: covering weight should be between 0 and 1!");
        }
        for (int i = 0; i < data.getNbRows(); ++i) {
            ClusAttributeWeights weights;
            ClusStatistic prediction;
            ClusAttrType[] targetAttrs;
            Object[] predictions;
            double new_weight;
            DataTuple tuple = data.getTuple(i);
            double old_weight = tuple.getWeight();
            if (cov_method.equals((Object)SettingsRules.CoveringMethod.WeightedAdditive)) {
                new_weight = cov_w_par * old_weight / (old_weight + 1.0);
            } else if (cov_method.equals((Object)SettingsRules.CoveringMethod.WeightedMultiplicative)) {
                if (cov_w_par == 1.0) {
                    throw new ClusException("Multiplicative weighted covering: covering weight should not be 1!");
                }
                new_weight = old_weight * cov_w_par;
            } else if (this.m_TargetStat instanceof ClassificationStat) {
                predictions = this.predictWeighted(tuple).getNominalPred();
                targetAttrs = data.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
                if (predictions.length > 1) {
                    double prop_true = 0.0;
                    for (int j = 0; j < predictions.length; ++j) {
                        int true_value = ((NominalAttrType)targetAttrs[j]).getNominal(tuple);
                        if (predictions[j] != true_value) continue;
                        prop_true += 1.0;
                    }
                    prop_true = prop_true != 0.0 ? prop_true / (double)predictions.length : 0.0;
                    new_weight = old_weight * (1.0 + prop_true * (cov_w_par - 1.0));
                } else {
                    int prediction2 = predictions[0];
                    int true_value = targetAttrs[0].getNominal(tuple);
                    new_weight = prediction2 == true_value ? old_weight * cov_w_par : old_weight;
                }
            } else if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
                prediction = this.predictWeighted(tuple);
                double coef = cov_w_par * prediction.getAbsoluteDistance(tuple, weights = this.m_StatManager.getClusteringWeights());
                if (coef > 1.0) {
                    coef = 1.0;
                }
                new_weight = old_weight * coef;
            } else if (this.m_TargetStat instanceof RegressionStat) {
                predictions = this.predictWeighted(tuple).getNumericPred();
                targetAttrs = data.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
                if (predictions.length > 1) {
                    double[] true_values = new double[predictions.length];
                    ClusStatistic stat = this.m_StatManager.getTrainSetStat();
                    double[] variance = new double[predictions.length];
                    double[] coef = new double[predictions.length];
                    for (int j = 0; j < true_values.length; ++j) {
                        true_values[j] = ((NumericAttrType)targetAttrs[j]).getNumeric(tuple);
                        variance[j] = ((CombStat)stat).getRegressionStat().getVariance(j);
                        coef[j] = cov_w_par * Math.abs((double)(predictions[j] - true_values[j])) / Math.sqrt(variance[j]);
                    }
                    double mean_coef = 0.0;
                    for (int j = 0; j < true_values.length; ++j) {
                        mean_coef += coef[j];
                    }
                    if ((mean_coef /= (double)coef.length) > 1.0) {
                        mean_coef = 1.0;
                    }
                    new_weight = old_weight * mean_coef;
                } else {
                    int prediction3 = predictions[0];
                    double true_value = ((NumericAttrType)targetAttrs[0]).getNumeric(tuple);
                    ClusStatistic stat = this.m_StatManager.getTrainSetStat();
                    double variance = ((CombStat)stat).getRegressionStat().getVariance(0);
                    double coef = cov_w_par * Math.abs((double)(prediction3 - true_value)) / Math.sqrt(variance);
                    if (coef > 1.0) {
                        coef = 1.0;
                    }
                    new_weight = old_weight * coef;
                }
            } else if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.TIME_SERIES) {
                prediction = this.predictWeighted(tuple);
                double coef = cov_w_par * prediction.getAbsoluteDistance(tuple, weights = this.m_StatManager.getClusteringWeights());
                if (coef > 1.0) {
                    coef = 1.0;
                }
                new_weight = old_weight * coef;
            } else {
                throw new ClusException("reweighCovered(): Unsupported mode!");
            }
            if (this.covers(tuple)) {
                result.setTuple(tuple.changeWeight(new_weight), i);
                continue;
            }
            result.setTuple(tuple, i);
        }
        return this.removeCoveredEnough(result);
    }

    public void setVisitor(Object visitor) {
        this.m_Visitor = visitor;
    }

    public Object getVisitor() {
        return this.m_Visitor;
    }

    public void setConstraints(ArrayList<ILevelConstraint> constraints) {
        this.m_Constraint = constraints;
    }

    public ArrayList<ILevelConstraint> getConstraints() {
        return this.m_Constraint;
    }

    public int getNumberOfViolatedConstraints() {
        int count = 0;
        for (ILevelConstraint ilc : this.m_Constraint) {
            DataTuple t1 = ilc.getT1();
            DataTuple t2 = ilc.getT2();
            if (ilc.getType() == 0) {
                if (this.m_Data.contains(t1) && this.m_Data.contains(t2)) continue;
                ++count;
                continue;
            }
            if (!this.m_Data.contains(t1) || !this.m_Data.contains(t2)) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfViolatedConstraintsRCCC() {
        int count = 0;
        Iterator<ILevelConstraint> i = this.m_Constraint.iterator();
        ArrayList<DataTuple> data = ((RowData)this.getVisitor()).toArrayList();
        while (i.hasNext()) {
            ILevelConstraint ilc = i.next();
            DataTuple t1 = ilc.getT1();
            DataTuple t2 = ilc.getT2();
            if (ilc.getType() == 0) {
                if (data.contains(t1) && data.contains(t2)) continue;
                ++count;
                continue;
            }
            if (!data.contains(t1) || !data.contains(t2)) continue;
            ++count;
        }
        return count;
    }

    public ArrayList<ILevelConstraint> getViolatedConstraintsRCCC() {
        Iterator<ILevelConstraint> i = this.m_Constraint.iterator();
        ArrayList<DataTuple> data = ((RowData)this.getVisitor()).toArrayList();
        ArrayList<ILevelConstraint> c = new ArrayList<ILevelConstraint>();
        while (i.hasNext()) {
            ILevelConstraint ilc = i.next();
            DataTuple t1 = ilc.getT1();
            DataTuple t2 = ilc.getT2();
            if (ilc.getType() == 0) {
                if (data.contains(t1) && data.contains(t2)) continue;
                c.add(ilc);
                continue;
            }
            if (!data.contains(t1) || !data.contains(t2)) continue;
            c.add(ilc);
        }
        return c;
    }

    @Override
    public void applyModelProcessors(DataTuple tuple, MyArray mproc) throws IOException {
    }

    @Override
    public void attachModel(HashMap table) throws ClusException {
        for (int i = 0; i < this.m_Tests.size(); ++i) {
            NodeTest test = this.m_Tests.get(i);
            test.attachModel(table);
        }
    }

    public void printModel() {
        PrintWriter wrt = new PrintWriter(System.out);
        this.printModel(wrt);
        wrt.flush();
    }

    @Override
    public void printModel(PrintWriter wrt) {
        this.printModel(wrt, StatisticPrintInfo.getInstance());
    }

    public void printModelTests(PrintWriter wrt) {
        for (NodeTest test : this.getModelTests()) {
            wrt.println(test.getString());
        }
    }

    public ArrayList<NodeTest> getModelTests() {
        ArrayList<NodeTest> tests = new ArrayList<NodeTest>();
        for (int i = 0; i < this.m_Tests.size(); ++i) {
            NodeTest test = this.m_Tests.get(i);
            tests.add(test);
        }
        return tests;
    }

    @Override
    public void printModel(PrintWriter wrt, StatisticPrintInfo info) {
        wrt.print("IF ");
        if (this.m_Tests.size() == 0) {
            wrt.print("true");
        } else {
            for (int i = 0; i < this.m_Tests.size(); ++i) {
                NodeTest test = this.m_Tests.get(i);
                if (i != 0) {
                    wrt.println(" AND");
                    wrt.print("   ");
                }
                wrt.print(test.getString());
            }
        }
        wrt.println();
        wrt.print("THEN " + this.m_TargetStat.getString(info));
        if (this.getID() != 0 && info.SHOW_INDEX) {
            wrt.println(" (" + this.getID() + ")");
        } else {
            wrt.println();
        }
        String extra = this.m_TargetStat.getExtraInfo();
        if (extra != null) {
            wrt.println();
            wrt.print(extra);
        }
        this.commonPrintForRuleTypes(wrt, info);
    }

    protected void commonPrintForRuleTypes(PrintWriter wrt, StatisticPrintInfo info) {
        ClusNumberFormat fr = ClusFormat.SIX_AFTER_DOT;
        if (this.getSettings().getRules().isRulePredictionOptimized()) {
            wrt.println("\n   Rule weight        : " + fr.format(this.getOptWeight()));
        }
        if (this.getSettings().getRules().computeDispersion() && this.m_CombStat[0] != null) {
            wrt.println("   Dispersion (train): " + this.m_CombStat[0].getDispersionString());
            wrt.println("   Coverage   (train): " + fr.format(this.m_Coverage[0]));
            wrt.println("   Cover*Disp (train): " + fr.format(this.m_CombStat[0].dispersionCalc() * this.m_Coverage[0]));
            if (this.m_CombStat[1] != null) {
                wrt.println("   Dispersion (test):  " + this.m_CombStat[1].getDispersionString());
                wrt.println("   Coverage   (test):  " + fr.format(this.m_Coverage[1]));
                wrt.println("   Cover*Disp (test):  " + fr.format(this.m_CombStat[1].dispersionCalc() * this.m_Coverage[1]));
            }
        }
        if (this.hasErrors()) {
            ClusErrorList test_err;
            ClusErrorList train_err = this.getError(0);
            if (train_err != null) {
                wrt.println();
                wrt.println("Training error");
                train_err.showError(wrt);
            }
            if ((test_err = this.getError(1)) != null) {
                wrt.println();
                wrt.println("Testing error");
                test_err.showError(wrt);
            }
        }
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> indices) {
    }

    @Override
    public void printModelToPythonScript(PrintWriter wrt, HashMap<String, Integer> indices, String modelIdentifier) {
    }

    @Override
    public JsonObject getModelJSON() {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info) {
        return null;
    }

    @Override
    public JsonObject getModelJSON(StatisticPrintInfo info, RowData examples) {
        return null;
    }

    @Override
    public void printModelToQuery(PrintWriter wrt, ClusRun cr, int starttree, int startitem, boolean ex) {
    }

    @Override
    public void printModelAndExamples(PrintWriter wrt, StatisticPrintInfo info, RowData examples) {
    }

    public Settings getSettings() {
        return this.m_StatManager.getSettings();
    }

    public boolean isEmpty() {
        return this.getModelSize() == 0;
    }

    @Override
    public int getModelSize() {
        return this.m_Tests.size();
    }

    public ArrayList<NodeTest> getTests() {
        return this.m_Tests;
    }

    public NodeTest getTest(int i) {
        return this.m_Tests.get(i);
    }

    public void setTest(int i, NodeTest test) {
        this.m_Tests.set(i, test);
    }

    public void addTest(NodeTest test) {
        this.m_Tests.add(test);
    }

    public void removeTest(int i) {
        this.m_Tests.remove(i);
    }

    public double[] getCoverage() {
        return this.m_Coverage;
    }

    public void setCoverage(double[] coverage) {
        this.m_Coverage = coverage;
    }

    public ClusStatistic getTargetStat() {
        return this.m_TargetStat;
    }

    public ClusStatistic getClusteringStat() {
        return this.m_ClusteringStat;
    }

    public void setTargetStat(ClusStatistic stat) {
        this.m_TargetStat = stat;
    }

    public void setNumericPrediction(double[] newPred) {
        RegressionStat stat = (RegressionStat)this.getTargetStat();
        for (int iTarget = 0; iTarget < stat.getNbAttributes(); ++iTarget) {
            stat.m_Means[iTarget] = newPred[iTarget];
            stat.m_SumValues[iTarget] = stat.m_Means[iTarget];
            stat.m_SumWeights[iTarget] = 1.0;
        }
        this.setTargetStat(stat);
    }

    public void setClusteringStat(ClusStatistic stat) {
        this.m_ClusteringStat = stat;
    }

    public void postProc() throws ClusException {
        this.m_TargetStat.calcMean();
        if (this.m_ROSModelInfo != null) {
            if (this.m_TargetStat instanceof RegressionStat) {
                for (Integer target : this.m_ROSModelInfo.getTargetsDisabled()) {
                    ((RegressionStat)this.m_TargetStat).m_Means[target.intValue()] = Double.NaN;
                }
            } else {
                throw new RuntimeException("si.ijs.kt.clus.algo.rules.ClusRule.postProc(): ROS only implemented for RegressionStat");
            }
        }
    }

    @Override
    public String getModelInfo() {
        return "Tests = " + this.getModelSize();
    }

    public double getTrainErrorScore() {
        if (this.m_TrainErrorScore != -1.0) {
            return this.m_TrainErrorScore;
        }
        System.err.println("getTrainErrorScore(): Error score not initialized!");
        return Double.POSITIVE_INFINITY;
    }

    public void setTrainErrorScore() throws ClusException {
        int nb_rows = this.m_Data.size();
        int nb_tar = this.m_TargetStat.getNbAttributes();
        if (this.m_TargetStat instanceof ClassificationStat) {
            int[] true_counts = new int[nb_tar];
            NominalAttrType[] targetAttrs = this.m_StatManager.getSchema().getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = this.m_Data.get(i);
                int[] prediction = this.predictWeighted(tuple).getNominalPred();
                for (int j = 0; j < nb_tar; ++j) {
                    if (prediction[j] != targetAttrs[j].getNominal(tuple)) continue;
                    int n = j;
                    true_counts[n] = true_counts[n] + 1;
                }
            }
            double sum_err = 0.0;
            for (int j = 0; j < nb_tar; ++j) {
                sum_err += (double)(nb_rows - true_counts[j]) / (double)nb_rows;
            }
            this.m_TrainErrorScore = sum_err / (double)nb_tar;
        } else if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.HIERARCHICAL) {
            double sum_diff = 0.0;
            ClusAttributeWeights weight = this.m_StatManager.getClusteringWeights();
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = this.m_Data.get(i);
                ClusStatistic prediction = this.predictWeighted(tuple);
                sum_diff = prediction.getAbsoluteDistance(tuple, weight);
            }
            this.m_TrainErrorScore = sum_diff / (double)nb_tar;
            if (this.m_TrainErrorScore > 1.0) {
                this.m_TrainErrorScore = 1.0;
            }
        } else if (this.m_TargetStat instanceof RegressionStat) {
            double norm = this.getSettings().getRules().getVarBasedDispNormWeight();
            ClusStatistic stat = this.m_StatManager.getTrainSetStat();
            NumericAttrType[] targetAttrs = this.m_StatManager.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
            int[] target_idx = new int[nb_tar];
            double[] variance = new double[nb_tar];
            double[] diff = new double[nb_tar];
            for (int j = 0; j < nb_tar; ++j) {
                target_idx[j] = targetAttrs[j].getArrayIndex();
                variance[j] = ((CombStat)stat).getRegressionStat().getVariance(target_idx[j]);
            }
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = this.m_Data.get(i);
                double[] prediction = this.predictWeighted(tuple).getNumericPred();
                for (int j = 0; j < nb_tar; ++j) {
                    int n = j;
                    diff[n] = diff[n] + Math.abs(prediction[j] - targetAttrs[j].getNumeric(tuple));
                }
            }
            double sum_diff = 0.0;
            for (int j = 0; j < nb_tar; ++j) {
                sum_diff += diff[j] / (double)nb_rows / Math.sqrt(variance[j]) / (norm * norm);
            }
            this.m_TrainErrorScore = sum_diff / (double)nb_tar;
            if (this.m_TrainErrorScore > 1.0) {
                this.m_TrainErrorScore = 1.0;
            }
        } else if (this.m_StatManager.getTargetMode() == ClusStatManager.Mode.TIME_SERIES) {
            double sum_diff = 0.0;
            ClusAttributeWeights weight = this.m_StatManager.getClusteringWeights();
            for (int i = 0; i < nb_rows; ++i) {
                DataTuple tuple = this.m_Data.get(i);
                ClusStatistic prediction = this.predictWeighted(tuple);
                sum_diff = prediction.getAbsoluteDistance(tuple, weight);
            }
            this.m_TrainErrorScore = sum_diff / (double)nb_tar;
            if (this.m_TrainErrorScore > 1.0) {
                this.m_TrainErrorScore = 1.0;
            }
        }
    }

    public double getOptWeight() {
        if (this.m_OptWeight != -1.0) {
            return this.m_OptWeight;
        }
        return -1.0;
    }

    public void setOptWeight(double weight) {
        this.m_OptWeight = weight;
    }

    public void computeDispersion(int mode) {
        CombStat combStat = (CombStat)this.m_StatManager.createStatistic(ClusAttrType.AttributeUseType.All);
        for (int i = 0; i < this.m_Data.size(); ++i) {
            combStat.updateWeighted(this.m_Data.get(i), 0);
        }
        combStat.calcMean();
        this.m_CombStat[mode] = combStat;
        this.m_Coverage[mode] = this.m_Data.size();
    }

    public void addDataTuple(DataTuple tuple) {
        this.m_Data.add(tuple);
    }

    public void removeDataTuples() {
        this.m_Data.clear();
    }

    public ArrayList getData() {
        return this.m_Data;
    }

    public void setError(ClusErrorList error, int subset) {
        if (this.m_Errors == null) {
            this.m_Errors = new ClusErrorList[2];
        }
        this.m_Errors[subset] = error;
    }

    public void addError(ClusErrorList error, int subset) {
        if (this.m_Errors == null) {
            this.setError(error, subset);
        } else {
            this.m_Errors[subset].addErrors(error);
        }
    }

    public ClusErrorList getError(int subset) {
        if (this.m_Errors == null) {
            return null;
        }
        return this.m_Errors[subset];
    }

    public boolean hasErrors() {
        return this.m_Errors != null;
    }

    public boolean hasPrediction() {
        return this.m_TargetStat.isValidPrediction();
    }

    public boolean isRegularRule() {
        return true;
    }

    public void computeCoverStat(RowData data, ClusStatistic stat) throws ClusException {
        int nb = data.getNbRows();
        stat.setSDataSize(nb);
        for (int i = 0; i < nb; ++i) {
            DataTuple tuple = data.getTuple(i);
            if (!this.covers(tuple)) continue;
            stat.updateWeighted(tuple, i);
        }
        stat.optimizePreCalc(data);
    }

    @Override
    public ClusModel prune(int prunetype) {
        return this;
    }

    public void retrieveStatistics(ArrayList list) {
    }

    public float overlap(ClusRule other) {
        BitSet bs = (BitSet)this.m_CoverageBits.clone();
        bs.and(other.m_CoverageBits);
        return bs.cardinality();
    }

    public boolean coversCorrect(DataTuple tuple) {
        if (this.m_CoverageBits.get(tuple.getIndex())) {
            return this.m_CoverageCorrectBits.get(tuple.getIndex());
        }
        return false;
    }

    public int coversIncorrect() {
        BitSet tmp = (BitSet)this.m_CoverageBits.clone();
        tmp.and(this.m_CoverageCorrectBits);
        return tmp.cardinality();
    }

    public void setROSModelInfo(ClusROSModelInfo info) {
        this.m_ROSModelInfo = info;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        this.printModel(pw);
        String s = out.toString();
        out = null;
        pw = null;
        return s;
    }
}

