/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.kNN.methods.vpTree;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.math3.random.RandomData;
import org.apache.commons.math3.random.RandomDataImpl;
import si.ijs.kt.clus.algo.kNN.methods.NNStack;
import si.ijs.kt.clus.algo.kNN.methods.SearchAlgorithm;
import si.ijs.kt.clus.algo.kNN.methods.vpTree.VPItem;
import si.ijs.kt.clus.algo.kNN.methods.vpTree.VPNode;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.distance.primitive.SearchDistance;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.section.SettingsKNN;
import si.ijs.kt.clus.util.exception.ClusException;

public class VPTree
extends SearchAlgorithm {
    private VPNode m_Root;
    private double m_Tau = 100.0;
    private NNStack m_Stack;
    private RandomData m_Random = new RandomDataImpl();
    private int m_NbNeighbors;

    public VPTree(ClusRun run, SearchDistance dist) {
        super(run, dist);
    }

    @Override
    public void build(int k) throws ClusException, IOException, InterruptedException {
        RowData data = this.getRun().getDataSet(0);
        LinkedList<VPItem> list = new LinkedList<VPItem>();
        for (DataTuple tuple : data.getData()) {
            list.add(new VPItem(tuple));
        }
        this.m_Root = this.recursiveBuild(list);
    }

    private VPNode recursiveBuild(LinkedList<VPItem> list) throws ClusException {
        VPNode node;
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() <= 2) {
            node = new VPNode(list.poll());
        } else {
            node = new VPNode(this.selectVPItem(list));
            list.remove(node.getVPItem());
        }
        for (VPItem item : list) {
            item.setItemsHistory(this.getDistance().calcDistance(node.getVPItem().getTuple(), item.getTuple()));
        }
        node.setMedian(this.getMedian(list));
        if (list.size() > 0) {
            LinkedList<VPItem> leftList = new LinkedList<VPItem>();
            LinkedList<VPItem> rightList = new LinkedList<VPItem>();
            for (VPItem item : list) {
                if (item.getItemsHistory() < node.getMedian()) {
                    leftList.add(item);
                    node.getBounds()[0] = Math.min(node.getBounds()[0], item.getItemsHistory());
                    node.getBounds()[1] = Math.max(node.getBounds()[1], item.getItemsHistory());
                    continue;
                }
                rightList.add(item);
                node.getBounds()[2] = Math.min(node.getBounds()[2], item.getItemsHistory());
                node.getBounds()[3] = Math.max(node.getBounds()[3], item.getItemsHistory());
            }
            list.clear();
            node.setLeftSubtree(this.recursiveBuild(leftList));
            node.setRightSubtree(this.recursiveBuild(rightList));
        }
        return node;
    }

    private VPItem selectVPItem(LinkedList<VPItem> list) {
        int sampleSize = (int)Math.max((double)Math.min(list.size(), 3), 0.1 * (double)list.size());
        int testSize = (int)Math.max((double)Math.min(list.size(), 2), 0.08 * (double)list.size());
        Object[] sample = this.m_Random.nextSample(list, sampleSize);
        VPItem vantagePoint = null;
        double bestSpread = -1.0;
        for (Object a : sample) {
            double median;
            VPItem item = (VPItem)a;
            Object[] testSample = this.m_Random.nextSample(list, testSize);
            double variance = this.calcVariance(testSample, item, median = this.calcMedian(testSample, item));
            if (variance <= bestSpread) continue;
            bestSpread = variance;
            vantagePoint = item;
        }
        return vantagePoint;
    }

    private double getMedian(LinkedList<VPItem> list) {
        double median = 0.0;
        for (VPItem item : list) {
            median += item.getItemsHistory();
        }
        return median / (double)list.size();
    }

    private double calcMedian(Object[] list, VPItem vp) {
        double median = 0.0;
        for (Object item : list) {
            median += ((VPItem)item).getItemsHistory();
        }
        return median / (double)list.length;
    }

    private double calcVariance(Object[] list, VPItem vp, double median) {
        double variance = 0.0;
        for (Object item : list) {
            variance += Math.pow(((VPItem)item).getItemsHistory() - median, 2.0);
        }
        return variance / (double)list.length;
    }

    @Override
    public LinkedList<DataTuple> returnNNs(DataTuple tuple, int k) throws ClusException {
        this.m_NbNeighbors = k;
        this.m_Tau = Double.MAX_VALUE;
        this.m_Stack = new NNStack(this.m_NbNeighbors);
        this.search(this.m_Root, tuple);
        return this.m_Stack.returnStack();
    }

    private void search(VPNode n, DataTuple q) throws ClusException {
        if (n == null) {
            return;
        }
        SearchAlgorithm.operationsCount[1] = SearchAlgorithm.operationsCount[1] + 1;
        double x = this.getDistance().calcDistance(n.getVPItem().getTuple(), q);
        this.m_Stack.addToStack(n.getVPItem().getTuple(), x);
        this.m_Tau = this.m_Stack.getWorstNearestDistance();
        double middle = (n.getBounds()[1] + n.getBounds()[2]) / 2.0;
        if (x < middle) {
            if (x <= n.getBounds()[1] + this.m_Tau && n.getLeftSubtree() != null) {
                this.search(n.getLeftSubtree(), q);
            }
            if (x >= n.getBounds()[2] - this.m_Tau && n.getRightSubtree() != null) {
                this.search(n.getRightSubtree(), q);
            }
        } else {
            if (x >= n.getBounds()[2] - this.m_Tau && n.getRightSubtree() != null) {
                this.search(n.getRightSubtree(), q);
            }
            if (x <= n.getBounds()[1] + this.m_Tau && n.getLeftSubtree() != null) {
                this.search(n.getLeftSubtree(), q);
            }
        }
    }

    @Override
    public void buildForMissingTargetImputation(int k, int[] trainingExamplesWithMissing, SettingsKNN sett) {
        throw new NotImplementedException("Use OracleBruteForce");
    }
}

