/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.kNN.methods.kdTree;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.lang.NotImplementedException;
import si.ijs.kt.clus.algo.kNN.methods.NNStack;
import si.ijs.kt.clus.algo.kNN.methods.SearchAlgorithm;
import si.ijs.kt.clus.algo.kNN.methods.kdTree.KDNode;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.distance.primitive.SearchDistance;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.section.SettingsKNN;
import si.ijs.kt.clus.util.exception.ClusException;

public class KDTree
extends SearchAlgorithm {
    private KDNode m_Root;
    protected int m_MaxTuples = 1;
    private int m_kNeighbors = 1;
    protected ClusRun m_Run;
    protected NNStack m_Stack;

    public KDTree(ClusRun run, SearchDistance distance) {
        super(run, distance);
        this.m_Run = run;
    }

    @Override
    public void build(int k) throws ClusException, IOException, InterruptedException {
        RowData data = this.getRun().getDataSet(0);
        LinkedList<DataTuple> tuples = new LinkedList<DataTuple>();
        for (DataTuple tuple : data.getData()) {
            tuples.add(tuple);
        }
        this.m_Root = new KDNode(this, 0);
        this.m_Root.setTuples(tuples);
        this.m_Root.build(0);
    }

    @Override
    public LinkedList<DataTuple> returnNNs(DataTuple tuple, int k) throws ClusException {
        this.m_kNeighbors = k;
        this.m_Stack = new NNStack(this.m_kNeighbors);
        this.m_Root.find(tuple);
        return this.m_Stack.returnStack();
    }

    public int getK() {
        return this.m_kNeighbors;
    }

    public NNStack getStack() {
        return this.m_Stack;
    }

    @Override
    public ClusRun getRun() {
        return this.m_Run;
    }

    public int getMaxTuples() {
        return this.m_MaxTuples;
    }

    @Override
    public void buildForMissingTargetImputation(int k, int[] trainingExamplesWithMissing, SettingsKNN sett) {
        throw new NotImplementedException("Use OracleBruteForce");
    }
}

