/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.kNN.methods.bfMethod;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import si.ijs.kt.clus.algo.kNN.methods.NN;
import si.ijs.kt.clus.algo.kNN.methods.bfMethod.ArrayOfArraysIterator;
import si.ijs.kt.clus.algo.kNN.methods.bfMethod.BruteForce;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.distance.primitive.SearchDistance;
import si.ijs.kt.clus.ext.featureRanking.relief.ClusReliefFeatureRanking;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.NearestNeighbour;
import si.ijs.kt.clus.ext.featureRanking.relief.nearestNeighbour.SaveLoadNeighbours;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsKNN;
import si.ijs.kt.clus.util.exception.ClusException;

public class OracleBruteForce
extends BruteForce {
    private HashMap<Integer, HashMap<Integer, NearestNeighbour[][]>> m_NearestNeighbours = new HashMap();
    private DataTuple[] m_ChosenInstancesTrain;
    private DataTuple[] m_ChosenInstancesTest;

    public OracleBruteForce(ClusRun run, SearchDistance dist) {
        super(run, dist);
        this.m_NearestNeighbours.put(SaveLoadNeighbours.DUMMY_TARGET, new HashMap());
    }

    @Override
    public void buildForMissingTargetImputation(int k, int[] trainingExamplesWithMissing, SettingsKNN sett) {
        try {
            this.m_ListTrain = this.getRun().getDataSet(0).getData();
        }
        catch (IOException | InterruptedException | ClusException e1) {
            e1.printStackTrace();
        }
        if (trainingExamplesWithMissing != null) {
            int[] chosenTrainingInstances = sett.getChosenIntancesTrain(this.m_ListTrain.length);
            Arrays.sort(chosenTrainingInstances);
            ArrayList<Integer> kept = new ArrayList<Integer>();
            int iWithMissing = 0;
            int iTraining = 0;
            while (iWithMissing < trainingExamplesWithMissing.length && iTraining < chosenTrainingInstances.length) {
                int missing = trainingExamplesWithMissing[iWithMissing];
                int training = chosenTrainingInstances[iTraining];
                if (missing == training) {
                    kept.add(missing);
                    ++iWithMissing;
                    ++iTraining;
                    continue;
                }
                if (missing < training) {
                    ++iWithMissing;
                    continue;
                }
                ++iTraining;
            }
            int[] filtered = new int[kept.size()];
            for (int i = 0; i < filtered.length; ++i) {
                filtered[i] = (Integer)kept.get(i);
            }
            if (trainingExamplesWithMissing.length != filtered.length) {
                throw new RuntimeException("Choosen instances should contain all examples with missing target data! Reconsider your life choices.");
            }
            sett.setChosenIntancesTrain(filtered);
        }
        try {
            this.build(k, true);
        }
        catch (IOException | InterruptedException | ClusException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void build(int k) throws ClusException, IOException, InterruptedException {
        this.build(k, false);
    }

    public void build(int k, boolean skipFirstNeighbour) throws ClusException, IOException, InterruptedException {
        int actualK;
        int i;
        if (this.m_ListTrain == null) {
            this.m_ListTrain = this.getRun().getDataSet(0).getData();
        }
        for (DataTuple tuple : this.m_ListTrain) {
            tuple.setTraining(true);
        }
        if (this.getRun().getDataSet(1) != null) {
            this.m_ListTest = this.getRun().getDataSet(1).getData();
            for (DataTuple tuple : this.m_ListTest) {
                tuple.setTesting(true);
            }
        } else {
            this.m_ListTest = new DataTuple[0];
        }
        Settings sett = this.getRun().getStatManager().getSettings();
        int[] tmp = sett.getKNN().getChosenIntancesTrain(this.m_ListTrain.length);
        this.m_ChosenInstancesTrain = new DataTuple[tmp.length];
        for (i = 0; i < this.m_ChosenInstancesTrain.length; ++i) {
            this.m_ChosenInstancesTrain[i] = this.m_ListTrain[tmp[i]];
        }
        tmp = sett.getKNN().getChosenIntancesTest(this.m_ListTest.length);
        this.m_ChosenInstancesTest = new DataTuple[tmp.length];
        for (i = 0; i < this.m_ChosenInstancesTest.length; ++i) {
            this.m_ChosenInstancesTest[i] = this.m_ListTest[tmp[i]];
        }
        int n = actualK = skipFirstNeighbour ? k + 1 : k;
        if (sett.getKNN().shouldLoadNeighbours()) {
            ClusReliefFeatureRanking.printMessage("Loading nearest neighbours from file(s)", 1, sett.getGeneral().getVerbose());
            SaveLoadNeighbours nnLoader = new SaveLoadNeighbours(sett.getKNN().getLoadNeighboursFiles(), null);
            this.m_NearestNeighbours = nnLoader.loadNeighboursFromFiles();
            SaveLoadNeighbours.assureIsFlatNearestNeighbours(this.m_NearestNeighbours);
        } else {
            int percentStep;
            ClusReliefFeatureRanking.printMessage("Computing nearest neighbours", 1, sett.getGeneral().getVerbose());
            int counter = 0;
            int nInstances = this.m_ChosenInstancesTrain.length + this.m_ChosenInstancesTest.length;
            int percents = percentStep = 10;
            for (DataTuple tuple : new ArrayOfArraysIterator<DataTuple>(new DataTuple[][]{this.m_ChosenInstancesTrain, this.m_ChosenInstancesTest})) {
                ++counter;
                NN[] temp = super.returnPureNNs(tuple, actualK);
                temp = Arrays.copyOfRange(temp, temp.length - k, temp.length);
                NearestNeighbour[] nns = new NearestNeighbour[temp.length];
                for (int n2 = 0; n2 < nns.length; ++n2) {
                    nns[n2] = new NearestNeighbour(temp[n2].getTuple().getDatasetIndex(), temp[n2].getDistance());
                }
                this.m_NearestNeighbours.get(SaveLoadNeighbours.DUMMY_TARGET).put(this.getModifiedIndex(tuple), new NearestNeighbour[][]{nns});
                int percentsNow = 100 * counter / nInstances;
                if (percentsNow < percents) continue;
                percentsNow -= Math.floorMod(percentsNow, percentStep);
                ClusReliefFeatureRanking.printMessage(String.format("Computed %d percents of nearest neighbours.", percentsNow), 1, sett.getGeneral().getVerbose());
                percents = percentsNow + percentStep;
            }
            if (percents <= 100) {
                ClusReliefFeatureRanking.printMessage("Computed 100 percents of nearest neighbours.", 1, sett.getGeneral().getVerbose());
            }
        }
        if (sett.getKNN().shouldSaveNeighbours()) {
            SaveLoadNeighbours nnSaver = new SaveLoadNeighbours(null, sett.getKNN().getSaveNeighboursFile());
            nnSaver.saveNeighboursToFile(this.m_NearestNeighbours);
        }
    }

    @Override
    public LinkedList<DataTuple> returnNNs(DataTuple tuple, int k) throws ClusException {
        LinkedList<DataTuple> nns = new LinkedList<DataTuple>();
        int index = this.getModifiedIndex(tuple);
        for (int i = 0; i < k; ++i) {
            int nn_index = this.m_NearestNeighbours.get(SaveLoadNeighbours.DUMMY_TARGET).get(index)[0][i].getIndexInDataset();
            nns.add(this.m_ListTrain[nn_index]);
        }
        return nns;
    }

    private int getModifiedIndex(DataTuple tuple) {
        if (tuple.isTraining()) {
            return tuple.getDatasetIndex();
        }
        if (tuple.isTesting()) {
            return this.m_ListTrain.length + tuple.getDatasetIndex();
        }
        throw new RuntimeException("The tuple is neither training nor testing instance.");
    }
}

