/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.kNN.methods;

import java.util.Arrays;
import java.util.LinkedList;
import si.ijs.kt.clus.algo.kNN.methods.NN;
import si.ijs.kt.clus.data.rows.DataTuple;

public class NNStack {
    private int m_NbNeighbors;
    private NN[] m_NearestNeighbors;

    public NNStack(int k) {
        this.m_NbNeighbors = k;
        this.m_NearestNeighbors = new NN[k + 1];
    }

    public void addToStack(DataTuple tuple, double dist) {
        for (int j = this.m_NbNeighbors - 1; j >= 0; --j) {
            if (this.m_NearestNeighbors[j] == null) continue;
            if (this.m_NearestNeighbors[j].getDistance() > dist) {
                this.m_NearestNeighbors[j + 1] = this.m_NearestNeighbors[j];
                continue;
            }
            this.m_NearestNeighbors[j + 1] = new NN(tuple, dist);
            return;
        }
        this.m_NearestNeighbors[0] = new NN(tuple, dist);
    }

    public double getWorstNearestDistance() {
        return this.m_NearestNeighbors[this.m_NbNeighbors - 1] == null ? Double.MAX_VALUE : this.m_NearestNeighbors[this.m_NbNeighbors - 1].getDistance();
    }

    public boolean enoughNeighbours() {
        return this.m_NearestNeighbors[this.m_NbNeighbors - 1] != null;
    }

    public LinkedList<DataTuple> returnStack() {
        LinkedList<DataTuple> nns = new LinkedList<DataTuple>();
        for (int i = 0; i < this.m_NbNeighbors; ++i) {
            nns.add(this.m_NearestNeighbors[i].getTuple());
        }
        return nns;
    }

    public NN[] returnPureStack() {
        return Arrays.copyOf(this.m_NearestNeighbors, this.m_NbNeighbors);
    }
}

