/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo.kNN;

import si.ijs.kt.clus.algo.kNN.distance.valentin.NominalStatistic;
import si.ijs.kt.clus.algo.kNN.distance.valentin.NumericStatistic;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.util.ClusLogger;

@Deprecated
public class KNNStatistics {
    private DataTuple[] $prototypes;

    public KNNStatistics(RowData data) {
        this.calcMeasures(data);
        this.printPrototype(0, data);
    }

    public void calcMeasures(RowData data) {
        int i;
        ClusSchema schema = data.getSchema();
        ClusAttrType[] attrs = schema.getDescriptiveAttributes();
        this.$prototypes = new DataTuple[1];
        for (i = 0; i < this.$prototypes.length; ++i) {
            this.$prototypes[i] = new DataTuple(schema);
        }
        for (i = 0; i < attrs.length; ++i) {
            if (attrs[i].getAttributeType().equals((Object)ClusAttrType.AttributeType.Nominal)) {
                this.calcNominalMeasures(data, (NominalAttrType)attrs[i]);
                continue;
            }
            if (!attrs[i].getAttributeType().equals((Object)ClusAttrType.AttributeType.Numeric)) continue;
            this.calcNumericMeasures(data, (NumericAttrType)attrs[i]);
        }
    }

    public void calcNominalMeasures(RowData data, NominalAttrType attr) {
        int[] occurences = new int[attr.getNbValues()];
        int aTargetValues = this.$prototypes.length;
        int[][] p_occs = new int[attr.getNbValues()][aTargetValues];
        NominalStatistic stat = new NominalStatistic();
        int nbr = data.getNbRows();
        for (int i = 0; i < nbr; ++i) {
            int curVal = attr.getNominal(data.getTuple(i));
            int curTargetVal = data.getTuple(i).getClassification();
            if (curVal == attr.getNbValues()) continue;
            int n = curVal;
            occurences[n] = occurences[n] + 1;
            int[] nArray = p_occs[curVal];
            int n2 = curTargetVal;
            nArray[n2] = nArray[n2] + 1;
        }
        int max = occurences[0];
        int[] maxs = new int[aTargetValues];
        int index_max = 0;
        int[] index_maxs = new int[aTargetValues];
        for (int i = 1; i < attr.getNbValues(); ++i) {
            if (max < occurences[i]) {
                max = occurences[i];
                index_max = i;
            }
            for (int j = 1; j < aTargetValues; ++j) {
                if (maxs[j] >= p_occs[i][j]) continue;
                maxs[j] = p_occs[i][j];
                index_maxs[j] = i;
            }
        }
        stat.setMean(index_max);
        attr.setStatistic(stat);
        ClusLogger.info("Prototype values for attribute " + attr.getName() + ":");
        int idx = attr.getArrayIndex();
        for (int i = 0; i < aTargetValues; ++i) {
            System.out.print(index_maxs[i] + ",");
            this.$prototypes[i].setIntVal(index_maxs[i], idx);
        }
        ClusLogger.info();
    }

    public void calcNumericMeasures(RowData data, NumericAttrType attr) {
        double curVal;
        int i;
        int nbr;
        NumericStatistic stat = new NumericStatistic();
        int actualnbr = nbr = data.getNbRows();
        double mean = 0.0;
        int aTargetValues = this.$prototypes.length;
        double[] means = new double[aTargetValues];
        double[] p_occs = new double[aTargetValues];
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (i = 0; i < nbr; ++i) {
            curVal = attr.getNumeric(data.getTuple(i));
            int curTargetVal = data.getTuple(i).getClassification();
            if (curVal == Double.NaN) {
                --actualnbr;
                ClusLogger.info("Fuck");
                continue;
            }
            if (curVal < min) {
                min = curVal;
            }
            if (curVal > max) {
                max = curVal;
            }
            int n = curTargetVal;
            means[n] = means[n] + curVal;
            int n2 = curTargetVal;
            p_occs[n2] = p_occs[n2] + 1.0;
        }
        for (i = 0; i < aTargetValues; ++i) {
            means[i] = means[i] / p_occs[i];
            mean += means[i];
        }
        mean /= (double)aTargetValues;
        double variance = 0.0;
        for (i = 0; i < nbr; ++i) {
            curVal = attr.getNumeric(data.getTuple(i));
            if (curVal == Double.NaN) continue;
            variance += Math.pow(curVal - mean, 2.0);
        }
        stat.setMean(mean);
        stat.setMax(max);
        stat.setMin(min);
        stat.setVariance(variance /= (double)actualnbr);
        attr.setStatistic(stat);
        ClusLogger.info("Prototype values for attribute " + attr.getName() + ":");
        int idx = attr.getArrayIndex();
        for (int i2 = 0; i2 < aTargetValues; ++i2) {
            System.out.print(means[i2] + ",");
            this.$prototypes[i2].setDoubleVal(means[i2], idx);
        }
        ClusLogger.info();
    }

    public DataTuple[] getPrototypes() {
        return this.$prototypes;
    }

    public DataTuple getPrototype(int idx) {
        return this.$prototypes[idx];
    }

    public void printPrototype(int idx, RowData data) {
        DataTuple t = this.$prototypes[idx];
        ClusSchema schema = data.getSchema();
        ClusAttrType[] attrs = schema.getDescriptiveAttributes();
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].getAttributeType().equals((Object)ClusAttrType.AttributeType.Nominal)) {
                System.out.print(attrs[i].getNominal(t) + ",");
                continue;
            }
            if (!attrs[i].getAttributeType().equals((Object)ClusAttrType.AttributeType.Numeric)) continue;
            System.out.print(attrs[i].getNumeric(t) + ",");
        }
        ClusLogger.info(")");
    }
}

