/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.algo;

import java.io.IOException;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.io.ClusModelCollectionIO;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class ClusInductionAlgorithm {
    protected ClusSchema m_Schema;
    protected ClusStatManager m_StatManager;

    public ClusInductionAlgorithm(ClusSchema schema, Settings sett) throws ClusException, IOException {
        this.m_Schema = schema;
        this.m_StatManager = new ClusStatManager(schema, sett);
    }

    public ClusInductionAlgorithm(ClusInductionAlgorithm other) {
        this.m_Schema = other.m_Schema;
        this.m_StatManager = other.m_StatManager;
    }

    public ClusInductionAlgorithm(ClusInductionAlgorithm other, ClusStatManager mgr) {
        this.m_Schema = other.m_Schema;
        this.m_StatManager = mgr;
    }

    public ClusSchema getSchema() {
        return this.m_Schema;
    }

    public ClusStatManager getStatManager() {
        return this.m_StatManager;
    }

    public Settings getSettings() {
        return this.m_StatManager.getSettings();
    }

    public void initialize() throws ClusException, IOException {
        this.m_StatManager.initStatisticAndStatManager();
    }

    public void getPreprocs(DataPreprocs pps) {
        this.m_StatManager.getPreprocs(pps);
    }

    public boolean isModelWriter() {
        return false;
    }

    public void writeModel(ClusModelCollectionIO strm) throws IOException, ClusException {
    }

    public ClusData createData() {
        return new RowData(this.m_Schema);
    }

    public void induceAll(ClusRun cr) throws ClusException, IOException, InterruptedException, Exception {
        ClusModel model;
        if (cr.getStatManager().getSettings().getModel().loadFromFile()) {
            String fname = cr.getStatManager().getSettings().getGeneric().getFileAbsolute(this.getSettings().getGeneric().getAppName() + ".model");
            ClusModelCollectionIO io = ClusModelCollectionIO.load(fname);
            model = io.getModel("Original");
        } else {
            model = this.induceSingleUnpruned(cr);
        }
        ClusModelInfo model_info = cr.addModelInfo(1);
        model_info.setModel(model);
    }

    public abstract ClusModel induceSingleUnpruned(ClusRun var1) throws ClusException, IOException, InterruptedException, Exception;

    public void initializeHeuristic() {
    }

    public ClusStatistic createTotalClusteringStat(RowData data) throws ClusException {
        ClusStatistic stat = this.m_StatManager.createClusteringStat();
        stat.setSDataSize(data.getNbRows());
        data.calcTotalStat(stat);
        stat.optimizePreCalc(data);
        return stat;
    }

    public ClusStatistic createTotalTargetStat(RowData data) throws ClusException {
        ClusStatistic stat = this.m_StatManager.createTargetStat();
        stat.setSDataSize(data.getNbRows());
        data.calcTotalStat(stat);
        stat.optimizePreCalc(data);
        return stat;
    }
}

