/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit.searchAlgorithm;

import java.util.ArrayList;
import si.ijs.kt.clus.addon.sit.Evaluator;
import si.ijs.kt.clus.addon.sit.TargetSet;
import si.ijs.kt.clus.addon.sit.mtLearner.MTLearner;
import si.ijs.kt.clus.addon.sit.searchAlgorithm.SearchAlgorithm;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.exception.ClusException;

public abstract class SearchAlgorithmImpl
implements SearchAlgorithm {
    protected MTLearner learner;
    protected Settings m_Sett;

    @Override
    public void setMTLearner(MTLearner learner) {
        this.learner = learner;
    }

    @Override
    public void setSettings(Settings s) {
        this.m_Sett = s;
    }

    protected double eval(TargetSet tset, ClusAttrType mainTarget) throws ClusException {
        int nbFolds = this.learner.initLOOXVal();
        ArrayList<RowData[]> folds = new ArrayList<RowData[]>();
        for (int f = 0; f < nbFolds; ++f) {
            folds.add(this.learner.LearnModel(tset, f));
        }
        String error = this.m_Sett.getSIT().getError();
        if (error.equals("MSE")) {
            return 1.0 - Evaluator.getMSE(folds, mainTarget.getArrayIndex());
        }
        if (error.equals("MisclassificationError")) {
            return 1.0 - Evaluator.getMisclassificationError(folds, mainTarget.getArrayIndex());
        }
        return Evaluator.getPearsonCorrelation(folds, mainTarget.getArrayIndex());
    }
}

