/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit.mtLearner;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import si.ijs.kt.clus.addon.sit.TargetSet;
import si.ijs.kt.clus.addon.sit.mtLearner.MTLearnerImpl;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.util.ClusLogger;

public class KNNLearner
extends MTLearnerImpl {
    @Override
    protected RowData[] LearnModel(TargetSet targets, RowData train, RowData test) {
        String appName = this.m_Sett.getGeneric().getAppName();
        this.writeCSV("train.csv" + appName, targets, train);
        this.writeCSV("test.csv" + appName, targets, test);
        NumericAttrType[] descriptive = test.m_Schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive);
        int nrFeatures = descriptive.length;
        int nrTargets = targets.size();
        try {
            int benchmk_cnt = train.getNbRows();
            String[] commands = new String[]{"/home/beau/SIT_evaluation/gent/top40/ga_basic_SIT", "config.txt", test.getNbRows() + "", nrFeatures + "", nrTargets + "", "train.csv" + appName, "test.csv" + appName, "result.csv" + appName, benchmk_cnt + ""};
            for (int i = 0; i < commands.length; ++i) {
                System.out.print(commands[i] + " ");
            }
            Process child = Runtime.getRuntime().exec(commands);
            child.waitFor();
        }
        catch (IOException benchmk_cnt) {
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        RowData predictions = new RowData(test.m_Schema, test.getNbRows());
        this.readResult(targets, predictions);
        RowData[] result = new RowData[]{test, predictions};
        return result;
    }

    @Override
    public String getName() {
        return "KNN";
    }

    private RowData readResult(TargetSet targets, RowData result) {
        try {
            FileReader input = new FileReader("result.csv" + this.m_Sett.getGeneric().getAppName());
            BufferedReader bufRead = new BufferedReader(input);
            String line = bufRead.readLine();
            int count = 0;
            while (line != null) {
                DataTuple t = this.parseLine(line, targets, result.m_Schema);
                result.setTuple(t, count);
                ++count;
                line = bufRead.readLine();
            }
            bufRead.close();
            if (count == 0) {
                System.err.println("No results from KNN found???");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ClusLogger.info("no results file found?");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private DataTuple parseLine(String line, TargetSet targets, ClusSchema schema) {
        DataTuple t = new DataTuple(schema);
        Iterator trgts = targets.iterator();
        String[] values = line.split(",");
        Double[] doubles = new Double[values.length];
        for (int i = 0; i < values.length; ++i) {
            doubles[i] = Double.parseDouble(values[i]);
        }
        int count = 0;
        while (trgts.hasNext()) {
            NumericAttrType atr = (NumericAttrType)trgts.next();
            atr.setNumeric(t, doubles[count]);
            ++count;
        }
        return t;
    }

    private void writeCSV(String fname, TargetSet targets, RowData data) {
        ClusSchema schema = this.m_Data.getSchema();
        NumericAttrType[] descriptive = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Descriptive);
        PrintWriter p = null;
        try {
            p = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fname)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        for (int ti = 0; ti < data.getNbRows(); ++ti) {
            double d;
            DataTuple t = data.getTuple(ti);
            for (int i = 0; i < descriptive.length; ++i) {
                d = descriptive[i].getNumeric(t);
                p.print(d + ",");
            }
            Iterator i = targets.iterator();
            while (i.hasNext()) {
                d = ((ClusAttrType)i.next()).getNumeric(t);
                if (i.hasNext()) {
                    p.print(d + ",");
                    continue;
                }
                p.print(d);
            }
            p.println();
        }
        p.flush();
    }
}

