/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.sit;

import java.util.ArrayList;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.error.MSError;
import si.ijs.kt.clus.error.MisclassificationError;
import si.ijs.kt.clus.error.PearsonCorrelation;
import si.ijs.kt.clus.error.RMSError;
import si.ijs.kt.clus.error.RelativeError;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.util.exception.ClusException;

public final class Evaluator {
    public static final double getPearsonCorrelation(ArrayList<RowData[]> folds, int errorIdx) throws ClusException {
        RowData[] temp = folds.get(0);
        ClusSchema schema = temp[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        PearsonCorrelation error = new PearsonCorrelation(parent, num);
        parent.addError(error);
        for (int f = 0; f < folds.size(); ++f) {
            RowData[] fold = folds.get(f);
            for (int t = 0; t < fold[0].getNbRows(); ++t) {
                DataTuple tuple_real = fold[0].getTuple(t);
                DataTuple tuple_prediction = fold[1].getTuple(t);
                parent.addExample(tuple_real, tuple_prediction);
            }
        }
        if (errorIdx == -1) {
            return 0.0;
        }
        return error.getModelErrorComponent(errorIdx);
    }

    public static final double getPearsonCorrelation(RowData[] data, int errorIdx) throws ClusException {
        if (errorIdx == -1) {
            return 0.0;
        }
        ClusSchema schema = data[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        PearsonCorrelation error = new PearsonCorrelation(parent, num);
        parent.addError(error);
        for (int t = 0; t < data[0].getNbRows(); ++t) {
            DataTuple tuple_real = data[0].getTuple(t);
            DataTuple tuple_prediction = data[1].getTuple(t);
            parent.addExample(tuple_real, tuple_prediction);
        }
        return error.getModelErrorComponent(errorIdx);
    }

    public static final double getMSE(RowData[] data, int errorIdx) throws ClusException {
        if (errorIdx == -1) {
            return 0.0;
        }
        ClusSchema schema = data[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        MSError error = new MSError(parent, num);
        parent.addError(error);
        for (int t = 0; t < data[0].getNbRows(); ++t) {
            DataTuple tuple_real = data[0].getTuple(t);
            DataTuple tuple_prediction = data[1].getTuple(t);
            parent.addExample(tuple_real, tuple_prediction);
        }
        double err = error.getModelErrorComponent(errorIdx);
        return err;
    }

    public static final MSError getMSE(RowData[] data) throws ClusException {
        ClusSchema schema = data[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        MSError error = new MSError(parent, num);
        parent.addError(error);
        for (int t = 0; t < data[0].getNbRows(); ++t) {
            DataTuple tuple_real = data[0].getTuple(t);
            DataTuple tuple_prediction = data[1].getTuple(t);
            parent.addExample(tuple_real, tuple_prediction);
        }
        return error;
    }

    public static final double getMSE(ArrayList<RowData[]> folds, int errorIdx) throws ClusException {
        RowData[] temp = folds.get(0);
        ClusSchema schema = temp[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        MSError error = new MSError(parent, num);
        parent.addError(error);
        for (int f = 0; f < folds.size(); ++f) {
            RowData[] fold = folds.get(f);
            for (int t = 0; t < fold[0].getNbRows(); ++t) {
                DataTuple tuple_real = fold[0].getTuple(t);
                DataTuple tuple_prediction = fold[1].getTuple(t);
                parent.addExample(tuple_real, tuple_prediction);
            }
        }
        if (errorIdx == -1) {
            return 0.0;
        }
        return error.getModelErrorComponent(errorIdx);
    }

    public static final double getMisclassificationError(ArrayList<RowData[]> folds, int errorIdx) throws ClusException {
        RowData[] temp = folds.get(0);
        ClusSchema schema = temp[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NominalAttrType[] nom = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.All);
        MisclassificationError error = new MisclassificationError(parent, nom);
        parent.addError(error);
        for (int f = 0; f < folds.size(); ++f) {
            RowData[] fold = folds.get(f);
            for (int t = 0; t < fold[0].getNbRows(); ++t) {
                DataTuple tuple_real = fold[0].getTuple(t);
                DataTuple tuple_prediction = fold[1].getTuple(t);
                parent.addExample(tuple_real, tuple_prediction);
            }
        }
        if (errorIdx == -1) {
            return 0.0;
        }
        return error.getModelErrorComponent(errorIdx);
    }

    public static final double getMisclassificationError(RowData[] data, int errorIdx) throws ClusException {
        if (errorIdx == -1) {
            return 0.0;
        }
        ClusSchema schema = data[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NominalAttrType[] nom = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.All);
        MisclassificationError error = new MisclassificationError(parent, nom);
        parent.addError(error);
        for (int t = 0; t < data[0].getNbRows(); ++t) {
            DataTuple tuple_real = data[0].getTuple(t);
            DataTuple tuple_prediction = data[1].getTuple(t);
            parent.addExample(tuple_real, tuple_prediction);
        }
        double err = error.getModelErrorComponent(errorIdx);
        return err;
    }

    public static final double getRelativeError(ArrayList<RowData[]> folds, int errorIdx) throws ClusException {
        RowData[] temp = folds.get(0);
        ClusSchema schema = temp[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        RelativeError error = new RelativeError(parent, num);
        parent.addError(error);
        for (int f = 0; f < folds.size(); ++f) {
            RowData[] fold = folds.get(f);
            for (int t = 0; t < fold[0].getNbRows(); ++t) {
                DataTuple tuple_real = fold[0].getTuple(t);
                DataTuple tuple_prediction = fold[1].getTuple(t);
                parent.addExample(tuple_real, tuple_prediction);
            }
        }
        if (errorIdx == -1) {
            return 0.0;
        }
        return error.getModelErrorComponent(errorIdx);
    }

    public static final double getRelativeError(RowData[] data, int errorIdx) throws ClusException {
        if (errorIdx == -1) {
            return 0.0;
        }
        ClusSchema schema = data[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        RelativeError error = new RelativeError(parent, num);
        parent.addError(error);
        for (int t = 0; t < data[0].getNbRows(); ++t) {
            DataTuple tuple_real = data[0].getTuple(t);
            DataTuple tuple_prediction = data[1].getTuple(t);
            parent.addExample(tuple_real, tuple_prediction);
        }
        double err = error.getModelErrorComponent(errorIdx);
        return err;
    }

    public static final double getRMSE(RowData[] data, int errorIdx) throws ClusException {
        if (errorIdx == -1) {
            return 0.0;
        }
        ClusSchema schema = data[0].getSchema();
        ClusErrorList parent = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        RMSError error = new RMSError(parent, num);
        parent.addError(error);
        for (int t = 0; t < data[0].getNbRows(); ++t) {
            DataTuple tuple_real = data[0].getTuple(t);
            DataTuple tuple_prediction = data[1].getTuple(t);
            parent.addExample(tuple_real, tuple_prediction);
        }
        double err = error.getModelErrorComponent(errorIdx);
        return err;
    }
}

