/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.hmc.HMCConvertToSC;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import si.ijs.kt.clus.Clus;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchical.ClassTerm;
import si.ijs.kt.clus.ext.hierarchical.ClassesTuple;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.FileUtil;
import si.ijs.kt.clus.util.jeans.util.StringUtils;

public class HMCConvertToSC {
    public void convert(String input, String output, boolean binary, boolean split) throws Exception {
        Clus clus = new Clus();
        String appname = FileUtil.getName(input) + ".s";
        clus.initializeAddOn(appname);
        ClusStatManager mgr = clus.getStatManager();
        Settings sett = clus.getSettings();
        ClassHierarchy hier = mgr.getHier();
        int sidx = hier.getType().getArrayIndex();
        String[] classterms = new String[hier.getTotal()];
        for (int i = 0; i < hier.getTotal(); ++i) {
            ClassTerm term = hier.getTermAt(i);
            classterms[i] = term.toStringHuman(hier);
        }
        if (split) {
            ClassesTuple tp;
            DataTuple tuple;
            ClusRun run = clus.partitionData();
            RowData train = (RowData)run.getTrainingSet();
            boolean[][] classes = new boolean[train.getNbRows()][hier.getTotal()];
            for (int i = 0; i < train.getNbRows(); ++i) {
                DataTuple tuple2 = train.getTuple(i);
                ClassesTuple tp2 = (ClassesTuple)tuple2.getObjVal(sidx);
                Arrays.fill(classes[i], false);
                tp2.fillBoolArrayNodeAndAncestors(classes[i]);
            }
            HMCConvertToSC.writeArffToSC(output + ".train.arff", train, classterms, classes, binary);
            if (!sett.getData().isNullTestFile()) {
                RowData test = run.getTestSet();
                classes = new boolean[test.getNbRows()][hier.getTotal()];
                for (int i = 0; i < test.getNbRows(); ++i) {
                    tuple = test.getTuple(i);
                    tp = (ClassesTuple)tuple.getObjVal(sidx);
                    Arrays.fill(classes[i], false);
                    tp.fillBoolArrayNodeAndAncestors(classes[i]);
                }
                HMCConvertToSC.writeArffToSC(output + ".test.arff", test, classterms, classes, binary);
            }
            if (!sett.getData().isNullPruneFile()) {
                RowData tune = (RowData)run.getPruneSet();
                classes = new boolean[tune.getNbRows()][hier.getTotal()];
                for (int i = 0; i < tune.getNbRows(); ++i) {
                    tuple = tune.getTuple(i);
                    tp = (ClassesTuple)tuple.getObjVal(sidx);
                    Arrays.fill(classes[i], false);
                    tp.fillBoolArrayNodeAndAncestors(classes[i]);
                }
                HMCConvertToSC.writeArffToSC(output + ".valid.arff", tune, classterms, classes, binary);
            }
        } else {
            RowData data = clus.getData();
            boolean[][] classes = new boolean[data.getNbRows()][hier.getTotal()];
            for (int i = 0; i < data.getNbRows(); ++i) {
                DataTuple tuple = data.getTuple(i);
                ClassesTuple tp = (ClassesTuple)tuple.getObjVal(sidx);
                Arrays.fill(classes[i], false);
                tp.fillBoolArrayNodeAndAncestors(classes[i]);
            }
            HMCConvertToSC.writeArffToSC(output + ".arff", data, classterms, classes, binary);
        }
    }

    public static void writeArffHeaderToSC(PrintWriter wrt, ClusSchema schema, String[] classterms, boolean binary) throws IOException, ClusException {
        int i;
        wrt.println("@RELATION " + schema.getRelationName());
        wrt.println();
        for (i = 0; i < schema.getNbAttributes(); ++i) {
            ClusAttrType type = schema.getAttrType(i);
            if (type.isDisabled() || type.getName().equals("class")) continue;
            wrt.print("@ATTRIBUTE ");
            wrt.print(StringUtils.printStr(type.getName(), 65));
            if (type.isKey()) {
                wrt.print("key");
            } else {
                type.writeARFFType(wrt);
            }
            wrt.println();
        }
        for (i = 0; i < classterms.length; ++i) {
            if (classterms[i].equals("root")) continue;
            wrt.print("@ATTRIBUTE ");
            wrt.print(classterms[i]);
            if (binary) {
                wrt.print("     numeric");
            } else {
                wrt.print("     hierarchical     p,n");
            }
            wrt.println();
        }
        wrt.println();
    }

    public static void writeArffToSC(String fname, RowData data, String[] classterms, boolean[][] classes, boolean binary) throws IOException, ClusException {
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream(fname)));
        ClusSchema schema = data.getSchema();
        HMCConvertToSC.writeArffHeaderToSC(wrt, schema, classterms, binary);
        wrt.println("@DATA");
        for (int j = 0; j < data.getNbRows(); ++j) {
            int i;
            DataTuple tuple = data.getTuple(j);
            int aidx = 0;
            for (i = 0; i < schema.getNbAttributes(); ++i) {
                ClusAttrType type = schema.getAttrType(i);
                if (type.isDisabled() || type.getName().equals("class")) continue;
                if (aidx != 0) {
                    wrt.print(",");
                }
                wrt.print(type.getString(tuple));
                ++aidx;
            }
            for (i = 0; i < classterms.length; ++i) {
                if (classterms[i].equals("root")) continue;
                if (binary) {
                    if (classes[j][i]) {
                        wrt.print(",1");
                        continue;
                    }
                    wrt.print(",0");
                    continue;
                }
                if (classes[j][i]) {
                    wrt.print(",p");
                    continue;
                }
                wrt.print(",n");
            }
            wrt.println();
        }
        wrt.close();
    }

    public static void main(String[] args) {
        int mainargs = 0;
        boolean binary = false;
        boolean split = false;
        boolean match = true;
        while (match && mainargs < args.length) {
            match = false;
            if (args[mainargs].equals("-binary")) {
                binary = true;
                match = true;
            }
            if (args[mainargs].equals("-split")) {
                split = true;
                match = true;
            }
            if (!match) continue;
            ++mainargs;
        }
        if (args.length - mainargs != 2) {
            ClusLogger.info("Usage: HMCConvertToSC input output");
            System.exit(0);
        }
        String input = args[mainargs];
        String output = args[mainargs + 1];
        HMCConvertToSC cnv = new HMCConvertToSC();
        try {
            cnv.convert(input, output, binary, split);
        }
        catch (Exception e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
        }
    }
}

