/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus.addon.ILevelC.ilevelc;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.io.ARFFFile;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.ext.ilevelc.DerivedConstraintsComputer;
import si.ijs.kt.clus.ext.ilevelc.ILevelConstraint;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.jeans.util.FileUtil;

public class ILevelCGUI
extends JFrame {
    public static final long serialVersionUID = 1L;
    public static final double LOGSIZE = 500.0;
    protected JComboBox m_Combo;
    protected JComboBox m_Class;
    protected ILevelCComponent m_Canvas;
    protected ClusSchema m_Schema;
    protected JButton m_Load;
    protected JButton m_Save;
    protected JButton m_Closure;
    protected JFileChooser m_Chooser = new JFileChooser();
    protected NominalAttrType m_ClassAttr;

    public ILevelCGUI() throws ClusException, IOException {
        super("ILevelCGUI");
        this.m_Chooser.setCurrentDirectory(new File("."));
        this.m_Schema = new ClusSchema("2DData");
        this.m_Schema.addAttrType(new NumericAttrType("X"));
        this.m_Schema.addAttrType(new NumericAttrType("Y"));
        this.m_ClassAttr = new NominalAttrType("CLASS", 2);
        this.m_Schema.addAttrType(this.m_ClassAttr);
        this.m_ClassAttr.setValue(0, "pos");
        this.m_ClassAttr.setValue(1, "neg");
        this.m_Schema.initialize();
        JPanel panel = new JPanel();
        JPanel top = new JPanel();
        JPanel bot = new JPanel();
        top.setLayout(new BorderLayout(3, 3));
        bot.setLayout(new BorderLayout(3, 3));
        this.m_Combo = new JComboBox();
        top.add(this.m_Combo, "Center");
        this.m_Load = new JButton("Load");
        top.add((Component)this.m_Load, "West");
        this.m_Save = new JButton("Save");
        top.add((Component)this.m_Save, "East");
        this.m_Class = new JComboBox();
        bot.add(this.m_Class, "West");
        this.m_Closure = new JButton("Compute Closure");
        bot.add((Component)this.m_Closure, "East");
        this.m_Save.addActionListener(new SaveListener());
        this.m_Load.addActionListener(new LoadListener());
        this.m_Closure.addActionListener(new ClosureListener());
        panel.setLayout(new BorderLayout());
        this.m_Combo.addItem("Add object");
        this.m_Combo.addItem("Delete object");
        this.m_Combo.addItem("Add must link");
        this.m_Combo.addItem("Add cannot link");
        this.m_Combo.setSelectedIndex(0);
        this.m_Class.addItem("pos");
        this.m_Class.addItem("neg");
        this.m_Class.setSelectedIndex(0);
        panel.add((Component)top, "North");
        this.m_Canvas = new ILevelCComponent();
        panel.add((Component)this.m_Canvas, "Center");
        panel.add((Component)bot, "South");
        this.m_Canvas.addMouseListener(new ILevelMouseListener());
        this.setContentPane(panel);
    }

    public int getClassValue() {
        return this.m_Class.getSelectedIndex();
    }

    public JFileChooser getFileOpen() {
        return this.m_Chooser;
    }

    public ClusSchema getSchema() {
        return this.m_Schema;
    }

    public static void main(String[] args) {
        try {
            ILevelCGUI gui = new ILevelCGUI();
            gui.setSize(new Dimension(800, 600));
            gui.setVisible(true);
        }
        catch (ClusException e) {
            ClusLogger.info("Exception: " + e);
            e.printStackTrace();
        }
        catch (IOException e) {
            ClusLogger.info("IOException: " + e);
            e.printStackTrace();
        }
    }

    public class SaveListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ILevelCGUI.this.m_Canvas.save();
        }
    }

    public class LoadListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ILevelCGUI.this.m_Canvas.load();
        }
    }

    public class ClosureListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ILevelCGUI.this.m_Canvas.computeClosure();
        }
    }

    public class ILevelCComponent
    extends JComponent {
        public static final long serialVersionUID = 1L;
        public int m_FirstIndex = -1;
        public ArrayList m_Points = new ArrayList();
        public ArrayList m_Constraints = new ArrayList();

        public void computeClosure() {
            DerivedConstraintsComputer comp = new DerivedConstraintsComputer(this.m_Points, this.m_Constraints);
            comp.compute();
            this.repaint();
        }

        public void indexPoints() {
            for (int i = 0; i < this.m_Points.size(); ++i) {
                DataTuple tuple = (DataTuple)this.m_Points.get(i);
                tuple.setIndex(i);
            }
        }

        public void load() {
            int returnVal = ILevelCGUI.this.getFileOpen().showOpenDialog(this);
            if (returnVal == 0) {
                String fname = ILevelCGUI.this.getFileOpen().getSelectedFile().getAbsolutePath();
                try {
                    RowData data = ARFFFile.readArff(fname);
                    this.m_Points = data.toArrayList();
                    this.indexPoints();
                    this.m_Constraints.clear();
                    String mname = FileUtil.getName(fname) + ".ilevelc";
                    ILevelConstraint.loadConstraints(mname, this.m_Constraints, this.m_Points);
                    this.repaint();
                }
                catch (Exception e) {
                    ClusLogger.info("Error saving: " + fname);
                    ClusLogger.info("Exception: " + e);
                    e.printStackTrace();
                }
            }
        }

        public void save() {
            int returnVal = ILevelCGUI.this.getFileOpen().showSaveDialog(this);
            if (returnVal == 0) {
                String fname = ILevelCGUI.this.getFileOpen().getSelectedFile().getAbsolutePath();
                try {
                    RowData data = new RowData(this.m_Points, ILevelCGUI.this.getSchema());
                    ARFFFile.writeArff(fname, data);
                    String mname = FileUtil.getName(fname);
                    PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream(mname + ".ilevelc")));
                    this.indexPoints();
                    wrt.println("TYPE,T1,T2");
                    for (int i = 0; i < this.m_Constraints.size(); ++i) {
                        ILevelConstraint ic = (ILevelConstraint)this.m_Constraints.get(i);
                        int type = ic.getType();
                        DataTuple t1 = ic.getT1();
                        DataTuple t2 = ic.getT2();
                        wrt.println(String.valueOf(type) + "," + t1.getIndex() + "," + t2.getIndex());
                    }
                    wrt.close();
                }
                catch (Exception e) {
                    ClusLogger.info("Error saving: " + fname);
                    ClusLogger.info("Exception: " + e);
                    e.printStackTrace();
                }
            }
        }

        public int getClosestPoint(int x, int y) {
            int select = -1;
            double mindist = Double.POSITIVE_INFINITY;
            for (int i = 0; i < this.m_Points.size(); ++i) {
                double pty;
                DataTuple tuple = (DataTuple)this.m_Points.get(i);
                double ptx = tuple.getDoubleVal(0);
                double dist = Math.sqrt((ptx - (double)x) * (ptx - (double)x) + ((pty = tuple.getDoubleVal(1)) - (double)y) * (pty - (double)y));
                if (!(dist < mindist)) continue;
                mindist = dist;
                select = i;
            }
            return select;
        }

        public boolean isIn(int x, int y) {
            for (int i = 0; i < this.m_Points.size(); ++i) {
                DataTuple tuple = (DataTuple)this.m_Points.get(i);
                double ptx = tuple.getDoubleVal(0);
                double pty = tuple.getDoubleVal(1);
                if (ptx != (double)x || pty != (double)y) continue;
                return true;
            }
            return false;
        }

        @Override
        public void paintComponent(Graphics g) {
            int i;
            Dimension dim = this.getSize();
            for (i = 0; i < this.m_Points.size(); ++i) {
                DataTuple tuple = (DataTuple)this.m_Points.get(i);
                int cls = tuple.getIntVal(0);
                if (cls == 0) {
                    g.setColor(Color.blue);
                } else {
                    g.setColor(Color.black);
                }
                g.fillOval((int)(tuple.getDoubleVal(0) * dim.getWidth() / 500.0) - 3, (int)(tuple.getDoubleVal(1) * dim.getHeight() / 500.0) - 3, 6, 6);
            }
            for (i = 0; i < this.m_Constraints.size(); ++i) {
                ILevelConstraint ic = (ILevelConstraint)this.m_Constraints.get(i);
                int type = ic.getType();
                DataTuple t1 = ic.getT1();
                DataTuple t2 = ic.getT2();
                if (type == 0) {
                    g.setColor(Color.green);
                } else {
                    g.setColor(Color.red);
                }
                g.drawLine((int)(t1.getDoubleVal(0) * dim.getWidth() / 500.0), (int)(t1.getDoubleVal(1) * dim.getHeight() / 500.0), (int)(t2.getDoubleVal(0) * dim.getWidth() / 500.0), (int)(t2.getDoubleVal(1) * dim.getHeight() / 500.0));
            }
        }

        public void addPoint(int x, int y) {
            int option = ILevelCGUI.this.m_Combo.getSelectedIndex();
            Dimension dim = this.getSize();
            x = (int)Math.floor(500.0 * (double)x / dim.getWidth());
            y = (int)Math.floor(500.0 * (double)y / dim.getHeight());
            if (option == 0 && !this.isIn(x, y)) {
                DataTuple tuple = new DataTuple(ILevelCGUI.this.m_Schema);
                tuple.setDoubleVal(x, 0);
                tuple.setDoubleVal(y, 1);
                tuple.setIntVal(ILevelCGUI.this.getClassValue(), 0);
                this.m_Points.add(tuple);
            } else if (option == 1) {
                int sel = this.getClosestPoint(x, y);
                if (sel != -1) {
                    this.m_Points.remove(sel);
                }
            } else if (option == 2 || option == 3) {
                int sel = this.getClosestPoint(x, y);
                if (this.m_FirstIndex == -1) {
                    this.m_FirstIndex = sel;
                } else {
                    DataTuple t2 = (DataTuple)this.m_Points.get(sel);
                    DataTuple t1 = (DataTuple)this.m_Points.get(this.m_FirstIndex);
                    ILevelConstraint cns = new ILevelConstraint(t1, t2, option == 2 ? 0 : 1);
                    this.m_Constraints.add(cns);
                    this.m_FirstIndex = -1;
                }
            }
            this.repaint();
        }
    }

    public class ILevelMouseListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            ILevelCGUI.this.m_Canvas.addPoint((int)e.getPoint().getX(), (int)e.getPoint().getY());
        }
    }
}

