/*
 * Decompiled with CFR 0.152.
 */
package si.ijs.kt.clus;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.lang.NotImplementedException;
import si.ijs.kt.clus.addon.network.PredictionAnalyzer;
import si.ijs.kt.clus.algo.ClusInductionAlgorithm;
import si.ijs.kt.clus.algo.ClusInductionAlgorithmType;
import si.ijs.kt.clus.algo.kNN.KnnClassifier;
import si.ijs.kt.clus.algo.rules.ClusCalcRuleErrorProc;
import si.ijs.kt.clus.algo.rules.ClusRuleClassifier;
import si.ijs.kt.clus.algo.rules.ClusRuleSet;
import si.ijs.kt.clus.algo.rules.tune.FIREROSTune;
import si.ijs.kt.clus.algo.tdidt.ClusDecisionTree;
import si.ijs.kt.clus.algo.tdidt.ClusNode;
import si.ijs.kt.clus.algo.tdidt.ClusSITDecisionTree;
import si.ijs.kt.clus.algo.tdidt.ConstraintDFInduce;
import si.ijs.kt.clus.algo.tdidt.processor.NodeExampleCollector;
import si.ijs.kt.clus.algo.tdidt.processor.NodeIDWriter;
import si.ijs.kt.clus.algo.tdidt.tune.CDTTuneFTest;
import si.ijs.kt.clus.algo.tdidt.tune.CDTuneSizeConstrPruning;
import si.ijs.kt.clus.data.ClusData;
import si.ijs.kt.clus.data.ClusSchema;
import si.ijs.kt.clus.data.ClusSchemaInitializer;
import si.ijs.kt.clus.data.io.ARFFFile;
import si.ijs.kt.clus.data.io.ClusReader;
import si.ijs.kt.clus.data.io.ClusView;
import si.ijs.kt.clus.data.rows.DataPreprocs;
import si.ijs.kt.clus.data.rows.DataTuple;
import si.ijs.kt.clus.data.rows.DiskTupleIterator;
import si.ijs.kt.clus.data.rows.RowData;
import si.ijs.kt.clus.data.rows.TupleIterator;
import si.ijs.kt.clus.data.type.ClusAttrType;
import si.ijs.kt.clus.data.type.primitive.IntegerAttrType;
import si.ijs.kt.clus.data.type.primitive.NominalAttrType;
import si.ijs.kt.clus.data.type.primitive.NumericAttrType;
import si.ijs.kt.clus.data.type.primitive.TimeSeriesAttrType;
import si.ijs.kt.clus.error.Accuracy;
import si.ijs.kt.clus.error.CorrelationMatrixComputer;
import si.ijs.kt.clus.error.PearsonCorrelation;
import si.ijs.kt.clus.error.common.ClusErrorList;
import si.ijs.kt.clus.error.common.ClusErrorOutput;
import si.ijs.kt.clus.error.common.multiscore.MultiScore;
import si.ijs.kt.clus.ext.beamsearch.ClusBeamSearch;
import si.ijs.kt.clus.ext.beamsearch.ClusFastBeamSearch;
import si.ijs.kt.clus.ext.constraint.ClusConstraintFile;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleClassifier;
import si.ijs.kt.clus.ext.ensemble.ClusEnsembleInduce;
import si.ijs.kt.clus.ext.exhaustivesearch.ClusExhaustiveDFSearch;
import si.ijs.kt.clus.ext.featureRanking.relief.Relief;
import si.ijs.kt.clus.ext.hierarchical.ClassHierarchy;
import si.ijs.kt.clus.ext.hierarchicalmtr.ClusHMTRHierarchy;
import si.ijs.kt.clus.ext.optiontree.ClusOptionTree;
import si.ijs.kt.clus.ext.semisupervised.ClusSemiSupervisedClassifier;
import si.ijs.kt.clus.main.ClusOutput;
import si.ijs.kt.clus.main.ClusRun;
import si.ijs.kt.clus.main.ClusStat;
import si.ijs.kt.clus.main.ClusStatManager;
import si.ijs.kt.clus.main.ClusSummary;
import si.ijs.kt.clus.main.settings.Settings;
import si.ijs.kt.clus.main.settings.section.SettingsData;
import si.ijs.kt.clus.main.settings.section.SettingsEnsemble;
import si.ijs.kt.clus.main.settings.section.SettingsExperimental;
import si.ijs.kt.clus.main.settings.section.SettingsGeneral;
import si.ijs.kt.clus.main.settings.section.SettingsGeneric;
import si.ijs.kt.clus.main.settings.section.SettingsHMTR;
import si.ijs.kt.clus.main.settings.section.SettingsSSL;
import si.ijs.kt.clus.main.settings.section.SettingsTree;
import si.ijs.kt.clus.model.ClusModel;
import si.ijs.kt.clus.model.ClusModelInfo;
import si.ijs.kt.clus.model.io.ClusModelCollectionIO;
import si.ijs.kt.clus.model.io.ClusTreeReader;
import si.ijs.kt.clus.model.processor.ClusEnsemblePredictionWriter;
import si.ijs.kt.clus.model.processor.ModelProcessorCollection;
import si.ijs.kt.clus.model.processor.PredictionWriter;
import si.ijs.kt.clus.pruning.PruneTree;
import si.ijs.kt.clus.selection.BagSelection;
import si.ijs.kt.clus.selection.ClusSelection;
import si.ijs.kt.clus.selection.CriterionBasedSelection;
import si.ijs.kt.clus.selection.OverSample;
import si.ijs.kt.clus.selection.RandomSelection;
import si.ijs.kt.clus.selection.XValDataSelection;
import si.ijs.kt.clus.selection.XValMainSelection;
import si.ijs.kt.clus.selection.XValRandomSelection;
import si.ijs.kt.clus.selection.XValSelection;
import si.ijs.kt.clus.statistic.ClusStatistic;
import si.ijs.kt.clus.statistic.CombStat;
import si.ijs.kt.clus.statistic.RegressionStat;
import si.ijs.kt.clus.util.ClusLogger;
import si.ijs.kt.clus.util.ClusMisc;
import si.ijs.kt.clus.util.ClusRandom;
import si.ijs.kt.clus.util.DebugFile;
import si.ijs.kt.clus.util.ResourceInfo;
import si.ijs.kt.clus.util.exception.ClusException;
import si.ijs.kt.clus.util.format.ClusFormat;
import si.ijs.kt.clus.util.format.ClusNumberFormat;
import si.ijs.kt.clus.util.jeans.io.MyFile;
import si.ijs.kt.clus.util.jeans.io.ObjectLoadStream;
import si.ijs.kt.clus.util.jeans.io.ObjectSaveStream;
import si.ijs.kt.clus.util.jeans.util.FileUtil;
import si.ijs.kt.clus.util.jeans.util.IntervalCollection;
import si.ijs.kt.clus.util.jeans.util.StringUtils;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgs;
import si.ijs.kt.clus.util.jeans.util.cmdline.CMDLineArgsProvider;

public class Clus
implements CMDLineArgsProvider {
    public static final boolean HIER_DEBUG = false;
    static EnumSet<DebugType> Debugging = EnumSet.of(DebugType.None);
    public static final boolean m_UseHier = true;
    public static final String[] OPTION_ARGS = new String[]{"relief", "exhaustive", "xval", "oxval", "target", "disable", "silent", "lwise", "c45", "info", "sample", "debug", "tuneftest", "load", "soxval", "bag", "obag", "show", "knn", "knnTEST", "knnTree", "beam", "gui", "fillin", "rules", "weka", "corrmatrix", "tunesize", "out2model", "test", "normalize", "tseries", "writetargets", "fold", "forest", "copying", "sit", "tc", "ssl", "clowdflows", "option", "unittest"};
    public static final int[] OPTION_ARITIES = new int[]{0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    private Settings m_Sett = new Settings();
    private ClusSummary m_Summary = new ClusSummary();
    private ClusSchema m_Schema;
    private MultiScore m_Score;
    private ClusInductionAlgorithmType m_Classifier;
    private ClusInductionAlgorithm m_Induce;
    private RowData m_Data;
    private boolean isxval = false;
    private CMDLineArgs m_CmdLine;
    private ClusHMTRHierarchy m_HMTRHierarchy;

    public final void initialize(CMDLineArgs cargs, ClusInductionAlgorithmType clss) throws IOException, ClusException {
        this.m_CmdLine = cargs;
        this.m_Classifier = clss;
        boolean test = this.m_Sett.getGeneral().getResourceInfoLoadedValue().equals((Object)SettingsGeneral.ResourceInfoLoad.Test);
        ResourceInfo.loadLibrary(test);
        this.initializeHMTRHierarchy();
        ARFFFile arff = null;
        if (this.m_Sett.getGeneral().getVerbose() > 0) {
            ClusLogger.info("Loading '" + this.m_Sett.getGeneric().getAppName() + "'");
        }
        ClusRandom.initialize(this.m_Sett);
        ClusReader reader = new ClusReader(this.m_Sett.getData().getDataFile(), this.m_Sett);
        if (cargs.hasOption("c45")) {
            if (this.m_Sett.getGeneral().getVerbose() > 0) {
                ClusLogger.info("Reading C45 .names/.data");
            }
        } else {
            if (this.m_Sett.getGeneral().getVerbose() > 0) {
                ClusLogger.info("Reading ARFF Header");
            }
            arff = new ARFFFile(reader);
            this.m_Schema = arff.read(this.m_Sett);
        }
        if (this.m_Sett.getGeneral().getVerbose() > 0) {
            ClusLogger.info("Reading CSV Data");
        }
        this.m_Sett.updateTarget(this.m_Schema);
        this.m_Sett.getHMTR().addHMTRTargets(this.m_Schema, this.m_HMTRHierarchy);
        this.m_Schema.initializeSettings(this.m_Sett);
        this.m_Sett.getAttribute().setTarget(this.m_Schema.getTarget().toString());
        this.m_Sett.getAttribute().setDisabled(this.m_Schema.getDisabled().toString());
        this.m_Sett.getAttribute().setClustering(this.m_Schema.getClustering().toString());
        this.m_Sett.getAttribute().setDescriptive(this.m_Schema.getDescriptive().toString());
        if (ResourceInfo.isLibLoaded()) {
            ClusStat.m_InitialMemory = ResourceInfo.getMemory();
        }
        ClusView view = this.m_Schema.createNormalView();
        this.m_Data = this.getSettings().getHMTR().isHMTREnabled() ? view.readDataHMTR(reader, this.m_Schema, this.m_HMTRHierarchy, this.m_Sett) : view.readData(reader, this.m_Schema);
        reader.close();
        if (this.m_Sett.getGeneral().getVerbose() > 0) {
            ClusLogger.info("Found " + this.m_Data.getNbRows() + " rows");
        }
        if (!this.getSettings().getData().getNormalizeData().equals((Object)SettingsData.NormalizeDataValues.None)) {
            if (this.m_Sett.getGeneral().getVerbose() > 0) {
                ClusLogger.info("Normalizing numerical data");
            }
            this.m_Data = Clus.returnNormalizedData(this.m_Data);
        }
        this.m_Schema.printInfo();
        if (ResourceInfo.isLibLoaded()) {
            ClusStat.m_LoadedMemory = ResourceInfo.getMemory();
        }
        if (this.getSettings().getData().isRemoveMissingTarget()) {
            this.m_Data = CriterionBasedSelection.removeMissingTarget(this.m_Data);
            CriterionBasedSelection.clearMissingFlagTargetAttrs(this.m_Schema);
        }
        if (this.isxval) {
            SettingsExperimental.IS_XVAL = true;
        }
        this.m_Induce = clss.createInduce(this.m_Schema, this.m_Sett, cargs);
        this.m_Sett.update(this.m_Schema);
        if (!this.m_Induce.getStatManager().isRuleInduceOnly()) {
            this.getSettings().getRules().disableRuleInduceParams();
        }
        this.preprocess();
        this.m_Schema.setHMTRHierarchy(this.m_HMTRHierarchy);
        this.m_Sett.validateSettings(this.m_Schema);
        this.m_Induce.initialize();
        this.initializeAttributeWeights(this.m_Data);
        this.m_Induce.initializeHeuristic();
        this.loadConstraintFile();
        this.initializeSummary(clss);
        if (cargs.hasOption("sample")) {
            String svalue = cargs.getOptionValue("sample");
            this.sample(svalue);
        }
        if (this.m_Sett.getGeneral().getVerbose() > 0) {
            ClusLogger.info("Has missing values: " + this.m_Schema.hasMissing());
        }
        if (ResourceInfo.isLibLoaded()) {
            ClusLogger.info("Memory usage: loading data took " + (ClusStat.m_LoadedMemory - ClusStat.m_InitialMemory) + " kB");
        }
    }

    private void initializeHMTRHierarchy() {
        if (this.m_Sett.getHMTR().isSectionHMTREnabled()) {
            this.m_HMTRHierarchy = new ClusHMTRHierarchy();
            if (this.m_Sett.getGeneral().getVerbose() > 0) {
                ClusLogger.info("Creating hierarchy for HMTR" + System.lineSeparator());
            }
            this.m_HMTRHierarchy.initialize(this.m_Sett);
            if (this.m_Sett.getGeneral().getVerbose() > 0) {
                this.m_HMTRHierarchy.printHierarchy();
                if (this.m_Sett.getHMTR().getHMTRType().equals((Object)SettingsHMTR.HierarchyTypesHMTR.Tree)) {
                    ClusLogger.info(this.m_HMTRHierarchy.printHierarchyTree());
                }
                this.m_HMTRHierarchy.printDepth();
                this.m_HMTRHierarchy.printWeights();
            }
        }
    }

    public final void initialize(CMDLineArgs cargs) throws ClusException, IOException {
        ARFFFile arff = null;
        ClusReader reader = new ClusReader(this.m_Sett.getData().getDataFile(), this.m_Sett);
        arff = new ARFFFile(reader);
        this.m_Schema = arff.read(this.m_Sett);
        this.m_Sett.updateTarget(this.m_Schema);
        this.m_Schema.initializeSettings(this.m_Sett);
        this.m_Sett.getAttribute().setTarget(this.m_Schema.getTarget().toString());
        this.m_Sett.getAttribute().setDisabled(this.m_Schema.getDisabled().toString());
        this.m_Sett.getAttribute().setClustering(this.m_Schema.getClustering().toString());
        this.m_Sett.getAttribute().setDescriptive(this.m_Schema.getDescriptive().toString());
        if (ResourceInfo.isLibLoaded()) {
            ClusStat.m_InitialMemory = ResourceInfo.getMemory();
        }
        ClusView view = this.m_Schema.createNormalView();
        this.m_Data = view.readData(reader, this.m_Schema, cargs.hasOption("unittest"));
        reader.close();
        if (!this.getSettings().getData().getNormalizeData().equals((Object)SettingsData.NormalizeDataValues.None)) {
            if (this.m_Sett.getGeneral().getVerbose() > 0) {
                ClusLogger.info("Normalizing numerical data");
            }
            this.m_Data = Clus.returnNormalizedData(this.m_Data);
        }
        if (ResourceInfo.isLibLoaded()) {
            ClusStat.m_LoadedMemory = ResourceInfo.getMemory();
        }
        if (this.getSettings().getData().isRemoveMissingTarget()) {
            this.m_Data = CriterionBasedSelection.removeMissingTarget(this.m_Data);
            CriterionBasedSelection.clearMissingFlagTargetAttrs(this.m_Schema);
        }
    }

    public void initialize(RowData data, ClusSchema schema, Settings sett, ClusInductionAlgorithmType clss) throws IOException, ClusException {
        this.m_Data = data;
        this.m_Sett = sett;
        this.m_Classifier = clss;
        this.m_Schema = schema;
        this.m_CmdLine = new CMDLineArgs(this);
    }

    public void recreateInduce(CMDLineArgs cargs, ClusInductionAlgorithmType clss, ClusSchema schema, RowData data) throws ClusException, IOException {
        this.m_Summary = new ClusSummary();
        this.m_Schema = schema;
        this.m_Induce = clss.createInduce(schema, this.m_Sett, cargs);
        this.m_Data = data;
        this.m_Classifier = clss;
        data.setSchema(schema);
        this.m_Induce.initialize();
        this.initializeAttributeWeights(data);
        this.m_Induce.initializeHeuristic();
        this.initializeSummary(clss);
    }

    public void initializeAddOn(String appname) throws ClusException, IOException {
        SettingsGeneric sett = this.getSettings().getGeneric();
        sett.setDate(new Date());
        sett.setAppName(appname);
        this.initSettings(null);
        ClusDecisionTree clss = new ClusDecisionTree(this);
        this.initialize(new CMDLineArgs(this), clss);
    }

    public final void loadConstraintFile() throws IOException {
        if (this.m_Sett.getConstraints().hasConstraintFile()) {
            ClusConstraintFile constr = ClusConstraintFile.getInstance();
            constr.load(this.m_Sett.getConstraints().getConstraintFile(), this.m_Schema);
        }
    }

    public final void initSettings(CMDLineArgs cargs) throws IOException {
        this.m_Sett.initialize(cargs, true);
    }

    public final void initializeSummary(ClusInductionAlgorithmType clss) throws ClusException {
        ClusStatManager mgr = this.m_Induce.getStatManager();
        ClusErrorList error = mgr.createErrorMeasure(this.m_Score);
        this.m_Summary.resetAll();
        this.m_Summary.setStatManager(mgr);
        if (this.m_Sett.getOutput().isOutTrainError()) {
            this.m_Summary.setTrainError(error);
        }
        if ((this.hasTestSet() || this.m_Sett.getSSL().isSemiSupervisedMode()) && this.m_Sett.getOutput().isOutTestError()) {
            this.m_Summary.setTestError(error);
        }
        if (this.hasPruneSet() && this.m_Sett.getOutput().isOutValidError()) {
            this.m_Summary.setValidationError(error);
        }
    }

    public final void sample(String svalue) {
        double val;
        int nb_rows = this.m_Data.getNbRows();
        int ps_perc = svalue.indexOf(37);
        ClusSelection sel = ps_perc != -1 ? ((val = Double.parseDouble(svalue.substring(0, ps_perc + 1)) / 100.0) < 1.0 ? new RandomSelection(nb_rows, val) : new OverSample(nb_rows, val)) : new RandomSelection(nb_rows, Integer.parseInt(svalue));
        this.m_Data = (RowData)this.m_Data.selectFrom(sel, null);
        int nb_sel = this.m_Data.getNbRows();
        ClusLogger.info("Sample (" + svalue + ") " + nb_rows + " -> " + nb_sel);
        ClusLogger.info();
    }

    public final void induce(ClusRun cr, ClusInductionAlgorithmType clss) throws Exception {
        ClusLogger.info("Time: " + new SimpleDateFormat("dd. MM. yyyy HH:mm:ss").format(Calendar.getInstance().getTime()));
        ClusLogger.info("Run: " + cr.getIndexString());
        clss.printInfo();
        clss.induceAll(cr);
    }

    public final int getNbRows() {
        return this.m_Data.getNbRows();
    }

    public final RowData getData() {
        return this.m_Data;
    }

    public final RowData getRowDataClone() {
        return (RowData)this.m_Data.cloneData();
    }

    public final MultiScore getMultiScore() {
        return this.m_Score;
    }

    public final ClusInductionAlgorithm getInduce() {
        return this.m_Induce;
    }

    public final ClusInductionAlgorithmType getClassifier() {
        return this.m_Classifier;
    }

    public final ClusStatManager getStatManager() {
        return this.m_Induce.getStatManager();
    }

    public final MultiScore getScore() {
        return this.m_Score;
    }

    public final ClusSchema getSchema() {
        return this.m_Schema;
    }

    public final Settings getSettings() {
        return this.m_Sett;
    }

    public final ClusSummary getSummary() {
        return this.m_Summary;
    }

    public final DataPreprocs getPreprocs(boolean single) {
        DataPreprocs pps = new DataPreprocs();
        this.m_Schema.getPreprocs(pps, single);
        this.m_Induce.getPreprocs(pps);
        return pps;
    }

    public final void initializeAttributeWeights(ClusData data) throws IOException, ClusException {
        ClusStatManager mgr = this.getInduce().getStatManager();
        ClusStatistic allStat = mgr.createStatistic(ClusAttrType.AttributeUseType.All);
        ClusStatistic[] stats = new ClusStatistic[]{allStat};
        mgr.initNormalizationWeights(allStat, data);
        mgr.initClusteringWeights();
        mgr.initDispersionWeights();
        mgr.initHeuristic();
        mgr.initStopCriterion();
        mgr.initSignifcanceTestingTable();
    }

    public final void preprocess(ClusData data) throws ClusException {
        DataPreprocs pps = this.getPreprocs(false);
        int nb = pps.getNbPasses();
        for (int i = 0; i < nb; ++i) {
            data.preprocess(i, pps);
            pps.done(i);
        }
    }

    public final void preprocSingle(RowData data) throws ClusException {
        DataPreprocs pps = this.getPreprocs(true);
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            pps.preprocSingle(tuple);
        }
    }

    public final void preprocess() throws ClusException {
        this.preprocess(this.m_Data);
    }

    public final boolean hasTestSet() {
        if (!this.m_Sett.getData().isNullTestFile()) {
            return true;
        }
        if (this.m_Sett.getData().getTestProportion() != 0.0) {
            return true;
        }
        return this.isxval;
    }

    public final boolean hasPruneSet() {
        if (!this.m_Sett.getData().isNullPruneFile()) {
            return true;
        }
        return this.m_Sett.getData().getPruneProportion() != 0.0;
    }

    public final RowData loadDataFile(String fname) throws IOException, ClusException {
        ClusReader reader = new ClusReader(fname, this.m_Sett);
        if (this.getSettings().getGeneral().getVerbose() > 0) {
            ClusLogger.info("Reading: " + fname);
        }
        ARFFFile arff = new ARFFFile(reader);
        arff.read(this.m_Sett);
        ClusView view = this.m_Schema.createNormalView();
        RowData data = view.readData(reader, this.m_Schema);
        reader.close();
        if (this.getSettings().getGeneral().getVerbose() > 0) {
            ClusLogger.info("Found " + data.getNbRows() + " rows");
        }
        this.preprocSingle(data);
        return data;
    }

    public final ClusRun partitionData() throws IOException, ClusException, InterruptedException {
        boolean testfile = false;
        boolean writetest = false;
        RandomSelection sel = null;
        if (!this.m_Sett.getData().isNullTestFile()) {
            testfile = true;
            writetest = true;
        } else {
            double test = this.m_Sett.getData().getTestProportion();
            if (test != 0.0) {
                int nbtot = this.m_Data.getNbRows();
                sel = new RandomSelection(nbtot, test);
                writetest = true;
            }
        }
        return this.partitionData(this.m_Data, sel, testfile, writetest, this.m_Summary, 1);
    }

    public final ClusRun partitionData(ClusSelection sel, int idx) throws IOException, ClusException, InterruptedException {
        return this.partitionData(this.m_Data, sel, false, false, this.m_Summary, idx);
    }

    public final ClusRun partitionData(ClusData data, ClusSelection sel, boolean testfile, boolean writetest, ClusSummary summary, int idx) throws IOException, ClusException, InterruptedException {
        ClusModelInfo allmi;
        ClusModelInfo mi;
        String test_fname = this.m_Sett.getGeneric().getAppName();
        ClusRun cr = this.partitionDataBasic(data, sel, summary, idx);
        boolean hasMissing = this.m_Schema.hasMissing();
        if (testfile) {
            test_fname = this.m_Sett.getData().getTestFile();
            MyClusInitializer init = new MyClusInitializer();
            DiskTupleIterator iter = new DiskTupleIterator(test_fname, init, this.getPreprocs(true), this.m_Sett);
            iter.setShouldAttach(true);
            cr.setTestSet(iter);
        }
        if (!this.m_Sett.getSSL().isNullUnlabeledFile()) {
            MyClusInitializer initUnlabeled = new MyClusInitializer();
            DiskTupleIterator iterUnlabeled = new DiskTupleIterator(this.m_Sett.getSSL().getUnlabeledFile(), initUnlabeled, this.getPreprocs(true), this.m_Sett);
            iterUnlabeled.setShouldAttach(true);
            cr.setUnlabeledSet(iterUnlabeled);
        }
        if (writetest) {
            String ts_name;
            if (this.m_Sett.getOutput().isWriteModelIDPredictions()) {
                mi = cr.addModelInfo(1);
                ts_name = this.m_Sett.getGeneric().getAppNameWithSuffix() + ".test.id";
                mi.addModelProcessor(1, new NodeIDWriter(ts_name, hasMissing, this.m_Sett));
            }
            if (this.m_Sett.getOutput().isWriteTestSetPredictions()) {
                allmi = cr.getAllModelsMI();
                ts_name = this.m_Sett.getGeneric().getAppNameWithSuffix() + ".test.pred.arff";
                allmi.addModelProcessor(1, new PredictionWriter(ts_name, this.m_Sett, this.getStatManager().createStatistic(ClusAttrType.AttributeUseType.Target)));
            }
        }
        if (this.m_Sett.getOutput().isWriteTrainSetPredictions()) {
            allmi = cr.getAllModelsMI();
            String tr_name = this.m_Sett.getGeneric().getAppNameWithSuffix() + ".train." + idx + ".pred.arff";
            allmi.addModelProcessor(0, new PredictionWriter(tr_name, this.m_Sett, this.getStatManager().createStatistic(ClusAttrType.AttributeUseType.Target)));
        }
        if (this.m_Sett.getOutput().isWriteModelIDPredictions()) {
            mi = cr.addModelInfo(1);
            String id_tr_name = this.m_Sett.getGeneric().getAppNameWithSuffix() + ".train." + idx + ".id";
            mi.addModelProcessor(0, new NodeExampleCollector(id_tr_name, hasMissing, this.m_Sett));
        }
        return cr;
    }

    public final ClusRun partitionDataBasic(RowData train) throws IOException, ClusException, InterruptedException {
        ClusSummary summary = new ClusSummary();
        return this.partitionDataBasic(train, null, null, summary, 1);
    }

    public final synchronized ClusRun partitionDataBasic(ClusData data, ClusSelection sel, ClusSummary summary, int idx) throws IOException, ClusException, InterruptedException {
        return this.partitionDataBasic(data, sel, null, summary, idx);
    }

    public final ClusRun partitionDataBasic(ClusData data, ClusSelection sel, ClusData prunefile, ClusSummary summary, int idx) throws IOException, ClusException, InterruptedException {
        ClusRun cr = new ClusRun(data.cloneData(), summary);
        if (sel != null) {
            if (sel.changesDistribution()) {
                ((RowData)cr.getTrainingSet()).update(sel);
            } else {
                ClusData val = cr.getTrainingSet().select(sel);
                cr.setTestSet(((RowData)val).getIterator());
            }
        }
        int pruning_max = this.m_Sett.getData().getPruneSetMax();
        double vsb = this.m_Sett.getData().getPruneProportion();
        if (vsb != 0.0) {
            ClusData train = cr.getTrainingSet();
            int nbtot = train.getNbRows();
            int nbsel = (int)Math.round(vsb * (double)nbtot);
            if (nbsel > pruning_max) {
                nbsel = pruning_max;
            }
            RandomSelection prunesel = new RandomSelection(nbtot, nbsel);
            cr.setPruneSet(train.select(prunesel), prunesel);
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Selecting pruning set: " + nbsel);
            }
        }
        if (!this.m_Sett.getData().isNullPruneFile()) {
            String prset = this.m_Sett.getData().getPruneFile();
            if (prunefile != null) {
                cr.setPruneSet(prunefile, null);
            } else {
                RowData prune = this.loadDataFile(prset);
                cr.setPruneSet(prune, null);
                if (this.getSettings().getGeneral().getVerbose() > 0) {
                    ClusLogger.info("Selecting pruning set: " + prset);
                }
            }
        }
        cr.setIndex(idx);
        cr.copyTrainingData();
        return cr;
    }

    public final void attachModels(ClusSchema schema, ClusRun cr) throws ClusException {
        for (int i = 0; i < cr.getNbModels(); ++i) {
            ClusModel model = cr.getModel(i);
            if (model == null) continue;
            schema.attachModel(model);
        }
    }

    public static final double calcModelError(ClusStatManager mgr, RowData data, ClusModel model) throws ClusException, IOException, InterruptedException {
        ClusSchema schema = data.getSchema();
        ClusErrorList error = new ClusErrorList();
        NumericAttrType[] num = schema.getNumericAttrUse(ClusAttrType.AttributeUseType.Target);
        NominalAttrType[] nom = schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        TimeSeriesAttrType[] ts = schema.getTimeSeriesAttrUse(ClusAttrType.AttributeUseType.Target);
        if (nom.length != 0) {
            error.addError(new Accuracy(error, nom));
        } else if (num.length != 0) {
            error.addError(new PearsonCorrelation(error, num));
        } else if (ts.length != 0) {
            throw new RuntimeException("There are some time series targets, no numeric targets, but we try to perform the step\nerror.addError(new PearsonCorrelation(error, num)).");
        }
        schema.attachModel(model);
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i);
            ClusStatistic pred = model.predictWeighted(tuple);
            error.addExample(tuple, pred);
        }
        double err = error.getFirstError().getModelError();
        return err;
    }

    public final void calcError(TupleIterator iter, int type, ClusRun cr) throws IOException, ClusException, InterruptedException {
        this.calcError(iter, type, cr, null);
    }

    public final void calcError(TupleIterator iter, int type, ClusRun cr, ClusEnsemblePredictionWriter ens_pred) throws IOException, ClusException, InterruptedException {
        iter.init();
        ClusSchema mschema = iter.getSchema();
        if (iter.shouldAttach()) {
            this.attachModels(mschema, cr);
        }
        cr.initModelProcessors(type, mschema);
        boolean wr_ens_tr_preds = !SettingsExperimental.IS_XVAL || SettingsExperimental.IS_XVAL && cr.getTestSet() == null;
        wr_ens_tr_preds = wr_ens_tr_preds && type == 0 && this.getSettings().getEnsemble().shouldWritePredictionsFromEnsemble();
        boolean wr_ens_te_preds = !SettingsExperimental.IS_XVAL && cr.getTestSet() != null;
        boolean bl = wr_ens_te_preds = wr_ens_te_preds && type == 1 && this.getSettings().getEnsemble().shouldWritePredictionsFromEnsemble();
        if (wr_ens_tr_preds || wr_ens_te_preds) {
            cr.initEnsemblePredictionsWriter(type);
        }
        ModelProcessorCollection allcoll = cr.getAllModelsMI().getAddModelProcessors(type);
        DataTuple tuple = iter.readTuple();
        int cnt = 0;
        while (tuple != null) {
            ++cnt;
            allcoll.exampleUpdate(tuple);
            for (int i = 0; i < cr.getNbModels(); ++i) {
                ModelProcessorCollection coll;
                ClusModelInfo mi = cr.getModelInfo(i);
                if (mi == null || mi.getModel() == null) continue;
                ClusModel model = mi.getModel();
                ClusStatistic pred = model.predictWeighted(tuple);
                ClusErrorList err = mi.getError(type);
                if (err != null) {
                    err.addExample(tuple, pred);
                }
                if ((coll = mi.getModelProcessors(type)) != null) {
                    if (coll.needsModelUpdate()) {
                        model.applyModelProcessors(tuple, coll);
                        coll.modelDone();
                    }
                    coll.exampleUpdate(tuple, pred);
                }
                if ((wr_ens_tr_preds || wr_ens_te_preds) && i == 1) {
                    mi.getEnsemblePredictionWriter(type).writePredictionsForTuple(tuple, pred);
                }
                if (ens_pred == null || i != 1 || type != 1) continue;
                ens_pred.writePredictionsForTuple(tuple, pred);
            }
            allcoll.exampleDone();
            tuple = iter.readTuple();
            if (cnt % 1000 != 0) continue;
            allcoll.flushWriter();
            cnt = 0;
        }
        iter.close();
        cr.termModelProcessors(type);
        if (wr_ens_tr_preds || wr_ens_te_preds) {
            cr.termEnsemblePredictionsWriter(type);
        }
    }

    public void addModelErrorMeasures(ClusRun cr) throws ClusException {
        for (int i = 0; i < cr.getNbModels(); ++i) {
            ClusModelInfo info = cr.getModelInfo(i);
            if (info == null || !(info.getModel() instanceof ClusRuleSet) || !this.m_Sett.getRules().isRuleWiseErrors()) continue;
            ClusRuleSet ruleset = (ClusRuleSet)info.getModel();
            ruleset.setError(info.getTrainingError(), 0);
            ruleset.setError(info.getTestError(), 1);
            info.addModelProcessor(0, new ClusCalcRuleErrorProc(0, info.getTrainingError()));
            info.addModelProcessor(1, new ClusCalcRuleErrorProc(1, info.getTestError()));
        }
    }

    public final void calcExtraTrainingSetErrors(ClusRun cr) throws ClusException, InterruptedException {
        ClusErrorList parent = this.getStatManager().createExtraError(0);
        for (int i = 0; i < cr.getNbModels(); ++i) {
            ClusModelInfo info = cr.getModelInfo(i);
            if (info == null) continue;
            ClusErrorList parent_cl = parent.getErrorClone();
            parent_cl.compute((RowData)cr.getTrainingSet(), info);
            info.setExtraError(0, parent_cl);
            if (!(info.getModel() instanceof ClusRuleSet) || !this.m_Sett.getRules().isRuleWiseErrors()) continue;
            ClusRuleSet ruleset = (ClusRuleSet)info.getModel();
            for (int j = 0; j < ruleset.getModelSize(); ++j) {
                ClusErrorList rule_error = parent.getErrorClone();
                rule_error.compute((RowData)cr.getTrainingSet(), ruleset.getRule(j));
                ruleset.getRule(j).addError(rule_error, 0);
            }
        }
    }

    public final void calcError(ClusRun cr, ClusSummary summary) throws IOException, ClusException, InterruptedException {
        this.calcError(cr, summary, null);
    }

    public final void calcError(ClusRun cr, ClusSummary summary, ClusEnsemblePredictionWriter ens_pred) throws IOException, ClusException, InterruptedException {
        cr.copyAllModelsMIs();
        for (int i = 0; i < cr.getNbModels(); ++i) {
            if (cr.getModelInfo(i) == null || this.m_Sett.getOutput().shouldShowModel(i)) continue;
            ClusModelInfo inf = cr.getModelInfo(i);
            if (inf.getTrainingError() != null) {
                inf.getTrainingError().clear();
            }
            if (inf.getTestError() != null) {
                inf.getTestError().clear();
            }
            if (inf.getValidationError() == null) continue;
            inf.getValidationError().clear();
        }
        if (this.m_Sett.getOutput().isOutTrainError()) {
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Computing training error");
            }
            this.calcError(cr.getTrainIter(), 0, cr, ens_pred);
        }
        if (this.m_Sett.getOutput().isOutTestError() && cr.getTestIter() != null) {
            cr.getTestSet();
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Computing testing error");
            }
            this.calcError(cr.getTestIter(), 1, cr, ens_pred);
        }
        if (this.m_Sett.getOutput().isOutValidError() && cr.getPruneSet() != null) {
            if (this.getSettings().getGeneral().getVerbose() > 0) {
                ClusLogger.info("Computing validation error");
            }
            this.calcError(cr.getPruneIter(), 2, cr, ens_pred);
        }
        if (summary != null) {
            summary.addSummary(cr);
        }
    }

    public final void out2model(String fname) throws Exception {
        String model_name = FileUtil.getName(fname) + ".model";
        ClusTreeReader rdr = new ClusTreeReader();
        ClusNode node = rdr.loadOutTree(fname, this.m_Schema, "Original Model");
        if (node == null) {
            node = rdr.loadOutTree(fname, this.m_Schema, "Pruned Model");
        }
        if (node == null) {
            throw new ClusException("Unable to find original tree in .out file");
        }
        ClusRun cr = this.partitionData();
        ConstraintDFInduce induce = new ConstraintDFInduce(this.m_Induce);
        ClusNode orig = induce.fillInInduce(cr, node, this.getScore());
        orig.numberTree();
        PruneTree pruner = induce.getStatManager().getTreePruner(cr.getPruneSet());
        pruner.setTrainingData((RowData)cr.getTrainingSet());
        ClusNode pruned = (ClusNode)orig.cloneTree();
        pruner.prune(pruned);
        pruned.numberTree();
        ClusLogger.info();
        ClusLogger.info("Tree read from .out:");
        orig.printTree();
        ClusLogger.info();
        if (rdr.getLineAfterTree() != null) {
            ClusLogger.info("First line after tree: '" + rdr.getLineAfterTree() + "'");
            ClusLogger.info();
        }
        ClusModelCollectionIO io = new ClusModelCollectionIO();
        ClusModelInfo pruned_info = new ClusModelInfo("Pruned");
        pruned_info.setModel(pruned);
        io.addModel(pruned_info);
        ClusModelInfo orig_info = new ClusModelInfo("Original");
        orig_info.setModel(orig);
        io.addModel(orig_info);
        io.save(model_name);
    }

    public static double[][] calcStdDevsForTheSet(RowData data, NumericAttrType[] numTypes) {
        int[] nbOfValidValues = new int[numTypes.length];
        double[] means = new double[numTypes.length];
        boolean[] varIsNonZero = new boolean[numTypes.length];
        double[] prevAcceptedValue = new double[numTypes.length];
        for (int i = 0; i < prevAcceptedValue.length; ++i) {
            prevAcceptedValue[i] = Double.NaN;
        }
        for (int iRow = 0; iRow < data.getNbRows(); ++iRow) {
            DataTuple tuple = data.getTuple(iRow);
            for (int jNumAttrib = 0; jNumAttrib < numTypes.length; ++jNumAttrib) {
                double value = numTypes[jNumAttrib].getNumeric(tuple);
                if (Double.isNaN(value) || Double.isInfinite(value)) continue;
                if (!Double.isNaN(prevAcceptedValue[jNumAttrib]) && prevAcceptedValue[jNumAttrib] != value) {
                    varIsNonZero[jNumAttrib] = true;
                }
                prevAcceptedValue[jNumAttrib] = value;
                int n = jNumAttrib;
                means[n] = means[n] + value;
                int n2 = jNumAttrib;
                nbOfValidValues[n2] = nbOfValidValues[n2] + 1;
            }
        }
        for (int jNumAttrib = 0; jNumAttrib < numTypes.length; ++jNumAttrib) {
            if (nbOfValidValues[jNumAttrib] == 0) {
                nbOfValidValues[jNumAttrib] = 1;
            }
            if (!varIsNonZero[jNumAttrib]) {
                means[jNumAttrib] = prevAcceptedValue[jNumAttrib];
                continue;
            }
            int n = jNumAttrib;
            means[n] = means[n] / (double)nbOfValidValues[jNumAttrib];
        }
        double[] variance = new double[numTypes.length];
        for (int iRow = 0; iRow < data.getNbRows(); ++iRow) {
            DataTuple tuple = data.getTuple(iRow);
            for (int jNumAttrib = 0; jNumAttrib < numTypes.length; ++jNumAttrib) {
                double value = numTypes[jNumAttrib].getNumeric(tuple);
                if (Double.isNaN(value) || Double.isInfinite(value)) continue;
                int n = jNumAttrib;
                variance[n] = variance[n] + Math.pow(value - means[jNumAttrib], 2.0);
            }
        }
        double[] stdDevs = new double[numTypes.length];
        for (int jNumAttrib = 0; jNumAttrib < numTypes.length; ++jNumAttrib) {
            if (!varIsNonZero[jNumAttrib]) {
                variance[jNumAttrib] = 0.25;
                ClusLogger.info("Warning: Variance of attribute " + jNumAttrib + " is zero.");
            } else {
                int n = jNumAttrib;
                variance[n] = variance[n] / (double)nbOfValidValues[jNumAttrib];
            }
            stdDevs[jNumAttrib] = Math.sqrt(variance[jNumAttrib]);
        }
        double[][] meanAndStdDev = new double[][]{means, stdDevs};
        return meanAndStdDev;
    }

    public static final RowData returnNormalizedData(RowData data) {
        NumericAttrType[] numTypes = data.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        double[][] meanAndStdDev = Clus.calcStdDevsForTheSet(data, numTypes);
        double[] stdDevs = meanAndStdDev[1];
        double[] mean = meanAndStdDev[0];
        ArrayList<DataTuple> normalized = new ArrayList<DataTuple>();
        for (int jNumAttrib = 0; jNumAttrib < numTypes.length; ++jNumAttrib) {
            numTypes[jNumAttrib].setSparse(false);
        }
        for (int iRow = 0; iRow < data.getNbRows(); ++iRow) {
            DataTuple tuple = data.getTuple(iRow).deepCloneTuple();
            int doublesLen = tuple.getDoubles().length;
            for (int jNumAttrib = 0; jNumAttrib < doublesLen; ++jNumAttrib) {
                NumericAttrType type = numTypes[jNumAttrib];
                double value = type.getNumeric(tuple);
                if (!Double.isNaN(value) && !Double.isInfinite(value)) {
                    value -= mean[jNumAttrib];
                    value /= 2.0 * stdDevs[jNumAttrib];
                }
                type.setNumeric(tuple, value);
            }
            normalized.add(tuple);
        }
        RowData normalized_data = new RowData(normalized, data.getSchema());
        ClusLogger.info("Normalized number of examples: " + normalized_data.getNbRows());
        return normalized_data;
    }

    public final void normalizeDataAndWriteToFile() throws IOException, ClusException {
        RowData data = this.m_Data;
        CombStat cmb = (CombStat)this.getStatManager().getTrainSetStat(ClusAttrType.AttributeUseType.All);
        RegressionStat rstat = cmb.getRegressionStat();
        NumericAttrType[] numtypes = this.getSchema().getNumericAttrUse(ClusAttrType.AttributeUseType.All);
        int tcnt = 0;
        for (int j = 0; j < numtypes.length; ++j) {
            NumericAttrType type = numtypes[j];
            if (!type.isTarget()) continue;
            ClusNumberFormat format = ClusFormat.THREE_AFTER_DOT;
            System.out.print(StringUtils.printStr("T" + ++tcnt + " ", 5));
            System.out.print(StringUtils.printStr(type.getName() + " ", 30));
            System.out.print(StringUtils.printStr(format.format(rstat.getMean(j)), 10));
            System.out.print(StringUtils.printStr(format.format(Math.sqrt(rstat.getVariance(j))), 10));
            ClusLogger.info();
        }
        ArrayList<DataTuple> normalized = new ArrayList<DataTuple>();
        for (int i = 0; i < data.getNbRows(); ++i) {
            DataTuple tuple = data.getTuple(i).deepCloneTuple();
            for (int j = 0; j < numtypes.length; ++j) {
                NumericAttrType type = numtypes[j];
                if (!type.isTarget()) continue;
                double value = type.getNumeric(tuple);
                value -= rstat.getMean(j);
                type.setNumeric(tuple, value /= Math.sqrt(rstat.getVariance(j)));
            }
            normalized.add(tuple);
        }
        RowData normalized_data = new RowData(normalized, this.getSchema());
        ClusLogger.info("Size: " + normalized_data.getNbRows());
        String fname = this.m_Sett.getGeneric().getFileAbsolute(FileUtil.getName(this.m_Sett.getData().getDataFile()) + "_norm.arff");
        ARFFFile.writeArff(fname, normalized_data);
    }

    public final void testModel(String fname) throws IOException, ClusException, ClassNotFoundException, InterruptedException {
        ClusModelCollectionIO io = ClusModelCollectionIO.load(fname);
        ClusModel res = io.getModel("Original");
        String test_name = this.m_Sett.getGeneric().getAppName() + ".test";
        ClusOutput out = new ClusOutput(test_name, this.m_Schema, this.m_Sett);
        ClusRun cr = this.partitionData();
        for (int i = io.getNbModels() - 1; i >= 0; --i) {
            ClusModelInfo mod_info = io.getModelInfo(i);
            ClusModelInfo def_info = cr.addModelInfo(mod_info.getModelInfo());
            def_info.setModel(io.getModel(i));
        }
        this.getStatManager().updateStatistics(res);
        this.getSchema().attachModel(res);
        this.getClassifier().postProcess(cr);
        this.calcError(cr, null, null);
        out.writeHeader();
        out.writeOutput(cr, true, this.m_Sett.getOutput().isOutTrainError());
        out.close();
    }

    public final void showModel(String fname) throws IOException, ClusException, ClassNotFoundException {
        ClusModelCollectionIO io = ClusModelCollectionIO.load(fname);
        ClusNode res = (ClusNode)io.getModel("Pruned");
        ClusLogger.info("Tree read from .model:");
        ClusLogger.info();
        res.inverseTests();
        res.printTree();
    }

    public final void saveModels(ClusRun models, ClusModelCollectionIO io) throws IOException, ClusException {
        if (this.getInduce().isModelWriter()) {
            this.getInduce().writeModel(io);
        }
        int pos = 0;
        for (int i = models.getNbModels() - 1; i >= 0; --i) {
            ClusModelInfo info = models.getModelInfo(i);
            if (info == null || !info.shouldSave()) continue;
            io.insertModel(pos++, info);
        }
    }

    public ClusRun train(RowData train) throws Exception {
        this.m_Induce = this.getClassifier().createInduce(train.getSchema(), this.m_Sett, this.m_CmdLine);
        ClusRun cr = this.partitionDataBasic(train);
        this.m_Induce.initialize();
        this.initializeAttributeWeights(this.m_Data);
        this.m_Induce.initializeHeuristic();
        this.getStatManager().computeTrainSetStat((RowData)cr.getTrainingSet());
        this.induce(cr, this.getClassifier());
        return cr;
    }

    public final void singleRun(ClusInductionAlgorithmType clss) throws Exception {
        ClusModelCollectionIO io = new ClusModelCollectionIO();
        this.m_Summary.setTotalRuns(1);
        ClusRun run = this.singleRunMain(clss, null);
        if (this.getSettings().getOutput().isWriteModelFile()) {
            if (!this.getSettings().getKNN().isKNN() && !this.getSettings().getRelief().isRelief()) {
                this.saveModels(run, io);
            }
            if (ClusEnsembleInduce.isOptimized() && this.m_Sett.getEnsemble().getNbBaggingSets().getVectorLength() > 1 && this.m_Sett.getEnsemble().getBagSelection().getIntVectorSorted()[0] < 1) {
                io.save(this.getSettings().getGeneric().getFileAbsolute(this.m_Sett.getGeneric().getAppName() + "_" + ClusEnsembleInduce.getMaxNbBags() + "_.model"));
            } else {
                io.save(this.getSettings().getGeneric().getFileAbsolute(this.m_Sett.getGeneric().getAppName() + ".model"));
            }
        }
    }

    public final ClusRun singleRunMain(ClusInductionAlgorithmType clss, ClusSummary summ) throws Exception {
        ClusOutput output = new ClusOutput(this.m_Sett.getGeneric().getAppName() + ".out", this.m_Schema, this.m_Sett);
        ClusRun cr = this.partitionData();
        this.getStatManager().computeTrainSetStat((RowData)cr.getTrainingSet());
        this.induce(cr, clss);
        if (summ == null) {
            this.addModelErrorMeasures(cr);
        }
        this.calcError(cr, null, null);
        if (summ != null) {
            for (int i = 0; i < cr.getNbModels(); ++i) {
                ClusModelInfo info = cr.getModelInfo(i);
                ClusModelInfo summ_info = summ.getModelInfo(i);
                ClusErrorList test_err = summ_info.getTestError();
                info.setTestError(test_err);
            }
        }
        this.calcExtraTrainingSetErrors(cr);
        output.writeHeader();
        output.writeOutput(cr, true, this.m_Sett.getOutput().isOutTrainError());
        output.close();
        clss.saveInformation(this.m_Sett.getGeneric().getAppName());
        return cr;
    }

    public final XValMainSelection getXValSelection() throws IOException, ClusException {
        if (this.m_Sett.getData().isLOOXVal()) {
            return new XValRandomSelection(this.m_Data.getNbRows(), this.m_Data.getNbRows());
        }
        if (this.m_Sett.getData().isNullXValFile()) {
            return this.m_Schema.getXValSelection(this.m_Data);
        }
        return XValDataSelection.readFoldsFile(this.m_Sett.getData().getXValFile(), this.m_Data.getNbRows());
    }

    public final void combineAllFoldRuns(ClusInductionAlgorithmType clss) throws Exception {
        ClusOutput output = new ClusOutput(this.m_Sett.getGeneric().getAppName() + ".xval", this.m_Schema, this.m_Sett);
        output.writeHeader();
        XValMainSelection sel = this.getXValSelection();
        this.m_Summary.setTotalRuns(sel.getNbFolds());
        for (int fold = 0; fold < sel.getNbFolds(); ++fold) {
            String dat_fname = "folds/" + this.m_Sett.getGeneric().getAppName() + ".fold." + fold;
            ClusLogger.info("Reading: " + dat_fname);
            ObjectLoadStream strm = new ObjectLoadStream(new FileInputStream(dat_fname));
            try {
                this.m_Summary.addSummary((ClusRun)strm.readObject());
                output.print((String)strm.readObject());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            strm.close();
        }
        PrintWriter wrt = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.m_Sett.getGeneric().getAppName() + ".test.pred")));
        for (int fold = 0; fold < sel.getNbFolds(); ++fold) {
            String pw_fname = "folds/" + this.m_Sett.getGeneric().getAppName() + ".test.pred." + fold;
            ClusLogger.info("Combining: " + pw_fname);
            LineNumberReader rdr = new LineNumberReader(new InputStreamReader(new FileInputStream(pw_fname)));
            String line = rdr.readLine();
            if (fold != 0) {
                while (line != null && !line.equals("@DATA")) {
                    line = rdr.readLine();
                }
                line = rdr.readLine();
            }
            while (line != null) {
                wrt.println(line);
                line = rdr.readLine();
            }
            rdr.close();
        }
        wrt.close();
        output.writeSummary(this.m_Summary);
        output.close();
        ClusRandom.initialize(this.m_Sett);
        this.singleRunMain(clss, this.m_Summary);
    }

    public final void oneFoldRun(ClusInductionAlgorithmType clss, int fold) throws Exception {
        if (fold == 0) {
            this.combineAllFoldRuns(clss);
        } else {
            FileUtil.mkdir("folds");
            ClusOutput output = new ClusOutput(this.m_Schema, this.m_Sett);
            ClusStatistic target = this.getStatManager().createStatistic(ClusAttrType.AttributeUseType.Target);
            String pw_fname = "folds/" + this.m_Sett.getGeneric().getAppName() + ".test.pred." + --fold;
            PredictionWriter wrt = new PredictionWriter(pw_fname, this.m_Sett, target);
            wrt.globalInitialize(this.m_Schema);
            XValMainSelection sel = this.getXValSelection();
            ClusModelCollectionIO io = new ClusModelCollectionIO();
            this.m_Summary.setTotalRuns(sel.getNbFolds());
            ClusRun cr = this.doOneFold(fold, clss, sel, io, wrt, output, null, null);
            wrt.close();
            output.close();
            cr.deleteData();
            String dat_fname = "folds/" + this.m_Sett.getGeneric().getAppName() + ".fold." + fold;
            ObjectSaveStream strm = new ObjectSaveStream(new FileOutputStream(dat_fname));
            strm.writeObject(cr);
            strm.writeObject(output.getString());
            strm.close();
        }
    }

    public final ClusRun doOneFold(int fold, ClusInductionAlgorithmType clss, XValMainSelection sel, ClusModelCollectionIO io, PredictionWriter wrt, ClusOutput output, ClusErrorOutput errOutput, ClusEnsemblePredictionWriter ens_pred) throws Exception {
        XValSelection msel = new XValSelection(sel, fold);
        ClusRun cr = this.partitionData(msel, fold + 1);
        this.getStatManager().computeTrainSetStat((RowData)cr.getTrainingSet());
        if (wrt != null) {
            wrt.println("! Fold = " + fold);
            cr.getAllModelsMI().addModelProcessor(1, wrt);
            if (this.m_Sett.getOutput().isOutFoldData()) {
                ClusLogger.info("Writing train and test ARFF files for fold " + fold);
                ARFFFile.writeArff(this.m_Sett.getGeneric().getAppName() + "-test-" + fold + ".arff", cr.getTestSet());
                ARFFFile.writeArff(this.m_Sett.getGeneric().getAppName() + "-train-" + fold + ".arff", (RowData)cr.getTrainingSet());
            }
        }
        if (this.m_Sett.getGeneral().isDoNotInduce()) {
            ClusLogger.info("Skipping model induction");
            return cr;
        }
        this.induce(cr, clss);
        if (this.m_Sett.getRules().isRuleWiseErrors()) {
            this.addModelErrorMeasures(cr);
        }
        this.calcError(cr, this.m_Summary, ens_pred);
        if (errOutput != null) {
            errOutput.writeOutput(cr, false, false, this.getStatManager().getClusteringWeights().m_Weights);
        }
        if (this.m_Sett.getOutput().isOutputFoldModels()) {
            ClusModelInfo mi;
            output.writeOutput(cr, false);
            if (!this.getSettings().getEnsemble().isEnsembleMode() && (mi = cr.getModelInfo(2)) != null) {
                io.addModel(mi);
            }
        } else {
            output.writeBrief(cr);
        }
        return cr;
    }

    public final void xvalRun(ClusInductionAlgorithmType clss) throws Exception {
        ClusErrorOutput errFileOutput = null;
        if (this.getSettings().getOutput().isWriteErrorFile()) {
            errFileOutput = new ClusErrorOutput(this.m_Sett.getGeneric().getAppName() + ".err", this.m_Schema, this.m_Sett);
            errFileOutput.writeHeader();
        }
        PredictionWriter testPredWriter = null;
        if (this.getSettings().getOutput().isWriteTestSetPredictions()) {
            ClusStatistic target = this.getStatManager().createStatistic(ClusAttrType.AttributeUseType.Target);
            testPredWriter = new PredictionWriter(this.m_Sett.getGeneric().getAppName() + ".test.pred.arff", this.m_Sett, target);
            testPredWriter.globalInitialize(this.m_Schema);
        }
        ClusOutput output = new ClusOutput(this.m_Sett.getGeneric().getAppName() + ".xval", this.m_Schema, this.m_Sett);
        output.writeHeader();
        XValMainSelection sel = this.getXValSelection();
        ClusModelCollectionIO io = new ClusModelCollectionIO();
        ClusEnsemblePredictionWriter ens_pred = null;
        if (this.getSettings().getEnsemble().shouldWritePredictionsFromEnsemble()) {
            ens_pred = new ClusEnsemblePredictionWriter(this.getStatManager().getSettings().getGeneric().getAppName() + ".ens.xval.preds", this.getStatManager().getSchema(), this.getStatManager().getSettings());
        }
        for (int fold = 0; fold < sel.getNbFolds(); ++fold) {
            this.doOneFold(fold, clss, sel, io, testPredWriter, output, errFileOutput, ens_pred);
        }
        if (this.getSettings().getEnsemble().shouldWritePredictionsFromEnsemble()) {
            ens_pred.closeWriter();
        }
        output.writeSummary(this.m_Summary);
        output.close();
        if (testPredWriter != null) {
            testPredWriter.close();
        }
        if (errFileOutput != null) {
            errFileOutput.close();
        }
        ClusRandom.initialize(this.m_Sett);
        ClusRun run = this.singleRunMain(clss, this.m_Summary);
        if (!this.getSettings().getKNN().isKNN() && this.getSettings().getOutput().isWriteModelFile()) {
            this.saveModels(run, io);
            io.save(this.getSettings().getGeneric().getFileAbsolute(this.m_Sett.getGeneric().getAppName() + ".model"));
        }
    }

    public final void baggingRun(ClusInductionAlgorithmType clss) throws Exception {
        ClusOutput output = new ClusOutput(this.m_Sett.getGeneric().getAppName() + ".bag", this.m_Schema, this.m_Sett);
        output.writeHeader();
        ClusStatistic target = this.getStatManager().createStatistic(ClusAttrType.AttributeUseType.Target);
        PredictionWriter wrt = new PredictionWriter(this.m_Sett.getGeneric().getAppName() + ".test.pred.arff", this.m_Sett, target);
        wrt.globalInitialize(this.m_Schema);
        int nbsets = this.m_Sett.getExperimental().getBaggingSets();
        int nbrows = this.m_Data.getNbRows();
        for (int i = 0; i < nbsets; ++i) {
            BagSelection msel = new BagSelection(nbrows, this.getSettings().getEnsemble().getEnsembleBagSize(), null);
            ClusRun cr = this.partitionData(msel, i + 1);
            ClusModelInfo mi = cr.getModelInfo(2);
            mi.addModelProcessor(1, wrt);
            this.induce(cr, clss);
            this.calcError(cr, this.m_Summary, null);
            if (!this.m_Sett.getOutput().isOutputFoldModels()) continue;
            output.writeOutput(cr, false);
        }
        wrt.close();
        output.writeSummary(this.m_Summary);
        output.close();
    }

    public final void exhaustiveRun(ClusInductionAlgorithmType clss) throws Exception {
        ClusOutput output = new ClusOutput(this.m_Sett.getGeneric().getAppName() + ".all", this.m_Schema, this.m_Sett);
        output.writeHeader();
        ClusRun cr = this.partitionData();
        this.induce(cr, clss);
        output.writeOutput(cr, false);
        output.writeSummary(this.m_Summary);
        output.close();
    }

    public void writeTargets() throws ClusException, IOException {
        ClassHierarchy hier = this.getStatManager().getHier();
        if (hier != null) {
            hier.writeTargets(this.m_Data, this.m_Schema, this.m_Sett.getGeneric().getAppName());
        }
    }

    public void showInfo() throws ClusException, IOException {
        RowData data = this.m_Data;
        ClusLogger.info("Name            #Rows      #Missing  #Nominal #Numeric #Target  #Classes");
        System.out.print(StringUtils.printStr(this.m_Sett.getGeneric().getAppName(), 16));
        System.out.print(StringUtils.printInt(data.getNbRows(), 11));
        double perc = this.m_Schema.getTotalInputNbMissing() / (double)data.getNbRows() / (double)this.m_Schema.getNbDescriptiveAttributes() * 100.0;
        System.out.print(StringUtils.printStr(ClusFormat.TWO_AFTER_DOT.format(perc) + "%", 10));
        System.out.print(StringUtils.printInt(this.m_Schema.getNbNominalDescriptiveAttributes(), 9));
        System.out.print(StringUtils.printInt(this.m_Schema.getNbNumericDescriptiveAttributes(), 9));
        System.out.print(StringUtils.printInt(this.m_Schema.getNbAllAttrUse(ClusAttrType.AttributeUseType.Target), 9));
        NominalAttrType[] tarnom = this.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
        if (tarnom != null && tarnom.length >= 1) {
            if (tarnom.length == 1) {
                ClusLogger.info(tarnom[0].getNbValues());
            } else {
                ClusLogger.info("M:" + tarnom.length);
            }
        } else {
            ClusLogger.info("(num)");
        }
        ClusLogger.info();
        this.m_Schema.showDebug();
        if (this.getStatManager().hasClusteringStat()) {
            ClusStatistic[] stats = new ClusStatistic[]{this.getStatManager().createClusteringStat(), this.getStatManager().createStatistic(ClusAttrType.AttributeUseType.All)};
            this.m_Data.calcTotalStats(stats);
            if (!this.m_Sett.getData().isNullTestFile()) {
                ClusLogger.info("Loading: " + this.m_Sett.getData().getTestFile());
                this.updateStatistic(this.m_Sett.getData().getTestFile(), stats);
            }
            if (!this.m_Sett.getData().isNullPruneFile()) {
                ClusLogger.info("Loading: " + this.m_Sett.getData().getPruneFile());
                this.updateStatistic(this.m_Sett.getData().getPruneFile(), stats);
            }
            ClusStatistic.calcMeans(stats);
            MyFile statf = new MyFile(this.getSettings().getGeneric().getAppName() + ".distr");
            statf.log("** Target:");
            stats[0].printDistribution(statf.getWriter());
            statf.log("** All:");
            stats[1].printDistribution(statf.getWriter());
            statf.close();
        }
    }

    public void updateStatistic(String fname, ClusStatistic[] stats) throws ClusException, IOException {
        MyClusInitializer init = new MyClusInitializer();
        DiskTupleIterator iter = new DiskTupleIterator(fname, init, this.getPreprocs(true), this.m_Sett);
        ((TupleIterator)iter).init();
        DataTuple tuple = ((TupleIterator)iter).readTuple();
        while (tuple != null) {
            for (int i = 0; i < stats.length; ++i) {
                stats[i].updateWeighted(tuple, 1.0);
            }
            tuple = ((TupleIterator)iter).readTuple();
        }
        ((TupleIterator)iter).close();
    }

    public void setFolds(int folds) {
        this.m_Sett.getData().setXValFolds(folds);
    }

    public void showDebug() {
        this.m_Schema.showDebug();
    }

    @Override
    public void showHelp() {
        ClusMisc.showHelp();
    }

    @Override
    public String[] getOptionArgs() {
        return OPTION_ARGS;
    }

    @Override
    public int[] getOptionArgArities() {
        return OPTION_ARITIES;
    }

    @Override
    public int getNbMainArgs() {
        return 1;
    }

    public String getAppName() {
        return this.m_Sett.getGeneric().getAppName();
    }

    private static void tryAnalyzePredictions(Clus clus, Settings sett) {
        int ts_size = clus.getNbRows();
        double b = clus.getSettings().getTree().getBandwidth();
        String ts_name = sett.getGeneric().getAppNameWithSuffix() + ".test.pred.arff";
        try {
            NominalAttrType[] t = clus.m_Schema.getNominalAttrUse(ClusAttrType.AttributeUseType.Target);
            if (t.length == 1) {
                PredictionAnalyzer.calculateI(ts_name, ts_size, b);
            } else {
                PredictionAnalyzer.calculateBI(ts_name, ts_size, b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Prediction analysis failed.");
        }
    }

    public static void main(String[] args) {
        try {
            Clus clus = new Clus();
            Settings sett = clus.getSettings();
            CMDLineArgs cargs = new CMDLineArgs(clus);
            cargs.process(args);
            if (cargs.hasOption("copying")) {
                ClusMisc.printGPL();
                System.exit(0);
            } else if (cargs.getNbMainArgs() == 0) {
                clus.showHelp();
                System.exit(0);
            }
            ClusMisc.printHeader(cargs.hasOption("silent"));
            if (cargs.allOK()) {
                sett.getGeneric().setDate(new Date());
                sett.getGeneric().setAppName(cargs.getMainArg(0));
                clus.initSettings(cargs);
                ClusLogger.initialize(sett.getGeneral());
                ClusInductionAlgorithmType clss = null;
                if (cargs.hasOption("relief")) {
                    clus.getSettings().getRelief().setSectionReliefEnabled(true);
                    clus.getSettings().getKNN().setSectionKNNEnabled(true);
                    clus.getSettings().getOutput().setOutValidError(false);
                    clus.getSettings().getOutput().setOutTrainError(false);
                    clus.getSettings().getOutput().setOutTestError(false);
                    clss = new Relief(clus);
                } else if (cargs.hasOption("knn")) {
                    clus.getSettings().getKNN().setSectionKNNEnabled(true);
                    clus.getSettings().getTree().setMissingAttrHandlingToTrainingSet();
                    clss = new KnnClassifier(clus);
                } else if (cargs.hasOption("rules")) {
                    clus.getSettings().getBeamSearch().setSectionBeamEnabled(true);
                    clus.getSettings().getRules().setSectionRulesEnabled(true);
                    clss = new ClusRuleClassifier(clus);
                    if (!sett.getEnsemble().getEnsembleROSAlgorithmType().equals((Object)SettingsEnsemble.EnsembleROSAlgorithmType.Disabled) && sett.getRules().isROSParameterAutoTune()) {
                        clss = new FIREROSTune(clss, new String[]{"0.25", "0.5", "0.75", "Random"});
                    }
                } else if (!cargs.hasOption("weka")) {
                    if (cargs.hasOption("tuneftest")) {
                        clss = new ClusDecisionTree(clus);
                        clss = new CDTTuneFTest(clss);
                    } else if (cargs.hasOption("tunesize")) {
                        clss = new ClusDecisionTree(clus);
                        clss = new CDTuneSizeConstrPruning(clss);
                    } else if (cargs.hasOption("beam")) {
                        clus.getSettings().getBeamSearch().setSectionBeamEnabled(true);
                        clss = sett.getBeamSearch().isFastBS() ? new ClusFastBeamSearch(clus) : new ClusBeamSearch(clus);
                    } else if (cargs.hasOption("exhaustive")) {
                        clus.getSettings().getExhaustiveSearch().setSectionExhaustiveEnabled(true);
                        clss = new ClusExhaustiveDFSearch(clus);
                    } else if (cargs.hasOption("sit")) {
                        clus.getSettings().getSIT().setSectionSITEnabled(true);
                        clss = new ClusDecisionTree(clus);
                        clss = new ClusSITDecisionTree(clss);
                    } else if (cargs.hasOption("forest")) {
                        sett.getEnsemble().setEnsembleMode(true);
                        clss = new ClusEnsembleClassifier(clus);
                        if (sett.getTree().getFTestArray().isVector()) {
                            clss = new CDTTuneFTest(clss, sett.getTree().getFTestArray().getDoubleVector());
                        }
                    } else if (cargs.hasOption("option")) {
                        clus.getSettings().getOptionTree().setSectionOptionEnabled(true);
                        clss = new ClusOptionTree(clus);
                        if (sett.getTree().getFTestArray().isVector()) {
                            clss = new CDTTuneFTest(clss, sett.getTree().getFTestArray().getDoubleVector());
                        }
                    } else {
                        clss = new ClusDecisionTree(clus);
                        if (sett.getTree().getFTestArray().isVector()) {
                            clss = new CDTTuneFTest(clss, sett.getTree().getFTestArray().getDoubleVector());
                        }
                    }
                }
                if (cargs.hasOption("ssl")) {
                    sett.getSSL().setSemiSupervisedMode(true);
                    if (sett.getSSL().getSemiSupervisedMethod().equals((Object)SettingsSSL.SSLMethod.PCT) && sett.getAttribute().getClustering().equals("Default")) {
                        sett.getAttribute().setClustering(sett.getAttribute().getDescriptive() + "," + sett.getAttribute().getTarget());
                    }
                    clss = new ClusSemiSupervisedClassifier(clus, clss);
                }
                if (cargs.hasOption("clowdflows")) {
                    clus.getSettings().getOutput().setOutputClowdFlows(true);
                }
                if (cargs.hasOption("corrmatrix")) {
                    clus.initialize(cargs, clss);
                    CorrelationMatrixComputer cmp = new CorrelationMatrixComputer();
                    cmp.compute(clus.m_Data);
                    cmp.printMatrixTeX();
                } else if (cargs.hasOption("info")) {
                    clus.initialize(cargs, clss);
                    clus.showInfo();
                } else if (cargs.hasOption("writetargets")) {
                    clus.initialize(cargs, clss);
                    clus.writeTargets();
                } else if (cargs.hasOption("out2model")) {
                    clus.initialize(cargs, clss);
                    clus.out2model(cargs.getOptionValue("out2model"));
                } else if (cargs.hasOption("test")) {
                    clus.initialize(cargs, clss);
                    clus.testModel(cargs.getOptionValue("test"));
                } else if (cargs.hasOption("normalize")) {
                    clus.initialize(cargs, clss);
                    clus.normalizeDataAndWriteToFile();
                } else if (cargs.hasOption("debug")) {
                    clus.initialize(cargs, clss);
                    clus.showDebug();
                } else if (cargs.hasOption("xval")) {
                    clus.isxval = true;
                    clus.initialize(cargs, clss);
                    clus.xvalRun(clss);
                } else if (cargs.hasOption("fold")) {
                    clus.isxval = true;
                    clus.initialize(cargs, clss);
                    ArrayList<Integer> f = cargs.getOptionList("fold");
                    Iterator iterator = f.iterator();
                    while (iterator.hasNext()) {
                        int i = (Integer)iterator.next();
                        clus.oneFoldRun(clss, i);
                    }
                } else if (cargs.hasOption("bag")) {
                    clus.isxval = true;
                    clus.initialize(cargs, clss);
                    clus.baggingRun(clss);
                } else if (cargs.hasOption("tseries")) {
                    clus.getSettings().getTimeSeries().setSectionTimeSeriesEnabled(true);
                    clus.initialize(cargs, clss);
                    clus.singleRun(clss);
                } else {
                    clus.initialize(cargs, clss);
                    clus.singleRun(clss);
                }
            }
            if (Clus.isDebug()) {
                ClusStat.show();
            }
            if (Clus.isDebug()) {
                ClusStat.show();
            }
            DebugFile.close();
            if (!sett.getAttribute().isNullGIS()) {
                Clus.tryAnalyzePredictions(clus, sett);
            }
            ClusLogger.info("Done.");
        }
        catch (ClusException e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace();
            System.exit(-2);
        }
        catch (FileNotFoundException e) {
            System.err.println("File not found: " + e);
            e.printStackTrace();
            System.exit(-3);
        }
        catch (IOException e) {
            System.err.println("IO Error: " + e);
            e.printStackTrace();
            System.exit(-4);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Class not found" + e);
            e.printStackTrace();
            System.exit(-5);
        }
        catch (InterruptedException e) {
            System.err.println("Error: " + e);
            e.printStackTrace();
            System.exit(-6);
        }
        catch (NotImplementedException e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-7);
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(-100);
        }
    }

    public static boolean isDebug(DebugType flag) {
        if (Debugging.contains((Object)DebugType.None)) {
            return false;
        }
        return Debugging.contains((Object)flag);
    }

    public static boolean isDebug() {
        return Clus.isDebug(DebugType.General);
    }

    public static void setDebug(EnumSet<DebugType> flags) {
        Debugging = flags;
    }

    private class MyClusInitializer
    implements ClusSchemaInitializer {
        private MyClusInitializer() {
        }

        @Override
        public void initSchema(ClusSchema schema) throws ClusException, IOException {
            if (Clus.this.getSettings().getTree().getHeuristic().equals((Object)SettingsTree.Heuristic.SSPD)) {
                schema.addAttrType(new IntegerAttrType("SSPD"));
            }
            schema.setTarget(new IntervalCollection(Clus.this.m_Sett.getAttribute().getTarget()));
            schema.setDisabled(new IntervalCollection(Clus.this.m_Sett.getAttribute().getDisabled()));
            schema.setClustering(new IntervalCollection(Clus.this.m_Sett.getAttribute().getClustering()));
            schema.setDescriptive(new IntervalCollection(Clus.this.m_Sett.getAttribute().getDescriptive()));
            schema.setKey(new IntervalCollection(Clus.this.m_Sett.getAttribute().getKey()));
            schema.updateAttributeUse();
            schema.initializeFrom(Clus.this.m_Schema);
        }
    }

    public static enum DebugType {
        None,
        General,
        Hierarchy;

    }
}

