/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import org.jgap.BreederBase;
import org.jgap.BulkFitnessFunction;
import org.jgap.Configuration;
import org.jgap.IChromosome;
import org.jgap.IInitializer;
import org.jgap.InvalidConfigurationException;
import org.jgap.Population;
import org.jgap.event.GeneticEvent;

public class GABreeder
extends BreederBase {
    private static final String CVS_REVISION = "$Revision: 1.15 $";
    private transient Configuration m_lastConf;
    private transient Population m_lastPop;

    public Population evolve(Population a_pop, Configuration a_conf) {
        IChromosome chrom;
        int i;
        Population pop = a_pop;
        int originalPopSize = a_conf.getPopulationSize();
        IChromosome fittest = null;
        if (a_conf.getGenerationNr() == 0) {
            int size = pop.size();
            for (i = 0; i < size; ++i) {
                chrom = pop.getChromosome(i);
                chrom.increaseAge();
            }
        } else if (a_conf.isPreserveFittestIndividual()) {
            fittest = pop.determineFittestChromosome(0, pop.size() - 1);
        }
        if (a_conf.getGenerationNr() > 0) {
            this.keepPopSizeConstant(pop, a_conf);
        }
        this.updateChromosomes(pop, a_conf);
        pop = this.applyNaturalSelectors(a_conf, pop, true);
        this.applyGeneticOperators(a_conf, pop);
        int currentPopSize = pop.size();
        for (i = originalPopSize; i < currentPopSize; ++i) {
            chrom = pop.getChromosome(i);
            chrom.setFitnessValueDirectly(-1.0);
            chrom.resetAge();
            chrom.increaseOperatedOn();
        }
        int size = Math.min(originalPopSize, currentPopSize);
        for (int i2 = 0; i2 < size; ++i2) {
            IChromosome chrom2 = pop.getChromosome(i2);
            chrom2.increaseAge();
            chrom2.resetOperatedOn();
        }
        BulkFitnessFunction bulkFunction = a_conf.getBulkFitnessFunction();
        if (bulkFunction != null) {
            bulkFunction.evaluate(pop);
        }
        this.updateChromosomes(pop, a_conf);
        pop = this.applyNaturalSelectors(a_conf, pop, false);
        if (a_conf.getMinimumPopSizePercent() > 0) {
            int sizeWanted = a_conf.getPopulationSize();
            int minSize = (int)Math.round((double)sizeWanted * (double)a_conf.getMinimumPopSizePercent() / 100.0);
            int popSize = pop.size();
            if (popSize < minSize) {
                IChromosome sampleChrom = a_conf.getSampleChromosome();
                Class<?> sampleChromClass = sampleChrom.getClass();
                IInitializer chromIniter = a_conf.getJGAPFactory().getInitializerFor(sampleChrom, sampleChromClass);
                while (pop.size() < minSize) {
                    try {
                        IChromosome newChrom = (IChromosome)chromIniter.perform(sampleChrom, sampleChromClass, null);
                        pop.addChromosome(newChrom);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
        this.reAddFittest(pop, fittest);
        a_conf.incrementGenerationNr();
        this.m_lastPop = pop;
        this.m_lastConf = a_conf;
        a_conf.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_evolved_event", this));
        return pop;
    }

    public Configuration getLastConfiguration() {
        return this.m_lastConf;
    }

    public Population getLastPopulation() {
        return this.m_lastPop;
    }

    public Object clone() {
        return new GABreeder();
    }

    protected void keepPopSizeConstant(Population a_pop, Configuration a_conf) {
        if (a_conf.isKeepPopulationSizeConstant()) {
            try {
                a_pop.keepPopSizeConstant();
            }
            catch (InvalidConfigurationException iex) {
                throw new RuntimeException(iex);
            }
        }
    }

    protected void reAddFittest(Population a_pop, IChromosome a_fittest) {
        if (a_fittest != null && !a_pop.contains(a_fittest)) {
            a_pop.addChromosome(a_fittest);
        }
    }

    protected void updateChromosomes(Population a_pop, Configuration a_conf) {
        boolean bulkFitFunc;
        int currentPopSize = a_pop.size();
        BulkFitnessFunction bulkFunction = a_conf.getBulkFitnessFunction();
        boolean bl = bulkFitFunc = bulkFunction != null;
        if (!bulkFitFunc) {
            for (int i = 0; i < currentPopSize; ++i) {
                IChromosome chrom = a_pop.getChromosome(i);
                chrom.getFitnessValue();
            }
        }
    }
}

