/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.jgap.BulkFitnessFunction;
import org.jgap.FitnessEvaluator;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.GeneticOperator;
import org.jgap.Genotype;
import org.jgap.IBreeder;
import org.jgap.IChromosome;
import org.jgap.IChromosomePool;
import org.jgap.ICloneHandler;
import org.jgap.IJGAPFactory;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.RandomGenerator;
import org.jgap.data.config.ConfigException;
import org.jgap.data.config.ConfigFileReader;
import org.jgap.data.config.Configurable;
import org.jgap.data.config.ConfigurationHandler;
import org.jgap.data.config.RootConfigurationHandler;
import org.jgap.event.IEventManager;
import org.jgap.impl.ChainOfSelectors;
import org.jgap.impl.GABreeder;
import org.jgap.impl.JGAPFactory;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class Configuration
implements Configurable,
Serializable,
ICloneable,
Comparable {
    private static final String CVS_REVISION = "$Revision: 1.97 $";
    public static final String PROPERTY_JGAPFACTORY_CLASS = "JGAPFACTORYCLASS";
    public static final String PROPERTY_FITFUNC_INST = "JGAPFITFUNCINST";
    public static final String PROPERTY_BFITFNC_INST = "JGAPBFITFNCINST";
    public static final String PROPERTY_FITEVAL_INST = "JGAPFITEVALINST";
    public static final String PROPERTY_SAMPLE_CHROM_INST = "JGAPSAMPLECHRMINST";
    public static final String PROPERTY_EVENT_MGR_INST = "JGAPEVNTMGRINST";
    public static final String S_CONFIGURATION = "Configuration";
    public static final String S_CONFIGURATION_NAME = "Configuration name";
    public static final String S_POPULATION_SIZE = "Population size";
    public static final String S_MINPOPSIZE = "Minimum pop. size [%]";
    public static final String S_CHROMOSOME_SIZE = "Chromosome size";
    public static final String S_SAMPLE_CHROM = "Sample Chromosome";
    public static final String S_SIZE = "Size";
    public static final String S_TOSTRING = "toString";
    public static final String S_RANDOM_GENERATOR = "Random generator";
    public static final String S_EVENT_MANAGER = "Event manager";
    public static final String S_NONE = "none";
    public static final String S_CONFIGURATION_HANDLER = "Configuration handler";
    public static final String S_FITNESS_FUNCTION = "Fitness function";
    public static final String S_FITNESS_EVALUATOR = "Fitness evaluator";
    public static final String S_GENETIC_OPERATORS = "Genetic operators";
    public static final String S_NATURAL_SELECTORS = "Natural Selectors";
    public static final String S_PRE = "pre";
    public static final String S_POST = "post";
    private ConfigurationConfigurable m_config = new ConfigurationConfigurable();
    private FitnessFunction m_objectiveFunction;
    private FitnessEvaluator m_fitnessEvaluator;
    private IBreeder m_breeder;
    private int m_minPercentageSizePopulation;
    private BulkFitnessFunction m_bulkObjectiveFunction;
    private IChromosome m_sampleChromosome;
    private RandomGenerator m_randomGenerator;
    private IEventManager m_eventManager;
    private transient IChromosomePool m_chromosomePool;
    private List m_geneticOperators;
    private int m_chromosomeSize;
    private boolean m_settingsLocked;
    private ChainOfSelectors m_preSelectors;
    private ChainOfSelectors m_postSelectors;
    private boolean m_preserveFittestIndividual;
    private double m_selectFromPrevGen;
    private int m_generationNr;
    private transient RootConfigurationHandler m_conHandler;
    private String m_name;
    private boolean m_keepPopulationSizeConstant;
    private IJGAPFactory m_factory;
    private boolean m_alwaysCalculateFitness;
    private transient String threadKey;
    private String m_id;

    public Configuration() {
        this("", null);
    }

    public Configuration(String a_id, String a_name) {
        this.m_id = a_id;
        this.setName(a_name);
        this.makeThreadKey();
        this.m_preSelectors = new ChainOfSelectors(this);
        this.m_postSelectors = new ChainOfSelectors(this);
        this.m_selectFromPrevGen = 1.0;
        this.m_geneticOperators = new Vector();
        this.m_conHandler = new RootConfigurationHandler();
        this.m_conHandler.setConfigurable(this);
        this.m_keepPopulationSizeConstant = true;
        this.m_alwaysCalculateFitness = false;
        String clazz = System.getProperty(PROPERTY_JGAPFACTORY_CLASS);
        if (clazz != null && clazz.length() > 0) {
            try {
                this.m_factory = (IJGAPFactory)Class.forName(clazz).newInstance();
            }
            catch (Throwable ex) {
                throw new RuntimeException("Class " + clazz + " could not be instantiated" + " as type IJGAPFactory", ex);
            }
        } else {
            this.m_factory = new JGAPFactory(false);
        }
    }

    public Configuration(String a_name) {
        this();
        this.setName(a_name);
    }

    public Configuration(String a_configFileName, boolean a_ignore) throws ConfigException, InvalidConfigurationException {
        this();
        ConfigFileReader.instance().setFileName(a_configFileName);
        Genotype.setStaticConfiguration(this);
        this.getConfigurationHandler().readConfig();
    }

    public static void reset() {
        Configuration.reset("");
    }

    public static void reset(String a_id) {
        String threadKey = Configuration.getThreadKey(Thread.currentThread(), a_id);
        System.setProperty(threadKey + PROPERTY_FITFUNC_INST, "");
        System.setProperty(threadKey + PROPERTY_BFITFNC_INST, "");
        System.setProperty(threadKey + PROPERTY_FITEVAL_INST, "");
        System.setProperty(threadKey + PROPERTY_SAMPLE_CHROM_INST, "");
        System.setProperty(threadKey + PROPERTY_EVENT_MGR_INST, "");
    }

    public static void resetProperty(String a_propName) {
        Configuration.resetProperty(a_propName, "");
    }

    public static void resetProperty(String a_propName, String a_id) {
        String threadKey = Configuration.getThreadKey(Thread.currentThread(), a_id);
        System.setProperty(threadKey + a_propName, "");
    }

    public void setName(String a_name) {
        this.m_name = a_name;
    }

    public String getName() {
        return this.m_name;
    }

    public synchronized void setFitnessFunction(FitnessFunction a_functionToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_functionToSet == null) {
            throw new InvalidConfigurationException("The FitnessFunction instance must not be null.");
        }
        if (this.m_bulkObjectiveFunction != null) {
            throw new InvalidConfigurationException("The bulk fitness function and normal fitness function may not both be set.");
        }
        this.checkProperty(PROPERTY_FITFUNC_INST, a_functionToSet, this.m_objectiveFunction, "Fitness function has already been set differently.");
        this.m_objectiveFunction = a_functionToSet;
    }

    protected void checkProperty(String a_propname, Object a_obj, Object a_oldObj, String a_errmsg) {
        String instanceHash = System.getProperty(this.threadKey + a_propname, null);
        String key = this.makeKey(a_obj);
        if (instanceHash == null || instanceHash.length() < 1) {
            System.setProperty(this.threadKey + a_propname, key);
        } else if (!instanceHash.equals(key)) {
            throw new RuntimeException(a_errmsg + "\nIf you want to set or construct" + " a configuration multiple times, please call" + " static method Configuration.reset() before" + " each setting!");
        }
    }

    protected String makeKey(Object a_obj) {
        String key = String.valueOf(a_obj.hashCode()) + a_obj.getClass().getName();
        return key;
    }

    public synchronized FitnessFunction getFitnessFunction() {
        return this.m_objectiveFunction;
    }

    public synchronized void setBulkFitnessFunction(BulkFitnessFunction a_functionToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_functionToSet == null) {
            throw new InvalidConfigurationException("The BulkFitnessFunction instance must not be null.");
        }
        if (this.m_objectiveFunction != null) {
            throw new InvalidConfigurationException("The bulk fitness function and normal fitness function must not both be set.");
        }
        this.checkProperty(PROPERTY_BFITFNC_INST, a_functionToSet, this.m_bulkObjectiveFunction, "Bulk fitness function has already been set differently.");
        this.m_bulkObjectiveFunction = a_functionToSet;
    }

    public synchronized BulkFitnessFunction getBulkFitnessFunction() {
        return this.m_bulkObjectiveFunction;
    }

    public void setSampleChromosome(IChromosome a_sampleChromosomeToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_sampleChromosomeToSet == null) {
            throw new InvalidConfigurationException("The sample chromosome instance must not be null.");
        }
        if (a_sampleChromosomeToSet.getConfiguration() == null) {
            throw new InvalidConfigurationException("The sample chromosome's configuration must not be null.");
        }
        this.checkProperty(PROPERTY_SAMPLE_CHROM_INST, a_sampleChromosomeToSet, this.m_sampleChromosome, "Sample chromosome has already been set differently.");
        this.m_sampleChromosome = a_sampleChromosomeToSet;
        this.m_chromosomeSize = this.m_sampleChromosome.size();
    }

    public IChromosome getSampleChromosome() {
        return this.m_sampleChromosome;
    }

    public int getChromosomeSize() {
        return this.m_chromosomeSize;
    }

    public synchronized void setNaturalSelector(NaturalSelector a_selectorToSet) throws InvalidConfigurationException {
        this.addNaturalSelector(a_selectorToSet, false);
    }

    public synchronized NaturalSelector getNaturalSelector() {
        if (this.getNaturalSelectors(false).size() < 1) {
            return null;
        }
        return this.getNaturalSelectors(false).get(0);
    }

    public synchronized NaturalSelector getNaturalSelector(boolean a_processBeforeGeneticOperators, int a_index) {
        if (a_processBeforeGeneticOperators) {
            return this.m_preSelectors.get(a_index);
        }
        return this.m_postSelectors.get(a_index);
    }

    public ChainOfSelectors getNaturalSelectors(boolean a_processBeforeGeneticOperators) {
        if (a_processBeforeGeneticOperators) {
            return this.m_preSelectors;
        }
        return this.m_postSelectors;
    }

    public int getNaturalSelectorsSize(boolean a_processBeforeGeneticOperators) {
        if (a_processBeforeGeneticOperators) {
            return this.m_preSelectors.size();
        }
        return this.m_postSelectors.size();
    }

    public void removeNaturalSelectors(boolean a_processBeforeGeneticOperators) {
        if (a_processBeforeGeneticOperators) {
            this.getNaturalSelectors(true).clear();
        } else {
            this.getNaturalSelectors(false).clear();
        }
    }

    public synchronized void setRandomGenerator(RandomGenerator a_generatorToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_generatorToSet == null) {
            throw new InvalidConfigurationException("The RandomGenerator instance may not be null.");
        }
        this.m_randomGenerator = a_generatorToSet;
    }

    public synchronized RandomGenerator getRandomGenerator() {
        return this.m_randomGenerator;
    }

    public synchronized void addGeneticOperator(GeneticOperator a_operatorToAdd) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_operatorToAdd == null) {
            throw new InvalidConfigurationException("The GeneticOperator instance must not be null.");
        }
        this.m_geneticOperators.add(a_operatorToAdd);
    }

    public List getGeneticOperators() {
        return this.m_geneticOperators;
    }

    public synchronized void setPopulationSize(int a_sizeOfPopulation) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_sizeOfPopulation < 1) {
            throw new InvalidConfigurationException("The population size must be positive.");
        }
        this.m_config.m_populationSize = a_sizeOfPopulation;
    }

    public synchronized int getPopulationSize() {
        return this.m_config.m_populationSize;
    }

    public void setEventManager(IEventManager a_eventManagerToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_eventManagerToSet == null) {
            throw new InvalidConfigurationException("The event manager instance must not be null.");
        }
        this.checkProperty(PROPERTY_EVENT_MGR_INST, a_eventManagerToSet, this.m_eventManager, "Event manager has already been set differently.");
        this.m_eventManager = a_eventManagerToSet;
    }

    public IEventManager getEventManager() {
        return this.m_eventManager;
    }

    public void setChromosomePool(IChromosomePool a_chromosomePoolToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        this.m_chromosomePool = a_chromosomePoolToSet;
    }

    public IChromosomePool getChromosomePool() {
        return this.m_chromosomePool;
    }

    public synchronized void lockSettings() throws InvalidConfigurationException {
        if (!this.m_settingsLocked) {
            this.verifyStateIsValid();
            this.m_settingsLocked = true;
        }
    }

    public boolean isLocked() {
        return this.m_settingsLocked;
    }

    public synchronized void verifyStateIsValid() throws InvalidConfigurationException {
        if (this.m_objectiveFunction == null && this.m_bulkObjectiveFunction == null) {
            throw new InvalidConfigurationException("A desired fitness function or bulk fitness function must be specified in the active configuration.");
        }
        if (this.m_sampleChromosome == null) {
            throw new InvalidConfigurationException("A sample instance of the desired Chromosome setup must be specified in the active configuration.");
        }
        if (this.m_preSelectors.size() == 0 && this.m_postSelectors.size() == 0) {
            throw new InvalidConfigurationException("At least one desired natural selector must be specified in the active configuration.");
        }
        if (this.m_randomGenerator == null) {
            throw new InvalidConfigurationException("A desired random number generator must be specified in the active configuration.");
        }
        if (this.m_eventManager == null) {
            throw new InvalidConfigurationException("A desired event manager must be specified in the active configuration.");
        }
        if (this.m_geneticOperators.isEmpty()) {
            throw new InvalidConfigurationException("At least one genetic operator must be specified in the configuration.");
        }
        if (this.m_chromosomeSize <= 0) {
            throw new InvalidConfigurationException("A chromosome size greater than zero must be specified in the active configuration.");
        }
        if (this.m_config.m_populationSize <= 0) {
            throw new InvalidConfigurationException("A population size greater than zero must be specified in the active configuration.");
        }
        if (this.m_fitnessEvaluator == null) {
            throw new IllegalArgumentException("The fitness evaluator must not be null.");
        }
        Gene[] sampleGenes = this.m_sampleChromosome.getGenes();
        for (int i = 0; i < sampleGenes.length; ++i) {
            Gene sampleCopy = sampleGenes[i].newGene();
            sampleCopy.setAllele(sampleGenes[i].getAllele());
            if (sampleCopy.equals(sampleGenes[i])) continue;
            throw new InvalidConfigurationException("The sample Gene at gene position (locus) " + i + " does not appear to have a working equals() or compareTo()" + " method.\n" + "It could also be that you forgot to implement method" + " newGene() in your Gene implementation.\n" + "When tested, the method returned false when comparing " + "the sample gene with a gene of the same type and " + "possessing the same value (allele).");
        }
    }

    protected void verifyChangesAllowed() throws InvalidConfigurationException {
        if (this.m_settingsLocked) {
            throw new InvalidConfigurationException("This Configuration object is locked. Settings may not be altered.");
        }
    }

    public void addNaturalSelector(NaturalSelector a_selector, boolean a_processBeforeGeneticOperators) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_processBeforeGeneticOperators) {
            this.m_preSelectors.addNaturalSelector(a_selector);
        } else {
            this.m_postSelectors.addNaturalSelector(a_selector);
        }
    }

    public void setMinimumPopSizePercent(int a_minimumSizeGuaranteedPercent) {
        this.m_minPercentageSizePopulation = a_minimumSizeGuaranteedPercent;
    }

    public int getMinimumPopSizePercent() {
        return this.m_minPercentageSizePopulation;
    }

    public FitnessEvaluator getFitnessEvaluator() {
        return this.m_fitnessEvaluator;
    }

    public void setFitnessEvaluator(FitnessEvaluator a_fitnessEvaluator) {
        if (a_fitnessEvaluator == null) {
            throw new IllegalStateException("The fitness evaluator object must not be null!");
        }
        this.checkProperty(PROPERTY_FITEVAL_INST, a_fitnessEvaluator, this.m_fitnessEvaluator, "Fitness evaluator has already been set differently.");
        this.m_fitnessEvaluator = a_fitnessEvaluator;
    }

    public boolean isPreserveFittestIndividual() {
        return this.m_preserveFittestIndividual;
    }

    public void setPreservFittestIndividual(boolean a_preserveFittest) {
        this.m_preserveFittestIndividual = a_preserveFittest;
    }

    public void incrementGenerationNr() {
        ++this.m_generationNr;
    }

    public int getGenerationNr() {
        return this.m_generationNr;
    }

    public ConfigurationHandler getConfigurationHandler() {
        return this.m_conHandler;
    }

    public String toString() {
        int i;
        String result = "Configuration:";
        result = result + "\n Configuration name: " + this.getName();
        result = result + "\n Population size: " + this.getPopulationSize();
        result = result + "\n Minimum pop. size [%]: " + this.getMinimumPopSizePercent();
        result = result + "\n Chromosome size: " + this.getChromosomeSize();
        result = result + "\n Sample Chromosome:\n";
        if (this.getSampleChromosome() == null) {
            result = result + "\n null";
        } else {
            result = result + "\n    Size: " + this.getSampleChromosome().size();
            result = result + "\n    toString: " + this.getSampleChromosome().toString();
        }
        result = result + "\n  Random generator: ";
        result = this.getRandomGenerator() != null ? result + this.getRandomGenerator().getClass().getName() : result + S_NONE;
        result = result + "\n  Event manager: ";
        result = this.getEventManager() == null ? result + S_NONE : result + this.getEventManager().getClass().getName();
        result = result + "\n Configuration handler: ";
        result = this.getConfigurationHandler() == null ? result + "null" : result + this.getConfigurationHandler().getName();
        result = result + "\n Fitness function: ";
        result = this.getFitnessFunction() == null ? result + "null" : result + this.getFitnessFunction().getClass().getName();
        result = result + "\n Fitness evaluator: ";
        result = this.getFitnessEvaluator() == null ? result + "null" : result + this.getFitnessEvaluator().getClass().getName();
        result = result + "\n  Genetic operators: ";
        if (this.getGeneticOperators() == null) {
            result = result + "null";
        } else {
            int gensize = this.getGeneticOperators().size();
            if (gensize < 1) {
                result = result + S_NONE;
            } else {
                for (i = 0; i < gensize; ++i) {
                    if (i > 0) {
                        result = result + "; ";
                    }
                    result = result + " " + this.getGeneticOperators().get(i).getClass().getName();
                }
            }
        }
        int natsize = this.getNaturalSelectors(true).size();
        result = result + "\n  Natural Selectors(pre): ";
        if (natsize < 1) {
            result = result + S_NONE;
        } else {
            for (i = 0; i < natsize; ++i) {
                if (i > 0) {
                    result = result + "; ";
                }
                result = result + " " + this.getNaturalSelectors(true).get(i).getClass().getName();
            }
        }
        natsize = this.getNaturalSelectors(false).size();
        result = result + "\n  Natural Selectors(post): ";
        if (natsize < 1) {
            result = result + S_NONE;
        } else {
            for (i = 0; i < natsize; ++i) {
                if (i > 0) {
                    result = result + "; ";
                }
                result = result + " " + this.getNaturalSelectors(false).get(i).getClass().getName();
            }
        }
        return result;
    }

    public boolean isKeepPopulationSizeConstant() {
        return this.m_keepPopulationSizeConstant;
    }

    public void setKeepPopulationSizeConstant(boolean a_keepPopSizeConstant) {
        this.m_keepPopulationSizeConstant = a_keepPopSizeConstant;
    }

    public void setSelectFromPrevGen(double a_percentage) {
        if (a_percentage < 0.0 || a_percentage > 1.0) {
            throw new IllegalArgumentException("Argument must be between 0 and 1");
        }
        this.m_selectFromPrevGen = a_percentage;
    }

    public double getSelectFromPrevGen() {
        return this.m_selectFromPrevGen;
    }

    public IJGAPFactory getJGAPFactory() {
        return this.m_factory;
    }

    protected static String getThreadKey(Thread current, String a_id) {
        return current.toString() + "|" + a_id + "|";
    }

    public void setJGAPFactory(IJGAPFactory a_factory) {
        this.m_factory = a_factory;
    }

    public void setBreeder(IBreeder a_breeder) {
        assert (a_breeder != null);
        this.m_breeder = a_breeder;
    }

    public IBreeder getBreeder() {
        if (this.m_breeder == null) {
            this.m_breeder = new GABreeder();
        }
        return this.m_breeder;
    }

    public void setAlwaysCaculateFitness(boolean a_alwaysCalculate) {
        this.m_alwaysCalculateFitness = a_alwaysCalculate;
    }

    public boolean isAlwaysCalculateFitness() {
        return this.m_alwaysCalculateFitness;
    }

    protected String makeThreadKey() {
        Thread current = Thread.currentThread();
        this.threadKey = Configuration.getThreadKey(current, this.m_id);
        return this.threadKey;
    }

    private void readObject(ObjectInputStream a_inputStream) throws ClassNotFoundException, IOException {
        a_inputStream.defaultReadObject();
        this.makeThreadKey();
    }

    public String getId() {
        return this.m_id;
    }

    protected void setId(String a_id) {
        this.m_id = a_id;
    }

    public Object clone() {
        return this.newInstance(this.m_id, this.m_name);
    }

    public Configuration newInstance(String a_id, String a_name) {
        try {
            Configuration result = new Configuration(this.m_name);
            if (this.m_factory instanceof ICloneable) {
                result.m_factory = (IJGAPFactory)((ICloneable)((Object)this.m_factory)).clone();
            } else {
                this.m_factory = new JGAPFactory(false);
                result.m_factory = (IJGAPFactory)((JGAPFactory)this.m_factory).clone();
            }
            if (this.m_breeder != null) {
                result.m_breeder = (IBreeder)this.doClone(this.m_breeder);
            }
            if (this.m_bulkObjectiveFunction != null) {
                result.m_bulkObjectiveFunction = this.m_bulkObjectiveFunction;
            }
            result.m_chromosomeSize = this.m_chromosomeSize;
            result.m_eventManager = (IEventManager)this.doClone(this.m_eventManager);
            result.m_fitnessEvaluator = (FitnessEvaluator)this.doClone(this.m_fitnessEvaluator);
            result.m_generationNr = 0;
            result.m_geneticOperators = (List)this.doClone(this.m_geneticOperators);
            result.m_keepPopulationSizeConstant = this.m_keepPopulationSizeConstant;
            result.m_minPercentageSizePopulation = this.m_minPercentageSizePopulation;
            result.m_selectFromPrevGen = this.m_selectFromPrevGen;
            result.m_objectiveFunction = (FitnessFunction)this.doClone(this.m_objectiveFunction);
            result.m_postSelectors = (ChainOfSelectors)this.doClone(this.m_postSelectors);
            result.m_preSelectors = (ChainOfSelectors)this.doClone(this.m_preSelectors);
            result.m_preserveFittestIndividual = this.m_preserveFittestIndividual;
            result.m_randomGenerator = (RandomGenerator)this.doClone(this.m_randomGenerator);
            if (this.m_sampleChromosome != null) {
                result.m_sampleChromosome = (IChromosome)this.m_sampleChromosome.clone();
            }
            result.m_alwaysCalculateFitness = this.m_alwaysCalculateFitness;
            result.m_settingsLocked = this.m_settingsLocked;
            result.m_config = new ConfigurationConfigurable();
            result.m_config.m_populationSize = this.m_config.m_populationSize;
            result.m_name = a_name;
            result.m_id = a_id;
            result.makeThreadKey();
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }

    protected Object doClone(Object a_objToClone) throws Exception {
        ICloneHandler handler;
        if (a_objToClone != null && (handler = this.getJGAPFactory().getCloneHandlerFor(a_objToClone, null)) != null) {
            return handler.perform(a_objToClone, null, null);
        }
        return null;
    }

    public boolean equals(Object a_other) {
        return this.compareTo(a_other) == 0;
    }

    public int compareTo(Object a_other) {
        if (a_other == null) {
            return 1;
        }
        Configuration other = (Configuration)a_other;
        try {
            return new CompareToBuilder().append(this.m_config.m_populationSize, other.m_config.m_populationSize).append(this.m_factory, other.m_factory).append(this.m_breeder, other.m_breeder).append(this.m_objectiveFunction, other.m_objectiveFunction).append(this.m_fitnessEvaluator, other.m_fitnessEvaluator).append(this.m_bulkObjectiveFunction, other.m_bulkObjectiveFunction).append(this.m_sampleChromosome, other.m_sampleChromosome).append(this.m_randomGenerator, other.m_randomGenerator).append(this.m_geneticOperators.toArray(), other.m_geneticOperators.toArray()).append(this.m_chromosomeSize, other.m_chromosomeSize).append(this.m_preSelectors, other.m_preSelectors).append(this.m_postSelectors, other.m_postSelectors).append(this.m_preserveFittestIndividual, other.m_preserveFittestIndividual).append(this.threadKey, other.threadKey).append(this.m_keepPopulationSizeConstant, other.m_keepPopulationSizeConstant).append(this.m_alwaysCalculateFitness, other.m_alwaysCalculateFitness).append(this.m_minPercentageSizePopulation, other.m_minPercentageSizePopulation).append(this.m_selectFromPrevGen, other.m_selectFromPrevGen).append(this.m_generationNr, other.m_generationNr).append(this.m_name, other.m_name).append(this.m_settingsLocked, other.m_settingsLocked).toComparison();
        }
        catch (ClassCastException cex) {
            throw new RuntimeException("Cannot compare all objects within org.jgap.Configuration, because at least one does not implement interface java.lang.Comparable!");
        }
    }

    class ConfigurationConfigurable
    implements Serializable {
        int m_populationSize;

        ConfigurationConfigurable() {
        }
    }
}

