/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.List;
import java.util.Vector;
import org.jgap.BaseChromosome;
import org.jgap.Configuration;
import org.jgap.FitnessEvaluator;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.Genotype;
import org.jgap.IChromosome;
import org.jgap.IChromosomePool;
import org.jgap.ICloneHandler;
import org.jgap.IGeneConstraintChecker;
import org.jgap.IJGAPFactory;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class Chromosome
extends BaseChromosome {
    private static final String CVS_REVISION = "$Revision: 1.99 $";
    private Object m_applicationData;
    private List m_multiObjective;
    private boolean m_isSelectedForNextGeneration;
    protected double m_fitnessValue = -1.0;
    private boolean m_compareAppData;
    private IGeneConstraintChecker m_geneAlleleChecker;
    private boolean m_alwaysCalculate;

    public Chromosome() throws InvalidConfigurationException {
        this(Genotype.getStaticConfiguration());
    }

    public Chromosome(Configuration a_configuration) throws InvalidConfigurationException {
        super(a_configuration);
        this.m_alwaysCalculate = a_configuration.isAlwaysCalculateFitness();
    }

    public Chromosome(Configuration a_configuration, String a_persistentRepresentatuion) throws InvalidConfigurationException, UnsupportedRepresentationException {
        this(a_configuration);
        this.setValueFromPersistentRepresentation(a_persistentRepresentatuion);
    }

    public Chromosome(Configuration a_configuration, int a_desiredSize) throws InvalidConfigurationException {
        this(a_configuration);
        if (a_desiredSize <= 0) {
            throw new IllegalArgumentException("Chromosome size must be greater than zero");
        }
        this.setGenes(new Gene[a_desiredSize]);
    }

    public Chromosome(Configuration a_configuration, Gene a_sampleGene, int a_desiredSize) throws InvalidConfigurationException {
        this(a_configuration, a_desiredSize);
        this.initFromGene(a_sampleGene);
    }

    public Chromosome(Configuration a_configuration, Gene a_sampleGene, int a_desiredSize, IGeneConstraintChecker a_constraintChecker) throws InvalidConfigurationException {
        this(a_configuration, a_desiredSize);
        this.initFromGene(a_sampleGene);
        this.setConstraintChecker(a_constraintChecker);
    }

    protected void initFromGene(Gene a_sampleGene) {
        if (a_sampleGene == null) {
            throw new IllegalArgumentException("Sample Gene cannot be null.");
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.setGene(i, a_sampleGene.newGene());
        }
    }

    public Chromosome(Configuration a_configuration, Gene[] a_initialGenes) throws InvalidConfigurationException {
        this(a_configuration, a_initialGenes == null ? 0 : a_initialGenes.length);
        this.checkGenes(a_initialGenes);
        this.setGenes(a_initialGenes);
    }

    public Chromosome(Configuration a_configuration, Gene[] a_initialGenes, IGeneConstraintChecker a_constraintChecker) throws InvalidConfigurationException {
        this(a_configuration, a_initialGenes.length);
        this.checkGenes(a_initialGenes);
        this.setGenes(a_initialGenes);
        this.setConstraintChecker(a_constraintChecker);
    }

    protected void checkGenes(Gene[] a_initialGenes) {
        for (int i = 0; i < a_initialGenes.length; ++i) {
            if (a_initialGenes[i] != null) continue;
            throw new IllegalArgumentException("The gene at index " + i + " in the given array of " + "genes was found to be null. No gene in the array " + "may be null.");
        }
    }

    public synchronized Object clone() {
        if (this.getConfiguration() == null) {
            throw new IllegalStateException("The active Configuration object must be set on this Chromosome prior to invocation of the clone() method.");
        }
        IChromosome copy = null;
        IChromosomePool pool = this.getConfiguration().getChromosomePool();
        if (pool != null && (copy = pool.acquireChromosome()) != null) {
            Gene[] genes = copy.getGenes();
            for (int i = 0; i < this.size(); ++i) {
                genes[i].setAllele(this.getGene(i).getAllele());
            }
        }
        try {
            if (copy == null) {
                int size = this.size();
                if (size > 0) {
                    Gene[] copyOfGenes = new Gene[size];
                    for (int i = 0; i < copyOfGenes.length; ++i) {
                        ICloneHandler cloner;
                        IJGAPFactory factory;
                        copyOfGenes[i] = this.getGene(i).newGene();
                        Object allele = this.getGene(i).getAllele();
                        if (allele != null && (factory = this.getConfiguration().getJGAPFactory()) != null && (cloner = factory.getCloneHandlerFor(allele, allele.getClass())) != null) {
                            try {
                                allele = cloner.perform(allele, null, this);
                            }
                            catch (Exception ex) {
                                throw new RuntimeException(ex);
                            }
                        }
                        copyOfGenes[i].setAllele(allele);
                    }
                    if (this.getClass() == Chromosome.class) {
                        copy = new Chromosome(this.getConfiguration(), copyOfGenes);
                    } else {
                        copy = (IChromosome)this.getConfiguration().getSampleChromosome().clone();
                        copy.setGenes(copyOfGenes);
                    }
                } else {
                    copy = this.getClass() == Chromosome.class ? new Chromosome(this.getConfiguration()) : (IChromosome)this.getConfiguration().getSampleChromosome().clone();
                }
            }
            copy.setFitnessValue(this.m_fitnessValue);
            copy.setConstraintChecker(this.getConstraintChecker());
        }
        catch (InvalidConfigurationException iex) {
            throw new IllegalStateException(iex.getMessage());
        }
        try {
            copy.setApplicationData(this.cloneObject(this.getApplicationData()));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        if (this.m_multiObjective != null && this.getClass() == Chromosome.class) {
            try {
                ((Chromosome)copy).setMultiObjectives((List)this.cloneObject(this.m_multiObjective));
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex.getMessage());
            }
        }
        return copy;
    }

    protected Object cloneObject(Object a_object) throws Exception {
        if (a_object == null) {
            return null;
        }
        ICloneHandler cloner = this.getConfiguration().getJGAPFactory().getCloneHandlerFor(a_object, a_object.getClass());
        if (cloner != null) {
            return cloner.perform(a_object, null, this);
        }
        return a_object;
    }

    public double getFitnessValue() {
        if (this.m_fitnessValue >= 0.0 && !this.m_alwaysCalculate) {
            return this.m_fitnessValue;
        }
        return this.calcFitnessValue();
    }

    public double getFitnessValueDirectly() {
        return this.m_fitnessValue;
    }

    protected double calcFitnessValue() {
        FitnessFunction normalFitnessFunction;
        if (this.getConfiguration() != null && (normalFitnessFunction = this.getConfiguration().getFitnessFunction()) != null) {
            this.m_fitnessValue = normalFitnessFunction.getFitnessValue(this);
        }
        return this.m_fitnessValue;
    }

    public void setFitnessValue(double a_newFitnessValue) {
        if (a_newFitnessValue >= 0.0 && Math.abs(this.m_fitnessValue - a_newFitnessValue) > 1.0E-7) {
            this.m_fitnessValue = a_newFitnessValue;
        }
    }

    public void setFitnessValueDirectly(double a_newFitnessValue) {
        this.m_fitnessValue = a_newFitnessValue;
    }

    public String toString() {
        StringBuffer representation = new StringBuffer();
        representation.append("Size:" + this.size());
        representation.append(", Fitness value:" + this.m_fitnessValue);
        representation.append(", Alleles:");
        representation.append("[");
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                representation.append(", ");
            }
            if (this.getGene(i) == null) {
                representation.append("null");
                continue;
            }
            representation.append(((Object)this.getGene(i)).toString());
        }
        representation.append("]");
        String appData = this.getApplicationData() != null ? this.getApplicationData().toString() : "null";
        representation.append(", Application data:" + appData);
        return representation.toString();
    }

    public static IChromosome randomInitialChromosome(Configuration a_configuration) throws InvalidConfigurationException {
        IChromosome randomChromosome;
        if (a_configuration == null) {
            throw new IllegalArgumentException("Configuration instance must not be null");
        }
        a_configuration.lockSettings();
        IChromosomePool pool = a_configuration.getChromosomePool();
        if (pool != null && (randomChromosome = pool.acquireChromosome()) != null) {
            Gene[] genes = randomChromosome.getGenes();
            RandomGenerator generator = a_configuration.getRandomGenerator();
            for (int i = 0; i < genes.length; ++i) {
                genes[i].setToRandomValue(generator);
            }
            randomChromosome.setFitnessValueDirectly(-1.0);
            return randomChromosome;
        }
        IChromosome sampleChromosome = a_configuration.getSampleChromosome();
        sampleChromosome.setFitnessValue(-1.0);
        Gene[] sampleGenes = sampleChromosome.getGenes();
        Gene[] newGenes = new Gene[sampleGenes.length];
        RandomGenerator generator = a_configuration.getRandomGenerator();
        for (int i = 0; i < newGenes.length; ++i) {
            newGenes[i] = sampleGenes[i].newGene();
            newGenes[i].setToRandomValue(generator);
        }
        return new Chromosome(a_configuration, newGenes);
    }

    public boolean equals(Object other) {
        try {
            return this.compareTo(other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public int hashCode() {
        int hashCode = 1;
        if (this.getGenes() != null) {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                Gene gene = this.getGene(i);
                int geneHashcode = gene == null ? -55 : gene.hashCode();
                hashCode = 31 * hashCode + geneHashcode;
            }
        }
        return hashCode;
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        int size = this.size();
        IChromosome otherChromosome = (IChromosome)other;
        Gene[] otherGenes = otherChromosome.getGenes();
        if (otherChromosome.size() != size) {
            return this.size() - otherChromosome.size();
        }
        for (int i = 0; i < size; ++i) {
            int comparison = this.getGene(i).compareTo(otherGenes[i]);
            if (comparison == 0) continue;
            return comparison;
        }
        if (this.m_fitnessValue != otherChromosome.getFitnessValueDirectly()) {
            FitnessEvaluator eval = this.getConfiguration().getFitnessEvaluator();
            if (eval != null) {
                if (eval.isFitter(this.m_fitnessValue, otherChromosome.getFitnessValueDirectly())) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
        if (this.m_compareAppData) {
            if (this.getApplicationData() == null) {
                if (otherChromosome.getApplicationData() != null) {
                    return -1;
                }
            } else {
                if (otherChromosome.getApplicationData() == null) {
                    return 1;
                }
                if (this.getApplicationData() instanceof Comparable) {
                    try {
                        return ((Comparable)this.getApplicationData()).compareTo(otherChromosome.getApplicationData());
                    }
                    catch (ClassCastException cex) {
                        return -1;
                    }
                }
                return this.getApplicationData().getClass().getName().compareTo(otherChromosome.getApplicationData().getClass().getName());
            }
        }
        return 0;
    }

    public void setIsSelectedForNextGeneration(boolean a_isSelected) {
        this.m_isSelectedForNextGeneration = a_isSelected;
    }

    public boolean isSelectedForNextGeneration() {
        return this.m_isSelectedForNextGeneration;
    }

    public void cleanup() {
        if (this.getConfiguration() == null) {
            throw new IllegalStateException("The active Configuration object must be set on this Chromosome prior to invocation of the cleanup() method.");
        }
        this.getConfiguration().getFitnessFunction();
        this.m_fitnessValue = -1.0;
        this.m_isSelectedForNextGeneration = false;
        IChromosomePool pool = this.getConfiguration().getChromosomePool();
        if (pool != null) {
            pool.releaseChromosome(this);
        } else {
            for (int i = 0; i < this.size(); ++i) {
                this.getGene(i).cleanup();
            }
        }
    }

    public void setApplicationData(Object a_newData) {
        this.m_applicationData = a_newData;
    }

    public Object getApplicationData() {
        return this.m_applicationData;
    }

    public void setGenes(Gene[] a_genes) throws InvalidConfigurationException {
        super.setGenes(a_genes);
        this.verify(this.getConstraintChecker());
    }

    public void setCompareApplicationData(boolean a_doCompare) {
        this.m_compareAppData = a_doCompare;
    }

    public boolean isCompareApplicationData() {
        return this.m_compareAppData;
    }

    public void setConstraintChecker(IGeneConstraintChecker a_constraintChecker) throws InvalidConfigurationException {
        this.verify(a_constraintChecker);
        this.m_geneAlleleChecker = a_constraintChecker;
    }

    public IGeneConstraintChecker getConstraintChecker() {
        return this.m_geneAlleleChecker;
    }

    protected void verify(IGeneConstraintChecker a_constraintChecker) throws InvalidConfigurationException {
        if (a_constraintChecker != null && this.getGenes() != null) {
            int len = this.getGenes().length;
            for (int i = 0; i < len; ++i) {
                Gene gene = this.getGene(i);
                if (a_constraintChecker.verify(gene, null, this, i)) continue;
                throw new InvalidConfigurationException("The gene type " + gene.getClass().getName() + " is not allowed to be used in the chromosome due to the" + " constraint checker used.");
            }
        }
    }

    public boolean isHandlerFor(Object a_obj, Class a_class) {
        return a_class == Chromosome.class;
    }

    public Object perform(Object a_obj, Class a_class, Object a_params) throws Exception {
        return Chromosome.randomInitialChromosome(this.getConfiguration());
    }

    public void setMultiObjectives(List a_values) {
        if (this.m_multiObjective == null) {
            this.m_multiObjective = new Vector();
        }
        this.m_multiObjective.clear();
        this.m_multiObjective.addAll(a_values);
    }

    public List getMultiObjectives() {
        return this.m_multiObjective;
    }
}

