import dynamic from "next/dynamic"
import ElementsLoading from "../../ElementsLoading"

const elements: ElementsRecord = {
  Accordion: dynamic(() => import("@mui/material/Accordion"), { loading: ElementsLoading, ssr: false }),
  LoadingButton: dynamic(() => import("@mui/lab/LoadingButton"), { loading: ElementsLoading, ssr: false }),
  Alert: dynamic(() => import("@mui/lab/Alert"), { loading: ElementsLoading, ssr: false }),
  AlertTitle: dynamic(() => import("@mui/lab/AlertTitle"), { loading: ElementsLoading, ssr: false }),
  Autocomplete: dynamic(() => import("@mui/lab/Autocomplete"), { loading: ElementsLoading, ssr: false }),
  AvatarGroup: dynamic(() => import("@mui/lab/AvatarGroup"), { loading: ElementsLoading, ssr: false }),
  CalendarPicker: dynamic(() => import("@mui/lab/CalendarPicker"), { loading: ElementsLoading, ssr: false }),
  CalendarPickerSkeleton: dynamic(() => import("@mui/lab/CalendarPickerSkeleton"), { loading: ElementsLoading, ssr: false }),
  ClockPicker: dynamic(() => import("@mui/lab/ClockPicker"), { loading: ElementsLoading, ssr: false }),
  DatePicker: dynamic(() => import("@mui/lab/DatePicker"), { loading: ElementsLoading, ssr: false }),
  DateTimePicker: dynamic(() => import("@mui/lab/DateTimePicker"), { loading: ElementsLoading, ssr: false }),
  DesktopDatePicker: dynamic(() => import("@mui/lab/DesktopDatePicker"), { loading: ElementsLoading, ssr: false }),
  DesktopDateTimePicker: dynamic(() => import("@mui/lab/DesktopDateTimePicker"), { loading: ElementsLoading, ssr: false }),
  DesktopTimePicker: dynamic(() => import("@mui/lab/DesktopTimePicker"), { loading: ElementsLoading, ssr: false }),
  LocalizationProvider: dynamic(() => import("@mui/lab/LocalizationProvider"), { loading: ElementsLoading, ssr: false }),
  Masonry: dynamic(() => import("@mui/lab/Masonry"), { loading: ElementsLoading, ssr: false }),
  MobileDatePicker: dynamic(() => import("@mui/lab/MobileDatePicker"), { loading: ElementsLoading, ssr: false }),
  MobileDateTimePicker: dynamic(() => import("@mui/lab/MobileDateTimePicker"), { loading: ElementsLoading, ssr: false }),
  MobileTimePicker: dynamic(() => import("@mui/lab/MobileTimePicker"), { loading: ElementsLoading, ssr: false }),
  MonthPicker: dynamic(() => import("@mui/lab/MonthPicker"), { loading: ElementsLoading, ssr: false }),
  Pagination: dynamic(() => import("@mui/lab/Pagination"), { loading: ElementsLoading, ssr: false }),
  PaginationItem: dynamic(() => import("@mui/lab/PaginationItem"), { loading: ElementsLoading, ssr: false }),
  PickersDay: dynamic(() => import("@mui/lab/PickersDay"), { loading: ElementsLoading, ssr: false }),
  Rating: dynamic(() => import("@mui/lab/Rating"), { loading: ElementsLoading, ssr: false }),
  Skeleton: dynamic(() => import("@mui/lab/Skeleton"), { loading: ElementsLoading, ssr: false }),
  SpeedDial: dynamic(() => import("@mui/lab/SpeedDial"), { loading: ElementsLoading, ssr: false }),
  SpeedDialAction: dynamic(() => import("@mui/lab/SpeedDialAction"), { loading: ElementsLoading, ssr: false }),
  SpeedDialIcon: dynamic(() => import("@mui/lab/SpeedDialIcon"), { loading: ElementsLoading, ssr: false }),
  StaticDatePicker: dynamic(() => import("@mui/lab/StaticDatePicker"), { loading: ElementsLoading, ssr: false }),
  StaticDateTimePicker: dynamic(() => import("@mui/lab/StaticDateTimePicker"), { loading: ElementsLoading, ssr: false }),
  StaticTimePicker: dynamic(() => import("@mui/lab/StaticTimePicker"), { loading: ElementsLoading, ssr: false }),
  TabContext: dynamic(() => import("@mui/lab/TabContext"), { loading: ElementsLoading, ssr: false }),
  TabList: dynamic(() => import("@mui/lab/TabList"), { loading: ElementsLoading, ssr: false }),
  TabPanel: dynamic(() => import("@mui/lab/TabPanel"), { loading: ElementsLoading, ssr: false }),
  TimePicker: dynamic(() => import("@mui/lab/TimePicker"), { loading: ElementsLoading, ssr: false }),
  Timeline: dynamic(() => import("@mui/lab/Timeline"), { loading: ElementsLoading, ssr: false }),
  TimelineConnector: dynamic(() => import("@mui/lab/TimelineConnector"), { loading: ElementsLoading, ssr: false }),
  TimelineContent: dynamic(() => import("@mui/lab/TimelineContent"), { loading: ElementsLoading, ssr: false }),
  TimelineDot: dynamic(() => import("@mui/lab/TimelineDot"), { loading: ElementsLoading, ssr: false }),
  TimelineItem: dynamic(() => import("@mui/lab/TimelineItem"), { loading: ElementsLoading, ssr: false }),
  TimelineOppositeContent: dynamic(() => import("@mui/lab/TimelineOppositeContent"), { loading: ElementsLoading, ssr: false }),
  TimelineSeparator: dynamic(() => import("@mui/lab/TimelineSeparator"), { loading: ElementsLoading, ssr: false }),
  ToggleButton: dynamic(() => import("@mui/lab/ToggleButton"), { loading: ElementsLoading, ssr: false }),
  ToggleButtonGroup: dynamic(() => import("@mui/lab/ToggleButtonGroup"), { loading: ElementsLoading, ssr: false }),
  TreeItem: dynamic(() => import("@mui/lab/TreeItem"), { loading: ElementsLoading, ssr: false }),
  TreeView: dynamic(() => import("@mui/lab/TreeView"), { loading: ElementsLoading, ssr: false }),
  YearPicker: dynamic(() => import("@mui/lab/YearPicker"), { loading: ElementsLoading, ssr: false }),
}

const loadMuiLab: ElementsLoader = element => elements[element]

export default loadMuiLab
