research-projects (temp-RIT-Tides and descendants)
research-projects-RIT

Repository for the rapid_PE / RIFT code, developed at RIT (forked long ago from work at UWM/CGCA).

## Installation

Please see INSTALL.md

## Science

If you are using this code for a production analysis, please contact us to make sure you follow the instructions included here!
Also, make sure you cite the relevant rapid_pe/RIFT papers

 1.  Pankow et al 2015
 2.  Lange et al 2018 (RIFT)
 3.  Wysocki et al 2019 (RIFT-GPU)
 4.  Wofforde et al 2022 (RIFT-Update)

When preparing your work, please cite 

 1. the relevant rapid_pe/RIFT papers
     1.  Pankow et al 2015
     2.  Lange et al 2018 (RIFT) [paper](https://arxiv.org/abs/1805.10457)
 
 2. If you are using the surrogate-basis approach, please cite
     3. O'Shaughnessy, Blackman, Field 2017 [paper](http://adsabs.harvard.edu/abs/2017CQGra..34n4002O)

 3. If you are using a GPU-optimized version, please acknowledge
     4.  Wysocki, O'Shaughnessy,  Fong, Lange [paper](https://arxiv.org/abs/1902.04934)

 4. If you are using a non-lalsuite waveform interface, please acknowledge
     a.  gwsurrogate interface: (a) O'Shaughnessy, Blackman, Field 2017 [paper](http://adsabs.harvard.edu/abs/2017CQGra..34n4002O); (b) F. Shaik et al (in prep)
     b.  TEOBResumS interface (original):  Lange et al 2018 RIFT paper
     c.  NR interface (parts inside ILE): Lange et al 2017 PRD 96, 404 [NR comparison methods paper](http://adsabs.harvard.edu/abs/2017PhRvD..96j4041L)
     d.  NRSur7dq2 interface: Lange et al 2018 (RIFT) [paper](https://arxiv.org/abs/1805.10457), and ...

  5. If you are using an updated Monte Carlo integration package, please acknowledge the authors; papers will be prepared soon
     a.  GMM integrator: Elizabeth Champion; see [original repo](https://git.ligo.org/benjamin.champion/Monte-Carlo-Integrator), implemented via MonteCarloEnsemble and mcsamplerEnsemble; please cite Ristic et al https://arxiv.org/abs/2105.07013
     b.  GPU MC integrator:  Wysocki, O'Shaughnessy; cite Wofford et al https://dcc.ligo.org/P2200059

  6. If you are using a distance-marginalized likeliihood, please acknowledge 
     a. Distance marginalization : Soichiro Morisaki, Dan Wysocki, see  Wofford et al https://dcc.ligo.org/P2200059

  7. If you are using a special coordinate system
     a. Rotated inspiral-phase : cite the original Lee, Morisaki, Tanaka paper (https://dcc.ligo.org/LIGO-P2200037); also cite Wofford et al in prep https://dcc.ligo.org/P2200059
     b. Pseudo-cylindrical coordinates: see Wofford et al https://dcc.ligo.org/P2200059

## Authorlists: Opt-in model
Several aspects of this code are very actively developed.  We encourage  close collaboration with the lead developers (O'Shaughnessy and Lange) to produce the best possible results, particularly given comparatively rapid changes to the interface and pipeline in the past and planned for the future as the user- and developer-base expands.

We expect to make the final developed code widely available and free to use, in a release-based distribution model.  But we're not there yet.  To simplify discussions about authorlist and ettiquete, we have adopted the following simple model, to be revised 4 times per year (1/15, 4/15, 7/15, 10/15):  
 * Free to use: Any code commit older than 3 years from the date an analysis <i>commences</i> is free to use for any scientific work.  
 * Opt-in: Any more recent use should offer (opt-in) authorship to the lead developers, as well as to developers who contributed significantly to features used in the version of the code adopted in an analysis.  Loosely speaking, the newer the features you use, the more proactive you should be in contacting relevant developers, to insure all authors are suitably engaged with the final product.
This policy refers only to commits in this repository, and not to resources and code maintained elsewhere or by other developers (e.g., NR Surrogates), who presumably maintain their own policy.


The following authors should be contacted 
  * O'Shaughnessy and Lange: Iterative pipeline, fitting and posterior generation code, external interfaces (EOB, surrogates)
  * Field, O'Shaughnessy, Blackman: Surrogate basis method 
  * Wysocki, O'Shaughnessy,  Fong, Lange: GPU optimizations
  * ...

## Relationship to version of rapid_pe in lalsuite
Chris Pankow has also been maintaining a [port of the original rapid_pe as part of lalsuite](https://github.com/lscsoft/lalsuite/tree/master/lalinference/python/lalinference/rapid_pe). While this code is unreviewed and has many API and workflow differences, the underlying likelihood evaluation procedure has been the same (until the recent GPU rewrite).  We hope to eventually merge the codebases, likely by modernizing the version in lalsuite and/or by ports of rapid_pe techniques to next-generation PE codes.


## Version numbers

Short term: roughly major.minor.feature_upgrade.internal_rc_candidates.   So the 4th number are upgraded every few major bugfixes or moves; the 3rd number will upgrade if we add a feature.  We hope to eventually reach version 0.1 for production automated unsupervised analysis during O4

Medium-term: Amajor API change or two we are thinking about for how the users specify workflows should be 0.2

Long-term: Version 1 will reduce dependency on hardcoded parameter names. More flexibility in how inference is done. 
