from platemap import Plate, add_volume
from string import ascii_uppercase

LINKER_96_LAYOUT = {
    "A1": "L1-S",
    "A2": "L2-S",
    "A3": "L3-S",
    "A4": "L4-S",
    "A5": "L5-S",
    "A6": "L6-S",
    "A7": "LMP-S",
    "A8": "LMS-S",
    "B1": "L1-P",
    "B2": "L2-p",
    "B3": "L3-P",
    "B4": "L4-P",
    "B5": "L5-P",
    "B6": "L6-P",
    "B7": "LMP-P",
    "B8": "LMS-P",
    "A9": "LF1-S",
    "B9": "LF1-P",
    "C1": "UTR1-S",
    "C2": "UTR2-S",
    "C3": "UTR3-S",
    "C4": "UTR1-RBS1-P",
    "C5": "UTR1-RBS2-P",
    "C6": "UTR1-RBS3-P",
    "C7": "UTR2-RBS1-P",
    "C8": "UTR2-RBS2-P",
    "C9": "UTR2-RBS3-P",
    "C10": "UTR3-RBS1-P",
    "C11": "UTR3-RBS2-P",
    "C12": "UTR3-RBS3-P",
    "D1": "UTR1-RBS-A01-P",
    "D2": "UTR1-RBS-A02-P",
    "D3": "UTR1-RBS-A03-P",
    "D4": "UTR1-RBS-A04-P",
    "D5": "UTR1-RBS-A05-P",
    "D6": "UTR1-RBS-A06-P",
    "D7": "UTR1-RBS-A07-P",
    "D8": "UTR1-RBS-A08-P",
    "D9": "UTR1-RBS-A09-P",
    "D10": "UTR1-RBS-A10-P",
    "D11": "UTR1-RBS-A11-P",
    "D12": "UTR1-RBS-A12-P",
    "E1": "UTR2-RBS-A01-P",
    "E2": "UTR2-RBS-A02-P",
    "E3": "UTR2-RBS-A03-P",
    "E4": "UTR2-RBS-A04-P",
    "E5": "UTR2-RBS-A05-P",
    "E6": "UTR2-RBS-A06-P",
    "E7": "UTR2-RBS-A07-P",
    "E8": "UTR2-RBS-A08-P",
    "E9": "UTR2-RBS-A09-P",
    "E10": "UTR2-RBS-A10-P",
    "E11": "UTR2-RBS-A11-P",
    "E12": "UTR2-RBS-A12-P",
    "F1": "UTR3-RBS-A01-P",
    "F2": "UTR3-RBS-A02-P",
    "F3": "UTR3-RBS-A03-P",
    "F4": "UTR3-RBS-A04-P",
    "F5": "UTR3-RBS-A05-P",
    "F6": "UTR3-RBS-A06-P",
    "F7": "UTR3-RBS-A07-P",
    "F8": "UTR3-RBS-A08-P",
    "F9": "UTR3-RBS-A09-P",
    "F10": "UTR3-RBS-A10-P",
    "F11": "UTR3-RBS-A11-P",
    "F12": "UTR3-RBS-A12-P",
    "A10": "UTR1-RBS-AM12-P",
    "B10": "UTR1-RBS-AM24-P",
    "A11": "UTR2-RBS-AM12-P",
    "B11": "UTR2-RBS-AM24-P",
    "A12": "UTR3-RBS-AM12-P",
    "B12": "UTR3-RBS-AM24-P",
    "G1": "LF2-S",
    "G2": "LF3-S",
    "G3": "LF4-S",
    "G4": "LF5-S",
    "G5": "LF6-S",
    "H1": "LF2-P",
    "H2": "LF3-P",
    "H3": "LF4-P",
    "H4": "LF5-P",
    "H5": "LF6-P",
    "G6": "L1-S",
    "G7": "L2-S",
    "G8": "L3-S",
    "G9": "LMP-S",
    "G10": "LMS-S",
    "G11": "UTR1-S",
    "G12": "UTR2-S",
    "H6": "L1-P",
    "H7": "L2-p",
    "H8": "L3-P",
    "H9": "LMP-P",
    "H10": "LMS-P",
    "H11": "UTR3-S",
}

LINKER_384_PLATE = Plate(size=384, deadspace=20e3, well_volume=65e3)
for key, value in LINKER_96_LAYOUT.items():
    row_index = ascii_uppercase.index(key[0])
    column_index = int(key[1:]) - 1
    add_volume(
        destination_plate=LINKER_384_PLATE,
        destination_well=ascii_uppercase[row_index * 2] + str(column_index * 2 + 1),
        volume=45e3,
        volume_id=value,
    )
    add_volume(
        destination_plate=LINKER_384_PLATE,
        destination_well=ascii_uppercase[row_index * 2 + 1] + str(column_index * 2 + 1),
        volume=45e3,
        volume_id=value,
    )
    add_volume(
        destination_plate=LINKER_384_PLATE,
        destination_well=ascii_uppercase[row_index * 2] + str(column_index * 2 + 2),
        volume=45e3,
        volume_id=value,
    )
    add_volume(
        destination_plate=LINKER_384_PLATE,
        destination_well=ascii_uppercase[row_index * 2 + 1] + str(column_index * 2 + 2),
        volume=45e3,
        volume_id=value,
    )
