# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tocase']

package_data = \
{'': ['*']}

install_requires = \
['regex']

setup_kwargs = {
    'name': 'tocase',
    'version': '0.2.3',
    'description': 'tocase provides an API to recase string into any case',
    'long_description': '[![PyPI Version][pypi-image]][pypi-url]\n[![Build Status][build-image]][build-url]\n\n<!-- Badges -->\n\n[pypi-image]: https://img.shields.io/pypi/v/summarize_dataframe\n[pypi-url]: https://pypi.org/project/summarize-dataframe/\n[build-image]: https://github.com/fbraza/summarize_dataframe/actions/workflows/ci.yml/badge.svg\n[build-url]: https://github.com/fbraza/summarize_dataframe/blob/master/.github/workflows/ci.yml\n\n![](assets/banner_ToCase.png)\n\n## Functionality\n\n`tocase` leverages the `regex` library to convert your strings into any case.\n\n## Setup\n\nTo install the package run the following command:\n\n```bash\npip install tocase\n```\n\nOnce installed import the `ToCase` class.\n\n```python\nfrom tocase.tocase import ToCase\n```\n\n## Usage\n\n### Camel\n\nIt is a naming convention where the first letter in compound words is capitalized, except for the first one.\n\n```python\n# Example with simple string\nTocase("camel-case").camel() # ==> camelCase\nTocase("camel case").camel() # ==> camelCase\n\n# Example with Pandas DataFrame and Iris DataFrame\nlist(df_with_original_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\ndf_with_modified_column_names = df.rename(columns=lambda x: ToCase(x).camel()\nlist(df_with_modified_column_names.columns) = [\'sepalLength\', \'sepalWidth\', \'petalLength\', \'petalWidth\', \'species\']\n```\n\n### Constant\n\nIt is a naming convention where all letters in compound words are capitalized. Words are joined with an underscore.\n\n```python\n# Example with simple string\nTocase("Constant-case").constant() # ==> CONSTANT_CASE\nTocase("constant Case").constant() # ==> CONSTANT_CASE\n\n# Example with Pandas DataFrame and Iris DataFrame\nlist(df_with_original_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\ndf_with_modified_column_names = df.rename(columns=lambda x: ToCase(x).constant()\nlist(df_with_modified_column_names.columns) = [\'SEPAL_LENGTH\', \'SEPAL_WIDTH\', \'PETAL_LENGTH\', \'PETAL_WIDTH\', \'SPECIES\']\n```\n\n### Dot\n\nIt is a naming convention where all letters in compound words are lowercased. Words are joined with a dot.\n\n```python\n# Example with simple string\nTocase("Dot-case").dot() # ==> dot.case\nTocase("dot Case").dot() # ==> dot.case\n\n# Example with Pandas DataFrame and Iris DataFrame\nlist(df_with_original_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\ndf_with_modified_column_names = df.rename(columns=lambda x: ToCase(x).dot()\nlist(df_with_modified_column_names.columns) = [\'sepal.length\', \'sepal.width\', \'petal.length\', \'petal.width\', \'species\']\n```\n\n### Header\n\nIt is a naming convention where the first letter in compound words is capitalized. Words are joined by a dash.\n\n```python\n# Example with simple string\nTocase("Header-case").header() # ==> Header-Case\nTocase("header Case").header() # ==> Header-Case\n\n# Example with Pandas DataFrame and Iris DataFrame\nlist(df_with_original_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\ndf_with_modified_column_names = df.rename(columns=lambda x: ToCase(x).header()\nlist(df_with_modified_column_names.columns) = [\'Sepal-Length\', \'Sepal-Width\', \'Petal-Length\', \'Petal-Width\', \'Species\']\n```\n\n### Kebab\n\nIt is a naming convention where all letters in compound words are lowercased. Words are joined by a dash.\n\n```python\n# Example with simple string\nTocase("Kebab-case").kebab() # ==> kebab-case\nTocase("kebab Case").kebab() # ==> kebab-case\n\n# Example with Pandas DataFrame and Iris DataFrame\nlist(df_with_original_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\ndf_with_modified_column_names = df.rename(columns=lambda x: ToCase(x).kebab()\nlist(df_with_modified_column_names.columns) = [\'sepal-length\', \'sepal-width\', \'petal-length\', \'petal-width\', \'species\']\n```\n\n### Pascal\n\nIt is a naming convention where the first letter in compound words is capitalized.\n\n```python\n# Example with simple string\nTocase("Pascal-case").pascal() # ==> PascalCase\nTocase("pascal Case").pascal() # ==> PascalCase\n\n# Example with Pandas DataFrame and Iris DataFrame\nlist(df_with_original_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\ndf_with_modified_column_names = df.rename(columns=lambda x: ToCase(x).pascal()\nlist(df_with_modified_column_names.columns) = [\'SepalLength\', \'SepalWidth\', \'PetalLength\', \'PetalWidth\', \'Species\']\n```\n\n### Snake\n\nIt is a naming convention where all letters in compound words are lowercased. Words are joined by an underscore.\n\n```python\n# Example with simple string\nTocase("Snake-case").snake() # ==> snake_case\nTocase("snake Case").snake() # ==> snake_case\n\n# Example with Pandas DataFrame and Iris DataFrame\nlist(df_with_original_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\ndf_with_modified_column_names = df.rename(columns=lambda x: ToCase(x).snake()\nlist(df_with_modified_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\n```\n\n### Title\n\nIt is a naming convention where the first letter in compound words is capitalized. Words are separated by a space.\n\n```python\n# Example with simple string\nTocase("Title-case").title() # ==> "Title Case"\nTocase("title Case").title() # ==> "Title Case"\n\n# Example with Pandas DataFrame and Iris DataFrame\nlist(df_with_original_column_names.columns) = [\'sepal_length\', \'sepal_width\', \'petal_length\', \'petal_width\', \'species\']\ndf_with_modified_column_names = df.rename(columns=lambda x: ToCase(x).title()\nlist(df_with_modified_column_names.columns) = [\'Sepal Length\', \'Sepal Width\', \'Petal Length\', \'Petal Width\', \'Species\']\n```\n\n## For developers\n\nClone or download the repository on your machine. If you have `poetry` installed just run the following command to restore the working environment:\n\n```bash\npoetry install\n```\n\nIf you don\'t have `poetry` you can use `pip` and the `requirements.txt` file:\n\n```bash\npip install -r requirements.txt\n```\n\nTo run tests, stay at the root of the directory and run:\n\n```bash\npytest -v\n```\n\nAll contributions are more than welcome. So feel free to to make a PR.\n\n## Author\n\nFaouzi Braza\n',
    'author': 'fbraza',
    'author_email': 'fbraza@tutanota.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/fbraza/toCase',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.9,<4.0.0',
}


setup(**setup_kwargs)
