<!--
SPDX-FileCopyrightText: 2022 The dune-iga developers developers mueller@ibb.uni-stuttgart.de
SPDX-License-Identifier: LGPL-3.0-or-later
-->
# dune-iga
[![codecov](https://codecov.io/github/rath3t/dune-iga/branch/main/graph/badge.svg?token=4O9UV99UR6)](https://codecov.io/github/rath3t/dune-iga)

Preparing the Sources
=========================

Additional to the software mentioned in README, you'll need the
following programs installed on your system:

  cmake >= 2.8.6

or if you use the old autoconf build system:

  automake >= 1.9

  autoconf >= 2.62

  libtool

Getting started
---------------

If these preliminaries are met, you should run

  dunecontrol all

which will find all installed dune modules as well as all dune modules
(not installed) which sources reside in a subdirectory of the current
directory. Note that if dune is not installed properly you will either
have to add the directory where the dunecontrol script resides (probably
./dune-common/bin) to your path or specify the relative path of the script.

On your project and all uninstalled DUNE source modules found the script
will then call the GNU autoconf/automake to create a ./configure-script
and the Makefiles. Afterwards that configure script will be called and the
modules will be build using make all

Most probably you'll have to provide additional information to dunecontrol
(e. g. compilers, configure options) and/or make options.

The most convenient way is to use options files in this case. The files
define four variables:

CMAKE_FLAGS      flags passed to cmake
AUTOGEN_FLAGS    flags passed to autogen
CONFIGURE_FLAGS  flags passed to configure
MAKE_FLAGS       flags passed to make

An example options file might look like this:

#use this options to autogen, configure and make if no other options are given
CMAKE_FLAGS=" \
-DCMAKE_CXX_COMPILER=g++-4.9 \
-DCMAKE_CXX_FLAGS='-Wall -pedantic' \
-DCMAKE_INSTALL_PREFIX=/install/path" #Force g++-4.9 and set compiler flags
AUTOGEN_FLAGS="--ac=2.50 --am=1.8" #Forces autoconf 2.50 and automake 1.8
CONFIGURE_FLAGS="CXX=g++-4.9 --prefix=/install/path" #Force g++-4.9 as compiler
MAKE_FLAGS=install #Per default run make install instead of simply make

If you save this information into example.opts you can pass the opts file to
dunecontrol via the --opts option, e. g.

  dunecontrol --opts=example.opts all

To get a full list of available configure flags just run

  dunecontrol configure --help

after running at least
  dunecontrol autogen

More info
---------

See

     dunecontrol --help

for further options.


The full build-system is described in the dune-common/doc/buildsystem (Git version) or under share/doc/dune-common/buildsystem if you installed DUNE!
