# Copyright 2019 New Relic, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import setuptools

setuptools.setup(
    use_scm_version={
        "write_to": "src/newrelic_airflow_plugin/version.py",
        "write_to_template": """\
# coding: utf-8
# file generated by setuptools_scm
# don't change, don't track in version control
version = "{version!s}"
""",
    },
    install_requires=("apache-airflow<2, >=1.8", "newrelic-telemetry-sdk>=0.4.0,<0.5"),
)
