window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "databased", "modulename": "databased", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "databased.create_shell", "modulename": "databased.create_shell", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "databased.create_shell.get_args", "modulename": "databased.create_shell", "qualname": "get_args", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argparse</span><span class=\"o\">.</span><span class=\"n\">Namespace</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.create_shell.create_shell", "modulename": "databased.create_shell", "qualname": "create_shell", "kind": "function", "doc": "<p>Generate a template file in the current working directory for a custom DBShell class.</p>\n\n<p><code>name</code> will be used to name the generated file as well as several components in the file content.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.create_shell.main", "modulename": "databased.create_shell", "qualname": "main", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argparse</span><span class=\"o\">.</span><span class=\"n\">Namespace</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.customshell", "modulename": "databased.customshell", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "databased.customshell.CustomShell", "modulename": "databased.customshell", "qualname": "CustomShell", "kind": "class", "doc": "<p>Subclass this to create custom ArgShells.</p>\n", "bases": "databased.dbshell.DBShell"}, {"fullname": "databased.databased", "modulename": "databased.databased", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "databased.databased.dict_factory", "modulename": "databased.databased", "qualname": "dict_factory", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">cursor</span><span class=\"p\">:</span> <span class=\"n\">sqlite3</span><span class=\"o\">.</span><span class=\"n\">Cursor</span>, </span><span class=\"param\"><span class=\"n\">row</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">dict</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased", "modulename": "databased.databased", "qualname": "Databased", "kind": "class", "doc": "<p>SQLite3 wrapper.</p>\n"}, {"fullname": "databased.databased.Databased.__init__", "modulename": "databased.databased", "qualname": "Databased.__init__", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">dbpath</span><span class=\"p\">:</span> <span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;db.sqlite3&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">connection_timeout</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">detect_types</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">enforce_foreign_keys</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">commit_on_close</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">logger_encoding</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;utf-8&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">logger_message_format</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;</span><span class=\"si\">{levelname}</span><span class=\"s1\">|-|</span><span class=\"si\">{asctime}</span><span class=\"s1\">|-|</span><span class=\"si\">{message}</span><span class=\"s1\">&#39;</span></span>)</span>"}, {"fullname": "databased.databased.Databased.path", "modulename": "databased.databased", "qualname": "Databased.path", "kind": "variable", "doc": "<p>If <code>new_path</code> doesn't exist, it will be created (including parent folders).</p>\n", "annotation": ": pathier.pathier.Pathier"}, {"fullname": "databased.databased.Databased.connection_timeout", "modulename": "databased.databased", "qualname": "Databased.connection_timeout", "kind": "variable", "doc": "<p>Changes to this property won't take effect until the current connection, if open, is closed and a new connection opened.</p>\n", "annotation": ": float"}, {"fullname": "databased.databased.Databased.detect_types", "modulename": "databased.databased", "qualname": "Databased.detect_types", "kind": "variable", "doc": "<p>Should use <code>detect_types=sqlite3.PARSE_DECLTYPES | sqlite3.PARSE_COLNAMES</code> when establishing a database connection.</p>\n\n<p>Changes to this property won't take effect until the current connection, if open, is closed and a new connection opened.</p>\n", "annotation": ": bool"}, {"fullname": "databased.databased.Databased.commit_on_close", "modulename": "databased.databased", "qualname": "Databased.commit_on_close", "kind": "variable", "doc": "<p>Should commit database before closing connection when <code>self.close()</code> is called.</p>\n", "annotation": ": bool"}, {"fullname": "databased.databased.Databased.connected", "modulename": "databased.databased", "qualname": "Databased.connected", "kind": "variable", "doc": "<p>Whether this <code>Databased</code> instance is connected to the database file or not.</p>\n", "annotation": ": bool"}, {"fullname": "databased.databased.Databased.indicies", "modulename": "databased.databased", "qualname": "Databased.indicies", "kind": "variable", "doc": "<p>List of indicies for this database.</p>\n", "annotation": ": list[str]"}, {"fullname": "databased.databased.Databased.name", "modulename": "databased.databased", "qualname": "Databased.name", "kind": "variable", "doc": "<p>The name of this database.</p>\n", "annotation": ": str"}, {"fullname": "databased.databased.Databased.tables", "modulename": "databased.databased", "qualname": "Databased.tables", "kind": "variable", "doc": "<p>List of table names for this database.</p>\n", "annotation": ": list[str]"}, {"fullname": "databased.databased.Databased.views", "modulename": "databased.databased", "qualname": "Databased.views", "kind": "variable", "doc": "<p>List of view for this database.</p>\n", "annotation": ": list[str]"}, {"fullname": "databased.databased.Databased.add_column", "modulename": "databased.databased", "qualname": "Databased.add_column", "kind": "function", "doc": "<p>Add a column to <code>table</code>.</p>\n\n<p><code>column_def</code> should be in the form <code>{column_name} {type_name} {constraint}</code>.</p>\n\n<p>i.e.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">db</span> <span class=\"o\">=</span> <span class=\"n\">Databased</span><span class=\"p\">()</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">db</span><span class=\"o\">.</span><span class=\"n\">add_column</span><span class=\"p\">(</span><span class=\"s2\">&quot;rides&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;num_stops INTEGER NOT NULL DEFAULT 0&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">column_def</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.close", "modulename": "databased.databased", "qualname": "Databased.close", "kind": "function", "doc": "<p>Disconnect from the database.</p>\n\n<p>Does not call <code>commit()</code> for you unless the <code>commit_on_close</code> property is set to <code>True</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.commit", "modulename": "databased.databased", "qualname": "Databased.commit", "kind": "function", "doc": "<p>Commit state of database.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.connect", "modulename": "databased.databased", "qualname": "Databased.connect", "kind": "function", "doc": "<p>Connect to the database.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.count", "modulename": "databased.databased", "qualname": "Databased.count", "kind": "function", "doc": "<p>Return number of matching rows in <code>table</code> table.</p>\n\n<p>Equivalent to:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">SELECT</span> <span class=\"n\">COUNT</span><span class=\"p\">({</span><span class=\"n\">distinct</span><span class=\"p\">}</span> <span class=\"p\">{</span><span class=\"n\">column</span><span class=\"p\">})</span> <span class=\"n\">FROM</span> <span class=\"p\">{</span><span class=\"n\">table</span><span class=\"p\">}</span> <span class=\"p\">{</span><span class=\"n\">where</span><span class=\"p\">};</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;*&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">where</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">distinct</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.create_table", "modulename": "databased.databased", "qualname": "Databased.create_table", "kind": "function", "doc": "<p>Create a table if it doesn't exist.</p>\n\n<h4 id=\"params\">:params:</h4>\n\n<p><code>table</code>: Name of the table to create.</p>\n\n<p><code>column_defs</code>: Any number of column names and their definitions in proper Sqlite3 sytax.\ni.e. <code>\"column_name TEXT UNIQUE\"</code> or <code>\"column_name INTEGER PRIMARY KEY\"</code> etc.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"o\">*</span><span class=\"n\">column_defs</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.delete", "modulename": "databased.databased", "qualname": "Databased.delete", "kind": "function", "doc": "<p>Delete rows from <code>table</code> that satisfy the given <code>where</code> clause.</p>\n\n<p>If <code>where</code> is <code>None</code>, all rows will be deleted.</p>\n\n<p>Returns the number of deleted rows.</p>\n\n<p>e.g.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">db</span> <span class=\"o\">=</span> <span class=\"n\">Databased</span><span class=\"p\">()</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">db</span><span class=\"o\">.</span><span class=\"n\">delete</span><span class=\"p\">(</span><span class=\"s2\">&quot;rides&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;distance &lt; 5 AND average_speed &lt; 7&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">where</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.describe", "modulename": "databased.databased", "qualname": "Databased.describe", "kind": "function", "doc": "<p>Returns information about <code>table</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.drop_column", "modulename": "databased.databased", "qualname": "Databased.drop_column", "kind": "function", "doc": "<p>Drop <code>column</code> from <code>table</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.drop_table", "modulename": "databased.databased", "qualname": "Databased.drop_table", "kind": "function", "doc": "<p>Drop <code>table</code> from the database.</p>\n\n<p>Returns <code>True</code> if successful, <code>False</code> if not.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">bool</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.execute_script", "modulename": "databased.databased", "qualname": "Databased.execute_script", "kind": "function", "doc": "<p>Execute sql script located at <code>path</code>.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">encoding</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;utf-8&#39;</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.get_columns", "modulename": "databased.databased", "qualname": "Databased.get_columns", "kind": "function", "doc": "<p>Returns a list of column names in <code>table</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.insert", "modulename": "databased.databased", "qualname": "Databased.insert", "kind": "function", "doc": "<p>Insert rows of <code>values</code> into <code>columns</code> of <code>table</code>.</p>\n\n<p>Each <code>tuple</code> in <code>values</code> corresponds to an individual row that is to be inserted.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">columns</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">values</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]]</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.query", "modulename": "databased.databased", "qualname": "Databased.query", "kind": "function", "doc": "<p>Execute an SQL query and return the results.</p>\n\n<p>Ensures that the database connection is opened before executing the command.</p>\n\n<p>The cursor used to execute the query will be available through <code>self.cursor</code> until the next time <code>self.query()</code> is called.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query_</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">parameters</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"n\">typing</span><span class=\"o\">.</span><span class=\"n\">Any</span><span class=\"p\">,</span> <span class=\"o\">...</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">()</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.rename_column", "modulename": "databased.databased", "qualname": "Databased.rename_column", "kind": "function", "doc": "<p>Rename a column in <code>table</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">column_to_rename</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new_column_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.rename_table", "modulename": "databased.databased", "qualname": "Databased.rename_table", "kind": "function", "doc": "<p>Rename a table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table_to_rename</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">new_table_name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.select", "modulename": "databased.databased", "qualname": "Databased.select", "kind": "function", "doc": "<p>Return rows for given criteria.</p>\n\n<p>For complex queries, use the <code>databased.query()</code> method.</p>\n\n<p>Parameters <code>where</code>, <code>group_by</code>, <code>having</code>, <code>order_by</code>, and <code>limit</code> should not have\ntheir corresponding key word in their string, but should otherwise be valid SQL.</p>\n\n<p><code>joins</code> should contain their key word (<code>INNER JOIN</code>, <code>LEFT JOIN</code>) in addition to the rest of the sub-statement.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">Databased</span><span class=\"p\">()</span><span class=\"o\">.</span><span class=\"n\">select</span><span class=\"p\">(</span>\n<span class=\"go\">    &quot;bike_rides&quot;,</span>\n<span class=\"go\">    &quot;id, date, distance, moving_time, AVG(distance/moving_time) as average_speed&quot;,</span>\n<span class=\"go\">    where=&quot;distance &gt; 20&quot;,</span>\n<span class=\"go\">    order_by=&quot;distance&quot;,</span>\n<span class=\"go\">    desc=True,</span>\n<span class=\"go\">    limit=10</span>\n<span class=\"go\">    )</span>\n<span class=\"go\">executes the query:</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">SELECT</span>\n<span class=\"go\">        id, date, distance, moving_time, AVG(distance/moving_time) as average_speed</span>\n<span class=\"go\">    FROM</span>\n<span class=\"go\">        bike_rides</span>\n<span class=\"go\">    WHERE</span>\n<span class=\"go\">        distance &gt; 20</span>\n<span class=\"go\">    ORDER BY</span>\n<span class=\"go\">        distance DESC</span>\n<span class=\"go\">    Limit 10;</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">columns</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">[</span><span class=\"s1\">&#39;*&#39;</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">joins</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">where</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">group_by</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">having</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">order_by</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">limit</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.to_grid", "modulename": "databased.databased", "qualname": "Databased.to_grid", "kind": "function", "doc": "<p>Returns a tabular grid from <code>data</code>.</p>\n\n<p>If <code>shrink_to_terminal</code> is <code>True</code>, the column widths of the grid will be reduced to fit within the current terminal.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span>, </span><span class=\"param\"><span class=\"n\">shrink_to_terminal</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.update", "modulename": "databased.databased", "qualname": "Databased.update", "kind": "function", "doc": "<p>Update <code>column</code> of <code>table</code> to <code>value</code> for rows satisfying the conditions in <code>where</code>.</p>\n\n<p>If <code>where</code> is <code>None</code> all rows will be updated.</p>\n\n<p>Returns the number of updated rows.</p>\n\n<p>e.g.</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">db</span> <span class=\"o\">=</span> <span class=\"n\">Databased</span><span class=\"p\">()</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">db</span><span class=\"o\">.</span><span class=\"n\">update</span><span class=\"p\">(</span><span class=\"s2\">&quot;rides&quot;</span><span class=\"p\">,</span> <span class=\"s2\">&quot;elevation&quot;</span><span class=\"p\">,</span> <span class=\"mi\">100</span><span class=\"p\">,</span> <span class=\"s2\">&quot;elevation &lt; 100&quot;</span><span class=\"p\">)</span>\n</code></pre>\n</div>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">column</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">value</span><span class=\"p\">:</span> <span class=\"n\">Any</span>,</span><span class=\"param\">\t<span class=\"n\">where</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.vacuum", "modulename": "databased.databased", "qualname": "Databased.vacuum", "kind": "function", "doc": "<p>Reduce disk size of database after row/table deletion.</p>\n\n<p>Returns space freed up in bytes.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.dump_data", "modulename": "databased.databased", "qualname": "Databased.dump_data", "kind": "function", "doc": "<p>Create a data dump file for the specified tables or all tables, if none are given.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">tables</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.databased.Databased.dump_schema", "modulename": "databased.databased", "qualname": "Databased.dump_schema", "kind": "function", "doc": "<p>Create a schema dump file for the specified tables or all tables, if none are given.</p>\n\n<p>NOTE: Foreign key relationships/constraints are not preserved when dumping the schema.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">pathier</span><span class=\"o\">.</span><span class=\"n\">Pathier</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">|</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">tables</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span> <span class=\"o\">|</span> <span class=\"kc\">None</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers", "modulename": "databased.dbparsers", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "databased.dbparsers.add_where_argument", "modulename": "databased.dbparsers", "qualname": "add_where_argument", "kind": "function", "doc": "<p>Add an optional <code>where</code> argument to the parser and return it.</p>\n\n<p>The added argument has a default value of <code>None</code> and has <code>nargs=\"?\"</code></p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">parser</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span></span><span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_backup_parser", "modulename": "databased.dbparsers", "qualname": "get_backup_parser", "kind": "function", "doc": "<p>Returns a parser for the backup command.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_select_parser", "modulename": "databased.dbparsers", "qualname": "get_select_parser", "kind": "function", "doc": "<p>Returns a parser for use with <code>select</code>.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_count_parser", "modulename": "databased.dbparsers", "qualname": "get_count_parser", "kind": "function", "doc": "<p>Returns a count parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_drop_column_parser", "modulename": "databased.dbparsers", "qualname": "get_drop_column_parser", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_schema_parser", "modulename": "databased.dbparsers", "qualname": "get_schema_parser", "kind": "function", "doc": "<p>Returns info parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_update_parser", "modulename": "databased.dbparsers", "qualname": "get_update_parser", "kind": "function", "doc": "<p>Returns update parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_delete_parser", "modulename": "databased.dbparsers", "qualname": "get_delete_parser", "kind": "function", "doc": "<p>Returns delete parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_add_column_parser", "modulename": "databased.dbparsers", "qualname": "get_add_column_parser", "kind": "function", "doc": "<p>Returns add column parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_scan_dbs_parser", "modulename": "databased.dbparsers", "qualname": "get_scan_dbs_parser", "kind": "function", "doc": "<p>Returns db scan parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_rename_table_parser", "modulename": "databased.dbparsers", "qualname": "get_rename_table_parser", "kind": "function", "doc": "<p>Returns rename table parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_rename_column_parser", "modulename": "databased.dbparsers", "qualname": "get_rename_column_parser", "kind": "function", "doc": "<p>Returns rename column parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_add_table_parser", "modulename": "databased.dbparsers", "qualname": "get_add_table_parser", "kind": "function", "doc": "<p>Returns a add_table parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.get_dump_parser", "modulename": "databased.dbparsers", "qualname": "get_dump_parser", "kind": "function", "doc": "<p>Returns a dump parser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">ArgShellParser</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbparsers.select_post_parser", "modulename": "databased.dbparsers", "qualname": "select_post_parser", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">) -> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span>:</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell", "modulename": "databased.dbshell", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "databased.dbshell.DBShell", "modulename": "databased.dbshell", "qualname": "DBShell", "kind": "class", "doc": "<p>Subclass this to create custom ArgShells.</p>\n", "bases": "argshell.argshell.ArgShell"}, {"fullname": "databased.dbshell.DBShell.default", "modulename": "databased.dbshell", "qualname": "DBShell.default", "kind": "function", "doc": "<p>Called on an input line when the command prefix is not recognized.</p>\n\n<p>If this method is not overridden, it prints an error message and\nreturns.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">line</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.display", "modulename": "databased.dbshell", "qualname": "DBShell.display", "kind": "function", "doc": "<p>Print row data to terminal in a grid.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">dict</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_add_column", "modulename": "databased.dbshell", "qualname": "DBShell.do_add_column", "kind": "function", "doc": "<p>Add a new column to the specified tables.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_add_table", "modulename": "databased.dbshell", "qualname": "DBShell.do_add_table", "kind": "function", "doc": "<p>Add a new table to the database.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_backup", "modulename": "databased.dbshell", "qualname": "DBShell.do_backup", "kind": "function", "doc": "<p>Create a backup of the current db file.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_count", "modulename": "databased.dbshell", "qualname": "DBShell.do_count", "kind": "function", "doc": "<p>Count the number of matching records.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_customize", "modulename": "databased.dbshell", "qualname": "DBShell.do_customize", "kind": "function", "doc": "<p>Generate a template file in the current working directory for creating a custom DBShell class.\nExpects one argument: the name of the custom dbshell.\nThis will be used to name the generated file as well as several components in the file content.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">name</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_dbpath", "modulename": "databased.dbshell", "qualname": "DBShell.do_dbpath", "kind": "function", "doc": "<p>Print the .db file in use.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_delete", "modulename": "databased.dbshell", "qualname": "DBShell.do_delete", "kind": "function", "doc": "<p>Delete rows from the database.</p>\n\n<p>Syntax:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">delete</span> <span class=\"p\">{</span><span class=\"n\">table</span><span class=\"p\">}</span> <span class=\"p\">{</span><span class=\"n\">where</span><span class=\"p\">}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">based</span><span class=\"o\">&gt;</span><span class=\"n\">delete</span> <span class=\"n\">users</span> <span class=\"s2\">&quot;username LIKE &#39;</span><span class=\"si\">%c</span><span class=\"s2\">hungus%&quot;</span>\n</code></pre>\n</div>\n\n<p>^will delete all rows in the 'users' table whose username contains 'chungus'^</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_describe", "modulename": "databased.dbshell", "qualname": "DBShell.do_describe", "kind": "function", "doc": "<p>Describe each given table or view. If no list is given, all tables and views will be described.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">tables</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_drop_column", "modulename": "databased.dbshell", "qualname": "DBShell.do_drop_column", "kind": "function", "doc": "<p>Drop the specified column from the specified table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_drop_table", "modulename": "databased.dbshell", "qualname": "DBShell.do_drop_table", "kind": "function", "doc": "<p>Drop the specified table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">table</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_dump", "modulename": "databased.dbshell", "qualname": "DBShell.do_dump", "kind": "function", "doc": "<p>Create <code>.sql</code> dump files for the current database.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_flush_log", "modulename": "databased.dbshell", "qualname": "DBShell.do_flush_log", "kind": "function", "doc": "<p>Clear the log file for this database.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_help", "modulename": "databased.dbshell", "qualname": "DBShell.do_help", "kind": "function", "doc": "<p>Display help messages.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_new_db", "modulename": "databased.dbshell", "qualname": "DBShell.do_new_db", "kind": "function", "doc": "<p>Create a new, empty database with the given name.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dbname</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_properties", "modulename": "databased.dbshell", "qualname": "DBShell.do_properties", "kind": "function", "doc": "<p>See current database property settings.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_query", "modulename": "databased.dbshell", "qualname": "DBShell.do_query", "kind": "function", "doc": "<p>Execute a query against the current database.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">query</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_rename_column", "modulename": "databased.dbshell", "qualname": "DBShell.do_rename_column", "kind": "function", "doc": "<p>Rename a column.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_rename_table", "modulename": "databased.dbshell", "qualname": "DBShell.do_rename_table", "kind": "function", "doc": "<p>Rename a table.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_restore", "modulename": "databased.dbshell", "qualname": "DBShell.do_restore", "kind": "function", "doc": "<p>Replace the current db file with the given db backup file.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">file</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_scan", "modulename": "databased.dbshell", "qualname": "DBShell.do_scan", "kind": "function", "doc": "<p>Scan the current working directory for database files.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_schema", "modulename": "databased.dbshell", "qualname": "DBShell.do_schema", "kind": "function", "doc": "<p>Print out the names of the database tables and views, their columns, and, optionally, the number of rows.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_script", "modulename": "databased.dbshell", "qualname": "DBShell.do_script", "kind": "function", "doc": "<p>Execute the given SQL script.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">path</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_select", "modulename": "databased.dbshell", "qualname": "DBShell.do_select", "kind": "function", "doc": "<p>Execute a SELECT query with the given args.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_set_connection_timeout", "modulename": "databased.dbshell", "qualname": "DBShell.do_set_connection_timeout", "kind": "function", "doc": "<p>Set database connection timeout to this number of seconds.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">seconds</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_set_detect_types", "modulename": "databased.dbshell", "qualname": "DBShell.do_set_detect_types", "kind": "function", "doc": "<p>Pass a <code>1</code> to turn on and a <code>0</code> to turn off.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">should_detect</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_set_enforce_foreign_keys", "modulename": "databased.dbshell", "qualname": "DBShell.do_set_enforce_foreign_keys", "kind": "function", "doc": "<p>Pass a <code>1</code> to turn on and a <code>0</code> to turn off.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">should_enforce</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_size", "modulename": "databased.dbshell", "qualname": "DBShell.do_size", "kind": "function", "doc": "<p>Display the size of the the current db file.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_tables", "modulename": "databased.dbshell", "qualname": "DBShell.do_tables", "kind": "function", "doc": "<p>Print out the names of the database tables, their columns, and, optionally, the number of rows.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_update", "modulename": "databased.dbshell", "qualname": "DBShell.do_update", "kind": "function", "doc": "<p>Update a column to a new value.</p>\n\n<p>Syntax:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">update</span> <span class=\"p\">{</span><span class=\"n\">table</span><span class=\"p\">}</span> <span class=\"p\">{</span><span class=\"n\">column</span><span class=\"p\">}</span> <span class=\"p\">{</span><span class=\"n\">value</span><span class=\"p\">}</span> <span class=\"p\">{</span><span class=\"n\">where</span><span class=\"p\">}</span>\n<span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">based</span><span class=\"o\">&gt;</span><span class=\"n\">update</span> <span class=\"n\">users</span> <span class=\"n\">username</span> <span class=\"n\">big_chungus</span> <span class=\"s2\">&quot;username = lil_chungus&quot;</span>\n</code></pre>\n</div>\n\n<p>^will update the username in the users 'table' to 'big_chungus' where the username is currently 'lil_chungus'^</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_use", "modulename": "databased.dbshell", "qualname": "DBShell.do_use", "kind": "function", "doc": "<p>Set which database file to use.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">dbname</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_vacuum", "modulename": "databased.dbshell", "qualname": "DBShell.do_vacuum", "kind": "function", "doc": "<p>Reduce database disk memory.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">_</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.do_views", "modulename": "databased.dbshell", "qualname": "DBShell.do_views", "kind": "function", "doc": "<p>Print out the names of the database views, their columns, and, optionally, the number of rows.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">argshell</span><span class=\"o\">.</span><span class=\"n\">Namespace</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.DBShell.preloop", "modulename": "databased.dbshell", "qualname": "DBShell.preloop", "kind": "function", "doc": "<p>Scan the current directory for a .db file to use.\nIf not found, prompt the user for one or to try again recursively.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "databased.dbshell.main", "modulename": "databased.dbshell", "qualname": "main", "kind": "function", "doc": "<p></p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"return-annotation\">):</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();