# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DistributionArgs', 'Distribution']

@pulumi.input_type
class DistributionArgs:
    def __init__(__self__, *,
                 bundle_id: pulumi.Input[str],
                 default_cache_behavior: pulumi.Input['DistributionCacheBehaviorArgs'],
                 origin: pulumi.Input['DistributionInputOriginArgs'],
                 cache_behavior_settings: Optional[pulumi.Input['DistributionCacheSettingsArgs']] = None,
                 cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorPerPathArgs']]]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 distribution_name: Optional[pulumi.Input[str]] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTagArgs']]]] = None):
        """
        The set of arguments for constructing a Distribution resource.
        :param pulumi.Input[str] bundle_id: The bundle ID to use for the distribution.
        :param pulumi.Input['DistributionCacheBehaviorArgs'] default_cache_behavior: An object that describes the default cache behavior for the distribution.
        :param pulumi.Input['DistributionInputOriginArgs'] origin: An object that describes the origin resource for the distribution, such as a Lightsail instance or load balancer.
        :param pulumi.Input['DistributionCacheSettingsArgs'] cache_behavior_settings: An object that describes the cache behavior settings for the distribution.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorPerPathArgs']]] cache_behaviors: An array of objects that describe the per-path cache behavior for the distribution.
        :param pulumi.Input[str] certificate_name: The certificate attached to the Distribution.
        :param pulumi.Input[str] distribution_name: The name for the distribution.
        :param pulumi.Input[str] ip_address_type: The IP address type for the distribution.
        :param pulumi.Input[bool] is_enabled: Indicates whether the distribution is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionTagArgs']]] tags: An array of key-value pairs to apply to this resource.
        """
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "default_cache_behavior", default_cache_behavior)
        pulumi.set(__self__, "origin", origin)
        if cache_behavior_settings is not None:
            pulumi.set(__self__, "cache_behavior_settings", cache_behavior_settings)
        if cache_behaviors is not None:
            pulumi.set(__self__, "cache_behaviors", cache_behaviors)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if distribution_name is not None:
            pulumi.set(__self__, "distribution_name", distribution_name)
        if ip_address_type is not None:
            pulumi.set(__self__, "ip_address_type", ip_address_type)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Input[str]:
        """
        The bundle ID to use for the distribution.
        """
        return pulumi.get(self, "bundle_id")

    @bundle_id.setter
    def bundle_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "bundle_id", value)

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Input['DistributionCacheBehaviorArgs']:
        """
        An object that describes the default cache behavior for the distribution.
        """
        return pulumi.get(self, "default_cache_behavior")

    @default_cache_behavior.setter
    def default_cache_behavior(self, value: pulumi.Input['DistributionCacheBehaviorArgs']):
        pulumi.set(self, "default_cache_behavior", value)

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Input['DistributionInputOriginArgs']:
        """
        An object that describes the origin resource for the distribution, such as a Lightsail instance or load balancer.
        """
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: pulumi.Input['DistributionInputOriginArgs']):
        pulumi.set(self, "origin", value)

    @property
    @pulumi.getter(name="cacheBehaviorSettings")
    def cache_behavior_settings(self) -> Optional[pulumi.Input['DistributionCacheSettingsArgs']]:
        """
        An object that describes the cache behavior settings for the distribution.
        """
        return pulumi.get(self, "cache_behavior_settings")

    @cache_behavior_settings.setter
    def cache_behavior_settings(self, value: Optional[pulumi.Input['DistributionCacheSettingsArgs']]):
        pulumi.set(self, "cache_behavior_settings", value)

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorPerPathArgs']]]]:
        """
        An array of objects that describe the per-path cache behavior for the distribution.
        """
        return pulumi.get(self, "cache_behaviors")

    @cache_behaviors.setter
    def cache_behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionCacheBehaviorPerPathArgs']]]]):
        pulumi.set(self, "cache_behaviors", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate attached to the Distribution.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="distributionName")
    def distribution_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the distribution.
        """
        return pulumi.get(self, "distribution_name")

    @distribution_name.setter
    def distribution_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "distribution_name", value)

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address type for the distribution.
        """
        return pulumi.get(self, "ip_address_type")

    @ip_address_type.setter
    def ip_address_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address_type", value)

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the distribution is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enabled", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTagArgs']]]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionTagArgs']]]]):
        pulumi.set(self, "tags", value)


warnings.warn("""Distribution is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)


class Distribution(pulumi.CustomResource):
    warnings.warn("""Distribution is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 cache_behavior_settings: Optional[pulumi.Input[pulumi.InputType['DistributionCacheSettingsArgs']]] = None,
                 cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DistributionCacheBehaviorPerPathArgs']]]]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 default_cache_behavior: Optional[pulumi.Input[pulumi.InputType['DistributionCacheBehaviorArgs']]] = None,
                 distribution_name: Optional[pulumi.Input[str]] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 origin: Optional[pulumi.Input[pulumi.InputType['DistributionInputOriginArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DistributionTagArgs']]]]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Lightsail::Distribution

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bundle_id: The bundle ID to use for the distribution.
        :param pulumi.Input[pulumi.InputType['DistributionCacheSettingsArgs']] cache_behavior_settings: An object that describes the cache behavior settings for the distribution.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DistributionCacheBehaviorPerPathArgs']]]] cache_behaviors: An array of objects that describe the per-path cache behavior for the distribution.
        :param pulumi.Input[str] certificate_name: The certificate attached to the Distribution.
        :param pulumi.Input[pulumi.InputType['DistributionCacheBehaviorArgs']] default_cache_behavior: An object that describes the default cache behavior for the distribution.
        :param pulumi.Input[str] distribution_name: The name for the distribution.
        :param pulumi.Input[str] ip_address_type: The IP address type for the distribution.
        :param pulumi.Input[bool] is_enabled: Indicates whether the distribution is enabled.
        :param pulumi.Input[pulumi.InputType['DistributionInputOriginArgs']] origin: An object that describes the origin resource for the distribution, such as a Lightsail instance or load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DistributionTagArgs']]]] tags: An array of key-value pairs to apply to this resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DistributionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Lightsail::Distribution

        :param str resource_name: The name of the resource.
        :param DistributionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DistributionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bundle_id: Optional[pulumi.Input[str]] = None,
                 cache_behavior_settings: Optional[pulumi.Input[pulumi.InputType['DistributionCacheSettingsArgs']]] = None,
                 cache_behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DistributionCacheBehaviorPerPathArgs']]]]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 default_cache_behavior: Optional[pulumi.Input[pulumi.InputType['DistributionCacheBehaviorArgs']]] = None,
                 distribution_name: Optional[pulumi.Input[str]] = None,
                 ip_address_type: Optional[pulumi.Input[str]] = None,
                 is_enabled: Optional[pulumi.Input[bool]] = None,
                 origin: Optional[pulumi.Input[pulumi.InputType['DistributionInputOriginArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DistributionTagArgs']]]]] = None,
                 __props__=None):
        pulumi.log.warn("""Distribution is deprecated: Distribution is not yet supported by AWS Native, so its creation will currently fail. Please use the classic AWS provider, if possible.""")
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DistributionArgs.__new__(DistributionArgs)

            if bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'bundle_id'")
            __props__.__dict__["bundle_id"] = bundle_id
            __props__.__dict__["cache_behavior_settings"] = cache_behavior_settings
            __props__.__dict__["cache_behaviors"] = cache_behaviors
            __props__.__dict__["certificate_name"] = certificate_name
            if default_cache_behavior is None and not opts.urn:
                raise TypeError("Missing required property 'default_cache_behavior'")
            __props__.__dict__["default_cache_behavior"] = default_cache_behavior
            __props__.__dict__["distribution_name"] = distribution_name
            __props__.__dict__["ip_address_type"] = ip_address_type
            __props__.__dict__["is_enabled"] = is_enabled
            if origin is None and not opts.urn:
                raise TypeError("Missing required property 'origin'")
            __props__.__dict__["origin"] = origin
            __props__.__dict__["tags"] = tags
            __props__.__dict__["able_to_update_bundle"] = None
            __props__.__dict__["distribution_arn"] = None
            __props__.__dict__["status"] = None
        super(Distribution, __self__).__init__(
            'aws-native:lightsail:Distribution',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Distribution':
        """
        Get an existing Distribution resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = DistributionArgs.__new__(DistributionArgs)

        __props__.__dict__["able_to_update_bundle"] = None
        __props__.__dict__["bundle_id"] = None
        __props__.__dict__["cache_behavior_settings"] = None
        __props__.__dict__["cache_behaviors"] = None
        __props__.__dict__["certificate_name"] = None
        __props__.__dict__["default_cache_behavior"] = None
        __props__.__dict__["distribution_arn"] = None
        __props__.__dict__["distribution_name"] = None
        __props__.__dict__["ip_address_type"] = None
        __props__.__dict__["is_enabled"] = None
        __props__.__dict__["origin"] = None
        __props__.__dict__["status"] = None
        __props__.__dict__["tags"] = None
        return Distribution(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="ableToUpdateBundle")
    def able_to_update_bundle(self) -> pulumi.Output[bool]:
        """
        Indicates whether the bundle that is currently applied to your distribution, specified using the distributionName parameter, can be changed to another bundle.
        """
        return pulumi.get(self, "able_to_update_bundle")

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> pulumi.Output[str]:
        """
        The bundle ID to use for the distribution.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter(name="cacheBehaviorSettings")
    def cache_behavior_settings(self) -> pulumi.Output[Optional['outputs.DistributionCacheSettings']]:
        """
        An object that describes the cache behavior settings for the distribution.
        """
        return pulumi.get(self, "cache_behavior_settings")

    @property
    @pulumi.getter(name="cacheBehaviors")
    def cache_behaviors(self) -> pulumi.Output[Optional[Sequence['outputs.DistributionCacheBehaviorPerPath']]]:
        """
        An array of objects that describe the per-path cache behavior for the distribution.
        """
        return pulumi.get(self, "cache_behaviors")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[Optional[str]]:
        """
        The certificate attached to the Distribution.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="defaultCacheBehavior")
    def default_cache_behavior(self) -> pulumi.Output['outputs.DistributionCacheBehavior']:
        """
        An object that describes the default cache behavior for the distribution.
        """
        return pulumi.get(self, "default_cache_behavior")

    @property
    @pulumi.getter(name="distributionArn")
    def distribution_arn(self) -> pulumi.Output[str]:
        return pulumi.get(self, "distribution_arn")

    @property
    @pulumi.getter(name="distributionName")
    def distribution_name(self) -> pulumi.Output[str]:
        """
        The name for the distribution.
        """
        return pulumi.get(self, "distribution_name")

    @property
    @pulumi.getter(name="ipAddressType")
    def ip_address_type(self) -> pulumi.Output[Optional[str]]:
        """
        The IP address type for the distribution.
        """
        return pulumi.get(self, "ip_address_type")

    @property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Indicates whether the distribution is enabled.
        """
        return pulumi.get(self, "is_enabled")

    @property
    @pulumi.getter
    def origin(self) -> pulumi.Output['outputs.DistributionInputOrigin']:
        """
        An object that describes the origin resource for the distribution, such as a Lightsail instance or load balancer.
        """
        return pulumi.get(self, "origin")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the distribution.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.DistributionTag']]]:
        """
        An array of key-value pairs to apply to this resource.
        """
        return pulumi.get(self, "tags")

