# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MessageTemplateArgs', 'MessageTemplate']

@pulumi.input_type
class MessageTemplateArgs:
    def __init__(__self__, *,
                 template: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MessageTemplate resource.
        :param pulumi.Input[str] template: The content of the message template.
        :param pulumi.Input[str] name: The name of the message template.
        """
        pulumi.set(__self__, "template", template)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def template(self) -> pulumi.Input[str]:
        """
        The content of the message template.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: pulumi.Input[str]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the message template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MessageTemplateState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MessageTemplate resources.
        :param pulumi.Input[str] name: The name of the message template.
        :param pulumi.Input[str] template: The content of the message template.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the message template.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the message template.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)


class MessageTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/next/alerting/contact-points/message-templating/)
        * [HTTP API](https://grafana.com/docs/grafana/next/developers/http_api/alerting_provisioning/#templates)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        my_template = grafana.MessageTemplate("myTemplate", template=\"\"\"{{define "My Reusable Template" }}
         template content
        {{ end }}
        \"\"\")
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/messageTemplate:MessageTemplate message_template_name {{message_template_name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the message template.
        :param pulumi.Input[str] template: The content of the message template.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MessageTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [Official documentation](https://grafana.com/docs/grafana/next/alerting/contact-points/message-templating/)
        * [HTTP API](https://grafana.com/docs/grafana/next/developers/http_api/alerting_provisioning/#templates)

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_grafana as grafana

        my_template = grafana.MessageTemplate("myTemplate", template=\"\"\"{{define "My Reusable Template" }}
         template content
        {{ end }}
        \"\"\")
        ```

        ## Import

        ```sh
         $ pulumi import grafana:index/messageTemplate:MessageTemplate message_template_name {{message_template_name}}
        ```

        :param str resource_name: The name of the resource.
        :param MessageTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MessageTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MessageTemplateArgs.__new__(MessageTemplateArgs)

            __props__.__dict__["name"] = name
            if template is None and not opts.urn:
                raise TypeError("Missing required property 'template'")
            __props__.__dict__["template"] = template
        super(MessageTemplate, __self__).__init__(
            'grafana:index/messageTemplate:MessageTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            template: Optional[pulumi.Input[str]] = None) -> 'MessageTemplate':
        """
        Get an existing MessageTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the message template.
        :param pulumi.Input[str] template: The content of the message template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MessageTemplateState.__new__(_MessageTemplateState)

        __props__.__dict__["name"] = name
        __props__.__dict__["template"] = template
        return MessageTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the message template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[str]:
        """
        The content of the message template.
        """
        return pulumi.get(self, "template")

