# Copyright 2021 Curtin University
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Author: James Diprose

# The keywords airflow and DAG are required to load the DAGs from this file, see bullet 2 in the Apache Airflow FAQ:
# https://airflow.apache.org/docs/stable/faq.html

from oaebu_workflows.identifiers import TelescopeTypes
from oaebu_workflows.workflows.onix_telescope import OnixTelescope
from observatory.platform.utils.workflow_utils import make_observatory_api

# Fetch all ONIX telescopes
api = make_observatory_api()
telescope_type = api.get_telescope_type(type_id=TelescopeTypes.onix)
telescopes = api.get_telescopes(telescope_type_id=telescope_type.id, limit=1000)

# Make all ONIX telescopes
for telescope in telescopes:
    organisation = telescope.organisation
    organisation_name = organisation.name
    project_id = organisation.gcp_project_id
    download_bucket = organisation.gcp_download_bucket
    transform_bucket = organisation.gcp_transform_bucket
    dataset_location = "us"
    date_regex = telescope.extra.get("date_regex")
    date_format = telescope.extra.get("date_format")

    workflow = OnixTelescope(
        organisation_name=organisation_name,
        project_id=project_id,
        download_bucket=download_bucket,
        transform_bucket=transform_bucket,
        dataset_location=dataset_location,
        date_regex=date_regex,
        date_format=date_format,
    )
    globals()[workflow.dag_id] = workflow.make_dag()
