OpenCropLib
==============

Python Library for simulating physiological processes in plants.
The aim of this project is to implement the energy balance model
developed in Berni et al. 2009 that allows to estimate canopy conductance
from a combination of canopy temperature and basic micro-metheorological
observations.

The different components of the model can also be used in the simulation and
estimation of physical processes such as aerodynamic modeling, calculation
of solar radiation, etc.

# Background
Calculation of ETo and ETa

# Installation

```pip install opencropib ```

# Examples


# Terms of use and citation
This library is licensed under the MIT license.

    Copyright 2021 Jose A. Jimenez-Berni

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

# References
Allen, R. G., Pereira, L. S., Raes, D., and Smith, M. (1998). Crop evapotranspiration: guidelines for computing crop 
water requirements. Roma: Food and Agriculture Organization of the United Nations Available at: 
https://appgeodb.nancy.inra.fr/biljou/pdf/Allen_FAO1998.pdf.

Berni, J. A. J., Zarco-Tejada, P. J., Sepulcre-Cantó, G., Fereres, E., and Villalobos, F. (2009). Mapping canopy 
conductance and CWSI in olive orchards using high resolution thermal remote sensing imagery. Remote Sens. Environ. 113, 
2380–2388. doi:10.1016/j.rse.2009.06.018.

https://github.com/woodcrafty/PyETo


