# A Bottle of Wiki

A Bottle of Wiki (abbreviated _abow_) is a personal wiki. Use it for viewing and
editing pages written in markdown directly in your browser. It is made to be
usable both on mobile and desktop.

While you won't be hosting Wikipedia on a Bottle of Wiki, it is easy to deploy
and does not require a database: pages are saved as text files. It has no notion
of users, access rights, page history, comments, discussion or even edit
conflict. It is meant to be used by one person.

A Bottle of Wiki is a wiki built with [bottle](https://bottlepy.org/).

## Installation

To run a Bottle of Wiki, you will need python3 installed on a unix-like machine.

### Test (_a quick sip_)

The easiest way to test a Bottle of Wiki is to install it in a virtual
environment. You can do so with the following commands:
```sh
python3 -m venv abow
source abow/bin/activate
```
Or use your favorite virtualenv management tool.

Then install a Bottle of Wiki and its dependencies with pip:
```sh
pip install abow
```

_Optional_: If you want syntax highlighting when displaying code in your page,
install the extra:
```sh
pip install abow[extra]
```

Finally start the application with:
```sh
bottle.py abow:application
```
If all went well, you can point your browser to <http://127.0.0.1:8080/> and
start editing. The pages will be saved in the current directory. If you are
looking for inspiration, a few markdown pages (including this README) are part
of the [source distribution][sdist].

[sdist]:https://files.pythonhosted.org/packages/source/a/abow/abow-0.4.3.tar.gz

### Deployment (_the whole bottle_)

A Bottle of Wiki is a WSGI application, as such it can be hosted by any
WSGI-capable web server. The documentation of bottle has a page dedicated to the
[deployment](https://bottlepy.org/docs/stable/deployment.html) that can be used
as inspiration. Detailing how to host a WSGI application is beyond the scope of
this README as there are many options to choose from, but here is the most
important piece of advice:

**Make sure the access is restricted.** A Bottle of Wiki has no concept of login
or user, so anyone with access can edit the pages. You can limit the access by
setting up HTTP authentication and encryption on your web server. You can also
serve only on a local network and access it via a VPN.

### Configuration

A Bottle of Wiki can be customized with a .ini configuration file. A example is
provided in the source distribution, or you can generate it with the following
command:
```sh
python -c "import abow.config;abow.config.print_file()"
```

The example configuration is heavily commented and should be self-explanatory.
It enable you to change where a Bottle of Wiki stores the pages and the locale
used. You can also host the static assets (css, js, ...) outside of the
application and serve them directly from a web server.

The configuration is read from the following locations:

* `/etc/abow/config`
* `$XDG_CONFIG_HOME/abow/config`, defaulting to `~/.config/abow/config`
* `$ABOW_CONFIG`, if defined

Paths are tried one after one and each configuration file can override the
settings of the previous ones.

## Built With

A Bottle of Wiki depends on the following python packages:

* [Bottle](https://bottlepy.org/) -- The WSGI micro-framework used
* [Python-Markdown](https://python-markdown.github.io/)
  -- The markdown interpreter
* [PyMdown Extensions](https://facelessuser.github.io/pymdown-extensions/)
  -- Extensions for Python Markdown
* [Pygments](https://pygments.org/) -- Syntax highlighter (_optional_)

The following css and javascript packages are included:

* [Bootstrap](https://getbootstrap.com) version 5.1.3 -- CSS Toolkit
* [Autosize](http://www.jacklmoore.com/autosize/) version 5.0.0
  -- Script to automatically adjust textarea height

## Things to do

### Detection of edit conflict

Right now if you edit a page from two browsers you can lose some modifications.
Detecting that the page has been changed on the server while being edited would
be nice if you want to use a Bottle of Wiki with more than one user.

### Page history

While you can avoid losing changes by setting up a backup on the server (and you
should anyway), integrating the page history in the wiki would make is easier to
review the page modifications. Look into [dulwich](https://www.dulwich.io/) for
that?

## License

This project is licensed under the Affero General Public License version 3 or later.
