# -*- coding: utf-8 -*-
"""visualize.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1M7_YnsCAo2eJz_EDGOBffRNvqtmuY7gm
"""

def nn_visualize(model,type="keras",title ="My neural network", verbose =False):
  """
  nn_visualize is used to visualize neural networks in pictorial form(keras) or graphical form(graphviz)

  Parameters:
  model - reference of the model
  type - to return keras or graphviz visualization
  title - for graphviz visualization
  verbose(bool) - to display details of neural network architecture

  Return :
  Visualization object
  """



  if type == "keras" or type[0]=="k":
    from keras.utils.vis_utils import plot_model
    obj = plot_model(model, to_file='model_plot.png', show_shapes=True, show_layer_names=True)
    return obj

  else:
    try:
      from ann_visualizer.visualize import ann_viz
      from graphviz import Source

      ann_viz(model,view=True, title=title)
      graph_source = Source.from_file("network.gv")

      if verbose:
        print(graph_source.source)

      return graph_source
    except:
      print("An error occur while using graphviz visualization. So keras visualization object is returned")
      from keras.utils.vis_utils import plot_model
      obj = plot_model(model, to_file='model_plot.png', show_shapes=True, show_layer_names=True)
      return obj