# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/sample_mesa_model.ipynb (unless otherwise specified).

__all__ = ['MoneyAgent', 'MoneyModel']

# Cell
from nbdev.showdoc import *
import jovsatools
import fastcore
import matplotlib.pyplot as plt
from mesa import Agent, Model
from mesa.time import RandomActivation
import numpy as np

# Cell
class MoneyAgent(Agent):
    """ An agent with fixed initial wealth."""
    def __init__(self, unique_id, model):
        super().__init__(unique_id, model)
        self.wealth = 1

    def step(self):
        if self.wealth == 0:
            return
        other_agent = self.random.choice(self.model.schedule.agents)
        other_agent.wealth += 1
        self.wealth -= 1

class MoneyModel(Model):
    """A model with some number of agents."""
    def __init__(self, N):
        self.num_agents = N
        self.schedule = RandomActivation(self)
        # Create agents
        for i in range(self.num_agents):
            a = MoneyAgent(i, self)
            self.schedule.add(a)

    def step(self):
        '''Advance the model by one step.'''
        self.schedule.step()