# Copyright (c) 2025 Sean Yeatts. All rights reserved.

from __future__ import annotations


# IMPORTS ( EXTERNAL )
import yaml

# IMPORTS ( STANDARD )
import base64

# IMPORTS ( PROJECT )
from swiftserialize import StructuredSerializer


# CLASSES
class YAMLSerializer(StructuredSerializer):

    # OVERRIDDEN METHODS
    def encode(self, data: dict) -> bytes:
        super().encode(data)
        string  = yaml.dump(data)
        encoded = string.encode(self.standard)
        stream  = base64.b64encode(encoded)
        return stream
    
    def decode(self, binary: bytes) -> dict:
        super().decode(binary)
        stream  = base64.b64decode(binary)
        decoded = stream.decode(self.standard)
        data    = yaml.safe_load(decoded)
        return data

    # STRUCTURED METHODS
    def load(self, file: str) -> dict:
        super().load(file)
        with open(file, 'r', encoding=self.standard) as target:
            data = yaml.safe_load(target)
        return data

    def save(self, data: dict, file: str) -> None:
        super().save(data, file)
        with open(file, 'w') as target:
            yaml.dump(data, target, sort_keys=False)
