"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgePutEvents = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const task_utils_1 = require("../private/task-utils");
/**
 * A StepFunctions Task to send events to an EventBridge event bus.
 *
 * @stability stable
 */
class EventBridgePutEvents extends sfn.TaskStateBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        this.integrationPattern = (_b = props.integrationPattern) !== null && _b !== void 0 ? _b : sfn.IntegrationPattern.REQUEST_RESPONSE;
        task_utils_1.validatePatternSupported(this.integrationPattern, EventBridgePutEvents.SUPPORTED_INTEGRATION_PATTERNS);
        if (this.integrationPattern === sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN) {
            if (!sfn.FieldUtils.containsTaskToken(props.entries.map(entry => entry.detail))) {
                throw new Error('Task Token is required in `entries`. Use JsonPath.taskToken to set the token.');
            }
        }
        this.validateEntries();
        this.taskPolicies = [
            new iam.PolicyStatement({
                actions: ['events:PutEvents'],
                resources: this.eventBusArns,
            }),
        ];
    }
    /**
     * Returns an array of EventBusArn strings based on this.props.entries
     */
    get eventBusArns() {
        return this.props.entries
            .map(entry => {
            if (entry.eventBus) {
                // If an eventBus is provided, use the corresponding ARN
                return entry.eventBus.eventBusArn;
            }
            else {
                // If neither an eventBus nor eventBusName is provided,
                // format the ARN for the default event bus in the account.
                return cdk.Stack.of(this).formatArn({
                    resource: 'event-bus',
                    resourceName: 'default',
                    sep: '/',
                    service: 'events',
                });
            }
        });
    }
    /**
     * Provides the EventBridge put events service integration task configuration
     * @internal
     */
    _renderTask() {
        return {
            Resource: task_utils_1.integrationResourceArn('events', 'putEvents', this.integrationPattern),
            Parameters: sfn.FieldUtils.renderObject({
                Entries: this.renderEntries(),
            }),
        };
    }
    renderEntries() {
        return this.props.entries.map(entry => {
            var _b, _c, _d;
            if ((_b = entry.source) === null || _b === void 0 ? void 0 : _b.startsWith('aws')) {
                throw new Error('Event source cannot start with "aws."');
            }
            else {
                return {
                    Detail: (_c = entry.detail) === null || _c === void 0 ? void 0 : _c.value,
                    DetailType: entry.detailType,
                    EventBusName: (_d = entry.eventBus) === null || _d === void 0 ? void 0 : _d.eventBusArn,
                    Source: entry.source,
                };
            }
        });
    }
    validateEntries() {
        if (this.props.entries.length <= 0) {
            throw new Error('Value for property `entries` must be a non-empty array.');
        }
    }
}
exports.EventBridgePutEvents = EventBridgePutEvents;
_a = JSII_RTTI_SYMBOL_1;
EventBridgePutEvents[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EventBridgePutEvents", version: "1.121.0" };
EventBridgePutEvents.SUPPORTED_INTEGRATION_PATTERNS = [
    sfn.IntegrationPattern.REQUEST_RESPONSE,
    sfn.IntegrationPattern.WAIT_FOR_TASK_TOKEN,
];
//# sourceMappingURL=data:application/json;base64,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