
# Loading additional proc with user specified bodies to compute parameter values.
source [file join [file dirname [file dirname [info script]]] gui/smartompssmanager_v5_0.gtcl]

# Definitional proc to organize widgets for parameters.
proc init_gui { IPINST } {
  ipgui::add_param $IPINST -name "Component_Name"
  #Adding Page
  set Page_0 [ipgui::add_page $IPINST -name "Page 0"]
  ipgui::add_param $IPINST -name "CMDIN_SUBQUEUE_LEN" -parent ${Page_0}
  ipgui::add_param $IPINST -name "CMDOUT_SUBQUEUE_LEN" -parent ${Page_0}
  ipgui::add_param $IPINST -name "ENABLE_SPAWN_QUEUES" -parent ${Page_0}
  ipgui::add_param $IPINST -name "LOCK_SUPPORT" -parent ${Page_0}
  ipgui::add_param $IPINST -name "MAX_ACCS" -parent ${Page_0}
  ipgui::add_param $IPINST -name "MAX_ACC_CREATORS" -parent ${Page_0}
  ipgui::add_param $IPINST -name "MAX_ACC_TYPES" -parent ${Page_0}
  ipgui::add_param $IPINST -name "SPAWNIN_QUEUE_LEN" -parent ${Page_0}
  ipgui::add_param $IPINST -name "SPAWNOUT_QUEUE_LEN" -parent ${Page_0}


}

proc update_PARAM_VALUE.SPAWNIN_QUEUE_LEN { PARAM_VALUE.SPAWNIN_QUEUE_LEN PARAM_VALUE.ENABLE_SPAWN_QUEUES } {
	# Procedure called to update SPAWNIN_QUEUE_LEN when any of the dependent parameters in the arguments change
	
	set SPAWNIN_QUEUE_LEN ${PARAM_VALUE.SPAWNIN_QUEUE_LEN}
	set ENABLE_SPAWN_QUEUES ${PARAM_VALUE.ENABLE_SPAWN_QUEUES}
	set values(ENABLE_SPAWN_QUEUES) [get_property value $ENABLE_SPAWN_QUEUES]
	if { [gen_USERPARAMETER_SPAWNIN_QUEUE_LEN_ENABLEMENT $values(ENABLE_SPAWN_QUEUES)] } {
		set_property enabled true $SPAWNIN_QUEUE_LEN
	} else {
		set_property enabled false $SPAWNIN_QUEUE_LEN
	}
}

proc validate_PARAM_VALUE.SPAWNIN_QUEUE_LEN { PARAM_VALUE.SPAWNIN_QUEUE_LEN } {
	# Procedure called to validate SPAWNIN_QUEUE_LEN
	return true
}

proc update_PARAM_VALUE.SPAWNOUT_QUEUE_LEN { PARAM_VALUE.SPAWNOUT_QUEUE_LEN PARAM_VALUE.ENABLE_SPAWN_QUEUES } {
	# Procedure called to update SPAWNOUT_QUEUE_LEN when any of the dependent parameters in the arguments change
	
	set SPAWNOUT_QUEUE_LEN ${PARAM_VALUE.SPAWNOUT_QUEUE_LEN}
	set ENABLE_SPAWN_QUEUES ${PARAM_VALUE.ENABLE_SPAWN_QUEUES}
	set values(ENABLE_SPAWN_QUEUES) [get_property value $ENABLE_SPAWN_QUEUES]
	if { [gen_USERPARAMETER_SPAWNOUT_QUEUE_LEN_ENABLEMENT $values(ENABLE_SPAWN_QUEUES)] } {
		set_property enabled true $SPAWNOUT_QUEUE_LEN
	} else {
		set_property enabled false $SPAWNOUT_QUEUE_LEN
	}
}

proc validate_PARAM_VALUE.SPAWNOUT_QUEUE_LEN { PARAM_VALUE.SPAWNOUT_QUEUE_LEN } {
	# Procedure called to validate SPAWNOUT_QUEUE_LEN
	return true
}

proc update_PARAM_VALUE.CMDIN_SUBQUEUE_LEN { PARAM_VALUE.CMDIN_SUBQUEUE_LEN } {
	# Procedure called to update CMDIN_SUBQUEUE_LEN when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.CMDIN_SUBQUEUE_LEN { PARAM_VALUE.CMDIN_SUBQUEUE_LEN } {
	# Procedure called to validate CMDIN_SUBQUEUE_LEN
	return true
}

proc update_PARAM_VALUE.CMDOUT_SUBQUEUE_LEN { PARAM_VALUE.CMDOUT_SUBQUEUE_LEN } {
	# Procedure called to update CMDOUT_SUBQUEUE_LEN when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.CMDOUT_SUBQUEUE_LEN { PARAM_VALUE.CMDOUT_SUBQUEUE_LEN } {
	# Procedure called to validate CMDOUT_SUBQUEUE_LEN
	return true
}

proc update_PARAM_VALUE.ENABLE_SPAWN_QUEUES { PARAM_VALUE.ENABLE_SPAWN_QUEUES } {
	# Procedure called to update ENABLE_SPAWN_QUEUES when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.ENABLE_SPAWN_QUEUES { PARAM_VALUE.ENABLE_SPAWN_QUEUES } {
	# Procedure called to validate ENABLE_SPAWN_QUEUES
	return true
}

proc update_PARAM_VALUE.LOCK_SUPPORT { PARAM_VALUE.LOCK_SUPPORT } {
	# Procedure called to update LOCK_SUPPORT when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.LOCK_SUPPORT { PARAM_VALUE.LOCK_SUPPORT } {
	# Procedure called to validate LOCK_SUPPORT
	return true
}

proc update_PARAM_VALUE.MAX_ACCS { PARAM_VALUE.MAX_ACCS } {
	# Procedure called to update MAX_ACCS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.MAX_ACCS { PARAM_VALUE.MAX_ACCS } {
	# Procedure called to validate MAX_ACCS
	return true
}

proc update_PARAM_VALUE.MAX_ACC_CREATORS { PARAM_VALUE.MAX_ACC_CREATORS } {
	# Procedure called to update MAX_ACC_CREATORS when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.MAX_ACC_CREATORS { PARAM_VALUE.MAX_ACC_CREATORS } {
	# Procedure called to validate MAX_ACC_CREATORS
	return true
}

proc update_PARAM_VALUE.MAX_ACC_TYPES { PARAM_VALUE.MAX_ACC_TYPES } {
	# Procedure called to update MAX_ACC_TYPES when any of the dependent parameters in the arguments change
}

proc validate_PARAM_VALUE.MAX_ACC_TYPES { PARAM_VALUE.MAX_ACC_TYPES } {
	# Procedure called to validate MAX_ACC_TYPES
	return true
}


proc update_MODELPARAM_VALUE.MAX_ACCS { MODELPARAM_VALUE.MAX_ACCS PARAM_VALUE.MAX_ACCS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.MAX_ACCS}] ${MODELPARAM_VALUE.MAX_ACCS}
}

proc update_MODELPARAM_VALUE.MAX_ACC_CREATORS { MODELPARAM_VALUE.MAX_ACC_CREATORS PARAM_VALUE.MAX_ACC_CREATORS } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.MAX_ACC_CREATORS}] ${MODELPARAM_VALUE.MAX_ACC_CREATORS}
}

proc update_MODELPARAM_VALUE.MAX_ACC_TYPES { MODELPARAM_VALUE.MAX_ACC_TYPES PARAM_VALUE.MAX_ACC_TYPES } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.MAX_ACC_TYPES}] ${MODELPARAM_VALUE.MAX_ACC_TYPES}
}

proc update_MODELPARAM_VALUE.CMDIN_SUBQUEUE_LEN { MODELPARAM_VALUE.CMDIN_SUBQUEUE_LEN PARAM_VALUE.CMDIN_SUBQUEUE_LEN } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.CMDIN_SUBQUEUE_LEN}] ${MODELPARAM_VALUE.CMDIN_SUBQUEUE_LEN}
}

proc update_MODELPARAM_VALUE.CMDOUT_SUBQUEUE_LEN { MODELPARAM_VALUE.CMDOUT_SUBQUEUE_LEN PARAM_VALUE.CMDOUT_SUBQUEUE_LEN } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.CMDOUT_SUBQUEUE_LEN}] ${MODELPARAM_VALUE.CMDOUT_SUBQUEUE_LEN}
}

proc update_MODELPARAM_VALUE.SPAWNIN_QUEUE_LEN { MODELPARAM_VALUE.SPAWNIN_QUEUE_LEN PARAM_VALUE.SPAWNIN_QUEUE_LEN } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.SPAWNIN_QUEUE_LEN}] ${MODELPARAM_VALUE.SPAWNIN_QUEUE_LEN}
}

proc update_MODELPARAM_VALUE.SPAWNOUT_QUEUE_LEN { MODELPARAM_VALUE.SPAWNOUT_QUEUE_LEN PARAM_VALUE.SPAWNOUT_QUEUE_LEN } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.SPAWNOUT_QUEUE_LEN}] ${MODELPARAM_VALUE.SPAWNOUT_QUEUE_LEN}
}

proc update_MODELPARAM_VALUE.LOCK_SUPPORT { MODELPARAM_VALUE.LOCK_SUPPORT PARAM_VALUE.LOCK_SUPPORT } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.LOCK_SUPPORT}] ${MODELPARAM_VALUE.LOCK_SUPPORT}
}

proc update_MODELPARAM_VALUE.ENABLE_SPAWN_QUEUES { MODELPARAM_VALUE.ENABLE_SPAWN_QUEUES PARAM_VALUE.ENABLE_SPAWN_QUEUES } {
	# Procedure called to set VHDL generic/Verilog parameter value(s) based on TCL parameter value
	set_property value [get_property value ${PARAM_VALUE.ENABLE_SPAWN_QUEUES}] ${MODELPARAM_VALUE.ENABLE_SPAWN_QUEUES}
}

