
/* Copyright 2019-2020 Smart Chain Arena LLC. */

const fs = require('fs');

const args = process.argv.slice(2);

// begin from eztz cli example

const library = {
  bs58check: require('bs58check'),
  sodium: require('libsodium-wrappers-sumo'),
};

const prefix = {
  tz1: new Uint8Array([6, 161, 159]),
  tz2: new Uint8Array([6, 161, 161]),
  tz3: new Uint8Array([6, 161, 164]),
  KT: new Uint8Array([2,90,121]),

  edpk: new Uint8Array([13, 15, 37, 217]),
  edsk2: new Uint8Array([13, 15, 58, 7]),
  spsk: new Uint8Array([17, 162, 224, 201]),
  p2sk: new Uint8Array([16,81,238,189]),

  sppk: new Uint8Array([3, 254, 226, 86]),
  p2pk: new Uint8Array([3, 178, 139, 127]),

  edsk: new Uint8Array([43, 246, 78, 7]),
  edsig: new Uint8Array([9, 245, 205, 134, 18]),
  spsig1: new Uint8Array([13, 115, 101, 19, 63]),
  p2sig: new Uint8Array([54, 240, 44, 52]),
  sig: new Uint8Array([4, 130, 43]),

  Net: new Uint8Array([87, 82, 0]),
  nce: new Uint8Array([69, 220, 169]),
  b: new Uint8Array([1,52]),
  o: new Uint8Array([5, 116]),
  Lo: new Uint8Array([133, 233]),
  LLo: new Uint8Array([29, 159, 109]),
  P: new Uint8Array([2, 170]),
  Co: new Uint8Array([79, 179]),
  id: new Uint8Array([153, 103]),
};

const utility = {
  b58cencode: function (payload, prefix) {
    const n = new Uint8Array(prefix.length + payload.length);
    n.set(prefix);
    n.set(payload, prefix.length);
    return library.bs58check.encode(new Buffer(n, 'hex'));
  },
  b58cdecode: (enc, prefix) => library.bs58check.decode(enc).slice(prefix.length),
  buf2hex: function (buffer) {
    const byteArray = new Uint8Array(buffer), hexParts = [];
    for (let i = 0; i < byteArray.length; i++) {
      let hex = byteArray[i].toString(16);
      let paddedHex = ('00' + hex).slice(-2);
      hexParts.push(paddedHex);
    }
    return hexParts.join('');
  },
  hex2buf : function(hex){
    return new Uint8Array(hex.match(/[\da-f]{2}/gi).map(function (h) {
      return parseInt(h, 16)
    }));
  },
  mergebuf : function(b1,b2){
    var r = new Uint8Array(b1.length+b2.length);
    r.set(b1);
    r.set(b2, b1.length);
    return r;
  },
};

global.eztz = {
  prefix : prefix,
  utility : utility,
  library : library
};

// end from eztz cli example

// sudo npm install libsodium-wrappers xmlhttprequest

(async() => {
  global.smartpyContext = {};
  await library.sodium.ready;
  await library.bs58check.ready;
  global.sodium = library.sodium;
  global.smartpyContext.Keccak256 = require('js-sha3').keccak_256;
  global.smartpyContext.Bls12 = require('tezos-bls12-381');

// __INSERT_HERE__

//# 1 "smartpyc_js.bc.runtime.js"
// Generated by js_of_ocaml 3.6.0
(function(joo_global_object)
   {"use strict";
    function caml_int64_is_zero(x){return + x.isZero()}
    function caml_str_repeat(n,s)
     {if(n == 0)return "";
      if(s.repeat)return s.repeat(n);
      var r="",l=0;
      for(;;)
       {if(n & 1)r += s;
        n >>= 1;
        if(n == 0)return r;
        s += s;
        l++;
        if(l == 9)s.slice(0,1)}}
    var caml_int64_offset=Math.pow(2,- 24);
    function caml_raise_constant(tag){throw tag}
    var caml_global_data=[0];
    function caml_raise_zero_divide()
     {caml_raise_constant(caml_global_data.Division_by_zero)}
    function MlInt64(lo,mi,hi)
     {this.lo = lo & 0xffffff;this.mi = mi & 0xffffff;this.hi = hi & 0xffff}
    MlInt64.prototype.caml_custom = "_j";
    MlInt64.prototype.copy
    =
    function(){return new MlInt64(this.lo,this.mi,this.hi)};
    MlInt64.prototype.ucompare
    =
    function(x)
     {if(this.hi > x.hi)return 1;
      if(this.hi < x.hi)return - 1;
      if(this.mi > x.mi)return 1;
      if(this.mi < x.mi)return - 1;
      if(this.lo > x.lo)return 1;
      if(this.lo < x.lo)return - 1;
      return 0};
    MlInt64.prototype.compare
    =
    function(x)
     {var hi=this.hi << 16,xhi=x.hi << 16;
      if(hi > xhi)return 1;
      if(hi < xhi)return - 1;
      if(this.mi > x.mi)return 1;
      if(this.mi < x.mi)return - 1;
      if(this.lo > x.lo)return 1;
      if(this.lo < x.lo)return - 1;
      return 0};
    MlInt64.prototype.neg
    =
    function()
     {var lo=- this.lo,mi=- this.mi + (lo >> 24),hi=- this.hi + (mi >> 24);
      return new MlInt64(lo,mi,hi)};
    MlInt64.prototype.add
    =
    function(x)
     {var
       lo=this.lo + x.lo,
       mi=this.mi + x.mi + (lo >> 24),
       hi=this.hi + x.hi + (mi >> 24);
      return new MlInt64(lo,mi,hi)};
    MlInt64.prototype.sub
    =
    function(x)
     {var
       lo=this.lo - x.lo,
       mi=this.mi - x.mi + (lo >> 24),
       hi=this.hi - x.hi + (mi >> 24);
      return new MlInt64(lo,mi,hi)};
    MlInt64.prototype.mul
    =
    function(x)
     {var
       lo=this.lo * x.lo,
       mi=(lo * caml_int64_offset | 0) + this.mi * x.lo + this.lo * x.mi,
       hi=
        (mi * caml_int64_offset | 0)
        +
        this.hi
        *
        x.lo
        +
        this.mi
        *
        x.mi
        +
        this.lo
        *
        x.hi;
      return new MlInt64(lo,mi,hi)};
    MlInt64.prototype.isZero
    =
    function(){return (this.lo | this.mi | this.hi) == 0};
    MlInt64.prototype.isNeg = function(){return this.hi << 16 < 0};
    MlInt64.prototype.and
    =
    function(x)
     {return new MlInt64(this.lo & x.lo,this.mi & x.mi,this.hi & x.hi)};
    MlInt64.prototype.or
    =
    function(x)
     {return new MlInt64(this.lo | x.lo,this.mi | x.mi,this.hi | x.hi)};
    MlInt64.prototype.xor
    =
    function(x)
     {return new MlInt64(this.lo ^ x.lo,this.mi ^ x.mi,this.hi ^ x.hi)};
    MlInt64.prototype.shift_left
    =
    function(s)
     {s = s & 63;
      if(s == 0)return this;
      if(s < 24)
       return new
               MlInt64
               (this.lo << s,
                this.mi << s | this.lo >> 24 - s,
                this.hi << s | this.mi >> 24 - s);
      if(s < 48)
       return new
               MlInt64
               (0,this.lo << s - 24,this.mi << s - 24 | this.lo >> 48 - s);
      return new MlInt64(0,0,this.lo << s - 48)};
    MlInt64.prototype.shift_right_unsigned
    =
    function(s)
     {s = s & 63;
      if(s == 0)return this;
      if(s < 24)
       return new
               MlInt64
               (this.lo >> s | this.mi << 24 - s,
                this.mi >> s | this.hi << 24 - s,
                this.hi >> s);
      if(s < 48)
       return new
               MlInt64
               (this.mi >> s - 24 | this.hi << 48 - s,this.hi >> s - 24,0);
      return new MlInt64(this.hi >> s - 48,0,0)};
    MlInt64.prototype.shift_right
    =
    function(s)
     {s = s & 63;
      if(s == 0)return this;
      var h=this.hi << 16 >> 16;
      if(s < 24)
       return new
               MlInt64
               (this.lo >> s | this.mi << 24 - s,
                this.mi >> s | h << 24 - s,
                this.hi << 16 >> s >>> 16);
      var sign=this.hi << 16 >> 31;
      if(s < 48)
       return new
               MlInt64
               (this.mi >> s - 24 | this.hi << 48 - s,
                this.hi << 16 >> s - 24 >> 16,
                sign & 0xffff);
      return new MlInt64(this.hi << 16 >> s - 32,sign,sign)};
    MlInt64.prototype.lsl1
    =
    function()
     {this.hi = this.hi << 1 | this.mi >> 23;
      this.mi = (this.mi << 1 | this.lo >> 23) & 0xffffff;
      this.lo = this.lo << 1 & 0xffffff};
    MlInt64.prototype.lsr1
    =
    function()
     {this.lo = (this.lo >>> 1 | this.mi << 23) & 0xffffff;
      this.mi = (this.mi >>> 1 | this.hi << 23) & 0xffffff;
      this.hi = this.hi >>> 1};
    MlInt64.prototype.udivmod
    =
    function(x)
     {var
       offset=0,
       modulus=this.copy(),
       divisor=x.copy(),
       quotient=new MlInt64(0,0,0);
      while(modulus.ucompare(divisor) > 0){offset++;divisor.lsl1()}
      while(offset >= 0)
       {offset--;
        quotient.lsl1();
        if(modulus.ucompare(divisor) >= 0)
         {quotient.lo++;modulus = modulus.sub(divisor)}
        divisor.lsr1()}
      return {quotient:quotient,modulus:modulus}};
    MlInt64.prototype.div
    =
    function(y)
     {var x=this;
      if(y.isZero())caml_raise_zero_divide();
      var sign=x.hi ^ y.hi;
      if(x.hi & 0x8000)x = x.neg();
      if(y.hi & 0x8000)y = y.neg();
      var q=x.udivmod(y).quotient;
      if(sign & 0x8000)q = q.neg();
      return q};
    MlInt64.prototype.mod
    =
    function(y)
     {var x=this;
      if(y.isZero())caml_raise_zero_divide();
      var sign=x.hi;
      if(x.hi & 0x8000)x = x.neg();
      if(y.hi & 0x8000)y = y.neg();
      var r=x.udivmod(y).modulus;
      if(sign & 0x8000)r = r.neg();
      return r};
    MlInt64.prototype.toInt = function(){return this.lo | this.mi << 24};
    MlInt64.prototype.toFloat
    =
    function()
     {return (this.hi << 16)
             *
             Math.pow(2,32)
             +
             this.mi
             *
             Math.pow(2,24)
             +
             this.lo};
    MlInt64.prototype.toArray
    =
    function()
     {return [this.hi >> 8,
              this.hi & 0xff,
              this.mi >> 16,
              this.mi >> 8 & 0xff,
              this.mi & 0xff,
              this.lo >> 16,
              this.lo >> 8 & 0xff,
              this.lo & 0xff]};
    MlInt64.prototype.lo32
    =
    function(){return this.lo | (this.mi & 0xff) << 24};
    MlInt64.prototype.hi32
    =
    function(){return this.mi >>> 8 & 0xffff | this.hi << 16};
    function caml_int64_of_int32(x)
     {return new MlInt64(x & 0xffffff,x >> 24 & 0xffffff,x >> 31 & 0xffff)}
    function caml_int64_to_int32(x){return x.toInt()}
    function caml_int64_is_negative(x){return + x.isNeg()}
    function caml_int64_neg(x){return x.neg()}
    function caml_subarray_to_jsbytes(a,i,len)
     {var f=String.fromCharCode;
      if(i == 0 && len <= 4096 && len == a.length)return f.apply(null,a);
      var s="";
      for(;0 < len;i += 1024,len -= 1024)
       s += f.apply(null,a.slice(i,i + Math.min(len,1024)));
      return s}
    function caml_convert_string_to_bytes(s)
     {if(s.t == 2)
       s.c += caml_str_repeat(s.l - s.c.length,"\0");
      else
       s.c = caml_subarray_to_jsbytes(s.c,0,s.c.length);
      s.t = 0}
    function caml_jsbytes_of_string(s)
     {if((s.t & 6) != 0)caml_convert_string_to_bytes(s);return s.c}
    function caml_raise_with_arg(tag,arg){throw [0,tag,arg]}
    function jsoo_is_ascii(s)
     {if(s.length < 24)
       {for(var i=0;i < s.length;i++)if(s.charCodeAt(i) > 127)return false;
        return true}
      else
       return ! /[^\x00-\x7f]/.test(s)}
    function caml_utf16_of_utf8(s)
     {for(var b="",t="",c,c1,c2,v,i=0,l=s.length;i < l;i++)
       {c1 = s.charCodeAt(i);
        if(c1 < 0x80)
         {for(var j=i + 1;j < l && (c1 = s.charCodeAt(j)) < 0x80;j++);
          if(j - i > 512)
           {t.substr(0,1);b += t;t = "";b += s.slice(i,j)}
          else
           t += s.slice(i,j);
          if(j == l)break;
          i = j}
        v = 1;
        if(++i < l && ((c2 = s.charCodeAt(i)) & - 64) == 128)
         {c = c2 + (c1 << 6);
          if(c1 < 0xe0)
           {v = c - 0x3080;if(v < 0x80)v = 1}
          else
           {v = 2;
            if(++i < l && ((c2 = s.charCodeAt(i)) & - 64) == 128)
             {c = c2 + (c << 6);
              if(c1 < 0xf0)
               {v = c - 0xe2080;
                if(v < 0x800 || v >= 0xd7ff && v < 0xe000)v = 2}
              else
               {v = 3;
                if
                 (++i
                  <
                  l
                  &&
                  ((c2 = s.charCodeAt(i)) & - 64)
                  ==
                  128
                  &&
                  c1
                  <
                  0xf5)
                 {v = c2 - 0x3c82080 + (c << 6);
                  if(v < 0x10000 || v > 0x10ffff)v = 3}}}}}
        if(v < 4)
         {i -= v;t += "\ufffd"}
        else
         if(v > 0xffff)
          t += String.fromCharCode(0xd7c0 + (v >> 10),0xdc00 + (v & 0x3FF));
         else
          t += String.fromCharCode(v);
        if(t.length > 1024){t.substr(0,1);b += t;t = ""}}
      return b + t}
    function MlBytes(tag,contents,length)
     {this.t = tag;this.c = contents;this.l = length}
    MlBytes.prototype.toString
    =
    function()
     {switch(this.t)
       {case 9:return this.c;
        default:caml_convert_string_to_bytes(this);case 0:
         if(jsoo_is_ascii(this.c)){this.t = 9;return this.c}this.t = 8;
        case 8:return caml_utf16_of_utf8(this.c)
        }};
    MlBytes.prototype.slice
    =
    function()
     {var content=this.t == 4?this.c.slice():this.c;
      return new MlBytes(this.t,content,this.l)};
    function caml_bytes_of_jsbytes(s){return new MlBytes(0,s,s.length)}
    function caml_string_of_jsbytes(s){return caml_bytes_of_jsbytes(s)}
    function caml_raise_with_string(tag,msg)
     {caml_raise_with_arg(tag,caml_string_of_jsbytes(msg))}
    function caml_invalid_argument(msg)
     {caml_raise_with_string(caml_global_data.Invalid_argument,msg)}
    function caml_parse_format(fmt)
     {fmt = caml_jsbytes_of_string(fmt);
      var len=fmt.length;
      if(len > 31)caml_invalid_argument("format_int: format too long");
      var
       f=
        {justify:"+",
         signstyle:"-",
         filler:" ",
         alternate:false,
         base:0,
         signedconv:false,
         width:0,
         uppercase:false,
         sign:1,
         prec:- 1,
         conv:"f"};
      for(var i=0;i < len;i++)
       {var c=fmt.charAt(i);
        switch(c)
         {case "-":f.justify = "-";break;
          case "+":
          case " ":f.signstyle = c;break;
          case "0":f.filler = "0";break;
          case "#":f.alternate = true;break;
          case "1":
          case "2":
          case "3":
          case "4":
          case "5":
          case "6":
          case "7":
          case "8":
          case "9":
           f.width = 0;
           while(c = fmt.charCodeAt(i) - 48,c >= 0 && c <= 9)
            {f.width = f.width * 10 + c;i++}
           i--;
           break;
          case ".":
           f.prec = 0;
           i++;
           while(c = fmt.charCodeAt(i) - 48,c >= 0 && c <= 9)
            {f.prec = f.prec * 10 + c;i++}
           i--;
          case "d":
          case "i":f.signedconv = true;
          case "u":f.base = 10;break;
          case "x":f.base = 16;break;
          case "X":f.base = 16;f.uppercase = true;break;
          case "o":f.base = 8;break;
          case "e":
          case "f":
          case "g":f.signedconv = true;f.conv = c;break;
          case "E":
          case "F":
          case "G":
           f.signedconv = true;
           f.uppercase = true;
           f.conv = c.toLowerCase();
           break
          }}
      return f}
    function caml_finish_formatting(f,rawbuffer)
     {if(f.uppercase)rawbuffer = rawbuffer.toUpperCase();
      var len=rawbuffer.length;
      if(f.signedconv && (f.sign < 0 || f.signstyle != "-"))len++;
      if(f.alternate){if(f.base == 8)len += 1;if(f.base == 16)len += 2}
      var buffer="";
      if(f.justify == "+" && f.filler == " ")
       for(var i=len;i < f.width;i++)buffer += " ";
      if(f.signedconv)
       if(f.sign < 0)
        buffer += "-";
       else
        if(f.signstyle != "-")buffer += f.signstyle;
      if(f.alternate && f.base == 8)buffer += "0";
      if(f.alternate && f.base == 16)buffer += "0x";
      if(f.justify == "+" && f.filler == "0")
       for(var i=len;i < f.width;i++)buffer += "0";
      buffer += rawbuffer;
      if(f.justify == "-")for(var i=len;i < f.width;i++)buffer += " ";
      return caml_string_of_jsbytes(buffer)}
    function caml_int64_format(fmt,x)
     {var f=caml_parse_format(fmt);
      if(f.signedconv && caml_int64_is_negative(x))
       {f.sign = - 1;x = caml_int64_neg(x)}
      var
       buffer="",
       wbase=caml_int64_of_int32(f.base),
       cvtbl="0123456789abcdef";
      do
       {var p=x.udivmod(wbase);
        x = p.quotient;
        buffer = cvtbl.charAt(caml_int64_to_int32(p.modulus)) + buffer}
      while
       (! caml_int64_is_zero(x));
      if(f.prec >= 0)
       {f.filler = " ";
        var n=f.prec - buffer.length;
        if(n > 0)buffer = caml_str_repeat(n,"0") + buffer}
      return caml_finish_formatting(f,buffer)}
    function caml_expm1_float(x)
     {var y=Math.exp(x),z=y - 1;
      return Math.abs(x) > 1?z:z == 0?x:x * z / Math.log(y)}
    function caml_jsstring_of_string(s){return s.toString()}
    if(joo_global_object.process && joo_global_object.process.cwd)
     var caml_current_dir=joo_global_object.process.cwd().replace(/\\/g,"/");
    else
     var caml_current_dir="/static";
    if(caml_current_dir.slice(- 1) !== "/")caml_current_dir += "/";
    function caml_make_path(name)
     {name = caml_jsstring_of_string(name);
      if(name.charCodeAt(0) != 47)name = caml_current_dir + name;
      var comp=name.split("/"),ncomp=[];
      for(var i=0;i < comp.length;i++)
       switch(comp[i])
        {case "..":if(ncomp.length > 1)ncomp.pop();break;
         case ".":break;
         case "":if(ncomp.length == 0)ncomp.push("");break;
         default:ncomp.push(comp[i]);break}
      ncomp.orig = name;
      return ncomp}
    function caml_is_ml_bytes(s){return s instanceof MlBytes}
    function caml_is_ml_string(s){return caml_is_ml_bytes(s)}
    function caml_bytes_of_array(a){return new MlBytes(4,a,a.length)}
    function caml_bytes_of_string(s){return s}
    function caml_utf8_of_utf16(s)
     {for(var b="",t=b,c,d,i=0,l=s.length;i < l;i++)
       {c = s.charCodeAt(i);
        if(c < 0x80)
         {for(var j=i + 1;j < l && (c = s.charCodeAt(j)) < 0x80;j++);
          if(j - i > 512)
           {t.substr(0,1);b += t;t = "";b += s.slice(i,j)}
          else
           t += s.slice(i,j);
          if(j == l)break;
          i = j}
        if(c < 0x800)
         {t += String.fromCharCode(0xc0 | c >> 6);
          t += String.fromCharCode(0x80 | c & 0x3f)}
        else
         if(c < 0xd800 || c >= 0xdfff)
          t
          +=
          String.fromCharCode
           (0xe0 | c >> 12,0x80 | c >> 6 & 0x3f,0x80 | c & 0x3f);
         else
          if
           (c
            >=
            0xdbff
            ||
            i
            +
            1
            ==
            l
            ||
            (d = s.charCodeAt(i + 1))
            <
            0xdc00
            ||
            d
            >
            0xdfff)
           t += "\xef\xbf\xbd";
          else
           {i++;
            c = (c << 10) + d - 0x35fdc00;
            t
            +=
            String.fromCharCode
             (0xf0 | c >> 18,
              0x80 | c >> 12 & 0x3f,
              0x80 | c >> 6 & 0x3f,
              0x80 | c & 0x3f)}
        if(t.length > 1024){t.substr(0,1);b += t;t = ""}}
      return b + t}
    function caml_bytes_of_utf16_jsstring(s)
     {var tag=9;
      if(! jsoo_is_ascii(s))tag = 8,s = caml_utf8_of_utf16(s);
      return new MlBytes(tag,s,s.length)}
    function caml_string_of_jsstring(s)
     {return caml_bytes_of_utf16_jsstring(s)}
    function caml_raise_sys_error(msg)
     {caml_raise_with_string(caml_global_data.Sys_error,msg)}
    function caml_raise_no_such_file(name)
     {name = caml_jsbytes_of_string(name);
      caml_raise_sys_error(name + ": No such file or directory")}
    function caml_bytes_bound_error()
     {caml_invalid_argument("index out of bounds")}
    function caml_bytes_unsafe_get(s,i)
     {switch(s.t & 6)
       {default:if(i >= s.c.length)return 0;case 0:return s.c.charCodeAt(i);
        case 4:return s.c[i]
        }}
    function caml_bytes_get(s,i)
     {if(i >>> 0 >= s.l)caml_bytes_bound_error();
      return caml_bytes_unsafe_get(s,i)}
    function caml_create_bytes(len)
     {if(len < 0)caml_invalid_argument("Bytes.create");
      return new MlBytes(len?2:9,"",len)}
    function caml_ml_bytes_length(s){return s.l}
    function caml_convert_bytes_to_array(s)
     {if(joo_global_object.Uint8Array)
       var a=new (joo_global_object.Uint8Array)(s.l);
      else
       var a=new Array(s.l);
      var b=s.c,l=b.length,i=0;
      for(;i < l;i++)a[i] = b.charCodeAt(i);
      for(l = s.l;i < l;i++)a[i] = 0;
      s.c = a;
      s.t = 4;
      return a}
    function caml_blit_bytes(s1,i1,s2,i2,len)
     {if(len == 0)return 0;
      if(i2 == 0 && (len >= s2.l || s2.t == 2 && len >= s2.c.length))
       {s2.c
        =
        s1.t == 4
         ?caml_subarray_to_jsbytes(s1.c,i1,len)
         :i1 == 0 && s1.c.length == len?s1.c:s1.c.substr(i1,len);
        s2.t = s2.c.length == s2.l?0:2}
      else
       if(s2.t == 2 && i2 == s2.c.length)
        {s2.c
         +=
         s1.t == 4
          ?caml_subarray_to_jsbytes(s1.c,i1,len)
          :i1 == 0 && s1.c.length == len?s1.c:s1.c.substr(i1,len);
         s2.t = s2.c.length == s2.l?0:2}
       else
        {if(s2.t != 4)caml_convert_bytes_to_array(s2);
         var c1=s1.c,c2=s2.c;
         if(s1.t == 4)
          if(i2 <= i1)
           for(var i=0;i < len;i++)c2[i2 + i] = c1[i1 + i];
          else
           for(var i=len - 1;i >= 0;i--)c2[i2 + i] = c1[i1 + i];
         else
          {var l=Math.min(len,c1.length - i1);
           for(var i=0;i < l;i++)c2[i2 + i] = c1.charCodeAt(i1 + i);
           for(;i < len;i++)c2[i2 + i] = 0}}
      return 0}
    function caml_blit_string(a,b,c,d,e)
     {caml_blit_bytes(caml_bytes_of_string(a),b,c,d,e);return 0}
    function MlFile(){}
    function MlFakeFile(content){this.data = content}
    MlFakeFile.prototype = new MlFile();
    MlFakeFile.prototype.truncate
    =
    function(len)
     {var old=this.data;
      this.data = caml_create_bytes(len | 0);
      caml_blit_bytes(old,0,this.data,0,len)};
    MlFakeFile.prototype.length
    =
    function(){return caml_ml_bytes_length(this.data)};
    MlFakeFile.prototype.write
    =
    function(offset,buf,pos,len)
     {var clen=this.length();
      if(offset + len >= clen)
       {var new_str=caml_create_bytes(offset + len),old_data=this.data;
        this.data = new_str;
        caml_blit_bytes(old_data,0,this.data,0,clen)}
      caml_blit_string(buf,pos,this.data,offset,len);
      return 0};
    MlFakeFile.prototype.read
    =
    function(offset,buf,pos,len)
     {var clen=this.length();
      caml_blit_bytes(this.data,offset,buf,pos,len);
      return 0};
    MlFakeFile.prototype.read_one
    =
    function(offset){return caml_bytes_get(this.data,offset)};
    MlFakeFile.prototype.close = function(){};
    MlFakeFile.prototype.constructor = MlFakeFile;
    function MlFakeDevice(root,f)
     {this.content = {};this.root = root;this.lookupFun = f}
    MlFakeDevice.prototype.nm = function(name){return this.root + name};
    MlFakeDevice.prototype.lookup
    =
    function(name)
     {if(! this.content[name] && this.lookupFun)
       {var
         res=
          this.lookupFun
           (caml_string_of_jsbytes(this.root),caml_string_of_jsbytes(name));
        if(res !== 0)
         this.content[name] = new MlFakeFile(caml_bytes_of_string(res[1]))}};
    MlFakeDevice.prototype.exists
    =
    function(name)
     {if(name == "")return 1;
      var name_slash=name + "/",r=new RegExp("^" + name_slash);
      for(var n in this.content)if(n.match(r))return 1;
      this.lookup(name);
      return this.content[name]?1:0};
    MlFakeDevice.prototype.readdir
    =
    function(name)
     {var
       name_slash=name == ""?"":name + "/",
       r=new RegExp("^" + name_slash + "([^/]*)"),
       seen={},
       a=[];
      for(var n in this.content)
       {var m=n.match(r);
        if(m && ! seen[m[1]]){seen[m[1]] = true;a.push(m[1])}}
      return a};
    MlFakeDevice.prototype.is_dir
    =
    function(name)
     {var
       name_slash=name == ""?"":name + "/",
       r=new RegExp("^" + name_slash + "([^/]*)"),
       a=[];
      for(var n in this.content){var m=n.match(r);if(m)return 1}
      return 0};
    MlFakeDevice.prototype.unlink
    =
    function(name)
     {var ok=this.content[name]?true:false;
      delete this.content[name];
      return ok};
    MlFakeDevice.prototype.open
    =
    function(name,f)
     {if(f.rdonly && f.wronly)
       caml_raise_sys_error
        (this.nm(name)
         +
         " : flags Open_rdonly and Open_wronly are not compatible");
      if(f.text && f.binary)
       caml_raise_sys_error
        (this.nm(name)
         +
         " : flags Open_text and Open_binary are not compatible");
      this.lookup(name);
      if(this.content[name])
       {if(this.is_dir(name))
         caml_raise_sys_error(this.nm(name) + " : is a directory");
        if(f.create && f.excl)
         caml_raise_sys_error(this.nm(name) + " : file already exists");
        var file=this.content[name];
        if(f.truncate)file.truncate();
        return file}
      else
       if(f.create)
        {this.content[name] = new MlFakeFile(caml_create_bytes(0));
         return this.content[name]}
       else
        caml_raise_no_such_file(this.nm(name))};
    MlFakeDevice.prototype.register
    =
    function(name,content)
     {if(this.content[name])
       caml_raise_sys_error(this.nm(name) + " : file already exists");
      if(caml_is_ml_bytes(content))
       this.content[name] = new MlFakeFile(content);
      if(caml_is_ml_string(content))
       this.content[name] = new MlFakeFile(caml_bytes_of_string(content));
      else
       if(content instanceof Array)
        this.content[name] = new MlFakeFile(caml_bytes_of_array(content));
       else
        if(typeof content === "string")
         this.content[name] = new MlFakeFile(caml_bytes_of_jsbytes(content));
        else
         if(content.toString)
          {var
            bytes=
             caml_bytes_of_string(caml_string_of_jsstring(content.toString()));
           this.content[name] = new MlFakeFile(bytes)}
         else
          caml_raise_sys_error
           (this.nm(name) + " : registering file with invalid content type")};
    MlFakeDevice.prototype.constructor = MlFakeDevice;
    function caml_ml_string_length(s){return caml_ml_bytes_length(s)}
    function caml_string_unsafe_get(s,i){return caml_bytes_unsafe_get(s,i)}
    function caml_array_of_string(s)
     {var l=caml_ml_string_length(s),a=new Array(l),i=0;
      for(;i < l;i++)a[i] = caml_string_unsafe_get(s,i);
      return a}
    function caml_array_of_bytes(s)
     {if(s.t != 4)caml_convert_bytes_to_array(s);return s.c}
    function caml_bytes_unsafe_set(s,i,c)
     {c &= 0xff;
      if(s.t != 4)
       {if(i == s.c.length)
         {s.c += String.fromCharCode(c);if(i + 1 == s.l)s.t = 0;return 0}
        caml_convert_bytes_to_array(s)}
      s.c[i] = c;
      return 0}
    function caml_bytes_set(s,i,c)
     {if(i >>> 0 >= s.l)caml_bytes_bound_error();
      return caml_bytes_unsafe_set(s,i,c)}
    function MlNodeFile(fd){this.fs = require("fs");this.fd = fd}
    MlNodeFile.prototype = new MlFile();
    MlNodeFile.prototype.truncate
    =
    function(len)
     {try
       {this.fs.ftruncateSync(this.fd,len | 0)}
      catch(err){caml_raise_sys_error(err.toString())}};
    MlNodeFile.prototype.length
    =
    function()
     {try
       {return this.fs.fstatSync(this.fd).size}
      catch(err){caml_raise_sys_error(err.toString())}};
    MlNodeFile.prototype.write
    =
    function(offset,buf,buf_offset,len)
     {var a=caml_array_of_string(buf);
      if(! (a instanceof joo_global_object.Uint8Array))
       a = new (joo_global_object.Uint8Array)(a);
      var buffer=joo_global_object.Buffer.from(a);
      try
       {this.fs.writeSync(this.fd,buffer,buf_offset,len,offset)}
      catch(err){caml_raise_sys_error(err.toString())}
      return 0};
    MlNodeFile.prototype.read
    =
    function(offset,buf,buf_offset,len)
     {var a=caml_array_of_bytes(buf);
      if(! (a instanceof joo_global_object.Uint8Array))
       a = new (joo_global_object.Uint8Array)(a);
      var buffer=joo_global_object.Buffer.from(a);
      try
       {this.fs.readSync(this.fd,buffer,buf_offset,len,offset)}
      catch(err){caml_raise_sys_error(err.toString())}
      for(var i=0;i < len;i++)
       caml_bytes_set(buf,buf_offset + i,buffer[buf_offset + i]);
      return 0};
    MlNodeFile.prototype.read_one
    =
    function(offset)
     {var
       a=new (joo_global_object.Uint8Array)(1),
       buffer=joo_global_object.Buffer.from(a);
      try
       {this.fs.readSync(this.fd,buffer,0,1,offset)}
      catch(err){caml_raise_sys_error(err.toString())}
      return buffer[0]};
    MlNodeFile.prototype.close
    =
    function()
     {try
       {this.fs.closeSync(this.fd)}
      catch(err){caml_raise_sys_error(err.toString())}};
    MlNodeFile.prototype.constructor = MlNodeFile;
    function MlNodeDevice(root){this.fs = require("fs");this.root = root}
    MlNodeDevice.prototype.nm = function(name){return this.root + name};
    MlNodeDevice.prototype.exists
    =
    function(name)
     {try
       {return this.fs.existsSync(this.nm(name))?1:0}
      catch(err){caml_raise_sys_error(err.toString())}};
    MlNodeDevice.prototype.readdir
    =
    function(name)
     {try
       {return this.fs.readdirSync(this.nm(name))}
      catch(err){caml_raise_sys_error(err.toString())}};
    MlNodeDevice.prototype.is_dir
    =
    function(name)
     {try
       {return this.fs.statSync(this.nm(name)).isDirectory()?1:0}
      catch(err){caml_raise_sys_error(err.toString())}};
    MlNodeDevice.prototype.unlink
    =
    function(name)
     {try
       {var b=this.fs.existsSync(this.nm(name))?1:0;
        this.fs.unlinkSync(this.nm(name))}
      catch(err){caml_raise_sys_error(err.toString())}
      return b};
    MlNodeDevice.prototype.open
    =
    function(name,f)
     {var consts=require("constants"),res=0;
      for(var key in f)
       switch(key)
        {case "rdonly":res |= consts.O_RDONLY;break;
         case "wronly":res |= consts.O_WRONLY;break;
         case "append":res |= consts.O_WRONLY | consts.O_APPEND;break;
         case "create":res |= consts.O_CREAT;break;
         case "truncate":res |= consts.O_TRUNC;break;
         case "excl":res |= consts.O_EXCL;break;
         case "binary":res |= consts.O_BINARY;break;
         case "text":res |= consts.O_TEXT;break;
         case "nonblock":res |= consts.O_NONBLOCK;break
         }
      try
       {var fd=this.fs.openSync(this.nm(name),res);return new MlNodeFile(fd)}
      catch(err){caml_raise_sys_error(err.toString())}};
    MlNodeDevice.prototype.rename
    =
    function(o,n)
     {try
       {this.fs.renameSync(this.nm(o),this.nm(n))}
      catch(err){caml_raise_sys_error(err.toString())}};
    MlNodeDevice.prototype.constructor = MlNodeDevice;
    var caml_root=caml_current_dir.match(/[^\/]*\//)[0];
    function fs_node_supported()
     {return typeof joo_global_object.process
             !==
             "undefined"
             &&
             typeof joo_global_object.process.versions
             !==
             "undefined"
             &&
             typeof joo_global_object.process.versions.node
             !==
             "undefined"
             &&
             joo_global_object.process.platform
             !==
             "browser"}
    var jsoo_mount_point=[];
    if(fs_node_supported())
     jsoo_mount_point.push
      ({path:caml_root,device:new MlNodeDevice(caml_root)});
    else
     jsoo_mount_point.push
      ({path:caml_root,device:new MlFakeDevice(caml_root)});
    jsoo_mount_point.push
     ({path:caml_root + "static/",
       device:new MlFakeDevice(caml_root + "static/")});
    function resolve_fs_device(name)
     {var
       path=caml_make_path(name),
       name=path.join("/"),
       name_slash=name + "/",
       res;
      for(var i=0;i < jsoo_mount_point.length;i++)
       {var m=jsoo_mount_point[i];
        if
         (name_slash.search(m.path)
          ==
          0
          &&
          (! res || res.path.length < m.path.length))
         res
         =
         {path:m.path,
          device:m.device,
          rest:name.substring(m.path.length,name.length)}}
      return res}
    function caml_sys_is_directory(name)
     {var root=resolve_fs_device(name),a=root.device.is_dir(root.rest);
      return a?1:0}
    function caml_raise_not_found()
     {caml_raise_constant(caml_global_data.Not_found)}
    function caml_sys_getenv(name)
     {var g=joo_global_object,n=caml_jsstring_of_string(name);
      if(g.process && g.process.env && g.process.env[n] != undefined)
       return caml_string_of_jsstring(g.process.env[n]);
      if
       (joo_global_object.jsoo_static_env
        &&
        joo_global_object.jsoo_static_env[n])
       return caml_string_of_jsstring(joo_global_object.jsoo_static_env[n]);
      caml_raise_not_found()}
    function shift_right_nat(nat1,ofs1,len1,nat2,ofs2,nbits)
     {if(nbits == 0){nat2.data[ofs2] = 0;return 0}
      var wrap=0;
      for(var i=len1 - 1;i >= 0;i--)
       {var a=nat1.data[ofs1 + i] >>> 0;
        nat1.data[ofs1 + i] = a >>> nbits | wrap;
        wrap = a << 32 - nbits}
      nat2.data[ofs2] = wrap;
      return 0}
    var caml_named_values={};
    function caml_named_value(nm){return caml_named_values[nm]}
    var caml_gr_state;
    function caml_gr_state_get()
     {if(caml_gr_state)return caml_gr_state;
      throw [0,
             caml_named_value("Graphics.Graphic_failure"),
             caml_string_of_jsbytes("Not initialized")]}
    function caml_gr_point_color(x,y)
     {var
       s=caml_gr_state_get(),
       im=s.context.getImageData(x,s.height - y,1,1),
       d=im.data;
      return (d[0] << 16) + (d[1] << 8) + d[2]}
    var MlObjectTable;
    if(typeof joo_global_object.WeakMap === "undefined")
     MlObjectTable
     =
     function()
       {function NaiveLookup(objs){this.objs = objs}
        NaiveLookup.prototype.get
        =
        function(v)
         {for(var i=0;i < this.objs.length;i++)if(this.objs[i] === v)return i};
        NaiveLookup.prototype.set = function(){};
        return function()
         {this.objs = [];this.lookup = new NaiveLookup(this.objs)}}
      ();
    else
     MlObjectTable
     =
     function()
      {this.objs = [];this.lookup = new (joo_global_object.WeakMap)()};
    MlObjectTable.prototype.store
    =
    function(v){this.lookup.set(v,this.objs.length);this.objs.push(v)};
    MlObjectTable.prototype.recall
    =
    function(v)
     {var i=this.lookup.get(v);
      return i === undefined?undefined:this.objs.length - i};
    function caml_failwith(msg)
     {caml_raise_with_string(caml_global_data.Failure,msg)}
    function caml_sys_rename(o,n)
     {var o_root=resolve_fs_device(o),n_root=resolve_fs_device(n);
      if(o_root.device != n_root.device)
       caml_failwith
        ("caml_sys_rename: cannot move file between two filesystem");
      if(! o_root.device.rename)
       caml_failwith("caml_sys_rename: no implemented");
      o_root.device.rename(o_root.rest,n_root.rest)}
    function caml_log10_float(x){return Math.LOG10E * Math.log(x)}
    var caml_runtime_warnings=0;
    function caml_ml_enable_runtime_warnings(bool)
     {caml_runtime_warnings = bool;return 0}
    function caml_classify_float(x)
     {if(isFinite(x))
       {if(Math.abs(x) >= 2.2250738585072014e-308)return 0;
        if(x != 0)return 1;
        return 2}
      return isNaN(x)?4:3}
    function caml_ml_refill_input(chan)
     {var str=chan.refill(),str_len=caml_ml_string_length(str);
      if(str_len == 0)chan.refill = null;
      chan.file.write(chan.file.length(),str,0,str_len);
      return str_len}
    var caml_ml_channels=new Array();
    function caml_ml_may_refill_input(chanid)
     {var chan=caml_ml_channels[chanid];
      if(chan.refill == null)return;
      if(chan.file.length() != chan.offset)return;
      caml_ml_refill_input(chan)}
    function caml_array_bound_error()
     {caml_invalid_argument("index out of bounds")}
    function caml_ml_input_scan_line(chanid)
     {var chan=caml_ml_channels[chanid];
      caml_ml_may_refill_input(chanid);
      var p=chan.offset,len=chan.file.length();
      if(p >= len)return 0;
      while(true)
       {if(p >= len)return - (p - chan.offset);
        if(chan.file.read_one(p) == 10)return p - chan.offset + 1;
        p++}}
    function caml_gc_minor(){return 0}
    var
     bigInt=
      function(undefined)
        {"use strict";
         var
          BASE=1e7,
          LOG_BASE=7,
          MAX_INT=9007199254740992,
          MAX_INT_ARR=smallToArray(MAX_INT),
          DEFAULT_ALPHABET="0123456789abcdefghijklmnopqrstuvwxyz",
          BigInt=joo_global_object.BigInt,
          supportsNativeBigInt=typeof BigInt === "function";
         function Integer(v,radix,alphabet,caseSensitive)
          {if(typeof v === "undefined")return Integer[0];
           if(typeof radix !== "undefined")
            return + radix === 10 && ! alphabet
                    ?parseValue(v)
                    :parseBase(v,radix,alphabet,caseSensitive);
           return parseValue(v)}
         function BigInteger(value,sign)
          {this.value = value;
           this.sign = sign;
           this.isSmall = false;
           this.caml_custom = "_z"}
         BigInteger.prototype = Object.create(Integer.prototype);
         function SmallInteger(value)
          {this.value = value;
           this.sign = value < 0;
           this.isSmall = true;
           this.caml_custom = "_z"}
         SmallInteger.prototype = Object.create(Integer.prototype);
         function NativeBigInt(value)
          {this.value = value;this.caml_custom = "_z"}
         NativeBigInt.prototype = Object.create(Integer.prototype);
         function isPrecise(n){return - MAX_INT < n && n < MAX_INT}
         function smallToArray(n)
          {if(n < 1e7)return [n];
           if(n < 1e14)return [n % 1e7,Math.floor(n / 1e7)];
           return [n % 1e7,Math.floor(n / 1e7) % 1e7,Math.floor(n / 1e14)]}
         function arrayToSmall(arr)
          {trim(arr);
           var length=arr.length;
           if(length < 4 && compareAbs(arr,MAX_INT_ARR) < 0)
            switch(length)
             {case 0:return 0;
              case 1:return arr[0];
              case 2:return arr[0] + arr[1] * BASE;
              default:return arr[0] + (arr[1] + arr[2] * BASE) * BASE}
           return arr}
         function trim(v){var i=v.length;while(v[--i] === 0);v.length = i + 1}
         function createArray(length)
          {var x=new Array(length),i=- 1;while(++i < length)x[i] = 0;return x}
         function truncate(n)
          {if(n > 0)return Math.floor(n);return Math.ceil(n)}
         function add(a,b)
          {var
            l_a=a.length,
            l_b=b.length,
            r=new Array(l_a),
            carry=0,
            base=BASE,
            sum,
            i;
           for(i = 0;i < l_b;i++)
            {sum = a[i] + b[i] + carry;
             carry = sum >= base?1:0;
             r[i] = sum - carry * base}
           while(i < l_a)
            {sum = a[i] + carry;
             carry = sum === base?1:0;
             r[i++] = sum - carry * base}
           if(carry > 0)r.push(carry);
           return r}
         function addAny(a,b)
          {if(a.length >= b.length)return add(a,b);return add(b,a)}
         function addSmall(a,carry)
          {var l=a.length,r=new Array(l),base=BASE,sum,i;
           for(i = 0;i < l;i++)
            {sum = a[i] - base + carry;
             carry = Math.floor(sum / base);
             r[i] = sum - carry * base;
             carry += 1}
           while(carry > 0)
            {r[i++] = carry % base;carry = Math.floor(carry / base)}
           return r}
         BigInteger.prototype.add
         =
         function(v)
          {var n=parseValue(v);
           if(this.sign !== n.sign)return this.subtract(n.negate());
           var a=this.value,b=n.value;
           if(n.isSmall)
            return new BigInteger(addSmall(a,Math.abs(b)),this.sign);
           return new BigInteger(addAny(a,b),this.sign)};
         BigInteger.prototype.plus = BigInteger.prototype.add;
         SmallInteger.prototype.add
         =
         function(v)
          {var n=parseValue(v),a=this.value;
           if(a < 0 !== n.sign)return this.subtract(n.negate());
           var b=n.value;
           if(n.isSmall)
            {if(isPrecise(a + b))return new SmallInteger(a + b);
             b = smallToArray(Math.abs(b))}
           return new BigInteger(addSmall(b,Math.abs(a)),a < 0)};
         SmallInteger.prototype.plus = SmallInteger.prototype.add;
         NativeBigInt.prototype.add
         =
         function(v)
          {return new NativeBigInt(this.value + parseValue(v).value)};
         NativeBigInt.prototype.plus = NativeBigInt.prototype.add;
         function subtract(a,b)
          {var
            a_l=a.length,
            b_l=b.length,
            r=new Array(a_l),
            borrow=0,
            base=BASE,
            i,
            difference;
           for(i = 0;i < b_l;i++)
            {difference = a[i] - borrow - b[i];
             if(difference < 0){difference += base;borrow = 1}else borrow = 0;
             r[i] = difference}
           for(i = b_l;i < a_l;i++)
            {difference = a[i] - borrow;
             if(difference < 0)
              difference += base;
             else
              {r[i++] = difference;break}
             r[i] = difference}
           for(;i < a_l;i++)r[i] = a[i];
           trim(r);
           return r}
         function subtractAny(a,b,sign)
          {var value;
           if(compareAbs(a,b) >= 0)
            value = subtract(a,b);
           else
            {value = subtract(b,a);sign = ! sign}
           value = arrayToSmall(value);
           if(typeof value === "number")
            {if(sign)value = - value;return new SmallInteger(value)}
           return new BigInteger(value,sign)}
         function subtractSmall(a,b,sign)
          {var l=a.length,r=new Array(l),carry=- b,base=BASE,i,difference;
           for(i = 0;i < l;i++)
            {difference = a[i] + carry;
             carry = Math.floor(difference / base);
             difference %= base;
             r[i] = difference < 0?difference + base:difference}
           r = arrayToSmall(r);
           if(typeof r === "number")
            {if(sign)r = - r;return new SmallInteger(r)}
           return new BigInteger(r,sign)}
         BigInteger.prototype.subtract
         =
         function(v)
          {var n=parseValue(v);
           if(this.sign !== n.sign)return this.add(n.negate());
           var a=this.value,b=n.value;
           if(n.isSmall)return subtractSmall(a,Math.abs(b),this.sign);
           return subtractAny(a,b,this.sign)};
         BigInteger.prototype.minus = BigInteger.prototype.subtract;
         SmallInteger.prototype.subtract
         =
         function(v)
          {var n=parseValue(v),a=this.value;
           if(a < 0 !== n.sign)return this.add(n.negate());
           var b=n.value;
           if(n.isSmall)return new SmallInteger(a - b);
           return subtractSmall(b,Math.abs(a),a >= 0)};
         SmallInteger.prototype.minus = SmallInteger.prototype.subtract;
         NativeBigInt.prototype.subtract
         =
         function(v)
          {return new NativeBigInt(this.value - parseValue(v).value)};
         NativeBigInt.prototype.minus = NativeBigInt.prototype.subtract;
         BigInteger.prototype.negate
         =
         function(){return new BigInteger(this.value,! this.sign)};
         SmallInteger.prototype.negate
         =
         function()
          {var sign=this.sign,small=new SmallInteger(- this.value);
           small.sign = ! sign;
           return small};
         NativeBigInt.prototype.negate
         =
         function(){return new NativeBigInt(- this.value)};
         BigInteger.prototype.abs
         =
         function(){return new BigInteger(this.value,false)};
         SmallInteger.prototype.abs
         =
         function(){return new SmallInteger(Math.abs(this.value))};
         NativeBigInt.prototype.abs
         =
         function()
          {return new NativeBigInt(this.value >= 0?this.value:- this.value)};
         function multiplyLong(a,b)
          {var
            a_l=a.length,
            b_l=b.length,
            l=a_l + b_l,
            r=createArray(l),
            base=BASE,
            product,
            carry,
            i,
            a_i,
            b_j;
           for(i = 0;i < a_l;++i)
            {a_i = a[i];
             for(var j=0;j < b_l;++j)
              {b_j = b[j];
               product = a_i * b_j + r[i + j];
               carry = Math.floor(product / base);
               r[i + j] = product - carry * base;
               r[i + j + 1] += carry}}
           trim(r);
           return r}
         function multiplySmall(a,b)
          {var l=a.length,r=new Array(l),base=BASE,carry=0,product,i;
           for(i = 0;i < l;i++)
            {product = a[i] * b + carry;
             carry = Math.floor(product / base);
             r[i] = product - carry * base}
           while(carry > 0)
            {r[i++] = carry % base;carry = Math.floor(carry / base)}
           return r}
         function shiftLeft(x,n)
          {var r=[];while(n-- > 0)r.push(0);return r.concat(x)}
         function multiplyKaratsuba(x,y)
          {var n=Math.max(x.length,y.length);
           if(n <= 30)return multiplyLong(x,y);
           n = Math.ceil(n / 2);
           var
            b=x.slice(n),
            a=x.slice(0,n),
            d=y.slice(n),
            c=y.slice(0,n),
            ac=multiplyKaratsuba(a,c),
            bd=multiplyKaratsuba(b,d),
            abcd=multiplyKaratsuba(addAny(a,b),addAny(c,d)),
            product=
             addAny
              (addAny(ac,shiftLeft(subtract(subtract(abcd,ac),bd),n)),
               shiftLeft(bd,2 * n));
           trim(product);
           return product}
         function useKaratsuba(l1,l2)
          {return - (0.012 * l1) - 0.012 * l2 + 0.000015 * l1 * l2 > 0}
         BigInteger.prototype.multiply
         =
         function(v)
          {var
            n=parseValue(v),
            a=this.value,
            b=n.value,
            sign=this.sign !== n.sign,
            abs;
           if(n.isSmall)
            {if(b === 0)return Integer[0];
             if(b === 1)return this;
             if(b === - 1)return this.negate();
             abs = Math.abs(b);
             if(abs < BASE)return new BigInteger(multiplySmall(a,abs),sign);
             b = smallToArray(abs)}
           if(useKaratsuba(a.length,b.length))
            return new BigInteger(multiplyKaratsuba(a,b),sign);
           return new BigInteger(multiplyLong(a,b),sign)};
         BigInteger.prototype.times = BigInteger.prototype.multiply;
         function multiplySmallAndArray(a,b,sign)
          {if(a < BASE)return new BigInteger(multiplySmall(b,a),sign);
           return new BigInteger(multiplyLong(b,smallToArray(a)),sign)}
         SmallInteger.prototype._multiplyBySmall
         =
         function(a)
          {if(isPrecise(a.value * this.value))
            return new SmallInteger(a.value * this.value);
           return multiplySmallAndArray
                   (Math.abs(a.value),
                    smallToArray(Math.abs(this.value)),
                    this.sign !== a.sign)};
         BigInteger.prototype._multiplyBySmall
         =
         function(a)
          {if(a.value === 0)return Integer[0];
           if(a.value === 1)return this;
           if(a.value === - 1)return this.negate();
           return multiplySmallAndArray
                   (Math.abs(a.value),this.value,this.sign !== a.sign)};
         SmallInteger.prototype.multiply
         =
         function(v){return parseValue(v)._multiplyBySmall(this)};
         SmallInteger.prototype.times = SmallInteger.prototype.multiply;
         NativeBigInt.prototype.multiply
         =
         function(v)
          {return new NativeBigInt(this.value * parseValue(v).value)};
         NativeBigInt.prototype.times = NativeBigInt.prototype.multiply;
         function square(a)
          {var
            l=a.length,
            r=createArray(l + l),
            base=BASE,
            product,
            carry,
            i,
            a_i,
            a_j;
           for(i = 0;i < l;i++)
            {a_i = a[i];
             carry = 0 - a_i * a_i;
             for(var j=i;j < l;j++)
              {a_j = a[j];
               product = 2 * (a_i * a_j) + r[i + j] + carry;
               carry = Math.floor(product / base);
               r[i + j] = product - carry * base}
             r[i + l] = carry}
           trim(r);
           return r}
         BigInteger.prototype.square
         =
         function(){return new BigInteger(square(this.value),false)};
         SmallInteger.prototype.square
         =
         function()
          {var value=this.value * this.value;
           if(isPrecise(value))return new SmallInteger(value);
           return new
                   BigInteger
                   (square(smallToArray(Math.abs(this.value))),false)};
         NativeBigInt.prototype.square
         =
         function(v){return new NativeBigInt(this.value * this.value)};
         function divMod1(a,b)
          {var
            a_l=a.length,
            b_l=b.length,
            base=BASE,
            result=createArray(b.length),
            divisorMostSignificantDigit=b[b_l - 1],
            lambda=Math.ceil(base / (2 * divisorMostSignificantDigit)),
            remainder=multiplySmall(a,lambda),
            divisor=multiplySmall(b,lambda),
            quotientDigit,
            shift,
            carry,
            borrow,
            i,
            l,
            q;
           if(remainder.length <= a_l)remainder.push(0);
           divisor.push(0);
           divisorMostSignificantDigit = divisor[b_l - 1];
           for(shift = a_l - b_l;shift >= 0;shift--)
            {quotientDigit = base - 1;
             if(remainder[shift + b_l] !== divisorMostSignificantDigit)
              quotientDigit
              =
              Math.floor
               ((remainder[shift + b_l] * base + remainder[shift + b_l - 1])
                /
                divisorMostSignificantDigit);
             carry = 0;
             borrow = 0;
             l = divisor.length;
             for(i = 0;i < l;i++)
              {carry += quotientDigit * divisor[i];
               q = Math.floor(carry / base);
               borrow += remainder[shift + i] - (carry - q * base);
               carry = q;
               if(borrow < 0)
                {remainder[shift + i] = borrow + base;borrow = - 1}
               else
                {remainder[shift + i] = borrow;borrow = 0}}
             while(borrow !== 0)
              {quotientDigit -= 1;
               carry = 0;
               for(i = 0;i < l;i++)
                {carry += remainder[shift + i] - base + divisor[i];
                 if(carry < 0)
                  {remainder[shift + i] = carry + base;carry = 0}
                 else
                  {remainder[shift + i] = carry;carry = 1}}
               borrow += carry}
             result[shift] = quotientDigit}
           remainder = divModSmall(remainder,lambda)[0];
           return [arrayToSmall(result),arrayToSmall(remainder)]}
         function divMod2(a,b)
          {var
            a_l=a.length,
            b_l=b.length,
            result=[],
            part=[],
            base=BASE,
            guess,
            xlen,
            highx,
            highy,
            check;
           while(a_l)
            {part.unshift(a[--a_l]);
             trim(part);
             if(compareAbs(part,b) < 0){result.push(0);continue}
             xlen = part.length;
             highx = part[xlen - 1] * base + part[xlen - 2];
             highy = b[b_l - 1] * base + b[b_l - 2];
             if(xlen > b_l)highx = (highx + 1) * base;
             guess = Math.ceil(highx / highy);
             do
              {check = multiplySmall(b,guess);
               if(compareAbs(check,part) <= 0)break;
               guess--}
             while
              (guess);
             result.push(guess);
             part = subtract(part,check)}
           result.reverse();
           return [arrayToSmall(result),arrayToSmall(part)]}
         function divModSmall(value,lambda)
          {var
            length=value.length,
            quotient=createArray(length),
            base=BASE,
            i,
            q,
            remainder,
            divisor;
           remainder = 0;
           for(i = length - 1;i >= 0;--i)
            {divisor = remainder * base + value[i];
             q = truncate(divisor / lambda);
             remainder = divisor - q * lambda;
             quotient[i] = q | 0}
           return [quotient,remainder | 0]}
         function divModAny(self,v)
          {var value,n=parseValue(v);
           if(supportsNativeBigInt)
            return [new NativeBigInt(self.value / n.value),
                    new NativeBigInt(self.value % n.value)];
           var a=self.value,b=n.value,quotient;
           if(b === 0)throw new Error("Cannot divide by zero");
           if(self.isSmall)
            {if(n.isSmall)
              return [new SmallInteger(truncate(a / b)),
                      new SmallInteger(a % b)];
             return [Integer[0],self]}
           if(n.isSmall)
            {if(b === 1)return [self,Integer[0]];
             if(b == - 1)return [self.negate(),Integer[0]];
             var abs=Math.abs(b);
             if(abs < BASE)
              {value = divModSmall(a,abs);
               quotient = arrayToSmall(value[0]);
               var remainder=value[1];
               if(self.sign)remainder = - remainder;
               if(typeof quotient === "number")
                {if(self.sign !== n.sign)quotient = - quotient;
                 return [new SmallInteger(quotient),
                         new SmallInteger(remainder)]}
               return [new BigInteger(quotient,self.sign !== n.sign),
                       new SmallInteger(remainder)]}
             b = smallToArray(abs)}
           var comparison=compareAbs(a,b);
           if(comparison === - 1)return [Integer[0],self];
           if(comparison === 0)
            return [Integer[self.sign === n.sign?1:- 1],Integer[0]];
           if(a.length + b.length <= 200)
            value = divMod1(a,b);
           else
            value = divMod2(a,b);
           quotient = value[0];
           var qSign=self.sign !== n.sign,mod=value[1],mSign=self.sign;
           if(typeof quotient === "number")
            {if(qSign)quotient = - quotient;
             quotient = new SmallInteger(quotient)}
           else
            quotient = new BigInteger(quotient,qSign);
           if(typeof mod === "number")
            {if(mSign)mod = - mod;mod = new SmallInteger(mod)}
           else
            mod = new BigInteger(mod,mSign);
           return [quotient,mod]}
         BigInteger.prototype.divmod
         =
         function(v)
          {var result=divModAny(this,v);
           return {quotient:result[0],remainder:result[1]}};
         NativeBigInt.prototype.divmod
         =
         SmallInteger.prototype.divmod
         =
         BigInteger.prototype.divmod;
         BigInteger.prototype.divide
         =
         function(v){return divModAny(this,v)[0]};
         NativeBigInt.prototype.over
         =
         NativeBigInt.prototype.divide
         =
         function(v)
          {return new NativeBigInt(this.value / parseValue(v).value)};
         SmallInteger.prototype.over
         =
         SmallInteger.prototype.divide
         =
         BigInteger.prototype.over
         =
         BigInteger.prototype.divide;
         BigInteger.prototype.mod = function(v){return divModAny(this,v)[1]};
         NativeBigInt.prototype.mod
         =
         NativeBigInt.prototype.remainder
         =
         function(v)
          {return new NativeBigInt(this.value % parseValue(v).value)};
         SmallInteger.prototype.remainder
         =
         SmallInteger.prototype.mod
         =
         BigInteger.prototype.remainder
         =
         BigInteger.prototype.mod;
         BigInteger.prototype.pow
         =
         function(v)
          {var n=parseValue(v),a=this.value,b=n.value,value,x,y;
           if(b === 0)return Integer[1];
           if(a === 0)return Integer[0];
           if(a === 1)return Integer[1];
           if(a === - 1)return n.isEven()?Integer[1]:Integer[- 1];
           if(n.sign)return Integer[0];
           if(! n.isSmall)
            throw new Error("The exponent " + n.toString() + " is too large.");
           if(this.isSmall)
            if(isPrecise(value = Math.pow(a,b)))
             return new SmallInteger(truncate(value));
           x = this;
           y = Integer[1];
           while(true)
            {if(b & 1 === 1){y = y.times(x);--b}
             if(b === 0)break;
             b /= 2;
             x = x.square()}
           return y};
         SmallInteger.prototype.pow = BigInteger.prototype.pow;
         NativeBigInt.prototype.pow
         =
         function(v)
          {var
            n=parseValue(v),
            a=this.value,
            b=n.value,
            _0=BigInt(0),
            _1=BigInt(1),
            _2=BigInt(2);
           if(b === _0)return Integer[1];
           if(a === _0)return Integer[0];
           if(a === _1)return Integer[1];
           if(a === BigInt(- 1))return n.isEven()?Integer[1]:Integer[- 1];
           if(n.isNegative())return new NativeBigInt(_0);
           var x=this,y=Integer[1];
           while(true)
            {if((b & _1) === _1){y = y.times(x);--b}
             if(b === _0)break;
             b /= _2;
             x = x.square()}
           return y};
         BigInteger.prototype.modPow
         =
         function(exp,mod)
          {exp = parseValue(exp);
           mod = parseValue(mod);
           if(mod.isZero())
            throw new Error("Cannot take modPow with modulus 0");
           var r=Integer[1],base=this.mod(mod);
           if(exp.isNegative())
            {exp = exp.multiply(Integer[- 1]);base = base.modInv(mod)}
           while(exp.isPositive())
            {if(base.isZero())return Integer[0];
             if(exp.isOdd())r = r.multiply(base).mod(mod);
             exp = exp.divide(2);
             base = base.square().mod(mod)}
           return r};
         NativeBigInt.prototype.modPow
         =
         SmallInteger.prototype.modPow
         =
         BigInteger.prototype.modPow;
         function compareAbs(a,b)
          {if(a.length !== b.length)return a.length > b.length?1:- 1;
           for(var i=a.length - 1;i >= 0;i--)
            if(a[i] !== b[i])return a[i] > b[i]?1:- 1;
           return 0}
         BigInteger.prototype.compareAbs
         =
         function(v)
          {var n=parseValue(v),a=this.value,b=n.value;
           if(n.isSmall)return 1;
           return compareAbs(a,b)};
         SmallInteger.prototype.compareAbs
         =
         function(v)
          {var n=parseValue(v),a=Math.abs(this.value),b=n.value;
           if(n.isSmall){b = Math.abs(b);return a === b?0:a > b?1:- 1}
           return - 1};
         NativeBigInt.prototype.compareAbs
         =
         function(v)
          {var a=this.value,b=parseValue(v).value;
           a = a >= 0?a:- a;
           b = b >= 0?b:- b;
           return a === b?0:a > b?1:- 1};
         BigInteger.prototype.compare
         =
         function(v)
          {if(v === Infinity)return - 1;
           if(v === - Infinity)return 1;
           var n=parseValue(v),a=this.value,b=n.value;
           if(this.sign !== n.sign)return n.sign?1:- 1;
           if(n.isSmall)return this.sign?- 1:1;
           return compareAbs(a,b) * (this.sign?- 1:1)};
         BigInteger.prototype.compareTo = BigInteger.prototype.compare;
         SmallInteger.prototype.compare
         =
         function(v)
          {if(v === Infinity)return - 1;
           if(v === - Infinity)return 1;
           var n=parseValue(v),a=this.value,b=n.value;
           if(n.isSmall)return a == b?0:a > b?1:- 1;
           if(a < 0 !== n.sign)return a < 0?- 1:1;
           return a < 0?1:- 1};
         SmallInteger.prototype.compareTo = SmallInteger.prototype.compare;
         NativeBigInt.prototype.compare
         =
         function(v)
          {if(v === Infinity)return - 1;
           if(v === - Infinity)return 1;
           var a=this.value,b=parseValue(v).value;
           return a === b?0:a > b?1:- 1};
         NativeBigInt.prototype.compareTo = NativeBigInt.prototype.compare;
         BigInteger.prototype.equals
         =
         function(v){return this.compare(v) === 0};
         NativeBigInt.prototype.eq
         =
         NativeBigInt.prototype.equals
         =
         SmallInteger.prototype.eq
         =
         SmallInteger.prototype.equals
         =
         BigInteger.prototype.eq
         =
         BigInteger.prototype.equals;
         BigInteger.prototype.notEquals
         =
         function(v){return this.compare(v) !== 0};
         NativeBigInt.prototype.neq
         =
         NativeBigInt.prototype.notEquals
         =
         SmallInteger.prototype.neq
         =
         SmallInteger.prototype.notEquals
         =
         BigInteger.prototype.neq
         =
         BigInteger.prototype.notEquals;
         BigInteger.prototype.greater
         =
         function(v){return this.compare(v) > 0};
         NativeBigInt.prototype.gt
         =
         NativeBigInt.prototype.greater
         =
         SmallInteger.prototype.gt
         =
         SmallInteger.prototype.greater
         =
         BigInteger.prototype.gt
         =
         BigInteger.prototype.greater;
         BigInteger.prototype.lesser
         =
         function(v){return this.compare(v) < 0};
         NativeBigInt.prototype.lt
         =
         NativeBigInt.prototype.lesser
         =
         SmallInteger.prototype.lt
         =
         SmallInteger.prototype.lesser
         =
         BigInteger.prototype.lt
         =
         BigInteger.prototype.lesser;
         BigInteger.prototype.greaterOrEquals
         =
         function(v){return this.compare(v) >= 0};
         NativeBigInt.prototype.geq
         =
         NativeBigInt.prototype.greaterOrEquals
         =
         SmallInteger.prototype.geq
         =
         SmallInteger.prototype.greaterOrEquals
         =
         BigInteger.prototype.geq
         =
         BigInteger.prototype.greaterOrEquals;
         BigInteger.prototype.lesserOrEquals
         =
         function(v){return this.compare(v) <= 0};
         NativeBigInt.prototype.leq
         =
         NativeBigInt.prototype.lesserOrEquals
         =
         SmallInteger.prototype.leq
         =
         SmallInteger.prototype.lesserOrEquals
         =
         BigInteger.prototype.leq
         =
         BigInteger.prototype.lesserOrEquals;
         BigInteger.prototype.isEven
         =
         function(){return (this.value[0] & 1) === 0};
         SmallInteger.prototype.isEven
         =
         function(){return (this.value & 1) === 0};
         NativeBigInt.prototype.isEven
         =
         function(){return (this.value & BigInt(1)) === BigInt(0)};
         BigInteger.prototype.isOdd
         =
         function(){return (this.value[0] & 1) === 1};
         SmallInteger.prototype.isOdd
         =
         function(){return (this.value & 1) === 1};
         NativeBigInt.prototype.isOdd
         =
         function(){return (this.value & BigInt(1)) === BigInt(1)};
         BigInteger.prototype.isPositive = function(){return ! this.sign};
         SmallInteger.prototype.isPositive
         =
         function(){return this.value > 0};
         NativeBigInt.prototype.isPositive
         =
         SmallInteger.prototype.isPositive;
         BigInteger.prototype.isNegative = function(){return this.sign};
         SmallInteger.prototype.isNegative
         =
         function(){return this.value < 0};
         NativeBigInt.prototype.isNegative
         =
         SmallInteger.prototype.isNegative;
         BigInteger.prototype.isUnit = function(){return false};
         SmallInteger.prototype.isUnit
         =
         function(){return Math.abs(this.value) === 1};
         NativeBigInt.prototype.isUnit
         =
         function(){return this.abs().value === BigInt(1)};
         BigInteger.prototype.isZero = function(){return false};
         SmallInteger.prototype.isZero = function(){return this.value === 0};
         NativeBigInt.prototype.isZero
         =
         function(){return this.value === BigInt(0)};
         BigInteger.prototype.isDivisibleBy
         =
         function(v)
          {var n=parseValue(v);
           if(n.isZero())return false;
           if(n.isUnit())return true;
           if(n.compareAbs(2) === 0)return this.isEven();
           return this.mod(n).isZero()};
         NativeBigInt.prototype.isDivisibleBy
         =
         SmallInteger.prototype.isDivisibleBy
         =
         BigInteger.prototype.isDivisibleBy;
         function isBasicPrime(v)
          {var n=v.abs();
           if(n.isUnit())return false;
           if(n.equals(2) || n.equals(3) || n.equals(5))return true;
           if(n.isEven() || n.isDivisibleBy(3) || n.isDivisibleBy(5))
            return false;
           if(n.lesser(49))return true}
         function millerRabinTest(n,a)
          {var nPrev=n.prev(),b=nPrev,r=0,d,t,i,x;
           while(b.isEven())b = b.divide(2),r++;
           next:
           for(i = 0;i < a.length;i++)
            {if(n.lesser(a[i]))continue;
             x = bigInt(a[i]).modPow(b,n);
             if(x.isUnit() || x.equals(nPrev))continue;
             for(d = r - 1;d != 0;d--)
              {x = x.square().mod(n);
               if(x.isUnit())return false;
               if(x.equals(nPrev))continue next}
             return false}
           return true}
         BigInteger.prototype.isPrime
         =
         function(strict)
          {var isPrime=isBasicPrime(this);
           if(isPrime !== undefined)return isPrime;
           var n=this.abs(),bits=n.bitLength();
           if(bits <= 64)
            return millerRabinTest(n,[2,3,5,7,11,13,17,19,23,29,31,37]);
           var
            logN=Math.log(2) * bits.toJSNumber(),
            t=Math.ceil(strict === true?2 * Math.pow(logN,2):logN);
           for(var a=[],i=0;i < t;i++)a.push(bigInt(i + 2));
           return millerRabinTest(n,a)};
         NativeBigInt.prototype.isPrime
         =
         SmallInteger.prototype.isPrime
         =
         BigInteger.prototype.isPrime;
         BigInteger.prototype.isProbablePrime
         =
         function(iterations)
          {var isPrime=isBasicPrime(this);
           if(isPrime !== undefined)return isPrime;
           var n=this.abs(),t=iterations === undefined?5:iterations;
           for(var a=[],i=0;i < t;i++)
            a.push(bigInt.randBetween(2,n.minus(2)));
           return millerRabinTest(n,a)};
         NativeBigInt.prototype.isProbablePrime
         =
         SmallInteger.prototype.isProbablePrime
         =
         BigInteger.prototype.isProbablePrime;
         BigInteger.prototype.modInv
         =
         function(n)
          {var
            t=bigInt.zero,
            newT=bigInt.one,
            r=parseValue(n),
            newR=this.abs(),
            q,
            lastT,
            lastR;
           while(! newR.isZero())
            {q = r.divide(newR);
             lastT = t;
             lastR = r;
             t = newT;
             r = newR;
             newT = lastT.subtract(q.multiply(newT));
             newR = lastR.subtract(q.multiply(newR))}
           if(! r.isUnit())
            throw new
                   Error
                   (this.toString()
                    +
                    " and "
                    +
                    n.toString()
                    +
                    " are not co-prime");
           if(t.compare(0) === - 1)t = t.add(n);
           if(this.isNegative())return t.negate();
           return t};
         NativeBigInt.prototype.modInv
         =
         SmallInteger.prototype.modInv
         =
         BigInteger.prototype.modInv;
         BigInteger.prototype.next
         =
         function()
          {var value=this.value;
           if(this.sign)return subtractSmall(value,1,this.sign);
           return new BigInteger(addSmall(value,1),this.sign)};
         SmallInteger.prototype.next
         =
         function()
          {var value=this.value;
           if(value + 1 < MAX_INT)return new SmallInteger(value + 1);
           return new BigInteger(MAX_INT_ARR,false)};
         NativeBigInt.prototype.next
         =
         function(){return new NativeBigInt(this.value + BigInt(1))};
         BigInteger.prototype.prev
         =
         function()
          {var value=this.value;
           if(this.sign)return new BigInteger(addSmall(value,1),true);
           return subtractSmall(value,1,this.sign)};
         SmallInteger.prototype.prev
         =
         function()
          {var value=this.value;
           if(value - 1 > - MAX_INT)return new SmallInteger(value - 1);
           return new BigInteger(MAX_INT_ARR,true)};
         NativeBigInt.prototype.prev
         =
         function(){return new NativeBigInt(this.value - BigInt(1))};
         var powersOfTwo=[1];
         while(2 * powersOfTwo[powersOfTwo.length - 1] <= BASE)
          powersOfTwo.push(2 * powersOfTwo[powersOfTwo.length - 1]);
         var
          powers2Length=powersOfTwo.length,
          highestPower2=powersOfTwo[powers2Length - 1];
         function shift_isSmall(n){return Math.abs(n) <= BASE}
         BigInteger.prototype.shiftLeft
         =
         function(v)
          {var n=parseValue(v).toJSNumber();
           if(! shift_isSmall(n))
            throw new Error(String(n) + " is too large for shifting.");
           if(n < 0)return this.shiftRight(- n);
           var result=this;
           if(result.isZero())return result;
           while(n >= powers2Length)
            {result = result.multiply(highestPower2);n -= powers2Length - 1}
           return result.multiply(powersOfTwo[n])};
         NativeBigInt.prototype.shiftLeft
         =
         SmallInteger.prototype.shiftLeft
         =
         BigInteger.prototype.shiftLeft;
         BigInteger.prototype.shiftRight
         =
         function(v)
          {var remQuo,n=parseValue(v).toJSNumber();
           if(! shift_isSmall(n))
            throw new Error(String(n) + " is too large for shifting.");
           if(n < 0)return this.shiftLeft(- n);
           var result=this;
           while(n >= powers2Length)
            {if(result.isZero() || result.isNegative() && result.isUnit())
              return result;
             remQuo = divModAny(result,highestPower2);
             result = remQuo[1].isNegative()?remQuo[0].prev():remQuo[0];
             n -= powers2Length - 1}
           remQuo = divModAny(result,powersOfTwo[n]);
           return remQuo[1].isNegative()?remQuo[0].prev():remQuo[0]};
         NativeBigInt.prototype.shiftRight
         =
         SmallInteger.prototype.shiftRight
         =
         BigInteger.prototype.shiftRight;
         function bitwise(x,y,fn)
          {y = parseValue(y);
           var
            xSign=x.isNegative(),
            ySign=y.isNegative(),
            xRem=xSign?x.not():x,
            yRem=ySign?y.not():y,
            xDigit=0,
            yDigit=0,
            xDivMod=null,
            yDivMod=null,
            result=[];
           while(! xRem.isZero() || ! yRem.isZero())
            {xDivMod = divModAny(xRem,highestPower2);
             xDigit = xDivMod[1].toJSNumber();
             if(xSign)xDigit = highestPower2 - 1 - xDigit;
             yDivMod = divModAny(yRem,highestPower2);
             yDigit = yDivMod[1].toJSNumber();
             if(ySign)yDigit = highestPower2 - 1 - yDigit;
             xRem = xDivMod[0];
             yRem = yDivMod[0];
             result.push(fn(xDigit,yDigit))}
           var sum=fn(xSign?1:0,ySign?1:0) !== 0?bigInt(- 1):bigInt(0);
           for(var i=result.length - 1;i >= 0;i -= 1)
            sum = sum.multiply(highestPower2).add(bigInt(result[i]));
           return sum}
         BigInteger.prototype.not = function(){return this.negate().prev()};
         NativeBigInt.prototype.not
         =
         SmallInteger.prototype.not
         =
         BigInteger.prototype.not;
         BigInteger.prototype.and
         =
         function(n){return bitwise(this,n,function(a,b){return a & b})};
         NativeBigInt.prototype.and
         =
         SmallInteger.prototype.and
         =
         BigInteger.prototype.and;
         BigInteger.prototype.or
         =
         function(n){return bitwise(this,n,function(a,b){return a | b})};
         NativeBigInt.prototype.or
         =
         SmallInteger.prototype.or
         =
         BigInteger.prototype.or;
         BigInteger.prototype.xor
         =
         function(n){return bitwise(this,n,function(a,b){return a ^ b})};
         NativeBigInt.prototype.xor
         =
         SmallInteger.prototype.xor
         =
         BigInteger.prototype.xor;
         var
          LOBMASK_I=1 << 30,
          LOBMASK_BI=(BASE & - BASE) * (BASE & - BASE) | LOBMASK_I;
         function roughLOB(n)
          {var
            v=n.value,
            x=
             typeof v === "number"
              ?v | LOBMASK_I
              :typeof v === "bigint"
                ?v | BigInt(LOBMASK_I)
                :v[0] + v[1] * BASE | LOBMASK_BI;
           return x & - x}
         function integerLogarithm(value,base)
          {if(base.compareTo(value) <= 0)
            {var
              tmp=integerLogarithm(value,base.square(base)),
              p=tmp.p,
              e=tmp.e,
              t=p.multiply(base);
             return t.compareTo(value) <= 0?{p:t,e:e * 2 + 1}:{p:p,e:e * 2}}
           return {p:bigInt(1),e:0}}
         BigInteger.prototype.bitLength
         =
         function()
          {var n=this;
           if(n.compareTo(bigInt(0)) < 0)n = n.negate().subtract(bigInt(1));
           if(n.compareTo(bigInt(0)) === 0)return bigInt(0);
           return bigInt(integerLogarithm(n,bigInt(2)).e).add(bigInt(1))};
         NativeBigInt.prototype.bitLength
         =
         SmallInteger.prototype.bitLength
         =
         BigInteger.prototype.bitLength;
         function max(a,b)
          {a = parseValue(a);b = parseValue(b);return a.greater(b)?a:b}
         function min(a,b)
          {a = parseValue(a);b = parseValue(b);return a.lesser(b)?a:b}
         function gcd(a,b)
          {a = parseValue(a).abs();
           b = parseValue(b).abs();
           if(a.equals(b))return a;
           if(a.isZero())return b;
           if(b.isZero())return a;
           var c=Integer[1],d,t;
           while(a.isEven() && b.isEven())
            {d = min(roughLOB(a),roughLOB(b));
             a = a.divide(d);
             b = b.divide(d);
             c = c.multiply(d)}
           while(a.isEven())a = a.divide(roughLOB(a));
           do
            {while(b.isEven())b = b.divide(roughLOB(b));
             if(a.greater(b)){t = b;b = a;a = t}
             b = b.subtract(a)}
           while
            (! b.isZero());
           return c.isUnit()?a:a.multiply(c)}
         function lcm(a,b)
          {a = parseValue(a).abs();
           b = parseValue(b).abs();
           return a.divide(gcd(a,b)).multiply(b)}
         function randBetween(a,b)
          {a = parseValue(a);
           b = parseValue(b);
           var low=min(a,b),high=max(a,b),range=high.subtract(low).add(1);
           if(range.isSmall)return low.add(Math.floor(Math.random() * range));
           var digits=toBase(range,BASE).value,result=[],restricted=true;
           for(var i=0;i < digits.length;i++)
            {var
              top=restricted?digits[i]:BASE,
              digit=truncate(Math.random() * top);
             result.push(digit);
             if(digit < top)restricted = false}
           return low.add(Integer.fromArray(result,BASE,false))}
         function parseBase(text,base,alphabet,caseSensitive)
          {alphabet = alphabet || DEFAULT_ALPHABET;
           text = String(text);
           if(! caseSensitive)
            {text = text.toLowerCase();alphabet = alphabet.toLowerCase()}
           var length=text.length,i,absBase=Math.abs(base),alphabetValues={};
           for(i = 0;i < alphabet.length;i++)alphabetValues[alphabet[i]] = i;
           for(i = 0;i < length;i++)
            {var c=text[i];
             if(c === "-")continue;
             if(c in alphabetValues)
              if(alphabetValues[c] >= absBase)
               {if(c === "1" && absBase === 1)continue;
                throw new
                       Error
                       (c + " is not a valid digit in base " + base + ".")}}
           base = parseValue(base);
           var digits=[],isNegative=text[0] === "-";
           for(i = isNegative?1:0;i < text.length;i++)
            {var c=text[i];
             if(c in alphabetValues)
              digits.push(parseValue(alphabetValues[c]));
             else
              if(c === "<")
               {var start=i;
                do i++;while(text[i] !== ">" && i < text.length);
                digits.push(parseValue(text.slice(start + 1,i)))}
              else
               throw new Error(c + " is not a valid character")}
           return parseBaseFromArray(digits,base,isNegative)}
         function parseBaseFromArray(digits,base,isNegative)
          {var val=Integer[0],pow=Integer[1],i;
           for(i = digits.length - 1;i >= 0;i--)
            {val = val.add(digits[i].times(pow));pow = pow.times(base)}
           return isNegative?val.negate():val}
         function stringify(digit,alphabet)
          {alphabet = alphabet || DEFAULT_ALPHABET;
           if(digit < alphabet.length)return alphabet[digit];
           return "<" + digit + ">"}
         function toBase(n,base)
          {base = bigInt(base);
           if(base.isZero())
            {if(n.isZero())return {value:[0],isNegative:false};
             throw new Error("Cannot convert nonzero numbers to base 0.")}
           if(base.equals(- 1))
            {if(n.isZero())return {value:[0],isNegative:false};
             if(n.isNegative())
              return {value:
                      [].concat.apply
                       ([],
                        Array.apply(null,Array(- n.toJSNumber())).map
                         (Array.prototype.valueOf,[1,0])),
                      isNegative:false};
             var
              arr=
               Array.apply(null,Array(n.toJSNumber() - 1)).map
                (Array.prototype.valueOf,[0,1]);
             arr.unshift([1]);
             return {value:[].concat.apply([],arr),isNegative:false}}
           var neg=false;
           if(n.isNegative() && base.isPositive()){neg = true;n = n.abs()}
           if(base.isUnit())
            {if(n.isZero())return {value:[0],isNegative:false};
             return {value:
                     Array.apply(null,Array(n.toJSNumber())).map
                      (Number.prototype.valueOf,1),
                     isNegative:neg}}
           var out=[],left=n,divmod;
           while(left.isNegative() || left.compareAbs(base) >= 0)
            {divmod = left.divmod(base);
             left = divmod.quotient;
             var digit=divmod.remainder;
             if(digit.isNegative())
              {digit = base.minus(digit).abs();left = left.next()}
             out.push(digit.toJSNumber())}
           out.push(left.toJSNumber());
           return {value:out.reverse(),isNegative:neg}}
         function toBaseString(n,base,alphabet)
          {var arr=toBase(n,base);
           return (arr.isNegative?"-":"")
                  +
                  arr.value.map(function(x){return stringify(x,alphabet)}).join
                   ("")}
         BigInteger.prototype.toArray
         =
         function(radix){return toBase(this,radix)};
         SmallInteger.prototype.toArray
         =
         function(radix){return toBase(this,radix)};
         NativeBigInt.prototype.toArray
         =
         function(radix){return toBase(this,radix)};
         BigInteger.prototype.toString
         =
         function(radix,alphabet)
          {if(radix === undefined)radix = 10;
           if(radix !== 10)return toBaseString(this,radix,alphabet);
           var
            v=this.value,
            l=v.length,
            str=String(v[--l]),
            zeros="0000000",
            digit;
           while(--l >= 0)
            {digit = String(v[l]);str += zeros.slice(digit.length) + digit}
           var sign=this.sign?"-":"";
           return sign + str};
         SmallInteger.prototype.toString
         =
         function(radix,alphabet)
          {if(radix === undefined)radix = 10;
           if(radix != 10)return toBaseString(this,radix,alphabet);
           return String(this.value)};
         NativeBigInt.prototype.toString = SmallInteger.prototype.toString;
         NativeBigInt.prototype.toJSON
         =
         BigInteger.prototype.toJSON
         =
         SmallInteger.prototype.toJSON
         =
         function(){return this.toString()};
         BigInteger.prototype.valueOf
         =
         function(){return parseInt(this.toString(),10)};
         BigInteger.prototype.toJSNumber = BigInteger.prototype.valueOf;
         SmallInteger.prototype.valueOf = function(){return this.value};
         SmallInteger.prototype.toJSNumber = SmallInteger.prototype.valueOf;
         NativeBigInt.prototype.valueOf
         =
         NativeBigInt.prototype.toJSNumber
         =
         function(){return parseInt(this.toString(),10)};
         function parseStringValue(v)
          {if(isPrecise(+ v))
            {var x=+ v;
             if(x === truncate(x))
              return supportsNativeBigInt
                      ?new NativeBigInt(BigInt(x))
                      :new SmallInteger(x);
             throw new Error("Invalid integer: " + v)}
           var sign=v[0] === "-";
           if(sign)v = v.slice(1);
           var split=v.split(/e/i);
           if(split.length > 2)
            throw new Error("Invalid integer: " + split.join("e"));
           if(split.length === 2)
            {var exp=split[1];
             if(exp[0] === "+")exp = exp.slice(1);
             exp = + exp;
             if(exp !== truncate(exp) || ! isPrecise(exp))
              throw new
                     Error
                     ("Invalid integer: " + exp + " is not a valid exponent.");
             var text=split[0],decimalPlace=text.indexOf(".");
             if(decimalPlace >= 0)
              {exp -= text.length - decimalPlace - 1;
               text
               =
               text.slice(0,decimalPlace)
               +
               text.slice(decimalPlace + 1)}
             if(exp < 0)
              throw new
                     Error
                     ("Cannot include negative exponent part for integers");
             text += new Array(exp + 1).join("0");
             v = text}
           var isValid=/^([0-9][0-9]*)$/.test(v);
           if(! isValid)throw new Error("Invalid integer: " + v);
           if(supportsNativeBigInt)
            return new NativeBigInt(BigInt(sign?"-" + v:v));
           var r=[],max=v.length,l=LOG_BASE,min=max - l;
           while(max > 0)
            {r.push(+ v.slice(min,max));min -= l;if(min < 0)min = 0;max -= l}
           trim(r);
           return new BigInteger(r,sign)}
         function parseNumberValue(v)
          {if(supportsNativeBigInt)return new NativeBigInt(BigInt(v));
           if(isPrecise(v))
            {if(v !== truncate(v))throw new Error(v + " is not an integer.");
             return new SmallInteger(v)}
           return parseStringValue(v.toString())}
         function parseValue(v)
          {if(typeof v === "number")return parseNumberValue(v);
           if(typeof v === "string")return parseStringValue(v);
           if(typeof v === "bigint")return new NativeBigInt(v);
           return v}
         for(var i=0;i < 1000;i++)
          {Integer[i] = parseValue(i);if(i > 0)Integer[- i] = parseValue(- i)}
         Integer.one = Integer[1];
         Integer.zero = Integer[0];
         Integer.minusOne = Integer[- 1];
         Integer.max = max;
         Integer.min = min;
         Integer.gcd = gcd;
         Integer.lcm = lcm;
         Integer.isInstance
         =
         function(x)
          {return x instanceof BigInteger
                  ||
                  x instanceof SmallInteger
                  ||
                  x instanceof NativeBigInt};
         Integer.randBetween = randBetween;
         Integer.fromArray
         =
         function(digits,base,isNegative)
          {return parseBaseFromArray
                   (digits.map(parseValue),parseValue(base || 10),isNegative)};
         return Integer}
       ();
    function ml_z_normalize(x)
     {var y=x.toJSNumber() | 0;if(x.equals(bigInt(y)))return y;return x}
    function ml_z_pow(z1,i1)
     {i1 = bigInt(i1);
      if(i1.lt(bigInt(0)))
       caml_invalid_argument("Z.pow: exponent must be non-negative");
      return ml_z_normalize(bigInt(z1).pow(i1))}
    function ml_z_root(z,i)
     {var zero=bigInt(0),one=bigInt(1);
      z = bigInt(z);
      if(z.equals(zero) || z.equals(one))return ml_z_normalize(z);
      var start=zero,end=z,ans=null,two=bigInt(2);
      while(start.leq(end))
       {var mid=start.add(end).divide(two),po=mid.pow(i);
        if(po.equals(z))
         return ml_z_normalize(mid);
        else
         if(po.lt(z)){start = mid.next();ans = mid}else end = mid.prev()}
      return ml_z_normalize(ans)}
    function caml_int64_of_bytes(a)
     {return new
              MlInt64
              (a[7] << 0 | a[6] << 8 | a[5] << 16,
               a[4] << 0 | a[3] << 8 | a[2] << 16,
               a[1] << 0 | a[0] << 8)}
    function caml_ba_uint8_get64(ba,i0)
     {var ofs=ba.offset(i0);
      if(ofs + 7 >= ba.data.length)caml_array_bound_error();
      var
       b1=ba.get(ofs + 0),
       b2=ba.get(ofs + 1),
       b3=ba.get(ofs + 2),
       b4=ba.get(ofs + 3),
       b5=ba.get(ofs + 4),
       b6=ba.get(ofs + 5),
       b7=ba.get(ofs + 6),
       b8=ba.get(ofs + 7);
      return caml_int64_of_bytes([b8,b7,b6,b5,b4,b3,b2,b1])}
    function caml_int64_to_bytes(x){return x.toArray()}
    function caml_int64_marshal(writer,v,sizes)
     {var b=caml_int64_to_bytes(v);
      for(var i=0;i < 8;i++)writer.write(8,b[i]);
      sizes[0] = 8;
      sizes[1] = 8}
    function caml_ba_num_dims(ba){return ba.dims.length}
    function caml_return_exn_constant(tag){return tag}
    function caml_wrap_exception(e)
     {if(e instanceof Array)return e;
      if
       (joo_global_object.RangeError
        &&
        e instanceof joo_global_object.RangeError
        &&
        e.message
        &&
        e.message.match(/maximum call stack/i))
       return caml_return_exn_constant(caml_global_data.Stack_overflow);
      if
       (joo_global_object.InternalError
        &&
        e instanceof joo_global_object.InternalError
        &&
        e.message
        &&
        e.message.match(/too much recursion/i))
       return caml_return_exn_constant(caml_global_data.Stack_overflow);
      if(e instanceof joo_global_object.Error && caml_named_value("jsError"))
       return [0,caml_named_value("jsError"),e];
      return [0,caml_global_data.Failure,caml_string_of_jsstring(String(e))]}
    function caml_create_file(name,content)
     {var root=resolve_fs_device(name);
      if(! root.device.register)caml_failwith("cannot register file");
      root.device.register(root.rest,content);
      return 0}
    function caml_fs_init()
     {var tmp=joo_global_object.caml_fs_tmp;
      if(tmp)
       for(var i=0;i < tmp.length;i++)
        caml_create_file(tmp[i].name,tmp[i].content);
      joo_global_object.caml_create_file = caml_create_file;
      joo_global_object.caml_fs_tmp = [];
      return 0}
    function caml_mul(a,b){return Math.imul(a,b)}
    function caml_hash_mix_int(h,d)
     {d = caml_mul(d,0xcc9e2d51 | 0);
      d = d << 15 | d >>> 32 - 15;
      d = caml_mul(d,0x1b873593);
      h ^= d;
      h = h << 13 | h >>> 32 - 13;
      return (h + (h << 2) | 0) + (0xe6546b64 | 0) | 0}
    function caml_hash_mix_jsbytes(h,s)
     {var len=s.length,i,w;
      for(i = 0;i + 4 <= len;i += 4)
       {w
        =
        s.charCodeAt(i)
        |
        s.charCodeAt(i + 1)
        <<
        8
        |
        s.charCodeAt(i + 2)
        <<
        16
        |
        s.charCodeAt(i + 3)
        <<
        24;
        h = caml_hash_mix_int(h,w)}
      w = 0;
      switch(len & 3)
       {case 3:w = s.charCodeAt(i + 2) << 16;
        case 2:w |= s.charCodeAt(i + 1) << 8;
        case 1:w |= s.charCodeAt(i);h = caml_hash_mix_int(h,w)
        }
      h ^= len;
      return h}
    function caml_hash_mix_string(h,v)
     {return caml_hash_mix_jsbytes(h,caml_jsbytes_of_string(v))}
    var Base_internalhash_fold_string=caml_hash_mix_string;
    function caml_set_parser_trace(){return 0}
    function caml_list_of_js_array(a)
     {var l=0;
      for(var i=a.length - 1;i >= 0;i--){var e=a[i];l = [0,e,l]}
      return l}
    function unix_gettimeofday(){return new Date().getTime() / 1000}
    function num_digits_nat(nat,ofs,len)
     {for(var i=len - 1;i >= 0;i--)if(nat.data[ofs + i] != 0)return i + 1;
      return 1}
    function caml_hash_nat(x)
     {var len=num_digits_nat(x,0,x.data.length),h=0;
      for(var i=0;i < len;i++)h = caml_hash_mix_int(h,x.data[i]);
      return h}
    function caml_call_gen(f,args)
     {if(f.fun)return caml_call_gen(f.fun,args);
      if(typeof f !== "function")return f;
      var n=f.length | 0;
      if(n === 0)return f.apply(null,args);
      var argsLen=args.length | 0,d=n - argsLen | 0;
      if(d == 0)
       return f.apply(null,args);
      else
       if(d < 0)
        return caml_call_gen(f.apply(null,args.slice(0,n)),args.slice(n));
       else
        return function()
         {var
           extra_args=arguments.length == 0?1:arguments.length,
           nargs=new Array(args.length + extra_args);
          for(var i=0;i < args.length;i++)nargs[i] = args[i];
          for(var i=0;i < arguments.length;i++)
           nargs[args.length + i] = arguments[i];
          return caml_call_gen(f,nargs)}}
    function caml_js_wrap_callback_arguments(f)
     {return function()
       {var len=arguments.length,args=new Array(len);
        for(var i=0;i < len;i++)args[i] = arguments[i];
        return caml_call_gen(f,[args])}}
    function caml_sys_chdir(dir)
     {var root=resolve_fs_device(dir);
      if(root.device.exists(root.rest))
       {if(root.rest)
         caml_current_dir = root.path + root.rest + "/";
        else
         caml_current_dir = root.path;
        return 0}
      else
       caml_raise_no_such_file(dir)}
    function caml_gc_counters(){return [254,0,0,0]}
    function ml_z_div(z1,z2)
     {z2 = bigInt(z2);
      if(z2.equals(bigInt(0)))caml_raise_zero_divide();
      return ml_z_normalize(bigInt(z1).divide(bigInt(z2)))}
    function ml_z_sign(z1){return bigInt(z1).compare(bigInt.zero)}
    function ml_z_add(z1,z2)
     {return ml_z_normalize(bigInt(z1).add(bigInt(z2)))}
    function ml_z_cdiv(z1,z2)
     {var z1_pos=ml_z_sign(z1),z2_pos=ml_z_sign(z2);
      if(z1_pos * z2_pos > 0)
       if(! bigInt(z1).mod(bigInt(z2)).equals(bigInt(0)))
        return ml_z_add(ml_z_div(z1,z2),bigInt(1));
      return ml_z_div(z1,z2)}
    function caml_gr_synchronize()
     {caml_failwith("caml_gr_synchronize not Implemented")}
    var log2_ok=Math.log2 && Math.log2(1.1235582092889474E+307) == 1020;
    function jsoo_floor_log2(x)
     {if(log2_ok)return Math.floor(Math.log2(x));
      var i=0;
      if(x == 0)return - Infinity;
      if(x >= 1)while(x >= 2){x /= 2;i++}else while(x < 1){x *= 2;i--}
      return i}
    function caml_int32_bits_of_float(x)
     {var float32a=new (joo_global_object.Float32Array)(1);
      float32a[0] = x;
      var int32a=new (joo_global_object.Int32Array)(float32a.buffer);
      return int32a[0] | 0}
    function caml_int64_create_lo_mi_hi(lo,mi,hi)
     {return new MlInt64(lo,mi,hi)}
    function caml_int64_bits_of_float(x)
     {if(! isFinite(x))
       {if(isNaN(x))return caml_int64_create_lo_mi_hi(1,0,0x7ff0);
        return x > 0
                ?caml_int64_create_lo_mi_hi(0,0,0x7ff0)
                :caml_int64_create_lo_mi_hi(0,0,0xfff0)}
      var sign=x == 0 && 1 / x == - Infinity?0x8000:x >= 0?0:0x8000;
      if(sign)x = - x;
      var exp=jsoo_floor_log2(x) + 1023;
      if(exp <= 0)
       {exp = 0;x /= Math.pow(2,- 1026)}
      else
       {x /= Math.pow(2,exp - 1027);
        if(x < 16){x *= 2;exp -= 1}
        if(exp == 0)x /= 2}
      var k=Math.pow(2,24),r3=x | 0;
      x = (x - r3) * k;
      var r2=x | 0;
      x = (x - r2) * k;
      var r1=x | 0;
      r3 = r3 & 0xf | sign | exp << 4;
      return caml_int64_create_lo_mi_hi(r1,r2,r3)}
    function caml_ba_serialize(writer,ba,sz)
     {writer.write(32,ba.dims.length);
      writer.write(32,ba.kind | ba.layout << 8);
      for(var i=0;i < ba.dims.length;i++)writer.write(32,ba.dims[i]);
      switch(ba.kind)
       {case 2:
        case 3:
        case 12:
         for(var i=0;i < ba.data.length;i++)writer.write(8,ba.data[i]);break;
        case 4:
        case 5:
         for(var i=0;i < ba.data.length;i++)writer.write(16,ba.data[i]);break;
        case 6:
         for(var i=0;i < ba.data.length;i++)writer.write(32,ba.data[i]);break;
        case 8:
        case 9:
         writer.write(8,0);
         for(var i=0;i < ba.data.length;i++)writer.write(32,ba.data[i]);
         break;
        case 7:
         for(var i=0;i < ba.data.length / 2;i++)
          {var b=caml_int64_to_bytes(ba.get(i));
           for(var j=0;j < 8;j++)writer.write(8,b[j])}
         break;
        case 1:
         for(var i=0;i < ba.data.length;i++)
          {var b=caml_int64_to_bytes(caml_int64_bits_of_float(ba.get(i)));
           for(var j=0;j < 8;j++)writer.write(8,b[j])}
         break;
        case 0:
         for(var i=0;i < ba.data.length;i++)
          {var b=caml_int32_bits_of_float(ba.get(i));writer.write(32,b)}
         break;
        case 10:
         for(var i=0;i < ba.data.length / 2;i++)
          {var j=ba.get(i);
           writer.write(32,caml_int32_bits_of_float(j[1]));
           writer.write(32,caml_int32_bits_of_float(j[2]))}
         break;
        case 11:
         for(var i=0;i < ba.data.length / 2;i++)
          {var
            complex=ba.get(i),
            b=caml_int64_to_bytes(caml_int64_bits_of_float(complex[1]));
           for(var j=0;j < 8;j++)writer.write(8,b[j]);
           var b=caml_int64_to_bytes(caml_int64_bits_of_float(complex[2]));
           for(var j=0;j < 8;j++)writer.write(8,b[j])}
         break
        }
      sz[0] = (4 + ba.dims.length) * 4;
      sz[1] = (4 + ba.dims.length) * 8}
    function caml_ba_get_size_per_element(kind)
     {switch(kind){case 7:case 10:case 11:return 2;default:return 1}}
    function caml_ba_create_buffer(kind,size)
     {var g=joo_global_object,view;
      switch(kind)
       {case 0:view = g.Float32Array;break;
        case 1:view = g.Float64Array;break;
        case 2:view = g.Int8Array;break;
        case 3:view = g.Uint8Array;break;
        case 4:view = g.Int16Array;break;
        case 5:view = g.Uint16Array;break;
        case 6:view = g.Int32Array;break;
        case 7:view = g.Int32Array;break;
        case 8:view = g.Int32Array;break;
        case 9:view = g.Int32Array;break;
        case 10:view = g.Float32Array;break;
        case 11:view = g.Float64Array;break;
        case 12:view = g.Uint8Array;break
        }
      if(! view)caml_invalid_argument("Bigarray.create: unsupported kind");
      var data=new view(size * caml_ba_get_size_per_element(kind));
      return data}
    function caml_int32_float_of_bits(x)
     {var int32a=new (joo_global_object.Int32Array)(1);
      int32a[0] = x;
      var float32a=new (joo_global_object.Float32Array)(int32a.buffer);
      return float32a[0]}
    function caml_int64_float_of_bits(x)
     {var lo=x.lo,mi=x.mi,hi=x.hi,exp=(hi & 0x7fff) >> 4;
      if(exp == 2047)
       return (lo | mi | hi & 0xf) == 0?hi & 0x8000?- Infinity:Infinity:NaN;
      var k=Math.pow(2,- 24),res=(lo * k + mi) * k + (hi & 0xf);
      if(exp > 0)
       {res += 16;res *= Math.pow(2,exp - 1027)}
      else
       res *= Math.pow(2,- 1026);
      if(hi & 0x8000)res = - res;
      return res}
    function caml_ba_get_size(dims)
     {var n_dims=dims.length,size=1;
      for(var i=0;i < n_dims;i++)
       {if(dims[i] < 0)
         caml_invalid_argument("Bigarray.create: negative dimension");
        size = size * dims[i]}
      return size}
    function caml_int64_create_lo_hi(lo,hi)
     {return new
              MlInt64
              (lo & 0xffffff,
               lo >>> 24 & 0xff | (hi & 0xffff) << 8,
               hi >>> 16 & 0xffff)}
    function caml_int64_hi32(v){return v.hi32()}
    function caml_int64_lo32(v){return v.lo32()}
    function Ml_Bigarray(kind,layout,dims,buffer)
     {this.kind = kind;
      this.layout = layout;
      this.dims = dims;
      this.data = buffer}
    Ml_Bigarray.prototype.caml_custom = "_bigarray";
    Ml_Bigarray.prototype.offset
    =
    function(arg)
     {var ofs=0;
      if(typeof arg === "number")arg = [arg];
      if(! (arg instanceof Array))
       caml_invalid_argument("bigarray.js: invalid offset");
      if(this.dims.length != arg.length)
       caml_invalid_argument("Bigarray.get/set: bad number of dimensions");
      if(this.layout == 0)
       for(var i=0;i < this.dims.length;i++)
        {if(arg[i] < 0 || arg[i] >= this.dims[i])caml_array_bound_error();
         ofs = ofs * this.dims[i] + arg[i]}
      else
       for(var i=this.dims.length - 1;i >= 0;i--)
        {if(arg[i] < 1 || arg[i] > this.dims[i])caml_array_bound_error();
         ofs = ofs * this.dims[i] + (arg[i] - 1)}
      return ofs};
    Ml_Bigarray.prototype.get
    =
    function(ofs)
     {switch(this.kind)
       {case 7:
         var l=this.data[ofs * 2 + 0],h=this.data[ofs * 2 + 1];
         return caml_int64_create_lo_hi(l,h);
        case 10:
        case 11:
         var r=this.data[ofs * 2 + 0],i=this.data[ofs * 2 + 1];
         return [254,r,i];
        default:return this.data[ofs]}};
    Ml_Bigarray.prototype.set
    =
    function(ofs,v)
     {switch(this.kind)
       {case 7:
         this.data[ofs * 2 + 0] = caml_int64_lo32(v);
         this.data[ofs * 2 + 1] = caml_int64_hi32(v);
         break;
        case 10:
        case 11:
         this.data[ofs * 2 + 0] = v[1];this.data[ofs * 2 + 1] = v[2];break;
        default:this.data[ofs] = v;break}
      return 0};
    Ml_Bigarray.prototype.fill
    =
    function(v)
     {switch(this.kind)
       {case 7:
         var a=caml_int64_lo32(v),b=caml_int64_hi32(v);
         if(a == b)
          this.data.fill(a);
         else
          for(var i=0;i < this.data.length;i++)this.data[i] = i % 2 == 0?a:b;
         break;
        case 10:
        case 11:
         var im=v[1],re=v[2];
         if(im == re)
          this.data.fill(im);
         else
          for(var i=0;i < this.data.length;i++)
           this.data[i] = i % 2 == 0?im:re;
         break;
        default:this.data.fill(v);break}};
    Ml_Bigarray.prototype.compare
    =
    function(b,total)
     {if(this.layout != b.layout || this.kind != b.kind)
       {var k1=this.kind | this.layout << 8,k2=b.kind | b.layout << 8;
        return k2 - k1}
      if(this.dims.length != b.dims.length)
       return b.dims.length - this.dims.length;
      for(var i=0;i < this.dims.length;i++)
       if(this.dims[i] != b.dims[i])return this.dims[i] < b.dims[i]?- 1:1;
      switch(this.kind)
       {case 0:
        case 1:
        case 10:
        case 11:
         var x,y;
         for(var i=0;i < this.data.length;i++)
          {x = this.data[i];
           y = b.data[i];
           if(x < y)return - 1;
           if(x > y)return 1;
           if(x != y)
            {if(! total)return NaN;if(x == x)return 1;if(y == y)return - 1}}
         break;
        case 7:
         for(var i=0;i < this.data.length;i += 2)
          {if(this.data[i + 1] < b.data[i + 1])return - 1;
           if(this.data[i + 1] > b.data[i + 1])return 1;
           if(this.data[i] >>> 0 < b.data[i] >>> 0)return - 1;
           if(this.data[i] >>> 0 > b.data[i] >>> 0)return 1}
         break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 8:
        case 9:
        case 12:
         for(var i=0;i < this.data.length;i++)
          {if(this.data[i] < b.data[i])return - 1;
           if(this.data[i] > b.data[i])return 1}
         break
        }
      return 0};
    function Ml_Bigarray_c_1_1(kind,layout,dims,buffer)
     {this.kind = kind;
      this.layout = layout;
      this.dims = dims;
      this.data = buffer}
    Ml_Bigarray_c_1_1.prototype = new Ml_Bigarray();
    Ml_Bigarray_c_1_1.prototype.offset
    =
    function(arg)
     {if(typeof arg !== "number")
       if(arg instanceof Array && arg.length == 1)
        arg = arg[0];
       else
        caml_invalid_argument("Ml_Bigarray_c_1_1.offset");
      if(arg < 0 || arg >= this.dims[0])caml_array_bound_error();
      return arg};
    Ml_Bigarray_c_1_1.prototype.get = function(ofs){return this.data[ofs]};
    Ml_Bigarray_c_1_1.prototype.set
    =
    function(ofs,v){this.data[ofs] = v;return 0};
    Ml_Bigarray_c_1_1.prototype.fill
    =
    function(v){this.data.fill(v);return 0};
    function caml_ba_create_unsafe(kind,layout,dims,data)
     {var size_per_element=caml_ba_get_size_per_element(kind);
      if(caml_ba_get_size(dims) * size_per_element != data.length)
       caml_invalid_argument("length doesn't match dims");
      if(layout == 0 && dims.length == 1 && size_per_element == 1)
       return new Ml_Bigarray_c_1_1(kind,layout,dims,data);
      return new Ml_Bigarray(kind,layout,dims,data)}
    function caml_ba_deserialize(reader,sz)
     {var num_dims=reader.read32s();
      if(num_dims < 0 || num_dims > 16)
       caml_failwith("input_value: wrong number of bigarray dimensions");
      var tag=reader.read32s(),kind=tag & 0xff,layout=tag >> 8 & 1,dims=[];
      for(var i=0;i < num_dims;i++)dims.push(reader.read32u());
      var
       size=caml_ba_get_size(dims),
       data=caml_ba_create_buffer(kind,size),
       ba=caml_ba_create_unsafe(kind,layout,dims,data);
      switch(kind)
       {case 2:for(var i=0;i < size;i++)data[i] = reader.read8s();break;
        case 3:
        case 12:for(var i=0;i < size;i++)data[i] = reader.read8u();break;
        case 4:for(var i=0;i < size;i++)data[i] = reader.read16s();break;
        case 5:for(var i=0;i < size;i++)data[i] = reader.read16u();break;
        case 6:for(var i=0;i < size;i++)data[i] = reader.read32s();break;
        case 8:
        case 9:
         var sixty=reader.read8u();
         if(sixty)
          caml_failwith
           ("input_value: cannot read bigarray with 64-bit OCaml ints");
         for(var i=0;i < size;i++)data[i] = reader.read32s();
         break;
        case 7:
         var t=new Array(8);
         for(var i=0;i < size;i++)
          {for(var j=0;j < 8;j++)t[j] = reader.read8u();
           var int64=caml_int64_of_bytes(t);
           ba.set(i,int64)}
         break;
        case 1:
         var t=new Array(8);
         for(var i=0;i < size;i++)
          {for(var j=0;j < 8;j++)t[j] = reader.read8u();
           var f=caml_int64_float_of_bits(caml_int64_of_bytes(t));
           ba.set(i,f)}
         break;
        case 0:
         for(var i=0;i < size;i++)
          {var f=caml_int32_float_of_bits(reader.read32s());ba.set(i,f)}
         break;
        case 10:
         for(var i=0;i < size;i++)
          {var
            re=caml_int32_float_of_bits(reader.read32s()),
            im=caml_int32_float_of_bits(reader.read32s());
           ba.set(i,[254,re,im])}
         break;
        case 11:
         var t=new Array(8);
         for(var i=0;i < size;i++)
          {for(var j=0;j < 8;j++)t[j] = reader.read8u();
           var re=caml_int64_float_of_bits(caml_int64_of_bytes(t));
           for(var j=0;j < 8;j++)t[j] = reader.read8u();
           var im=caml_int64_float_of_bits(caml_int64_of_bytes(t));
           ba.set(i,[254,re,im])}
         break
        }
      sz[0] = (4 + num_dims) * 4;
      return caml_ba_create_unsafe(kind,layout,dims,data)}
    function caml_ba_compare(a,b,total){return a.compare(b,total)}
    function caml_hash_mix_int64(h,v)
     {h = caml_hash_mix_int(h,caml_int64_lo32(v));
      h = caml_hash_mix_int(h,caml_int64_hi32(v));
      return h}
    function caml_hash_mix_float(h,v0)
     {return caml_hash_mix_int64(h,caml_int64_bits_of_float(v0))}
    function caml_ba_hash(ba)
     {var num_elts=caml_ba_get_size(ba.dims),h=0;
      switch(ba.kind)
       {case 2:
        case 3:
        case 12:
         if(num_elts > 256)num_elts = 256;
         var w=0,i=0;
         for(i = 0;i + 4 <= ba.data.length;i += 4)
          {w
           =
           ba.data[i + 0]
           |
           ba.data[i + 1]
           <<
           8
           |
           ba.data[i + 2]
           <<
           16
           |
           ba.data[i + 3]
           <<
           24;
           h = caml_hash_mix_int(h,w)}
         w = 0;
         switch(num_elts & 3)
          {case 3:w = ba.data[i + 2] << 16;
           case 2:w |= ba.data[i + 1] << 8;
           case 1:w |= ba.data[i + 0];h = caml_hash_mix_int(h,w)
           }
         break;
        case 4:
        case 5:
         if(num_elts > 128)num_elts = 128;
         var w=0,i=0;
         for(i = 0;i + 2 <= ba.data.length;i += 2)
          {w = ba.data[i + 0] | ba.data[i + 1] << 16;
           h = caml_hash_mix_int(h,w)}
         if((num_elts & 1) != 0)h = caml_hash_mix_int(h,ba.data[i]);
         break;
        case 6:
         if(num_elts > 64)num_elts = 64;
         for(var i=0;i < num_elts;i++)h = caml_hash_mix_int(h,ba.data[i]);
         break;
        case 8:
        case 9:
         if(num_elts > 64)num_elts = 64;
         for(var i=0;i < num_elts;i++)h = caml_hash_mix_int(h,ba.data[i]);
         break;
        case 7:
         if(num_elts > 32)num_elts = 32;
         num_elts *= 2;
         for(var i=0;i < num_elts;i++)h = caml_hash_mix_int(h,ba.data[i]);
         break;
        case 10:num_elts *= 2;
        case 0:
         if(num_elts > 64)num_elts = 64;
         for(var i=0;i < num_elts;i++)h = caml_hash_mix_float(h,ba.data[i]);
         break;
        case 11:num_elts *= 2;
        case 1:
         if(num_elts > 32)num_elts = 32;
         for(var i=0;i < num_elts;i++)h = caml_hash_mix_float(h,ba.data[i]);
         break
        }
      return h}
    function caml_int32_unmarshal(reader,size)
     {size[0] = 4;return reader.read32s()}
    function caml_nativeint_unmarshal(reader,size)
     {switch(reader.read8u())
       {case 1:size[0] = 4;return reader.read32s();
        case 2:caml_failwith("input_value: native integer value too large");
        default:caml_failwith("input_value: ill-formed native integer")}}
    function caml_int64_unmarshal(reader,size)
     {var t=new Array(8);
      for(var j=0;j < 8;j++)t[j] = reader.read8u();
      size[0] = 8;
      return caml_int64_of_bytes(t)}
    function caml_int64_compare(x,y,total){return x.compare(y)}
    function caml_int64_hash(v){return v.lo32() ^ v.hi32()}
    var
     caml_custom_ops=
      {"_j":
       {deserialize:caml_int64_unmarshal,
        serialize:caml_int64_marshal,
        fixed_length:8,
        compare:caml_int64_compare,
        hash:caml_int64_hash},
       "_i":{deserialize:caml_int32_unmarshal,fixed_length:4},
       "_n":{deserialize:caml_nativeint_unmarshal,fixed_length:4},
       "_bigarray":
       {deserialize:caml_ba_deserialize,
        serialize:caml_ba_serialize,
        compare:caml_ba_compare,
        hash:caml_ba_hash}};
    function caml_compare_val_get_custom(a)
     {return caml_custom_ops[a.caml_custom]
             &&
             caml_custom_ops[a.caml_custom].compare}
    function caml_compare_val_number_custom(num,custom,swap,total)
     {var comp=caml_compare_val_get_custom(custom);
      if(comp)
       {var x=swap > 0?comp(custom,num,total):comp(num,custom,total);
        if(total && x != x)return swap;
        if(+ x != + x)return + x;
        if((x | 0) != 0)return x | 0}
      return swap}
    function caml_compare_val_tag(a)
     {if(typeof a === "number")
       return 1000;
      else
       if(caml_is_ml_bytes(a))
        return 252;
       else
        if(caml_is_ml_string(a))
         return 1252;
        else
         if(a instanceof Array && a[0] === a[0] >>> 0 && a[0] <= 255)
          {var tag=a[0] | 0;return tag == 254?0:tag}
         else
          if(a instanceof String)
           return 12520;
          else
           if(typeof a == "string")
            return 12520;
           else
            if(a instanceof Number)
             return 1000;
            else
             if(a && a.caml_custom)
              return 1255;
             else
              if(a && a.compare)
               return 1256;
              else
               if(typeof a == "function")
                return 1247;
               else
                if(typeof a == "symbol")return 1251;
      return 1001}
    function caml_int_compare(a,b)
     {if(a < b)return - 1;if(a == b)return 0;return 1}
    function caml_bytes_compare(s1,s2)
     {s1.t & 6 && caml_convert_string_to_bytes(s1);
      s2.t & 6 && caml_convert_string_to_bytes(s2);
      return s1.c < s2.c?- 1:s1.c > s2.c?1:0}
    function caml_string_compare(s1,s2){return caml_bytes_compare(s1,s2)}
    function caml_compare_val(a,b,total)
     {var stack=[];
      for(;;)
       {if(! (total && a === b))
         {var tag_a=caml_compare_val_tag(a);
          if(tag_a == 250){a = a[1];continue}
          var tag_b=caml_compare_val_tag(b);
          if(tag_b == 250){b = b[1];continue}
          if(tag_a !== tag_b)
           {if(tag_a == 1000)
             {if(tag_b == 1255)
               return caml_compare_val_number_custom(a,b,- 1,total);
              return - 1}
            if(tag_b == 1000)
             {if(tag_a == 1255)
               return caml_compare_val_number_custom(b,a,1,total);
              return 1}
            return tag_a < tag_b?- 1:1}
          switch(tag_a)
           {case 247:caml_invalid_argument("compare: functional value");break;
            case 248:
             var x=caml_int_compare(a[2],b[2]);if(x != 0)return x | 0;break;
            case 249:caml_invalid_argument("compare: functional value");break;
            case 250:
             caml_invalid_argument
              ("equal: got Forward_tag, should not happen");
             break;
            case 251:caml_invalid_argument("equal: abstract value");break;
            case 252:
             if(a !== b){var x=caml_bytes_compare(a,b);if(x != 0)return x | 0}
             break;
            case 253:
             caml_invalid_argument("equal: got Double_tag, should not happen");
             break;
            case 254:
             caml_invalid_argument
              ("equal: got Double_array_tag, should not happen");
             break;
            case 255:
             caml_invalid_argument("equal: got Custom_tag, should not happen");
             break;
            case 1247:
             caml_invalid_argument("compare: functional value");break;
            case 1255:
             var comp=caml_compare_val_get_custom(a);
             if(comp != caml_compare_val_get_custom(b))
              return a.caml_custom < b.caml_custom?- 1:1;
             if(! comp)caml_invalid_argument("compare: abstract value");
             var x=comp(a,b,total);
             if(x != x)return total?- 1:x;
             if(x !== (x | 0))return - 1;
             if(x != 0)return x | 0;
             break;
            case 1256:
             var x=a.compare(b,total);
             if(x != x)return total?- 1:x;
             if(x !== (x | 0))return - 1;
             if(x != 0)return x | 0;
             break;
            case 1000:
             a = + a;
             b = + b;
             if(a < b)return - 1;
             if(a > b)return 1;
             if(a != b)
              {if(! total)return NaN;if(a == a)return 1;if(b == b)return - 1}
             break;
            case 1001:
             if(a < b)return - 1;
             if(a > b)return 1;
             if(a != b)
              {if(! total)return NaN;if(a == a)return 1;if(b == b)return - 1}
             break;
            case 1251:if(a !== b){if(! total)return NaN;return 1}break;
            case 1252:
             var a=caml_jsbytes_of_string(a),b=caml_jsbytes_of_string(b);
             if(a !== b){if(a < b)return - 1;if(a > b)return 1}
             break;
            case 12520:
             var a=a.toString(),b=b.toString();
             if(a !== b){if(a < b)return - 1;if(a > b)return 1}
             break;
            case 246:
            case 254:
            default:
             if(a.length != b.length)return a.length < b.length?- 1:1;
             if(a.length > 1)stack.push(a,b,1);
             break}}
        if(stack.length == 0)return 0;
        var i=stack.pop();
        b = stack.pop();
        a = stack.pop();
        if(i + 1 < a.length)stack.push(a,b,i + 1);
        a = a[i];
        b = b[i]}}
    function caml_greaterthan(x,y){return + (caml_compare_val(x,y,false) > 0)}
    function div_helper(a,b,c)
     {var
       x=a * 65536 + (b >>> 16),
       y=Math.floor(x / c) * 65536,
       z=x % c * 65536,
       w=z + (b & 0x0000FFFF);
      return [y + Math.floor(w / c),w % c]}
    function div_digit_nat(natq,ofsq,natr,ofsr,nat1,ofs1,len,nat2,ofs2)
     {var rem=nat1.data[ofs1 + len - 1] >>> 0;
      for(var i=len - 2;i >= 0;i--)
       {var x=div_helper(rem,nat1.data[ofs1 + i] >>> 0,nat2.data[ofs2] >>> 0);
        natq.data[ofsq + i] = x[0];
        rem = x[1]}
      natr.data[ofsr] = rem;
      return 0}
    function num_leading_zero_bits_in_digit(nat,ofs)
     {var a=nat.data[ofs],b=0;
      if(a & 0xFFFF0000){b += 16;a >>>= 16}
      if(a & 0xFF00){b += 8;a >>>= 8}
      if(a & 0xF0){b += 4;a >>>= 4}
      if(a & 12){b += 2;a >>>= 2}
      if(a & 2){b += 1;a >>>= 1}
      if(a & 1)b += 1;
      return 32 - b}
    function shift_left_nat(nat1,ofs1,len1,nat2,ofs2,nbits)
     {if(nbits == 0){nat2.data[ofs2] = 0;return 0}
      var wrap=0;
      for(var i=0;i < len1;i++)
       {var a=nat1.data[ofs1 + i] >>> 0;
        nat1.data[ofs1 + i] = a << nbits | wrap;
        wrap = a >>> 32 - nbits}
      nat2.data[ofs2] = wrap;
      return 0}
    function MlNat(x)
     {this.data = new (joo_global_object.Int32Array)(x);
      this.length = this.data.length + 2}
    MlNat.prototype.caml_custom = "_nat";
    function create_nat(size)
     {var arr=new MlNat(size);
      for(var i=0;i < size;i++)arr.data[i] = - 1;
      return arr}
    function set_to_zero_nat(nat,ofs,len)
     {for(var i=0;i < len;i++)nat.data[ofs + i] = 0;return 0}
    function incr_nat(nat,ofs,len,carry_in)
     {var carry=carry_in;
      for(var i=0;i < len;i++)
       {var x=(nat.data[ofs + i] >>> 0) + carry;
        nat.data[ofs + i] = x | 0;
        if(x == x >>> 0){carry = 0;break}else carry = 1}
      return carry}
    function add_nat(nat1,ofs1,len1,nat2,ofs2,len2,carry_in)
     {var carry=carry_in;
      for(var i=0;i < len2;i++)
       {var
         x=
          (nat1.data[ofs1 + i] >>> 0) + (nat2.data[ofs2 + i] >>> 0) + carry;
        nat1.data[ofs1 + i] = x;
        if(x == x >>> 0)carry = 0;else carry = 1}
      return incr_nat(nat1,ofs1 + len2,len1 - len2,carry)}
    function nat_of_array(l){return new MlNat(l)}
    function mult_digit_nat(nat1,ofs1,len1,nat2,ofs2,len2,nat3,ofs3)
     {var carry=0,a=nat3.data[ofs3] >>> 0;
      for(var i=0;i < len2;i++)
       {var
         x1=
          (nat1.data[ofs1 + i] >>> 0)
          +
          (nat2.data[ofs2 + i] >>> 0)
          *
          (a & 0x0000FFFF)
          +
          carry,
         x2=(nat2.data[ofs2 + i] >>> 0) * (a >>> 16);
        carry = Math.floor(x2 / 65536);
        var x3=x1 + x2 % 65536 * 65536;
        nat1.data[ofs1 + i] = x3;
        carry += Math.floor(x3 / 4294967296)}
      return len2 < len1 && carry
              ?add_nat
                (nat1,ofs1 + len2,len1 - len2,nat_of_array([carry]),0,1,0)
              :carry}
    function decr_nat(nat,ofs,len,carry_in)
     {var borrow=carry_in == 1?0:1;
      for(var i=0;i < len;i++)
       {var x=(nat.data[ofs + i] >>> 0) - borrow;
        nat.data[ofs + i] = x;
        if(x >= 0){borrow = 0;break}else borrow = 1}
      return borrow == 1?0:1}
    function sub_nat(nat1,ofs1,len1,nat2,ofs2,len2,carry_in)
     {var borrow=carry_in == 1?0:1;
      for(var i=0;i < len2;i++)
       {var
         x=
          (nat1.data[ofs1 + i] >>> 0) - (nat2.data[ofs2 + i] >>> 0) - borrow;
        nat1.data[ofs1 + i] = x;
        if(x >= 0)borrow = 0;else borrow = 1}
      return decr_nat(nat1,ofs1 + len2,len1 - len2,borrow == 1?0:1)}
    function compare_nat(nat1,ofs1,len1,nat2,ofs2,len2)
     {var a=num_digits_nat(nat1,ofs1,len1),b=num_digits_nat(nat2,ofs2,len2);
      if(a > b)return 1;
      if(a < b)return - 1;
      for(var i=len1 - 1;i >= 0;i--)
       {if(nat1.data[ofs1 + i] >>> 0 > nat2.data[ofs2 + i] >>> 0)return 1;
        if(nat1.data[ofs1 + i] >>> 0 < nat2.data[ofs2 + i] >>> 0)return - 1}
      return 0}
    function div_nat(nat1,ofs1,len1,nat2,ofs2,len2)
     {if(len2 == 1)
       {div_digit_nat(nat1,ofs1 + 1,nat1,ofs1,nat1,ofs1,len1,nat2,ofs2);
        return 0}
      var s=num_leading_zero_bits_in_digit(nat2,ofs2 + len2 - 1);
      shift_left_nat(nat2,ofs2,len2,nat_of_array([0]),0,s);
      shift_left_nat(nat1,ofs1,len1,nat_of_array([0]),0,s);
      var d=(nat2.data[ofs2 + len2 - 1] >>> 0) + 1,a=create_nat(len2 + 1);
      for(var i=len1 - 1;i >= len2;i--)
       {var
         quo=
          d == 4294967296
           ?nat1.data[ofs1 + i] >>> 0
           :div_helper
              (nat1.data[ofs1 + i] >>> 0,nat1.data[ofs1 + i - 1] >>> 0,d)
             [0];
        set_to_zero_nat(a,0,len2 + 1);
        mult_digit_nat(a,0,len2 + 1,nat2,ofs2,len2,nat_of_array([quo]),0);
        sub_nat(nat1,ofs1 + i - len2,len2 + 1,a,0,len2 + 1,1);
        while
         (nat1.data[ofs1 + i]
          !=
          0
          ||
          compare_nat(nat1,ofs1 + i - len2,len2,nat2,ofs2,len2)
          >=
          0)
         {quo = quo + 1;
          sub_nat(nat1,ofs1 + i - len2,len2 + 1,nat2,ofs2,len2,1)}
        nat1.data[ofs1 + i] = quo}
      shift_right_nat(nat1,ofs1,len2,nat_of_array([0]),0,s);
      shift_right_nat(nat2,ofs2,len2,nat_of_array([0]),0,s);
      return 0}
    function caml_ba_blit(src,dst)
     {if(dst.dims.length != src.dims.length)
       caml_invalid_argument("Bigarray.blit: dimension mismatch");
      for(var i=0;i < dst.dims.length;i++)
       if(dst.dims[i] != src.dims[i])
        caml_invalid_argument("Bigarray.blit: dimension mismatch");
      dst.data.set(src.data);
      return 0}
    function is_digit_int(nat,ofs){if(nat.data[ofs] >= 0)return 1;return 0}
    function caml_int64_div(x,y){return x.div(y)}
    function caml_js_html_entities(s)
     {var entity=/^&#?[0-9a-zA-Z]+;$/;
      if(s.match(entity))
       {var str,temp=document.createElement("p");
        temp.innerHTML = s;
        str = temp.textContent || temp.innerText;
        temp = null;
        return str}
      else
       caml_failwith("Invalid entity " + s)}
    function caml_string_unsafe_set(s,i,c)
     {return caml_bytes_unsafe_set(s,i,c)}
    function caml_int64_of_float(x)
     {if(x < 0)x = Math.ceil(x);
      return new
              MlInt64
              (x & 0xffffff,
               Math.floor(x * caml_int64_offset) & 0xffffff,
               Math.floor(x * caml_int64_offset * caml_int64_offset) & 0xffff)}
    function caml_ml_channel_size_64(chanid)
     {var chan=caml_ml_channels[chanid];
      return caml_int64_of_float(chan.file.length())}
    function caml_ba_set_2(ba,i0,i1,v){ba.set(ba.offset([i0,i1]),v);return 0}
    function ml_z_of_int64(i64)
     {var neg=false;
      if(caml_int64_compare(i64,[255,0,0,0]) < 0)
       {neg = true;i64 = caml_int64_neg(i64)}
      var
       x=
        bigInt(i64[1]).add(bigInt(i64[2]).shiftLeft(24)).add
         (bigInt(i64[3]).shiftLeft(48));
      if(neg)x = x.negate();
      return ml_z_normalize(x)}
    var
     caml_argv=
      function()
        {var g=joo_global_object,main="a.out",args=[];
         if(g.process && g.process.argv && g.process.argv.length > 1)
          {var argv=g.process.argv;main = argv[1];args = argv.slice(2)}
         var p=caml_string_of_jsstring(main),args2=[0,p];
         for(var i=0;i < args.length;i++)
          args2.push(caml_string_of_jsstring(args[i]));
         return args2}
       (),
     caml_executable_name=caml_argv[1];
    function caml_js_eval_string(s){return eval(caml_jsstring_of_string(s))}
    function caml_CamlinternalMod_init_mod(loc,shape)
     {function undef_module(_x)
       {caml_raise_with_arg(caml_global_data.Undefined_recursive_module,loc)}
      function loop(shape,struct,idx)
       {if(typeof shape === "number")
         switch(shape)
          {case 0:struct[idx] = {fun:undef_module};break;
           case 1:struct[idx] = [246,undef_module];break;
           default:struct[idx] = []}
        else
         switch(shape[0])
          {case 0:
            struct[idx] = [0];
            for(var i=1;i < shape[1].length;i++)
             loop(shape[1][i],struct[idx],i);
            break;
           default:struct[idx] = shape[1]}}
      var res=[];
      loop(shape,res,0);
      return res[0]}
    function serialize_nat(writer,nat,sz)
     {var len=nat.data.length;
      writer.write(32,len);
      for(var i=0;i < len;i++)writer.write(32,nat.data[i]);
      sz[0] = len * 4;
      sz[1] = len * 8}
    function caml_memprof_set(_control){return 0}
    function ml_z_neg(z1){return ml_z_normalize(bigInt(z1).negate())}
    function caml_sys_exit(code)
     {var g=joo_global_object;
      if(g.quit)g.quit(code);
      if(g.process && g.process.exit)g.process.exit(code);
      caml_invalid_argument("Function 'exit' not implemented")}
    function caml_js_from_array(a){return a.slice(1)}
    function caml_ba_reshape(ba,vind)
     {vind = caml_js_from_array(vind);
      var new_dim=[],num_dims=vind.length;
      if(num_dims < 0 || num_dims > 16)
       caml_invalid_argument("Bigarray.reshape: bad number of dimensions");
      var num_elts=1;
      for(var i=0;i < num_dims;i++)
       {new_dim[i] = vind[i];
        if(new_dim[i] < 0)
         caml_invalid_argument("Bigarray.reshape: negative dimension");
        num_elts = num_elts * new_dim[i]}
      var size=caml_ba_get_size(ba.dims);
      if(num_elts != size)
       caml_invalid_argument("Bigarray.reshape: size mismatch");
      return caml_ba_create_unsafe(ba.kind,ba.layout,new_dim,ba.data)}
    var caml_oo_last_id=0;
    function caml_set_oo_id(b){b[2] = caml_oo_last_id++;return b}
    function caml_gr_fill_rect(x,y,w,h)
     {var s=caml_gr_state_get();
      s.context.fillRect(x,s.height - y,w,- h);
      return 0}
    function caml_bigstring_blit_string_to_ba(str1,pos1,ba2,pos2,len)
     {if(12 != ba2.kind)
       caml_invalid_argument
        ("caml_bigstring_blit_string_to_ba: kind mismatch");
      if(len == 0)return 0;
      var ofs2=ba2.offset(pos2);
      if(pos1 + len > caml_ml_string_length(str1))caml_array_bound_error();
      if(ofs2 + len > ba2.data.length)caml_array_bound_error();
      var slice=caml_array_of_string(str1).slice(pos1,pos1 + len);
      ba2.data.set(slice,ofs2);
      return 0}
    function caml_gr_set_window_title(name)
     {var s=caml_gr_state_get();
      s.title = name;
      var jsname=caml_jsstring_of_string(name);
      if(s.set_title)s.set_title(jsname);
      return 0}
    function caml_get_global_data(){return caml_global_data}
    function caml_int64_shift_right_unsigned(x,s)
     {return x.shift_right_unsigned(s)}
    function caml_ba_uint8_get16(ba,i0)
     {var ofs=ba.offset(i0);
      if(ofs + 1 >= ba.data.length)caml_array_bound_error();
      var b1=ba.get(ofs),b2=ba.get(ofs + 1);
      return b1 | b2 << 8}
    function ml_z_of_int(i){return i | 0}
    function ml_z_of_int32(i32){return ml_z_of_int(i32)}
    function caml_compare(a,b){return caml_compare_val(a,b,true)}
    function caml_fresh_oo_id(){return caml_oo_last_id++}
    function caml_int64_to_float(x){return x.toFloat()}
    function caml_ba_get_1(ba,i0){return ba.get(ba.offset(i0))}
    function caml_bigstring_memcmp(s1,pos1,s2,pos2,len)
     {for(var i=0;i < len;i++)
       {var a=caml_ba_get_1(s1,pos1 + i),b=caml_ba_get_1(s2,pos2 + i);
        if(a < b)return - 1;
        if(a > b)return 1}
      return 0}
    function caml_new_string(s){return caml_string_of_jsbytes(s)}
    function caml_ba_uint8_get32(ba,i0)
     {var ofs=ba.offset(i0);
      if(ofs + 3 >= ba.data.length)caml_array_bound_error();
      var
       b1=ba.get(ofs + 0),
       b2=ba.get(ofs + 1),
       b3=ba.get(ofs + 2),
       b4=ba.get(ofs + 3);
      return b1 << 0 | b2 << 8 | b3 << 16 | b4 << 24}
    function caml_raw_backtrace_length(){return 0}
    function ml_z_shift_right(z1,amt)
     {return ml_z_normalize(bigInt(z1).shiftRight(amt))}
    function caml_obj_block(tag,size)
     {var o=new Array(size + 1);
      o[0] = tag;
      for(var i=1;i <= size;i++)o[i] = 0;
      return o}
    function caml_gr_clear_graph()
     {var s=caml_gr_state_get();
      s.canvas.width = s.width;
      s.canvas.height = s.height;
      return 0}
    function bigstring_to_array_buffer(bs){return bs.data.buffer}
    function lxor_digit_nat(nat1,ofs1,nat2,ofs2)
     {nat1.data[ofs1] ^= nat2.data[ofs2];return 0}
    function caml_final_release(){return 0}
    function caml_js_to_array(a)
     {var len=a.length,b=new Array(len + 1);
      b[0] = 0;
      for(var i=0;i < len;i++)b[i + 1] = a[i];
      return b}
    function ml_z_logor(z1,z2)
     {return ml_z_normalize(bigInt(z1).or(bigInt(z2)))}
    function caml_gr_plot(x,y)
     {var
       s=caml_gr_state_get(),
       im=s.context.createImageData(1,1),
       d=im.data,
       color=s.color;
      d[0] = color >> 16 & 0xff;
      d[1] = color >> 8 & 0xff,d[2] = color >> 0 & 0xff;
      d[3] = 0xFF;
      s.x = x;
      s.y = y;
      s.context.putImageData(im,x,s.height - y);
      return 0}
    function caml_bytes_set64(s,i,i64)
     {if(i >>> 0 >= s.l - 7)caml_bytes_bound_error();
      var a=caml_int64_to_bytes(i64);
      for(var j=0;j < 8;j++)caml_bytes_unsafe_set(s,i + 7 - j,a[j]);
      return 0}
    function caml_bytes_set16(s,i,i16)
     {if(i >>> 0 >= s.l - 1)caml_bytes_bound_error();
      var b2=0xFF & i16 >> 8,b1=0xFF & i16;
      caml_bytes_unsafe_set(s,i + 0,b1);
      caml_bytes_unsafe_set(s,i + 1,b2);
      return 0}
    function caml_string_set16(s,i,i16){return caml_bytes_set16(s,i,i16)}
    function caml_int64_bswap(x)
     {var y=caml_int64_to_bytes(x);
      return caml_int64_of_bytes([y[7],y[6],y[5],y[4],y[3],y[2],y[1],y[0]])}
    function ml_z_fits_int(z1){return z1 == (z1 | 0)?1:0}
    function ml_z_fits_int32(z1){return ml_z_fits_int(z1)}
    function caml_fill_bytes(s,i,l,c)
     {if(l > 0)
       if(i == 0 && (l >= s.l || s.t == 2 && l >= s.c.length))
        if(c == 0)
         {s.c = "";s.t = 2}
        else
         {s.c = caml_str_repeat(l,String.fromCharCode(c));s.t = l == s.l?0:2}
       else
        {if(s.t != 4)caml_convert_bytes_to_array(s);
         for(l += i;i < l;i++)s.c[i] = c}
      return 0}
    var caml_fill_string=caml_fill_bytes;
    function caml_gc_major(){return 0}
    function ml_z_shift_left(z1,amt)
     {return ml_z_normalize(bigInt(z1).shiftLeft(amt))}
    function caml_lex_array(s)
     {s = caml_jsbytes_of_string(s);
      var l=s.length / 2,a=new Array(l);
      for(var i=0;i < l;i++)
       a[i]
       =
       (s.charCodeAt(2 * i) | s.charCodeAt(2 * i + 1) << 8)
       <<
       16
       >>
       16;
      return a}
    function caml_lex_engine(tbl,start_state,lexbuf)
     {var
       lex_buffer=2,
       lex_buffer_len=3,
       lex_start_pos=5,
       lex_curr_pos=6,
       lex_last_pos=7,
       lex_last_action=8,
       lex_eof_reached=9,
       lex_base=1,
       lex_backtrk=2,
       lex_default=3,
       lex_trans=4,
       lex_check=5;
      if(! tbl.lex_default)
       {tbl.lex_base = caml_lex_array(tbl[lex_base]);
        tbl.lex_backtrk = caml_lex_array(tbl[lex_backtrk]);
        tbl.lex_check = caml_lex_array(tbl[lex_check]);
        tbl.lex_trans = caml_lex_array(tbl[lex_trans]);
        tbl.lex_default = caml_lex_array(tbl[lex_default])}
      var c,state=start_state,buffer=caml_array_of_bytes(lexbuf[lex_buffer]);
      if(state >= 0)
       {lexbuf[lex_last_pos] = lexbuf[lex_start_pos] = lexbuf[lex_curr_pos];
        lexbuf[lex_last_action] = - 1}
      else
       state = - state - 1;
      for(;;)
       {var base=tbl.lex_base[state];
        if(base < 0)return - base - 1;
        var backtrk=tbl.lex_backtrk[state];
        if(backtrk >= 0)
         {lexbuf[lex_last_pos] = lexbuf[lex_curr_pos];
          lexbuf[lex_last_action] = backtrk}
        if(lexbuf[lex_curr_pos] >= lexbuf[lex_buffer_len])
         if(lexbuf[lex_eof_reached] == 0)return - state - 1;else c = 256;
        else
         {c = buffer[lexbuf[lex_curr_pos]];lexbuf[lex_curr_pos]++}
        if(tbl.lex_check[base + c] == state)
         state = tbl.lex_trans[base + c];
        else
         state = tbl.lex_default[state];
        if(state < 0)
         {lexbuf[lex_curr_pos] = lexbuf[lex_last_pos];
          if(lexbuf[lex_last_action] == - 1)
           caml_failwith("lexing: empty token");
          else
           return lexbuf[lex_last_action]}
        else
         if(c == 256)lexbuf[lex_eof_reached] = 0}}
    function caml_sys_file_exists(name)
     {var root=resolve_fs_device(name);return root.device.exists(root.rest)}
    function caml_convert_raw_backtrace_slot()
     {caml_failwith("caml_convert_raw_backtrace_slot")}
    function caml_array_sub(a,i,len)
     {var a2=new Array(len + 1);
      a2[0] = 0;
      for(var i2=1,i1=i + 1;i2 <= len;i2++,i1++)a2[i2] = a[i1];
      return a2}
    function caml_bytes_equal(s1,s2)
     {if(s1 === s2)return 1;
      s1.t & 6 && caml_convert_string_to_bytes(s1);
      s2.t & 6 && caml_convert_string_to_bytes(s2);
      return s1.c == s2.c?1:0}
    function caml_gr_size_x(){var s=caml_gr_state_get();return s.width}
    function Base_int_math_int32_clz(x)
     {var n=32,y;
      y = x >> 16;
      if(y != 0){n = n - 16;x = y}
      y = x >> 8;
      if(y != 0){n = n - 8;x = y}
      y = x >> 4;
      if(y != 0){n = n - 4;x = y}
      y = x >> 2;
      if(y != 0){n = n - 2;x = y}
      y = x >> 1;
      if(y != 0)return n - 2;
      return n - x}
    function caml_sys_const_ostype_cygwin(){return 0}
    function caml_cosh_float(x){return (Math.exp(x) + Math.exp(- x)) / 2}
    var caml_ephe_key_offset=3;
    function caml_weak_check(x,i)
     {return x[caml_ephe_key_offset + i]
              !==
              undefined
              &&
              x[caml_ephe_key_offset + i]
              !==
              0
              ?1
              :0}
    var caml_ephe_check_key=caml_weak_check;
    function caml_hash_mix_final(h)
     {h ^= h >>> 16;
      h = caml_mul(h,0x85ebca6b | 0);
      h ^= h >>> 13;
      h = caml_mul(h,0xc2b2ae35 | 0);
      h ^= h >>> 16;
      return h}
    function caml_gr_text_size(txt)
     {var
       s=caml_gr_state_get(),
       w=s.context.measureText(caml_jsstring_of_string(txt)).width;
      return [0,w,s.text_size]}
    function caml_lex_run_mem(s,i,mem,curr_pos)
     {for(;;)
       {var dst=s.charCodeAt(i);
        i++;
        if(dst == 0xff)return;
        var src=s.charCodeAt(i);
        i++;
        if(src == 0xff)
         mem[dst + 1] = curr_pos;
        else
         mem[dst + 1] = mem[src + 1]}}
    function caml_lex_run_tag(s,i,mem)
     {for(;;)
       {var dst=s.charCodeAt(i);
        i++;
        if(dst == 0xff)return;
        var src=s.charCodeAt(i);
        i++;
        if(src == 0xff)mem[dst + 1] = - 1;else mem[dst + 1] = mem[src + 1]}}
    function caml_new_lex_engine(tbl,start_state,lexbuf)
     {var
       lex_buffer=2,
       lex_buffer_len=3,
       lex_start_pos=5,
       lex_curr_pos=6,
       lex_last_pos=7,
       lex_last_action=8,
       lex_eof_reached=9,
       lex_mem=10,
       lex_base=1,
       lex_backtrk=2,
       lex_default=3,
       lex_trans=4,
       lex_check=5,
       lex_base_code=6,
       lex_backtrk_code=7,
       lex_default_code=8,
       lex_trans_code=9,
       lex_check_code=10,
       lex_code=11;
      if(! tbl.lex_default)
       {tbl.lex_base = caml_lex_array(tbl[lex_base]);
        tbl.lex_backtrk = caml_lex_array(tbl[lex_backtrk]);
        tbl.lex_check = caml_lex_array(tbl[lex_check]);
        tbl.lex_trans = caml_lex_array(tbl[lex_trans]);
        tbl.lex_default = caml_lex_array(tbl[lex_default])}
      if(! tbl.lex_default_code)
       {tbl.lex_base_code = caml_lex_array(tbl[lex_base_code]);
        tbl.lex_backtrk_code = caml_lex_array(tbl[lex_backtrk_code]);
        tbl.lex_check_code = caml_lex_array(tbl[lex_check_code]);
        tbl.lex_trans_code = caml_lex_array(tbl[lex_trans_code]);
        tbl.lex_default_code = caml_lex_array(tbl[lex_default_code])}
      if(tbl.lex_code == null)
       tbl.lex_code = caml_jsbytes_of_string(tbl[lex_code]);
      var c,state=start_state,buffer=caml_array_of_bytes(lexbuf[lex_buffer]);
      if(state >= 0)
       {lexbuf[lex_last_pos] = lexbuf[lex_start_pos] = lexbuf[lex_curr_pos];
        lexbuf[lex_last_action] = - 1}
      else
       state = - state - 1;
      for(;;)
       {var base=tbl.lex_base[state];
        if(base < 0)
         {var pc_off=tbl.lex_base_code[state];
          caml_lex_run_tag(tbl.lex_code,pc_off,lexbuf[lex_mem]);
          return - base - 1}
        var backtrk=tbl.lex_backtrk[state];
        if(backtrk >= 0)
         {var pc_off=tbl.lex_backtrk_code[state];
          caml_lex_run_tag(tbl.lex_code,pc_off,lexbuf[lex_mem]);
          lexbuf[lex_last_pos] = lexbuf[lex_curr_pos];
          lexbuf[lex_last_action] = backtrk}
        if(lexbuf[lex_curr_pos] >= lexbuf[lex_buffer_len])
         if(lexbuf[lex_eof_reached] == 0)return - state - 1;else c = 256;
        else
         {c = buffer[lexbuf[lex_curr_pos]];lexbuf[lex_curr_pos]++}
        var pstate=state;
        if(tbl.lex_check[base + c] == state)
         state = tbl.lex_trans[base + c];
        else
         state = tbl.lex_default[state];
        if(state < 0)
         {lexbuf[lex_curr_pos] = lexbuf[lex_last_pos];
          if(lexbuf[lex_last_action] == - 1)
           caml_failwith("lexing: empty token");
          else
           return lexbuf[lex_last_action]}
        else
         {var base_code=tbl.lex_base_code[pstate],pc_off;
          if(tbl.lex_check_code[base_code + c] == pstate)
           pc_off = tbl.lex_trans_code[base_code + c];
          else
           pc_off = tbl.lex_default_code[pstate];
          if(pc_off > 0)
           caml_lex_run_mem
            (tbl.lex_code,pc_off,lexbuf[lex_mem],lexbuf[lex_curr_pos]);
          if(c == 256)lexbuf[lex_eof_reached] = 0}}}
    function caml_ba_uint8_set64(ba,i0,v)
     {var ofs=ba.offset(i0);
      if(ofs + 7 >= ba.data.length)caml_array_bound_error();
      var v=caml_int64_to_bytes(v);
      for(var i=0;i < 8;i++)ba.set(ofs + i,v[7 - i]);
      return 0}
    function ml_z_popcount(z)
     {z = bigInt(z);
      var zero=bigInt(0),one=bigInt(1);
      if(z.lt(zero))caml_raise_constant(caml_named_value("ml_z_overflow"));
      var i;
      for(i = 0;! z.equals(zero);i++)z = z.and(z.prev());
      if(i != (i | 0))caml_raise_constant(caml_named_value("ml_z_overflow"));
      return i | 0}
    function caml_sys_executable_name(a){return caml_executable_name}
    function caml_lessequal(x,y){return + (caml_compare_val(x,y,false) <= 0)}
    function caml_ml_flush(chanid)
     {var chan=caml_ml_channels[chanid];
      if(! chan.opened)caml_raise_sys_error("Cannot flush a closed channel");
      if(! chan.buffer || chan.buffer == "")return 0;
      if
       (chan.fd
        &&
        caml_global_data.fds[chan.fd]
        &&
        caml_global_data.fds[chan.fd].output)
       {var output=caml_global_data.fds[chan.fd].output;
        switch(output.length)
         {case 2:output(chanid,chan.buffer);break;default:output(chan.buffer)}}
      chan.buffer = "";
      return 0}
    function caml_ml_seek_out_64(chanid,pos)
     {caml_ml_flush(chanid);
      caml_ml_channels[chanid].offset = caml_int64_to_float(pos);
      return 0}
    function compare_nat_real(nat1,nat2)
     {return compare_nat(nat1,0,nat1.data.length,nat2,0,nat2.data.length)}
    function caml_gc_set(_control){return 0}
    function caml_js_get(o,f){return o[f]}
    function caml_hash_mix_bytes_arr(h,s)
     {var len=s.length,i,w;
      for(i = 0;i + 4 <= len;i += 4)
       {w = s[i] | s[i + 1] << 8 | s[i + 2] << 16 | s[i + 3] << 24;
        h = caml_hash_mix_int(h,w)}
      w = 0;
      switch(len & 3)
       {case 3:w = s[i + 2] << 16;
        case 2:w |= s[i + 1] << 8;
        case 1:w |= s[i];h = caml_hash_mix_int(h,w)
        }
      h ^= len;
      return h}
    function caml_hash_mix_bytes(h,v)
     {switch(v.t & 6)
       {default:caml_convert_string_to_bytes(v);case 0:
         h = caml_hash_mix_jsbytes(h,v.c);break;
        case 2:h = caml_hash_mix_bytes_arr(h,v.c)
        }
      return h}
    function caml_hash(count,limit,seed,obj)
     {var queue,rd,wr,sz,num,h,v,i,len;
      sz = limit;
      if(sz < 0 || sz > 256)sz = 256;
      num = count;
      h = seed;
      queue = [obj];
      rd = 0;
      wr = 1;
      while(rd < wr && num > 0)
       {v = queue[rd++];
        if(v && v.caml_custom)
         {if
           (caml_custom_ops[v.caml_custom]
            &&
            caml_custom_ops[v.caml_custom].hash)
           {var hh=caml_custom_ops[v.caml_custom].hash(v);
            h = caml_hash_mix_int(h,hh);
            num--}}
        else
         if(v instanceof Array && v[0] === (v[0] | 0))
          switch(v[0])
           {case 248:h = caml_hash_mix_int(h,v[2]);num--;break;
            case 250:queue[--rd] = v[1];break;
            default:
             var tag=v.length - 1 << 10 | v[0];
             h = caml_hash_mix_int(h,tag);
             for(i = 1,len = v.length;i < len;i++)
              {if(wr >= sz)break;queue[wr++] = v[i]}
             break}
         else
          if(caml_is_ml_bytes(v))
           {h = caml_hash_mix_bytes(h,v);num--}
          else
           if(caml_is_ml_string(v))
            {h = caml_hash_mix_string(h,v);num--}
           else
            if(typeof v === "string")
             {h = caml_hash_mix_jsbytes(h,v);num--}
            else
             if(v === (v | 0))
              {h = caml_hash_mix_int(h,v + v + 1);num--}
             else
              if(v === + v){h = caml_hash_mix_float(h,v);num--}}
      h = caml_hash_mix_final(h);
      return h & 0x3FFFFFFF}
    function Base_hash_string(s){return caml_hash(1,1,0,s)}
    function caml_gc_compaction(){return 0}
    function caml_weak_get(x,i)
     {if(i < 0 || caml_ephe_key_offset + i >= x.length)
       caml_invalid_argument("Weak.get_key");
      return x[caml_ephe_key_offset + i] === undefined
              ?0
              :x[caml_ephe_key_offset + i]}
    var caml_ephe_get_key=caml_weak_get;
    function caml_string_of_array(a)
     {return caml_string_of_jsbytes(caml_subarray_to_jsbytes(a,0,a.length))}
    function caml_to_js_string(s){return caml_jsstring_of_string(s)}
    function jsoo_z_of_js_string_base(base,s)
     {if(base == 0)
       {base = 10;
        var p=0,sign=1;
        if(s[p] == "-"){sign = - 1;p++}else if(s[p] == "+")p++;
        if(s[p] == "0")
         {p++;
          if(s.length == p)
           return 0;
          else
           {var bc=s[p];
            if(bc == "o" || bc == "O")
             base = 8;
            else
             if(bc == "x" || bc == "X")
              base = 16;
             else
              if(bc == "b" || bc == "B")base = 2;
            if(base != 10){s = s.substring(p + 1);if(sign == - 1)s = "-" + s}}}}
      if(s[0] == "+")s = s.substring(1);
      s = s.replace(/^0+/,"");
      if(s == "-" || s == "")s = "0";
      function digit(code)
       {if(code >= 48 && code <= 57)return code - 48;
        if(code >= 97 && code <= 102)return code - 97 + 10;
        if(code >= 65 && code <= 70)return code - 65 + 10}
      var i=0;
      if(s[i] == "-")i++;
      for(;i < s.length;i++)
       {var c=digit(s.charCodeAt(i));
        if(c == undefined || c >= base)
         caml_invalid_argument("Z.of_substring_base: invalid digit")}
      return ml_z_normalize(bigInt(s,base))}
    function ml_z_of_substring_base(base,s,pos,len)
     {if(pos != 0 || len != caml_ml_string_length(s))
       {s = caml_array_of_string(s);
        if(s.length - pos < len)
         caml_invalid_argument
          ("Z.of_substring_base: invalid offset or length");
        s = caml_string_of_array(s.slice(pos,pos + len))}
      return jsoo_z_of_js_string_base(base,caml_to_js_string(s))}
    function caml_bigstring_blit_bytes_to_ba(str1,pos1,ba2,pos2,len)
     {if(12 != ba2.kind)
       caml_invalid_argument
        ("caml_bigstring_blit_string_to_ba: kind mismatch");
      if(len == 0)return 0;
      var ofs2=ba2.offset(pos2);
      if(pos1 + len > caml_ml_bytes_length(str1))caml_array_bound_error();
      if(ofs2 + len > ba2.data.length)caml_array_bound_error();
      var slice=caml_array_of_bytes(str1).slice(pos1,pos1 + len);
      ba2.data.set(slice,ofs2);
      return 0}
    function win_cleanup(){}
    function caml_sys_close(fd){delete caml_global_data.fds[fd];return 0}
    function caml_ml_close_channel(chanid)
     {var chan=caml_ml_channels[chanid];
      caml_ml_flush(chanid);
      chan.opened = false;
      chan.file.close();
      caml_sys_close(chan.fd);
      return 0}
    function caml_exn_with_js_backtrace(exn,force)
     {if(! exn.js_error || force || exn[0] == 248)
       exn.js_error
       =
       new (joo_global_object.Error)("Js exception containing backtrace");
      return exn}
    function Base_int_math_int_pow_stub(base,exponent)
     {var one=1,mul=[one,base,one,one],res=one;
      while(! exponent == 0)
       {mul[1] = mul[1] * mul[3] | 0;
        mul[2] = mul[1] * mul[1] | 0;
        mul[3] = mul[2] * mul[1] | 0;
        res = res * mul[exponent & 3] | 0;
        exponent = exponent >> 2}
      return res}
    function caml_sys_isatty(_chan){return 0}
    function is_digit_zero(nat,ofs){if(nat.data[ofs] == 0)return 1;return 0}
    function unix_inet_addr_of_string(){return 0}
    function caml_js_set(o,f,v){o[f] = v;return 0}
    function ml_z_gcdext_intern(z1,z2)
     {z1 = bigInt(z1);
      z2 = bigInt(z2);
      var
       gcd=bigInt.gcd(z1,z2),
       a=z1,
       b=z2,
       x=bigInt(0),
       lastx=bigInt(1),
       y=bigInt(1),
       lasty=bigInt(1),
       q,
       t,
       r;
      if(z1.equals(bigInt(0)))caml_raise_zero_divide();
      while(! b.equals(bigInt(0)))
       {q = a.divide(b);
        r = a.subtract(q.multiply(b));
        t = x;
        x = lastx.subtract(q.multiply(x));
        lastx = t;
        t = y;
        y = lasty.subtract(q.multiply(y));
        lasty = t;
        a = b;
        b = r}
      return a.lt(bigInt(0))
              ?[0,ml_z_normalize(a.negate()),ml_z_normalize(lastx.negate()),1]
              :[0,ml_z_normalize(a),ml_z_normalize(lastx),1]}
    function ml_z_testbit(z,pos)
     {z = bigInt(z);return z.shiftRight(pos).and(bigInt(1)).toJSNumber() | 0}
    function caml_array_get(array,index)
     {if(index < 0 || index >= array.length - 1)caml_array_bound_error();
      return array[index + 1]}
    function caml_spacetime_only_works_for_native_code()
     {caml_failwith("Spacetime profiling only works for native code")}
    function caml_int64_sub(x,y){return x.sub(y)}
    function caml_ml_seek_in_64(chanid,pos)
     {var chan=caml_ml_channels[chanid];
      if(chan.refill != null)caml_raise_sys_error("Illegal seek");
      chan.offset = caml_int64_to_float(pos);
      return 0}
    function caml_int64_shift_left(x,s){return x.shift_left(s)}
    function caml_notequal(x,y){return + (caml_compare_val(x,y,false) != 0)}
    function ml_z_abs(z1){return ml_z_normalize(bigInt(z1).abs())}
    function caml_sys_const_int_size(){return 32}
    function caml_js_wrap_meth_callback(f)
     {return function()
       {var len=arguments.length,args=new Array(len + 1);
        args[0] = this;
        for(var i=0;i < len;i++)args[i + 1] = arguments[i];
        return caml_call_gen(f,args)}}
    function caml_is_js(){return 1}
    var Base_internalhash_fold_float=caml_hash_mix_float;
    function caml_ba_dim(ba,i)
     {if(i < 0 || i >= ba.dims.length)caml_invalid_argument("Bigarray.dim");
      return ba.dims[i]}
    function caml_ba_dim_1(ba){return caml_ba_dim(ba,0)}
    function ml_z_sqrt(z1)
     {var z=bigInt(z1),zero=bigInt(0);
      if(z.lt(zero))
       caml_invalid_argument("Z.sqrt: square root of a negative number");
      return ml_z_root(z,2)}
    function unix_localtime(t)
     {var
       d=new Date(t * 1000),
       d_num=d.getTime(),
       januaryfirst=new Date(d.getFullYear(),0,1).getTime(),
       doy=Math.floor((d_num - januaryfirst) / 86400000),
       jan=new Date(d.getFullYear(),0,1),
       jul=new Date(d.getFullYear(),6,1),
       stdTimezoneOffset=
        Math.max(jan.getTimezoneOffset(),jul.getTimezoneOffset());
      return [0,
              d.getSeconds(),
              d.getMinutes(),
              d.getHours(),
              d.getDate(),
              d.getMonth(),
              d.getFullYear() - 1900,
              d.getDay(),
              doy,
              d.getTimezoneOffset() < stdTimezoneOffset | 0]}
    function caml_js_meth_call(o,f,args)
     {return o[caml_jsstring_of_string(f)].apply(o,caml_js_from_array(args))}
    function caml_weak_create(n)
     {if(n < 0)caml_invalid_argument("Weak.create");
      var x=[251,"caml_ephe_list_head"];
      x.length = caml_ephe_key_offset + n;
      return x}
    var caml_ephe_create=caml_weak_create;
    function caml_js_to_byte_string(s){return caml_string_of_jsbytes(s)}
    function ml_z_probab_prime(z,i){return bigInt(z).isProbablePrime(i)?1:0}
    function unix_mktime(tm)
     {var
       d=new Date(tm[6] + 1900,tm[5],tm[4],tm[3],tm[2],tm[1]).getTime(),
       t=Math.floor(d / 1000),
       tm2=unix_localtime(t);
      return [0,t,tm2]}
    function caml_trampoline(res)
     {var c=1;
      while(res && res.joo_tramp)
       {res = res.joo_tramp.apply(null,res.joo_args);c++}
      return res}
    function caml_bytes_get64(s,i)
     {if(i >>> 0 >= s.l - 7)caml_bytes_bound_error();
      var a=new Array(8);
      for(var j=0;j < 8;j++)a[7 - j] = caml_bytes_unsafe_get(s,i + j);
      return caml_int64_of_bytes(a)}
    function ml_z_rem(z1,z2)
     {z2 = bigInt(z2);
      if(z2.equals(bigInt(0)))caml_raise_zero_divide();
      return ml_z_normalize(bigInt(z1).mod(z2))}
    function caml_weak_set(x,i,v)
     {if(i < 0 || caml_ephe_key_offset + i >= x.length)
       caml_invalid_argument("Weak.set");
      x[caml_ephe_key_offset + i] = v;
      return 0}
    function caml_sys_remove(name)
     {var root=resolve_fs_device(name),ok=root.device.unlink(root.rest);
      if(ok == 0)caml_raise_no_such_file(name);
      return 0}
    function caml_string_bound_error()
     {caml_invalid_argument("index out of bounds")}
    function caml_string_get32(s,i)
     {if(i >>> 0 >= caml_ml_string_length(s) - 3)caml_string_bound_error();
      var
       b1=caml_string_unsafe_get(s,i),
       b2=caml_string_unsafe_get(s,i + 1),
       b3=caml_string_unsafe_get(s,i + 2),
       b4=caml_string_unsafe_get(s,i + 3);
      return b4 << 24 | b3 << 16 | b2 << 8 | b1}
    function caml_hypot_float(x,y)
     {var
       x=Math.abs(x),
       y=Math.abs(y),
       a=Math.max(x,y),
       b=Math.min(x,y) / (a?a:1);
      return a * Math.sqrt(1 + b * b)}
    function caml_js_call(f,o,args)
     {return f.apply(o,caml_js_from_array(args))}
    function caml_sys_const_max_wosize(){return 0x7FFFFFFF / 4 | 0}
    function caml_ephe_unset_key(x,i){return caml_weak_set(x,i,0)}
    function Base_am_testing(x){return 0}
    function ml_z_to_int(z1)
     {if(z1 == (z1 | 0))return z1 | 0;
      caml_raise_constant(caml_named_value("ml_z_overflow"))}
    function caml_bytes_lessthan(s1,s2)
     {s1.t & 6 && caml_convert_string_to_bytes(s1);
      s2.t & 6 && caml_convert_string_to_bytes(s2);
      return s1.c < s2.c?1:0}
    function caml_gr_fill_poly(ar)
     {var s=caml_gr_state_get();
      s.context.beginPath();
      s.context.moveTo(ar[1][1],s.height - ar[1][2]);
      for(var i=2;i < ar.length;i++)
       s.context.lineTo(ar[i][1],s.height - ar[i][2]);
      s.context.lineTo(ar[1][1],s.height - ar[1][2]);
      s.context.fill();
      return 0}
    function caml_gc_quick_stat(){return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}
    function caml_raise_end_of_file()
     {caml_raise_constant(caml_global_data.End_of_file)}
    function caml_ml_input_int(chanid)
     {var chan=caml_ml_channels[chanid],file=chan.file;
      while(chan.offset + 3 >= file.length())
       {var l=caml_ml_refill_input(chan);if(l == 0)caml_raise_end_of_file()}
      var
       o=chan.offset,
       r=
        file.read_one(o)
        <<
        24
        |
        file.read_one(o + 1)
        <<
        16
        |
        file.read_one(o + 2)
        <<
        8
        |
        file.read_one(o + 3);
      chan.offset += 4;
      return r}
    function caml_gr_display_mode()
     {caml_failwith("caml_gr_display_mode not Implemented")}
    function nth_digit_nat(nat,ofs){return nat.data[ofs]}
    function caml_array_blit(a1,i1,a2,i2,len)
     {if(i2 <= i1)
       for(var j=1;j <= len;j++)a2[i2 + j] = a1[i1 + j];
      else
       for(var j=len;j >= 1;j--)a2[i2 + j] = a1[i1 + j];
      return 0}
    function caml_float_of_string(s)
     {var res;
      s = caml_jsbytes_of_string(s);
      res = + s;
      if(s.length > 0 && res === res)return res;
      s = s.replace(/_/g,"");
      res = + s;
      if(s.length > 0 && res === res || /^[+-]?nan$/i.test(s))return res;
      var m=/^ *([+-]?)0x([0-9a-f]+)\.?([0-9a-f]*)p([+-]?[0-9]+)/i.exec(s);
      if(m)
       {var
         m3=m[3].replace(/0+$/,""),
         mantissa=parseInt(m[1] + m[2] + m3,16),
         exponent=(m[4] | 0) - 4 * m3.length;
        res = mantissa * Math.pow(2,exponent);
        return res}
      if(/^\+?inf(inity)?$/i.test(s))return Infinity;
      if(/^-inf(inity)?$/i.test(s))return - Infinity;
      caml_failwith("float_of_string")}
    function caml_sys_getcwd()
     {return caml_string_of_jsbytes(caml_current_dir)}
    function caml_sys_const_big_endian(){return 0}
    function caml_list_to_js_array(l)
     {var a=[];for(;l !== 0;l = l[2])a.push(l[1]);return a}
    var
     caml_legacy_custom_code=false,
     caml_output_val=
      function()
        {function Writer(){this.chunk = []}
         Writer.prototype
         =
         {chunk_idx:20,
          block_len:0,
          obj_counter:0,
          size_32:0,
          size_64:0,
          write:
          function(size,value)
           {for(var i=size - 8;i >= 0;i -= 8)
             this.chunk[this.chunk_idx++] = value >> i & 0xFF},
          write_at:
          function(pos,size,value)
           {var pos=pos;
            for(var i=size - 8;i >= 0;i -= 8)
             this.chunk[pos++] = value >> i & 0xFF},
          write_code:
          function(size,code,value)
           {this.chunk[this.chunk_idx++] = code;
            for(var i=size - 8;i >= 0;i -= 8)
             this.chunk[this.chunk_idx++] = value >> i & 0xFF},
          write_shared:
          function(offset)
           {if(offset < 1 << 8)
             this.write_code(8,0x04,offset);
            else
             if(offset < 1 << 16)
              this.write_code(16,0x05,offset);
             else
              this.write_code(32,0x06,offset)},
          pos:function(){return this.chunk_idx},
          finalize:
          function()
           {this.block_len = this.chunk_idx - 20;
            this.chunk_idx = 0;
            this.write(32,0x8495A6BE);
            this.write(32,this.block_len);
            this.write(32,this.obj_counter);
            this.write(32,this.size_32);
            this.write(32,this.size_64);
            return this.chunk}};
         return function(v,flags)
          {flags = caml_list_to_js_array(flags);
           var
            no_sharing=flags.indexOf(0) !== - 1,
            closures=flags.indexOf(1) !== - 1;
           if(closures)
            joo_global_object.console.warn
             ("in caml_output_val: flag Marshal.Closures is not supported.");
           var
            writer=new Writer(),
            stack=[],
            intern_obj_table=no_sharing?null:new MlObjectTable();
           function memo(v)
            {if(no_sharing)return false;
             var existing_offset=intern_obj_table.recall(v);
             if(existing_offset)
              {writer.write_shared(existing_offset);return true}
             else
              {intern_obj_table.store(v);return false}}
           function extern_rec(v)
            {if(v.caml_custom)
              {if(memo(v))return;
               var
                name=v.caml_custom,
                ops=caml_custom_ops[name],
                sz_32_64=[0,0];
               if(! ops.serialize)
                caml_invalid_argument("output_value: abstract value (Custom)");
               if(caml_legacy_custom_code)
                {writer.write(8,0x12);
                 for(var i=0;i < name.length;i++)
                  writer.write(8,name.charCodeAt(i));
                 writer.write(8,0);
                 ops.serialize(writer,v,sz_32_64)}
               else
                if(ops.fixed_length == undefined)
                 {writer.write(8,0x18);
                  for(var i=0;i < name.length;i++)
                   writer.write(8,name.charCodeAt(i));
                  writer.write(8,0);
                  var header_pos=writer.pos();
                  for(var i=0;i < 12;i++)writer.write(8,0);
                  ops.serialize(writer,v,sz_32_64);
                  writer.write_at(header_pos,32,sz_32_64[0]);
                  writer.write_at(header_pos + 4,32,0);
                  writer.write_at(header_pos + 8,32,sz_32_64[1])}
                else
                 {writer.write(8,0x19);
                  for(var i=0;i < name.length;i++)
                   writer.write(8,name.charCodeAt(i));
                  writer.write(8,0);
                  var old_pos=writer.pos();
                  ops.serialize(writer,v,sz_32_64);
                  if(ops.fixed_length != writer.pos() - old_pos)
                   caml_failwith
                    ("output_value: incorrect fixed sizes specified by " + name)}
               writer.size_32 += 2 + (sz_32_64[0] + 3 >> 2);
               writer.size_64 += 2 + (sz_32_64[1] + 7 >> 3)}
             else
              if(v instanceof Array && v[0] === (v[0] | 0))
               {if(v[0] == 251)
                 caml_failwith("output_value: abstract value (Abstract)");
                if(v.length > 1 && memo(v))return;
                if(v[0] < 16 && v.length - 1 < 8)
                 writer.write(8,0x80 + v[0] + (v.length - 1 << 4));
                else
                 writer.write_code(32,0x08,v.length - 1 << 10 | v[0]);
                writer.size_32 += v.length;
                writer.size_64 += v.length;
                if(v.length > 1)stack.push(v,1)}
              else
               if(caml_is_ml_bytes(v))
                {if(! caml_is_ml_bytes(caml_string_of_jsbytes("")))
                  caml_failwith
                   ("output_value: [Bytes.t] cannot safely be marshaled with [--enable use-js-string]");
                 if(memo(v))return;
                 var len=caml_ml_bytes_length(v);
                 if(len < 0x20)
                  writer.write(8,0x20 + len);
                 else
                  if(len < 0x100)
                   writer.write_code(8,0x09,len);
                  else
                   writer.write_code(32,0x0A,len);
                 for(var i=0;i < len;i++)
                  writer.write(8,caml_bytes_unsafe_get(v,i));
                 writer.size_32 += 1 + ((len + 4) / 4 | 0);
                 writer.size_64 += 1 + ((len + 8) / 8 | 0)}
               else
                if(caml_is_ml_string(v))
                 {var len=caml_ml_string_length(v);
                  if(len < 0x20)
                   writer.write(8,0x20 + len);
                  else
                   if(len < 0x100)
                    writer.write_code(8,0x09,len);
                   else
                    writer.write_code(32,0x0A,len);
                  for(var i=0;i < len;i++)
                   writer.write(8,caml_string_unsafe_get(v,i));
                  writer.size_32 += 1 + ((len + 4) / 4 | 0);
                  writer.size_64 += 1 + ((len + 8) / 8 | 0)}
                else
                 if(v != (v | 0))
                  {var type_of_v=typeof v;
                   caml_failwith
                    ("output_value: abstract value (" + type_of_v + ")")}
                 else
                  if(v >= 0 && v < 0x40)
                   writer.write(8,0X40 + v);
                  else
                   if(v >= - (1 << 7) && v < 1 << 7)
                    writer.write_code(8,0x00,v);
                   else
                    if(v >= - (1 << 15) && v < 1 << 15)
                     writer.write_code(16,0x01,v);
                    else
                     writer.write_code(32,0x02,v)}
           extern_rec(v);
           while(stack.length > 0)
            {var i=stack.pop(),v=stack.pop();
             if(i + 1 < v.length)stack.push(v,i + 1);
             extern_rec(v[i])}
           if(intern_obj_table)
            writer.obj_counter = intern_obj_table.objs.length;
           writer.finalize();
           return writer.chunk}}
       ();
    function caml_output_value_to_string(v,flags)
     {return caml_string_of_array(caml_output_val(v,flags))}
    function caml_raise_not_a_dir(name)
     {name = caml_jsbytes_of_string(name);
      caml_raise_sys_error(name + ": Not a directory")}
    function caml_sys_system_command(cmd)
     {var cmd=caml_jsstring_of_string(cmd);
      if
       (typeof require
        !=
        "undefined"
        &&
        require("child_process")
        &&
        require("child_process").execSync)
       try
        {require("child_process").execSync(cmd,{stdio:"inherit"});return 0}
       catch(e){return 1}
      else
       return 127}
    function unix_isatty(fileDescriptor)
     {if(fs_node_supported())
       {var tty=require("tty");return tty.isatty(fileDescriptor)}
      else
       return false}
    function caml_js_error_of_exception(exn)
     {if(exn.js_error)return exn.js_error;return null}
    function deserialize_nat(reader,sz)
     {var len=reader.read32s(),nat=new MlNat(len);
      for(var i=0;i < len;i++)nat.data[i] = reader.read32s();
      sz[0] = len * 4;
      return nat}
    function initialize_nat()
     {caml_custom_ops["_nat"]
      =
      {deserialize:deserialize_nat,serialize:serialize_nat,hash:caml_hash_nat}}
    function ml_z_succ(z1){return ml_z_normalize(bigInt(z1).next())}
    function caml_gr_open_subwindow(a,b,c,d)
     {caml_failwith("caml_gr_open_subwindow not Implemented")}
    function js_print_stdout(s)
     {var s=caml_utf16_of_utf8(s),g=joo_global_object;
      if(g.process && g.process.stdout && g.process.stdout.write)
       g.process.stdout.write(s);
      else
       {if(s.charCodeAt(s.length - 1) == 10)s = s.substr(0,s.length - 1);
        var v=g.console;
        v && v.log && v.log(s)}}
    function caml_copysign_float(x,y)
     {if(y == 0)y = 1 / y;x = Math.abs(x);return y < 0?- x:x}
    function caml_gr_set_text_size(size)
     {var s=caml_gr_state_get();
      s.text_size = size;
      s.context.font = s.text_size + "px " + caml_jsstring_of_string(s.font);
      return 0}
    var
     caml_md5_bytes=
      function()
        {function add(x,y){return x + y | 0}
         function xx(q,a,b,x,s,t)
          {a = add(add(a,q),add(x,t));return add(a << s | a >>> 32 - s,b)}
         function ff(a,b,c,d,x,s,t){return xx(b & c | ~ b & d,a,b,x,s,t)}
         function gg(a,b,c,d,x,s,t){return xx(b & d | c & ~ d,a,b,x,s,t)}
         function hh(a,b,c,d,x,s,t){return xx(b ^ c ^ d,a,b,x,s,t)}
         function ii(a,b,c,d,x,s,t){return xx(c ^ (b | ~ d),a,b,x,s,t)}
         function md5(buffer,length)
          {var i=length;
           buffer[i >> 2] |= 0x80 << 8 * (i & 3);
           for(i = (i & ~ 0x3) + 8;(i & 0x3F) < 60;i += 4)
            buffer[(i >> 2) - 1] = 0;
           buffer[(i >> 2) - 1] = length << 3;
           buffer[i >> 2] = length >> 29 & 0x1FFFFFFF;
           var w=[0x67452301,0xEFCDAB89,0x98BADCFE,0x10325476];
           for(i = 0;i < buffer.length;i += 16)
            {var a=w[0],b=w[1],c=w[2],d=w[3];
             a = ff(a,b,c,d,buffer[i + 0],7,0xD76AA478);
             d = ff(d,a,b,c,buffer[i + 1],12,0xE8C7B756);
             c = ff(c,d,a,b,buffer[i + 2],17,0x242070DB);
             b = ff(b,c,d,a,buffer[i + 3],22,0xC1BDCEEE);
             a = ff(a,b,c,d,buffer[i + 4],7,0xF57C0FAF);
             d = ff(d,a,b,c,buffer[i + 5],12,0x4787C62A);
             c = ff(c,d,a,b,buffer[i + 6],17,0xA8304613);
             b = ff(b,c,d,a,buffer[i + 7],22,0xFD469501);
             a = ff(a,b,c,d,buffer[i + 8],7,0x698098D8);
             d = ff(d,a,b,c,buffer[i + 9],12,0x8B44F7AF);
             c = ff(c,d,a,b,buffer[i + 10],17,0xFFFF5BB1);
             b = ff(b,c,d,a,buffer[i + 11],22,0x895CD7BE);
             a = ff(a,b,c,d,buffer[i + 12],7,0x6B901122);
             d = ff(d,a,b,c,buffer[i + 13],12,0xFD987193);
             c = ff(c,d,a,b,buffer[i + 14],17,0xA679438E);
             b = ff(b,c,d,a,buffer[i + 15],22,0x49B40821);
             a = gg(a,b,c,d,buffer[i + 1],5,0xF61E2562);
             d = gg(d,a,b,c,buffer[i + 6],9,0xC040B340);
             c = gg(c,d,a,b,buffer[i + 11],14,0x265E5A51);
             b = gg(b,c,d,a,buffer[i + 0],20,0xE9B6C7AA);
             a = gg(a,b,c,d,buffer[i + 5],5,0xD62F105D);
             d = gg(d,a,b,c,buffer[i + 10],9,0x02441453);
             c = gg(c,d,a,b,buffer[i + 15],14,0xD8A1E681);
             b = gg(b,c,d,a,buffer[i + 4],20,0xE7D3FBC8);
             a = gg(a,b,c,d,buffer[i + 9],5,0x21E1CDE6);
             d = gg(d,a,b,c,buffer[i + 14],9,0xC33707D6);
             c = gg(c,d,a,b,buffer[i + 3],14,0xF4D50D87);
             b = gg(b,c,d,a,buffer[i + 8],20,0x455A14ED);
             a = gg(a,b,c,d,buffer[i + 13],5,0xA9E3E905);
             d = gg(d,a,b,c,buffer[i + 2],9,0xFCEFA3F8);
             c = gg(c,d,a,b,buffer[i + 7],14,0x676F02D9);
             b = gg(b,c,d,a,buffer[i + 12],20,0x8D2A4C8A);
             a = hh(a,b,c,d,buffer[i + 5],4,0xFFFA3942);
             d = hh(d,a,b,c,buffer[i + 8],11,0x8771F681);
             c = hh(c,d,a,b,buffer[i + 11],16,0x6D9D6122);
             b = hh(b,c,d,a,buffer[i + 14],23,0xFDE5380C);
             a = hh(a,b,c,d,buffer[i + 1],4,0xA4BEEA44);
             d = hh(d,a,b,c,buffer[i + 4],11,0x4BDECFA9);
             c = hh(c,d,a,b,buffer[i + 7],16,0xF6BB4B60);
             b = hh(b,c,d,a,buffer[i + 10],23,0xBEBFBC70);
             a = hh(a,b,c,d,buffer[i + 13],4,0x289B7EC6);
             d = hh(d,a,b,c,buffer[i + 0],11,0xEAA127FA);
             c = hh(c,d,a,b,buffer[i + 3],16,0xD4EF3085);
             b = hh(b,c,d,a,buffer[i + 6],23,0x04881D05);
             a = hh(a,b,c,d,buffer[i + 9],4,0xD9D4D039);
             d = hh(d,a,b,c,buffer[i + 12],11,0xE6DB99E5);
             c = hh(c,d,a,b,buffer[i + 15],16,0x1FA27CF8);
             b = hh(b,c,d,a,buffer[i + 2],23,0xC4AC5665);
             a = ii(a,b,c,d,buffer[i + 0],6,0xF4292244);
             d = ii(d,a,b,c,buffer[i + 7],10,0x432AFF97);
             c = ii(c,d,a,b,buffer[i + 14],15,0xAB9423A7);
             b = ii(b,c,d,a,buffer[i + 5],21,0xFC93A039);
             a = ii(a,b,c,d,buffer[i + 12],6,0x655B59C3);
             d = ii(d,a,b,c,buffer[i + 3],10,0x8F0CCC92);
             c = ii(c,d,a,b,buffer[i + 10],15,0xFFEFF47D);
             b = ii(b,c,d,a,buffer[i + 1],21,0x85845DD1);
             a = ii(a,b,c,d,buffer[i + 8],6,0x6FA87E4F);
             d = ii(d,a,b,c,buffer[i + 15],10,0xFE2CE6E0);
             c = ii(c,d,a,b,buffer[i + 6],15,0xA3014314);
             b = ii(b,c,d,a,buffer[i + 13],21,0x4E0811A1);
             a = ii(a,b,c,d,buffer[i + 4],6,0xF7537E82);
             d = ii(d,a,b,c,buffer[i + 11],10,0xBD3AF235);
             c = ii(c,d,a,b,buffer[i + 2],15,0x2AD7D2BB);
             b = ii(b,c,d,a,buffer[i + 9],21,0xEB86D391);
             w[0] = add(a,w[0]);
             w[1] = add(b,w[1]);
             w[2] = add(c,w[2]);
             w[3] = add(d,w[3])}
           var t=new Array(16);
           for(var i=0;i < 4;i++)
            for(var j=0;j < 4;j++)t[i * 4 + j] = w[i] >> 8 * j & 0xFF;
           return t}
         return function(s,ofs,len)
          {var buf=[];
           switch(s.t & 6)
            {default:caml_convert_string_to_bytes(s);case 0:
              var b=s.c;
              for(var i=0;i < len;i += 4)
               {var j=i + ofs;
                buf[i >> 2]
                =
                b.charCodeAt(j)
                |
                b.charCodeAt(j + 1)
                <<
                8
                |
                b.charCodeAt(j + 2)
                <<
                16
                |
                b.charCodeAt(j + 3)
                <<
                24}
              for(;i < len;i++)
               buf[i >> 2] |= b.charCodeAt(i + ofs) << 8 * (i & 3);
              break;
             case 4:
              var a=s.c;
              for(var i=0;i < len;i += 4)
               {var j=i + ofs;
                buf[i >> 2]
                =
                a[j]
                |
                a[j + 1]
                <<
                8
                |
                a[j + 2]
                <<
                16
                |
                a[j + 3]
                <<
                24}
              for(;i < len;i++)buf[i >> 2] |= a[i + ofs] << 8 * (i & 3)
             }
           return caml_string_of_array(md5(buf,len))}}
       ();
    function caml_ba_set_generic(ba,i,v)
     {ba.set(ba.offset(caml_js_from_array(i)),v);return 0}
    function caml_ephe_set_key(x,i,v){return caml_weak_set(x,i,[0,v])}
    function caml_bytes_lessequal(s1,s2)
     {s1.t & 6 && caml_convert_string_to_bytes(s1);
      s2.t & 6 && caml_convert_string_to_bytes(s2);
      return s1.c <= s2.c?1:0}
    function caml_string_lessequal(s1,s2){return caml_bytes_lessequal(s1,s2)}
    function caml_string_greaterequal(s1,s2)
     {return caml_string_lessequal(s2,s1)}
    function caml_int64_add(x,y){return x.add(y)}
    function caml_nextafter_float(x,y)
     {if(isNaN(x) || isNaN(y))return NaN;
      if(x == y)return y;
      if(x == 0)return y < 0?- Math.pow(2,- 1074):Math.pow(2,- 1074);
      var bits=caml_int64_bits_of_float(x),one=caml_int64_of_int32(1);
      if(x < y == x > 0)
       bits = caml_int64_add(bits,one);
      else
       bits = caml_int64_sub(bits,one);
      return caml_int64_float_of_bits(bits)}
    function caml_gr_size_y(){var s=caml_gr_state_get();return s.height}
    function caml_ml_pos_in(chanid){return caml_ml_channels[chanid].offset}
    function caml_int64_and(x,y){return x.and(y)}
    function caml_int64_mul(x,y){return x.mul(y)}
    function Base_int_math_int64_pow_stub(base,exponent)
     {var one=[255,1,0,0],mul=[one,base,one,one],res=one;
      while(! caml_int64_is_zero(exponent))
       {mul[1] = caml_int64_mul(mul[1],mul[3]);
        mul[2] = caml_int64_mul(mul[1],mul[1]);
        mul[3] = caml_int64_mul(mul[2],mul[1]);
        res = caml_int64_mul(res,mul[exponent[1] & 3]);
        exponent = caml_int64_shift_right_unsigned(exponent,2)}
      return res}
    function caml_sys_const_word_size(){return 32}
    function caml_std_output(chanid,s)
     {var
       chan=caml_ml_channels[chanid],
       str=caml_string_of_jsbytes(s),
       slen=caml_ml_string_length(str);
      chan.file.write(chan.offset,str,0,slen);
      chan.offset += slen;
      return 0}
    function js_print_stderr(s)
     {var s=caml_utf16_of_utf8(s),g=joo_global_object;
      if(g.process && g.process.stdout && g.process.stdout.write)
       g.process.stderr.write(s);
      else
       {if(s.charCodeAt(s.length - 1) == 10)s = s.substr(0,s.length - 1);
        var v=g.console;
        v && v.error && v.error(s)}}
    function caml_sys_open_internal(idx,output,file,flags)
     {if(caml_global_data.fds === undefined)
       caml_global_data.fds = new Array();
      flags = flags?flags:{};
      var info={};
      info.file = file;
      info.offset = flags.append?file.length():0;
      info.flags = flags;
      info.output = output;
      caml_global_data.fds[idx] = info;
      if(! caml_global_data.fd_last_idx || idx > caml_global_data.fd_last_idx)
       caml_global_data.fd_last_idx = idx;
      return idx}
    function caml_sys_open(name,flags,_perms)
     {var f={};
      while(flags)
       {switch(flags[1])
         {case 0:f.rdonly = 1;break;
          case 1:f.wronly = 1;break;
          case 2:f.append = 1;break;
          case 3:f.create = 1;break;
          case 4:f.truncate = 1;break;
          case 5:f.excl = 1;break;
          case 6:f.binary = 1;break;
          case 7:f.text = 1;break;
          case 8:f.nonblock = 1;break
          }
        flags = flags[2]}
      if(f.rdonly && f.wronly)
       caml_raise_sys_error
        (caml_jsbytes_of_string(name)
         +
         " : flags Open_rdonly and Open_wronly are not compatible");
      if(f.text && f.binary)
       caml_raise_sys_error
        (caml_jsbytes_of_string(name)
         +
         " : flags Open_text and Open_binary are not compatible");
      var
       root=resolve_fs_device(name),
       file=root.device.open(root.rest,f),
       idx=caml_global_data.fd_last_idx?caml_global_data.fd_last_idx:0;
      return caml_sys_open_internal(idx + 1,caml_std_output,file,f)}
    caml_sys_open_internal
     (0,caml_std_output,new MlFakeFile(caml_create_bytes(0)));
    caml_sys_open_internal
     (1,js_print_stdout,new MlFakeFile(caml_create_bytes(0)));
    caml_sys_open_internal
     (2,js_print_stderr,new MlFakeFile(caml_create_bytes(0)));
    function ml_z_gcd(z1,z2)
     {return ml_z_normalize(bigInt.gcd(bigInt(z1),bigInt(z2)).abs())}
    function MlStringReader(s,i)
     {this.s = caml_jsbytes_of_string(s);this.i = i}
    MlStringReader.prototype
    =
    {read8u:function(){return this.s.charCodeAt(this.i++)},
     read8s:function(){return this.s.charCodeAt(this.i++) << 24 >> 24},
     read16u:
     function()
      {var s=this.s,i=this.i;
       this.i = i + 2;
       return s.charCodeAt(i) << 8 | s.charCodeAt(i + 1)},
     read16s:
     function()
      {var s=this.s,i=this.i;
       this.i = i + 2;
       return s.charCodeAt(i) << 24 >> 16 | s.charCodeAt(i + 1)},
     read32u:
     function()
      {var s=this.s,i=this.i;
       this.i = i + 4;
       return (s.charCodeAt(i)
               <<
               24
               |
               s.charCodeAt(i + 1)
               <<
               16
               |
               s.charCodeAt(i + 2)
               <<
               8
               |
               s.charCodeAt(i + 3))
              >>>
              0},
     read32s:
     function()
      {var s=this.s,i=this.i;
       this.i = i + 4;
       return s.charCodeAt(i)
              <<
              24
              |
              s.charCodeAt(i + 1)
              <<
              16
              |
              s.charCodeAt(i + 2)
              <<
              8
              |
              s.charCodeAt(i + 3)},
     readstr:
     function(len)
      {var i=this.i;
       this.i = i + len;
       return caml_string_of_jsbytes(this.s.substring(i,i + len))}};
    function caml_float_of_bytes(a)
     {return caml_int64_float_of_bits(caml_int64_of_bytes(a))}
    function caml_input_value_from_reader(reader,ofs)
     {var
       _magic=reader.read32u(),
       _block_len=reader.read32u(),
       num_objects=reader.read32u(),
       _size_32=reader.read32u(),
       _size_64=reader.read32u(),
       stack=[],
       intern_obj_table=num_objects > 0?[]:null,
       obj_counter=0;
      function intern_rec()
       {var code=reader.read8u();
        if(code >= 0x40)
         if(code >= 0x80)
          {var tag=code & 0xF,size=code >> 4 & 0x7,v=[tag];
           if(size == 0)return v;
           if(intern_obj_table)intern_obj_table[obj_counter++] = v;
           stack.push(v,size);
           return v}
         else
          return code & 0x3F;
        else
         if(code >= 0x20)
          {var len=code & 0x1F,v=reader.readstr(len);
           if(intern_obj_table)intern_obj_table[obj_counter++] = v;
           return v}
         else
          switch(code)
           {case 0x00:return reader.read8s();
            case 0x01:return reader.read16s();
            case 0x02:return reader.read32s();
            case 0x03:caml_failwith("input_value: integer too large");break;
            case 0x04:
             var offset=reader.read8u();
             return intern_obj_table[obj_counter - offset];
            case 0x05:
             var offset=reader.read16u();
             return intern_obj_table[obj_counter - offset];
            case 0x06:
             var offset=reader.read32u();
             return intern_obj_table[obj_counter - offset];
            case 0x08:
             var
              header=reader.read32u(),
              tag=header & 0xFF,
              size=header >> 10,
              v=[tag];
             if(size == 0)return v;
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             stack.push(v,size);
             return v;
            case 0x13:
             caml_failwith("input_value: data block too large");break;
            case 0x09:
             var len=reader.read8u(),v=reader.readstr(len);
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             return v;
            case 0x0A:
             var len=reader.read32u(),v=reader.readstr(len);
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             return v;
            case 0x0C:
             var t=new Array(8);
             for(var i=0;i < 8;i++)t[7 - i] = reader.read8u();
             var v=caml_float_of_bytes(t);
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             return v;
            case 0x0B:
             var t=new Array(8);
             for(var i=0;i < 8;i++)t[i] = reader.read8u();
             var v=caml_float_of_bytes(t);
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             return v;
            case 0x0E:
             var len=reader.read8u(),v=new Array(len + 1);
             v[0] = 254;
             var t=new Array(8);
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             for(var i=1;i <= len;i++)
              {for(var j=0;j < 8;j++)t[7 - j] = reader.read8u();
               v[i] = caml_float_of_bytes(t)}
             return v;
            case 0x0D:
             var len=reader.read8u(),v=new Array(len + 1);
             v[0] = 254;
             var t=new Array(8);
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             for(var i=1;i <= len;i++)
              {for(var j=0;j < 8;j++)t[j] = reader.read8u();
               v[i] = caml_float_of_bytes(t)}
             return v;
            case 0x07:
             var len=reader.read32u(),v=new Array(len + 1);
             v[0] = 254;
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             var t=new Array(8);
             for(var i=1;i <= len;i++)
              {for(var j=0;j < 8;j++)t[7 - j] = reader.read8u();
               v[i] = caml_float_of_bytes(t)}
             return v;
            case 0x0F:
             var len=reader.read32u(),v=new Array(len + 1);
             v[0] = 254;
             var t=new Array(8);
             for(var i=1;i <= len;i++)
              {for(var j=0;j < 8;j++)t[j] = reader.read8u();
               v[i] = caml_float_of_bytes(t)}
             return v;
            case 0x10:
            case 0x11:caml_failwith("input_value: code pointer");break;
            case 0x12:
            case 0x18:
            case 0x19:
             var c,s="";
             while((c = reader.read8u()) != 0)s += String.fromCharCode(c);
             var ops=caml_custom_ops[s],expected_size;
             if(! ops)
              caml_failwith("input_value: unknown custom block identifier");
             switch(code)
              {case 0x12:break;
               case 0x19:
                if(! ops.fixed_length)
                 caml_failwith
                  ("input_value: expected a fixed-size custom block");
                expected_size = ops.fixed_length;
                break;
               case 0x18:
                expected_size = reader.read32u();
                reader.read32s();
                reader.read32s();
                break
               }
             var old_pos=reader.i,size=[0],v=ops.deserialize(reader,size);
             if(expected_size != undefined)
              if(expected_size != size[0])
               caml_failwith
                ("input_value: incorrect length of serialized custom block");
             if(intern_obj_table)intern_obj_table[obj_counter++] = v;
             return v;
            default:caml_failwith("input_value: ill-formed message")}}
      var res=intern_rec();
      while(stack.length > 0)
       {var size=stack.pop(),v=stack.pop(),d=v.length;
        if(d < size)stack.push(v,size);
        v[d] = intern_rec()}
      if(typeof ofs != "number")ofs[0] = reader.i;
      return res}
    function caml_string_of_bytes(s){return s}
    function caml_input_value_from_bytes(s,ofs)
     {var
       reader=
        new
         MlStringReader
         (caml_string_of_bytes(s),typeof ofs == "number"?ofs:ofs[0]);
      return caml_input_value_from_reader(reader,ofs)}
    function ml_z_hamdist(z1,z2)
     {if(bigInt(z1).isNegative() != bigInt(z2).isNegative())
       caml_raise_constant(caml_named_value("ml_z_overflow"));
      if
       ((z1 != (z1 | 0) || z2 != (z2 | 0))
        &&
        (bigInt(z1).isNegative() || bigInt(z2).isNegative()))
       caml_invalid_argument("Z.hamdist: negative arguments");
      return ml_z_popcount(bigInt(z1).xor(bigInt(z2)))}
    function ml_z_mul(z1,z2)
     {return ml_z_normalize(bigInt(z1).multiply(bigInt(z2)))}
    function caml_string_get(s,i)
     {if(i >>> 0 >= caml_ml_string_length(s))caml_string_bound_error();
      return caml_string_unsafe_get(s,i)}
    var
     re_match=
      function()
        {var
          re_word_letters=
           [0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0xFF,
            0x03,
            0xFE,
            0xFF,
            0xFF,
            0x87,
            0xFE,
            0xFF,
            0xFF,
            0x07,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0x00,
            0xFF,
            0xFF,
            0x7F,
            0xFF,
            0xFF,
            0xFF,
            0x7F,
            0xFF],
          opcodes=
           {CHAR:0,
            CHARNORM:1,
            STRING:2,
            STRINGNORM:3,
            CHARCLASS:4,
            BOL:5,
            EOL:6,
            WORDBOUNDARY:7,
            BEGGROUP:8,
            ENDGROUP:9,
            REFGROUP:10,
            ACCEPT:11,
            SIMPLEOPT:12,
            SIMPLESTAR:13,
            SIMPLEPLUS:14,
            GOTO:15,
            PUSHBACK:16,
            SETMARK:17,
            CHECKPROGRESS:18};
         function is_word_letter(c)
          {return re_word_letters[c >> 3] >> (c & 7) & 1}
         function in_bitset(s,i)
          {return caml_string_get(s,i >> 3) >> (i & 7) & 1}
         function re_match_impl(re,s,pos,partial)
          {var
            prog=caml_js_from_array(re[1]),
            cpool=caml_js_from_array(re[2]),
            normtable=caml_jsbytes_of_string(re[3]),
            numgroups=re[4] | 0,
            numregisters=re[5] | 0,
            startchars=re[6] | 0,
            s=caml_array_of_string(s),
            pc=0,
            quit=false,
            stack=[],
            groups=new Array(numgroups),
            re_register=new Array(numregisters);
           for(var i=0;i < groups.length;i++)groups[i] = {start:- 1,end:- 1};
           groups[0].start = pos;
           function backtrack()
            {while(stack.length)
              {var item=stack.pop();
               if(item.undo)
                item.undo.obj[item.undo.prop] = item.undo.value;
               else
                if(item.pos){pc = item.pos.pc;pos = item.pos.txt;return}}
             quit = true}
           function push(item){stack.push(item)}
           function accept()
            {groups[0].end = pos;
             var result=new Array(1 + groups.length * 2);
             result[0] = 0;
             for(var i=0;i < groups.length;i++)
              {var g=groups[i];
               if(g.start < 0 || g.end < 0)g.start = g.end = - 1;
               result[2 * i + 1] = g.start;
               result[2 * i + 1 + 1] = g.end}
             return result}
           function prefix_match()
            {if(partial)return accept();else backtrack()}
           while(! quit)
            {var
              op=prog[pc] & 0xff,
              sarg=prog[pc] >> 8,
              uarg=sarg & 0xff,
              c=s[pos],
              group;
             pc++;
             switch(op)
              {case opcodes.CHAR:
                if(pos === s.length){prefix_match();break}
                if(c === uarg)pos++;else backtrack();
                break;
               case opcodes.CHARNORM:
                if(pos === s.length){prefix_match();break}
                if(normtable.charCodeAt(c) === uarg)pos++;else backtrack();
                break;
               case opcodes.STRING:
                for
                 (var arg=caml_jsbytes_of_string(cpool[uarg]),i=0;
                  i
                  <
                  arg.length;
                  i++)
                 {if(pos === s.length){prefix_match();break}
                  if(c === arg.charCodeAt(i))
                   c = s[++pos];
                  else
                   {backtrack();break}}
                break;
               case opcodes.STRINGNORM:
                for
                 (var arg=caml_jsbytes_of_string(cpool[uarg]),i=0;
                  i
                  <
                  arg.length;
                  i++)
                 {if(pos === s.length){prefix_match();break}
                  if(normtable.charCodeAt(c) === arg.charCodeAt(i))
                   c = s[++pos];
                  else
                   {backtrack();break}}
                break;
               case opcodes.CHARCLASS:
                if(pos === s.length){prefix_match();break}
                if(in_bitset(cpool[uarg],c))pos++;else backtrack();
                break;
               case opcodes.BOL:
                if(pos > 0 && s[pos - 1] != 10)backtrack();break;
               case opcodes.EOL:
                if(pos < s.length && s[pos] != 10)backtrack();break;
               case opcodes.WORDBOUNDARY:
                if(pos == 0)
                 {if(pos === s.length){prefix_match();break}
                  if(is_word_letter(s[0]))break;
                  backtrack()}
                else
                 if(pos === s.length)
                  {if(is_word_letter(s[pos - 1]))break;backtrack()}
                 else
                  {if(is_word_letter(s[pos - 1]) != is_word_letter(s[pos]))
                    break;
                   backtrack()}
                break;
               case opcodes.BEGGROUP:
                group = groups[uarg];
                push({undo:{obj:group,prop:"start",value:group.start}});
                group.start = pos;
                break;
               case opcodes.ENDGROUP:
                group = groups[uarg];
                push({undo:{obj:group,prop:"end",value:group.end}});
                group.end = pos;
                break;
               case opcodes.REFGROUP:
                group = groups[uarg];
                if(group.start < 0 || group.end < 0){backtrack();break}
                for(var i=group.start;i < group.end;i++)
                 {if(pos === s.length){prefix_match();break}
                  if(s[i] != s[pos]){backtrack();break}
                  pos++}
                break;
               case opcodes.SIMPLEOPT:if(in_bitset(cpool[uarg],c))pos++;break;
               case opcodes.SIMPLESTAR:
                while(in_bitset(cpool[uarg],c))c = s[++pos];break;
               case opcodes.SIMPLEPLUS:
                if(pos === s.length){prefix_match();break}
                if(in_bitset(cpool[uarg],c))
                 do c = s[++pos];while(in_bitset(cpool[uarg],c));
                else
                 backtrack();
                break;
               case opcodes.ACCEPT:return accept();
               case opcodes.GOTO:pc = pc + sarg;break;
               case opcodes.PUSHBACK:push({pos:{pc:pc + sarg,txt:pos}});break;
               case opcodes.SETMARK:
                push
                 ({undo:{obj:re_register,prop:uarg,value:re_register[uarg]}});
                re_register[uarg] = pos;
                break;
               case opcodes.CHECKPROGRESS:
                if(re_register[uarg] === pos)backtrack();break;
               default:throw new Error("Invalid bytecode")}}
           return 0}
         return re_match_impl}
       ();
    function re_search_backward(re,s,pos)
     {if(pos < 0 || pos > caml_ml_string_length(s))
       caml_invalid_argument("Str.search_backward");
      while(pos >= 0){var res=re_match(re,s,pos,0);if(res)return res;pos--}
      return [0]}
    function ml_z_logand(z1,z2)
     {return ml_z_normalize(bigInt(z1).and(bigInt(z2)))}
    function caml_js_from_string(s){return caml_jsstring_of_string(s)}
    function caml_ba_sub(ba,ofs,len)
     {var changed_dim,mul=1;
      if(ba.layout == 0)
       {for(var i=1;i < ba.dims.length;i++)mul = mul * ba.dims[i];
        changed_dim = 0}
      else
       {for(var i=0;i < ba.dims.length - 1;i++)mul = mul * ba.dims[i];
        changed_dim = ba.dims.length - 1;
        ofs = ofs - 1}
      if(ofs < 0 || len < 0 || ofs + len > ba.dims[changed_dim])
       caml_invalid_argument("Bigarray.sub: bad sub-array");
      var new_dims=[];
      for(var i=0;i < ba.dims.length;i++)new_dims[i] = ba.dims[i];
      new_dims[changed_dim] = len;
      mul *= caml_ba_get_size_per_element(ba.kind);
      var new_data=ba.data.subarray(ofs * mul,(ofs + len) * mul);
      return caml_ba_create_unsafe(ba.kind,ba.layout,new_dims,new_data)}
    function caml_gc_full_major(){return 0}
    function caml_bytes_set32(s,i,i32)
     {if(i >>> 0 >= s.l - 3)caml_bytes_bound_error();
      var
       b4=0xFF & i32 >> 24,
       b3=0xFF & i32 >> 16,
       b2=0xFF & i32 >> 8,
       b1=0xFF & i32;
      caml_bytes_unsafe_set(s,i + 0,b1);
      caml_bytes_unsafe_set(s,i + 1,b2);
      caml_bytes_unsafe_set(s,i + 2,b3);
      caml_bytes_unsafe_set(s,i + 3,b4);
      return 0}
    function caml_gr_sigio_signal(){return 0}
    function caml_ba_uint8_set32(ba,i0,v)
     {var ofs=ba.offset(i0);
      if(ofs + 3 >= ba.data.length)caml_array_bound_error();
      ba.set(ofs + 0,v & 0xff);
      ba.set(ofs + 1,v >>> 8 & 0xff);
      ba.set(ofs + 2,v >>> 16 & 0xff);
      ba.set(ofs + 3,v >>> 24 & 0xff);
      return 0}
    function ml_z_div_rem(z1,z2){return [0,ml_z_div(z1,z2),ml_z_rem(z1,z2)]}
    function caml_sys_const_ostype_unix(){return 1}
    function caml_signbit_float(x){if(x == 0)x = 1 / x;return x < 0?1:0}
    function caml_gr_current_x(){var s=caml_gr_state_get();return s.x}
    function caml_gr_set_line_width(w)
     {var s=caml_gr_state_get();
      s.line_width = w;
      s.context.lineWidth = w;
      return 0}
    function caml_gr_set_font(f)
     {var s=caml_gr_state_get();
      s.font = f;
      s.context.font = s.text_size + "px " + caml_jsstring_of_string(s.font);
      return 0}
    function caml_gr_set_color(color)
     {var s=caml_gr_state_get();
      function convert(number)
       {var str="" + number.toString(16);
        while(str.length < 2)str = "0" + str;
        return str}
      var r=color >> 16 & 0xff,g=color >> 8 & 0xff,b=color >> 0 & 0xff;
      s.color = color;
      var c_str="#" + convert(r) + convert(g) + convert(b);
      s.context.fillStyle = c_str;
      s.context.strokeStyle = c_str;
      return 0}
    function caml_gr_moveto(x,y)
     {var s=caml_gr_state_get();s.x = x;s.y = y;return 0}
    function caml_gr_resize_window(w,h)
     {var s=caml_gr_state_get();
      s.width = w;
      s.height = h;
      s.canvas.width = w;
      s.canvas.height = h;
      return 0}
    function caml_gr_state_init()
     {caml_gr_moveto(caml_gr_state.x,caml_gr_state.y);
      caml_gr_resize_window(caml_gr_state.width,caml_gr_state.height);
      caml_gr_set_line_width(caml_gr_state.line_width);
      caml_gr_set_text_size(caml_gr_state.text_size);
      caml_gr_set_font(caml_gr_state.font);
      caml_gr_set_color(caml_gr_state.color);
      caml_gr_set_window_title(caml_gr_state.title);
      caml_gr_state.context.textBaseline = "bottom"}
    function caml_ba_kind_of_typed_array(ta)
     {var g=joo_global_object,kind;
      if(ta instanceof g.Float32Array)
       kind = 0;
      else
       if(ta instanceof g.Float64Array)
        kind = 1;
       else
        if(ta instanceof g.Int8Array)
         kind = 2;
        else
         if(ta instanceof g.Uint8Array)
          kind = 3;
         else
          if(ta instanceof g.Int16Array)
           kind = 4;
          else
           if(ta instanceof g.Uint16Array)
            kind = 5;
           else
            if(ta instanceof g.Int32Array)
             kind = 6;
            else
             if(ta instanceof g.Uint32Array)
              kind = 6;
             else
              caml_invalid_argument
               ("caml_ba_kind_of_typed_array: unsupported kind");
      return kind}
    function caml_ba_from_typed_array(ta)
     {var kind=caml_ba_kind_of_typed_array(ta);
      return caml_ba_create_unsafe(kind,0,[ta.length],ta)}
    function caml_ml_seek_out(chanid,pos)
     {caml_ml_flush(chanid);caml_ml_channels[chanid].offset = pos;return 0}
    function caml_js_typeof(o){return typeof o}
    function caml_restore_raw_backtrace(exn,bt){return 0}
    function caml_gr_lineto(x,y)
     {var s=caml_gr_state_get();
      s.context.beginPath();
      s.context.moveTo(s.x,s.height - s.y);
      s.context.lineTo(x,s.height - y);
      s.context.stroke();
      s.x = x;
      s.y = y;
      return 0}
    function caml_js_wrap_meth_callback_unsafe(f)
     {return function()
       {var len=arguments.length,args=new Array(len + 1);
        args[0] = this;
        for(var i=0;i < len;i++)args[i + 1] = arguments[i];
        return f.apply(null,args)}}
    function caml_ba_dim_3(ba){return caml_ba_dim(ba,2)}
    var caml_ephe_data_offset=2;
    function caml_ephe_check_data(x)
     {return x[caml_ephe_data_offset] === undefined?0:1}
    function caml_bytes_get16(s,i)
     {if(i >>> 0 >= s.l - 1)caml_bytes_bound_error();
      var b1=caml_bytes_unsafe_get(s,i),b2=caml_bytes_unsafe_get(s,i + 1);
      return b2 << 8 | b1}
    function caml_obj_make_forward(b,v){b[0] = 250;b[1] = v;return 0}
    function caml_js_from_bool(x){return ! ! x}
    function caml_ml_set_channel_name(){return 0}
    function caml_gr_close_graph()
     {var s=caml_gr_state_get();
      s.canvas.width = 0;
      s.canvas.height = 0;
      return 0}
    var Base_internalhash_fold_int=caml_hash_mix_int;
    function caml_create_string(len)
     {if(len < 0)caml_invalid_argument("String.create");
      return new MlBytes(len?2:9,"",len)}
    function Base_int_math_nativeint_clz(x){return Base_int_math_int32_clz(x)}
    function caml_md5_string(s,ofs,len)
     {return caml_md5_bytes(caml_bytes_of_string(s),ofs,len)}
    function caml_md5_chan(chanid,len)
     {var chan=caml_ml_channels[chanid],chan_len=chan.file.length();
      if(len < 0)len = chan_len - chan.offset;
      if(chan.offset + len > chan_len)caml_raise_end_of_file();
      var buf=caml_create_bytes(len);
      chan.file.read(chan.offset,buf,0,len);
      return caml_md5_string(caml_string_of_bytes(buf),0,len)}
    function caml_obj_dup(x)
     {var l=x.length,a=new Array(l);
      for(var i=0;i < l;i++)a[i] = x[i];
      return a}
    function caml_weak_get_copy(x,i)
     {if(i < 0 || caml_ephe_key_offset + i >= x.length)
       caml_invalid_argument("Weak.get_copy");
      var y=caml_weak_get(x,i);
      if(y === 0)return y;
      var z=y[1];
      if(z instanceof Array)return [0,caml_obj_dup(z)];
      return y}
    function caml_ml_output_bytes(chanid,buffer,offset,len)
     {var chan=caml_ml_channels[chanid];
      if(! chan.opened)
       caml_raise_sys_error("Cannot output to a closed channel");
      var bytes;
      if(offset == 0 && caml_ml_bytes_length(buffer) == len)
       bytes = buffer;
      else
       {bytes = caml_create_bytes(len);
        caml_blit_bytes(buffer,offset,bytes,0,len)}
      var
       string=caml_string_of_bytes(bytes),
       jsstring=caml_jsbytes_of_string(string),
       id=jsstring.lastIndexOf("\n");
      if(id < 0)
       chan.buffer += jsstring;
      else
       {chan.buffer += jsstring.substr(0,id + 1);
        caml_ml_flush(chanid);
        chan.buffer += jsstring.substr(id + 1)}
      return 0}
    function caml_ml_output(chanid,buffer,offset,len)
     {return caml_ml_output_bytes
              (chanid,caml_bytes_of_string(buffer),offset,len)}
    function caml_ephe_get_data(x)
     {return x[caml_ephe_data_offset] === undefined
              ?0
              :[0,x[caml_ephe_data_offset]]}
    function caml_trampoline_return(f,args)
     {return {joo_tramp:f,joo_args:args}}
    function Base_int_math_int64_clz(x)
     {var n=64,y;
      y = caml_int64_shift_right_unsigned(x,32);
      if(! caml_int64_is_zero(y)){n = n - 32;x = y}
      y = caml_int64_shift_right_unsigned(x,16);
      if(! caml_int64_is_zero(y)){n = n - 16;x = y}
      y = caml_int64_shift_right_unsigned(x,8);
      if(! caml_int64_is_zero(y)){n = n - 8;x = y}
      y = caml_int64_shift_right_unsigned(x,4);
      if(! caml_int64_is_zero(y)){n = n - 4;x = y}
      y = caml_int64_shift_right_unsigned(x,2);
      if(! caml_int64_is_zero(y)){n = n - 2;x = y}
      y = caml_int64_shift_right_unsigned(x,1);
      if(! caml_int64_is_zero(y))return n - 2;
      return n - caml_int64_to_int32(x)}
    function caml_array_append(a1,a2)
     {var l1=a1.length,l2=a2.length,l=l1 + l2 - 1,a=new Array(l);
      a[0] = 0;
      var i=1,j=1;
      for(;i < l1;i++)a[i] = a1[i];
      for(;i < l;i++,j++)a[i] = a2[j];
      return a}
    function caml_ml_set_channel_refill(chanid,f)
     {caml_ml_channels[chanid].refill = f;return 0}
    function ml_z_nextprime(z1)
     {z1 = bigInt(z1);
      var one=bigInt(1),two=bigInt(2);
      if(z1.lt(one) || z1.equals(one))return 2;
      if(z1.and(one).equals(one))z1 = z1.add(two);else z1 = z1.add(one);
      while(true)
       if(z1.isProbablePrime(25))
        return ml_z_normalize(z1);
       else
        z1 = z1.add(two)}
    function caml_js_expr(s)
     {js_print_stderr("caml_js_expr: fallback to runtime evaluation\n");
      return eval(caml_jsstring_of_string(s))}
    function caml_js_to_string(s){return caml_string_of_jsstring(s)}
    function caml_ojs_iterate_properties(o,f)
     {var name;
      for(name in o)if(o.hasOwnProperty(name))f(caml_js_to_string(name))}
    function caml_ml_runtime_warnings_enabled(_unit)
     {return caml_runtime_warnings}
    function ml_z_sub(z1,z2)
     {return ml_z_normalize(bigInt(z1).subtract(bigInt(z2)))}
    function ml_z_fdiv(z1,z2)
     {var z1_pos=ml_z_sign(z1),z2_pos=ml_z_sign(z2);
      if(z1_pos * z2_pos < 0)
       if(! bigInt(z1).mod(bigInt(z2)).equals(bigInt(0)))
        return ml_z_sub(ml_z_div(z1,z2),bigInt(1));
      return ml_z_div(z1,z2)}
    function ml_z_to_bits(z1)
     {z1 = bigInt(z1).abs();
      var res="";
      while(! z1.equals(bigInt(0)))
       {res += String.fromCharCode(z1.mod(bigInt(256)));
        z1 = z1.divide(bigInt(256))}
      while(res.length % 4 != 0)res += String.fromCharCode(0);
      return caml_new_string(res)}
    function caml_output_value_to_bytes(v,flags)
     {return caml_bytes_of_array(caml_output_val(v,flags))}
    function caml_hash_univ_param(count,limit,obj)
     {var hash_accu=0;
      function hash_aux(obj)
       {limit--;
        if(count < 0 || limit < 0)return;
        if(obj instanceof Array && obj[0] === (obj[0] | 0))
         switch(obj[0])
          {case 248:count--;hash_accu = hash_accu * 65599 + obj[2] | 0;break;
           case 250:limit++;hash_aux(obj);break;
           default:
            count--;
            hash_accu = hash_accu * 19 + obj[0] | 0;
            for(var i=obj.length - 1;i > 0;i--)hash_aux(obj[i])}
        else
         if(caml_is_ml_bytes(obj))
          {count--;
           switch(obj.t & 6)
            {default:caml_convert_string_to_bytes(obj);case 0:
              for(var b=obj.c,l=caml_ml_bytes_length(obj),i=0;i < l;i++)
               hash_accu = hash_accu * 19 + b.charCodeAt(i) | 0;
              break;
             case 2:
              for(var a=obj.c,l=caml_ml_bytes_length(obj),i=0;i < l;i++)
               hash_accu = hash_accu * 19 + a[i] | 0
             }}
         else
          if(caml_is_ml_string(obj))
           {var jsbytes=caml_jsbytes_of_string(obj);
            for(var b=jsbytes,l=jsbytes.length,i=0;i < l;i++)
             hash_accu = hash_accu * 19 + b.charCodeAt(i) | 0}
          else
           if(typeof obj === "string")
            for(var b=obj,l=obj.length,i=0;i < l;i++)
             hash_accu = hash_accu * 19 + b.charCodeAt(i) | 0;
           else
            if(obj === (obj | 0))
             {count--;hash_accu = hash_accu * 65599 + obj | 0}
            else
             if(obj === + obj)
              {count--;
               var p=caml_int64_to_bytes(caml_int64_bits_of_float(obj));
               for(var i=7;i >= 0;i--)hash_accu = hash_accu * 19 + p[i] | 0}
             else
              if(obj && obj.caml_custom)
               if
                (caml_custom_ops[obj.caml_custom]
                 &&
                 caml_custom_ops[obj.caml_custom].hash)
                {var h=caml_custom_ops[obj.caml_custom].hash(obj) | 0;
                 hash_accu = hash_accu * 65599 + h | 0}}
      hash_aux(obj);
      return hash_accu & 0x3FFFFFFF}
    function caml_string_equal(s1,s2){return caml_bytes_equal(s1,s2)}
    function ml_z_divexact(z1,z2){return ml_z_div(z1,z2)}
    function caml_output_value_to_buffer(s,ofs,len,v,flags)
     {var t=caml_output_val(v,flags);
      if(t.length > len)caml_failwith("Marshal.to_buffer: buffer overflow");
      caml_blit_bytes(t,0,s,ofs,t.length);
      return 0}
    function re_replacement_text(repl,groups,orig)
     {var
       repl=caml_jsbytes_of_string(repl),
       len=repl.length,
       orig=caml_jsbytes_of_string(orig),
       res="",
       n=0,
       cur,
       start,
       end,
       c;
      while(n < len)
       {cur = repl.charAt(n++);
        if(cur != "\\")
         res += cur;
        else
         {if(n == len)
           caml_failwith("Str.replace: illegal backslash sequence");
          cur = repl.charAt(n++);
          switch(cur)
           {case "\\":res += cur;break;
            case "0":
            case "1":
            case "2":
            case "3":
            case "4":
            case "5":
            case "6":
            case "7":
            case "8":
            case "9":
             c = + cur;
             if(c * 2 >= groups.length - 1)
              caml_failwith("Str.replace: reference to unmatched group");
             start = caml_array_get(groups,c * 2);
             end = caml_array_get(groups,c * 2 + 1);
             if(start == - 1)
              caml_failwith("Str.replace: reference to unmatched group");
             res += orig.slice(start,end);
             break;
            default:res += "\\" + cur}}}
      return caml_string_of_jsbytes(res)}
    function caml_pure_js_expr(s)
     {js_print_stderr("caml_pure_js_expr: fallback to runtime evaluation\n");
      return eval(caml_jsstring_of_string(s))}
    function blit_nat(nat1,ofs1,nat2,ofs2,len)
     {for(var i=0;i < len;i++)nat1.data[ofs1 + i] = nat2.data[ofs2 + i];
      return 0}
    function caml_int64_ult(x,y){return x.ucompare(y) < 0}
    function caml_int64_xor(x,y){return x.xor(y)}
    function caml_bigstring_blit_ba_to_bytes(ba1,pos1,bytes2,pos2,len)
     {if(12 != ba1.kind)
       caml_invalid_argument
        ("caml_bigstring_blit_string_to_ba: kind mismatch");
      if(len == 0)return 0;
      var ofs1=ba1.offset(pos1);
      if(ofs1 + len > ba1.data.length)caml_array_bound_error();
      if(pos2 + len > caml_ml_bytes_length(bytes2))caml_array_bound_error();
      var slice=ba1.data.slice(ofs1,ofs1 + len);
      caml_blit_bytes(caml_bytes_of_array(slice),0,bytes2,pos2,len);
      return 0}
    function caml_register_named_value(nm,v)
     {caml_named_values[caml_jsbytes_of_string(nm)] = v;return 0}
    function caml_parse_sign_and_base(s)
     {var i=0,len=caml_ml_string_length(s),base=10,sign=1;
      if(len > 0)
       switch(caml_string_unsafe_get(s,i))
        {case 45:i++;sign = - 1;break;case 43:i++;sign = 1;break}
      if(i + 1 < len && caml_string_unsafe_get(s,i) == 48)
       switch(caml_string_unsafe_get(s,i + 1))
        {case 120:
         case 88:base = 16;i += 2;break;
         case 111:
         case 79:base = 8;i += 2;break;
         case 98:
         case 66:base = 2;i += 2;break;
         case 117:
         case 85:i += 2;break
         }
      return [i,sign,base]}
    function caml_parse_digit(c)
     {if(c >= 48 && c <= 57)return c - 48;
      if(c >= 65 && c <= 90)return c - 55;
      if(c >= 97 && c <= 122)return c - 87;
      return - 1}
    function caml_int64_of_string(s)
     {var
       r=caml_parse_sign_and_base(s),
       i=r[0],
       sign=r[1],
       base=r[2],
       base64=caml_int64_of_int32(base),
       threshold=
        new MlInt64(0xffffff,0xfffffff,0xffff).udivmod(base64).quotient,
       c=caml_string_unsafe_get(s,i),
       d=caml_parse_digit(c);
      if(d < 0 || d >= base)caml_failwith("int_of_string");
      var res=caml_int64_of_int32(d);
      for(;;)
       {i++;
        c = caml_string_unsafe_get(s,i);
        if(c == 95)continue;
        d = caml_parse_digit(c);
        if(d < 0 || d >= base)break;
        if(caml_int64_ult(threshold,res))caml_failwith("int_of_string");
        d = caml_int64_of_int32(d);
        res = caml_int64_add(caml_int64_mul(base64,res),d);
        if(caml_int64_ult(res,d))caml_failwith("int_of_string")}
      if(i != caml_ml_string_length(s))caml_failwith("int_of_string");
      if(base == 10 && caml_int64_ult(new MlInt64(0,0,0x8000),res))
       caml_failwith("int_of_string");
      if(sign < 0)res = caml_int64_neg(res);
      return res}
    var caml_blit_string_to_bigstring=caml_bigstring_blit_string_to_ba;
    function re_search_forward(re,s,pos)
     {if(pos < 0 || pos > caml_ml_string_length(s))
       caml_invalid_argument("Str.search_forward");
      while(pos <= caml_ml_string_length(s))
       {var res=re_match(re,s,pos,0);if(res)return res;pos++}
      return [0]}
    function caml_make_vect(len,init)
     {if(len < 0)caml_array_bound_error();
      var len=len + 1 | 0,b=new Array(len);
      b[0] = 0;
      for(var i=1;i < len;i++)b[i] = init;
      return b}
    function caml_ml_seek_in(chanid,pos)
     {var chan=caml_ml_channels[chanid];
      if(chan.refill != null)caml_raise_sys_error("Illegal seek");
      chan.offset = pos;
      return 0}
    function caml_sys_read_directory(name)
     {var
       root=resolve_fs_device(name),
       a=root.device.readdir(root.rest),
       l=new Array(a.length + 1);
      l[0] = 0;
      for(var i=0;i < a.length;i++)l[i + 1] = caml_string_of_jsbytes(a[i]);
      return l}
    function caml_ml_output_char(chanid,c)
     {var s=caml_string_of_jsbytes(String.fromCharCode(c));
      caml_ml_output(chanid,s,0,1);
      return 0}
    function caml_sys_const_ostype_win32(){return 0}
    function caml_obj_is_block(x){return + (x instanceof Array)}
    function caml_ml_input_char(chanid)
     {var chan=caml_ml_channels[chanid];
      caml_ml_may_refill_input(chanid);
      if(chan.offset >= chan.file.length())caml_raise_end_of_file();
      var res=chan.file.read_one(chan.offset);
      chan.offset++;
      return res}
    function caml_js_var(x)
     {var x=caml_jsstring_of_string(x);
      if(! x.match(/^[a-zA-Z_$][a-zA-Z_$0-9]*(\.[a-zA-Z_$][a-zA-Z_$0-9]*)*$/))
       js_print_stderr
        ('caml_js_var: "'
         +
         x
         +
         '" is not a valid JavaScript variable. continuing ..');
      return eval(x)}
    function caml_trunc_float(x){return Math.trunc(x)}
    function caml_zarith_marshal(writer,v,sz)
     {v = bigInt(v);
      var bits=v.toArray(Math.pow(2,32));
      writer.write(8,bits.isNegative?1:0);
      var block=bits.value.length,len=block * 4;
      writer.write(32,len);
      for(var i=block - 1;i >= 0;i--)
       {writer.write(8,bits.value[i] >>> 0 & 0xff);
        writer.write(8,bits.value[i] >>> 8 & 0xff);
        writer.write(8,bits.value[i] >>> 16 & 0xff);
        writer.write(8,bits.value[i] >>> 24 & 0xff)}
      sz[0] = 4 * (1 + ((len + 3) / 4 | 0));
      sz[1] = 8 * (1 + ((len + 7) / 8 | 0))}
    function caml_ephe_blit_data(src,dst)
     {dst[caml_ephe_data_offset] = src[caml_ephe_data_offset];return 0}
    var Base_internalhash_fold_int64=caml_hash_mix_int64;
    function caml_is_printable(c){return + (c > 31 && c < 127)}
    function caml_equal(x,y){return + (caml_compare_val(x,y,false) == 0)}
    function re_partial_match(re,s,pos)
     {if(pos < 0 || pos > caml_ml_string_length(s))
       caml_invalid_argument("Str.partial_match");
      var res=re_match(re,s,pos,1);
      return res?res:[0]}
    function caml_sys_random_seed()
     {var now=new Date().getTime(),x=now ^ 0xffffffff * Math.random();
      return [0,x]}
    function caml_final_register_called_without_value(){return 0}
    function caml_ba_get_2(ba,i0,i1){return ba.get(ba.offset([i0,i1]))}
    function win_handle_fd(x){return x}
    function caml_ba_uint8_set16(ba,i0,v)
     {var ofs=ba.offset(i0);
      if(ofs + 1 >= ba.data.length)caml_array_bound_error();
      ba.set(ofs + 0,v & 0xff);
      ba.set(ofs + 1,v >>> 8 & 0xff);
      return 0}
    function caml_js_delete(o,f){delete o[f];return 0}
    function caml_int_of_string(s)
     {var
       r=caml_parse_sign_and_base(s),
       i=r[0],
       sign=r[1],
       base=r[2],
       len=caml_ml_string_length(s),
       threshold=- 1 >>> 0,
       c=i < len?caml_string_unsafe_get(s,i):0,
       d=caml_parse_digit(c);
      if(d < 0 || d >= base)caml_failwith("int_of_string");
      var res=d;
      for(i++;i < len;i++)
       {c = caml_string_unsafe_get(s,i);
        if(c == 95)continue;
        d = caml_parse_digit(c);
        if(d < 0 || d >= base)break;
        res = base * res + d;
        if(res > threshold)caml_failwith("int_of_string")}
      if(i != len)caml_failwith("int_of_string");
      res = sign * res;
      if(base == 10 && (res | 0) != res)caml_failwith("int_of_string");
      return res | 0}
    function caml_list_mount_point()
     {var prev=0;
      for(var i=0;i < jsoo_mount_point.length;i++)
       {var old=prev;
        prev = [0,caml_string_of_jsbytes(jsoo_mount_point[i].path),old]}
      return prev}
    var
     caml_marshal_constants=
      {PREFIX_SMALL_BLOCK:0x80,
       PREFIX_SMALL_INT:0x40,
       PREFIX_SMALL_STRING:0x20,
       CODE_INT8:0x00,
       CODE_INT16:0x01,
       CODE_INT32:0x02,
       CODE_INT64:0x03,
       CODE_SHARED8:0x04,
       CODE_SHARED16:0x05,
       CODE_SHARED32:0x06,
       CODE_BLOCK32:0x08,
       CODE_BLOCK64:0x13,
       CODE_STRING8:0x09,
       CODE_STRING32:0x0A,
       CODE_DOUBLE_BIG:0x0B,
       CODE_DOUBLE_LITTLE:0x0C,
       CODE_DOUBLE_ARRAY8_BIG:0x0D,
       CODE_DOUBLE_ARRAY8_LITTLE:0x0E,
       CODE_DOUBLE_ARRAY32_BIG:0x0F,
       CODE_DOUBLE_ARRAY32_LITTLE:0x07,
       CODE_CODEPOINTER:0x10,
       CODE_INFIXPOINTER:0x11,
       CODE_CUSTOM:0x12,
       CODE_CUSTOM_LEN:0x18,
       CODE_CUSTOM_FIXED:0x19};
    function caml_js_equals(x,y){return + (x == y)}
    function bigstring_to_typed_array(bs){return bs.data}
    function ml_z_fits_nativeint(z1){return ml_z_fits_int(z1)}
    function caml_gr_arc_aux(ctx,cx,cy,ry,rx,a1,a2)
     {while(a1 > a2)a2 += 360;
      a1 /= 180;
      a2 /= 180;
      var
       rot=0,
       xPos,
       yPos,
       xPos_prev,
       yPos_prev,
       space=2,
       num=(a2 - a1) * Math.PI * ((rx + ry) / 2) / space | 0,
       delta=(a2 - a1) * Math.PI / num,
       i=a1 * Math.PI;
      for(var j=0;j <= num;j++)
       {xPos
        =
        cx
        -
        rx
        *
        Math.sin(i)
        *
        Math.sin(rot * Math.PI)
        +
        ry
        *
        Math.cos(i)
        *
        Math.cos(rot * Math.PI);
        xPos = xPos.toFixed(2);
        yPos
        =
        cy
        +
        ry
        *
        Math.cos(i)
        *
        Math.sin(rot * Math.PI)
        +
        rx
        *
        Math.sin(i)
        *
        Math.cos(rot * Math.PI);
        yPos = yPos.toFixed(2);
        if(j == 0)
         ctx.moveTo(xPos,yPos);
        else
         if(xPos_prev != xPos || yPos_prev != yPos)ctx.lineTo(xPos,yPos);
        xPos_prev = xPos;
        yPos_prev = yPos;
        i -= delta}
      return 0}
    function caml_gr_fill_arc(x,y,rx,ry,a1,a2)
     {var s=caml_gr_state_get();
      s.context.beginPath();
      caml_gr_arc_aux(s.context,x,s.height - y,rx,ry,a1,a2);
      s.context.fill();
      return 0}
    function caml_ba_slice(ba,vind)
     {vind = caml_js_from_array(vind);
      var num_inds=vind.length,index=[],sub_dims=[],ofs;
      if(num_inds > ba.dims.length)
       caml_invalid_argument("Bigarray.slice: too many indices");
      if(ba.layout == 0)
       {for(var i=0;i < num_inds;i++)index[i] = vind[i];
        for(;i < ba.dims.length;i++)index[i] = 0;
        sub_dims = ba.dims.slice(num_inds)}
      else
       {for(var i=0;i < num_inds;i++)
         index[ba.dims.length - num_inds + i] = vind[i];
        for(var i=0;i < ba.dims.length - num_inds;i++)index[i] = 1;
        sub_dims = ba.dims.slice(0,ba.dims.length - num_inds)}
      ofs = ba.offset(index);
      var
       size=caml_ba_get_size(sub_dims),
       size_per_element=caml_ba_get_size_per_element(ba.kind),
       new_data=
        ba.data.subarray
         (ofs * size_per_element,(ofs + size) * size_per_element);
      return caml_ba_create_unsafe(ba.kind,ba.layout,sub_dims,new_data)}
    function ml_z_of_nativeint(z){return ml_z_of_int(z)}
    function caml_marshal_data_size(s,ofs)
     {function get32(s,i)
       {return caml_bytes_unsafe_get(s,i)
               <<
               24
               |
               caml_bytes_unsafe_get(s,i + 1)
               <<
               16
               |
               caml_bytes_unsafe_get(s,i + 2)
               <<
               8
               |
               caml_bytes_unsafe_get(s,i + 3)}
      if(get32(s,ofs) != (0x8495A6BE | 0))
       caml_failwith("Marshal.data_size: bad object");
      return get32(s,ofs + 4)}
    function caml_input_value(chanid)
     {var chan=caml_ml_channels[chanid],buf=caml_create_bytes(8);
      chan.file.read(chan.offset,buf,0,8);
      var len=caml_marshal_data_size(buf,0) + 20,buf=caml_create_bytes(len);
      chan.file.read(chan.offset,buf,0,len);
      var offset=[0],res=caml_input_value_from_bytes(buf,offset);
      chan.offset = chan.offset + offset[0];
      return res}
    function caml_ba_kind(ba){return ba.kind}
    function caml_js_fun_call(f,a)
     {switch(a.length)
       {case 1:return f();
        case 2:return f(a[1]);
        case 3:return f(a[1],a[2]);
        case 4:return f(a[1],a[2],a[3]);
        case 5:return f(a[1],a[2],a[3],a[4]);
        case 6:return f(a[1],a[2],a[3],a[4],a[5]);
        case 7:return f(a[1],a[2],a[3],a[4],a[5],a[6]);
        case 8:return f(a[1],a[2],a[3],a[4],a[5],a[6],a[7])
        }
      return f.apply(null,caml_js_from_array(a))}
    function ml_z_invert(a,n)
     {a = bigInt(a);
      n = bigInt(n);
      var
       x=ml_z_gcdext_intern(a,n),
       r=bigInt(x[2]),
       tmp=bigInt(a).multiply(r).mod(n);
      if(tmp.lt(bigInt(0)))tmp = tmp.add(n.abs());
      if(r.lt(bigInt(0)))r = r.add(n.abs());
      if(n.abs().equals(bigInt(1)))return 0;
      if(tmp.equals(bigInt(1)))return ml_z_normalize(r);
      caml_raise_zero_divide()}
    function ml_z_powm(z1,z2,z3)
     {var zero=bigInt(0),one=bigInt(1);
      z1 = bigInt(z1);
      z2 = bigInt(z2);
      z3 = bigInt(z3);
      if(z3.equals(zero) || z3.abs().equals(one))return 0;
      if(z2.equals(zero))return 1;
      if(z2.lt(0))
       {var inv=bigInt(ml_z_invert(z1,z3)),r=inv.modPow(z2.negate(),z3);
        if(r.lt(zero))r = r.add(z3.abs());
        return ml_z_normalize(r)}
      else
       {var r=bigInt(z1).modPow(z2,z3);
        if(r.lt(zero))r = r.add(z3.abs());
        return ml_z_normalize(r)}}
    function ml_z_powm_sec(z1,z2,z3)
     {z3 = bigInt(z3).abs();
      var one=bigInt(1);
      if(bigInt(z2).lt(one))
       caml_invalid_argument("Z.powm_sec: exponent must be positive");
      if(! bigInt(z3).and(one).equals(one))
       caml_invalid_argument("Z.powm_sec: modulus must be odd");
      return ml_z_powm(z1,z2,z3)}
    function caml_js_pure_expr(f){return f()}
    function compare_digits_nat(nat1,ofs1,nat2,ofs2)
     {if(nat1.data[ofs1] > nat2.data[ofs2])return 1;
      if(nat1.data[ofs1] < nat2.data[ofs2])return - 1;
      return 0}
    function caml_ml_input(chanid,s,i,l)
     {var chan=caml_ml_channels[chanid],l2=chan.file.length() - chan.offset;
      if(l2 == 0 && chan.refill != null)l2 = caml_ml_refill_input(chan);
      if(l2 < l)l = l2;
      chan.file.read(chan.offset,s,i,l);
      chan.offset += l;
      return l}
    function caml_gr_wait_event(_evl)
     {caml_failwith
       ("caml_gr_wait_event not Implemented: use Graphics_js instead")}
    function caml_gr_sigio_handler(){return 0}
    function caml_hash_mix_bigstring(h,bs)
     {return caml_hash_mix_bytes_arr(h,bs.data)}
    function caml_record_backtrace(){return 0}
    function unix_gmtime(t)
     {var
       d=new Date(t * 1000),
       d_num=d.getTime(),
       januaryfirst=new Date(Date.UTC(d.getUTCFullYear(),0,1)).getTime(),
       doy=Math.floor((d_num - januaryfirst) / 86400000);
      return [0,
              d.getUTCSeconds(),
              d.getUTCMinutes(),
              d.getUTCHours(),
              d.getUTCDate(),
              d.getUTCMonth(),
              d.getUTCFullYear() - 1900,
              d.getUTCDay(),
              doy,
              false | 0]}
    function caml_sys_get_config()
     {return [0,caml_string_of_jsbytes("Unix"),32,0]}
    function caml_sys_const_backend_type()
     {return [0,caml_string_of_jsbytes("js_of_ocaml")]}
    function unix_time(){return Math.floor(unix_gettimeofday())}
    function caml_ml_out_channels_list()
     {var l=0;
      for(var c=0;c < caml_ml_channels.length;c++)
       if
        (caml_ml_channels[c]
         &&
         caml_ml_channels[c].opened
         &&
         caml_ml_channels[c].out)
        l = [0,caml_ml_channels[c].fd,l];
      return l}
    function ml_z_hash(z1)
     {var a=bigInt(z1).toArray(Math.pow(2,32)),acc=0;
      for(var i=0;i < a.value.length;i++)
       acc = caml_hash_mix_int(acc,a.value[i]);
      if(a.value.length % 2 != 0)acc = caml_hash_mix_int(acc,0);
      if(a.isNegative)acc = acc + 1;
      return acc | 0}
    function bigstring_of_array_buffer(ab)
     {var ta=new (joo_global_object.Uint8Array)(ab);
      return caml_ba_create_unsafe(12,0,[ta.length],ta)}
    function caml_mod(x,y){if(y == 0)caml_raise_zero_divide();return x % y}
    function caml_ba_init(){return 0}
    function re_string_match(re,s,pos)
     {if(pos < 0 || pos > caml_ml_string_length(s))
       caml_invalid_argument("Str.string_match");
      var res=re_match(re,s,pos,0);
      return res?res:[0]}
    function BigStringReader(bs,i){this.s = bs;this.i = i}
    BigStringReader.prototype
    =
    {read8u:function(){return caml_ba_get_1(this.s,this.i++)},
     read8s:function(){return caml_ba_get_1(this.s,this.i++) << 24 >> 24},
     read16u:
     function()
      {var s=this.s,i=this.i;
       this.i = i + 2;
       return caml_ba_get_1(s,i) << 8 | caml_ba_get_1(s,i + 1)},
     read16s:
     function()
      {var s=this.s,i=this.i;
       this.i = i + 2;
       return caml_ba_get_1(s,i) << 24 >> 16 | caml_ba_get_1(s,i + 1)},
     read32u:
     function()
      {var s=this.s,i=this.i;
       this.i = i + 4;
       return (caml_ba_get_1(s,i)
               <<
               24
               |
               caml_ba_get_1(s,i + 1)
               <<
               16
               |
               caml_ba_get_1(s,i + 2)
               <<
               8
               |
               caml_ba_get_1(s,i + 3))
              >>>
              0},
     read32s:
     function()
      {var s=this.s,i=this.i;
       this.i = i + 4;
       return caml_ba_get_1(s,i)
              <<
              24
              |
              caml_ba_get_1(s,i + 1)
              <<
              16
              |
              caml_ba_get_1(s,i + 2)
              <<
              8
              |
              caml_ba_get_1(s,i + 3)},
     readstr:
     function(len)
      {var i=this.i,arr=new Array(len);
       for(var j=0;j < len;j++)arr[j] = caml_ba_get_1(this.s,i + j);
       this.i = i + len;
       return caml_string_of_array(arr)}};
    function caml_gr_dump_image(im)
     {var data=[0];
      for(var i=0;i < im.height;i++)
       {data[i + 1] = [0];
        for(var j=0;j < im.width;j++)
         {var
           o=i * (im.width * 4) + j * 4,
           r=im.data[o + 0],
           g=im.data[o + 1],
           b=im.data[o + 2];
          data[i + 1][j + 1] = (r << 16) + (g << 8) + b}}
      return data}
    function caml_ba_get_generic(ba,i)
     {var ofs=ba.offset(caml_js_from_array(i));return ba.get(ofs)}
    function caml_get_exception_backtrace(){return 0}
    function caml_format_float(fmt,x)
     {function toFixed(x,dp)
       {if(Math.abs(x) < 1.0)
         return x.toFixed(dp);
        else
         {var e=parseInt(x.toString().split("+")[1]);
          if(e > 20)
           {e -= 20;
            x /= Math.pow(10,e);
            x += new Array(e + 1).join("0");
            if(dp > 0)x = x + "." + new Array(dp + 1).join("0");
            return x}
          else
           return x.toFixed(dp)}}
      var s,f=caml_parse_format(fmt),prec=f.prec < 0?6:f.prec;
      if(x < 0 || x == 0 && 1 / x == - Infinity){f.sign = - 1;x = - x}
      if(isNaN(x))
       {s = "nan";f.filler = " "}
      else
       if(! isFinite(x))
        {s = "inf";f.filler = " "}
       else
        switch(f.conv)
         {case "e":
           var s=x.toExponential(prec),i=s.length;
           if(s.charAt(i - 3) == "e")
            s = s.slice(0,i - 1) + "0" + s.slice(i - 1);
           break;
          case "f":s = toFixed(x,prec);break;
          case "g":
           prec = prec?prec:1;
           s = x.toExponential(prec - 1);
           var j=s.indexOf("e"),exp=+ s.slice(j + 1);
           if(exp < - 4 || x >= 1e21 || x.toFixed(0).length > prec)
            {var i=j - 1;
             while(s.charAt(i) == "0")i--;
             if(s.charAt(i) == ".")i--;
             s = s.slice(0,i + 1) + s.slice(j);
             i = s.length;
             if(s.charAt(i - 3) == "e")
              s = s.slice(0,i - 1) + "0" + s.slice(i - 1);
             break}
           else
            {var p=prec;
             if(exp < 0)
              {p -= exp + 1;s = x.toFixed(p)}
             else
              while(s = x.toFixed(p),s.length > prec + 1)p--;
             if(p)
              {var i=s.length - 1;
               while(s.charAt(i) == "0")i--;
               if(s.charAt(i) == ".")i--;
               s = s.slice(0,i + 1)}}
           break
          }
      return caml_finish_formatting(f,s)}
    function caml_mount_autoload(name,f)
     {var path=caml_make_path(name),name=path.join("/") + "/";
      jsoo_mount_point.push({path:name,device:new MlFakeDevice(name,f)});
      return 0}
    function Base_int_math_int_clz(x){return Base_int_math_int32_clz(x)}
    function ml_z_fits_int64(z1)
     {z1 = bigInt(z1);
      return z1.compare(bigInt("9223372036854775807"))
              <=
              0
              &&
              z1.compare(bigInt("-9223372036854775808"))
              >=
              0
              ?1
              :0}
    function ml_z_equal(z1,z2){return bigInt(z1).equals(bigInt(z2))}
    function caml_bigstring_blit_ba_to_ba(ba1,pos1,ba2,pos2,len)
     {if(12 != ba1.kind)
       caml_invalid_argument("caml_bigstring_blit_ba_to_ba: kind mismatch");
      if(12 != ba2.kind)
       caml_invalid_argument("caml_bigstring_blit_ba_to_ba: kind mismatch");
      if(len == 0)return 0;
      var ofs1=ba1.offset(pos1),ofs2=ba2.offset(pos2);
      if(ofs1 + len > ba1.data.length)caml_array_bound_error();
      if(ofs2 + len > ba2.data.length)caml_array_bound_error();
      var slice=ba1.data.subarray(ofs1,ofs1 + len);
      ba2.data.set(slice,pos2);
      return 0}
    var caml_blit_bigstring_to_bigstring=caml_bigstring_blit_ba_to_ba;
    function ml_z_sqrt_rem(z)
     {z = bigInt(z);
      var zero=bigInt(0);
      if(z.lt(zero))
       caml_invalid_argument("Z.sqrt_rem: square root of a negative number");
      var
       root=bigInt(ml_z_root(z,2)),
       mul=root.multiply(root),
       diff=z.subtract(mul);
      return [0,ml_z_normalize(root),ml_z_normalize(diff)]}
    function caml_string_lessthan(s1,s2){return caml_bytes_lessthan(s1,s2)}
    function caml_string_greaterthan(s1,s2)
     {return caml_string_lessthan(s2,s1)}
    function caml_div(x,y)
     {if(y == 0)caml_raise_zero_divide();return x / y | 0}
    function caml_ba_set_1(ba,i0,v){ba.set(ba.offset(i0),v);return 0}
    function caml_fill_bigstring(buf,buf_off,buf_len,v)
     {var i;
      for(i = 0;i < buf_len;i++)caml_ba_set_1(buf,buf_off + i,v);
      return 0}
    function caml_ephe_get_data_copy(x)
     {return x[caml_ephe_data_offset] === undefined
              ?0
              :[0,caml_obj_dup(x[caml_ephe_data_offset])]}
    function ml_z_perfect_square(z)
     {z = bigInt(z);
      if(z.lt(bigInt(0)))return 0;
      var root=bigInt(ml_z_root(z,2));
      return root.multiply(root).eq(z)?1:0}
    function caml_sys_get_argv(a){return [0,caml_argv[1],caml_argv]}
    function caml_js_to_bool(x){return + x}
    function caml_gr_create_image(x,y)
     {var s=caml_gr_state_get();return s.context.createImageData(x,y)}
    var caml_ephe_get_key_copy=caml_weak_get_copy;
    function caml_lessthan(x,y){return + (caml_compare_val(x,y,false) < 0)}
    function caml_raw_backtrace_next_slot(){return 0}
    function ml_z_to_nativeint(z1){return ml_z_to_int(z1)}
    function caml_register_global(n,v,name_opt)
     {if(name_opt && joo_global_object.toplevelReloc)
       n = joo_global_object.toplevelReloc(name_opt);
      caml_global_data[n + 1] = v;
      if(name_opt)caml_global_data[name_opt] = v}
    function mult_nat(nat1,ofs1,len1,nat2,ofs2,len2,nat3,ofs3,len3)
     {var carry=0;
      for(var i=0;i < len3;i++)
       carry
       +=
       mult_digit_nat(nat1,ofs1 + i,len1 - i,nat2,ofs2,len2,nat3,ofs3 + i);
      return carry}
    function square_nat(nat1,ofs1,len1,nat2,ofs2,len2)
     {var carry=0;
      carry += add_nat(nat1,ofs1,len1,nat1,ofs1,len1,0);
      carry += mult_nat(nat1,ofs1,len1,nat2,ofs2,len2,nat2,ofs2,len2);
      return carry}
    function caml_js_from_float(x){return x}
    function caml_floatarray_create(len)
     {if(len < 0)caml_array_bound_error();
      var len=len + 1 | 0,b=new Array(len);
      b[0] = 254;
      for(var i=1;i < len;i++)b[i] = 0;
      return b}
    function caml_gc_stat(){return [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}
    function caml_sys_modify_argv(arg){caml_argv = arg;return 0}
    var caml_method_cache=[];
    function caml_get_public_method(obj,tag,cacheid)
     {var meths=obj[1],ofs=caml_method_cache[cacheid];
      if(ofs === null)
       for(var i=caml_method_cache.length;i < cacheid;i++)
        caml_method_cache[i] = 0;
      else
       if(meths[ofs] === tag)return meths[ofs - 1];
      var li=3,hi=meths[1] * 2 + 1,mi;
      while(li < hi)
       {mi = li + hi >> 1 | 1;if(tag < meths[mi + 1])hi = mi - 2;else li = mi}
      caml_method_cache[cacheid] = li + 1;
      return tag == meths[li + 1]?meths[li]:0}
    function caml_js_get_console()
     {var
       c=joo_global_object.console?joo_global_object.console:{},
       m=
        ["log",
         "debug",
         "info",
         "warn",
         "error",
         "assert",
         "dir",
         "dirxml",
         "trace",
         "group",
         "groupCollapsed",
         "groupEnd",
         "time",
         "timeEnd"];
      function f(){}
      for(var i=0;i < m.length;i++)if(! c[m[i]])c[m[i]] = f;
      return c}
    function caml_ml_open_descriptor_in(fd)
     {var data=caml_global_data.fds[fd];
      if(data.flags.wronly)caml_raise_sys_error("fd " + fd + " is writeonly");
      var
       channel=
        {file:data.file,
         offset:data.offset,
         fd:fd,
         opened:true,
         out:false,
         refill:null};
      caml_ml_channels[channel.fd] = channel;
      return channel.fd}
    function bigstring_of_typed_array(ba)
     {var
       ta=
        new
         (joo_global_object.Uint8Array)
         (ba.buffer,ba.byteOffset,ba.length * ba.BYTES_PER_ELEMENT);
      return caml_ba_create_unsafe(12,0,[ta.length],ta)}
    function caml_round_float(x){return Math.round(x)}
    function ml_z_of_bits(z1)
     {var r=bigInt.zero,base1=bigInt(256),base=bigInt.one;
      for(var i=0;i < caml_ml_string_length(z1);i++)
       {var d=caml_string_unsafe_get(z1,i);
        r = bigInt(base).multiply(d).add(r);
        base = bigInt(base).multiply(base1)}
      return ml_z_normalize(r)}
    function caml_ojs_new_arr(c,a)
     {switch(a.length)
       {case 0:return new c();
        case 1:return new c(a[0]);
        case 2:return new c(a[0],a[1]);
        case 3:return new c(a[0],a[1],a[2]);
        case 4:return new c(a[0],a[1],a[2],a[3]);
        case 5:return new c(a[0],a[1],a[2],a[3],a[4]);
        case 6:return new c(a[0],a[1],a[2],a[3],a[4],a[5]);
        case 7:return new c(a[0],a[1],a[2],a[3],a[4],a[5],a[6])
        }
      function F(){return c.apply(this,a)}
      F.prototype = c.prototype;
      return new F()}
    function complement_nat(nat,ofs,len)
     {for(var i=0;i < len;i++)
       nat.data[ofs + i] = (- 1 >>> 0) - (nat.data[ofs + i] >>> 0)}
    function ml_z_logxor(z1,z2)
     {return ml_z_normalize(bigInt(z1).xor(bigInt(z2)))}
    var caml_js_regexps={amp:/&/g,lt:/</g,quot:/\"/g,all:/[&<\"]/};
    function caml_js_html_escape(s)
     {if(! caml_js_regexps.all.test(s))return s;
      return s.replace(caml_js_regexps.amp,"&amp;").replace
               (caml_js_regexps.lt,"&lt;").replace
              (caml_js_regexps.quot,"&quot;")}
    function caml_ba_dim_2(ba){return caml_ba_dim(ba,1)}
    function caml_js_wrap_meth_callback_arguments(f)
     {return function()
       {var len=arguments.length,args=new Array(len);
        for(var i=0;i < len;i++)args[i] = arguments[i];
        return caml_call_gen(f,[this,args])}}
    function caml_sinh_float(x){return (Math.exp(x) - Math.exp(- x)) / 2}
    function caml_ldexp_float(x,exp)
     {exp |= 0;
      if(exp > 1023)
       {exp -= 1023;
        x *= Math.pow(2,1023);
        if(exp > 1023){exp -= 1023;x *= Math.pow(2,1023)}}
      if(exp < - 1023){exp += 1023;x *= Math.pow(2,- 1023)}
      x *= Math.pow(2,exp);
      return x}
    function caml_gr_state_set(ctx)
     {caml_gr_state = ctx;caml_gr_state_init();return 0}
    function caml_zarith_unmarshal(reader,sz)
     {var negate;
      switch(reader.read8u())
       {case 1:negate = true;break;
        case 0:negate = false;break;
        default:caml_failwith("input_value: z (malformed input)")}
      var len=reader.read32u(),x=bigInt(0);
      for(var i=0;i < len / 4;i++)
       {var y=bigInt(reader.read8u());
        y = y.add(reader.read8u() << 8);
        y = y.add(reader.read8u() << 16);
        y = y.add(reader.read8u() << 24 >>> 0);
        x = y.shiftLeft(i * 32).add(x)}
      if(negate)x = x.negate();
      sz[0] = len + 4;
      return ml_z_normalize(x)}
    function ml_z_trailing_zeros(z)
     {z = bigInt(z).abs();
      var zero=bigInt(0),one=bigInt(1);
      if(z.equals(zero))return 0x7fffffff;
      var i=0;
      z = z.xor(z.prev()).shiftRight(1);
      for(i = 0;! z.equals(bigInt.zero);i++)z = z.shiftRight(1);
      return i}
    function caml_js_wrap_callback_strict(arity,f)
     {return function()
       {var n=arguments.length;
        if(n == arity && f.length == arity)return f.apply(null,arguments);
        var args=new Array(arity),len=Math.min(arguments.length,arity);
        for(var i=0;i < len;i++)args[i] = arguments[i];
        return caml_call_gen(f,args)}}
    function caml_get_current_callstack(){return [0]}
    function land_digit_nat(nat1,ofs1,nat2,ofs2)
     {nat1.data[ofs1] &= nat2.data[ofs2];return 0}
    function caml_int64_mod(x,y){return x.mod(y)}
    function caml_obj_set_tag(x,tag){x[0] = tag;return 0}
    function caml_create_file_extern(name,content)
     {if(joo_global_object.caml_create_file)
       joo_global_object.caml_create_file(name,content);
      else
       {if(! joo_global_object.caml_fs_tmp)joo_global_object.caml_fs_tmp = [];
        joo_global_object.caml_fs_tmp.push({name:name,content:content})}
      return 0}
    function caml_int32_bswap(x)
     {return (x & 0x000000FF)
             <<
             24
             |
             (x & 0x0000FF00)
             <<
             8
             |
             (x & 0x00FF0000)
             >>>
             8
             |
             (x & 0xFF000000)
             >>>
             24}
    function win_startup(){}
    function caml_ba_set_3(ba,i0,i1,i2,v)
     {ba.set(ba.offset([i0,i1,i2]),v);return 0}
    function caml_js_instanceof(o,c){return o instanceof c}
    var caml_blit_bigstring_to_string=caml_bigstring_blit_ba_to_bytes;
    function nth_digit_nat_native(nat,ofs){return nat.data[ofs]}
    function set_digit_nat_native(nat,ofs,digit)
     {nat.data[ofs] = digit;return 0}
    function caml_string_set64(s,i,i64){return caml_bytes_set64(s,i,i64)}
    function caml_gr_state_create(canvas,w,h)
     {var context=canvas.getContext("2d");
      return {context:context,
              canvas:canvas,
              x:0,
              y:0,
              width:w,
              height:h,
              line_width:1,
              font:caml_string_of_jsbytes("fixed"),
              text_size:26,
              color:0x000000,
              title:caml_string_of_jsbytes("")}}
    function caml_js_wrap_callback(f)
     {return function()
       {var len=arguments.length;
        if(len > 0)
         {var args=new Array(len);
          for(var i=0;i < len;i++)args[i] = arguments[i];
          return caml_call_gen(f,args)}
        else
         return caml_call_gen(f,[undefined])}}
    function caml_gr_draw_arc(x,y,rx,ry,a1,a2)
     {var s=caml_gr_state_get();
      s.context.beginPath();
      caml_gr_arc_aux(s.context,x,s.height - y,rx,ry,a1,a2);
      s.context.stroke();
      return 0}
    function caml_ba_map_file(vfd,kind,layout,shared,dims,pos)
     {caml_failwith("caml_ba_map_file not implemented")}
    function caml_ba_map_file_bytecode(argv,argn)
     {return caml_ba_map_file(argv[0],argv[1],argv[2],argv[3],argv[4],argv[5])}
    function caml_ba_create_from(data1,data2,jstyp,kind,layout,dims)
     {if(data2 || caml_ba_get_size_per_element(kind) == 2)
       caml_invalid_argument
        ("caml_ba_create_from: use return caml_ba_create_unsafe");
      return caml_ba_create_unsafe(kind,layout,dims,data1)}
    function caml_tanh_float(x)
     {var y=Math.exp(x),z=Math.exp(- x);return (y - z) / (y + z)}
    function caml_gr_draw_str(str)
     {var s=caml_gr_state_get(),m=s.context.measureText(str),dx=m.width;
      s.context.fillText(str,s.x,s.height - s.y);
      s.x += dx | 0;
      return 0}
    function caml_gr_draw_string(str)
     {caml_gr_draw_str(caml_jsstring_of_string(str));return 0}
    function caml_gr_draw_char(c)
     {caml_gr_draw_str(String.fromCharCode(c));return 0}
    function caml_unmount(name)
     {var path=caml_make_path(name),name=path.join("/") + "/",idx=- 1;
      for(var i=0;i < jsoo_mount_point.length;i++)
       if(jsoo_mount_point[i].path == name)idx = i;
      if(idx > - 1)jsoo_mount_point.splice(idx,1);
      return 0}
    function caml_input_value_from_string(s,ofs)
     {var reader=new MlStringReader(s,typeof ofs == "number"?ofs:ofs[0]);
      return caml_input_value_from_reader(reader,ofs)}
    function caml_ml_pos_in_64(chanid)
     {return caml_int64_of_float(caml_ml_channels[chanid].offset)}
    function caml_gr_draw_image(im,x,y)
     {var s=caml_gr_state_get();
      if(! im.image)
       {var canvas=document.createElement("canvas");
        canvas.width = s.width;
        canvas.height = s.height;
        canvas.getContext("2d").putImageData(im,0,0);
        var image=new (joo_global_object.Image)();
        image.onload
        =
        function()
         {s.context.drawImage(image,x,s.height - im.height - y);
          im.image = image};
        image.src = canvas.toDataURL("image/png")}
      else
       s.context.drawImage(im.image,x,s.height - im.height - y);
      return 0}
    function caml_register_channel_for_spacetime(_channel){return 0}
    function caml_string_set(s,i,c)
     {if(i >>> 0 >= s.l)caml_string_bound_error();
      return caml_string_unsafe_set(s,i,c)}
    function caml_ml_pos_out(chanid)
     {caml_ml_flush(chanid);return caml_ml_channels[chanid].offset}
    function caml_spacetime_enabled(_unit){return 0}
    function caml_bytes_notequal(s1,s2){return 1 - caml_string_equal(s1,s2)}
    function caml_runtime_parameters(_unit){return caml_string_of_jsbytes("")}
    function caml_js_object(a)
     {var o={};
      for(var i=1;i < a.length;i++)
       {var p=a[i];o[caml_jsstring_of_string(p[1])] = p[2]}
      return o}
    function caml_ba_create(kind,layout,dims_ml)
     {var
       dims=caml_js_from_array(dims_ml),
       data=caml_ba_create_buffer(kind,caml_ba_get_size(dims));
      return caml_ba_create_unsafe(kind,layout,dims,data)}
    function caml_weak_blit(a1,i1,a2,i2,len)
     {caml_array_blit
       (a1,caml_ephe_key_offset + i1 - 1,a2,caml_ephe_key_offset + i2 - 1,len);
      return 0}
    function caml_gr_remember_mode()
     {caml_failwith("caml_gr_remember_mode not Implemented")}
    function Base_internalhash_get_hash_value(seed)
     {var h=caml_hash_mix_final(seed);return h & 0x3FFFFFFF}
    function caml_bswap16(x){return (x & 0x00FF) << 8 | (x & 0xFF00) >> 8}
    function caml_ml_set_binary_mode(chanid,mode)
     {var chan=caml_ml_channels[chanid],data=caml_global_data.fds[chan.fd];
      data.flags.text = ! mode;
      data.flags.binary = mode;
      return 0}
    function caml_final_register(){return 0}
    function caml_check_alignment_bigstring(buf,ofs,alignment){return true}
    function caml_gr_draw_rect(x,y,w,h)
     {var s=caml_gr_state_get();
      s.context.strokeRect(x,s.height - y,w,- h);
      return 0}
    function caml_string_get16(s,i)
     {if(i >>> 0 >= caml_ml_string_length(s) - 1)caml_string_bound_error();
      var b1=caml_string_unsafe_get(s,i),b2=caml_string_unsafe_get(s,i + 1);
      return b2 << 8 | b1}
    function caml_ephe_unset_data(x,data)
     {x[caml_ephe_data_offset] = undefined;return 0}
    function caml_output_value(chanid,v,flags)
     {var s=caml_output_value_to_string(v,flags);
      caml_ml_output(chanid,s,0,caml_ml_string_length(s));
      return 0}
    function caml_ba_get_3(ba,i0,i1,i2){return ba.get(ba.offset([i0,i1,i2]))}
    var caml_ephe_blit_key=caml_weak_blit;
    function ml_z_to_int32(z1){return ml_z_to_int(z1)}
    function Base_clear_caml_backtrace_pos(x){return 0}
    function caml_check_bound(array,index)
     {if(index >>> 0 >= array.length - 1)caml_array_bound_error();
      return array}
    function caml_compare_bigstring(buf1,buf1_off,buf2,buf2_off,len)
     {var i,r;
      for(i = 0;i < len;i++)
       {r
        =
        caml_int_compare
         (caml_ba_get_1(buf1,buf1_off + i),caml_ba_get_1(buf2,buf2_off + i));
        if(r != 0)return r}
      return 0}
    function ml_z_compare(z1,z2){return bigInt(z1).compare(bigInt(z2))}
    function caml_obj_tag(x)
     {if(x instanceof Array && x[0] == x[0] >>> 0)
       return x[0];
      else
       if(caml_is_ml_bytes(x))
        return 252;
       else
        if(caml_is_ml_string(x))
         return 252;
        else
         if(x instanceof Function || typeof x == "function")
          return 247;
         else
          if(x && x.caml_custom)return 255;else return 1000}
    function caml_ba_to_typed_array(ba){return ba.data}
    function caml_js_export_var()
     {return typeof module !== "undefined" && module && module.exports
              ?module.exports
              :joo_global_object}
    function caml_bytes_get32(s,i)
     {if(i >>> 0 >= s.l - 3)caml_bytes_bound_error();
      var
       b1=caml_bytes_unsafe_get(s,i),
       b2=caml_bytes_unsafe_get(s,i + 1),
       b3=caml_bytes_unsafe_get(s,i + 2),
       b4=caml_bytes_unsafe_get(s,i + 3);
      return b4 << 24 | b3 << 16 | b2 << 8 | b1}
    function caml_frexp_float(x)
     {if(x == 0 || ! isFinite(x))return [0,x,0];
      var neg=x < 0;
      if(neg)x = - x;
      var exp=Math.max(- 1023,jsoo_floor_log2(x) + 1);
      x *= Math.pow(2,- exp);
      while(x < 0.5){x *= 2;exp--}
      while(x >= 1){x *= 0.5;exp++}
      if(neg)x = - x;
      return [0,x,exp]}
    function caml_ojs_wrap_fun_arguments(f)
     {return function(){return caml_js_wrap_callback(f)(arguments)}}
    function ml_z_pred(z1){return ml_z_normalize(bigInt(z1).prev())}
    function caml_string_get64(s,i)
     {if(i >>> 0 >= caml_ml_string_length(s) - 7)caml_string_bound_error();
      var a=new Array(8);
      for(var j=0;j < 8;j++)a[7 - j] = caml_string_unsafe_get(s,i + j);
      return caml_int64_of_bytes(a)}
    function caml_ml_pos_out_64(chanid)
     {caml_ml_flush(chanid);
      return caml_int64_of_float(caml_ml_channels[chanid].offset)}
    function ml_z_extract(z1,pos,len)
     {z1 = bigInt(z1);
      return ml_z_normalize
              (z1.shiftRight(pos).and(bigInt(2).pow(len).subtract(1)))}
    function ml_z_of_float(f1)
     {if(f1 == Infinity || f1 == - Infinity || f1 != f1)
       caml_raise_constant(caml_named_value("ml_z_overflow"));
      return ml_z_normalize(bigInt(f1 < 0?Math.ceil(f1):Math.floor(f1)))}
    function ml_z_lognot(z1){return ml_z_normalize(bigInt(z1).not())}
    function caml_gr_close_subwindow(a)
     {caml_failwith("caml_gr_close_subwindow not Implemented")}
    function caml_set_static_env(k,v)
     {if(! joo_global_object.jsoo_static_env)
       joo_global_object.jsoo_static_env = {};
      joo_global_object.jsoo_static_env[k] = v;
      return 0}
    function caml_ba_change_layout(ba,layout)
     {if(ba.layout == layout)return ba;
      var new_dims=[];
      for(var i=0;i < ba.dims.length;i++)
       new_dims[i] = ba.dims[ba.dims.length - i - 1];
      return caml_ba_create_unsafe(ba.kind,layout,new_dims,ba.data)}
    function Base_hash_double(d){return caml_hash(1,1,0,d)}
    function caml_js_new(c,a)
     {switch(a.length)
       {case 1:return new c();
        case 2:return new c(a[1]);
        case 3:return new c(a[1],a[2]);
        case 4:return new c(a[1],a[2],a[3]);
        case 5:return new c(a[1],a[2],a[3],a[4]);
        case 6:return new c(a[1],a[2],a[3],a[4],a[5]);
        case 7:return new c(a[1],a[2],a[3],a[4],a[5],a[6]);
        case 8:return new c(a[1],a[2],a[3],a[4],a[5],a[6],a[7])
        }
      function F(){return c.apply(this,caml_js_from_array(a))}
      F.prototype = c.prototype;
      return new F()}
    function caml_gr_current_y(){var s=caml_gr_state_get();return s.y}
    function caml_format_int(fmt,i)
     {if(caml_jsbytes_of_string(fmt) == "%d")
       return caml_string_of_jsbytes("" + i);
      var f=caml_parse_format(fmt);
      if(i < 0)if(f.signedconv){f.sign = - 1;i = - i}else i >>>= 0;
      var s=i.toString(f.base);
      if(f.prec >= 0)
       {f.filler = " ";
        var n=f.prec - s.length;
        if(n > 0)s = caml_str_repeat(n,"0") + s}
      return caml_finish_formatting(f,s)}
    function caml_obj_truncate(x,s)
     {if(s <= 0 || s + 1 > x.length)caml_invalid_argument("Obj.truncate");
      if(x.length != s + 1)x.length = s + 1;
      return 0}
    function is_digit_odd(nat,ofs){if(nat.data[ofs] & 1)return 1;return 0}
    function caml_runtime_variant(_unit){return caml_string_of_jsbytes("")}
    function caml_ml_open_descriptor_out(fd)
     {var data=caml_global_data.fds[fd];
      if(data.flags.rdonly)caml_raise_sys_error("fd " + fd + " is readonly");
      var
       channel=
        {file:data.file,
         offset:data.offset,
         fd:fd,
         opened:true,
         out:true,
         buffer:""};
      caml_ml_channels[channel.fd] = channel;
      return channel.fd}
    function caml_array_concat(l)
     {var a=[0];
      while(l !== 0)
       {var b=l[1];for(var i=1;i < b.length;i++)a.push(b[i]);l = l[2]}
      return a}
    function caml_gr_open_graph(info)
     {var g=joo_global_object,info=caml_jsstring_of_string(info);
      function get(name)
       {var res=info.match("(^|,) *" + name + " *= *([a-zA-Z0-9_]+) *(,|$)");
        if(res)return res[2]}
      var specs=[];
      if(! (info == ""))specs.push(info);
      var target=get("target");
      if(! target)target = "";
      var status=get("status");
      if(! status)specs.push("status=1");
      var w=get("width");
      w = w?parseInt(w):200;
      specs.push("width=" + w);
      var h=get("height");
      h = h?parseInt(h):200;
      specs.push("height=" + h);
      var win=g.open("about:blank",target,specs.join(","));
      if(! win)caml_failwith("Graphics.open_graph: cannot open the window");
      var doc=win.document,canvas=doc.createElement("canvas");
      canvas.width = w;
      canvas.height = h;
      var ctx=caml_gr_state_create(canvas,w,h);
      ctx.set_title = function(title){doc.title = title};
      caml_gr_state_set(ctx);
      var body=doc.body;
      body.style.margin = "0px";
      body.appendChild(canvas);
      return 0}
    function caml_ephe_set_data(x,data)
     {x[caml_ephe_data_offset] = data;return 0}
    function caml_make_float_vect(len)
     {if(len < 0)caml_array_bound_error();
      var len=len + 1 | 0,b=new Array(len);
      b[0] = 254;
      for(var i=1;i < len;i++)b[i] = 0;
      return b}
    function caml_greaterequal(x,y)
     {return + (caml_compare_val(x,y,false) >= 0)}
    function ml_z_numbits(z1)
     {z1 = bigInt(z1).abs();
      var n=0,upperBound=bigInt.one;
      while(upperBound.leq(z1)){n += 1;upperBound = upperBound.multiply(2)}
      return n}
    function caml_get_exception_raw_backtrace(){return [0]}
    function caml_log1p_float(x)
     {var y=1 + x,z=y - 1;return z == 0?x:x * Math.log(y) / z}
    function caml_int64_or(x,y){return x.or(y)}
    function caml_lazy_make_forward(v){return [250,v]}
    function lor_digit_nat(nat1,ofs1,nat2,ofs2)
     {nat1.data[ofs1] |= nat2.data[ofs2];return 0}
    function caml_gr_blit_image(im,x,y)
     {var
       s=caml_gr_state_get(),
       im2=
        s.context.getImageData(x,s.height - im.height - y,im.width,im.height);
      for(var i=0;i < im2.data.length;i += 4)
       {im.data[i] = im2.data[i];
        im.data[i + 1] = im2.data[i + 1];
        im.data[i + 2] = im2.data[i + 2];
        im.data[i + 3] = im2.data[i + 3]}
      return 0}
    function caml_gr_window_id(a)
     {caml_failwith("caml_gr_window_id not Implemented")}
    function caml_js_on_ie()
     {var
       ua=
        joo_global_object.navigator?joo_global_object.navigator.userAgent:"";
      return ua.indexOf("MSIE") != - 1 && ua.indexOf("Opera") != 0}
    function caml_int64_shift_right(x,s){return x.shift_right(s)}
    function caml_ba_layout(ba){return ba.layout}
    function caml_convert_raw_backtrace(){return [0]}
    function caml_array_set(array,index,newval)
     {if(index < 0 || index >= array.length - 1)caml_array_bound_error();
      array[index + 1] = newval;
      return 0}
    function caml_bytes_greaterequal(s1,s2)
     {return caml_bytes_lessequal(s2,s1)}
    function ml_z_perfect_power(z)
     {z = bigInt(z);
      var zero=bigInt(0),one=bigInt(1);
      if(z.equals(zero) || z.equals(one) || z.equals(one.negate()))return 1;
      var log2z=ml_z_numbits(z.abs());
      for(var b=2;b <= log2z;b++)
       {if(z.lt(zero) && b % 2 == 0)continue;
        var zp=z.abs(),p=bigInt(ml_z_root(zp,b));
        if(z.lt(zero))p = p.negate();
        var r=bigInt(ml_z_pow(p,b));
        if(z.equals(r))return 1}
      return 0}
    function set_digit_nat(nat,ofs,digit){nat.data[ofs] = digit;return 0}
    function caml_update_dummy(x,y)
     {if(typeof y === "function"){x.fun = y;return 0}
      if(y.fun){x.fun = y.fun;return 0}
      var i=y.length;
      while(i--)x[i] = y[i];
      return 0}
    function caml_CamlinternalMod_update_mod(shape,real,x)
     {if(typeof shape === "number")
       switch(shape){case 0:case 1:case 2:default:caml_update_dummy(real,x)}
      else
       switch(shape[0])
        {case 0:
          for(var i=1;i < shape[1].length;i++)
           caml_CamlinternalMod_update_mod(shape[1][i],real[i],x[i]);
          break
         }
      return 0}
    function ml_z_init(unit)
     {caml_custom_ops["_z"]
      =
      {serialize:caml_zarith_marshal,
       deserialize:caml_zarith_unmarshal,
       hash:ml_z_hash};
      return 0}
    function caml_gr_doc_of_state(state)
     {if(state.canvas.ownerDocument)return state.canvas.ownerDocument}
    function caml_ml_output_int(chanid,i)
     {var
       arr=[i >> 24 & 0xFF,i >> 16 & 0xFF,i >> 8 & 0xFF,i & 0xFF],
       s=caml_string_of_array(arr);
      caml_ml_output(chanid,s,0,4);
      return 0}
    function caml_obj_with_tag(tag,x)
     {var l=x.length,a=new Array(l);
      a[0] = tag;
      for(var i=1;i < l;i++)a[i] = x[i];
      return a}
    var caml_initial_time=new Date().getTime() * 0.001;
    function caml_sys_time()
     {var now=new Date().getTime();return now * 0.001 - caml_initial_time}
    function caml_ml_channel_size(chanid)
     {var chan=caml_ml_channels[chanid];return chan.file.length()}
    function caml_raw_backtrace_slot()
     {caml_invalid_argument
       ("Printexc.get_raw_backtrace_slot: index out of bounds")}
    function caml_hexstring_of_float(x,prec,style)
     {if(! isFinite(x))
       {if(isNaN(x))return caml_string_of_jsstring("nan");
        return caml_string_of_jsstring(x > 0?"infinity":"-infinity")}
      var sign=x == 0 && 1 / x == - Infinity?1:x >= 0?0:1;
      if(sign)x = - x;
      var exp=0;
      if(x == 0)
       ;
      else
       if(x < 1)
        while(x < 1 && exp > - 1022){x *= 2;exp--}
       else
        while(x >= 2){x /= 2;exp++}
      var exp_sign=exp < 0?"":"+",sign_str="";
      if(sign)
       sign_str = "-";
      else
       switch(style)
        {case 43:sign_str = "+";break;
         case 32:sign_str = " ";break;
         default:break}
      if(prec >= 0 && prec < 13)
       {var cst=Math.pow(2,prec * 4);x = Math.round(x * cst) / cst}
      var x_str=x.toString(16);
      if(prec >= 0)
       {var idx=x_str.indexOf(".");
        if(idx < 0)
         x_str += "." + caml_str_repeat(prec,"0");
        else
         {var size=idx + 1 + prec;
          if(x_str.length < size)
           x_str += caml_str_repeat(size - x_str.length,"0");
          else
           x_str = x_str.substr(0,size)}}
      return caml_string_of_jsstring
              (sign_str + "0x" + x_str + "p" + exp_sign + exp.toString(10))}
    function caml_js_wrap_meth_callback_strict(arity,f)
     {return function()
       {var args=new Array(arity + 1),len=Math.min(arguments.length,arity);
        args[0] = this;
        for(var i=0;i < len;i++)args[i + 1] = arguments[i];
        return caml_call_gen(f,args)}}
    function ml_z_format(fmt,z1)
     {z1 = bigInt(z1);
      var
       fmt=fmt.toString(),
       base=10,
       cas=0,
       width=0,
       alt=0,
       dir=0,
       sign="",
       pad=" ",
       idx=0,
       prefix="";
      while(fmt[idx] == "%")idx++;
      for(;;idx++)
       if(fmt[idx] == "#")
        alt = 1;
       else
        if(fmt[idx] == "0")
         pad = "0";
        else
         if(fmt[idx] == "-")
          dir = 1;
         else
          if(fmt[idx] == " " || fmt[idx] == "+")sign = fmt[idx];else break;
      if(z1.lt(bigInt(0))){sign = "-";z1 = z1.negate()}
      for(;fmt[idx] >= "0" && fmt[idx] <= "9";idx++)
       width = 10 * width + + fmt[idx];
      switch(fmt[idx])
       {case "i":
        case "d":
        case "u":break;
        case "b":base = 2;if(alt)prefix = "0b";break;
        case "o":base = 8;if(alt)prefix = "0o";break;
        case "x":base = 16;if(alt)prefix = "0x";break;
        case "X":base = 16;if(alt)prefix = "0X";cas = 1;break;
        default:caml_failwith("Unsupported format '" + fmt + "'")}
      if(dir)pad = " ";
      var res=z1.toString(base);
      if(cas === 1)res = res.toUpperCase();
      var size=res.length;
      if(pad == " ")
       if(dir)
        {res = sign + prefix + res;for(;res.length < width;)res = res + pad}
       else
        {res = sign + prefix + res;for(;res.length < width;)res = pad + res}
      else
       {var pre=sign + prefix;
        for(;res.length + pre.length < width;)res = pad + res;
        res = pre + res}
      return caml_new_string(res)}
    function ml_z_size(z1)
     {return bigInt(z1).toArray(Math.pow(2,32)).value.length}
    function ml_z_to_int64(z1)
     {z1 = bigInt(z1);
      if(! ml_z_fits_int64(z1))
       caml_raise_constant(caml_named_value("ml_z_overflow"));
      var
       a=z1.and(bigInt(0xffffff)).toJSNumber() | 0,
       b=z1.shiftRight(24).and(bigInt(0xffffff)).toJSNumber() | 0,
       c=z1.shiftRight(48).and(bigInt(0xffff)).toJSNumber() | 0,
       x=[255,a,b,c];
      return x}
    function caml_backtrace_status(){return 0}
    function caml_install_signal_handler(){return 0}
    function caml_sys_argv(a){return caml_argv}
    function caml_ba_fill(ba,v){ba.fill(v);return 0}
    function caml_modf_float(x)
     {if(isFinite(x))
       {var neg=1 / x < 0;
        x = Math.abs(x);
        var i=Math.floor(x),f=x - i;
        if(neg){i = - i;f = - f}
        return [0,f,i]}
      if(isNaN(x))return [0,NaN,NaN];
      return [0,1 / x,x]}
    function caml_gc_get(){return [0,0,0,0,0,0,0,0,0]}
    function caml_float_compare(x,y)
     {if(x === y)return 0;
      if(x < y)return - 1;
      if(x > y)return 1;
      if(x === x)return 1;
      if(y === y)return - 1;
      return 0}
    function ml_z_shift_right_trunc(z1,z2)
     {return ml_z_div(bigInt(z1),bigInt(2).pow(z2))}
    function caml_string_set32(s,i,i32){return caml_bytes_set32(s,i,i32)}
    function caml_parse_engine(tables,env,cmd,arg)
     {var
       ERRCODE=256,
       loop=6,
       testshift=7,
       shift=8,
       shift_recover=9,
       reduce=10,
       READ_TOKEN=0,
       RAISE_PARSE_ERROR=1,
       GROW_STACKS_1=2,
       GROW_STACKS_2=3,
       COMPUTE_SEMANTIC_ACTION=4,
       CALL_ERROR_FUNCTION=5,
       env_s_stack=1,
       env_v_stack=2,
       env_symb_start_stack=3,
       env_symb_end_stack=4,
       env_stacksize=5,
       env_stackbase=6,
       env_curr_char=7,
       env_lval=8,
       env_symb_start=9,
       env_symb_end=10,
       env_asp=11,
       env_rule_len=12,
       env_rule_number=13,
       env_sp=14,
       env_state=15,
       env_errflag=16,
       tbl_transl_const=2,
       tbl_transl_block=3,
       tbl_lhs=4,
       tbl_len=5,
       tbl_defred=6,
       tbl_dgoto=7,
       tbl_sindex=8,
       tbl_rindex=9,
       tbl_gindex=10,
       tbl_tablesize=11,
       tbl_table=12,
       tbl_check=13;
      if(! tables.dgoto)
       {tables.defred = caml_lex_array(tables[tbl_defred]);
        tables.sindex = caml_lex_array(tables[tbl_sindex]);
        tables.check = caml_lex_array(tables[tbl_check]);
        tables.rindex = caml_lex_array(tables[tbl_rindex]);
        tables.table = caml_lex_array(tables[tbl_table]);
        tables.len = caml_lex_array(tables[tbl_len]);
        tables.lhs = caml_lex_array(tables[tbl_lhs]);
        tables.gindex = caml_lex_array(tables[tbl_gindex]);
        tables.dgoto = caml_lex_array(tables[tbl_dgoto])}
      var
       res=0,
       n,
       n1,
       n2,
       state1,
       sp=env[env_sp],
       state=env[env_state],
       errflag=env[env_errflag];
      exit:
      for(;;)
       switch(cmd)
        {case 0:state = 0;errflag = 0;
         case 6:
          n = tables.defred[state];
          if(n != 0){cmd = reduce;break}
          if(env[env_curr_char] >= 0){cmd = testshift;break}
          res = READ_TOKEN;
          break exit;
         case 1:
          if(arg instanceof Array)
           {env[env_curr_char] = tables[tbl_transl_block][arg[0] + 1];
            env[env_lval] = arg[1]}
          else
           {env[env_curr_char] = tables[tbl_transl_const][arg + 1];
            env[env_lval] = 0}
         case 7:
          n1 = tables.sindex[state];
          n2 = n1 + env[env_curr_char];
          if
           (n1
            !=
            0
            &&
            n2
            >=
            0
            &&
            n2
            <=
            tables[tbl_tablesize]
            &&
            tables.check[n2]
            ==
            env[env_curr_char])
           {cmd = shift;break}
          n1 = tables.rindex[state];
          n2 = n1 + env[env_curr_char];
          if
           (n1
            !=
            0
            &&
            n2
            >=
            0
            &&
            n2
            <=
            tables[tbl_tablesize]
            &&
            tables.check[n2]
            ==
            env[env_curr_char])
           {n = tables.table[n2];cmd = reduce;break}
          if(errflag <= 0){res = CALL_ERROR_FUNCTION;break exit}
         case 5:
          if(errflag < 3)
           {errflag = 3;
            for(;;)
             {state1 = env[env_s_stack][sp + 1];
              n1 = tables.sindex[state1];
              n2 = n1 + ERRCODE;
              if
               (n1
                !=
                0
                &&
                n2
                >=
                0
                &&
                n2
                <=
                tables[tbl_tablesize]
                &&
                tables.check[n2]
                ==
                ERRCODE)
               {cmd = shift_recover;break}
              else
               {if(sp <= env[env_stackbase])return RAISE_PARSE_ERROR;sp--}}}
          else
           {if(env[env_curr_char] == 0)return RAISE_PARSE_ERROR;
            env[env_curr_char] = - 1;
            cmd = loop;
            break}
         case 8:env[env_curr_char] = - 1;if(errflag > 0)errflag--;
         case 9:
          state = tables.table[n2];
          sp++;
          if(sp >= env[env_stacksize]){res = GROW_STACKS_1;break exit}
         case 2:
          env[env_s_stack][sp + 1] = state;
          env[env_v_stack][sp + 1] = env[env_lval];
          env[env_symb_start_stack][sp + 1] = env[env_symb_start];
          env[env_symb_end_stack][sp + 1] = env[env_symb_end];
          cmd = loop;
          break;
         case 10:
          var m=tables.len[n];
          env[env_asp] = sp;
          env[env_rule_number] = n;
          env[env_rule_len] = m;
          sp = sp - m + 1;
          m = tables.lhs[n];
          state1 = env[env_s_stack][sp];
          n1 = tables.gindex[m];
          n2 = n1 + state1;
          if
           (n1
            !=
            0
            &&
            n2
            >=
            0
            &&
            n2
            <=
            tables[tbl_tablesize]
            &&
            tables.check[n2]
            ==
            state1)
           state = tables.table[n2];
          else
           state = tables.dgoto[m];
          if(sp >= env[env_stacksize]){res = GROW_STACKS_2;break exit}
         case 3:res = COMPUTE_SEMANTIC_ACTION;break exit;
         case 4:
          env[env_s_stack][sp + 1] = state;
          env[env_v_stack][sp + 1] = arg;
          var asp=env[env_asp];
          env[env_symb_end_stack][sp + 1] = env[env_symb_end_stack][asp + 1];
          if(sp > asp)
           env[env_symb_start_stack][sp + 1]
           =
           env[env_symb_end_stack][asp + 1];
          cmd = loop;
          break;
         default:return RAISE_PARSE_ERROR}
      env[env_sp] = sp;
      env[env_state] = state;
      env[env_errflag] = errflag;
      return res}
    function caml_array_fill(array,ofs,len,v)
     {for(var i=0;i < len;i++)array[ofs + i + 1] = v;return 0}
    function ml_z_install_frametable(unit){return 0}
    function caml_string_notequal(s1,s2){return 1 - caml_string_equal(s1,s2)}
    function caml_bytes_greaterthan(s1,s2){return caml_bytes_lessthan(s2,s1)}
    function caml_gr_make_image(arr)
     {var
       s=caml_gr_state_get(),
       h=arr.length - 1,
       w=arr[1].length - 1,
       im=s.context.createImageData(w,h);
      for(var i=0;i < h;i++)
       for(var j=0;j < w;j++)
        {var c=arr[i + 1][j + 1],o=i * (w * 4) + j * 4;
         if(c == - 1)
          {im.data[o + 0] = 0;
           im.data[o + 1] = 0;
           im.data[o + 2] = 0;
           im.data[o + 3] = 0}
         else
          {im.data[o + 0] = c >> 16 & 0xff;
           im.data[o + 1] = c >> 8 & 0xff;
           im.data[o + 2] = c >> 0 & 0Xff;
           im.data[o + 3] = 0xff}}
      return im}
    function Base_int_math_int_popcount(v)
     {v = v - (v >>> 1 & 0x55555555);
      v = (v & 0x33333333) + (v >>> 2 & 0x33333333);
      return (v + (v >>> 4) & 0xF0F0F0F) * 0x1010101 >>> 24}
    function caml_ml_set_channel_output(chanid,f)
     {var chan=caml_ml_channels[chanid];
      caml_global_data.fds[chan.fd].output = f;
      return 0}
    function caml_read_file_content(name)
     {var root=resolve_fs_device(name);
      if(root.device.exists(root.rest))
       {var
         file=root.device.open(root.rest,{rdonly:1}),
         len=file.length(),
         buf=caml_create_bytes(len);
        file.read(0,buf,0,len);
        return caml_string_of_bytes(buf)}
      caml_raise_no_such_file(name)}
    function caml_js_to_float(x){return x}
    joo_global_object.jsoo_runtime
    =
    {caml_ojs_iterate_properties:caml_ojs_iterate_properties,
     caml_ojs_wrap_fun_arguments:caml_ojs_wrap_fun_arguments,
     caml_check_alignment_bigstring:caml_check_alignment_bigstring,
     caml_fill_bigstring:caml_fill_bigstring,
     caml_compare_bigstring:caml_compare_bigstring,
     caml_blit_string_to_bigstring:caml_blit_string_to_bigstring,
     caml_blit_bigstring_to_string:caml_blit_bigstring_to_string,
     caml_blit_bigstring_to_bigstring:caml_blit_bigstring_to_bigstring,
     Base_am_testing:Base_am_testing,
     Base_hash_double:Base_hash_double,
     Base_hash_string:Base_hash_string,
     Base_int_math_int64_pow_stub:Base_int_math_int64_pow_stub,
     Base_int_math_int_pow_stub:Base_int_math_int_pow_stub,
     Base_int_math_int64_clz:Base_int_math_int64_clz,
     Base_int_math_nativeint_clz:Base_int_math_nativeint_clz,
     Base_int_math_int_clz:Base_int_math_int_clz,
     Base_int_math_int32_clz:Base_int_math_int32_clz,
     Base_clear_caml_backtrace_pos:Base_clear_caml_backtrace_pos,
     Base_int_math_int_popcount:Base_int_math_int_popcount,
     Base_internalhash_get_hash_value:Base_internalhash_get_hash_value,
     Base_internalhash_fold_string:Base_internalhash_fold_string,
     Base_internalhash_fold_float:Base_internalhash_fold_float,
     Base_internalhash_fold_int:Base_internalhash_fold_int,
     Base_internalhash_fold_int64:Base_internalhash_fold_int64,
     caml_zarith_unmarshal:caml_zarith_unmarshal,
     caml_zarith_marshal:caml_zarith_marshal,
     ml_z_divexact:ml_z_divexact,
     ml_z_size:ml_z_size,
     ml_z_hamdist:ml_z_hamdist,
     ml_z_popcount:ml_z_popcount,
     ml_z_trailing_zeros:ml_z_trailing_zeros,
     ml_z_sqrt_rem:ml_z_sqrt_rem,
     ml_z_sqrt:ml_z_sqrt,
     ml_z_gcdext_intern:ml_z_gcdext_intern,
     ml_z_extract:ml_z_extract,
     ml_z_nextprime:ml_z_nextprime,
     ml_z_probab_prime:ml_z_probab_prime,
     ml_z_perfect_square:ml_z_perfect_square,
     ml_z_perfect_power:ml_z_perfect_power,
     ml_z_invert:ml_z_invert,
     ml_z_root:ml_z_root,
     ml_z_powm_sec:ml_z_powm_sec,
     ml_z_of_bits:ml_z_of_bits,
     ml_z_to_bits:ml_z_to_bits,
     ml_z_hash:ml_z_hash,
     ml_z_pow:ml_z_pow,
     ml_z_powm:ml_z_powm,
     ml_z_fits_nativeint:ml_z_fits_nativeint,
     ml_z_fits_int64:ml_z_fits_int64,
     ml_z_fits_int32:ml_z_fits_int32,
     ml_z_fits_int:ml_z_fits_int,
     ml_z_numbits:ml_z_numbits,
     ml_z_gcd:ml_z_gcd,
     ml_z_sign:ml_z_sign,
     ml_z_equal:ml_z_equal,
     ml_z_compare:ml_z_compare,
     ml_z_of_substring_base:ml_z_of_substring_base,
     jsoo_z_of_js_string_base:jsoo_z_of_js_string_base,
     ml_z_format:ml_z_format,
     ml_z_to_nativeint:ml_z_to_nativeint,
     ml_z_testbit:ml_z_testbit,
     ml_z_to_int64:ml_z_to_int64,
     ml_z_to_int32:ml_z_to_int32,
     ml_z_to_int:ml_z_to_int,
     ml_z_of_float:ml_z_of_float,
     ml_z_of_int64:ml_z_of_int64,
     ml_z_of_nativeint:ml_z_of_nativeint,
     ml_z_of_int32:ml_z_of_int32,
     ml_z_of_int:ml_z_of_int,
     ml_z_shift_right_trunc:ml_z_shift_right_trunc,
     ml_z_shift_right:ml_z_shift_right,
     ml_z_shift_left:ml_z_shift_left,
     ml_z_lognot:ml_z_lognot,
     ml_z_logxor:ml_z_logxor,
     ml_z_logor:ml_z_logor,
     ml_z_logand:ml_z_logand,
     ml_z_abs:ml_z_abs,
     ml_z_pred:ml_z_pred,
     ml_z_succ:ml_z_succ,
     ml_z_div_rem:ml_z_div_rem,
     ml_z_rem:ml_z_rem,
     ml_z_fdiv:ml_z_fdiv,
     ml_z_cdiv:ml_z_cdiv,
     ml_z_div:ml_z_div,
     ml_z_mul:ml_z_mul,
     ml_z_sub:ml_z_sub,
     ml_z_add:ml_z_add,
     ml_z_neg:ml_z_neg,
     ml_z_install_frametable:ml_z_install_frametable,
     ml_z_init:ml_z_init,
     ml_z_normalize:ml_z_normalize,
     bigInt:bigInt,
     caml_ephe_check_data:caml_ephe_check_data,
     caml_ephe_unset_data:caml_ephe_unset_data,
     caml_ephe_set_data:caml_ephe_set_data,
     caml_ephe_get_data_copy:caml_ephe_get_data_copy,
     caml_ephe_get_data:caml_ephe_get_data,
     caml_ephe_blit_data:caml_ephe_blit_data,
     caml_ephe_unset_key:caml_ephe_unset_key,
     caml_ephe_set_key:caml_ephe_set_key,
     caml_ephe_check_key:caml_ephe_check_key,
     caml_ephe_get_key_copy:caml_ephe_get_key_copy,
     caml_ephe_get_key:caml_ephe_get_key,
     caml_ephe_blit_key:caml_ephe_blit_key,
     caml_ephe_create:caml_ephe_create,
     caml_weak_blit:caml_weak_blit,
     caml_weak_check:caml_weak_check,
     caml_weak_get_copy:caml_weak_get_copy,
     caml_weak_get:caml_weak_get,
     caml_weak_set:caml_weak_set,
     caml_weak_create:caml_weak_create,
     caml_ephe_data_offset:caml_ephe_data_offset,
     caml_ephe_key_offset:caml_ephe_key_offset,
     unix_isatty:unix_isatty,
     win_handle_fd:win_handle_fd,
     win_cleanup:win_cleanup,
     win_startup:win_startup,
     unix_mktime:unix_mktime,
     unix_localtime:unix_localtime,
     unix_gmtime:unix_gmtime,
     unix_time:unix_time,
     unix_gettimeofday:unix_gettimeofday,
     re_replacement_text:re_replacement_text,
     re_partial_match:re_partial_match,
     re_string_match:re_string_match,
     re_search_backward:re_search_backward,
     re_search_forward:re_search_forward,
     re_match:re_match,
     caml_spacetime_only_works_for_native_code:
     caml_spacetime_only_works_for_native_code,
     caml_register_channel_for_spacetime:caml_register_channel_for_spacetime,
     caml_spacetime_enabled:caml_spacetime_enabled,
     caml_ml_runtime_warnings_enabled:caml_ml_runtime_warnings_enabled,
     caml_ml_enable_runtime_warnings:caml_ml_enable_runtime_warnings,
     caml_runtime_warnings:caml_runtime_warnings,
     unix_inet_addr_of_string:unix_inet_addr_of_string,
     caml_install_signal_handler:caml_install_signal_handler,
     caml_runtime_parameters:caml_runtime_parameters,
     caml_runtime_variant:caml_runtime_variant,
     caml_sys_isatty:caml_sys_isatty,
     caml_sys_get_config:caml_sys_get_config,
     caml_sys_const_backend_type:caml_sys_const_backend_type,
     caml_sys_const_ostype_cygwin:caml_sys_const_ostype_cygwin,
     caml_sys_const_ostype_win32:caml_sys_const_ostype_win32,
     caml_sys_const_ostype_unix:caml_sys_const_ostype_unix,
     caml_sys_const_max_wosize:caml_sys_const_max_wosize,
     caml_sys_const_int_size:caml_sys_const_int_size,
     caml_sys_const_word_size:caml_sys_const_word_size,
     caml_sys_const_big_endian:caml_sys_const_big_endian,
     caml_sys_random_seed:caml_sys_random_seed,
     caml_sys_time:caml_sys_time,
     caml_sys_system_command:caml_sys_system_command,
     caml_sys_executable_name:caml_sys_executable_name,
     caml_sys_modify_argv:caml_sys_modify_argv,
     caml_sys_argv:caml_sys_argv,
     caml_sys_get_argv:caml_sys_get_argv,
     caml_executable_name:caml_executable_name,
     caml_argv:caml_argv,
     caml_sys_getenv:caml_sys_getenv,
     caml_set_static_env:caml_set_static_env,
     caml_sys_exit:caml_sys_exit,
     caml_raise_sys_error:caml_raise_sys_error,
     caml_is_printable:caml_is_printable,
     caml_get_global_data:caml_get_global_data,
     caml_register_global:caml_register_global,
     caml_global_data:caml_global_data,
     caml_named_value:caml_named_value,
     caml_register_named_value:caml_register_named_value,
     caml_named_values:caml_named_values,
     caml_call_gen:caml_call_gen,
     caml_set_parser_trace:caml_set_parser_trace,
     caml_parse_engine:caml_parse_engine,
     caml_fresh_oo_id:caml_fresh_oo_id,
     caml_set_oo_id:caml_set_oo_id,
     caml_oo_last_id:caml_oo_last_id,
     caml_get_public_method:caml_get_public_method,
     caml_lazy_make_forward:caml_lazy_make_forward,
     caml_obj_make_forward:caml_obj_make_forward,
     caml_obj_truncate:caml_obj_truncate,
     caml_obj_dup:caml_obj_dup,
     caml_obj_with_tag:caml_obj_with_tag,
     caml_obj_block:caml_obj_block,
     caml_obj_set_tag:caml_obj_set_tag,
     caml_obj_tag:caml_obj_tag,
     caml_obj_is_block:caml_obj_is_block,
     caml_update_dummy:caml_update_dummy,
     deserialize_nat:deserialize_nat,
     serialize_nat:serialize_nat,
     lxor_digit_nat:lxor_digit_nat,
     lor_digit_nat:lor_digit_nat,
     land_digit_nat:land_digit_nat,
     compare_nat_real:compare_nat_real,
     compare_nat:compare_nat,
     compare_digits_nat:compare_digits_nat,
     shift_right_nat:shift_right_nat,
     div_nat:div_nat,
     div_digit_nat:div_digit_nat,
     div_helper:div_helper,
     shift_left_nat:shift_left_nat,
     square_nat:square_nat,
     mult_nat:mult_nat,
     mult_digit_nat:mult_digit_nat,
     sub_nat:sub_nat,
     decr_nat:decr_nat,
     complement_nat:complement_nat,
     add_nat:add_nat,
     incr_nat:incr_nat,
     is_digit_odd:is_digit_odd,
     is_digit_zero:is_digit_zero,
     is_digit_int:is_digit_int,
     num_leading_zero_bits_in_digit:num_leading_zero_bits_in_digit,
     num_digits_nat:num_digits_nat,
     nth_digit_nat_native:nth_digit_nat_native,
     set_digit_nat_native:set_digit_nat_native,
     nth_digit_nat:nth_digit_nat,
     set_digit_nat:set_digit_nat,
     blit_nat:blit_nat,
     set_to_zero_nat:set_to_zero_nat,
     create_nat:create_nat,
     nat_of_array:nat_of_array,
     caml_hash_nat:caml_hash_nat,
     MlNat:MlNat,
     initialize_nat:initialize_nat,
     caml_js_to_string:caml_js_to_string,
     caml_to_js_string:caml_to_js_string,
     caml_js_from_string:caml_js_from_string,
     caml_new_string:caml_new_string,
     caml_js_to_byte_string:caml_js_to_byte_string,
     caml_is_ml_string:caml_is_ml_string,
     caml_is_ml_bytes:caml_is_ml_bytes,
     caml_string_of_jsstring:caml_string_of_jsstring,
     caml_jsstring_of_string:caml_jsstring_of_string,
     caml_jsbytes_of_string:caml_jsbytes_of_string,
     caml_string_of_jsbytes:caml_string_of_jsbytes,
     caml_bytes_of_string:caml_bytes_of_string,
     caml_string_of_bytes:caml_string_of_bytes,
     caml_string_lessthan:caml_string_lessthan,
     caml_string_lessequal:caml_string_lessequal,
     caml_string_equal:caml_string_equal,
     caml_string_compare:caml_string_compare,
     caml_ml_string_length:caml_ml_string_length,
     caml_string_unsafe_set:caml_string_unsafe_set,
     caml_string_unsafe_get:caml_string_unsafe_get,
     caml_bytes_of_jsbytes:caml_bytes_of_jsbytes,
     caml_ml_bytes_length:caml_ml_bytes_length,
     caml_blit_string:caml_blit_string,
     caml_blit_bytes:caml_blit_bytes,
     caml_fill_string:caml_fill_string,
     caml_fill_bytes:caml_fill_bytes,
     caml_bytes_greaterthan:caml_bytes_greaterthan,
     caml_string_greaterthan:caml_string_greaterthan,
     caml_bytes_greaterequal:caml_bytes_greaterequal,
     caml_string_greaterequal:caml_string_greaterequal,
     caml_bytes_lessthan:caml_bytes_lessthan,
     caml_bytes_lessequal:caml_bytes_lessequal,
     caml_bytes_notequal:caml_bytes_notequal,
     caml_string_notequal:caml_string_notequal,
     caml_bytes_equal:caml_bytes_equal,
     caml_bytes_compare:caml_bytes_compare,
     caml_bytes_of_array:caml_bytes_of_array,
     caml_string_of_array:caml_string_of_array,
     caml_create_bytes:caml_create_bytes,
     caml_create_string:caml_create_string,
     caml_array_of_string:caml_array_of_string,
     caml_array_of_bytes:caml_array_of_bytes,
     caml_convert_bytes_to_array:caml_convert_bytes_to_array,
     caml_convert_string_to_bytes:caml_convert_string_to_bytes,
     MlBytes:MlBytes,
     caml_bytes_of_utf16_jsstring:caml_bytes_of_utf16_jsstring,
     caml_bytes_set:caml_bytes_set,
     caml_string_set64:caml_string_set64,
     caml_bytes_set64:caml_bytes_set64,
     caml_string_set32:caml_string_set32,
     caml_bytes_set32:caml_bytes_set32,
     caml_string_set16:caml_string_set16,
     caml_bytes_set16:caml_bytes_set16,
     caml_string_set:caml_string_set,
     caml_bytes_get:caml_bytes_get,
     caml_bytes_get64:caml_bytes_get64,
     caml_string_get64:caml_string_get64,
     caml_bytes_get32:caml_bytes_get32,
     caml_string_get32:caml_string_get32,
     caml_bytes_get16:caml_bytes_get16,
     caml_string_get16:caml_string_get16,
     caml_string_get:caml_string_get,
     caml_bytes_bound_error:caml_bytes_bound_error,
     caml_string_bound_error:caml_string_bound_error,
     caml_bytes_unsafe_set:caml_bytes_unsafe_set,
     caml_bytes_unsafe_get:caml_bytes_unsafe_get,
     jsoo_is_ascii:jsoo_is_ascii,
     caml_utf16_of_utf8:caml_utf16_of_utf8,
     caml_utf8_of_utf16:caml_utf8_of_utf16,
     caml_subarray_to_jsbytes:caml_subarray_to_jsbytes,
     caml_str_repeat:caml_str_repeat,
     caml_md5_bytes:caml_md5_bytes,
     caml_md5_string:caml_md5_string,
     caml_md5_chan:caml_md5_chan,
     caml_output_value_to_buffer:caml_output_value_to_buffer,
     caml_output_value_to_bytes:caml_output_value_to_bytes,
     caml_output_value_to_string:caml_output_value_to_string,
     caml_output_val:caml_output_val,
     caml_legacy_custom_code:caml_legacy_custom_code,
     MlObjectTable:MlObjectTable,
     caml_marshal_data_size:caml_marshal_data_size,
     caml_input_value_from_reader:caml_input_value_from_reader,
     caml_custom_ops:caml_custom_ops,
     caml_nativeint_unmarshal:caml_nativeint_unmarshal,
     caml_int32_unmarshal:caml_int32_unmarshal,
     caml_int64_marshal:caml_int64_marshal,
     caml_int64_unmarshal:caml_int64_unmarshal,
     caml_input_value_from_bytes:caml_input_value_from_bytes,
     caml_input_value_from_string:caml_input_value_from_string,
     caml_float_of_bytes:caml_float_of_bytes,
     BigStringReader:BigStringReader,
     MlStringReader:MlStringReader,
     caml_marshal_constants:caml_marshal_constants,
     caml_new_lex_engine:caml_new_lex_engine,
     caml_lex_engine:caml_lex_engine,
     caml_lex_array:caml_lex_array,
     caml_js_export_var:caml_js_export_var,
     caml_js_object:caml_js_object,
     caml_pure_js_expr:caml_pure_js_expr,
     caml_js_expr:caml_js_expr,
     caml_js_eval_string:caml_js_eval_string,
     caml_js_equals:caml_js_equals,
     caml_js_wrap_meth_callback_unsafe:caml_js_wrap_meth_callback_unsafe,
     caml_js_wrap_meth_callback_strict:caml_js_wrap_meth_callback_strict,
     caml_js_wrap_meth_callback_arguments:caml_js_wrap_meth_callback_arguments,
     caml_js_wrap_meth_callback:caml_js_wrap_meth_callback,
     caml_js_wrap_callback_strict:caml_js_wrap_callback_strict,
     caml_js_wrap_callback_arguments:caml_js_wrap_callback_arguments,
     caml_js_wrap_callback:caml_js_wrap_callback,
     caml_ojs_new_arr:caml_ojs_new_arr,
     caml_js_new:caml_js_new,
     caml_js_meth_call:caml_js_meth_call,
     caml_js_fun_call:caml_js_fun_call,
     caml_js_call:caml_js_call,
     caml_js_var:caml_js_var,
     caml_list_to_js_array:caml_list_to_js_array,
     caml_list_of_js_array:caml_list_of_js_array,
     caml_js_to_array:caml_js_to_array,
     caml_js_from_array:caml_js_from_array,
     caml_js_to_float:caml_js_to_float,
     caml_js_from_float:caml_js_from_float,
     caml_js_to_bool:caml_js_to_bool,
     caml_js_from_bool:caml_js_from_bool,
     caml_js_error_of_exception:caml_js_error_of_exception,
     caml_exn_with_js_backtrace:caml_exn_with_js_backtrace,
     caml_wrap_exception:caml_wrap_exception,
     caml_is_js:caml_is_js,
     js_print_stderr:js_print_stderr,
     js_print_stdout:js_print_stdout,
     caml_trampoline_return:caml_trampoline_return,
     caml_trampoline:caml_trampoline,
     caml_js_get_console:caml_js_get_console,
     caml_js_html_entities:caml_js_html_entities,
     caml_js_html_escape:caml_js_html_escape,
     caml_js_on_ie:caml_js_on_ie,
     caml_js_typeof:caml_js_typeof,
     caml_js_instanceof:caml_js_instanceof,
     caml_js_delete:caml_js_delete,
     caml_js_get:caml_js_get,
     caml_js_set:caml_js_set,
     caml_js_pure_expr:caml_js_pure_expr,
     caml_ml_output_int:caml_ml_output_int,
     caml_ml_pos_out_64:caml_ml_pos_out_64,
     caml_ml_pos_out:caml_ml_pos_out,
     caml_ml_seek_out_64:caml_ml_seek_out_64,
     caml_ml_seek_out:caml_ml_seek_out,
     caml_output_value:caml_output_value,
     caml_ml_output_char:caml_ml_output_char,
     caml_ml_output:caml_ml_output,
     caml_ml_output_bytes:caml_ml_output_bytes,
     caml_ml_flush:caml_ml_flush,
     caml_ml_input_scan_line:caml_ml_input_scan_line,
     caml_ml_pos_in_64:caml_ml_pos_in_64,
     caml_ml_pos_in:caml_ml_pos_in,
     caml_ml_seek_in_64:caml_ml_seek_in_64,
     caml_ml_seek_in:caml_ml_seek_in,
     caml_ml_input_int:caml_ml_input_int,
     caml_ml_input_char:caml_ml_input_char,
     caml_input_value:caml_input_value,
     caml_ml_input:caml_ml_input,
     caml_ml_may_refill_input:caml_ml_may_refill_input,
     caml_ml_refill_input:caml_ml_refill_input,
     caml_ml_set_channel_refill:caml_ml_set_channel_refill,
     caml_ml_set_channel_output:caml_ml_set_channel_output,
     caml_ml_channel_size_64:caml_ml_channel_size_64,
     caml_ml_channel_size:caml_ml_channel_size,
     caml_ml_close_channel:caml_ml_close_channel,
     caml_ml_set_binary_mode:caml_ml_set_binary_mode,
     caml_ml_open_descriptor_in:caml_ml_open_descriptor_in,
     caml_ml_open_descriptor_out:caml_ml_open_descriptor_out,
     caml_ml_out_channels_list:caml_ml_out_channels_list,
     caml_ml_channels:caml_ml_channels,
     caml_ml_set_channel_name:caml_ml_set_channel_name,
     caml_sys_open:caml_sys_open,
     caml_std_output:caml_std_output,
     caml_sys_close:caml_sys_close,
     caml_int64_bswap:caml_int64_bswap,
     caml_int32_bswap:caml_int32_bswap,
     caml_bswap16:caml_bswap16,
     caml_mod:caml_mod,
     caml_div:caml_div,
     caml_mul:caml_mul,
     caml_int_of_string:caml_int_of_string,
     caml_parse_digit:caml_parse_digit,
     caml_parse_sign_and_base:caml_parse_sign_and_base,
     caml_format_int:caml_format_int,
     caml_CamlinternalMod_update_mod:caml_CamlinternalMod_update_mod,
     caml_CamlinternalMod_init_mod:caml_CamlinternalMod_init_mod,
     caml_int64_hash:caml_int64_hash,
     caml_int64_to_bytes:caml_int64_to_bytes,
     caml_int64_of_bytes:caml_int64_of_bytes,
     caml_int64_hi32:caml_int64_hi32,
     caml_int64_lo32:caml_int64_lo32,
     caml_int64_create_lo_hi:caml_int64_create_lo_hi,
     caml_int64_create_lo_mi_hi:caml_int64_create_lo_mi_hi,
     caml_int64_of_string:caml_int64_of_string,
     caml_int64_format:caml_int64_format,
     caml_int64_of_float:caml_int64_of_float,
     caml_int64_to_float:caml_int64_to_float,
     caml_int64_to_int32:caml_int64_to_int32,
     caml_int64_of_int32:caml_int64_of_int32,
     caml_int64_mod:caml_int64_mod,
     caml_int64_div:caml_int64_div,
     caml_int64_shift_right:caml_int64_shift_right,
     caml_int64_shift_right_unsigned:caml_int64_shift_right_unsigned,
     caml_int64_shift_left:caml_int64_shift_left,
     caml_int64_xor:caml_int64_xor,
     caml_int64_or:caml_int64_or,
     caml_int64_and:caml_int64_and,
     caml_int64_is_negative:caml_int64_is_negative,
     caml_int64_is_zero:caml_int64_is_zero,
     caml_int64_mul:caml_int64_mul,
     caml_int64_sub:caml_int64_sub,
     caml_int64_add:caml_int64_add,
     caml_int64_neg:caml_int64_neg,
     caml_int64_compare:caml_int64_compare,
     caml_int64_ult:caml_int64_ult,
     MlInt64:MlInt64,
     caml_int64_offset:caml_int64_offset,
     caml_float_of_string:caml_float_of_string,
     caml_format_float:caml_format_float,
     caml_round_float:caml_round_float,
     caml_tanh_float:caml_tanh_float,
     caml_sinh_float:caml_sinh_float,
     caml_cosh_float:caml_cosh_float,
     caml_log10_float:caml_log10_float,
     caml_hypot_float:caml_hypot_float,
     caml_log1p_float:caml_log1p_float,
     caml_expm1_float:caml_expm1_float,
     caml_signbit_float:caml_signbit_float,
     caml_copysign_float:caml_copysign_float,
     caml_float_compare:caml_float_compare,
     caml_frexp_float:caml_frexp_float,
     caml_ldexp_float:caml_ldexp_float,
     caml_modf_float:caml_modf_float,
     caml_classify_float:caml_classify_float,
     caml_int32_float_of_bits:caml_int32_float_of_bits,
     caml_trunc_float:caml_trunc_float,
     caml_nextafter_float:caml_nextafter_float,
     caml_int64_float_of_bits:caml_int64_float_of_bits,
     caml_hexstring_of_float:caml_hexstring_of_float,
     caml_int32_bits_of_float:caml_int32_bits_of_float,
     caml_int64_bits_of_float:caml_int64_bits_of_float,
     jsoo_floor_log2:jsoo_floor_log2,
     caml_hash:caml_hash,
     caml_hash_mix_string:caml_hash_mix_string,
     caml_hash_mix_bytes:caml_hash_mix_bytes,
     caml_hash_mix_bytes_arr:caml_hash_mix_bytes_arr,
     caml_hash_mix_jsbytes:caml_hash_mix_jsbytes,
     caml_hash_mix_int64:caml_hash_mix_int64,
     caml_hash_mix_float:caml_hash_mix_float,
     caml_hash_mix_final:caml_hash_mix_final,
     caml_hash_mix_int:caml_hash_mix_int,
     caml_hash_univ_param:caml_hash_univ_param,
     caml_gr_close_subwindow:caml_gr_close_subwindow,
     caml_gr_open_subwindow:caml_gr_open_subwindow,
     caml_gr_window_id:caml_gr_window_id,
     caml_gr_display_mode:caml_gr_display_mode,
     caml_gr_remember_mode:caml_gr_remember_mode,
     caml_gr_synchronize:caml_gr_synchronize,
     caml_gr_wait_event:caml_gr_wait_event,
     caml_gr_sigio_signal:caml_gr_sigio_signal,
     caml_gr_sigio_handler:caml_gr_sigio_handler,
     caml_gr_blit_image:caml_gr_blit_image,
     caml_gr_create_image:caml_gr_create_image,
     caml_gr_draw_image:caml_gr_draw_image,
     caml_gr_dump_image:caml_gr_dump_image,
     caml_gr_make_image:caml_gr_make_image,
     caml_gr_text_size:caml_gr_text_size,
     caml_gr_set_text_size:caml_gr_set_text_size,
     caml_gr_set_font:caml_gr_set_font,
     caml_gr_draw_string:caml_gr_draw_string,
     caml_gr_draw_char:caml_gr_draw_char,
     caml_gr_draw_str:caml_gr_draw_str,
     caml_gr_fill_arc:caml_gr_fill_arc,
     caml_gr_fill_poly:caml_gr_fill_poly,
     caml_gr_fill_rect:caml_gr_fill_rect,
     caml_gr_set_line_width:caml_gr_set_line_width,
     caml_gr_draw_arc:caml_gr_draw_arc,
     caml_gr_arc_aux:caml_gr_arc_aux,
     caml_gr_draw_rect:caml_gr_draw_rect,
     caml_gr_lineto:caml_gr_lineto,
     caml_gr_current_y:caml_gr_current_y,
     caml_gr_current_x:caml_gr_current_x,
     caml_gr_moveto:caml_gr_moveto,
     caml_gr_point_color:caml_gr_point_color,
     caml_gr_plot:caml_gr_plot,
     caml_gr_set_color:caml_gr_set_color,
     caml_gr_size_y:caml_gr_size_y,
     caml_gr_size_x:caml_gr_size_x,
     caml_gr_clear_graph:caml_gr_clear_graph,
     caml_gr_resize_window:caml_gr_resize_window,
     caml_gr_set_window_title:caml_gr_set_window_title,
     caml_gr_close_graph:caml_gr_close_graph,
     caml_gr_doc_of_state:caml_gr_doc_of_state,
     caml_gr_state_create:caml_gr_state_create,
     caml_gr_state_init:caml_gr_state_init,
     caml_gr_open_graph:caml_gr_open_graph,
     caml_gr_state_set:caml_gr_state_set,
     caml_gr_state_get:caml_gr_state_get,
     caml_gr_state:caml_gr_state,
     caml_final_release:caml_final_release,
     caml_final_register_called_without_value:
     caml_final_register_called_without_value,
     caml_final_register:caml_final_register,
     caml_memprof_set:caml_memprof_set,
     caml_gc_get:caml_gc_get,
     caml_gc_set:caml_gc_set,
     caml_gc_stat:caml_gc_stat,
     caml_gc_quick_stat:caml_gc_quick_stat,
     caml_gc_counters:caml_gc_counters,
     caml_gc_compaction:caml_gc_compaction,
     caml_gc_full_major:caml_gc_full_major,
     caml_gc_major:caml_gc_major,
     caml_gc_minor:caml_gc_minor,
     MlNodeFile:MlNodeFile,
     MlNodeDevice:MlNodeDevice,
     fs_node_supported:fs_node_supported,
     MlFakeFile:MlFakeFile,
     MlFakeDevice:MlFakeDevice,
     caml_read_file_content:caml_read_file_content,
     caml_create_file:caml_create_file,
     caml_fs_init:caml_fs_init,
     caml_create_file_extern:caml_create_file_extern,
     caml_ba_map_file_bytecode:caml_ba_map_file_bytecode,
     caml_ba_map_file:caml_ba_map_file,
     caml_sys_rename:caml_sys_rename,
     caml_sys_is_directory:caml_sys_is_directory,
     caml_sys_remove:caml_sys_remove,
     caml_sys_read_directory:caml_sys_read_directory,
     caml_sys_file_exists:caml_sys_file_exists,
     caml_raise_not_a_dir:caml_raise_not_a_dir,
     caml_raise_no_such_file:caml_raise_no_such_file,
     caml_sys_chdir:caml_sys_chdir,
     caml_sys_getcwd:caml_sys_getcwd,
     caml_unmount:caml_unmount,
     caml_mount_autoload:caml_mount_autoload,
     resolve_fs_device:resolve_fs_device,
     caml_list_mount_point:caml_list_mount_point,
     jsoo_mount_point:jsoo_mount_point,
     caml_make_path:caml_make_path,
     MlFile:MlFile,
     caml_root:caml_root,
     caml_current_dir:caml_current_dir,
     caml_finish_formatting:caml_finish_formatting,
     caml_parse_format:caml_parse_format,
     caml_array_bound_error:caml_array_bound_error,
     caml_raise_not_found:caml_raise_not_found,
     caml_raise_zero_divide:caml_raise_zero_divide,
     caml_raise_end_of_file:caml_raise_end_of_file,
     caml_invalid_argument:caml_invalid_argument,
     caml_failwith:caml_failwith,
     caml_raise_with_string:caml_raise_with_string,
     caml_raise_with_arg:caml_raise_with_arg,
     caml_return_exn_constant:caml_return_exn_constant,
     caml_raise_constant:caml_raise_constant,
     caml_lessthan:caml_lessthan,
     caml_lessequal:caml_lessequal,
     caml_greaterthan:caml_greaterthan,
     caml_greaterequal:caml_greaterequal,
     caml_notequal:caml_notequal,
     caml_equal:caml_equal,
     caml_int_compare:caml_int_compare,
     caml_compare:caml_compare,
     caml_compare_val:caml_compare_val,
     caml_compare_val_number_custom:caml_compare_val_number_custom,
     caml_compare_val_get_custom:caml_compare_val_get_custom,
     caml_compare_val_tag:caml_compare_val_tag,
     caml_bigstring_blit_ba_to_bytes:caml_bigstring_blit_ba_to_bytes,
     caml_bigstring_blit_bytes_to_ba:caml_bigstring_blit_bytes_to_ba,
     caml_bigstring_blit_string_to_ba:caml_bigstring_blit_string_to_ba,
     caml_bigstring_blit_ba_to_ba:caml_bigstring_blit_ba_to_ba,
     caml_bigstring_memcmp:caml_bigstring_memcmp,
     bigstring_of_typed_array:bigstring_of_typed_array,
     bigstring_of_array_buffer:bigstring_of_array_buffer,
     bigstring_to_typed_array:bigstring_to_typed_array,
     bigstring_to_array_buffer:bigstring_to_array_buffer,
     caml_hash_mix_bigstring:caml_hash_mix_bigstring,
     caml_ba_from_typed_array:caml_ba_from_typed_array,
     caml_ba_kind_of_typed_array:caml_ba_kind_of_typed_array,
     caml_ba_to_typed_array:caml_ba_to_typed_array,
     caml_ba_hash:caml_ba_hash,
     caml_ba_create_from:caml_ba_create_from,
     caml_ba_deserialize:caml_ba_deserialize,
     caml_ba_serialize:caml_ba_serialize,
     caml_ba_reshape:caml_ba_reshape,
     caml_ba_slice:caml_ba_slice,
     caml_ba_sub:caml_ba_sub,
     caml_ba_blit:caml_ba_blit,
     caml_ba_fill:caml_ba_fill,
     caml_ba_set_3:caml_ba_set_3,
     caml_ba_set_2:caml_ba_set_2,
     caml_ba_set_1:caml_ba_set_1,
     caml_ba_uint8_set64:caml_ba_uint8_set64,
     caml_ba_uint8_set32:caml_ba_uint8_set32,
     caml_ba_uint8_set16:caml_ba_uint8_set16,
     caml_ba_set_generic:caml_ba_set_generic,
     caml_ba_get_3:caml_ba_get_3,
     caml_ba_get_2:caml_ba_get_2,
     caml_ba_get_1:caml_ba_get_1,
     caml_ba_uint8_get64:caml_ba_uint8_get64,
     caml_ba_uint8_get32:caml_ba_uint8_get32,
     caml_ba_uint8_get16:caml_ba_uint8_get16,
     caml_ba_get_generic:caml_ba_get_generic,
     caml_ba_dim_3:caml_ba_dim_3,
     caml_ba_dim_2:caml_ba_dim_2,
     caml_ba_dim_1:caml_ba_dim_1,
     caml_ba_dim:caml_ba_dim,
     caml_ba_num_dims:caml_ba_num_dims,
     caml_ba_layout:caml_ba_layout,
     caml_ba_kind:caml_ba_kind,
     caml_ba_change_layout:caml_ba_change_layout,
     caml_ba_create:caml_ba_create,
     caml_ba_create_unsafe:caml_ba_create_unsafe,
     caml_ba_compare:caml_ba_compare,
     Ml_Bigarray_c_1_1:Ml_Bigarray_c_1_1,
     Ml_Bigarray:Ml_Bigarray,
     caml_ba_create_buffer:caml_ba_create_buffer,
     caml_ba_get_size_per_element:caml_ba_get_size_per_element,
     caml_ba_get_size:caml_ba_get_size,
     caml_ba_init:caml_ba_init,
     caml_convert_raw_backtrace_slot:caml_convert_raw_backtrace_slot,
     caml_get_current_callstack:caml_get_current_callstack,
     caml_restore_raw_backtrace:caml_restore_raw_backtrace,
     caml_raw_backtrace_slot:caml_raw_backtrace_slot,
     caml_raw_backtrace_next_slot:caml_raw_backtrace_next_slot,
     caml_raw_backtrace_length:caml_raw_backtrace_length,
     caml_convert_raw_backtrace:caml_convert_raw_backtrace,
     caml_record_backtrace:caml_record_backtrace,
     caml_get_exception_raw_backtrace:caml_get_exception_raw_backtrace,
     caml_get_exception_backtrace:caml_get_exception_backtrace,
     caml_backtrace_status:caml_backtrace_status,
     caml_floatarray_create:caml_floatarray_create,
     caml_make_float_vect:caml_make_float_vect,
     caml_make_vect:caml_make_vect,
     caml_check_bound:caml_check_bound,
     caml_array_fill:caml_array_fill,
     caml_array_get:caml_array_get,
     caml_array_set:caml_array_set,
     caml_array_blit:caml_array_blit,
     caml_array_concat:caml_array_concat,
     caml_array_append:caml_array_append,
     caml_array_sub:caml_array_sub};
    caml_fs_init();
    caml_register_global
     (0,[248,caml_string_of_jsbytes("Out_of_memory"),0],"Out_of_memory");
    caml_register_global
     (1,[248,caml_string_of_jsbytes("Sys_error"),-1],"Sys_error");
    caml_register_global
     (2,[248,caml_string_of_jsbytes("Failure"),-2],"Failure");
    caml_register_global
     (3,
      [248,caml_string_of_jsbytes("Invalid_argument"),-3],
      "Invalid_argument");
    caml_register_global
     (4,[248,caml_string_of_jsbytes("End_of_file"),-4],"End_of_file");
    caml_register_global
     (5,
      [248,caml_string_of_jsbytes("Division_by_zero"),-5],
      "Division_by_zero");
    caml_register_global
     (6,[248,caml_string_of_jsbytes("Not_found"),-6],"Not_found");
    caml_register_global
     (7,[248,caml_string_of_jsbytes("Match_failure"),-7],"Match_failure");
    caml_register_global
     (8,[248,caml_string_of_jsbytes("Stack_overflow"),-8],"Stack_overflow");
    caml_register_global
     (9,[248,caml_string_of_jsbytes("Sys_blocked_io"),-9],"Sys_blocked_io");
    caml_register_global
     (10,[248,caml_string_of_jsbytes("Assert_failure"),-10],"Assert_failure");
    caml_register_global
     (11,
      [248,caml_string_of_jsbytes("Undefined_recursive_module"),-11],
      "Undefined_recursive_module");
    return}
  (function(){return this}()));

//# 1 "../../.js/stdlib/stdlib.cma.js"
(function(joo_global_object)
   {"use strict";
    var
     runtime=joo_global_object.jsoo_runtime,
     caml_array_concat=runtime.caml_array_concat,
     caml_array_get=runtime.caml_array_get,
     caml_array_set=runtime.caml_array_set,
     caml_array_sub=runtime.caml_array_sub,
     caml_ba_change_layout=runtime.caml_ba_change_layout,
     caml_ba_create=runtime.caml_ba_create,
     caml_ba_dim_1=runtime.caml_ba_dim_1,
     caml_ba_dim_2=runtime.caml_ba_dim_2,
     caml_ba_kind=runtime.caml_ba_kind,
     caml_ba_num_dims=runtime.caml_ba_num_dims,
     caml_ba_reshape=runtime.caml_ba_reshape,
     caml_ba_slice=runtime.caml_ba_slice,
     caml_blit_bytes=runtime.caml_blit_bytes,
     caml_blit_string=runtime.caml_blit_string,
     caml_bswap16=runtime.caml_bswap16,
     caml_bytes_get=runtime.caml_bytes_get,
     caml_bytes_get16=runtime.caml_bytes_get16,
     caml_bytes_get32=runtime.caml_bytes_get32,
     caml_bytes_get64=runtime.caml_bytes_get64,
     caml_bytes_of_string=runtime.caml_bytes_of_string,
     caml_bytes_set=runtime.caml_bytes_set,
     caml_bytes_set16=runtime.caml_bytes_set16,
     caml_bytes_set32=runtime.caml_bytes_set32,
     caml_bytes_set64=runtime.caml_bytes_set64,
     caml_bytes_unsafe_get=runtime.caml_bytes_unsafe_get,
     caml_bytes_unsafe_set=runtime.caml_bytes_unsafe_set,
     caml_check_bound=runtime.caml_check_bound,
     caml_compare=runtime.caml_compare,
     caml_create_bytes=runtime.caml_create_bytes,
     caml_div=runtime.caml_div,
     caml_ephe_set_key=runtime.caml_ephe_set_key,
     caml_ephe_unset_key=runtime.caml_ephe_unset_key,
     caml_equal=runtime.caml_equal,
     caml_fill_bytes=runtime.caml_fill_bytes,
     caml_float_compare=runtime.caml_float_compare,
     caml_float_of_string=runtime.caml_float_of_string,
     caml_floatarray_create=runtime.caml_floatarray_create,
     caml_format_float=runtime.caml_format_float,
     caml_format_int=runtime.caml_format_int,
     caml_fresh_oo_id=runtime.caml_fresh_oo_id,
     caml_get_exception_raw_backtra=runtime.caml_get_exception_raw_backtrace,
     caml_get_public_method=runtime.caml_get_public_method,
     caml_greaterequal=runtime.caml_greaterequal,
     caml_greaterthan=runtime.caml_greaterthan,
     caml_hash=runtime.caml_hash,
     caml_input_value=runtime.caml_input_value,
     caml_int32_bswap=runtime.caml_int32_bswap,
     caml_int64_add=runtime.caml_int64_add,
     caml_int64_bswap=runtime.caml_int64_bswap,
     caml_int64_compare=runtime.caml_int64_compare,
     caml_int64_float_of_bits=runtime.caml_int64_float_of_bits,
     caml_int64_format=runtime.caml_int64_format,
     caml_int64_mul=runtime.caml_int64_mul,
     caml_int64_of_int32=runtime.caml_int64_of_int32,
     caml_int64_of_string=runtime.caml_int64_of_string,
     caml_int64_or=runtime.caml_int64_or,
     caml_int64_shift_left=runtime.caml_int64_shift_left,
     caml_int64_sub=runtime.caml_int64_sub,
     caml_int_compare=runtime.caml_int_compare,
     caml_int_of_string=runtime.caml_int_of_string,
     caml_lessequal=runtime.caml_lessequal,
     caml_lessthan=runtime.caml_lessthan,
     caml_make_vect=runtime.caml_make_vect,
     caml_marshal_data_size=runtime.caml_marshal_data_size,
     caml_md5_string=runtime.caml_md5_string,
     caml_ml_bytes_length=runtime.caml_ml_bytes_length,
     caml_ml_channel_size=runtime.caml_ml_channel_size,
     caml_ml_channel_size_64=runtime.caml_ml_channel_size_64,
     caml_ml_close_channel=runtime.caml_ml_close_channel,
     caml_ml_flush=runtime.caml_ml_flush,
     caml_ml_input=runtime.caml_ml_input,
     caml_ml_input_char=runtime.caml_ml_input_char,
     caml_ml_open_descriptor_in=runtime.caml_ml_open_descriptor_in,
     caml_ml_open_descriptor_out=runtime.caml_ml_open_descriptor_out,
     caml_ml_output=runtime.caml_ml_output,
     caml_ml_output_bytes=runtime.caml_ml_output_bytes,
     caml_ml_output_char=runtime.caml_ml_output_char,
     caml_ml_set_binary_mode=runtime.caml_ml_set_binary_mode,
     caml_ml_set_channel_name=runtime.caml_ml_set_channel_name,
     caml_ml_string_length=runtime.caml_ml_string_length,
     caml_mod=runtime.caml_mod,
     caml_mul=runtime.caml_mul,
     caml_nextafter_float=runtime.caml_nextafter_float,
     caml_notequal=runtime.caml_notequal,
     caml_obj_block=runtime.caml_obj_block,
     caml_obj_make_forward=runtime.caml_obj_make_forward,
     caml_obj_tag=runtime.caml_obj_tag,
     caml_output_value=runtime.caml_output_value,
     caml_register_global=runtime.caml_register_global,
     caml_register_named_value=runtime.caml_register_named_value,
     caml_restore_raw_backtrace=runtime.caml_restore_raw_backtrace,
     caml_set_oo_id=runtime.caml_set_oo_id,
     caml_signbit_float=runtime.caml_signbit_float,
     caml_spacetime_enabled=runtime.caml_spacetime_enabled,
     caml_spacetime_only_works_for_=
      runtime.caml_spacetime_only_works_for_native_code,
     caml_string_compare=runtime.caml_string_compare,
     caml_string_equal=runtime.caml_string_equal,
     caml_string_get=runtime.caml_string_get,
     caml_string_notequal=runtime.caml_string_notequal,
     caml_string_of_bytes=runtime.caml_string_of_bytes,
     caml_string_of_jsbytes=runtime.caml_string_of_jsbytes,
     caml_string_unsafe_get=runtime.caml_string_unsafe_get,
     caml_sys_argv=runtime.caml_sys_argv,
     caml_sys_getenv=runtime.caml_sys_getenv,
     caml_sys_open=runtime.caml_sys_open,
     caml_sys_random_seed=runtime.caml_sys_random_seed,
     caml_trampoline=runtime.caml_trampoline,
     caml_trampoline_return=runtime.caml_trampoline_return,
     caml_wrap_exception=runtime.caml_wrap_exception;
    function caml_call1(f,a0)
     {return f.length == 1?f(a0):runtime.caml_call_gen(f,[a0])}
    function caml_call2(f,a0,a1)
     {return f.length == 2?f(a0,a1):runtime.caml_call_gen(f,[a0,a1])}
    function caml_call3(f,a0,a1,a2)
     {return f.length == 3?f(a0,a1,a2):runtime.caml_call_gen(f,[a0,a1,a2])}
    function caml_call4(f,a0,a1,a2,a3)
     {return f.length == 4
              ?f(a0,a1,a2,a3)
              :runtime.caml_call_gen(f,[a0,a1,a2,a3])}
    function caml_call5(f,a0,a1,a2,a3,a4)
     {return f.length == 5
              ?f(a0,a1,a2,a3,a4)
              :runtime.caml_call_gen(f,[a0,a1,a2,a3,a4])}
    function caml_call6(f,a0,a1,a2,a3,a4,a5)
     {return f.length == 6
              ?f(a0,a1,a2,a3,a4,a5)
              :runtime.caml_call_gen(f,[a0,a1,a2,a3,a4,a5])}
    var
     global_data=runtime.caml_get_global_data(),
     cst$0=caml_string_of_jsbytes("%,"),
     cst_really_input=caml_string_of_jsbytes("really_input"),
     cst_input=caml_string_of_jsbytes("input"),
     cst_output_substring=caml_string_of_jsbytes("output_substring"),
     cst_output=caml_string_of_jsbytes("output"),
     cst_12g=caml_string_of_jsbytes("%.12g"),
     cst=caml_string_of_jsbytes("."),
     cst_false$1=caml_string_of_jsbytes("false"),
     cst_true$1=caml_string_of_jsbytes("true"),
     cst_false$0=caml_string_of_jsbytes("false"),
     cst_true$0=caml_string_of_jsbytes("true"),
     cst_bool_of_string=caml_string_of_jsbytes("bool_of_string"),
     cst_true=caml_string_of_jsbytes("true"),
     cst_false=caml_string_of_jsbytes("false"),
     cst_char_of_int=caml_string_of_jsbytes("char_of_int"),
     cst_Stdlib_Exit=caml_string_of_jsbytes("Stdlib.Exit"),
     cst_Stdlib_Pervasives_Exit=
      caml_string_of_jsbytes("Stdlib.Pervasives.Exit"),
     cst_option_is_None=caml_string_of_jsbytes("option is None"),
     cst_result_is_Ok=caml_string_of_jsbytes("result is Ok _"),
     cst_result_is_Error=caml_string_of_jsbytes("result is Error _"),
     cst_true$2=caml_string_of_jsbytes("true"),
     cst_false$2=caml_string_of_jsbytes("false"),
     cst$1=caml_string_of_jsbytes("\\\\"),
     cst$2=caml_string_of_jsbytes("\\'"),
     cst_b=caml_string_of_jsbytes("\\b"),
     cst_t=caml_string_of_jsbytes("\\t"),
     cst_n=caml_string_of_jsbytes("\\n"),
     cst_r=caml_string_of_jsbytes("\\r"),
     cst_Char_chr=caml_string_of_jsbytes("Char.chr"),
     cst_is_not_a_latin1_character=
      caml_string_of_jsbytes(" is not a latin1 character"),
     cst_04X=caml_string_of_jsbytes("%04X"),
     cst_U=caml_string_of_jsbytes("U+"),
     cst_is_not_an_Unicode_scalar_v=
      caml_string_of_jsbytes(" is not an Unicode scalar value"),
     cst_X=caml_string_of_jsbytes("%X"),
     err_no_pred=caml_string_of_jsbytes("U+0000 has no predecessor"),
     err_no_succ=caml_string_of_jsbytes("U+10FFFF has no successor"),
     cst_Stdlib_Sys_Break=caml_string_of_jsbytes("Stdlib.Sys.Break"),
     ocaml_version=caml_string_of_jsbytes("4.10.2"),
     cst_List_map2=caml_string_of_jsbytes("List.map2"),
     cst_List_iter2=caml_string_of_jsbytes("List.iter2"),
     cst_List_fold_left2=caml_string_of_jsbytes("List.fold_left2"),
     cst_List_fold_right2=caml_string_of_jsbytes("List.fold_right2"),
     cst_List_for_all2=caml_string_of_jsbytes("List.for_all2"),
     cst_List_exists2=caml_string_of_jsbytes("List.exists2"),
     cst_List_combine=caml_string_of_jsbytes("List.combine"),
     cst_List_rev_map2=caml_string_of_jsbytes("List.rev_map2"),
     cst_List_init=caml_string_of_jsbytes("List.init"),
     cst_List_nth$0=caml_string_of_jsbytes("List.nth"),
     cst_nth=caml_string_of_jsbytes("nth"),
     cst_List_nth=caml_string_of_jsbytes("List.nth"),
     cst_tl=caml_string_of_jsbytes("tl"),
     cst_hd=caml_string_of_jsbytes("hd"),
     cst_Bytes_of_seq_cannot_grow_b=
      caml_string_of_jsbytes("Bytes.of_seq: cannot grow bytes"),
     cst_String_rcontains_from_Byte=
      caml_string_of_jsbytes("String.rcontains_from / Bytes.rcontains_from"),
     cst_String_contains_from_Bytes=
      caml_string_of_jsbytes("String.contains_from / Bytes.contains_from"),
     cst_String_rindex_from_opt_Byt=
      caml_string_of_jsbytes("String.rindex_from_opt / Bytes.rindex_from_opt"),
     cst_String_rindex_from_Bytes_r=
      caml_string_of_jsbytes("String.rindex_from / Bytes.rindex_from"),
     cst_String_index_from_opt_Byte=
      caml_string_of_jsbytes("String.index_from_opt / Bytes.index_from_opt"),
     cst_String_index_from_Bytes_in=
      caml_string_of_jsbytes("String.index_from / Bytes.index_from"),
     cst_Bytes_concat=caml_string_of_jsbytes("Bytes.concat"),
     cst_String_blit_Bytes_blit_str=
      caml_string_of_jsbytes("String.blit / Bytes.blit_string"),
     cst_Bytes_blit=caml_string_of_jsbytes("Bytes.blit"),
     cst_String_fill_Bytes_fill=
      caml_string_of_jsbytes("String.fill / Bytes.fill"),
     cst_Bytes_extend=caml_string_of_jsbytes("Bytes.extend"),
     cst_String_sub_Bytes_sub=caml_string_of_jsbytes("String.sub / Bytes.sub"),
     cst_String_rcontains_from_Byte$0=
      caml_string_of_jsbytes("String.rcontains_from / Bytes.rcontains_from"),
     cst_String_contains_from_Bytes$0=
      caml_string_of_jsbytes("String.contains_from / Bytes.contains_from"),
     cst_String_rindex_from_opt_Byt$0=
      caml_string_of_jsbytes("String.rindex_from_opt / Bytes.rindex_from_opt"),
     cst_String_rindex_from_Bytes_r$0=
      caml_string_of_jsbytes("String.rindex_from / Bytes.rindex_from"),
     cst_String_index_from_opt_Byte$0=
      caml_string_of_jsbytes("String.index_from_opt / Bytes.index_from_opt"),
     cst_String_index_from_Bytes_in$0=
      caml_string_of_jsbytes("String.index_from / Bytes.index_from"),
     cst$4=caml_string_of_jsbytes(""),
     cst$3=caml_string_of_jsbytes(""),
     cst_String_concat=caml_string_of_jsbytes("String.concat"),
     cst$5=caml_string_of_jsbytes("()"),
     cst_Marshal_from_bytes=caml_string_of_jsbytes("Marshal.from_bytes"),
     cst_Marshal_from_bytes$0=caml_string_of_jsbytes("Marshal.from_bytes"),
     cst_Marshal_data_size=caml_string_of_jsbytes("Marshal.data_size"),
     cst_Marshal_to_buffer_substrin=
      caml_string_of_jsbytes("Marshal.to_buffer: substring out of bounds"),
     cst_Obj_Ephemeron_blit_key=
      caml_string_of_jsbytes("Obj.Ephemeron.blit_key"),
     cst_Obj_Ephemeron_check_key=
      caml_string_of_jsbytes("Obj.Ephemeron.check_key"),
     cst_Obj_Ephemeron_unset_key=
      caml_string_of_jsbytes("Obj.Ephemeron.unset_key"),
     cst_Obj_Ephemeron_set_key=caml_string_of_jsbytes("Obj.Ephemeron.set_key"),
     cst_Obj_Ephemeron_get_key_copy=
      caml_string_of_jsbytes("Obj.Ephemeron.get_key_copy"),
     cst_Obj_Ephemeron_get_key=caml_string_of_jsbytes("Obj.Ephemeron.get_key"),
     cst_Obj_Ephemeron_create=caml_string_of_jsbytes("Obj.Ephemeron.create"),
     cst_Obj_extension_constructor$0=
      caml_string_of_jsbytes("Obj.extension_constructor"),
     cst_Obj_extension_constructor=
      caml_string_of_jsbytes("Obj.extension_constructor"),
     cst_Array_map2_arrays_must_hav=
      caml_string_of_jsbytes("Array.map2: arrays must have the same length"),
     cst_Array_iter2_arrays_must_ha=
      caml_string_of_jsbytes("Array.iter2: arrays must have the same length"),
     cst_Array_blit=caml_string_of_jsbytes("Array.blit"),
     cst_Array_fill=caml_string_of_jsbytes("Array.fill"),
     cst_Array_sub=caml_string_of_jsbytes("Array.sub"),
     cst_Array_init=caml_string_of_jsbytes("Array.init"),
     cst_Stdlib_Array_Bottom=caml_string_of_jsbytes("Stdlib.Array.Bottom"),
     cst_Float_Array_map2_arrays_mu=
      caml_string_of_jsbytes
       ("Float.Array.map2: arrays must have the same length"),
     cst_Float_Array_iter2_arrays_m=
      caml_string_of_jsbytes
       ("Float.Array.iter2: arrays must have the same length"),
     cst_Float_array_blit=caml_string_of_jsbytes("Float.array.blit"),
     cst_Float_array_blit$0=caml_string_of_jsbytes("Float.array.blit"),
     cst_Float_Array_fill=caml_string_of_jsbytes("Float.Array.fill"),
     cst_Float_Array_sub=caml_string_of_jsbytes("Float.Array.sub"),
     cst_Float_Array_concat=caml_string_of_jsbytes("Float.Array.concat"),
     cst_Float_Array_init=caml_string_of_jsbytes("Float.Array.init"),
     cst_Stdlib_Float_Array_Bottom=
      caml_string_of_jsbytes("Stdlib.Float.Array.Bottom"),
     cst_d=caml_string_of_jsbytes("%d"),
     cst_d$0=caml_string_of_jsbytes("%d"),
     zero$2=runtime.caml_int64_create_lo_mi_hi(0,0,0),
     one$2=runtime.caml_int64_create_lo_mi_hi(1,0,0),
     minus_one$2=runtime.caml_int64_create_lo_mi_hi(16777215,16777215,65535),
     min_int$2=runtime.caml_int64_create_lo_mi_hi(0,0,32768),
     max_int$2=runtime.caml_int64_create_lo_mi_hi(16777215,16777215,32767),
     cst_d$1=caml_string_of_jsbytes("%d"),
     cst_Lexing_lex_refill_cannot_g=
      caml_string_of_jsbytes("Lexing.lex_refill: cannot grow buffer"),
     dummy_pos=[0,caml_string_of_jsbytes(""),0,0,-1],
     zero_pos=[0,caml_string_of_jsbytes(""),1,0,0],
     cst_syntax_error=caml_string_of_jsbytes("syntax error"),
     cst_Stdlib_Parsing_YYexit=caml_string_of_jsbytes("Stdlib.Parsing.YYexit"),
     cst_Stdlib_Parsing_Parse_error=
      caml_string_of_jsbytes("Stdlib.Parsing.Parse_error"),
     cst_Set_remove_min_elt=caml_string_of_jsbytes("Set.remove_min_elt"),
     cst_Set_bal=caml_string_of_jsbytes("Set.bal"),
     cst_Set_bal$0=caml_string_of_jsbytes("Set.bal"),
     cst_Set_bal$1=caml_string_of_jsbytes("Set.bal"),
     cst_Set_bal$2=caml_string_of_jsbytes("Set.bal"),
     cst_Map_remove_min_elt=caml_string_of_jsbytes("Map.remove_min_elt"),
     cst_Map_bal=caml_string_of_jsbytes("Map.bal"),
     cst_Map_bal$0=caml_string_of_jsbytes("Map.bal"),
     cst_Map_bal$1=caml_string_of_jsbytes("Map.bal"),
     cst_Map_bal$2=caml_string_of_jsbytes("Map.bal"),
     cst_Stdlib_Stack_Empty=caml_string_of_jsbytes("Stdlib.Stack.Empty"),
     cst_Stdlib_Queue_Empty=caml_string_of_jsbytes("Stdlib.Queue.Empty"),
     cst_CamlinternalLazy_Undefined=
      caml_string_of_jsbytes("CamlinternalLazy.Undefined"),
     cst_count=caml_string_of_jsbytes("{count = "),
     cst_data=caml_string_of_jsbytes("; data = "),
     cst$6=caml_string_of_jsbytes("}"),
     cst_Sempty=caml_string_of_jsbytes("Sempty"),
     cst_Scons=caml_string_of_jsbytes("Scons ("),
     cst$7=caml_string_of_jsbytes(", "),
     cst$8=caml_string_of_jsbytes(")"),
     cst_Sapp=caml_string_of_jsbytes("Sapp ("),
     cst$9=caml_string_of_jsbytes(", "),
     cst$10=caml_string_of_jsbytes(")"),
     cst_Slazy=caml_string_of_jsbytes("Slazy"),
     cst_Sgen=caml_string_of_jsbytes("Sgen"),
     cst_Sbuffio=caml_string_of_jsbytes("Sbuffio"),
     cst_Stdlib_Stream_Failure=caml_string_of_jsbytes("Stdlib.Stream.Failure"),
     cst_Stdlib_Stream_Error=caml_string_of_jsbytes("Stdlib.Stream.Error"),
     cst_Buffer_truncate=caml_string_of_jsbytes("Buffer.truncate"),
     cst_Buffer_add_channel=caml_string_of_jsbytes("Buffer.add_channel"),
     cst_Buffer_add_substring_add_s=
      caml_string_of_jsbytes("Buffer.add_substring/add_subbytes"),
     cst_Buffer_add_cannot_grow_buf=
      caml_string_of_jsbytes("Buffer.add: cannot grow buffer"),
     cst_Buffer_nth=caml_string_of_jsbytes("Buffer.nth"),
     cst_Buffer_blit=caml_string_of_jsbytes("Buffer.blit"),
     cst_Buffer_sub=caml_string_of_jsbytes("Buffer.sub"),
     cst_c=caml_string_of_jsbytes("%c"),
     cst_s=caml_string_of_jsbytes("%s"),
     cst_i=caml_string_of_jsbytes("%i"),
     cst_li=caml_string_of_jsbytes("%li"),
     cst_ni=caml_string_of_jsbytes("%ni"),
     cst_Li=caml_string_of_jsbytes("%Li"),
     cst_f=caml_string_of_jsbytes("%f"),
     cst_B=caml_string_of_jsbytes("%B"),
     cst$21=caml_string_of_jsbytes("%{"),
     cst$22=caml_string_of_jsbytes("%}"),
     cst$23=caml_string_of_jsbytes("%("),
     cst$24=caml_string_of_jsbytes("%)"),
     cst_a=caml_string_of_jsbytes("%a"),
     cst_t$0=caml_string_of_jsbytes("%t"),
     cst$25=caml_string_of_jsbytes("%?"),
     cst_r$0=caml_string_of_jsbytes("%r"),
     cst_r$1=caml_string_of_jsbytes("%_r"),
     cst_u$0=caml_string_of_jsbytes("%u"),
     cst_Printf_bad_conversion=
      caml_string_of_jsbytes("Printf: bad conversion %["),
     cst_Printf_bad_conversion$0=
      caml_string_of_jsbytes("Printf: bad conversion %_"),
     cst$30=caml_string_of_jsbytes("@{"),
     cst$31=caml_string_of_jsbytes("@["),
     cst$32=caml_string_of_jsbytes("@{"),
     cst$33=caml_string_of_jsbytes("@["),
     cst$34=caml_string_of_jsbytes("@{"),
     cst$35=caml_string_of_jsbytes("@["),
     cst_0=caml_string_of_jsbytes("0"),
     cst_padding=caml_string_of_jsbytes("padding"),
     cst_precision=caml_string_of_jsbytes("precision"),
     cst$40=caml_string_of_jsbytes("'*'"),
     cst$38=caml_string_of_jsbytes("'-'"),
     cst_0$2=caml_string_of_jsbytes("'0'"),
     cst$39=caml_string_of_jsbytes("'*'"),
     cst_0$0=caml_string_of_jsbytes("0"),
     cst_0$1=caml_string_of_jsbytes("0"),
     cst_precision$0=caml_string_of_jsbytes("precision"),
     cst_precision$1=caml_string_of_jsbytes("precision"),
     cst$41=caml_string_of_jsbytes("'+'"),
     cst$42=caml_string_of_jsbytes("'#'"),
     cst$43=caml_string_of_jsbytes("' '"),
     cst_padding$0=caml_string_of_jsbytes("`padding'"),
     cst_precision$2=caml_string_of_jsbytes("`precision'"),
     cst$44=caml_string_of_jsbytes("'+'"),
     cst$45=caml_string_of_jsbytes("'_'"),
     sub_format=[0,0,caml_string_of_jsbytes("")],
     formatting_lit=[0,caml_string_of_jsbytes("@;"),1,0],
     cst_digit=caml_string_of_jsbytes("digit"),
     cst_character=caml_string_of_jsbytes("character ')'"),
     cst_character$0=caml_string_of_jsbytes("character '}'"),
     cst$49=caml_string_of_jsbytes("'#'"),
     cst$46=caml_string_of_jsbytes("'+'"),
     cst$47=caml_string_of_jsbytes("'+'"),
     cst$48=caml_string_of_jsbytes("' '"),
     cst$50=caml_string_of_jsbytes("'+'"),
     cst_non_zero_widths_are_unsupp=
      caml_string_of_jsbytes
       ("non-zero widths are unsupported for %c conversions"),
     cst_unexpected_end_of_format=
      caml_string_of_jsbytes("unexpected end of format"),
     cst$36=caml_string_of_jsbytes(""),
     cst$37=caml_string_of_jsbytes(""),
     cst_b$0=caml_string_of_jsbytes("b"),
     cst_h=caml_string_of_jsbytes("h"),
     cst_hov=caml_string_of_jsbytes("hov"),
     cst_hv=caml_string_of_jsbytes("hv"),
     cst_v=caml_string_of_jsbytes("v"),
     cst_nan=caml_string_of_jsbytes("nan"),
     cst_neg_infinity=caml_string_of_jsbytes("neg_infinity"),
     cst_infinity=caml_string_of_jsbytes("infinity"),
     cst$29=caml_string_of_jsbytes("."),
     cst_nd$0=caml_string_of_jsbytes("%+nd"),
     cst_nd$1=caml_string_of_jsbytes("% nd"),
     cst_ni$1=caml_string_of_jsbytes("%+ni"),
     cst_ni$2=caml_string_of_jsbytes("% ni"),
     cst_nx=caml_string_of_jsbytes("%nx"),
     cst_nx$0=caml_string_of_jsbytes("%#nx"),
     cst_nX=caml_string_of_jsbytes("%nX"),
     cst_nX$0=caml_string_of_jsbytes("%#nX"),
     cst_no=caml_string_of_jsbytes("%no"),
     cst_no$0=caml_string_of_jsbytes("%#no"),
     cst_nd=caml_string_of_jsbytes("%nd"),
     cst_ni$0=caml_string_of_jsbytes("%ni"),
     cst_nu=caml_string_of_jsbytes("%nu"),
     cst_ld$0=caml_string_of_jsbytes("%+ld"),
     cst_ld$1=caml_string_of_jsbytes("% ld"),
     cst_li$1=caml_string_of_jsbytes("%+li"),
     cst_li$2=caml_string_of_jsbytes("% li"),
     cst_lx=caml_string_of_jsbytes("%lx"),
     cst_lx$0=caml_string_of_jsbytes("%#lx"),
     cst_lX=caml_string_of_jsbytes("%lX"),
     cst_lX$0=caml_string_of_jsbytes("%#lX"),
     cst_lo=caml_string_of_jsbytes("%lo"),
     cst_lo$0=caml_string_of_jsbytes("%#lo"),
     cst_ld=caml_string_of_jsbytes("%ld"),
     cst_li$0=caml_string_of_jsbytes("%li"),
     cst_lu=caml_string_of_jsbytes("%lu"),
     cst_Ld$0=caml_string_of_jsbytes("%+Ld"),
     cst_Ld$1=caml_string_of_jsbytes("% Ld"),
     cst_Li$1=caml_string_of_jsbytes("%+Li"),
     cst_Li$2=caml_string_of_jsbytes("% Li"),
     cst_Lx=caml_string_of_jsbytes("%Lx"),
     cst_Lx$0=caml_string_of_jsbytes("%#Lx"),
     cst_LX=caml_string_of_jsbytes("%LX"),
     cst_LX$0=caml_string_of_jsbytes("%#LX"),
     cst_Lo=caml_string_of_jsbytes("%Lo"),
     cst_Lo$0=caml_string_of_jsbytes("%#Lo"),
     cst_Ld=caml_string_of_jsbytes("%Ld"),
     cst_Li$0=caml_string_of_jsbytes("%Li"),
     cst_Lu=caml_string_of_jsbytes("%Lu"),
     cst_d$3=caml_string_of_jsbytes("%+d"),
     cst_d$4=caml_string_of_jsbytes("% d"),
     cst_i$1=caml_string_of_jsbytes("%+i"),
     cst_i$2=caml_string_of_jsbytes("% i"),
     cst_x=caml_string_of_jsbytes("%x"),
     cst_x$0=caml_string_of_jsbytes("%#x"),
     cst_X$0=caml_string_of_jsbytes("%X"),
     cst_X$1=caml_string_of_jsbytes("%#X"),
     cst_o=caml_string_of_jsbytes("%o"),
     cst_o$0=caml_string_of_jsbytes("%#o"),
     cst_d$2=caml_string_of_jsbytes("%d"),
     cst_i$0=caml_string_of_jsbytes("%i"),
     cst_u=caml_string_of_jsbytes("%u"),
     cst$26=caml_string_of_jsbytes("%!"),
     cst$27=caml_string_of_jsbytes("@{"),
     cst$28=caml_string_of_jsbytes("@["),
     cst_0c=caml_string_of_jsbytes("0c"),
     cst$20=caml_string_of_jsbytes("%%"),
     cst$12=caml_string_of_jsbytes("@]"),
     cst$13=caml_string_of_jsbytes("@}"),
     cst$14=caml_string_of_jsbytes("@?"),
     cst$15=caml_string_of_jsbytes("@\n"),
     cst$16=caml_string_of_jsbytes("@."),
     cst$17=caml_string_of_jsbytes("@@"),
     cst$18=caml_string_of_jsbytes("@%"),
     cst$19=caml_string_of_jsbytes("@"),
     cst$11=caml_string_of_jsbytes(".*"),
     cst_CamlinternalFormat_Type_mi=
      caml_string_of_jsbytes("CamlinternalFormat.Type_mismatch"),
     cst$58=caml_string_of_jsbytes(""),
     cst$59=caml_string_of_jsbytes("\n"),
     cst_a_boolean=caml_string_of_jsbytes("a boolean"),
     cst_an_integer=caml_string_of_jsbytes("an integer"),
     cst_an_integer$0=caml_string_of_jsbytes("an integer"),
     cst_a_float=caml_string_of_jsbytes("a float"),
     cst_a_float$0=caml_string_of_jsbytes("a float"),
     cst$55=caml_string_of_jsbytes(""),
     cst$56=caml_string_of_jsbytes(" "),
     cst$57=caml_string_of_jsbytes(""),
     cst_one_of=caml_string_of_jsbytes("one of: "),
     cst_Arg_Expand_is_is_only_allo=
      caml_string_of_jsbytes
       ("Arg.Expand is is only allowed with Arg.parse_and_expand_argv_dynamic"),
     cst_no_argument=caml_string_of_jsbytes("no argument"),
     cst$54=caml_string_of_jsbytes("(?)"),
     cst_help$3=caml_string_of_jsbytes("--help"),
     cst_help$4=caml_string_of_jsbytes("-help"),
     cst_help$2=caml_string_of_jsbytes("-help"),
     cst_Display_this_list_of_optio=
      caml_string_of_jsbytes(" Display this list of options"),
     cst_help=caml_string_of_jsbytes("-help"),
     cst_help$1=caml_string_of_jsbytes("--help"),
     cst_Display_this_list_of_optio$0=
      caml_string_of_jsbytes(" Display this list of options"),
     cst_help$0=caml_string_of_jsbytes("--help"),
     cst$51=caml_string_of_jsbytes("}"),
     cst$52=caml_string_of_jsbytes("|"),
     cst$53=caml_string_of_jsbytes("{"),
     cst_none=caml_string_of_jsbytes("<none>"),
     cst_Stdlib_Arg_Bad=caml_string_of_jsbytes("Stdlib.Arg.Bad"),
     cst_Stdlib_Arg_Help=caml_string_of_jsbytes("Stdlib.Arg.Help"),
     cst_Stdlib_Arg_Stop=caml_string_of_jsbytes("Stdlib.Arg.Stop"),
     cst$61=caml_string_of_jsbytes(""),
     cst_Program_not_linked_with_g_=
      caml_string_of_jsbytes
       ("(Program not linked with -g, cannot print stack backtrace)\n"),
     cst_Raised_at=caml_string_of_jsbytes("Raised at"),
     cst_Re_raised_at=caml_string_of_jsbytes("Re-raised at"),
     cst_Raised_by_primitive_operat=
      caml_string_of_jsbytes("Raised by primitive operation at"),
     cst_Called_from=caml_string_of_jsbytes("Called from"),
     cst_inlined=caml_string_of_jsbytes(" (inlined)"),
     cst$64=caml_string_of_jsbytes(""),
     partial=[4,0,0,0,0],
     cst_Out_of_memory=caml_string_of_jsbytes("Out of memory"),
     cst_Stack_overflow=caml_string_of_jsbytes("Stack overflow"),
     cst_Pattern_matching_failed=
      caml_string_of_jsbytes("Pattern matching failed"),
     cst_Assertion_failed=caml_string_of_jsbytes("Assertion failed"),
     cst_Undefined_recursive_module=
      caml_string_of_jsbytes("Undefined recursive module"),
     cst$62=caml_string_of_jsbytes(""),
     cst$63=caml_string_of_jsbytes(""),
     cst$60=caml_string_of_jsbytes("_"),
     locfmt=
      [0,
       [11,
        caml_string_of_jsbytes('File "'),
        [2,
         0,
         [11,
          caml_string_of_jsbytes('", line '),
          [4,
           0,
           0,
           0,
           [11,
            caml_string_of_jsbytes(", characters "),
            [4,
             0,
             0,
             0,
             [12,45,[4,0,0,0,[11,caml_string_of_jsbytes(": "),[2,0,0]]]]]]]]]],
       caml_string_of_jsbytes('File "%s", line %d, characters %d-%d: %s')],
     cst_Stdlib_Fun_Finally_raised=
      caml_string_of_jsbytes("Stdlib.Fun.Finally_raised"),
     cst_Digest_from_hex$0=caml_string_of_jsbytes("Digest.from_hex"),
     cst_Digest_from_hex=caml_string_of_jsbytes("Digest.from_hex"),
     cst_Digest_to_hex=caml_string_of_jsbytes("Digest.to_hex"),
     cst_Digest_substring=caml_string_of_jsbytes("Digest.substring"),
     cst_Random_int64=caml_string_of_jsbytes("Random.int64"),
     cst_Random_int32=caml_string_of_jsbytes("Random.int32"),
     cst_Random_int=caml_string_of_jsbytes("Random.int"),
     cst_x$1=caml_string_of_jsbytes("x"),
     cst_OCAMLRUNPARAM=caml_string_of_jsbytes("OCAMLRUNPARAM"),
     cst_CAMLRUNPARAM=caml_string_of_jsbytes("CAMLRUNPARAM"),
     cst$65=caml_string_of_jsbytes(""),
     cst_Weak_Make_hash_bucket_cann=
      caml_string_of_jsbytes("Weak.Make: hash bucket cannot grow more"),
     cst_Weak_fill=caml_string_of_jsbytes("Weak.fill"),
     cst_Weak_blit=caml_string_of_jsbytes("Weak.blit"),
     cst_Weak_check=caml_string_of_jsbytes("Weak.check"),
     cst_Weak_get_copy=caml_string_of_jsbytes("Weak.get_copy"),
     cst_Weak_get=caml_string_of_jsbytes("Weak.get"),
     cst_Weak_set=caml_string_of_jsbytes("Weak.set"),
     cst_Weak_create=caml_string_of_jsbytes("Weak.create"),
     cst$83=caml_string_of_jsbytes(""),
     cst$84=caml_string_of_jsbytes(""),
     cst$82=caml_string_of_jsbytes("."),
     cst$79=caml_string_of_jsbytes(">"),
     cst$80=caml_string_of_jsbytes("<\/"),
     cst$81=caml_string_of_jsbytes(""),
     cst$76=caml_string_of_jsbytes(">"),
     cst$77=caml_string_of_jsbytes("<"),
     cst$78=caml_string_of_jsbytes(""),
     cst$75=caml_string_of_jsbytes("\n"),
     cst_Format_pp_set_geometry_max=
      caml_string_of_jsbytes("Format.pp_set_geometry: max_indent < 2"),
     cst_Format_pp_set_geometry_mar=
      caml_string_of_jsbytes("Format.pp_set_geometry: margin <= max_indent"),
     cst$71=caml_string_of_jsbytes(""),
     cst$72=caml_string_of_jsbytes(""),
     cst$73=caml_string_of_jsbytes(""),
     cst$74=caml_string_of_jsbytes(""),
     cst$67=caml_string_of_jsbytes(""),
     cst$68=caml_string_of_jsbytes(""),
     cst$69=caml_string_of_jsbytes(""),
     cst$70=caml_string_of_jsbytes(""),
     cst$66=caml_string_of_jsbytes(""),
     cst_Stdlib_Format_String_tag=
      caml_string_of_jsbytes("Stdlib.Format.String_tag"),
     cst_end_of_input_not_found=
      caml_string_of_jsbytes("end of input not found"),
     cst_scanf_bad_conversion_a=
      caml_string_of_jsbytes('scanf: bad conversion "%a"'),
     cst_scanf_bad_conversion_t=
      caml_string_of_jsbytes('scanf: bad conversion "%t"'),
     cst_scanf_missing_reader=caml_string_of_jsbytes("scanf: missing reader"),
     cst_scanf_bad_conversion_custo=
      caml_string_of_jsbytes('scanf: bad conversion "%?" (custom converter)'),
     cst_scanf_bad_conversion=
      caml_string_of_jsbytes('scanf: bad conversion "%*"'),
     cst_scanf_bad_conversion$0=
      caml_string_of_jsbytes('scanf: bad conversion "%*"'),
     cst_scanf_bad_conversion$1=
      caml_string_of_jsbytes('scanf: bad conversion "%-"'),
     cst_scanf_bad_conversion$2=
      caml_string_of_jsbytes('scanf: bad conversion "%*"'),
     cst$90=caml_string_of_jsbytes('"'),
     cst$91=caml_string_of_jsbytes('"'),
     cst$88=caml_string_of_jsbytes('"'),
     cst$89=caml_string_of_jsbytes('"'),
     cst$87=caml_string_of_jsbytes('"'),
     cst_in_format=caml_string_of_jsbytes(' in format "'),
     cst_an=caml_string_of_jsbytes("an"),
     cst_x$2=caml_string_of_jsbytes("x"),
     cst_nfinity=caml_string_of_jsbytes("nfinity"),
     cst_digits=caml_string_of_jsbytes("digits"),
     cst_decimal_digits=caml_string_of_jsbytes("decimal digits"),
     cst_0b=caml_string_of_jsbytes("0b"),
     cst_0o=caml_string_of_jsbytes("0o"),
     cst_0u=caml_string_of_jsbytes("0u"),
     cst_0x=caml_string_of_jsbytes("0x"),
     cst_false$3=caml_string_of_jsbytes("false"),
     cst_true$3=caml_string_of_jsbytes("true"),
     cst_not_a_valid_float_in_hexad=
      caml_string_of_jsbytes("not a valid float in hexadecimal notation"),
     cst_no_dot_or_exponent_part_fo=
      caml_string_of_jsbytes("no dot or exponent part found in float token"),
     cst$86=caml_string_of_jsbytes("-"),
     cst_unnamed_function=caml_string_of_jsbytes("unnamed function"),
     cst_unnamed_character_string=
      caml_string_of_jsbytes("unnamed character string"),
     cst_unnamed_Stdlib_input_chann=
      caml_string_of_jsbytes("unnamed Stdlib input channel"),
     cst$85=caml_string_of_jsbytes("-"),
     cst_Stdlib_Scanf_Scan_failure=
      caml_string_of_jsbytes("Stdlib.Scanf.Scan_failure"),
     cst_binary=caml_string_of_jsbytes("binary"),
     cst_octal=caml_string_of_jsbytes("octal"),
     cst_hexadecimal=caml_string_of_jsbytes("hexadecimal"),
     cst_a_Char=caml_string_of_jsbytes("a Char"),
     cst_a_String=caml_string_of_jsbytes("a String"),
     cst$92=caml_string_of_jsbytes(""),
     cst$93=caml_string_of_jsbytes(""),
     cst$94=caml_string_of_jsbytes(""),
     cst$95=caml_string_of_jsbytes(""),
     cst$96=caml_string_of_jsbytes(""),
     cst$98=caml_string_of_jsbytes(""),
     cst$97=caml_string_of_jsbytes(""),
     cst_Illegal_character=caml_string_of_jsbytes("Illegal character "),
     cst_Filename_chop_extension=
      caml_string_of_jsbytes("Filename.chop_extension"),
     cst$126=caml_string_of_jsbytes(""),
     cst_Filename_chop_suffix=caml_string_of_jsbytes("Filename.chop_suffix"),
     cst$125=caml_string_of_jsbytes(""),
     cst_2_1$0=caml_string_of_jsbytes(" 2>&1"),
     cst_2$0=caml_string_of_jsbytes(" 2>"),
     cst$124=caml_string_of_jsbytes(""),
     cst$116=caml_string_of_jsbytes(" >"),
     cst$123=caml_string_of_jsbytes(""),
     cst$117=caml_string_of_jsbytes(" <"),
     cst$122=caml_string_of_jsbytes(""),
     cst$118=caml_string_of_jsbytes(" "),
     cst$119=caml_string_of_jsbytes(" "),
     cst$120=caml_string_of_jsbytes('"'),
     cst$121=caml_string_of_jsbytes(""),
     cst_Filename_quote_command_bad=
      caml_string_of_jsbytes("Filename.quote_command: bad file name "),
     cst$114=caml_string_of_jsbytes('"'),
     cst$115=caml_string_of_jsbytes('"'),
     cst$112=caml_string_of_jsbytes("./"),
     cst$111=caml_string_of_jsbytes(".\\"),
     cst$110=caml_string_of_jsbytes("../"),
     cst$109=caml_string_of_jsbytes("..\\"),
     cst_2_1=caml_string_of_jsbytes(" 2>&1"),
     cst_2=caml_string_of_jsbytes(" 2>"),
     cst$108=caml_string_of_jsbytes(""),
     cst$103=caml_string_of_jsbytes(" >"),
     cst$107=caml_string_of_jsbytes(""),
     cst$104=caml_string_of_jsbytes(" <"),
     cst$106=caml_string_of_jsbytes(""),
     cst$105=caml_string_of_jsbytes(" "),
     cst$102=caml_string_of_jsbytes("./"),
     cst$101=caml_string_of_jsbytes("../"),
     cst$100=caml_string_of_jsbytes(""),
     cst$99=caml_string_of_jsbytes(""),
     null$0=caml_string_of_jsbytes("/dev/null"),
     current_dir_name=caml_string_of_jsbytes("."),
     parent_dir_name=caml_string_of_jsbytes(".."),
     dir_sep=caml_string_of_jsbytes("/"),
     cst_TMPDIR=caml_string_of_jsbytes("TMPDIR"),
     cst_tmp=caml_string_of_jsbytes("/tmp"),
     quotequote=caml_string_of_jsbytes("'\\''"),
     null$1=caml_string_of_jsbytes("NUL"),
     current_dir_name$0=caml_string_of_jsbytes("."),
     parent_dir_name$0=caml_string_of_jsbytes(".."),
     dir_sep$0=caml_string_of_jsbytes("\\"),
     cst_TEMP=caml_string_of_jsbytes("TEMP"),
     cst$113=caml_string_of_jsbytes("."),
     null$2=caml_string_of_jsbytes("/dev/null"),
     current_dir_name$1=caml_string_of_jsbytes("."),
     parent_dir_name$1=caml_string_of_jsbytes(".."),
     dir_sep$1=caml_string_of_jsbytes("/"),
     cst_Cygwin=caml_string_of_jsbytes("Cygwin"),
     cst_Win32=caml_string_of_jsbytes("Win32"),
     zero$4=[254,0.,0.],
     one$4=[254,1.,0.],
     i=[254,0.,1.],
     cst_Series_is_closed$0=caml_string_of_jsbytes("Series is closed"),
     cst_Series_is_closed=caml_string_of_jsbytes("Series is closed"),
     cst_Bigarray_array3_of_genarra=
      caml_string_of_jsbytes("Bigarray.array3_of_genarray"),
     cst_Bigarray_array2_of_genarra=
      caml_string_of_jsbytes("Bigarray.array2_of_genarray"),
     cst_Bigarray_array1_of_genarra=
      caml_string_of_jsbytes("Bigarray.array1_of_genarray"),
     cst_Bigarray_array0_of_genarra=
      caml_string_of_jsbytes("Bigarray.array0_of_genarray"),
     cst_Bigarray_Array3_of_array_n=
      caml_string_of_jsbytes("Bigarray.Array3.of_array: non-cubic data"),
     cst_Bigarray_Array3_of_array_n$0=
      caml_string_of_jsbytes("Bigarray.Array3.of_array: non-cubic data"),
     cst_Bigarray_Array2_of_array_n=
      caml_string_of_jsbytes("Bigarray.Array2.of_array: non-rectangular data"),
     Invalid_argument=global_data.Invalid_argument,
     Failure=global_data.Failure,
     Match_failure=global_data.Match_failure,
     Assert_failure=global_data.Assert_failure,
     Not_found=global_data.Not_found,
     Out_of_memory=global_data.Out_of_memory,
     Stack_overflow=global_data.Stack_overflow,
     Sys_error=global_data.Sys_error,
     End_of_file=global_data.End_of_file,
     Division_by_zero=global_data.Division_by_zero,
     Sys_blocked_io=global_data.Sys_blocked_io,
     Undefined_recursive_module=global_data.Undefined_recursive_module,
     _l_=[0,0,[0,6,0]],
     _k_=[0,0,[0,7,0]],
     _j_=[0,1,[0,3,[0,4,[0,6,0]]]],
     _i_=[0,1,[0,3,[0,4,[0,7,0]]]],
     _g_=[0,1],
     _h_=[0,0],
     _a_=runtime.caml_int64_create_lo_mi_hi(0,0,32752),
     _b_=runtime.caml_int64_create_lo_mi_hi(0,0,65520),
     _c_=runtime.caml_int64_create_lo_mi_hi(1,0,32752),
     _d_=runtime.caml_int64_create_lo_mi_hi(16777215,16777215,32751),
     _e_=runtime.caml_int64_create_lo_mi_hi(0,0,16),
     _f_=runtime.caml_int64_create_lo_mi_hi(0,0,15536),
     _o_=[0,0,0],
     _s_=[0,caml_string_of_jsbytes("array.ml"),238,4],
     _u_=[0,caml_string_of_jsbytes("float.ml"),381,6],
     _t_=[0,caml_string_of_jsbytes("float.ml"),208,14],
     _F_=runtime.caml_int64_create_lo_mi_hi(16777215,16777215,65535),
     _E_=runtime.caml_int64_create_lo_mi_hi(0,0,0),
     _D_=runtime.caml_int64_create_lo_mi_hi(1,0,0),
     _C_=runtime.caml_int64_create_lo_mi_hi(1,0,0),
     _G_=[0,0,0,0],
     _H_=[0,0,0],
     _I_=[0,caml_string_of_jsbytes("set.ml"),547,18],
     _J_=[0,0,0,0],
     _K_=[0,caml_string_of_jsbytes("map.ml"),398,10],
     _L_=[0,0,0],
     _M_=[0,caml_string_of_jsbytes("stream.ml"),53,12],
     _N_=[0,0],
     _O_=[0,caml_string_of_jsbytes("stream.ml"),82,12],
     _Y_=[0,caml_string_of_jsbytes("buffer.ml"),282,9],
     _X_=[0,caml_string_of_jsbytes("buffer.ml"),263,2],
     _W_=[0,caml_string_of_jsbytes("buffer.ml"),195,19],
     _V_=[0,caml_string_of_jsbytes("buffer.ml"),213,8],
     _U_=[0,caml_string_of_jsbytes("buffer.ml"),174,19],
     _T_=[0,caml_string_of_jsbytes("buffer.ml"),192,8],
     _S_=[0,caml_string_of_jsbytes("buffer.ml"),138,19],
     _R_=[0,caml_string_of_jsbytes("buffer.ml"),171,8],
     _Q_=[0,caml_string_of_jsbytes("buffer.ml"),93,2],
     _P_=[0,caml_string_of_jsbytes("buffer.ml"),94,2],
     ___=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),850,23],
     _aj_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),814,21],
     _ab_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),815,21],
     _ak_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),818,21],
     _ac_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),819,21],
     _al_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),822,19],
     _ad_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),823,19],
     _am_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),826,22],
     _ae_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),827,22],
     _an_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),831,30],
     _af_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),832,30],
     _ah_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),836,26],
     _$_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),837,26],
     _ai_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),846,28],
     _aa_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),847,28],
     _ag_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),851,23],
     _ap_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),1558,4],
     _aq_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),1626,39],
     _ar_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),1649,31],
     _as_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),1650,31],
     _at_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),1830,8],
     _aX_=
      [0,
       [11,
        caml_string_of_jsbytes("bad input: format type mismatch between "),
        [3,0,[11,caml_string_of_jsbytes(" and "),[3,0,0]]]],
       caml_string_of_jsbytes
        ("bad input: format type mismatch between %S and %S")],
     _aW_=
      [0,
       [11,
        caml_string_of_jsbytes("bad input: format type mismatch between "),
        [3,0,[11,caml_string_of_jsbytes(" and "),[3,0,0]]]],
       caml_string_of_jsbytes
        ("bad input: format type mismatch between %S and %S")],
     _az_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": at character number "),
          [4,0,0,0,[11,caml_string_of_jsbytes(", duplicate flag "),[1,0]]]]]],
       caml_string_of_jsbytes
        ("invalid format %S: at character number %d, duplicate flag %C")],
     _aA_=[0,1,0],
     _aB_=[0,0],
     _aC_=[1,0],
     _aD_=[1,1],
     _aF_=[1,1],
     _aE_=[1,1],
     _aJ_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": at character number "),
          [4,
           0,
           0,
           0,
           [11,
            caml_string_of_jsbytes(", flag "),
            [1,
             [11,
              caml_string_of_jsbytes(" is only allowed after the '"),
              [12,
               37,
               [11,
                caml_string_of_jsbytes("', before padding and precision"),
                0]]]]]]]]],
       caml_string_of_jsbytes
        ("invalid format %S: at character number %d, flag %C is only allowed after the '%%', before padding and precision")],
     _aG_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": at character number "),
          [4,
           0,
           0,
           0,
           [11,
            caml_string_of_jsbytes(', invalid conversion "'),
            [12,37,[0,[12,34,0]]]]]]]],
       caml_string_of_jsbytes
        ('invalid format %S: at character number %d, invalid conversion "%%%c"')],
     _aH_=[0,0],
     _aI_=[0,0],
     _aK_=[0,[12,64,0]],
     _aL_=[0,caml_string_of_jsbytes("@ "),1,0],
     _aM_=[0,caml_string_of_jsbytes("@,"),0,0],
     _aN_=[2,60],
     _aO_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": '"),
          [12,
           37,
           [11,
            caml_string_of_jsbytes
             ("' alone is not accepted in character sets, use "),
            [12,
             37,
             [12,
              37,
              [11,
               caml_string_of_jsbytes(" instead at position "),
               [4,0,0,0,[12,46,0]]]]]]]]]],
       caml_string_of_jsbytes
        ("invalid format %S: '%%' alone is not accepted in character sets, use %%%% instead at position %d.")],
     _aP_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": integer "),
          [4,
           0,
           0,
           0,
           [11,
            caml_string_of_jsbytes(" is greater than the limit "),
            [4,0,0,0,0]]]]]],
       caml_string_of_jsbytes
        ("invalid format %S: integer %d is greater than the limit %d")],
     _aQ_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),2837,11],
     _aR_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(': unclosed sub-format, expected "'),
          [12,
           37,
           [0,
            [11,caml_string_of_jsbytes('" at character number '),[4,0,0,0,0]]]]]]],
       caml_string_of_jsbytes
        ('invalid format %S: unclosed sub-format, expected "%%%c" at character number %d')],
     _aS_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),2899,34],
     _aT_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),2935,28],
     _aU_=[0,caml_string_of_jsbytes("camlinternalFormat.ml"),2957,11],
     _aV_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": at character number "),
          [4,
           0,
           0,
           0,
           [11,
            caml_string_of_jsbytes(", "),
            [2,
             0,
             [11,
              caml_string_of_jsbytes(" is incompatible with '"),
              [0,[11,caml_string_of_jsbytes("' in sub-format "),[3,0,0]]]]]]]]]],
       caml_string_of_jsbytes
        ("invalid format %S: at character number %d, %s is incompatible with '%c' in sub-format %S")],
     _ay_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": at character number "),
          [4,
           0,
           0,
           0,
           [11,
            caml_string_of_jsbytes(", "),
            [2,0,[11,caml_string_of_jsbytes(" expected, read "),[1,0]]]]]]]],
       caml_string_of_jsbytes
        ("invalid format %S: at character number %d, %s expected, read %C")],
     _ax_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": at character number "),
          [4,
           0,
           0,
           0,
           [11,
            caml_string_of_jsbytes(", '"),
            [0,[11,caml_string_of_jsbytes("' without "),[2,0,0]]]]]]]],
       caml_string_of_jsbytes
        ("invalid format %S: at character number %d, '%c' without %s")],
     _aw_=
      [0,
       [11,
        caml_string_of_jsbytes("invalid format "),
        [3,
         0,
         [11,
          caml_string_of_jsbytes(": at character number "),
          [4,0,0,0,[11,caml_string_of_jsbytes(", "),[2,0,0]]]]]],
       caml_string_of_jsbytes("invalid format %S: at character number %d, %s")],
     _av_=
      [0,
       [11,caml_string_of_jsbytes("invalid box description "),[3,0,0]],
       caml_string_of_jsbytes("invalid box description %S")],
     _au_=[0,0,4],
     _ao_=[0,103],
     _Z_=[0,0,0],
     _bh_=[0,[2,0,[0,0]],caml_string_of_jsbytes("%s%c")],
     _bb_=[0,[2,0,0],caml_string_of_jsbytes("%s")],
     _bc_=[0,[2,0,0],caml_string_of_jsbytes("%s")],
     _a$_=[0,[2,0,0],caml_string_of_jsbytes("%s")],
     _ba_=[0,[2,0,0],caml_string_of_jsbytes("%s")],
     _a9_=[0,[2,0,0],caml_string_of_jsbytes("%s")],
     _a__=[0,[2,0,0],caml_string_of_jsbytes("%s")],
     _a3_=
      [0,
       [2,
        0,
        [11,
         caml_string_of_jsbytes(": unknown option '"),
         [2,0,[11,caml_string_of_jsbytes("'.\n"),0]]]],
       caml_string_of_jsbytes("%s: unknown option '%s'.\n")],
     _a6_=
      [0,
       [2,
        0,
        [11,
         caml_string_of_jsbytes(": wrong argument '"),
         [2,
          0,
          [11,
           caml_string_of_jsbytes("'; option '"),
           [2,
            0,
            [11,
             caml_string_of_jsbytes("' expects "),
             [2,0,[11,caml_string_of_jsbytes(".\n"),0]]]]]]]],
       caml_string_of_jsbytes
        ("%s: wrong argument '%s'; option '%s' expects %s.\n")],
     _a7_=
      [0,
       [2,
        0,
        [11,
         caml_string_of_jsbytes(": option '"),
         [2,0,[11,caml_string_of_jsbytes("' needs an argument.\n"),0]]]],
       caml_string_of_jsbytes("%s: option '%s' needs an argument.\n")],
     _a8_=
      [0,
       [2,
        0,
        [11,
         caml_string_of_jsbytes(": "),
         [2,0,[11,caml_string_of_jsbytes(".\n"),0]]]],
       caml_string_of_jsbytes("%s: %s.\n")],
     _a4_=[0,caml_string_of_jsbytes("-help")],
     _a5_=[0,caml_string_of_jsbytes("--help")],
     _a2_=[0,[2,0,0],caml_string_of_jsbytes("%s")],
     _a1_=[0,[2,0,[12,10,0]],caml_string_of_jsbytes("%s\n")],
     _a0_=[0,caml_string_of_jsbytes("-help")],
     _aY_=
      [0,
       [11,caml_string_of_jsbytes("  "),[2,0,[12,32,[2,0,[12,10,0]]]]],
       caml_string_of_jsbytes("  %s %s\n")],
     _aZ_=
      [0,
       [11,caml_string_of_jsbytes("  "),[2,0,[12,32,[2,0,[2,0,[12,10,0]]]]]],
       caml_string_of_jsbytes("  %s %s%s\n")],
     _bm_=
      [0,
       [11,caml_string_of_jsbytes(", "),[2,0,[2,0,0]]],
       caml_string_of_jsbytes(", %s%s")],
     _bv_=[0,[2,0,[12,10,0]],caml_string_of_jsbytes("%s\n")],
     _bt_=[0,[2,0,[12,10,0]],caml_string_of_jsbytes("%s\n")],
     _bu_=
      [0,
       [11,
        caml_string_of_jsbytes
         ("(Program not linked with -g, cannot print stack backtrace)\n"),
        0],
       caml_string_of_jsbytes
        ("(Program not linked with -g, cannot print stack backtrace)\n")],
     _br_=
      [0,
       [2,
        0,
        [11,
         caml_string_of_jsbytes(' file "'),
         [2,
          0,
          [12,
           34,
           [2,
            0,
            [11,
             caml_string_of_jsbytes(", line "),
             [4,
              0,
              0,
              0,
              [11,
               caml_string_of_jsbytes(", characters "),
               [4,0,0,0,[12,45,partial]]]]]]]]]],
       caml_string_of_jsbytes('%s file "%s"%s, line %d, characters %d-%d')],
     _bs_=
      [0,
       [2,0,[11,caml_string_of_jsbytes(" unknown location"),0]],
       caml_string_of_jsbytes("%s unknown location")],
     _bq_=
      [0,
       [11,caml_string_of_jsbytes("Uncaught exception: "),[2,0,[12,10,0]]],
       caml_string_of_jsbytes("Uncaught exception: %s\n")],
     _bp_=
      [0,
       [11,caml_string_of_jsbytes("Uncaught exception: "),[2,0,[12,10,0]]],
       caml_string_of_jsbytes("Uncaught exception: %s\n")],
     _bn_=[0,[12,40,[2,0,[2,0,[12,41,0]]]],caml_string_of_jsbytes("(%s%s)")],
     _bo_=[0,[12,40,[2,0,[12,41,0]]],caml_string_of_jsbytes("(%s)")],
     _bl_=[0,[4,0,0,0,0],caml_string_of_jsbytes("%d")],
     _bk_=[0,[3,0,0],caml_string_of_jsbytes("%S")],
     _bD_=
      [0,
       [11,caml_string_of_jsbytes("minor_collections: "),[4,0,0,0,[12,10,0]]],
       caml_string_of_jsbytes("minor_collections: %d\n")],
     _bE_=
      [0,
       [11,caml_string_of_jsbytes("major_collections: "),[4,0,0,0,[12,10,0]]],
       caml_string_of_jsbytes("major_collections: %d\n")],
     _bF_=
      [0,
       [11,caml_string_of_jsbytes("compactions:       "),[4,0,0,0,[12,10,0]]],
       caml_string_of_jsbytes("compactions:       %d\n")],
     _bG_=[0,[12,10,0],caml_string_of_jsbytes("\n")],
     _bH_=[0,[8,[0,0,0],0,[0,0],0],caml_string_of_jsbytes("%.0f")],
     _bI_=
      [0,
       [11,
        caml_string_of_jsbytes("minor_words:    "),
        [8,[0,0,0],[1,1],[0,0],[12,10,0]]],
       caml_string_of_jsbytes("minor_words:    %*.0f\n")],
     _bJ_=
      [0,
       [11,
        caml_string_of_jsbytes("promoted_words: "),
        [8,[0,0,0],[1,1],[0,0],[12,10,0]]],
       caml_string_of_jsbytes("promoted_words: %*.0f\n")],
     _bK_=
      [0,
       [11,
        caml_string_of_jsbytes("major_words:    "),
        [8,[0,0,0],[1,1],[0,0],[12,10,0]]],
       caml_string_of_jsbytes("major_words:    %*.0f\n")],
     _bL_=[0,[12,10,0],caml_string_of_jsbytes("\n")],
     _bM_=[0,[4,0,0,0,0],caml_string_of_jsbytes("%d")],
     _bN_=
      [0,
       [11,caml_string_of_jsbytes("top_heap_words: "),[4,0,[1,1],0,[12,10,0]]],
       caml_string_of_jsbytes("top_heap_words: %*d\n")],
     _bO_=
      [0,
       [11,caml_string_of_jsbytes("heap_words:     "),[4,0,[1,1],0,[12,10,0]]],
       caml_string_of_jsbytes("heap_words:     %*d\n")],
     _bP_=
      [0,
       [11,caml_string_of_jsbytes("live_words:     "),[4,0,[1,1],0,[12,10,0]]],
       caml_string_of_jsbytes("live_words:     %*d\n")],
     _bQ_=
      [0,
       [11,caml_string_of_jsbytes("free_words:     "),[4,0,[1,1],0,[12,10,0]]],
       caml_string_of_jsbytes("free_words:     %*d\n")],
     _bR_=
      [0,
       [11,caml_string_of_jsbytes("largest_free:   "),[4,0,[1,1],0,[12,10,0]]],
       caml_string_of_jsbytes("largest_free:   %*d\n")],
     _bS_=
      [0,
       [11,caml_string_of_jsbytes("fragments:      "),[4,0,[1,1],0,[12,10,0]]],
       caml_string_of_jsbytes("fragments:      %*d\n")],
     _bT_=[0,[12,10,0],caml_string_of_jsbytes("\n")],
     _bU_=
      [0,
       [11,caml_string_of_jsbytes("live_blocks: "),[4,0,0,0,[12,10,0]]],
       caml_string_of_jsbytes("live_blocks: %d\n")],
     _bV_=
      [0,
       [11,caml_string_of_jsbytes("free_blocks: "),[4,0,0,0,[12,10,0]]],
       caml_string_of_jsbytes("free_blocks: %d\n")],
     _bW_=
      [0,
       [11,caml_string_of_jsbytes("heap_chunks: "),[4,0,0,0,[12,10,0]]],
       caml_string_of_jsbytes("heap_chunks: %d\n")],
     _bZ_=runtime.caml_int64_create_lo_mi_hi(1,0,0),
     _b0_=runtime.caml_int64_create_lo_mi_hi(0,0,0),
     _b1_=
      [0,
       987910699,
       495797812,
       364182224,
       414272206,
       318284740,
       990407751,
       383018966,
       270373319,
       840823159,
       24560019,
       536292337,
       512266505,
       189156120,
       730249596,
       143776328,
       51606627,
       140166561,
       366354223,
       1003410265,
       700563762,
       981890670,
       913149062,
       526082594,
       1021425055,
       784300257,
       667753350,
       630144451,
       949649812,
       48546892,
       415514493,
       258888527,
       511570777,
       89983870,
       283659902,
       308386020,
       242688715,
       482270760,
       865188196,
       1027664170,
       207196989,
       193777847,
       619708188,
       671350186,
       149669678,
       257044018,
       87658204,
       558145612,
       183450813,
       28133145,
       901332182,
       710253903,
       510646120,
       652377910,
       409934019,
       801085050],
     _b5_=[0,0],
     _b4_=[0,caml_string_of_jsbytes("hashtbl.ml"),102,23],
     _b8_=[3,0,3],
     _b7_=[0,caml_string_of_jsbytes("")],
     _b6_=[0,caml_string_of_jsbytes(""),0,caml_string_of_jsbytes("")],
     _cm_=[0,91],
     _cl_=[0,123],
     _cn_=[0,caml_string_of_jsbytes("scanf.ml"),1453,13],
     _co_=[0,[3,0,[10,0]],caml_string_of_jsbytes("%S%!")],
     _ck_=[0,37,caml_string_of_jsbytes("")],
     _cj_=
      [0,
       [11,
        caml_string_of_jsbytes("scanf: bad input at char number "),
        [4,3,0,0,[11,caml_string_of_jsbytes(": "),[2,0,0]]]],
       caml_string_of_jsbytes("scanf: bad input at char number %i: %s")],
     _ci_=
      [0,
       [11,
        caml_string_of_jsbytes("the character "),
        [1,[11,caml_string_of_jsbytes(" cannot start a boolean"),0]]],
       caml_string_of_jsbytes("the character %C cannot start a boolean")],
     _ch_=
      [0,
       [11,
        caml_string_of_jsbytes("bad character hexadecimal encoding \\"),
        [0,[0,0]]],
       caml_string_of_jsbytes("bad character hexadecimal encoding \\%c%c")],
     _cg_=
      [0,
       [11,
        caml_string_of_jsbytes("bad character decimal encoding \\"),
        [0,[0,[0,0]]]],
       caml_string_of_jsbytes("bad character decimal encoding \\%c%c%c")],
     _cf_=
      [0,
       [11,
        caml_string_of_jsbytes("character "),
        [1,
         [11,
          caml_string_of_jsbytes(" is not a valid "),
          [2,0,[11,caml_string_of_jsbytes(" digit"),0]]]]],
       caml_string_of_jsbytes("character %C is not a valid %s digit")],
     _ce_=
      [0,
       [11,
        caml_string_of_jsbytes("character "),
        [1,[11,caml_string_of_jsbytes(" is not a decimal digit"),0]]],
       caml_string_of_jsbytes("character %C is not a decimal digit")],
     _cd_=[0,caml_string_of_jsbytes("scanf.ml"),555,9],
     _cc_=
      [0,
       [11,caml_string_of_jsbytes("invalid boolean '"),[2,0,[12,39,0]]],
       caml_string_of_jsbytes("invalid boolean '%s'")],
     _cb_=
      [0,
       [11,
        caml_string_of_jsbytes("looking for "),
        [1,[11,caml_string_of_jsbytes(", found "),[1,0]]]],
       caml_string_of_jsbytes("looking for %C, found %C")],
     _ca_=
      [0,
       [11,
        caml_string_of_jsbytes("scanning of "),
        [2,
         0,
         [11,
          caml_string_of_jsbytes
           (" failed: premature end of file occurred before end of token"),
          0]]],
       caml_string_of_jsbytes
        ("scanning of %s failed: premature end of file occurred before end of token")],
     _b$_=
      [0,
       [11,
        caml_string_of_jsbytes("scanning of "),
        [2,
         0,
         [11,
          caml_string_of_jsbytes
           (" failed: the specified length was too short for token"),
          0]]],
       caml_string_of_jsbytes
        ("scanning of %s failed: the specified length was too short for token")],
     _b__=
      [0,
       [11,caml_string_of_jsbytes("illegal escape character "),[1,0]],
       caml_string_of_jsbytes("illegal escape character %C")],
     _cv_=[0,caml_string_of_jsbytes("camlinternalOO.ml"),438,17],
     _cu_=[0,caml_string_of_jsbytes("camlinternalOO.ml"),420,13],
     _ct_=[0,caml_string_of_jsbytes("camlinternalOO.ml"),417,13],
     _cs_=[0,caml_string_of_jsbytes("camlinternalOO.ml"),414,13],
     _cr_=[0,caml_string_of_jsbytes("camlinternalOO.ml"),411,13],
     _cq_=[0,caml_string_of_jsbytes("camlinternalOO.ml"),408,13],
     _cp_=[0,caml_string_of_jsbytes("camlinternalOO.ml"),281,50],
     _cy_=[0,0],
     _cx_=[0,0],
     _cw_=[0,0],
     _cD_=[0,7,0],
     _cC_=[0,1,[0,3,[0,5,0]]],
     _cB_=[0,[2,0,[4,6,[0,2,6],0,[2,0,0]]],caml_string_of_jsbytes("%s%06x%s")],
     _cA_=[0,caml_string_of_jsbytes('"'),0],
     _cE_=[254,0.,0.];
    function erase_rel(param)
     {if(typeof param === "number")
       return 0;
      else
       switch(param[0])
        {case 0:var rest=param[1];return [0,erase_rel(rest)];
         case 1:var rest$0=param[1];return [1,erase_rel(rest$0)];
         case 2:var rest$1=param[1];return [2,erase_rel(rest$1)];
         case 3:var rest$2=param[1];return [3,erase_rel(rest$2)];
         case 4:var rest$3=param[1];return [4,erase_rel(rest$3)];
         case 5:var rest$4=param[1];return [5,erase_rel(rest$4)];
         case 6:var rest$5=param[1];return [6,erase_rel(rest$5)];
         case 7:var rest$6=param[1];return [7,erase_rel(rest$6)];
         case 8:
          var rest$7=param[2],ty=param[1];return [8,ty,erase_rel(rest$7)];
         case 9:
          var rest$8=param[3],ty1=param[1];
          return [9,ty1,ty1,erase_rel(rest$8)];
         case 10:var rest$9=param[1];return [10,erase_rel(rest$9)];
         case 11:var rest$10=param[1];return [11,erase_rel(rest$10)];
         case 12:var rest$11=param[1];return [12,erase_rel(rest$11)];
         case 13:var rest$12=param[1];return [13,erase_rel(rest$12)];
         default:var rest$13=param[1];return [14,erase_rel(rest$13)]}}
    function concat_fmtty(fmtty1,fmtty2)
     {if(typeof fmtty1 === "number")
       return fmtty2;
      else
       switch(fmtty1[0])
        {case 0:var rest=fmtty1[1];return [0,concat_fmtty(rest,fmtty2)];
         case 1:var rest$0=fmtty1[1];return [1,concat_fmtty(rest$0,fmtty2)];
         case 2:var rest$1=fmtty1[1];return [2,concat_fmtty(rest$1,fmtty2)];
         case 3:var rest$2=fmtty1[1];return [3,concat_fmtty(rest$2,fmtty2)];
         case 4:var rest$3=fmtty1[1];return [4,concat_fmtty(rest$3,fmtty2)];
         case 5:var rest$4=fmtty1[1];return [5,concat_fmtty(rest$4,fmtty2)];
         case 6:var rest$5=fmtty1[1];return [6,concat_fmtty(rest$5,fmtty2)];
         case 7:var rest$6=fmtty1[1];return [7,concat_fmtty(rest$6,fmtty2)];
         case 8:
          var rest$7=fmtty1[2],ty=fmtty1[1];
          return [8,ty,concat_fmtty(rest$7,fmtty2)];
         case 9:
          var rest$8=fmtty1[3],ty2=fmtty1[2],ty1=fmtty1[1];
          return [9,ty1,ty2,concat_fmtty(rest$8,fmtty2)];
         case 10:var rest$9=fmtty1[1];return [10,concat_fmtty(rest$9,fmtty2)];
         case 11:
          var rest$10=fmtty1[1];return [11,concat_fmtty(rest$10,fmtty2)];
         case 12:
          var rest$11=fmtty1[1];return [12,concat_fmtty(rest$11,fmtty2)];
         case 13:
          var rest$12=fmtty1[1];return [13,concat_fmtty(rest$12,fmtty2)];
         default:
          var rest$13=fmtty1[1];return [14,concat_fmtty(rest$13,fmtty2)]}}
    function concat_fmt(fmt1,fmt2)
     {if(typeof fmt1 === "number")
       return fmt2;
      else
       switch(fmt1[0])
        {case 0:var rest=fmt1[1];return [0,concat_fmt(rest,fmt2)];
         case 1:var rest$0=fmt1[1];return [1,concat_fmt(rest$0,fmt2)];
         case 2:
          var rest$1=fmt1[2],pad=fmt1[1];
          return [2,pad,concat_fmt(rest$1,fmt2)];
         case 3:
          var rest$2=fmt1[2],pad$0=fmt1[1];
          return [3,pad$0,concat_fmt(rest$2,fmt2)];
         case 4:
          var rest$3=fmt1[4],prec=fmt1[3],pad$1=fmt1[2],iconv=fmt1[1];
          return [4,iconv,pad$1,prec,concat_fmt(rest$3,fmt2)];
         case 5:
          var rest$4=fmt1[4],prec$0=fmt1[3],pad$2=fmt1[2],iconv$0=fmt1[1];
          return [5,iconv$0,pad$2,prec$0,concat_fmt(rest$4,fmt2)];
         case 6:
          var rest$5=fmt1[4],prec$1=fmt1[3],pad$3=fmt1[2],iconv$1=fmt1[1];
          return [6,iconv$1,pad$3,prec$1,concat_fmt(rest$5,fmt2)];
         case 7:
          var rest$6=fmt1[4],prec$2=fmt1[3],pad$4=fmt1[2],iconv$2=fmt1[1];
          return [7,iconv$2,pad$4,prec$2,concat_fmt(rest$6,fmt2)];
         case 8:
          var rest$7=fmt1[4],prec$3=fmt1[3],pad$5=fmt1[2],fconv=fmt1[1];
          return [8,fconv,pad$5,prec$3,concat_fmt(rest$7,fmt2)];
         case 9:
          var rest$8=fmt1[2],pad$6=fmt1[1];
          return [9,pad$6,concat_fmt(rest$8,fmt2)];
         case 10:var rest$9=fmt1[1];return [10,concat_fmt(rest$9,fmt2)];
         case 11:
          var rest$10=fmt1[2],str=fmt1[1];
          return [11,str,concat_fmt(rest$10,fmt2)];
         case 12:
          var rest$11=fmt1[2],chr=fmt1[1];
          return [12,chr,concat_fmt(rest$11,fmt2)];
         case 13:
          var rest$12=fmt1[3],fmtty=fmt1[2],pad$7=fmt1[1];
          return [13,pad$7,fmtty,concat_fmt(rest$12,fmt2)];
         case 14:
          var rest$13=fmt1[3],fmtty$0=fmt1[2],pad$8=fmt1[1];
          return [14,pad$8,fmtty$0,concat_fmt(rest$13,fmt2)];
         case 15:var rest$14=fmt1[1];return [15,concat_fmt(rest$14,fmt2)];
         case 16:var rest$15=fmt1[1];return [16,concat_fmt(rest$15,fmt2)];
         case 17:
          var rest$16=fmt1[2],fmting_lit=fmt1[1];
          return [17,fmting_lit,concat_fmt(rest$16,fmt2)];
         case 18:
          var rest$17=fmt1[2],fmting_gen=fmt1[1];
          return [18,fmting_gen,concat_fmt(rest$17,fmt2)];
         case 19:var rest$18=fmt1[1];return [19,concat_fmt(rest$18,fmt2)];
         case 20:
          var rest$19=fmt1[3],char_set=fmt1[2],width_opt=fmt1[1];
          return [20,width_opt,char_set,concat_fmt(rest$19,fmt2)];
         case 21:
          var rest$20=fmt1[2],counter=fmt1[1];
          return [21,counter,concat_fmt(rest$20,fmt2)];
         case 22:var rest$21=fmt1[1];return [22,concat_fmt(rest$21,fmt2)];
         case 23:
          var rest$22=fmt1[2],ign=fmt1[1];
          return [23,ign,concat_fmt(rest$22,fmt2)];
         default:
          var rest$23=fmt1[3],f=fmt1[2],arity=fmt1[1];
          return [24,arity,f,concat_fmt(rest$23,fmt2)]}}
    var CamlinternalFormatBasics=[0,concat_fmtty,erase_rel,concat_fmt];
    caml_register_global
     (734,CamlinternalFormatBasics,"CamlinternalFormatBasics");
    function failwith(s){throw [0,Failure,s]}
    function invalid_arg(s){throw [0,Invalid_argument,s]}
    var Exit=[248,cst_Stdlib_Exit,caml_fresh_oo_id(0)];
    function min(x,y){return caml_lessequal(x,y)?x:y}
    function max(x,y){return caml_greaterequal(x,y)?x:y}
    function abs(x){return 0 <= x?x:- x | 0}
    function lnot(x){return x ^ -1}
    var
     infinity=caml_int64_float_of_bits(_a_),
     neg_infinity=caml_int64_float_of_bits(_b_),
     nan=caml_int64_float_of_bits(_c_),
     max_float=caml_int64_float_of_bits(_d_),
     min_float=caml_int64_float_of_bits(_e_),
     epsilon=caml_int64_float_of_bits(_f_),
     max_int=2147483647,
     min_int=-2147483648;
    function symbol(s1,s2)
     {var
       l1=caml_ml_string_length(s1),
       l2=caml_ml_string_length(s2),
       s=caml_create_bytes(l1 + l2 | 0);
      caml_blit_string(s1,0,s,0,l1);
      caml_blit_string(s2,0,s,l1,l2);
      return caml_string_of_bytes(s)}
    function char_of_int(n)
     {if(0 <= n && ! (255 < n))return n;return invalid_arg(cst_char_of_int)}
    function string_of_bool(b){return b?cst_true:cst_false}
    function bool_of_string(param)
     {return caml_string_notequal(param,cst_false$0)
              ?caml_string_notequal(param,cst_true$0)
                ?invalid_arg(cst_bool_of_string)
                :1
              :0}
    function bool_of_string_opt(param)
     {return caml_string_notequal(param,cst_false$1)
              ?caml_string_notequal(param,cst_true$1)?0:_g_
              :_h_}
    function string_of_int(n){return caml_string_of_jsbytes("" + n)}
    function int_of_string_opt(s)
     {try
       {var _As_=[0,caml_int_of_string(s)];return _As_}
      catch(_At_)
       {_At_ = caml_wrap_exception(_At_);
        if(_At_[1] === Failure)return 0;
        throw _At_}}
    function valid_float_lexem(s)
     {var l=caml_ml_string_length(s),i=0;
      for(;;)
       {if(l <= i)return symbol(s,cst);
        var match=caml_string_get(s,i),switch$0=0;
        if(48 <= match)
         {if(! (58 <= match))switch$0 = 1}
        else
         if(45 === match)switch$0 = 1;
        if(switch$0){var i$0=i + 1 | 0,i=i$0;continue}
        return s}}
    function to_string(f)
     {return valid_float_lexem(caml_format_float(cst_12g,f))}
    function of_string_opt(s)
     {try
       {var _Aq_=[0,caml_float_of_string(s)];return _Aq_}
      catch(_Ar_)
       {_Ar_ = caml_wrap_exception(_Ar_);
        if(_Ar_[1] === Failure)return 0;
        throw _Ar_}}
    function append(l1,l2)
     {if(l1){var tl=l1[2],hd=l1[1];return [0,hd,append(tl,l2)]}return l2}
    var
     stdin=caml_ml_open_descriptor_in(0),
     stdout=caml_ml_open_descriptor_out(1),
     stderr=caml_ml_open_descriptor_out(2);
    function open_out_gen(mode,perm,name)
     {var c=caml_ml_open_descriptor_out(caml_sys_open(name,mode,perm));
      caml_ml_set_channel_name(c,name);
      return c}
    function open_out(name){return open_out_gen(_i_,438,name)}
    function open_out_bin(name){return open_out_gen(_j_,438,name)}
    function flush_all(param)
     {function iter(param)
       {var param$0=param;
        for(;;)
         {if(param$0)
           {var l=param$0[2],a=param$0[1];
            try
             {caml_ml_flush(a)}
            catch(_Ap_)
             {_Ap_ = caml_wrap_exception(_Ap_);
              if(_Ap_[1] !== Sys_error)throw _Ap_;
              var _Ao_=_Ap_}
            var param$0=l;
            continue}
          return 0}}
      return iter(runtime.caml_ml_out_channels_list(0))}
    function output_bytes(oc,s)
     {return caml_ml_output_bytes(oc,s,0,caml_ml_bytes_length(s))}
    function output_string(oc,s)
     {return caml_ml_output(oc,s,0,caml_ml_string_length(s))}
    function output(oc,s,ofs,len)
     {if
       (0 <= ofs && 0 <= len && ! ((caml_ml_bytes_length(s) - len | 0) < ofs))
       return caml_ml_output_bytes(oc,s,ofs,len);
      return invalid_arg(cst_output)}
    function output_substring(oc,s,ofs,len)
     {if
       (0
        <=
        ofs
        &&
        0
        <=
        len
        &&
        !
        ((caml_ml_string_length(s) - len | 0) < ofs))
       return caml_ml_output(oc,s,ofs,len);
      return invalid_arg(cst_output_substring)}
    function output_value(chan,v){return caml_output_value(chan,v,0)}
    function close_out(oc){caml_ml_flush(oc);return caml_ml_close_channel(oc)}
    function close_out_noerr(oc)
     {try {caml_ml_flush(oc)}catch(_An_){}
      try
       {var _Al_=caml_ml_close_channel(oc);return _Al_}
      catch(_Am_){return 0}}
    function open_in_gen(mode,perm,name)
     {var c=caml_ml_open_descriptor_in(caml_sys_open(name,mode,perm));
      caml_ml_set_channel_name(c,name);
      return c}
    function open_in(name){return open_in_gen(_k_,0,name)}
    function open_in_bin(name){return open_in_gen(_l_,0,name)}
    function input(ic,s,ofs,len)
     {if
       (0 <= ofs && 0 <= len && ! ((caml_ml_bytes_length(s) - len | 0) < ofs))
       return caml_ml_input(ic,s,ofs,len);
      return invalid_arg(cst_input)}
    function unsafe_really_input(ic,s,ofs,len)
     {var ofs$0=ofs,len$0=len;
      for(;;)
       {if(0 < len$0)
         {var r=caml_ml_input(ic,s,ofs$0,len$0);
          if(0 === r)throw End_of_file;
          var len$1=len$0 - r | 0,ofs$1=ofs$0 + r | 0,ofs$0=ofs$1,len$0=len$1;
          continue}
        return 0}}
    function really_input(ic,s,ofs,len)
     {if
       (0 <= ofs && 0 <= len && ! ((caml_ml_bytes_length(s) - len | 0) < ofs))
       return unsafe_really_input(ic,s,ofs,len);
      return invalid_arg(cst_really_input)}
    function really_input_string(ic,len)
     {var s=caml_create_bytes(len);
      really_input(ic,s,0,len);
      return caml_string_of_bytes(s)}
    function input_line(chan)
     {function build_result(buf,pos,param)
       {var pos$0=pos,param$0=param;
        for(;;)
         {if(param$0)
           {var tl=param$0[2],hd=param$0[1],len=caml_ml_bytes_length(hd);
            caml_blit_bytes(hd,0,buf,pos$0 - len | 0,len);
            var pos$1=pos$0 - len | 0,pos$0=pos$1,param$0=tl;
            continue}
          return buf}}
      var accu=0,len=0;
      for(;;)
       {var n=runtime.caml_ml_input_scan_line(chan);
        if(0 === n)
         {if(! accu)throw End_of_file;
          var _Ak_=build_result(caml_create_bytes(len),len,accu)}
        else
         {if(! (0 < n))
           {var beg=caml_create_bytes(- n | 0);
            caml_ml_input(chan,beg,0,- n | 0);
            var len$1=len - n | 0,accu$0=[0,beg,accu],accu=accu$0,len=len$1;
            continue}
          var res=caml_create_bytes(n - 1 | 0);
          caml_ml_input(chan,res,0,n - 1 | 0);
          caml_ml_input_char(chan);
          if(accu)
           var
            len$0=(len + n | 0) - 1 | 0,
            _Ak_=build_result(caml_create_bytes(len$0),len$0,[0,res,accu]);
          else
           var _Ak_=res}
        return caml_string_of_bytes(_Ak_)}}
    function close_in_noerr(ic)
     {try
       {var _Ai_=caml_ml_close_channel(ic);return _Ai_}
      catch(_Aj_){return 0}}
    function print_char(c){return caml_ml_output_char(stdout,c)}
    function print_string(s){return output_string(stdout,s)}
    function print_bytes(s){return output_bytes(stdout,s)}
    function print_int(i)
     {return output_string(stdout,caml_string_of_jsbytes("" + i))}
    function print_float(f){return output_string(stdout,to_string(f))}
    function print_endline(s)
     {output_string(stdout,s);
      caml_ml_output_char(stdout,10);
      return caml_ml_flush(stdout)}
    function print_newline(param)
     {caml_ml_output_char(stdout,10);return caml_ml_flush(stdout)}
    function prerr_char(c){return caml_ml_output_char(stderr,c)}
    function prerr_string(s){return output_string(stderr,s)}
    function prerr_bytes(s){return output_bytes(stderr,s)}
    function prerr_int(i)
     {return output_string(stderr,caml_string_of_jsbytes("" + i))}
    function prerr_float(f){return output_string(stderr,to_string(f))}
    function prerr_endline(s)
     {output_string(stderr,s);
      caml_ml_output_char(stderr,10);
      return caml_ml_flush(stderr)}
    function prerr_newline(param)
     {caml_ml_output_char(stderr,10);return caml_ml_flush(stderr)}
    function read_line(param){caml_ml_flush(stdout);return input_line(stdin)}
    function read_int(param){return caml_int_of_string(read_line(0))}
    function read_int_opt(param){return int_of_string_opt(read_line(0))}
    function read_float(param){return caml_float_of_string(read_line(0))}
    function read_float_opt(param){return of_string_opt(read_line(0))}
    function string_of_format(param){var str=param[2];return str}
    function symbol$0(param,_Ag_)
     {var
       str2=_Ag_[2],
       fmt2=_Ag_[1],
       str1=param[2],
       fmt1=param[1],
       _Ah_=symbol(str1,symbol(cst$0,str2));
      return [0,concat_fmt(fmt1,fmt2),_Ah_]}
    var exit_function=[0,flush_all];
    function at_exit(f)
     {var g=exit_function[1],f_already_ran=[0,0];
      exit_function[1]
      =
      function(param)
       {if(1 - f_already_ran[1]){f_already_ran[1] = 1;caml_call1(f,0)}
        return caml_call1(g,0)};
      return 0}
    function do_at_exit(param){return caml_call1(exit_function[1],0)}
    function exit(retcode)
     {do_at_exit(0);return runtime.caml_sys_exit(retcode)}
    var
     set_binary_mode_in=caml_ml_set_binary_mode,
     close_in=caml_ml_close_channel,
     in_channel_length=caml_ml_channel_size,
     pos_in=runtime.caml_ml_pos_in,
     seek_in=runtime.caml_ml_seek_in,
     input_value=caml_input_value,
     input_binary_int=runtime.caml_ml_input_int,
     input_byte=caml_ml_input_char,
     input_char=caml_ml_input_char,
     set_binary_mode_out=caml_ml_set_binary_mode,
     out_channel_length=caml_ml_channel_size,
     pos_out=runtime.caml_ml_pos_out,
     seek_out=runtime.caml_ml_seek_out,
     output_binary_int=runtime.caml_ml_output_int,
     output_byte=caml_ml_output_char,
     output_char=caml_ml_output_char,
     flush=caml_ml_flush,
     Stdlib=
      [0,
       invalid_arg,
       failwith,
       Exit,
       Match_failure,
       Assert_failure,
       Invalid_argument,
       Failure,
       Not_found,
       Out_of_memory,
       Stack_overflow,
       Sys_error,
       End_of_file,
       Division_by_zero,
       Sys_blocked_io,
       Undefined_recursive_module,
       min,
       max,
       abs,
       max_int,
       min_int,
       lnot,
       infinity,
       neg_infinity,
       nan,
       max_float,
       min_float,
       epsilon,
       symbol,
       char_of_int,
       string_of_bool,
       bool_of_string_opt,
       bool_of_string,
       string_of_int,
       int_of_string_opt,
       to_string,
       of_string_opt,
       append,
       stdin,
       stdout,
       stderr,
       print_char,
       print_string,
       print_bytes,
       print_int,
       print_float,
       print_endline,
       print_newline,
       prerr_char,
       prerr_string,
       prerr_bytes,
       prerr_int,
       prerr_float,
       prerr_endline,
       prerr_newline,
       read_line,
       read_int_opt,
       read_int,
       read_float_opt,
       read_float,
       open_out,
       open_out_bin,
       open_out_gen,
       flush,
       flush_all,
       output_char,
       output_string,
       output_bytes,
       output,
       output_substring,
       output_byte,
       output_binary_int,
       output_value,
       seek_out,
       pos_out,
       out_channel_length,
       close_out,
       close_out_noerr,
       set_binary_mode_out,
       open_in,
       open_in_bin,
       open_in_gen,
       input_char,
       input_line,
       input,
       really_input,
       really_input_string,
       input_byte,
       input_binary_int,
       input_value,
       seek_in,
       pos_in,
       in_channel_length,
       close_in,
       close_in_noerr,
       set_binary_mode_in,
       [0,
        runtime.caml_ml_seek_out_64,
        runtime.caml_ml_pos_out_64,
        caml_ml_channel_size_64,
        runtime.caml_ml_seek_in_64,
        runtime.caml_ml_pos_in_64,
        caml_ml_channel_size_64],
       string_of_format,
       symbol$0,
       exit,
       at_exit,
       valid_float_lexem,
       unsafe_really_input,
       do_at_exit];
    caml_register_global(747,Stdlib,"Stdlib");
    var
     Exit$0=[248,cst_Stdlib_Pervasives_Exit,caml_fresh_oo_id(0)],
     Stdlib_pervasives=
      [0,
       invalid_arg,
       failwith,
       Exit$0,
       min,
       max,
       abs,
       max_int,
       min_int,
       lnot,
       infinity,
       neg_infinity,
       nan,
       max_float,
       min_float,
       epsilon,
       symbol,
       char_of_int,
       string_of_bool,
       bool_of_string,
       bool_of_string_opt,
       string_of_int,
       int_of_string_opt,
       to_string,
       of_string_opt,
       append,
       stdin,
       stdout,
       stderr,
       print_char,
       print_string,
       print_bytes,
       print_int,
       print_float,
       print_endline,
       print_newline,
       prerr_char,
       prerr_string,
       prerr_bytes,
       prerr_int,
       prerr_float,
       prerr_endline,
       prerr_newline,
       read_line,
       read_int,
       read_int_opt,
       read_float,
       read_float_opt,
       open_out,
       open_out_bin,
       open_out_gen,
       flush,
       flush_all,
       output_char,
       output_string,
       output_bytes,
       output,
       output_substring,
       output_byte,
       output_binary_int,
       output_value,
       seek_out,
       pos_out,
       out_channel_length,
       close_out,
       close_out_noerr,
       set_binary_mode_out,
       open_in,
       open_in_bin,
       open_in_gen,
       input_char,
       input_line,
       input,
       really_input,
       really_input_string,
       input_byte,
       input_binary_int,
       input_value,
       seek_in,
       pos_in,
       in_channel_length,
       close_in,
       close_in_noerr,
       set_binary_mode_in,
       string_of_format,
       symbol$0,
       exit,
       at_exit,
       valid_float_lexem,
       do_at_exit];
    caml_register_global(748,Stdlib_pervasives,"Stdlib__pervasives");
    function empty(param){return 0}
    function return$0(x,param){return [0,x,empty]}
    function map(f,seq,param)
     {var match=caml_call1(seq,0);
      if(match)
       {var
         next=match[2],
         x=match[1],
         _Ae_=function(_Af_){return map(f,next,_Af_)};
        return [0,caml_call1(f,x),_Ae_]}
      return 0}
    function filter_map(f,seq,param)
     {var seq$0=seq;
      for(;;)
       {var match=caml_call1(seq$0,0);
        if(match)
         {var next=match[2],x=match[1],match$0=caml_call1(f,x);
          if(match$0)
           {var y=match$0[1];
            return [0,y,function(_Ad_){return filter_map(f,next,_Ad_)}]}
          var seq$0=next;
          continue}
        return 0}}
    function filter(f,seq,param)
     {var seq$0=seq;
      for(;;)
       {var match=caml_call1(seq$0,0);
        if(match)
         {var next=match[2],x=match[1];
          if(caml_call1(f,x))
           return [0,x,function(_Ac_){return filter(f,next,_Ac_)}];
          var seq$0=next;
          continue}
        return 0}}
    function flat_map$0(counter,f,seq,param)
     {var match=caml_call1(seq,0);
      if(match)
       {var next=match[2],x=match[1],_Ab_=caml_call1(f,x),_Aa_=0;
        if(counter < 50)
         {var counter$0=counter + 1 | 0;
          return flat_map_app$0(counter$0,f,_Ab_,next,_Aa_)}
        return caml_trampoline_return(flat_map_app$0,[0,f,_Ab_,next,_Aa_])}
      return 0}
    function flat_map_app$0(counter,f,seq,tail,param)
     {var match=caml_call1(seq,0);
      if(match)
       {var next=match[2],x=match[1];
        return [0,x,function(_z$_){return flat_map_app(f,next,tail,_z$_)}]}
      var _z__=0;
      if(counter < 50)
       {var counter$0=counter + 1 | 0;
        return flat_map$0(counter$0,f,tail,_z__)}
      return caml_trampoline_return(flat_map$0,[0,f,tail,_z__])}
    function flat_map(f,seq,param)
     {return caml_trampoline(flat_map$0(0,f,seq,param))}
    function flat_map_app(f,seq,tail,param)
     {return caml_trampoline(flat_map_app$0(0,f,seq,tail,param))}
    function fold_left(f,acc,seq)
     {var acc$0=acc,seq$0=seq;
      for(;;)
       {var match=caml_call1(seq$0,0);
        if(match)
         {var
           next=match[2],
           x=match[1],
           acc$1=caml_call2(f,acc$0,x),
           acc$0=acc$1,
           seq$0=next;
          continue}
        return acc$0}}
    function iter(f,seq)
     {var seq$0=seq;
      for(;;)
       {var match=caml_call1(seq$0,0);
        if(match)
         {var next=match[2],x=match[1];
          caml_call1(f,x);
          var seq$0=next;
          continue}
        return 0}}
    var
     Stdlib_seq=
      [0,empty,return$0,map,filter,filter_map,flat_map,fold_left,iter];
    caml_register_global(749,Stdlib_seq,"Stdlib__seq");
    var none=0;
    function some(v){return [0,v]}
    function value(o,default$0){if(o){var v=o[1];return v}return default$0}
    function get(param)
     {if(param){var v=param[1];return v}
      return invalid_arg(cst_option_is_None)}
    function bind(o,f){if(o){var v=o[1];return caml_call1(f,v)}return 0}
    function join(param){if(param){var o=param[1];return o}return 0}
    function map$0(f,o){if(o){var v=o[1];return [0,caml_call1(f,v)]}return 0}
    function fold(none,some,param)
     {if(param){var v=param[1];return caml_call1(some,v)}return none}
    function iter$0(f,param)
     {if(param){var v=param[1];return caml_call1(f,v)}return 0}
    function is_none(param){return param?0:1}
    function is_some(param){return param?1:0}
    function equal(eq,o0,o1)
     {if(o0)
       {if(o1){var v1=o1[1],v0=o0[1];return caml_call2(eq,v0,v1)}}
      else
       if(! o1)return 1;
      return 0}
    function compare(cmp,o0,o1)
     {if(o0)
       {var _z9_=o0[1];
        if(o1){var v1=o1[1];return caml_call2(cmp,_z9_,v1)}
        return 1}
      return o1?-1:0}
    function to_result(none,param)
     {if(param){var v=param[1];return [0,v]}return [1,none]}
    function to_list(param){if(param){var v=param[1];return [0,v,0]}return 0}
    function to_seq(param)
     {if(param){var v=param[1];return function(_z8_){return return$0(v,_z8_)}}
      return empty}
    var
     Stdlib_option=
      [0,
       none,
       some,
       value,
       get,
       bind,
       join,
       map$0,
       fold,
       iter$0,
       is_none,
       is_some,
       equal,
       compare,
       to_result,
       to_list,
       to_seq];
    caml_register_global(750,Stdlib_option,"Stdlib__option");
    function ok(v){return [0,v]}
    function error(e){return [1,e]}
    function value$0(r,default$0)
     {if(0 === r[0]){var v=r[1];return v}return default$0}
    function get_ok(param)
     {if(0 === param[0]){var v=param[1];return v}
      return invalid_arg(cst_result_is_Error)}
    function get_error(param)
     {if(0 === param[0])return invalid_arg(cst_result_is_Ok);
      var e=param[1];
      return e}
    function bind$0(r,f)
     {if(0 === r[0]){var v=r[1];return caml_call1(f,v)}return r}
    function join$0(e){if(0 === e[0]){var r=e[1];return r}return e}
    function map$1(f,e)
     {if(0 === e[0]){var v=e[1];return [0,caml_call1(f,v)]}return e}
    function map_error(f,v)
     {if(0 === v[0])return v;var e=v[1];return [1,caml_call1(f,e)]}
    function fold$0(ok,error,param)
     {if(0 === param[0]){var v=param[1];return caml_call1(ok,v)}
      var e=param[1];
      return caml_call1(error,e)}
    function iter$1(f,param)
     {if(0 === param[0]){var v=param[1];return caml_call1(f,v)}return 0}
    function iter_error(f,param)
     {if(0 === param[0])return 0;var e=param[1];return caml_call1(f,e)}
    function is_ok(param){return 0 === param[0]?1:0}
    function is_error(param){return 0 === param[0]?0:1}
    function equal$0(ok,error,r0,match)
     {if(0 === r0[0])
       {var _z6_=r0[1];
        if(0 === match[0]){var v1=match[1];return caml_call2(ok,_z6_,v1)}}
      else
       {var _z7_=r0[1];
        if(0 !== match[0]){var e1=match[1];return caml_call2(error,_z7_,e1)}}
      return 0}
    function compare$0(ok,error,r0,match)
     {if(0 === r0[0])
       {var _z4_=r0[1];
        if(0 === match[0]){var v1=match[1];return caml_call2(ok,_z4_,v1)}
        return -1}
      var _z5_=r0[1];
      if(0 === match[0])return 1;
      var e1=match[1];
      return caml_call2(error,_z5_,e1)}
    function to_option(param)
     {if(0 === param[0]){var v=param[1];return [0,v]}return 0}
    function to_list$0(param)
     {if(0 === param[0]){var v=param[1];return [0,v,0]}return 0}
    function to_seq$0(param)
     {if(0 === param[0])
       {var v=param[1];return function(_z3_){return return$0(v,_z3_)}}
      return empty}
    var
     Stdlib_result=
      [0,
       ok,
       error,
       value$0,
       get_ok,
       get_error,
       bind$0,
       join$0,
       map$1,
       map_error,
       fold$0,
       iter$1,
       iter_error,
       is_ok,
       is_error,
       equal$0,
       compare$0,
       to_option,
       to_list$0,
       to_seq$0];
    caml_register_global(751,Stdlib_result,"Stdlib__result");
    function equal$1(_z2_,_z1_){return _z2_ === _z1_?1:0}
    var compare$1=caml_int_compare;
    function to_int(param){return param?1:0}
    function to_float(param){return param?1.:0.}
    function to_string$0(param){return param?cst_true$2:cst_false$2}
    var
     Stdlib_bool=
      [0,
       function(_z0_){return 1 - _z0_},
       equal$1,
       compare$1,
       to_int,
       to_float,
       to_string$0];
    caml_register_global(752,Stdlib_bool,"Stdlib__bool");
    function chr(n)
     {if(0 <= n && ! (255 < n))return n;return invalid_arg(cst_Char_chr)}
    function escaped(c)
     {var switch$0=0;
      if(40 <= c)
       {if(92 === c)return cst$1;if(! (127 <= c))switch$0 = 1}
      else
       if(32 <= c)
        {if(39 <= c)return cst$2;switch$0 = 1}
       else
        if(! (14 <= c))
         switch(c)
          {case 8:return cst_b;
           case 9:return cst_t;
           case 10:return cst_n;
           case 13:return cst_r
           }
      if(switch$0)
       {var s$0=caml_create_bytes(1);
        caml_bytes_unsafe_set(s$0,0,c);
        return caml_string_of_bytes(s$0)}
      var s=caml_create_bytes(4);
      caml_bytes_unsafe_set(s,0,92);
      caml_bytes_unsafe_set(s,1,48 + (c / 100 | 0) | 0);
      caml_bytes_unsafe_set(s,2,48 + ((c / 10 | 0) % 10 | 0) | 0);
      caml_bytes_unsafe_set(s,3,48 + (c % 10 | 0) | 0);
      return caml_string_of_bytes(s)}
    function lowercase(c)
     {var switch$0=0;
      if(! (65 <= c) || 90 < c)switch$0 = 1;
      if(switch$0)
       {var switch$1=0;
        if(! (192 <= c) || 214 < c)switch$1 = 1;
        if(switch$1)
         {var switch$2=0;
          if(! (216 <= c) || 222 < c)switch$2 = 1;
          if(switch$2)return c}}
      return c + 32 | 0}
    function uppercase(c)
     {var switch$0=0;
      if(! (97 <= c) || 122 < c)switch$0 = 1;
      if(switch$0)
       {var switch$1=0;
        if(! (224 <= c) || 246 < c)switch$1 = 1;
        if(switch$1)
         {var switch$2=0;
          if(! (248 <= c) || 254 < c)switch$2 = 1;
          if(switch$2)return c}}
      return c - 32 | 0}
    function lowercase_ascii(c)
     {if(65 <= c && ! (90 < c))return c + 32 | 0;return c}
    function uppercase_ascii(c)
     {if(97 <= c && ! (122 < c))return c - 32 | 0;return c}
    function compare$2(c1,c2){return c1 - c2 | 0}
    function equal$2(c1,c2){return 0 === (c1 - c2 | 0)?1:0}
    var
     Stdlib_char=
      [0,
       chr,
       escaped,
       lowercase,
       uppercase,
       lowercase_ascii,
       uppercase_ascii,
       compare$2,
       equal$2];
    caml_register_global(753,Stdlib_char,"Stdlib__char");
    var
     min$0=0,
     max$0=1114111,
     lo_bound=55295,
     hi_bound=57344,
     bom=65279,
     rep=65533;
    function succ(u)
     {return u === 55295
              ?hi_bound
              :u === 1114111?invalid_arg(err_no_succ):u + 1 | 0}
    function pred(u)
     {return u === 57344?lo_bound:u === 0?invalid_arg(err_no_pred):u - 1 | 0}
    function is_valid(i)
     {var _zW_=0 <= i?1:0,_zX_=_zW_?i <= 55295?1:0:_zW_;
      if(_zX_)
       var _zY_=_zX_;
      else
       var _zZ_=57344 <= i?1:0,_zY_=_zZ_?i <= 1114111?1:0:_zZ_;
      return _zY_}
    function of_int(i)
     {return is_valid(i)
              ?i
              :invalid_arg
                (symbol
                  (caml_format_int(cst_X,i),cst_is_not_an_Unicode_scalar_v))}
    function is_char(u){return u < 256?1:0}
    function of_char(c){return c}
    function to_char(u)
     {return 255 < u
              ?invalid_arg
                (symbol
                  (cst_U,
                   symbol
                    (caml_format_int(cst_04X,u),cst_is_not_a_latin1_character)))
              :u}
    function unsafe_to_char(_zV_){return _zV_}
    function equal$3(_zU_,_zT_){return _zU_ === _zT_?1:0}
    var compare$3=caml_int_compare;
    function hash(_zS_){return _zS_}
    function _m_(_zR_){return _zR_}
    var
     Stdlib_uchar=
      [0,
       min$0,
       max$0,
       bom,
       rep,
       succ,
       pred,
       is_valid,
       of_int,
       function(_zQ_){return _zQ_},
       _m_,
       is_char,
       of_char,
       to_char,
       unsafe_to_char,
       equal$3,
       compare$3,
       hash];
    caml_register_global(754,Stdlib_uchar,"Stdlib__uchar");
    var
     executable_name=runtime.caml_sys_executable_name(0),
     match=runtime.caml_sys_get_config(0),
     os_type=match[1],
     match$0=runtime.caml_sys_const_backend_type(0),
     unix=runtime.caml_sys_const_ostype_unix(0),
     win32=runtime.caml_sys_const_ostype_win32(0),
     cygwin=runtime.caml_sys_const_ostype_cygwin(0),
     max_array_length=runtime.caml_sys_const_max_wosize(0),
     max_floatarray_length=max_array_length / 2 | 0,
     max_string_length=(4 * max_array_length | 0) - 1 | 0,
     big_endian=0,
     match$1=32,
     int_size=32;
    function getenv_opt(s)
     {try
       {var _zO_=[0,caml_sys_getenv(s)];return _zO_}
      catch(_zP_)
       {_zP_ = caml_wrap_exception(_zP_);
        if(_zP_ === Not_found)return 0;
        throw _zP_}}
    var interactive=[0,0];
    function set_signal(sig_num,sig_beh){return 0}
    var
     Break=[248,cst_Stdlib_Sys_Break,caml_fresh_oo_id(0)],
     sigabrt=-1,
     sigalrm=-2,
     sigfpe=-3,
     sighup=-4,
     sigill=-5,
     sigint=-6,
     sigkill=-7,
     sigpipe=-8,
     sigquit=-9,
     sigsegv=-10,
     sigterm=-11,
     sigusr1=-12,
     sigusr2=-13,
     sigchld=-14,
     sigcont=-15,
     sigstop=-16,
     sigtstp=-17,
     sigttin=-18,
     sigttou=-19,
     sigvtalrm=-20,
     sigprof=-21,
     sigbus=-22,
     sigpoll=-23,
     sigsys=-24,
     sigtrap=-25,
     sigurg=-26,
     sigxcpu=-27,
     sigxfsz=-28;
    function catch_break(on){return on?0:0}
    function Make(_zN_,_zM_){return [0,1]}
    var
     Immediate64=[0,Make],
     Stdlib_sys=
      [0,
       executable_name,
       getenv_opt,
       interactive,
       os_type,
       match$0,
       unix,
       win32,
       cygwin,
       match$1,
       int_size,
       big_endian,
       max_string_length,
       max_array_length,
       max_floatarray_length,
       set_signal,
       sigabrt,
       sigalrm,
       sigfpe,
       sighup,
       sigill,
       sigint,
       sigkill,
       sigpipe,
       sigquit,
       sigsegv,
       sigterm,
       sigusr1,
       sigusr2,
       sigchld,
       sigcont,
       sigstop,
       sigtstp,
       sigttin,
       sigttou,
       sigvtalrm,
       sigprof,
       sigbus,
       sigpoll,
       sigsys,
       sigtrap,
       sigurg,
       sigxcpu,
       sigxfsz,
       Break,
       catch_break,
       ocaml_version,
       runtime.caml_ml_enable_runtime_warnings,
       runtime.caml_ml_runtime_warnings_enabled,
       Immediate64];
    caml_register_global(755,Stdlib_sys,"Stdlib__sys");
    function length(l)
     {var len=0,param=l;
      for(;;)
       {if(param)
         {var param$0=param[2],len$0=len + 1 | 0,len=len$0,param=param$0;
          continue}
        return len}}
    function cons(a,l){return [0,a,l]}
    function hd(param)
     {if(param){var a=param[1];return a}return failwith(cst_hd)}
    function tl(param)
     {if(param){var l=param[2];return l}return failwith(cst_tl)}
    function nth(l,n)
     {if(0 <= n)
       {var l$0=l,n$0=n;
        for(;;)
         {if(l$0)
           {var l$1=l$0[2],a=l$0[1];
            if(0 === n$0)return a;
            var n$1=n$0 - 1 | 0,l$0=l$1,n$0=n$1;
            continue}
          return failwith(cst_nth)}}
      return invalid_arg(cst_List_nth)}
    function nth_opt(l,n)
     {if(0 <= n)
       {var l$0=l,n$0=n;
        for(;;)
         {if(l$0)
           {var l$1=l$0[2],a=l$0[1];
            if(0 === n$0)return [0,a];
            var n$1=n$0 - 1 | 0,l$0=l$1,n$0=n$1;
            continue}
          return 0}}
      return invalid_arg(cst_List_nth$0)}
    function rev_append(l1,l2)
     {var l1$0=l1,l2$0=l2;
      for(;;)
       {if(l1$0)
         {var l1$1=l1$0[2],a=l1$0[1],l2$1=[0,a,l2$0],l1$0=l1$1,l2$0=l2$1;
          continue}
        return l2$0}}
    function rev(l){return rev_append(l,0)}
    function init_aux(i,n,f)
     {if(n <= i)return 0;
      var r=caml_call1(f,i);
      return [0,r,init_aux(i + 1 | 0,n,f)]}
    var rev_init_threshold=typeof match$0 === "number"?10000:50;
    function init(len,f)
     {if(0 <= len)
       {if(rev_init_threshold < len)
         {var acc=0,i=0;
          for(;;)
           {if(len <= i)return rev(acc);
            var i$0=i + 1 | 0,acc$0=[0,caml_call1(f,i),acc],acc=acc$0,i=i$0;
            continue}}
        return init_aux(0,len,f)}
      return invalid_arg(cst_List_init)}
    function flatten(param)
     {if(param){var r=param[2],l=param[1];return append(l,flatten(r))}
      return 0}
    function map$2(f,param)
     {if(param)
       {var l=param[2],a=param[1],r=caml_call1(f,a);return [0,r,map$2(f,l)]}
      return 0}
    function _n_(i,f,param)
     {if(param)
       {var l=param[2],a=param[1],r=caml_call2(f,i,a);
        return [0,r,_n_(i + 1 | 0,f,l)]}
      return 0}
    function mapi(f,l){return _n_(0,f,l)}
    function rev_map(f,param)
     {var accu=0,param$0=param;
      for(;;)
       {if(param$0)
         {var
           l=param$0[2],
           a=param$0[1],
           accu$0=[0,caml_call1(f,a),accu],
           accu=accu$0,
           param$0=l;
          continue}
        return accu}}
    function iter$2(f,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],a=param$0[1];
          caml_call1(f,a);
          var param$0=l;
          continue}
        return 0}}
    function iteri(f,l$0)
     {var i=0,param=l$0;
      for(;;)
       {if(param)
         {var l=param[2],a=param[1];
          caml_call2(f,i,a);
          var i$0=i + 1 | 0,i=i$0,param=l;
          continue}
        return 0}}
    function fold_left$0(f,accu,l)
     {var accu$0=accu,l$0=l;
      for(;;)
       {if(l$0)
         {var
           l$1=l$0[2],
           a=l$0[1],
           accu$1=caml_call2(f,accu$0,a),
           accu$0=accu$1,
           l$0=l$1;
          continue}
        return accu$0}}
    function fold_right(f,l,accu)
     {if(l){var l$0=l[2],a=l[1];return caml_call2(f,a,fold_right(f,l$0,accu))}
      return accu}
    function map2(f,l1,l2)
     {if(l1)
       {if(l2)
         {var l2$0=l2[2],a2=l2[1],l1$0=l1[2],a1=l1[1],r=caml_call2(f,a1,a2);
          return [0,r,map2(f,l1$0,l2$0)]}}
      else
       if(! l2)return 0;
      return invalid_arg(cst_List_map2)}
    function rev_map2(f,l1,l2)
     {var accu=0,l1$0=l1,l2$0=l2;
      for(;;)
       {if(l1$0)
         {if(l2$0)
           {var
             l2$1=l2$0[2],
             a2=l2$0[1],
             l1$1=l1$0[2],
             a1=l1$0[1],
             accu$0=[0,caml_call2(f,a1,a2),accu],
             accu=accu$0,
             l1$0=l1$1,
             l2$0=l2$1;
            continue}}
        else
         if(! l2$0)return accu;
        return invalid_arg(cst_List_rev_map2)}}
    function iter2(f,l1,l2)
     {var l1$0=l1,l2$0=l2;
      for(;;)
       {if(l1$0)
         {if(l2$0)
           {var l2$1=l2$0[2],a2=l2$0[1],l1$1=l1$0[2],a1=l1$0[1];
            caml_call2(f,a1,a2);
            var l1$0=l1$1,l2$0=l2$1;
            continue}}
        else
         if(! l2$0)return 0;
        return invalid_arg(cst_List_iter2)}}
    function fold_left2(f,accu,l1,l2)
     {var accu$0=accu,l1$0=l1,l2$0=l2;
      for(;;)
       {if(l1$0)
         {if(l2$0)
           {var
             l2$1=l2$0[2],
             a2=l2$0[1],
             l1$1=l1$0[2],
             a1=l1$0[1],
             accu$1=caml_call3(f,accu$0,a1,a2),
             accu$0=accu$1,
             l1$0=l1$1,
             l2$0=l2$1;
            continue}}
        else
         if(! l2$0)return accu$0;
        return invalid_arg(cst_List_fold_left2)}}
    function fold_right2(f,l1,l2,accu)
     {if(l1)
       {if(l2)
         {var l2$0=l2[2],a2=l2[1],l1$0=l1[2],a1=l1[1];
          return caml_call3(f,a1,a2,fold_right2(f,l1$0,l2$0,accu))}}
      else
       if(! l2)return accu;
      return invalid_arg(cst_List_fold_right2)}
    function for_all(p,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],a=param$0[1],_zL_=caml_call1(p,a);
          if(_zL_){var param$0=l;continue}
          return _zL_}
        return 1}}
    function exists(p,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],a=param$0[1],_zK_=caml_call1(p,a);
          if(_zK_)return _zK_;
          var param$0=l;
          continue}
        return 0}}
    function for_all2(p,l1,l2)
     {var l1$0=l1,l2$0=l2;
      for(;;)
       {if(l1$0)
         {if(l2$0)
           {var
             l2$1=l2$0[2],
             a2=l2$0[1],
             l1$1=l1$0[2],
             a1=l1$0[1],
             _zJ_=caml_call2(p,a1,a2);
            if(_zJ_){var l1$0=l1$1,l2$0=l2$1;continue}
            return _zJ_}}
        else
         if(! l2$0)return 1;
        return invalid_arg(cst_List_for_all2)}}
    function exists2(p,l1,l2)
     {var l1$0=l1,l2$0=l2;
      for(;;)
       {if(l1$0)
         {if(l2$0)
           {var
             l2$1=l2$0[2],
             a2=l2$0[1],
             l1$1=l1$0[2],
             a1=l1$0[1],
             _zI_=caml_call2(p,a1,a2);
            if(_zI_)return _zI_;
            var l1$0=l1$1,l2$0=l2$1;
            continue}}
        else
         if(! l2$0)return 0;
        return invalid_arg(cst_List_exists2)}}
    function mem(x,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],a=param$0[1],_zH_=0 === caml_compare(a,x)?1:0;
          if(_zH_)return _zH_;
          var param$0=l;
          continue}
        return 0}}
    function memq(x,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],a=param$0[1],_zG_=a === x?1:0;
          if(_zG_)return _zG_;
          var param$0=l;
          continue}
        return 0}}
    function assoc(x,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],match=param$0[1],b=match[2],a=match[1];
          if(0 === caml_compare(a,x))return b;
          var param$0=l;
          continue}
        throw Not_found}}
    function assoc_opt(x,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],match=param$0[1],b=match[2],a=match[1];
          if(0 === caml_compare(a,x))return [0,b];
          var param$0=l;
          continue}
        return 0}}
    function assq(x,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],match=param$0[1],b=match[2],a=match[1];
          if(a === x)return b;
          var param$0=l;
          continue}
        throw Not_found}}
    function assq_opt(x,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],match=param$0[1],b=match[2],a=match[1];
          if(a === x)return [0,b];
          var param$0=l;
          continue}
        return 0}}
    function mem_assoc(x,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var
           l=param$0[2],
           match=param$0[1],
           a=match[1],
           _zF_=0 === caml_compare(a,x)?1:0;
          if(_zF_)return _zF_;
          var param$0=l;
          continue}
        return 0}}
    function mem_assq(x,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],match=param$0[1],a=match[1],_zE_=a === x?1:0;
          if(_zE_)return _zE_;
          var param$0=l;
          continue}
        return 0}}
    function remove_assoc(x,param)
     {if(param)
       {var l=param[2],pair=param[1],a=pair[1];
        return 0 === caml_compare(a,x)?l:[0,pair,remove_assoc(x,l)]}
      return 0}
    function remove_assq(x,param)
     {if(param)
       {var l=param[2],pair=param[1],a=pair[1];
        return a === x?l:[0,pair,remove_assq(x,l)]}
      return 0}
    function find(p,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],x=param$0[1];
          if(caml_call1(p,x))return x;
          var param$0=l;
          continue}
        throw Not_found}}
    function find_opt(p,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],x=param$0[1];
          if(caml_call1(p,x))return [0,x];
          var param$0=l;
          continue}
        return 0}}
    function find_map(f,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],x=param$0[1],result=caml_call1(f,x);
          if(result)return result;
          var param$0=l;
          continue}
        return 0}}
    function find_all(p)
     {var accu=0;
      return function(param$0)
       {var accu$0=accu,param=param$0;
        for(;;)
         {if(param)
           {var l=param[2],x=param[1];
            if(caml_call1(p,x))
             {var accu$1=[0,x,accu$0],accu$0=accu$1,param=l;continue}
            var param=l;
            continue}
          return rev(accu$0)}}}
    function filter_map$0(f)
     {var accu=0;
      return function(param$0)
       {var accu$0=accu,param=param$0;
        for(;;)
         {if(param)
           {var l=param[2],x=param[1],match=caml_call1(f,x);
            if(match)
             {var v=match[1],accu$1=[0,v,accu$0],accu$0=accu$1,param=l;
              continue}
            var param=l;
            continue}
          return rev(accu$0)}}}
    function concat_map(f,param)
     {var acc=0,param$0=param;
      for(;;)
       {if(param$0)
         {var
           l=param$0[2],
           x=param$0[1],
           xs=caml_call1(f,x),
           acc$0=rev_append(xs,acc),
           acc=acc$0,
           param$0=l;
          continue}
        return rev(acc)}}
    function partition(p,param)
     {var yes=0,no=0,param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],x=param$0[1];
          if(caml_call1(p,x))
           {var yes$0=[0,x,yes],yes=yes$0,param$0=l;continue}
          var no$0=[0,x,no],no=no$0,param$0=l;
          continue}
        var _zD_=rev(no);
        return [0,rev(yes),_zD_]}}
    function split(param)
     {if(param)
       {var
         l=param[2],
         match=param[1],
         y=match[2],
         x=match[1],
         match$0=split(l),
         ry=match$0[2],
         rx=match$0[1];
        return [0,[0,x,rx],[0,y,ry]]}
      return _o_}
    function combine(l1,l2)
     {if(l1)
       {if(l2)
         {var l2$0=l2[2],a2=l2[1],l1$0=l1[2],a1=l1[1];
          return [0,[0,a1,a2],combine(l1$0,l2$0)]}}
      else
       if(! l2)return 0;
      return invalid_arg(cst_List_combine)}
    function merge(cmp,l1,match)
     {if(l1)
       {if(match)
         {var t2=match[2],h2=match[1],t1=l1[2],h1=l1[1];
          return 0 < caml_call2(cmp,h1,h2)
                  ?[0,h2,merge(cmp,l1,t2)]
                  :[0,h1,merge(cmp,t1,match)]}
        return l1}
      return match}
    function fast_sort(cmp,l)
     {function sort(n,l)
       {if(2 === n)
         {if(l)
           {var _zz_=l[2];
            if(_zz_)
             {var
               tl=_zz_[2],
               x2=_zz_[1],
               x1=l[1],
               s=0 < caml_call2(cmp,x1,x2)?[0,x2,[0,x1,0]]:[0,x1,[0,x2,0]];
              return [0,s,tl]}}}
        else
         if(3 === n && l)
          {var _zB_=l[2];
           if(_zB_)
            {var _zC_=_zB_[2];
             if(_zC_)
              {var
                tl$1=_zC_[2],
                x3=_zC_[1],
                x2$0=_zB_[1],
                x1$0=l[1],
                s$0=
                 0 < caml_call2(cmp,x1$0,x2$0)
                  ?0 < caml_call2(cmp,x1$0,x3)
                    ?0 < caml_call2(cmp,x2$0,x3)
                      ?[0,x3,[0,x2$0,[0,x1$0,0]]]
                      :[0,x2$0,[0,x3,[0,x1$0,0]]]
                    :[0,x2$0,[0,x1$0,[0,x3,0]]]
                  :0 < caml_call2(cmp,x2$0,x3)
                    ?0 < caml_call2(cmp,x1$0,x3)
                      ?[0,x3,[0,x1$0,[0,x2$0,0]]]
                      :[0,x1$0,[0,x3,[0,x2$0,0]]]
                    :[0,x1$0,[0,x2$0,[0,x3,0]]];
               return [0,s$0,tl$1]}}}
        var
         n1=n >> 1,
         n2=n - n1 | 0,
         match=rev_sort(n1,l),
         l2$0=match[2],
         s1=match[1],
         match$0=rev_sort(n2,l2$0),
         tl$0=match$0[2],
         s2=match$0[1],
         l1=s1,
         l2=s2,
         accu=0;
        for(;;)
         {if(l1)
           {if(l2)
             {var t2=l2[2],h2=l2[1],t1=l1[2],h1=l1[1];
              if(0 < caml_call2(cmp,h1,h2))
               {var accu$0=[0,h1,accu],l1=t1,accu=accu$0;continue}
              var accu$1=[0,h2,accu],l2=t2,accu=accu$1;
              continue}
            var _zA_=rev_append(l1,accu)}
          else
           var _zA_=rev_append(l2,accu);
          return [0,_zA_,tl$0]}}
      function rev_sort(n,l)
       {if(2 === n)
         {if(l)
           {var _zv_=l[2];
            if(_zv_)
             {var
               tl=_zv_[2],
               x2=_zv_[1],
               x1=l[1],
               s=0 < caml_call2(cmp,x1,x2)?[0,x1,[0,x2,0]]:[0,x2,[0,x1,0]];
              return [0,s,tl]}}}
        else
         if(3 === n && l)
          {var _zx_=l[2];
           if(_zx_)
            {var _zy_=_zx_[2];
             if(_zy_)
              {var
                tl$1=_zy_[2],
                x3=_zy_[1],
                x2$0=_zx_[1],
                x1$0=l[1],
                s$0=
                 0 < caml_call2(cmp,x1$0,x2$0)
                  ?0 < caml_call2(cmp,x2$0,x3)
                    ?[0,x1$0,[0,x2$0,[0,x3,0]]]
                    :0 < caml_call2(cmp,x1$0,x3)
                      ?[0,x1$0,[0,x3,[0,x2$0,0]]]
                      :[0,x3,[0,x1$0,[0,x2$0,0]]]
                  :0 < caml_call2(cmp,x1$0,x3)
                    ?[0,x2$0,[0,x1$0,[0,x3,0]]]
                    :0 < caml_call2(cmp,x2$0,x3)
                      ?[0,x2$0,[0,x3,[0,x1$0,0]]]
                      :[0,x3,[0,x2$0,[0,x1$0,0]]];
               return [0,s$0,tl$1]}}}
        var
         n1=n >> 1,
         n2=n - n1 | 0,
         match=sort(n1,l),
         l2$0=match[2],
         s1=match[1],
         match$0=sort(n2,l2$0),
         tl$0=match$0[2],
         s2=match$0[1],
         l1=s1,
         l2=s2,
         accu=0;
        for(;;)
         {if(l1)
           {if(l2)
             {var t2=l2[2],h2=l2[1],t1=l1[2],h1=l1[1];
              if(0 < caml_call2(cmp,h1,h2))
               {var accu$0=[0,h2,accu],l2=t2,accu=accu$0;continue}
              var accu$1=[0,h1,accu],l1=t1,accu=accu$1;
              continue}
            var _zw_=rev_append(l1,accu)}
          else
           var _zw_=rev_append(l2,accu);
          return [0,_zw_,tl$0]}}
      var len=length(l);
      return 2 <= len?sort(len,l)[1]:l}
    function sort_uniq(cmp,l)
     {function sort(n,l)
       {if(2 === n)
         {if(l)
           {var _zm_=l[2];
            if(_zm_)
             {var
               tl=_zm_[2],
               x2=_zm_[1],
               x1=l[1],
               c$0=caml_call2(cmp,x1,x2),
               s=0 === c$0?[0,x1,0]:0 <= c$0?[0,x2,[0,x1,0]]:[0,x1,[0,x2,0]];
              return [0,s,tl]}}}
        else
         if(3 === n && l)
          {var _zo_=l[2];
           if(_zo_)
            {var _zp_=_zo_[2];
             if(_zp_)
              {var
                tl$1=_zp_[2],
                x3=_zp_[1],
                x2$0=_zo_[1],
                x1$0=l[1],
                c$1=caml_call2(cmp,x1$0,x2$0);
               if(0 === c$1)
                var
                 c$2=caml_call2(cmp,x2$0,x3),
                 _zq_=
                  0 === c$2
                   ?[0,x2$0,0]
                   :0 <= c$2?[0,x3,[0,x2$0,0]]:[0,x2$0,[0,x3,0]],
                 s$0=_zq_;
               else
                if(0 <= c$1)
                 {var c$3=caml_call2(cmp,x1$0,x3);
                  if(0 === c$3)
                   var _zr_=[0,x2$0,[0,x1$0,0]];
                  else
                   if(0 <= c$3)
                    var
                     c$4=caml_call2(cmp,x2$0,x3),
                     _zs_=
                      0 === c$4
                       ?[0,x2$0,[0,x1$0,0]]
                       :0 <= c$4
                         ?[0,x3,[0,x2$0,[0,x1$0,0]]]
                         :[0,x2$0,[0,x3,[0,x1$0,0]]],
                     _zr_=_zs_;
                   else
                    var _zr_=[0,x2$0,[0,x1$0,[0,x3,0]]];
                  var s$0=_zr_}
                else
                 {var c$5=caml_call2(cmp,x2$0,x3);
                  if(0 === c$5)
                   var _zt_=[0,x1$0,[0,x2$0,0]];
                  else
                   if(0 <= c$5)
                    var
                     c$6=caml_call2(cmp,x1$0,x3),
                     _zu_=
                      0 === c$6
                       ?[0,x1$0,[0,x2$0,0]]
                       :0 <= c$6
                         ?[0,x3,[0,x1$0,[0,x2$0,0]]]
                         :[0,x1$0,[0,x3,[0,x2$0,0]]],
                     _zt_=_zu_;
                   else
                    var _zt_=[0,x1$0,[0,x2$0,[0,x3,0]]];
                  var s$0=_zt_}
               return [0,s$0,tl$1]}}}
        var
         n1=n >> 1,
         n2=n - n1 | 0,
         match=rev_sort(n1,l),
         l2$0=match[2],
         s1=match[1],
         match$0=rev_sort(n2,l2$0),
         tl$0=match$0[2],
         s2=match$0[1],
         l1=s1,
         l2=s2,
         accu=0;
        for(;;)
         {if(l1)
           {if(l2)
             {var t2=l2[2],h2=l2[1],t1=l1[2],h1=l1[1],c=caml_call2(cmp,h1,h2);
              if(0 === c)
               {var accu$0=[0,h1,accu],l1=t1,l2=t2,accu=accu$0;continue}
              if(0 < c){var accu$1=[0,h1,accu],l1=t1,accu=accu$1;continue}
              var accu$2=[0,h2,accu],l2=t2,accu=accu$2;
              continue}
            var _zn_=rev_append(l1,accu)}
          else
           var _zn_=rev_append(l2,accu);
          return [0,_zn_,tl$0]}}
      function rev_sort(n,l)
       {if(2 === n)
         {if(l)
           {var _zd_=l[2];
            if(_zd_)
             {var
               tl=_zd_[2],
               x2=_zd_[1],
               x1=l[1],
               c$0=caml_call2(cmp,x1,x2),
               s=0 === c$0?[0,x1,0]:0 < c$0?[0,x1,[0,x2,0]]:[0,x2,[0,x1,0]];
              return [0,s,tl]}}}
        else
         if(3 === n && l)
          {var _zf_=l[2];
           if(_zf_)
            {var _zg_=_zf_[2];
             if(_zg_)
              {var
                tl$1=_zg_[2],
                x3=_zg_[1],
                x2$0=_zf_[1],
                x1$0=l[1],
                c$1=caml_call2(cmp,x1$0,x2$0);
               if(0 === c$1)
                var
                 c$2=caml_call2(cmp,x2$0,x3),
                 _zh_=
                  0 === c$2
                   ?[0,x2$0,0]
                   :0 < c$2?[0,x2$0,[0,x3,0]]:[0,x3,[0,x2$0,0]],
                 s$0=_zh_;
               else
                if(0 < c$1)
                 {var c$3=caml_call2(cmp,x2$0,x3);
                  if(0 === c$3)
                   var _zi_=[0,x1$0,[0,x2$0,0]];
                  else
                   if(0 < c$3)
                    var _zi_=[0,x1$0,[0,x2$0,[0,x3,0]]];
                   else
                    var
                     c$4=caml_call2(cmp,x1$0,x3),
                     _zj_=
                      0 === c$4
                       ?[0,x1$0,[0,x2$0,0]]
                       :0 < c$4
                         ?[0,x1$0,[0,x3,[0,x2$0,0]]]
                         :[0,x3,[0,x1$0,[0,x2$0,0]]],
                     _zi_=_zj_;
                  var s$0=_zi_}
                else
                 {var c$5=caml_call2(cmp,x1$0,x3);
                  if(0 === c$5)
                   var _zk_=[0,x2$0,[0,x1$0,0]];
                  else
                   if(0 < c$5)
                    var _zk_=[0,x2$0,[0,x1$0,[0,x3,0]]];
                   else
                    var
                     c$6=caml_call2(cmp,x2$0,x3),
                     _zl_=
                      0 === c$6
                       ?[0,x2$0,[0,x1$0,0]]
                       :0 < c$6
                         ?[0,x2$0,[0,x3,[0,x1$0,0]]]
                         :[0,x3,[0,x2$0,[0,x1$0,0]]],
                     _zk_=_zl_;
                  var s$0=_zk_}
               return [0,s$0,tl$1]}}}
        var
         n1=n >> 1,
         n2=n - n1 | 0,
         match=sort(n1,l),
         l2$0=match[2],
         s1=match[1],
         match$0=sort(n2,l2$0),
         tl$0=match$0[2],
         s2=match$0[1],
         l1=s1,
         l2=s2,
         accu=0;
        for(;;)
         {if(l1)
           {if(l2)
             {var t2=l2[2],h2=l2[1],t1=l1[2],h1=l1[1],c=caml_call2(cmp,h1,h2);
              if(0 === c)
               {var accu$0=[0,h1,accu],l1=t1,l2=t2,accu=accu$0;continue}
              if(0 <= c){var accu$1=[0,h2,accu],l2=t2,accu=accu$1;continue}
              var accu$2=[0,h1,accu],l1=t1,accu=accu$2;
              continue}
            var _ze_=rev_append(l1,accu)}
          else
           var _ze_=rev_append(l2,accu);
          return [0,_ze_,tl$0]}}
      var len=length(l);
      return 2 <= len?sort(len,l)[1]:l}
    function compare_lengths(l1,l2)
     {var l1$0=l1,l2$0=l2;
      for(;;)
       {if(l1$0)
         {if(l2$0){var l2$1=l2$0[2],l1$1=l1$0[2],l1$0=l1$1,l2$0=l2$1;continue}
          return 1}
        return l2$0?-1:0}}
    function compare_length_with(l,n)
     {var l$0=l,n$0=n;
      for(;;)
       {if(l$0)
         {var l$1=l$0[2];
          if(0 < n$0){var n$1=n$0 - 1 | 0,l$0=l$1,n$0=n$1;continue}
          return 1}
        return 0 === n$0?0:0 < n$0?-1:1}}
    function to_seq$1(l)
     {function aux(l,param)
       {if(l)
         {var tail=l[2],x=l[1];
          return [0,x,function(_zc_){return aux(tail,_zc_)}]}
        return 0}
      return function(_zb_){return aux(l,_zb_)}}
    function of_seq(seq)
     {function direct(depth,seq)
       {if(0 === depth)
         {var _za_=0;
          return rev(fold_left(function(acc,x){return [0,x,acc]},_za_,seq))}
        var match=caml_call1(seq,0);
        if(match)
         {var next=match[2],x=match[1];
          return [0,x,direct(depth - 1 | 0,next)]}
        return 0}
      return direct(500,seq)}
    var
     include=
      [0,
       length,
       compare_lengths,
       compare_length_with,
       cons,
       hd,
       tl,
       nth,
       nth_opt,
       rev,
       init,
       append,
       rev_append,
       flatten,
       flatten,
       iter$2,
       iteri,
       map$2,
       mapi,
       rev_map,
       filter_map$0,
       concat_map,
       fold_left$0,
       fold_right,
       iter2,
       map2,
       rev_map2,
       fold_left2,
       fold_right2,
       for_all,
       exists,
       for_all2,
       exists2,
       mem,
       memq,
       find,
       find_opt,
       find_map,
       find_all,
       find_all,
       partition,
       assoc,
       assoc_opt,
       assq,
       assq_opt,
       mem_assoc,
       mem_assq,
       remove_assoc,
       remove_assq,
       split,
       combine,
       fast_sort,
       fast_sort,
       fast_sort,
       sort_uniq,
       merge,
       to_seq$1,
       of_seq];
    caml_register_global(756,include,"Stdlib__list");
    function make(n,c)
     {var s=caml_create_bytes(n);caml_fill_bytes(s,0,n,c);return s}
    function init$0(n,f)
     {var s=caml_create_bytes(n),_y__=n - 1 | 0,_y9_=0;
      if(! (_y__ < 0))
       {var i=_y9_;
        for(;;)
         {caml_bytes_unsafe_set(s,i,caml_call1(f,i));
          var _y$_=i + 1 | 0;
          if(_y__ !== i){var i=_y$_;continue}
          break}}
      return s}
    var empty$0=caml_create_bytes(0);
    function copy(s)
     {var len=caml_ml_bytes_length(s),r=caml_create_bytes(len);
      caml_blit_bytes(s,0,r,0,len);
      return r}
    function to_string$1(b){return caml_string_of_bytes(copy(b))}
    function of_string(s){return copy(caml_bytes_of_string(s))}
    function sub(s,ofs,len)
     {if
       (0 <= ofs && 0 <= len && ! ((caml_ml_bytes_length(s) - len | 0) < ofs))
       {var r=caml_create_bytes(len);caml_blit_bytes(s,ofs,r,0,len);return r}
      return invalid_arg(cst_String_sub_Bytes_sub)}
    function sub_string(b,ofs,len)
     {return caml_string_of_bytes(sub(b,ofs,len))}
    function symbol$1(a,b)
     {var c=a + b | 0,_y8_=b < 0?1:0,match=c < 0?1:0,switch$0=0;
      if(a < 0)
       {if(_y8_ && ! match)switch$0 = 1}
      else
       if(! _y8_ && match)switch$0 = 1;
      return switch$0?invalid_arg(cst_Bytes_extend):c}
    function extend(s,left,right)
     {var
       len=symbol$1(symbol$1(caml_ml_bytes_length(s),left),right),
       r=caml_create_bytes(len);
      if(0 <= left)
       var dstoff=left,srcoff=0;
      else
       var dstoff=0,srcoff=- left | 0;
      var cpylen=min(caml_ml_bytes_length(s) - srcoff | 0,len - dstoff | 0);
      if(0 < cpylen)caml_blit_bytes(s,srcoff,r,dstoff,cpylen);
      return r}
    function fill(s,ofs,len,c)
     {if
       (0 <= ofs && 0 <= len && ! ((caml_ml_bytes_length(s) - len | 0) < ofs))
       return caml_fill_bytes(s,ofs,len,c);
      return invalid_arg(cst_String_fill_Bytes_fill)}
    function blit(s1,ofs1,s2,ofs2,len)
     {if
       (0
        <=
        len
        &&
        0
        <=
        ofs1
        &&
        !
        ((caml_ml_bytes_length(s1) - len | 0) < ofs1)
        &&
        0
        <=
        ofs2
        &&
        !
        ((caml_ml_bytes_length(s2) - len | 0) < ofs2))
       return caml_blit_bytes(s1,ofs1,s2,ofs2,len);
      return invalid_arg(cst_Bytes_blit)}
    function blit$0(s1,ofs1,s2,ofs2,len)
     {if
       (0
        <=
        len
        &&
        0
        <=
        ofs1
        &&
        !
        ((caml_ml_string_length(s1) - len | 0) < ofs1)
        &&
        0
        <=
        ofs2
        &&
        !
        ((caml_ml_bytes_length(s2) - len | 0) < ofs2))
       return caml_blit_string(s1,ofs1,s2,ofs2,len);
      return invalid_arg(cst_String_blit_Bytes_blit_str)}
    function iter$3(f,a)
     {var _y6_=caml_ml_bytes_length(a) - 1 | 0,_y5_=0;
      if(! (_y6_ < 0))
       {var i=_y5_;
        for(;;)
         {caml_call1(f,caml_bytes_unsafe_get(a,i));
          var _y7_=i + 1 | 0;
          if(_y6_ !== i){var i=_y7_;continue}
          break}}
      return 0}
    function iteri$0(f,a)
     {var _y3_=caml_ml_bytes_length(a) - 1 | 0,_y2_=0;
      if(! (_y3_ < 0))
       {var i=_y2_;
        for(;;)
         {caml_call2(f,i,caml_bytes_unsafe_get(a,i));
          var _y4_=i + 1 | 0;
          if(_y3_ !== i){var i=_y4_;continue}
          break}}
      return 0}
    function concat(sep,l)
     {if(l)
       {var seplen=caml_ml_bytes_length(sep),acc=0,param=l,pos$1=0;
        for(;;)
         {if(param)
           {var _yZ_=param[1];
            if(param[2])
             {var
               tl=param[2],
               x=(caml_ml_bytes_length(_yZ_) + seplen | 0) + acc | 0,
               acc$0=acc <= x?x:invalid_arg(cst_Bytes_concat),
               acc=acc$0,
               param=tl;
              continue}
            var _y1_=caml_ml_bytes_length(_yZ_) + acc | 0}
          else
           var _y1_=acc;
          var dst=caml_create_bytes(_y1_),pos=pos$1,param$0=l;
          for(;;)
           {if(param$0)
             {var _y0_=param$0[1];
              if(param$0[2])
               {var tl$0=param$0[2];
                caml_blit_bytes(_y0_,0,dst,pos,caml_ml_bytes_length(_y0_));
                caml_blit_bytes
                 (sep,0,dst,pos + caml_ml_bytes_length(_y0_) | 0,seplen);
                var
                 pos$0=(pos + caml_ml_bytes_length(_y0_) | 0) + seplen | 0,
                 pos=pos$0,
                 param$0=tl$0;
                continue}
              caml_blit_bytes(_y0_,0,dst,pos,caml_ml_bytes_length(_y0_));
              return dst}
            return dst}}}
      return empty$0}
    function cat(s1,s2)
     {var
       l1=caml_ml_bytes_length(s1),
       l2=caml_ml_bytes_length(s2),
       r=caml_create_bytes(l1 + l2 | 0);
      caml_blit_bytes(s1,0,r,0,l1);
      caml_blit_bytes(s2,0,r,l1,l2);
      return r}
    function is_space(param)
     {var _yY_=param - 9 | 0,switch$0=0;
      if(4 < _yY_ >>> 0)
       {if(23 === _yY_)switch$0 = 1}
      else
       if(2 !== _yY_)switch$0 = 1;
      return switch$0?1:0}
    function trim(s)
     {var len=caml_ml_bytes_length(s),i=[0,0];
      for(;;)
       {if(i[1] < len && is_space(caml_bytes_unsafe_get(s,i[1])))
         {i[1]++;continue}
        var j=[0,len - 1 | 0];
        for(;;)
         {if(i[1] <= j[1] && is_space(caml_bytes_unsafe_get(s,j[1])))
           {j[1] += -1;continue}
          return i[1] <= j[1]?sub(s,i[1],(j[1] - i[1] | 0) + 1 | 0):empty$0}}}
    function escaped$0(s)
     {var n=[0,0],_yR_=caml_ml_bytes_length(s) - 1 | 0,_yQ_=0;
      if(! (_yR_ < 0))
       {var i$0=_yQ_;
        for(;;)
         {var match=caml_bytes_unsafe_get(s,i$0),switch$0=0;
          if(32 <= match)
           {var _yV_=match - 34 | 0,switch$1=0;
            if(58 < _yV_ >>> 0)
             {if(93 <= _yV_)switch$1 = 1}
            else
             if(56 < (_yV_ - 1 | 0) >>> 0){switch$0 = 1;switch$1 = 1}
            if(! switch$1){var _yW_=1;switch$0 = 2}}
          else
           if(11 <= match)
            {if(13 === match)switch$0 = 1}
           else
            if(8 <= match)switch$0 = 1;
          switch(switch$0){case 0:var _yW_=4;break;case 1:var _yW_=2;break}
          n[1] = n[1] + _yW_ | 0;
          var _yX_=i$0 + 1 | 0;
          if(_yR_ !== i$0){var i$0=_yX_;continue}
          break}}
      if(n[1] === caml_ml_bytes_length(s))return copy(s);
      var s$0=caml_create_bytes(n[1]);
      n[1] = 0;
      var _yT_=caml_ml_bytes_length(s) - 1 | 0,_yS_=0;
      if(! (_yT_ < 0))
       {var i=_yS_;
        for(;;)
         {var c=caml_bytes_unsafe_get(s,i),switch$2=0;
          if(35 <= c)
           if(92 === c)
            switch$2 = 2;
           else
            if(127 <= c)switch$2 = 1;else switch$2 = 3;
          else
           if(32 <= c)
            if(34 <= c)switch$2 = 2;else switch$2 = 3;
           else
            if(14 <= c)
             switch$2 = 1;
            else
             switch(c)
              {case 8:
                caml_bytes_unsafe_set(s$0,n[1],92);
                n[1]++;
                caml_bytes_unsafe_set(s$0,n[1],98);
                break;
               case 9:
                caml_bytes_unsafe_set(s$0,n[1],92);
                n[1]++;
                caml_bytes_unsafe_set(s$0,n[1],116);
                break;
               case 10:
                caml_bytes_unsafe_set(s$0,n[1],92);
                n[1]++;
                caml_bytes_unsafe_set(s$0,n[1],110);
                break;
               case 13:
                caml_bytes_unsafe_set(s$0,n[1],92);
                n[1]++;
                caml_bytes_unsafe_set(s$0,n[1],114);
                break;
               default:switch$2 = 1}
          switch(switch$2)
           {case 1:
             caml_bytes_unsafe_set(s$0,n[1],92);
             n[1]++;
             caml_bytes_unsafe_set(s$0,n[1],48 + (c / 100 | 0) | 0);
             n[1]++;
             caml_bytes_unsafe_set(s$0,n[1],48 + ((c / 10 | 0) % 10 | 0) | 0);
             n[1]++;
             caml_bytes_unsafe_set(s$0,n[1],48 + (c % 10 | 0) | 0);
             break;
            case 2:
             caml_bytes_unsafe_set(s$0,n[1],92);
             n[1]++;
             caml_bytes_unsafe_set(s$0,n[1],c);
             break;
            case 3:caml_bytes_unsafe_set(s$0,n[1],c);break
            }
          n[1]++;
          var _yU_=i + 1 | 0;
          if(_yT_ !== i){var i=_yU_;continue}
          break}}
      return s$0}
    function map$3(f,s)
     {var l=caml_ml_bytes_length(s);
      if(0 === l)return s;
      var r=caml_create_bytes(l),_yO_=l - 1 | 0,_yN_=0;
      if(! (_yO_ < 0))
       {var i=_yN_;
        for(;;)
         {caml_bytes_unsafe_set(r,i,caml_call1(f,caml_bytes_unsafe_get(s,i)));
          var _yP_=i + 1 | 0;
          if(_yO_ !== i){var i=_yP_;continue}
          break}}
      return r}
    function mapi$0(f,s)
     {var l=caml_ml_bytes_length(s);
      if(0 === l)return s;
      var r=caml_create_bytes(l),_yL_=l - 1 | 0,_yK_=0;
      if(! (_yL_ < 0))
       {var i=_yK_;
        for(;;)
         {caml_bytes_unsafe_set
           (r,i,caml_call2(f,i,caml_bytes_unsafe_get(s,i)));
          var _yM_=i + 1 | 0;
          if(_yL_ !== i){var i=_yM_;continue}
          break}}
      return r}
    function uppercase_ascii$0(s){return map$3(uppercase_ascii,s)}
    function lowercase_ascii$0(s){return map$3(lowercase_ascii,s)}
    function apply1(f,s)
     {if(0 === caml_ml_bytes_length(s))return s;
      var r=copy(s);
      caml_bytes_unsafe_set(r,0,caml_call1(f,caml_bytes_unsafe_get(s,0)));
      return r}
    function capitalize_ascii(s){return apply1(uppercase_ascii,s)}
    function uncapitalize_ascii(s){return apply1(lowercase_ascii,s)}
    function index_rec(s,lim,i,c)
     {var i$0=i;
      for(;;)
       {if(lim <= i$0)throw Not_found;
        if(caml_bytes_unsafe_get(s,i$0) === c)return i$0;
        var i$1=i$0 + 1 | 0,i$0=i$1;
        continue}}
    function index(s,c){return index_rec(s,caml_ml_bytes_length(s),0,c)}
    function index_rec_opt(s,lim,i,c)
     {var i$0=i;
      for(;;)
       {if(lim <= i$0)return 0;
        if(caml_bytes_unsafe_get(s,i$0) === c)return [0,i$0];
        var i$1=i$0 + 1 | 0,i$0=i$1;
        continue}}
    function index_opt(s,c)
     {return index_rec_opt(s,caml_ml_bytes_length(s),0,c)}
    function index_from(s,i,c)
     {var l=caml_ml_bytes_length(s);
      if(0 <= i && ! (l < i))return index_rec(s,l,i,c);
      return invalid_arg(cst_String_index_from_Bytes_in)}
    function index_from_opt(s,i,c)
     {var l=caml_ml_bytes_length(s);
      if(0 <= i && ! (l < i))return index_rec_opt(s,l,i,c);
      return invalid_arg(cst_String_index_from_opt_Byte)}
    function rindex_rec(s,i,c)
     {var i$0=i;
      for(;;)
       {if(0 <= i$0)
         {if(caml_bytes_unsafe_get(s,i$0) === c)return i$0;
          var i$1=i$0 - 1 | 0,i$0=i$1;
          continue}
        throw Not_found}}
    function rindex(s,c)
     {return rindex_rec(s,caml_ml_bytes_length(s) - 1 | 0,c)}
    function rindex_from(s,i,c)
     {if(-1 <= i && ! (caml_ml_bytes_length(s) <= i))return rindex_rec(s,i,c);
      return invalid_arg(cst_String_rindex_from_Bytes_r)}
    function rindex_rec_opt(s,i,c)
     {var i$0=i;
      for(;;)
       {if(0 <= i$0)
         {if(caml_bytes_unsafe_get(s,i$0) === c)return [0,i$0];
          var i$1=i$0 - 1 | 0,i$0=i$1;
          continue}
        return 0}}
    function rindex_opt(s,c)
     {return rindex_rec_opt(s,caml_ml_bytes_length(s) - 1 | 0,c)}
    function rindex_from_opt(s,i,c)
     {if(-1 <= i && ! (caml_ml_bytes_length(s) <= i))
       return rindex_rec_opt(s,i,c);
      return invalid_arg(cst_String_rindex_from_opt_Byt)}
    function contains_from(s,i,c)
     {var l=caml_ml_bytes_length(s);
      if(0 <= i && ! (l < i))
       try
        {index_rec(s,l,i,c);var _yI_=1;return _yI_}
       catch(_yJ_)
        {_yJ_ = caml_wrap_exception(_yJ_);
         if(_yJ_ === Not_found)return 0;
         throw _yJ_}
      return invalid_arg(cst_String_contains_from_Bytes)}
    function contains(s,c){return contains_from(s,0,c)}
    function rcontains_from(s,i,c)
     {if(0 <= i && ! (caml_ml_bytes_length(s) <= i))
       try
        {rindex_rec(s,i,c);var _yG_=1;return _yG_}
       catch(_yH_)
        {_yH_ = caml_wrap_exception(_yH_);
         if(_yH_ === Not_found)return 0;
         throw _yH_}
      return invalid_arg(cst_String_rcontains_from_Byte)}
    var compare$4=runtime.caml_bytes_compare;
    function uppercase$0(s){return map$3(uppercase,s)}
    function lowercase$0(s){return map$3(lowercase,s)}
    function capitalize(s){return apply1(uppercase,s)}
    function uncapitalize(s){return apply1(lowercase,s)}
    function to_seq$2(s)
     {function aux(i,param)
       {if(i === caml_ml_bytes_length(s))return 0;
        var x=caml_bytes_get(s,i),_yE_=i + 1 | 0;
        return [0,x,function(_yF_){return aux(_yE_,_yF_)}]}
      var _yC_=0;
      return function(_yD_){return aux(_yC_,_yD_)}}
    function to_seqi(s)
     {function aux(i,param)
       {if(i === caml_ml_bytes_length(s))return 0;
        var x=caml_bytes_get(s,i),_yA_=i + 1 | 0;
        return [0,[0,i,x],function(_yB_){return aux(_yA_,_yB_)}]}
      var _yy_=0;
      return function(_yz_){return aux(_yy_,_yz_)}}
    function of_seq$0(i)
     {var n=[0,0],buf=[0,make(256,0)];
      iter
       (function(c)
         {if(n[1] === caml_ml_bytes_length(buf[1]))
           {var
             new_len=
              min(2 * caml_ml_bytes_length(buf[1]) | 0,max_string_length);
            if(caml_ml_bytes_length(buf[1]) === new_len)
             failwith(cst_Bytes_of_seq_cannot_grow_b);
            var new_buf=make(new_len,0);
            blit(buf[1],0,new_buf,0,n[1]);
            buf[1] = new_buf}
          caml_bytes_set(buf[1],n[1],c);
          n[1]++;
          return 0},
        i);
      return sub(buf[1],0,n[1])}
    function get_int8(b,i){return caml_bytes_get(b,i) << 24 >> 24}
    function get_uint16_le(b,i){return caml_bytes_get16(b,i)}
    function get_uint16_be(b,i){return caml_bswap16(caml_bytes_get16(b,i))}
    function get_int16_ne(b,i){return caml_bytes_get16(b,i) << 16 >> 16}
    function get_int16_le(b,i){return caml_bytes_get16(b,i) << 16 >> 16}
    function get_int16_be(b,i){return get_uint16_be(b,i) << 16 >> 16}
    function get_int32_le(b,i){return caml_bytes_get32(b,i)}
    function get_int32_be(b,i){return caml_int32_bswap(caml_bytes_get32(b,i))}
    function get_int64_le(b,i){return caml_bytes_get64(b,i)}
    function get_int64_be(b,i){return caml_int64_bswap(caml_bytes_get64(b,i))}
    function set_int16_le(b,i,x){return caml_bytes_set16(b,i,x)}
    function set_int16_be(b,i,x){return caml_bytes_set16(b,i,caml_bswap16(x))}
    function set_int32_le(b,i,x){return caml_bytes_set32(b,i,x)}
    function set_int32_be(b,i,x)
     {return caml_bytes_set32(b,i,caml_int32_bswap(x))}
    function set_int64_le(b,i,x){return caml_bytes_set64(b,i,x)}
    function set_int64_be(b,i,x)
     {return caml_bytes_set64(b,i,caml_int64_bswap(x))}
    var
     set_uint8=caml_bytes_set,
     set_uint16_ne=caml_bytes_set16,
     set_int64_ne=caml_bytes_set64,
     set_int32_ne=caml_bytes_set32,
     set_int16_ne=caml_bytes_set16,
     set_int8=caml_bytes_set,
     get_int64_ne=caml_bytes_get64,
     get_int32_ne=caml_bytes_get32,
     get_uint16_ne=caml_bytes_get16,
     get_uint8=caml_bytes_get,
     unsafe_of_string=caml_bytes_of_string,
     unsafe_to_string=caml_string_of_bytes,
     equal$4=runtime.caml_bytes_equal,
     include$0=
      [0,
       make,
       init$0,
       empty$0,
       copy,
       of_string,
       to_string$1,
       sub,
       sub_string,
       extend,
       fill,
       blit,
       blit$0,
       concat,
       cat,
       iter$3,
       iteri$0,
       map$3,
       mapi$0,
       trim,
       escaped$0,
       index,
       index_opt,
       rindex,
       rindex_opt,
       index_from,
       index_from_opt,
       rindex_from,
       rindex_from_opt,
       contains,
       contains_from,
       rcontains_from,
       uppercase$0,
       lowercase$0,
       capitalize,
       uncapitalize,
       uppercase_ascii$0,
       lowercase_ascii$0,
       capitalize_ascii,
       uncapitalize_ascii,
       compare$4,
       equal$4,
       unsafe_to_string,
       unsafe_of_string,
       to_seq$2,
       to_seqi,
       of_seq$0,
       get_uint8,
       get_int8,
       get_uint16_ne,
       get_uint16_be,
       get_uint16_le,
       get_int16_ne,
       get_int16_be,
       get_int16_le,
       get_int32_ne,
       get_int32_be,
       get_int32_le,
       get_int64_ne,
       get_int64_be,
       get_int64_le,
       set_uint8,
       set_int8,
       set_uint16_ne,
       set_int16_be,
       set_int16_le,
       set_int16_ne,
       set_int16_be,
       set_int16_le,
       set_int32_ne,
       set_int32_be,
       set_int32_le,
       set_int64_ne,
       set_int64_be,
       set_int64_le];
    caml_register_global(757,include$0,"Stdlib__bytes");
    function make$0(n,c){return caml_string_of_bytes(make(n,c))}
    function init$1(n,f){return caml_string_of_bytes(init$0(n,f))}
    function copy$0(s)
     {return caml_string_of_bytes(copy(caml_bytes_of_string(s)))}
    function sub$0(s,ofs,len)
     {return caml_string_of_bytes(sub(caml_bytes_of_string(s),ofs,len))}
    function concat$0(sep,l)
     {if(l)
       {var seplen=caml_ml_string_length(sep),acc=0,param=l,pos$1=0;
        for(;;)
         {if(param)
           {var _yv_=param[1];
            if(param[2])
             {var
               tl=param[2],
               x=(caml_ml_string_length(_yv_) + seplen | 0) + acc | 0,
               acc$0=acc <= x?x:invalid_arg(cst_String_concat),
               acc=acc$0,
               param=tl;
              continue}
            var _yx_=caml_ml_string_length(_yv_) + acc | 0}
          else
           var _yx_=acc;
          var dst=caml_create_bytes(_yx_),pos=pos$1,param$0=l;
          for(;;)
           {if(param$0)
             {var _yw_=param$0[1];
              if(param$0[2])
               {var tl$0=param$0[2];
                caml_blit_string(_yw_,0,dst,pos,caml_ml_string_length(_yw_));
                caml_blit_string
                 (sep,0,dst,pos + caml_ml_string_length(_yw_) | 0,seplen);
                var
                 pos$0=(pos + caml_ml_string_length(_yw_) | 0) + seplen | 0,
                 pos=pos$0,
                 param$0=tl$0;
                continue}
              caml_blit_string(_yw_,0,dst,pos,caml_ml_string_length(_yw_))}
            return caml_string_of_bytes(dst)}}}
      return cst$3}
    function iter$4(f,s)
     {var _yt_=caml_ml_string_length(s) - 1 | 0,_ys_=0;
      if(! (_yt_ < 0))
       {var i=_ys_;
        for(;;)
         {caml_call1(f,caml_string_unsafe_get(s,i));
          var _yu_=i + 1 | 0;
          if(_yt_ !== i){var i=_yu_;continue}
          break}}
      return 0}
    function iteri$1(f,s)
     {var _yq_=caml_ml_string_length(s) - 1 | 0,_yp_=0;
      if(! (_yq_ < 0))
       {var i=_yp_;
        for(;;)
         {caml_call2(f,i,caml_string_unsafe_get(s,i));
          var _yr_=i + 1 | 0;
          if(_yq_ !== i){var i=_yr_;continue}
          break}}
      return 0}
    function map$4(f,s)
     {return caml_string_of_bytes(map$3(f,caml_bytes_of_string(s)))}
    function mapi$1(f,s)
     {return caml_string_of_bytes(mapi$0(f,caml_bytes_of_string(s)))}
    function is_space$0(param)
     {var _yo_=param - 9 | 0,switch$0=0;
      if(4 < _yo_ >>> 0)
       {if(23 === _yo_)switch$0 = 1}
      else
       if(2 !== _yo_)switch$0 = 1;
      return switch$0?1:0}
    function trim$0(s)
     {if(caml_string_equal(s,cst$4))return s;
      if
       (!
        is_space$0(caml_string_unsafe_get(s,0))
        &&
        !
        is_space$0(caml_string_unsafe_get(s,caml_ml_string_length(s) - 1 | 0)))
       return s;
      return caml_string_of_bytes(trim(caml_bytes_of_string(s)))}
    function escaped$1(s)
     {var n=caml_ml_string_length(s),i=0;
      for(;;)
       {if(n <= i)return s;
        var match=caml_string_unsafe_get(s,i),_yn_=match - 32 | 0,switch$0=0;
        if(59 < _yn_ >>> 0)
         {if(33 < (_yn_ - 61 | 0) >>> 0)switch$0 = 1}
        else
         if(2 === _yn_)switch$0 = 1;
        if(switch$0)
         return caml_string_of_bytes(escaped$0(caml_bytes_of_string(s)));
        var i$0=i + 1 | 0,i=i$0;
        continue}}
    function index_rec$0(s,lim,i,c)
     {var i$0=i;
      for(;;)
       {if(lim <= i$0)throw Not_found;
        if(caml_string_unsafe_get(s,i$0) === c)return i$0;
        var i$1=i$0 + 1 | 0,i$0=i$1;
        continue}}
    function index$0(s,c){return index_rec$0(s,caml_ml_string_length(s),0,c)}
    function index_rec_opt$0(s,lim,i,c)
     {var i$0=i;
      for(;;)
       {if(lim <= i$0)return 0;
        if(caml_string_unsafe_get(s,i$0) === c)return [0,i$0];
        var i$1=i$0 + 1 | 0,i$0=i$1;
        continue}}
    function index_opt$0(s,c)
     {return index_rec_opt$0(s,caml_ml_string_length(s),0,c)}
    function index_from$0(s,i,c)
     {var l=caml_ml_string_length(s);
      if(0 <= i && ! (l < i))return index_rec$0(s,l,i,c);
      return invalid_arg(cst_String_index_from_Bytes_in$0)}
    function index_from_opt$0(s,i,c)
     {var l=caml_ml_string_length(s);
      if(0 <= i && ! (l < i))return index_rec_opt$0(s,l,i,c);
      return invalid_arg(cst_String_index_from_opt_Byte$0)}
    function rindex_rec$0(s,i,c)
     {var i$0=i;
      for(;;)
       {if(0 <= i$0)
         {if(caml_string_unsafe_get(s,i$0) === c)return i$0;
          var i$1=i$0 - 1 | 0,i$0=i$1;
          continue}
        throw Not_found}}
    function rindex$0(s,c)
     {return rindex_rec$0(s,caml_ml_string_length(s) - 1 | 0,c)}
    function rindex_from$0(s,i,c)
     {if(-1 <= i && ! (caml_ml_string_length(s) <= i))
       return rindex_rec$0(s,i,c);
      return invalid_arg(cst_String_rindex_from_Bytes_r$0)}
    function rindex_rec_opt$0(s,i,c)
     {var i$0=i;
      for(;;)
       {if(0 <= i$0)
         {if(caml_string_unsafe_get(s,i$0) === c)return [0,i$0];
          var i$1=i$0 - 1 | 0,i$0=i$1;
          continue}
        return 0}}
    function rindex_opt$0(s,c)
     {return rindex_rec_opt$0(s,caml_ml_string_length(s) - 1 | 0,c)}
    function rindex_from_opt$0(s,i,c)
     {if(-1 <= i && ! (caml_ml_string_length(s) <= i))
       return rindex_rec_opt$0(s,i,c);
      return invalid_arg(cst_String_rindex_from_opt_Byt$0)}
    function contains_from$0(s,i,c)
     {var l=caml_ml_string_length(s);
      if(0 <= i && ! (l < i))
       try
        {index_rec$0(s,l,i,c);var _yl_=1;return _yl_}
       catch(_ym_)
        {_ym_ = caml_wrap_exception(_ym_);
         if(_ym_ === Not_found)return 0;
         throw _ym_}
      return invalid_arg(cst_String_contains_from_Bytes$0)}
    function contains$0(s,c){return contains_from$0(s,0,c)}
    function rcontains_from$0(s,i,c)
     {if(0 <= i && ! (caml_ml_string_length(s) <= i))
       try
        {rindex_rec$0(s,i,c);var _yj_=1;return _yj_}
       catch(_yk_)
        {_yk_ = caml_wrap_exception(_yk_);
         if(_yk_ === Not_found)return 0;
         throw _yk_}
      return invalid_arg(cst_String_rcontains_from_Byte$0)}
    function uppercase_ascii$1(s)
     {return caml_string_of_bytes(uppercase_ascii$0(caml_bytes_of_string(s)))}
    function lowercase_ascii$1(s)
     {return caml_string_of_bytes(lowercase_ascii$0(caml_bytes_of_string(s)))}
    function capitalize_ascii$0(s)
     {return caml_string_of_bytes(capitalize_ascii(caml_bytes_of_string(s)))}
    function uncapitalize_ascii$0(s)
     {return caml_string_of_bytes(uncapitalize_ascii(caml_bytes_of_string(s)))}
    var compare$5=caml_string_compare;
    function split_on_char(sep,s)
     {var
       r=[0,0],
       j=[0,caml_ml_string_length(s)],
       _yf_=caml_ml_string_length(s) - 1 | 0;
      if(! (_yf_ < 0))
       {var i=_yf_;
        for(;;)
         {if(caml_string_unsafe_get(s,i) === sep)
           {var _yh_=r[1];
            r[1] = [0,sub$0(s,i + 1 | 0,(j[1] - i | 0) - 1 | 0),_yh_];
            j[1] = i}
          var _yi_=i - 1 | 0;
          if(0 !== i){var i=_yi_;continue}
          break}}
      var _yg_=r[1];
      return [0,sub$0(s,0,j[1]),_yg_]}
    function uppercase$1(s)
     {return caml_string_of_bytes(uppercase$0(caml_bytes_of_string(s)))}
    function lowercase$1(s)
     {return caml_string_of_bytes(lowercase$0(caml_bytes_of_string(s)))}
    function capitalize$0(s)
     {return caml_string_of_bytes(capitalize(caml_bytes_of_string(s)))}
    function uncapitalize$0(s)
     {return caml_string_of_bytes(uncapitalize(caml_bytes_of_string(s)))}
    function to_seq$3(s){return to_seq$2(caml_bytes_of_string(s))}
    function to_seqi$0(s){return to_seqi(caml_bytes_of_string(s))}
    function of_seq$1(g){return caml_string_of_bytes(of_seq$0(g))}
    var
     equal$5=caml_string_equal,
     include$1=
      [0,
       make$0,
       init$1,
       copy$0,
       sub$0,
       fill,
       blit$0,
       concat$0,
       iter$4,
       iteri$1,
       map$4,
       mapi$1,
       trim$0,
       escaped$1,
       index$0,
       index_opt$0,
       rindex$0,
       rindex_opt$0,
       index_from$0,
       index_from_opt$0,
       rindex_from$0,
       rindex_from_opt$0,
       contains$0,
       contains_from$0,
       rcontains_from$0,
       uppercase$1,
       lowercase$1,
       capitalize$0,
       uncapitalize$0,
       uppercase_ascii$1,
       lowercase_ascii$1,
       capitalize_ascii$0,
       uncapitalize_ascii$0,
       compare$5,
       equal$5,
       split_on_char,
       to_seq$3,
       to_seqi$0,
       of_seq$1];
    caml_register_global(758,include$1,"Stdlib__string");
    function equal$6(param,_ye_){return 1}
    function compare$6(param,_yd_){return 0}
    function to_string$2(param){return cst$5}
    var Stdlib_unit=[0,equal$6,compare$6,to_string$2];
    caml_register_global(759,Stdlib_unit,"Stdlib__unit");
    function to_buffer(buff,ofs,len,v,flags)
     {if
       (0
        <=
        ofs
        &&
        0
        <=
        len
        &&
        !
        ((caml_ml_bytes_length(buff) - len | 0) < ofs))
       return runtime.caml_output_value_to_buffer(buff,ofs,len,v,flags);
      return invalid_arg(cst_Marshal_to_buffer_substrin)}
    var header_size=20;
    function data_size(buff,ofs)
     {if(0 <= ofs && ! ((caml_ml_bytes_length(buff) - 20 | 0) < ofs))
       return caml_marshal_data_size(buff,ofs);
      return invalid_arg(cst_Marshal_data_size)}
    function total_size(buff,ofs){return 20 + data_size(buff,ofs) | 0}
    function from_bytes(buff,ofs)
     {if(0 <= ofs && ! ((caml_ml_bytes_length(buff) - 20 | 0) < ofs))
       {var len=caml_marshal_data_size(buff,ofs);
        return (caml_ml_bytes_length(buff) - (20 + len | 0) | 0) < ofs
                ?invalid_arg(cst_Marshal_from_bytes$0)
                :runtime.caml_input_value_from_bytes(buff,ofs)}
      return invalid_arg(cst_Marshal_from_bytes)}
    function from_string(buff,ofs)
     {return from_bytes(caml_bytes_of_string(buff),ofs)}
    var
     Stdlib_marshal=
      [0,
       caml_output_value,
       to_buffer,
       caml_input_value,
       from_bytes,
       from_string,
       header_size,
       data_size,
       total_size];
    caml_register_global(760,Stdlib_marshal,"Stdlib__marshal");
    function is_block(a){return 1 - (typeof a === "number"?1:0)}
    var double_field=caml_array_get,set_double_field=caml_array_set;
    function marshal(obj){return runtime.caml_output_value_to_bytes(obj,0)}
    function unmarshal(str,pos)
     {var _yc_=pos + total_size(str,pos) | 0;
      return [0,from_bytes(str,pos),_yc_]}
    var
     first_non_constant_constructor=0,
     last_non_constant_constructor_=245,
     lazy_tag=246,
     closure_tag=247,
     object_tag=248,
     infix_tag=249,
     forward_tag=250,
     no_scan_tag=251,
     abstract_tag=251,
     string_tag=252,
     double_tag=253,
     double_array_tag=254,
     custom_tag=255,
     int_tag=1000,
     out_of_heap_tag=1001,
     unaligned_tag=1002;
    function of_val(x)
     {var switch$0=0;
      if(is_block(x) && caml_obj_tag(x) !== 248 && 1 <= x.length - 1)
       {var slot=x[1];switch$0 = 1}
      if(! switch$0)var slot=x;
      var switch$1=0;
      if(is_block(slot) && caml_obj_tag(slot) === 248)
       {var name=slot[1];switch$1 = 1}
      if(! switch$1)var name=invalid_arg(cst_Obj_extension_constructor$0);
      return caml_obj_tag(name) === 252
              ?slot
              :invalid_arg(cst_Obj_extension_constructor)}
    function name(slot){return slot[1]}
    function id(slot){return slot[2]}
    var
     Extension_constructor=[0,of_val,name,id],
     extension_constructor=Extension_constructor[1],
     extension_name=Extension_constructor[2],
     extension_id=Extension_constructor[3],
     max_ephe_length=max_array_length - 2 | 0;
    function create(l)
     {var _ya_=0 <= l?1:0,_yb_=_ya_?l <= max_ephe_length?1:0:_ya_;
      if(1 - _yb_)invalid_arg(cst_Obj_Ephemeron_create);
      return runtime.caml_ephe_create(l)}
    function length$0(x){return x.length - 1 - 2 | 0}
    function raise_if_invalid_offset(e,o,msg)
     {var _x9_=0 <= o?1:0,_x__=_x9_?o < length$0(e)?1:0:_x9_,_x$_=1 - _x__;
      return _x$_?invalid_arg(msg):_x$_}
    function get_key(e,o)
     {raise_if_invalid_offset(e,o,cst_Obj_Ephemeron_get_key);
      return runtime.caml_ephe_get_key(e,o)}
    function get_key_copy(e,o)
     {raise_if_invalid_offset(e,o,cst_Obj_Ephemeron_get_key_copy);
      return runtime.caml_ephe_get_key_copy(e,o)}
    function set_key(e,o,x)
     {raise_if_invalid_offset(e,o,cst_Obj_Ephemeron_set_key);
      return caml_ephe_set_key(e,o,x)}
    function unset_key(e,o)
     {raise_if_invalid_offset(e,o,cst_Obj_Ephemeron_unset_key);
      return caml_ephe_unset_key(e,o)}
    function check_key(e,o)
     {raise_if_invalid_offset(e,o,cst_Obj_Ephemeron_check_key);
      return runtime.caml_ephe_check_key(e,o)}
    function blit_key(e1,o1,e2,o2,l)
     {if
       (0
        <=
        l
        &&
        0
        <=
        o1
        &&
        !
        ((length$0(e1) - l | 0) < o1)
        &&
        0
        <=
        o2
        &&
        !
        ((length$0(e2) - l | 0) < o2))
       {var
         _x7_=0 !== l?1:0,
         _x8_=_x7_?runtime.caml_ephe_blit_key(e1,o1,e2,o2,l):_x7_;
        return _x8_}
      return invalid_arg(cst_Obj_Ephemeron_blit_key)}
    var
     _p_=runtime.caml_ephe_blit_data,
     _q_=runtime.caml_ephe_check_data,
     _r_=
      [0,
       create,
       length$0,
       get_key,
       get_key_copy,
       set_key,
       unset_key,
       check_key,
       blit_key,
       runtime.caml_ephe_get_data,
       runtime.caml_ephe_get_data_copy,
       runtime.caml_ephe_set_data,
       function(_x6_){return runtime.caml_ephe_unset_data(_x6_)},
       _q_,
       _p_,
       max_ephe_length],
     Stdlib_obj=
      [0,
       is_block,
       double_field,
       set_double_field,
       first_non_constant_constructor,
       last_non_constant_constructor_,
       lazy_tag,
       closure_tag,
       object_tag,
       infix_tag,
       forward_tag,
       no_scan_tag,
       abstract_tag,
       string_tag,
       double_tag,
       double_array_tag,
       custom_tag,
       custom_tag,
       int_tag,
       out_of_heap_tag,
       unaligned_tag,
       Extension_constructor,
       extension_constructor,
       extension_name,
       extension_id,
       marshal,
       unmarshal,
       _r_];
    caml_register_global(761,Stdlib_obj,"Stdlib__obj");
    var make_float=runtime.caml_make_float_vect,Floatarray=[0];
    function init$2(l,f)
     {if(0 === l)return [0];
      if(0 <= l)
       {var res=caml_make_vect(l,caml_call1(f,0)),_x4_=l - 1 | 0,_x3_=1;
        if(! (_x4_ < 1))
         {var i=_x3_;
          for(;;)
           {res[1 + i] = caml_call1(f,i);
            var _x5_=i + 1 | 0;
            if(_x4_ !== i){var i=_x5_;continue}
            break}}
        return res}
      return invalid_arg(cst_Array_init)}
    function create_matrix(sx,sy,init)
     {var res=caml_make_vect(sx,[0]),_x1_=sx - 1 | 0,_x0_=0;
      if(! (_x1_ < 0))
       {var x=_x0_;
        for(;;)
         {res[1 + x] = caml_make_vect(sy,init);
          var _x2_=x + 1 | 0;
          if(_x1_ !== x){var x=_x2_;continue}
          break}}
      return res}
    function copy$1(a)
     {var l=a.length - 1;return 0 === l?[0]:caml_array_sub(a,0,l)}
    function append$0(a1,a2)
     {var l1=a1.length - 1;
      return 0 === l1
              ?copy$1(a2)
              :0 === a2.length - 1
                ?caml_array_sub(a1,0,l1)
                :runtime.caml_array_append(a1,a2)}
    function sub$1(a,ofs,len)
     {if(0 <= ofs && 0 <= len && ! ((a.length - 1 - len | 0) < ofs))
       return caml_array_sub(a,ofs,len);
      return invalid_arg(cst_Array_sub)}
    function fill$0(a,ofs,len,v)
     {if(0 <= ofs && 0 <= len && ! ((a.length - 1 - len | 0) < ofs))
       return runtime.caml_array_fill(a,ofs,len,v);
      return invalid_arg(cst_Array_fill)}
    function blit$1(a1,ofs1,a2,ofs2,len)
     {if
       (0
        <=
        len
        &&
        0
        <=
        ofs1
        &&
        !
        ((a1.length - 1 - len | 0) < ofs1)
        &&
        0
        <=
        ofs2
        &&
        !
        ((a2.length - 1 - len | 0) < ofs2))
       return runtime.caml_array_blit(a1,ofs1,a2,ofs2,len);
      return invalid_arg(cst_Array_blit)}
    function iter$5(f,a)
     {var _xY_=a.length - 1 - 1 | 0,_xX_=0;
      if(! (_xY_ < 0))
       {var i=_xX_;
        for(;;)
         {caml_call1(f,a[1 + i]);
          var _xZ_=i + 1 | 0;
          if(_xY_ !== i){var i=_xZ_;continue}
          break}}
      return 0}
    function iter2$0(f,a,b)
     {if(a.length - 1 !== b.length - 1)
       return invalid_arg(cst_Array_iter2_arrays_must_ha);
      var _xV_=a.length - 1 - 1 | 0,_xU_=0;
      if(! (_xV_ < 0))
       {var i=_xU_;
        for(;;)
         {caml_call2(f,a[1 + i],b[1 + i]);
          var _xW_=i + 1 | 0;
          if(_xV_ !== i){var i=_xW_;continue}
          break}}
      return 0}
    function map$5(f,a)
     {var l=a.length - 1;
      if(0 === l)return [0];
      var r=caml_make_vect(l,caml_call1(f,a[1])),_xS_=l - 1 | 0,_xR_=1;
      if(! (_xS_ < 1))
       {var i=_xR_;
        for(;;)
         {r[1 + i] = caml_call1(f,a[1 + i]);
          var _xT_=i + 1 | 0;
          if(_xS_ !== i){var i=_xT_;continue}
          break}}
      return r}
    function map2$0(f,a,b)
     {var la=a.length - 1,lb=b.length - 1;
      if(la !== lb)return invalid_arg(cst_Array_map2_arrays_must_hav);
      if(0 === la)return [0];
      var r=caml_make_vect(la,caml_call2(f,a[1],b[1])),_xP_=la - 1 | 0,_xO_=1;
      if(! (_xP_ < 1))
       {var i=_xO_;
        for(;;)
         {r[1 + i] = caml_call2(f,a[1 + i],b[1 + i]);
          var _xQ_=i + 1 | 0;
          if(_xP_ !== i){var i=_xQ_;continue}
          break}}
      return r}
    function iteri$2(f,a)
     {var _xM_=a.length - 1 - 1 | 0,_xL_=0;
      if(! (_xM_ < 0))
       {var i=_xL_;
        for(;;)
         {caml_call2(f,i,a[1 + i]);
          var _xN_=i + 1 | 0;
          if(_xM_ !== i){var i=_xN_;continue}
          break}}
      return 0}
    function mapi$2(f,a)
     {var l=a.length - 1;
      if(0 === l)return [0];
      var r=caml_make_vect(l,caml_call2(f,0,a[1])),_xJ_=l - 1 | 0,_xI_=1;
      if(! (_xJ_ < 1))
       {var i=_xI_;
        for(;;)
         {r[1 + i] = caml_call2(f,i,a[1 + i]);
          var _xK_=i + 1 | 0;
          if(_xJ_ !== i){var i=_xK_;continue}
          break}}
      return r}
    function to_list$1(a)
     {var i$1=a.length - 1 - 1 | 0,i=i$1,res=0;
      for(;;)
       {if(0 <= i)
         {var res$0=[0,a[1 + i],res],i$0=i - 1 | 0,i=i$0,res=res$0;continue}
        return res}}
    function list_length(accu,param)
     {var accu$0=accu,param$0=param;
      for(;;)
       {if(param$0)
         {var
           param$1=param$0[2],
           accu$1=accu$0 + 1 | 0,
           accu$0=accu$1,
           param$0=param$1;
          continue}
        return accu$0}}
    function of_list(l)
     {if(l)
       {var
         tl=l[2],
         hd=l[1],
         a=caml_make_vect(list_length(0,l),hd),
         i=1,
         param=tl;
        for(;;)
         {if(param)
           {var tl$0=param[2],hd$0=param[1];
            a[1 + i] = hd$0;
            var i$0=i + 1 | 0,i=i$0,param=tl$0;
            continue}
          return a}}
      return [0]}
    function fold_left$1(f,x,a)
     {var r=[0,x],_xG_=a.length - 1 - 1 | 0,_xF_=0;
      if(! (_xG_ < 0))
       {var i=_xF_;
        for(;;)
         {r[1] = caml_call2(f,r[1],a[1 + i]);
          var _xH_=i + 1 | 0;
          if(_xG_ !== i){var i=_xH_;continue}
          break}}
      return r[1]}
    function fold_right$0(f,a,x)
     {var r=[0,x],_xD_=a.length - 1 - 1 | 0;
      if(! (_xD_ < 0))
       {var i=_xD_;
        for(;;)
         {r[1] = caml_call2(f,a[1 + i],r[1]);
          var _xE_=i - 1 | 0;
          if(0 !== i){var i=_xE_;continue}
          break}}
      return r[1]}
    function exists$0(p,a)
     {var n=a.length - 1,i=0;
      for(;;)
       {if(i === n)return 0;
        if(caml_call1(p,a[1 + i]))return 1;
        var i$0=i + 1 | 0,i=i$0;
        continue}}
    function for_all$0(p,a)
     {var n=a.length - 1,i=0;
      for(;;)
       {if(i === n)return 1;
        if(caml_call1(p,a[1 + i])){var i$0=i + 1 | 0,i=i$0;continue}
        return 0}}
    function mem$0(x,a)
     {var n=a.length - 1,i=0;
      for(;;)
       {if(i === n)return 0;
        if(0 === caml_compare(a[1 + i],x))return 1;
        var i$0=i + 1 | 0,i=i$0;
        continue}}
    function memq$0(x,a)
     {var n=a.length - 1,i=0;
      for(;;)
       {if(i === n)return 0;
        if(x === a[1 + i])return 1;
        var i$0=i + 1 | 0,i=i$0;
        continue}}
    var Bottom=[248,cst_Stdlib_Array_Bottom,caml_fresh_oo_id(0)];
    function sort(cmp,a)
     {function maxson(l,i)
       {var i31=((i + i | 0) + i | 0) + 1 | 0,x=[0,i31];
        if((i31 + 2 | 0) < l)
         {var _xw_=i31 + 1 | 0,_xx_=caml_check_bound(a,_xw_)[1 + _xw_];
          if(caml_call2(cmp,caml_check_bound(a,i31)[1 + i31],_xx_) < 0)
           x[1] = i31 + 1 | 0;
          var
           _xy_=i31 + 2 | 0,
           _xz_=caml_check_bound(a,_xy_)[1 + _xy_],
           _xA_=x[1];
          if(caml_call2(cmp,caml_check_bound(a,_xA_)[1 + _xA_],_xz_) < 0)
           x[1] = i31 + 2 | 0;
          return x[1]}
        if((i31 + 1 | 0) < l)
         {var _xB_=i31 + 1 | 0,_xC_=caml_check_bound(a,_xB_)[1 + _xB_];
          if(! (0 <= caml_call2(cmp,caml_check_bound(a,i31)[1 + i31],_xC_)))
           return i31 + 1 | 0}
        if(i31 < l)return i31;
        throw [0,Bottom,i]}
      function trickledown(l,i,e)
       {var i$0=i;
        for(;;)
         {var j=maxson(l,i$0);
          if(0 < caml_call2(cmp,caml_check_bound(a,j)[1 + j],e))
           {var _xv_=caml_check_bound(a,j)[1 + j];
            caml_check_bound(a,i$0)[1 + i$0] = _xv_;
            var i$0=j;
            continue}
          caml_check_bound(a,i$0)[1 + i$0] = e;
          return 0}}
      function trickle(l,i,e)
       {try
         {var _xu_=trickledown(l,i,e);return _xu_}
        catch(exn)
         {exn = caml_wrap_exception(exn);
          if(exn[1] === Bottom)
           {var i$0=exn[2];caml_check_bound(a,i$0)[1 + i$0] = e;return 0}
          throw exn}}
      function bubbledown(l,i)
       {var i$0=i;
        for(;;)
         {var i$1=maxson(l,i$0),_xt_=caml_check_bound(a,i$1)[1 + i$1];
          caml_check_bound(a,i$0)[1 + i$0] = _xt_;
          var i$0=i$1;
          continue}}
      function bubble(l,i)
       {try
         {var _xs_=bubbledown(l,i);return _xs_}
        catch(exn)
         {exn = caml_wrap_exception(exn);
          if(exn[1] === Bottom){var i$0=exn[2];return i$0}
          throw exn}}
      var l=a.length - 1,_xk_=((l + 1 | 0) / 3 | 0) - 1 | 0;
      if(! (_xk_ < 0))
       {var i$2=_xk_;
        for(;;)
         {trickle(l,i$2,caml_check_bound(a,i$2)[1 + i$2]);
          var _xr_=i$2 - 1 | 0;
          if(0 !== i$2){var i$2=_xr_;continue}
          break}}
      var _xl_=l - 1 | 0;
      if(! (_xl_ < 2))
       {var i$0=_xl_;
        a:
        for(;;)
         {var
           e$0=caml_check_bound(a,i$0)[1 + i$0],
           _xp_=caml_check_bound(a,0)[1];
          caml_check_bound(a,i$0)[1 + i$0] = _xp_;
          var i$1=bubble(i$0,0),i=i$1;
          for(;;)
           {var father=(i - 1 | 0) / 3 | 0;
            if(i === father)throw [0,Assert_failure,_s_];
            if
             (0 <= caml_call2(cmp,caml_check_bound(a,father)[1 + father],e$0))
             caml_check_bound(a,i)[1 + i] = e$0;
            else
             {var _xj_=caml_check_bound(a,father)[1 + father];
              caml_check_bound(a,i)[1 + i] = _xj_;
              if(0 < father){var i=father;continue}
              caml_check_bound(a,0)[1] = e$0}
            var _xq_=i$0 - 1 | 0;
            if(2 !== i$0){var i$0=_xq_;continue a}
            break}
          break}}
      var _xm_=1 < l?1:0;
      if(_xm_)
       {var e=caml_check_bound(a,1)[2],_xn_=caml_check_bound(a,0)[1];
        caml_check_bound(a,1)[2] = _xn_;
        caml_check_bound(a,0)[1] = e;
        var _xo_=0}
      else
       var _xo_=_xm_;
      return _xo_}
    function fast_sort$0(cmp,a)
     {function merge(src1ofs,src1len,src2,src2ofs,src2len,dst,dstofs)
       {var
         src1r=src1ofs + src1len | 0,
         src2r=src2ofs + src2len | 0,
         s2$1=caml_check_bound(src2,src2ofs)[1 + src2ofs],
         s1$1=caml_check_bound(a,src1ofs)[1 + src1ofs],
         i1=src1ofs,
         s1=s1$1,
         i2=src2ofs,
         s2=s2$1,
         d=dstofs;
        for(;;)
         {if(0 < caml_call2(cmp,s1,s2))
           {caml_check_bound(dst,d)[1 + d] = s2;
            var i2$0=i2 + 1 | 0;
            if(i2$0 < src2r)
             {var
               d$0=d + 1 | 0,
               s2$0=caml_check_bound(src2,i2$0)[1 + i2$0],
               i2=i2$0,
               s2=s2$0,
               d=d$0;
              continue}
            return blit$1(a,i1,dst,d + 1 | 0,src1r - i1 | 0)}
          caml_check_bound(dst,d)[1 + d] = s1;
          var i1$0=i1 + 1 | 0;
          if(i1$0 < src1r)
           {var
             d$1=d + 1 | 0,
             s1$0=caml_check_bound(a,i1$0)[1 + i1$0],
             i1=i1$0,
             s1=s1$0,
             d=d$1;
            continue}
          return blit$1(src2,i2,dst,d + 1 | 0,src2r - i2 | 0)}}
      function isortto(srcofs,dst,dstofs,len)
       {var _xb_=len - 1 | 0,_xa_=0;
        if(! (_xb_ < 0))
         {var i=_xa_;
          a:
          for(;;)
           {var
             _xc_=srcofs + i | 0,
             e=caml_check_bound(a,_xc_)[1 + _xc_],
             j=[0,(dstofs + i | 0) - 1 | 0];
            for(;;)
             {if(dstofs <= j[1])
               {var _xd_=j[1];
                if(0 < caml_call2(cmp,caml_check_bound(dst,_xd_)[1 + _xd_],e))
                 {var
                   _xe_=j[1],
                   _xf_=caml_check_bound(dst,_xe_)[1 + _xe_],
                   _xg_=j[1] + 1 | 0;
                  caml_check_bound(dst,_xg_)[1 + _xg_] = _xf_;
                  j[1] += -1;
                  continue}}
              var _xh_=j[1] + 1 | 0;
              caml_check_bound(dst,_xh_)[1 + _xh_] = e;
              var _xi_=i + 1 | 0;
              if(_xb_ !== i){var i=_xi_;continue a}
              break}
            break}}
        return 0}
      function sortto(srcofs,dst,dstofs,len)
       {if(len <= 5)return isortto(srcofs,dst,dstofs,len);
        var l1=len / 2 | 0,l2=len - l1 | 0;
        sortto(srcofs + l1 | 0,dst,dstofs + l1 | 0,l2);
        sortto(srcofs,a,srcofs + l2 | 0,l1);
        return merge(srcofs + l2 | 0,l1,dst,dstofs + l1 | 0,l2,dst,dstofs)}
      var l=a.length - 1;
      if(l <= 5)return isortto(0,a,0,l);
      var
       l1=l / 2 | 0,
       l2=l - l1 | 0,
       t=caml_make_vect(l2,caml_check_bound(a,0)[1]);
      sortto(l1,t,0,l2);
      sortto(0,a,l2,l1);
      return merge(l2,l1,t,0,l2,a,0)}
    function to_seq$4(a)
     {function aux(i,param)
       {if(i < a.length - 1)
         {var x=a[1 + i],_w__=i + 1 | 0;
          return [0,x,function(_w$_){return aux(_w__,_w$_)}]}
        return 0}
      var _w8_=0;
      return function(_w9_){return aux(_w8_,_w9_)}}
    function to_seqi$1(a)
     {function aux(i,param)
       {if(i < a.length - 1)
         {var x=a[1 + i],_w6_=i + 1 | 0;
          return [0,[0,i,x],function(_w7_){return aux(_w6_,_w7_)}]}
        return 0}
      var _w4_=0;
      return function(_w5_){return aux(_w4_,_w5_)}}
    function of_seq$2(i$2)
     {var _w3_=0,l=fold_left(function(acc,x){return [0,x,acc]},_w3_,i$2);
      if(l)
       {var
         tl=l[2],
         hd=l[1],
         len=list_length(0,l),
         a=caml_make_vect(len,hd),
         i$1=len - 2 | 0,
         i=i$1,
         param=tl;
        for(;;)
         {if(param)
           {var tl$0=param[2],hd$0=param[1];
            a[1 + i] = hd$0;
            var i$0=i - 1 | 0,i=i$0,param=tl$0;
            continue}
          return a}}
      return [0]}
    var
     concat$1=caml_array_concat,
     include$2=
      [0,
       make_float,
       init$2,
       create_matrix,
       create_matrix,
       append$0,
       concat$1,
       sub$1,
       copy$1,
       fill$0,
       blit$1,
       to_list$1,
       of_list,
       iter$5,
       iteri$2,
       map$5,
       mapi$2,
       fold_left$1,
       fold_right$0,
       iter2$0,
       map2$0,
       for_all$0,
       exists$0,
       mem$0,
       memq$0,
       sort,
       fast_sort$0,
       fast_sort$0,
       to_seq$4,
       to_seqi$1,
       of_seq$2,
       Floatarray];
    caml_register_global(762,include$2,"Stdlib__array");
    var zero=0.,one=1.,minus_one=-1.;
    function is_finite(x){return x - x == 0.?1:0}
    function is_infinite(x){return 1. / x == 0.?1:0}
    function is_nan(x){return x != x?1:0}
    var pi=3.14159265358979312;
    function is_integer(x)
     {var _w2_=x == runtime.caml_trunc_float(x)?1:0;
      return _w2_?is_finite(x):_w2_}
    function succ$0(x){return caml_nextafter_float(x,infinity)}
    function pred$0(x){return caml_nextafter_float(x,neg_infinity)}
    function equal$7(x,y){return 0 === caml_float_compare(x,y)?1:0}
    function min$1(x,y)
     {if(! (x < y))
       {var switch$0=0;
        if(caml_signbit_float(y) || ! caml_signbit_float(x))switch$0 = 1;
        if(switch$0)return x != x?x:y}
      return y != y?y:x}
    function max$1(x,y)
     {if(! (x < y))
       {var switch$0=0;
        if(caml_signbit_float(y) || ! caml_signbit_float(x))switch$0 = 1;
        if(switch$0)return y != y?y:x}
      return x != x?x:y}
    function min_max(x,y)
     {if(x == x && y == y)
       {if(! (x < y))
         {var switch$0=0;
          if(caml_signbit_float(y) || ! caml_signbit_float(x))switch$0 = 1;
          if(switch$0)return [0,y,x]}
        return [0,x,y]}
      return [0,nan,nan]}
    function min_num(x,y)
     {if(! (x < y))
       {var switch$0=0;
        if(caml_signbit_float(y) || ! caml_signbit_float(x))switch$0 = 1;
        if(switch$0)return y != y?x:y}
      return x != x?y:x}
    function max_num(x,y)
     {if(! (x < y))
       {var switch$0=0;
        if(caml_signbit_float(y) || ! caml_signbit_float(x))switch$0 = 1;
        if(switch$0)return x != x?y:x}
      return y != y?x:y}
    function min_max_num(x,y)
     {if(x != x)return [0,y,y];
      if(y != y)return [0,x,x];
      if(! (x < y))
       {var switch$0=0;
        if(caml_signbit_float(y) || ! caml_signbit_float(x))switch$0 = 1;
        if(switch$0)return [0,y,x]}
      return [0,x,y]}
    function hash$0(x){return caml_hash(10,100,0,x)}
    function unsafe_fill(a,ofs,len,v)
     {var _w0_=(ofs + len | 0) - 1 | 0;
      if(! (_w0_ < ofs))
       {var i=ofs;
        for(;;)
         {a[1 + i] = v;
          var _w1_=i + 1 | 0;
          if(_w0_ !== i){var i=_w1_;continue}
          break}}
      return 0}
    function unsafe_blit(src,sofs,dst,dofs,len)
     {var _wY_=len - 1 | 0,_wX_=0;
      if(! (_wY_ < 0))
       {var i=_wX_;
        for(;;)
         {dst[1 + (dofs + i | 0)] = src[1 + (sofs + i | 0)];
          var _wZ_=i + 1 | 0;
          if(_wY_ !== i){var i=_wZ_;continue}
          break}}
      return 0}
    function check(a,ofs,len,msg)
     {var _wT_=ofs < 0?1:0;
      if(_wT_)
       var _wU_=_wT_;
      else
       {var _wV_=len < 0?1:0;
        if(_wV_)
         var _wU_=_wV_;
        else
         var
          _wW_=(ofs + len | 0) < 0?1:0,
          _wU_=_wW_ || (a.length - 1 < (ofs + len | 0)?1:0)}
      return _wU_?invalid_arg(msg):_wU_}
    function make$1(n,v)
     {var result=caml_floatarray_create(n);
      unsafe_fill(result,0,n,v);
      return result}
    function init$3(l,f)
     {if(0 <= l)
       {var res=caml_floatarray_create(l),_wR_=l - 1 | 0,_wQ_=0;
        if(! (_wR_ < 0))
         {var i=_wQ_;
          for(;;)
           {res[1 + i] = caml_call1(f,i);
            var _wS_=i + 1 | 0;
            if(_wR_ !== i){var i=_wS_;continue}
            break}}
        return res}
      return invalid_arg(cst_Float_Array_init)}
    function append$1(a1,a2)
     {var
       l1=a1.length - 1,
       l2=a2.length - 1,
       result=caml_floatarray_create(l1 + l2 | 0);
      unsafe_blit(a1,0,result,0,l1);
      unsafe_blit(a2,0,result,l1,l2);
      return result}
    function concat$2(l)
     {var acc=0,param=l;
      for(;;)
       {if(param)
         {var
           tl=param[2],
           hd=param[1],
           x=hd.length - 1 + acc | 0,
           acc$0=acc <= x?x:invalid_arg(cst_Float_Array_concat),
           acc=acc$0,
           param=tl;
          continue}
        var result=caml_floatarray_create(acc),l$0=l,i=0;
        for(;;)
         {if(l$0)
           {var tl$0=l$0[2],hd$0=l$0[1],hlen=hd$0.length - 1;
            unsafe_blit(hd$0,0,result,i,hlen);
            var i$0=i + hlen | 0,l$0=tl$0,i=i$0;
            continue}
          if(i === acc)return result;
          throw [0,Assert_failure,_t_]}}}
    function sub$2(a,ofs,len)
     {check(a,ofs,len,cst_Float_Array_sub);
      var result=caml_floatarray_create(len);
      unsafe_blit(a,ofs,result,0,len);
      return result}
    function copy$2(a)
     {var l=a.length - 1,result=caml_floatarray_create(l);
      unsafe_blit(a,0,result,0,l);
      return result}
    function fill$1(a,ofs,len,v)
     {check(a,ofs,len,cst_Float_Array_fill);return unsafe_fill(a,ofs,len,v)}
    function blit$2(src,sofs,dst,dofs,len)
     {check(src,sofs,len,cst_Float_array_blit);
      check(dst,dofs,len,cst_Float_array_blit$0);
      return unsafe_blit(src,sofs,dst,dofs,len)}
    function to_list$2(a)
     {return init(a.length - 1,function(_wP_){return a[1 + _wP_]})}
    function of_list$0(l)
     {var result=caml_floatarray_create(length(l)),i=0,l$0=l;
      for(;;)
       {if(l$0)
         {var t=l$0[2],h=l$0[1];
          result[1 + i] = h;
          var i$0=i + 1 | 0,i=i$0,l$0=t;
          continue}
        return result}}
    function iter$6(f,a)
     {var _wN_=a.length - 1 - 1 | 0,_wM_=0;
      if(! (_wN_ < 0))
       {var i=_wM_;
        for(;;)
         {caml_call1(f,a[1 + i]);
          var _wO_=i + 1 | 0;
          if(_wN_ !== i){var i=_wO_;continue}
          break}}
      return 0}
    function iter2$1(f,a,b)
     {if(a.length - 1 !== b.length - 1)
       return invalid_arg(cst_Float_Array_iter2_arrays_m);
      var _wK_=a.length - 1 - 1 | 0,_wJ_=0;
      if(! (_wK_ < 0))
       {var i=_wJ_;
        for(;;)
         {caml_call2(f,a[1 + i],b[1 + i]);
          var _wL_=i + 1 | 0;
          if(_wK_ !== i){var i=_wL_;continue}
          break}}
      return 0}
    function map$6(f,a)
     {var l=a.length - 1,r=caml_floatarray_create(l),_wH_=l - 1 | 0,_wG_=0;
      if(! (_wH_ < 0))
       {var i=_wG_;
        for(;;)
         {r[1 + i] = caml_call1(f,a[1 + i]);
          var _wI_=i + 1 | 0;
          if(_wH_ !== i){var i=_wI_;continue}
          break}}
      return r}
    function map2$1(f,a,b)
     {var la=a.length - 1,lb=b.length - 1;
      if(la !== lb)return invalid_arg(cst_Float_Array_map2_arrays_mu);
      var r=caml_floatarray_create(la),_wE_=la - 1 | 0,_wD_=0;
      if(! (_wE_ < 0))
       {var i=_wD_;
        for(;;)
         {r[1 + i] = caml_call2(f,a[1 + i],b[1 + i]);
          var _wF_=i + 1 | 0;
          if(_wE_ !== i){var i=_wF_;continue}
          break}}
      return r}
    function iteri$3(f,a)
     {var _wB_=a.length - 1 - 1 | 0,_wA_=0;
      if(! (_wB_ < 0))
       {var i=_wA_;
        for(;;)
         {caml_call2(f,i,a[1 + i]);
          var _wC_=i + 1 | 0;
          if(_wB_ !== i){var i=_wC_;continue}
          break}}
      return 0}
    function mapi$3(f,a)
     {var l=a.length - 1,r=caml_floatarray_create(l),_wy_=l - 1 | 0,_wx_=0;
      if(! (_wy_ < 0))
       {var i=_wx_;
        for(;;)
         {r[1 + i] = caml_call2(f,i,a[1 + i]);
          var _wz_=i + 1 | 0;
          if(_wy_ !== i){var i=_wz_;continue}
          break}}
      return r}
    function fold_left$2(f,x,a)
     {var r=[0,x],_wv_=a.length - 1 - 1 | 0,_wu_=0;
      if(! (_wv_ < 0))
       {var i=_wu_;
        for(;;)
         {r[1] = caml_call2(f,r[1],a[1 + i]);
          var _ww_=i + 1 | 0;
          if(_wv_ !== i){var i=_ww_;continue}
          break}}
      return r[1]}
    function fold_right$1(f,a,x)
     {var r=[0,x],_ws_=a.length - 1 - 1 | 0;
      if(! (_ws_ < 0))
       {var i=_ws_;
        for(;;)
         {r[1] = caml_call2(f,a[1 + i],r[1]);
          var _wt_=i - 1 | 0;
          if(0 !== i){var i=_wt_;continue}
          break}}
      return r[1]}
    function exists$1(p,a)
     {var n=a.length - 1,i=0;
      for(;;)
       {if(i === n)return 0;
        if(caml_call1(p,a[1 + i]))return 1;
        var i$0=i + 1 | 0,i=i$0;
        continue}}
    function for_all$1(p,a)
     {var n=a.length - 1,i=0;
      for(;;)
       {if(i === n)return 1;
        if(caml_call1(p,a[1 + i])){var i$0=i + 1 | 0,i=i$0;continue}
        return 0}}
    function mem$1(x,a)
     {var n=a.length - 1,i=0;
      for(;;)
       {if(i === n)return 0;
        if(0 === caml_float_compare(a[1 + i],x))return 1;
        var i$0=i + 1 | 0,i=i$0;
        continue}}
    function mem_ieee(x,a)
     {var n=a.length - 1,i=0;
      for(;;)
       {if(i === n)return 0;
        if(x == a[1 + i])return 1;
        var i$0=i + 1 | 0,i=i$0;
        continue}}
    var Bottom$0=[248,cst_Stdlib_Float_Array_Bottom,caml_fresh_oo_id(0)];
    function sort$0(cmp,a)
     {function maxson(l,i)
       {var i31=((i + i | 0) + i | 0) + 1 | 0,x=[0,i31];
        if((i31 + 2 | 0) < l)
         {if
           (caml_call2
             (cmp,caml_array_get(a,i31),caml_array_get(a,i31 + 1 | 0))
            <
            0)
           x[1] = i31 + 1 | 0;
          if
           (caml_call2
             (cmp,caml_array_get(a,x[1]),caml_array_get(a,i31 + 2 | 0))
            <
            0)
           x[1] = i31 + 2 | 0;
          return x[1]}
        if
         ((i31 + 1 | 0)
          <
          l
          &&
          !
          (0
           <=
           caml_call2(cmp,caml_array_get(a,i31),caml_array_get(a,i31 + 1 | 0))))
         return i31 + 1 | 0;
        if(i31 < l)return i31;
        throw [0,Bottom$0,i]}
      function trickledown(l,i,e)
       {var i$0=i;
        for(;;)
         {var j=maxson(l,i$0);
          if(0 < caml_call2(cmp,caml_array_get(a,j),e))
           {caml_array_set(a,i$0,caml_array_get(a,j));var i$0=j;continue}
          return caml_array_set(a,i$0,e)}}
      function trickle(l,i,e)
       {try
         {var _wr_=trickledown(l,i,e);return _wr_}
        catch(exn)
         {exn = caml_wrap_exception(exn);
          if(exn[1] === Bottom$0)
           {var i$0=exn[2];return caml_array_set(a,i$0,e)}
          throw exn}}
      function bubbledown(l,i)
       {var i$0=i;
        for(;;)
         {var i$1=maxson(l,i$0);
          caml_array_set(a,i$0,caml_array_get(a,i$1));
          var i$0=i$1;
          continue}}
      function bubble(l,i)
       {try
         {var _wq_=bubbledown(l,i);return _wq_}
        catch(exn)
         {exn = caml_wrap_exception(exn);
          if(exn[1] === Bottom$0){var i$0=exn[2];return i$0}
          throw exn}}
      var l=a.length - 1,_wk_=((l + 1 | 0) / 3 | 0) - 1 | 0;
      if(! (_wk_ < 0))
       {var i$2=_wk_;
        for(;;)
         {trickle(l,i$2,caml_array_get(a,i$2));
          var _wp_=i$2 - 1 | 0;
          if(0 !== i$2){var i$2=_wp_;continue}
          break}}
      var _wl_=l - 1 | 0;
      if(! (_wl_ < 2))
       {var i$0=_wl_;
        a:
        for(;;)
         {var e$0=caml_array_get(a,i$0);
          caml_array_set(a,i$0,caml_array_get(a,0));
          var i$1=bubble(i$0,0),i=i$1;
          for(;;)
           {var father=(i - 1 | 0) / 3 | 0;
            if(i === father)throw [0,Assert_failure,_u_];
            if(0 <= caml_call2(cmp,caml_array_get(a,father),e$0))
             caml_array_set(a,i,e$0);
            else
             {caml_array_set(a,i,caml_array_get(a,father));
              if(0 < father){var i=father;continue}
              caml_array_set(a,0,e$0)}
            var _wo_=i$0 - 1 | 0;
            if(2 !== i$0){var i$0=_wo_;continue a}
            break}
          break}}
      var _wm_=1 < l?1:0;
      if(_wm_)
       {var e=caml_array_get(a,1);
        caml_array_set(a,1,caml_array_get(a,0));
        var _wn_=caml_array_set(a,0,e)}
      else
       var _wn_=_wm_;
      return _wn_}
    function stable_sort(cmp,a)
     {function merge(src1ofs,src1len,src2,src2ofs,src2len,dst,dstofs)
       {var
         src1r=src1ofs + src1len | 0,
         src2r=src2ofs + src2len | 0,
         s2$1=caml_array_get(src2,src2ofs),
         s1$1=caml_array_get(a,src1ofs),
         i1=src1ofs,
         s1=s1$1,
         i2=src2ofs,
         s2=s2$1,
         d=dstofs;
        for(;;)
         {if(0 < caml_call2(cmp,s1,s2))
           {caml_array_set(dst,d,s2);
            var i2$0=i2 + 1 | 0;
            if(i2$0 < src2r)
             {var
               d$0=d + 1 | 0,
               s2$0=caml_array_get(src2,i2$0),
               i2=i2$0,
               s2=s2$0,
               d=d$0;
              continue}
            return blit$2(a,i1,dst,d + 1 | 0,src1r - i1 | 0)}
          caml_array_set(dst,d,s1);
          var i1$0=i1 + 1 | 0;
          if(i1$0 < src1r)
           {var
             d$1=d + 1 | 0,
             s1$0=caml_array_get(a,i1$0),
             i1=i1$0,
             s1=s1$0,
             d=d$1;
            continue}
          return blit$2(src2,i2,dst,d + 1 | 0,src2r - i2 | 0)}}
      function isortto(srcofs,dst,dstofs,len)
       {var _wi_=len - 1 | 0,_wh_=0;
        if(! (_wi_ < 0))
         {var i=_wh_;
          a:
          for(;;)
           {var
             e=caml_array_get(a,srcofs + i | 0),
             j=[0,(dstofs + i | 0) - 1 | 0];
            for(;;)
             {if
               (dstofs
                <=
                j[1]
                &&
                0
                <
                caml_call2(cmp,caml_array_get(dst,j[1]),e))
               {caml_array_set(dst,j[1] + 1 | 0,caml_array_get(dst,j[1]));
                j[1] += -1;
                continue}
              caml_array_set(dst,j[1] + 1 | 0,e);
              var _wj_=i + 1 | 0;
              if(_wi_ !== i){var i=_wj_;continue a}
              break}
            break}}
        return 0}
      function sortto(srcofs,dst,dstofs,len)
       {if(len <= 5)return isortto(srcofs,dst,dstofs,len);
        var l1=len / 2 | 0,l2=len - l1 | 0;
        sortto(srcofs + l1 | 0,dst,dstofs + l1 | 0,l2);
        sortto(srcofs,a,srcofs + l2 | 0,l1);
        return merge(srcofs + l2 | 0,l1,dst,dstofs + l1 | 0,l2,dst,dstofs)}
      var l=a.length - 1;
      if(l <= 5)return isortto(0,a,0,l);
      var l1=l / 2 | 0,l2=l - l1 | 0,t=caml_floatarray_create(l2);
      sortto(l1,t,0,l2);
      sortto(0,a,l2,l1);
      return merge(l2,l1,t,0,l2,a,0)}
    function to_seq$5(a)
     {function aux(i,param)
       {if(i < a.length - 1)
         {var x=a[1 + i],_wf_=i + 1 | 0;
          return [0,x,function(_wg_){return aux(_wf_,_wg_)}]}
        return 0}
      var _wd_=0;
      return function(_we_){return aux(_wd_,_we_)}}
    function to_seqi$2(a)
     {function aux(i,param)
       {if(i < a.length - 1)
         {var x=a[1 + i],_wb_=i + 1 | 0;
          return [0,[0,i,x],function(_wc_){return aux(_wb_,_wc_)}]}
        return 0}
      var _v$_=0;
      return function(_wa_){return aux(_v$_,_wa_)}}
    function of_seq$3(i$2)
     {var
       _v__=0,
       param$0=fold_left(function(acc,x){return [0,x,acc]},_v__,i$2),
       len=length(param$0),
       a=caml_floatarray_create(len),
       i$1=len - 1 | 0,
       i=i$1,
       param=param$0;
      for(;;)
       {if(param)
         {var tl=param[2],hd=param[1];
          a[1 + i] = hd;
          var i$0=i - 1 | 0,i=i$0,param=tl;
          continue}
        return a}}
    function map_to_array(f,a)
     {var l=a.length - 1;
      if(0 === l)return [0];
      var r=caml_make_vect(l,caml_call1(f,a[1])),_v8_=l - 1 | 0,_v7_=1;
      if(! (_v8_ < 1))
       {var i=_v7_;
        for(;;)
         {r[1 + i] = caml_call1(f,a[1 + i]);
          var _v9_=i + 1 | 0;
          if(_v8_ !== i){var i=_v9_;continue}
          break}}
      return r}
    function map_from_array(f,a)
     {var l=a.length - 1,r=caml_floatarray_create(l),_v5_=l - 1 | 0,_v4_=0;
      if(! (_v5_ < 0))
       {var i=_v4_;
        for(;;)
         {r[1 + i] = caml_call1(f,a[1 + i]);
          var _v6_=i + 1 | 0;
          if(_v5_ !== i){var i=_v6_;continue}
          break}}
      return r}
    var
     _v_=caml_floatarray_create,
     _w_=caml_array_set,
     _x_=caml_array_get,
     _y_=
      [0,
       function(_v3_){return _v3_.length - 1},
       _x_,
       _w_,
       make$1,
       _v_,
       init$3,
       append$1,
       concat$2,
       sub$2,
       copy$2,
       fill$1,
       blit$2,
       to_list$2,
       of_list$0,
       iter$6,
       iteri$3,
       map$6,
       mapi$3,
       fold_left$2,
       fold_right$1,
       iter2$1,
       map2$1,
       for_all$1,
       exists$1,
       mem$1,
       mem_ieee,
       sort$0,
       stable_sort,
       stable_sort,
       to_seq$5,
       to_seqi$2,
       of_seq$3,
       map_to_array,
       map_from_array],
     _z_=caml_floatarray_create,
     _A_=caml_array_set,
     _B_=caml_array_get,
     Stdlib_float=
      [0,
       zero,
       one,
       minus_one,
       succ$0,
       pred$0,
       infinity,
       neg_infinity,
       nan,
       pi,
       max_float,
       min_float,
       epsilon,
       is_finite,
       is_infinite,
       is_nan,
       is_integer,
       of_string_opt,
       to_string,
       caml_float_compare,
       equal$7,
       min$1,
       max$1,
       min_max,
       min_num,
       max_num,
       min_max_num,
       hash$0,
       [0,
        function(_v2_){return _v2_.length - 1},
        _B_,
        _A_,
        make$1,
        _z_,
        init$3,
        append$1,
        concat$2,
        sub$2,
        copy$2,
        fill$1,
        blit$2,
        to_list$2,
        of_list$0,
        iter$6,
        iteri$3,
        map$6,
        mapi$3,
        fold_left$2,
        fold_right$1,
        iter2$1,
        map2$1,
        for_all$1,
        exists$1,
        mem$1,
        mem_ieee,
        sort$0,
        stable_sort,
        stable_sort,
        to_seq$5,
        to_seqi$2,
        of_seq$3,
        map_to_array,
        map_from_array],
       _y_];
    caml_register_global(763,Stdlib_float,"Stdlib__float");
    var zero$0=0,one$0=1,minus_one$0=-1;
    function abs$0(x){return 0 <= x?x:- x | 0}
    var max_int$0=2147483647,min_int$0=-2147483648;
    function lognot(x){return x ^ -1}
    function equal$8(_v1_,_v0_){return _v1_ === _v0_?1:0}
    var compare$7=caml_int_compare;
    function to_string$3(x){return caml_string_of_jsbytes("" + x)}
    var
     Stdlib_int=
      [0,
       zero$0,
       one$0,
       minus_one$0,
       abs$0,
       max_int$0,
       min_int$0,
       lognot,
       equal$8,
       compare$7,
       to_string$3];
    caml_register_global(764,Stdlib_int,"Stdlib__int");
    var zero$1=0,one$1=1,minus_one$1=-1;
    function succ$1(n){return n + 1 | 0}
    function pred$1(n){return n - 1 | 0}
    function abs$1(n){return caml_greaterequal(n,0)?n:- n | 0}
    var min_int$1=-2147483648,max_int$1=2147483647;
    function lognot$0(n){return n ^ -1}
    function unsigned_to_int(n)
     {if
       (!
        (0 < caml_int_compare(0,n))
        &&
        !
        (0 < caml_int_compare(n,2147483647)))
       return [0,n];
      return 0}
    function to_string$4(n){return caml_format_int(cst_d,n)}
    function of_string_opt$0(s)
     {try
       {var _vY_=[0,caml_int_of_string(s)];return _vY_}
      catch(_vZ_)
       {_vZ_ = caml_wrap_exception(_vZ_);
        if(_vZ_[1] === Failure)return 0;
        throw _vZ_}}
    var compare$8=caml_int_compare;
    function equal$9(x,y){return 0 === caml_int_compare(x,y)?1:0}
    function unsigned_compare(n,m)
     {return caml_int_compare(n + 2147483648 | 0,m + 2147483648 | 0)}
    function unsigned_div(n,d)
     {if(caml_lessthan(d,0))return 0 <= unsigned_compare(n,d)?one$1:zero$1;
      var q=caml_div(n >>> 1 | 0,d) << 1,r=n - caml_mul(q,d) | 0;
      return 0 <= unsigned_compare(r,d)?q + 1 | 0:q}
    function unsigned_rem(n,d){return n - caml_mul(unsigned_div(n,d),d) | 0}
    var
     Stdlib_int32=
      [0,
       zero$1,
       one$1,
       minus_one$1,
       unsigned_div,
       unsigned_rem,
       succ$1,
       pred$1,
       abs$1,
       max_int$1,
       min_int$1,
       lognot$0,
       unsigned_to_int,
       of_string_opt$0,
       to_string$4,
       compare$8,
       unsigned_compare,
       equal$9];
    caml_register_global(765,Stdlib_int32,"Stdlib__int32");
    function succ$2(n){return caml_int64_add(n,_C_)}
    function pred$2(n){return caml_int64_sub(n,_D_)}
    function abs$2(n)
     {return caml_greaterequal(n,_E_)?n:runtime.caml_int64_neg(n)}
    function lognot$1(n){return runtime.caml_int64_xor(n,_F_)}
    var max_int$3=caml_int64_of_int32(2147483647);
    function unsigned_to_int$0(n)
     {if
       (!
        (0 < caml_int64_compare(zero$2,n))
        &&
        !
        (0 < caml_int64_compare(n,max_int$3)))
       return [0,runtime.caml_int64_to_int32(n)];
      return 0}
    function to_string$5(n){return caml_int64_format(cst_d$0,n)}
    function of_string_opt$1(s)
     {try
       {var _vW_=[0,caml_int64_of_string(s)];return _vW_}
      catch(_vX_)
       {_vX_ = caml_wrap_exception(_vX_);
        if(_vX_[1] === Failure)return 0;
        throw _vX_}}
    function compare$9(x,y){return caml_int64_compare(x,y)}
    function equal$10(x,y){return 0 === caml_int64_compare(x,y)?1:0}
    function unsigned_compare$0(n,m)
     {return caml_int64_compare
              (caml_int64_sub(n,min_int$2),caml_int64_sub(m,min_int$2))}
    function unsigned_div$0(n,d)
     {if(caml_lessthan(d,zero$2))
       return 0 <= unsigned_compare$0(n,d)?one$2:zero$2;
      var
       q=
        caml_int64_shift_left
         (runtime.caml_int64_div
           (runtime.caml_int64_shift_right_unsigned(n,1),d),
          1),
       r=caml_int64_sub(n,caml_int64_mul(q,d));
      return 0 <= unsigned_compare$0(r,d)?succ$2(q):q}
    function unsigned_rem$0(n,d)
     {return caml_int64_sub(n,caml_int64_mul(unsigned_div$0(n,d),d))}
    var
     Stdlib_int64=
      [0,
       zero$2,
       one$2,
       minus_one$2,
       unsigned_div$0,
       unsigned_rem$0,
       succ$2,
       pred$2,
       abs$2,
       max_int$2,
       min_int$2,
       lognot$1,
       unsigned_to_int$0,
       of_string_opt$1,
       to_string$5,
       compare$9,
       unsigned_compare$0,
       equal$10];
    caml_register_global(766,Stdlib_int64,"Stdlib__int64");
    var zero$3=0,one$3=1,minus_one$3=-1;
    function succ$3(n){return n + 1 | 0}
    function pred$3(n){return n - 1 | 0}
    function abs$3(n){return caml_greaterequal(n,0)?n:- n | 0}
    var min_int$3=-2147483648,max_int$4=2147483647;
    function lognot$2(n){return n ^ -1}
    function unsigned_to_int$1(n)
     {if
       (!
        (0 < caml_int_compare(0,n))
        &&
        !
        (0 < caml_int_compare(n,2147483647)))
       return [0,n];
      return 0}
    function to_string$6(n){return caml_format_int(cst_d$1,n)}
    function of_string_opt$2(s)
     {try
       {var _vU_=[0,caml_int_of_string(s)];return _vU_}
      catch(_vV_)
       {_vV_ = caml_wrap_exception(_vV_);
        if(_vV_[1] === Failure)return 0;
        throw _vV_}}
    var compare$10=caml_int_compare;
    function equal$11(x,y){return 0 === caml_int_compare(x,y)?1:0}
    function unsigned_compare$1(n,m)
     {return caml_int_compare(n + 2147483648 | 0,m + 2147483648 | 0)}
    function unsigned_div$1(n,d)
     {if(caml_lessthan(d,0))return 0 <= unsigned_compare$1(n,d)?one$3:zero$3;
      var q=caml_div(n >>> 1 | 0,d) << 1,r=n - caml_mul(q,d) | 0;
      return 0 <= unsigned_compare$1(r,d)?q + 1 | 0:q}
    function unsigned_rem$1(n,d)
     {return n - caml_mul(unsigned_div$1(n,d),d) | 0}
    var
     Stdlib_nativeint=
      [0,
       zero$3,
       one$3,
       minus_one$3,
       unsigned_div$1,
       unsigned_rem$1,
       succ$3,
       pred$3,
       abs$3,
       match$1,
       max_int$4,
       min_int$3,
       lognot$2,
       unsigned_to_int$1,
       of_string_opt$2,
       to_string$6,
       compare$10,
       unsigned_compare$1,
       equal$11];
    caml_register_global(767,Stdlib_nativeint,"Stdlib__nativeint");
    function engine(tbl,state,buf)
     {var
       result=runtime.caml_lex_engine(tbl,state,buf),
       _vR_=0 <= result?1:0,
       _vS_=_vR_?buf[12] !== dummy_pos?1:0:_vR_;
      if(_vS_)
       {buf[11] = buf[12];
        var _vT_=buf[12];
        buf[12] = [0,_vT_[1],_vT_[2],_vT_[3],buf[4] + buf[6] | 0]}
      return result}
    function new_engine(tbl,state,buf)
     {var
       result=runtime.caml_new_lex_engine(tbl,state,buf),
       _vO_=0 <= result?1:0,
       _vP_=_vO_?buf[12] !== dummy_pos?1:0:_vO_;
      if(_vP_)
       {buf[11] = buf[12];
        var _vQ_=buf[12];
        buf[12] = [0,_vQ_[1],_vQ_[2],_vQ_[3],buf[4] + buf[6] | 0]}
      return result}
    function from_function(opt,f)
     {if(opt)var sth=opt[1],with_positions=sth;else var with_positions=1;
      var
       _vA_=with_positions?zero_pos:dummy_pos,
       _vB_=with_positions?zero_pos:dummy_pos,
       aux_buffer=caml_create_bytes(512),
       _vC_=[0],
       _vD_=0,
       _vE_=0,
       _vF_=0,
       _vG_=0,
       _vH_=0,
       _vI_=0,
       _vJ_=0,
       _vK_=caml_create_bytes(1024);
      return [0,
              function(lexbuf)
               {var
                 read=
                  caml_call2(f,aux_buffer,caml_ml_bytes_length(aux_buffer)),
                 n=0 < read?read:(lexbuf[9] = 1,0);
                if(caml_ml_bytes_length(lexbuf[2]) < (lexbuf[3] + n | 0))
                 {if
                   (((lexbuf[3] - lexbuf[5] | 0) + n | 0)
                    <=
                    caml_ml_bytes_length(lexbuf[2]))
                   blit
                    (lexbuf[2],lexbuf[5],lexbuf[2],0,lexbuf[3] - lexbuf[5] | 0);
                  else
                   {var
                     newlen=
                      min
                       (2 * caml_ml_bytes_length(lexbuf[2]) | 0,max_string_length);
                    if(newlen < ((lexbuf[3] - lexbuf[5] | 0) + n | 0))
                     failwith(cst_Lexing_lex_refill_cannot_g);
                    var newbuf=caml_create_bytes(newlen);
                    blit(lexbuf[2],lexbuf[5],newbuf,0,lexbuf[3] - lexbuf[5] | 0);
                    lexbuf[2] = newbuf}
                  var s=lexbuf[5];
                  lexbuf[4] = lexbuf[4] + s | 0;
                  lexbuf[6] = lexbuf[6] - s | 0;
                  lexbuf[5] = 0;
                  lexbuf[7] = lexbuf[7] - s | 0;
                  lexbuf[3] = lexbuf[3] - s | 0;
                  var t=lexbuf[10],_vM_=t.length - 1 - 1 | 0,_vL_=0;
                  if(! (_vM_ < 0))
                   {var i=_vL_;
                    for(;;)
                     {var v=caml_check_bound(t,i)[1 + i];
                      if(0 <= v)caml_check_bound(t,i)[1 + i] = v - s | 0;
                      var _vN_=i + 1 | 0;
                      if(_vM_ !== i){var i=_vN_;continue}
                      break}}}
                blit(aux_buffer,0,lexbuf[2],lexbuf[3],n);
                lexbuf[3] = lexbuf[3] + n | 0;
                return 0},
              _vK_,
              _vJ_,
              _vI_,
              _vH_,
              _vG_,
              _vF_,
              _vE_,
              _vD_,
              _vC_,
              _vB_,
              _vA_]}
    function from_channel(with_positions,ic)
     {return from_function
              (with_positions,function(buf,n){return input(ic,buf,0,n)})}
    function from_string$0(opt,s)
     {if(opt)var sth=opt[1],with_positions=sth;else var with_positions=1;
      var
       _vp_=with_positions?zero_pos:dummy_pos,
       _vq_=with_positions?zero_pos:dummy_pos,
       _vr_=[0],
       _vs_=1,
       _vt_=0,
       _vu_=0,
       _vv_=0,
       _vw_=0,
       _vx_=0,
       _vy_=caml_ml_string_length(s),
       _vz_=of_string(s);
      return [0,
              function(lexbuf){lexbuf[9] = 1;return 0},
              _vz_,
              _vy_,
              _vx_,
              _vw_,
              _vv_,
              _vu_,
              _vt_,
              _vs_,
              _vr_,
              _vq_,
              _vp_]}
    function with_positions(lexbuf){return lexbuf[12] !== dummy_pos?1:0}
    function lexeme(lexbuf)
     {var len=lexbuf[6] - lexbuf[5] | 0;
      return sub_string(lexbuf[2],lexbuf[5],len)}
    function sub_lexeme(lexbuf,i1,i2)
     {var len=i2 - i1 | 0;return sub_string(lexbuf[2],i1,len)}
    function sub_lexeme_opt(lexbuf,i1,i2)
     {if(0 <= i1){var len=i2 - i1 | 0;return [0,sub_string(lexbuf[2],i1,len)]}
      return 0}
    function sub_lexeme_char(lexbuf,i){return caml_bytes_get(lexbuf[2],i)}
    function sub_lexeme_char_opt(lexbuf,i)
     {return 0 <= i?[0,caml_bytes_get(lexbuf[2],i)]:0}
    function lexeme_char(lexbuf,i)
     {return caml_bytes_get(lexbuf[2],lexbuf[5] + i | 0)}
    function lexeme_start(lexbuf){return lexbuf[11][4]}
    function lexeme_end(lexbuf){return lexbuf[12][4]}
    function lexeme_start_p(lexbuf){return lexbuf[11]}
    function lexeme_end_p(lexbuf){return lexbuf[12]}
    function new_line(lexbuf)
     {var
       lcp=lexbuf[12],
       _vn_=lcp !== dummy_pos?1:0,
       _vo_=_vn_?(lexbuf[12] = [0,lcp[1],lcp[2] + 1 | 0,lcp[4],lcp[4]],0):_vn_;
      return _vo_}
    function flush_input(lb)
     {lb[6] = 0;
      lb[4] = 0;
      var lcp=lb[12];
      if(lcp !== dummy_pos)
       lb[12] = [0,lcp[1],zero_pos[2],zero_pos[3],zero_pos[4]];
      lb[3] = 0;
      return 0}
    var
     Stdlib_lexing=
      [0,
       dummy_pos,
       from_channel,
       from_string$0,
       from_function,
       with_positions,
       lexeme,
       lexeme_char,
       lexeme_start,
       lexeme_end,
       lexeme_start_p,
       lexeme_end_p,
       new_line,
       flush_input,
       sub_lexeme,
       sub_lexeme_opt,
       sub_lexeme_char,
       sub_lexeme_char_opt,
       engine,
       new_engine];
    caml_register_global(768,Stdlib_lexing,"Stdlib__lexing");
    var
     YYexit=[248,cst_Stdlib_Parsing_YYexit,caml_fresh_oo_id(0)],
     Parse_error=[248,cst_Stdlib_Parsing_Parse_error,caml_fresh_oo_id(0)],
     env=
      [0,
       caml_make_vect(100,0),
       caml_make_vect(100,0),
       caml_make_vect(100,dummy_pos),
       caml_make_vect(100,dummy_pos),
       100,
       0,
       0,
       0,
       dummy_pos,
       dummy_pos,
       0,
       0,
       0,
       0,
       0,
       0];
    function grow_stacks(param)
     {var
       oldsize=env[5],
       newsize=oldsize * 2 | 0,
       new_s=caml_make_vect(newsize,0),
       new_v=caml_make_vect(newsize,0),
       new_start=caml_make_vect(newsize,dummy_pos),
       new_end=caml_make_vect(newsize,dummy_pos);
      blit$1(env[1],0,new_s,0,oldsize);
      env[1] = new_s;
      blit$1(env[2],0,new_v,0,oldsize);
      env[2] = new_v;
      blit$1(env[3],0,new_start,0,oldsize);
      env[3] = new_start;
      blit$1(env[4],0,new_end,0,oldsize);
      env[4] = new_end;
      env[5] = newsize;
      return 0}
    function clear_parser(param)
     {fill$0(env[2],0,env[5],0);env[8] = 0;return 0}
    var current_lookahead_fun=[0,function(param){return 0}];
    function yyparse(tables,start,lexer,lexbuf)
     {var
       init_asp=env[11],
       init_sp=env[14],
       init_stackbase=env[6],
       init_state=env[15],
       init_curr_char=env[7],
       init_lval=env[8],
       init_errflag=env[16];
      env[6] = env[14] + 1 | 0;
      env[7] = start;
      env[10] = lexbuf[12];
      try
       {var cmd=0,arg=0;
        for(;;)
         {var match=runtime.caml_parse_engine(tables,env,cmd,arg);
          switch(match)
           {case 0:
             var arg$0=caml_call1(lexer,lexbuf);
             env[9] = lexbuf[11];
             env[10] = lexbuf[12];
             var cmd=1,arg=arg$0;
             continue;
            case 1:throw Parse_error;
            case 2:grow_stacks(0);var cmd=2,arg=0;continue;
            case 3:grow_stacks(0);var cmd=3,arg=0;continue;
            case 4:
             try
              {var
                _vh_=env[13],
                _vi_=
                 caml_call1(caml_check_bound(tables[1],_vh_)[1 + _vh_],env),
                _vj_=4,
                arg$1=_vi_,
                cmd$0=_vj_}
             catch(_vm_)
              {_vm_ = caml_wrap_exception(_vm_);
               if(_vm_ !== Parse_error)throw _vm_;
               var arg$1=0,cmd$0=5,_vk_=_vm_}
             var cmd=cmd$0,arg=arg$1;
             continue;
            default:
             caml_call1(tables[14],cst_syntax_error);var cmd=5,arg=0;continue}}}
      catch(exn)
       {exn = caml_wrap_exception(exn);
        var curr_char=env[7];
        env[11] = init_asp;
        env[14] = init_sp;
        env[6] = init_stackbase;
        env[15] = init_state;
        env[7] = init_curr_char;
        env[8] = init_lval;
        env[16] = init_errflag;
        if(exn[1] === YYexit){var v=exn[2];return v}
        current_lookahead_fun[1]
        =
        function(tok)
         {if(is_block(tok))
           {var _vl_=caml_obj_tag(tok);
            return caml_check_bound(tables[3],_vl_)[1 + _vl_] === curr_char
                    ?1
                    :0}
          return caml_check_bound(tables[2],tok)[1 + tok] === curr_char?1:0};
        throw exn}}
    function peek_val(env,n)
     {var _vg_=env[11] - n | 0;return caml_check_bound(env[2],_vg_)[1 + _vg_]}
    function symbol_start_pos(param)
     {var i=env[12];
      for(;;)
       {if(0 < i)
         {var
           _vd_=(env[11] - i | 0) + 1 | 0,
           st=caml_check_bound(env[3],_vd_)[1 + _vd_],
           _ve_=(env[11] - i | 0) + 1 | 0,
           en=caml_check_bound(env[4],_ve_)[1 + _ve_];
          if(caml_notequal(st,en))return st;
          var i$0=i - 1 | 0,i=i$0;
          continue}
        var _vf_=env[11];
        return caml_check_bound(env[4],_vf_)[1 + _vf_]}}
    function symbol_end_pos(param)
     {var _vc_=env[11];return caml_check_bound(env[4],_vc_)[1 + _vc_]}
    function rhs_start_pos(n)
     {var _vb_=env[11] - (env[12] - n | 0) | 0;
      return caml_check_bound(env[3],_vb_)[1 + _vb_]}
    function rhs_end_pos(n)
     {var _va_=env[11] - (env[12] - n | 0) | 0;
      return caml_check_bound(env[4],_va_)[1 + _va_]}
    function symbol_start(param){return symbol_start_pos(0)[4]}
    function symbol_end(param){return symbol_end_pos(0)[4]}
    function rhs_start(n){return rhs_start_pos(n)[4]}
    function rhs_end(n){return rhs_end_pos(n)[4]}
    function is_current_lookahead(tok)
     {return caml_call1(current_lookahead_fun[1],tok)}
    function parse_error(param){return 0}
    var
     Stdlib_parsing=
      [0,
       symbol_start,
       symbol_end,
       rhs_start,
       rhs_end,
       symbol_start_pos,
       symbol_end_pos,
       rhs_start_pos,
       rhs_end_pos,
       clear_parser,
       Parse_error,
       function(_u$_){return runtime.caml_set_parser_trace(_u$_)},
       YYexit,
       yyparse,
       peek_val,
       is_current_lookahead,
       parse_error];
    caml_register_global(769,Stdlib_parsing,"Stdlib__parsing");
    var
     Stdlib_set=
      [0,
       function(Ord)
        {function height(param){if(param){var h=param[4];return h}return 0}
         function create(l,v,r)
          {if(l)var h=l[4],hl=h;else var hl=0;
           if(r)var h$0=r[4],hr=h$0;else var hr=0;
           var _u__=hr <= hl?hl + 1 | 0:hr + 1 | 0;
           return [0,l,v,r,_u__]}
         function bal(l,v,r)
          {if(l)var h=l[4],hl=h;else var hl=0;
           if(r)var h$0=r[4],hr=h$0;else var hr=0;
           if((hr + 2 | 0) < hl)
            {if(l)
              {var lr=l[3],lv=l[2],ll=l[1],_u5_=height(lr);
               if(_u5_ <= height(ll))return create(ll,lv,create(lr,v,r));
               if(lr)
                {var lrr=lr[3],lrv=lr[2],lrl=lr[1],_u6_=create(lrr,v,r);
                 return create(create(ll,lv,lrl),lrv,_u6_)}
               return invalid_arg(cst_Set_bal)}
             return invalid_arg(cst_Set_bal$0)}
           if((hl + 2 | 0) < hr)
            {if(r)
              {var rr=r[3],rv=r[2],rl=r[1],_u7_=height(rl);
               if(_u7_ <= height(rr))return create(create(l,v,rl),rv,rr);
               if(rl)
                {var rlr=rl[3],rlv=rl[2],rll=rl[1],_u8_=create(rlr,rv,rr);
                 return create(create(l,v,rll),rlv,_u8_)}
               return invalid_arg(cst_Set_bal$1)}
             return invalid_arg(cst_Set_bal$2)}
           var _u9_=hr <= hl?hl + 1 | 0:hr + 1 | 0;
           return [0,l,v,r,_u9_]}
         function add(x,t)
          {if(t)
            {var r=t[3],v=t[2],l=t[1],c=caml_call2(Ord[1],x,v);
             if(0 === c)return t;
             if(0 <= c){var rr=add(x,r);return r === rr?t:bal(l,v,rr)}
             var ll=add(x,l);
             return l === ll?t:bal(ll,v,r)}
           return [0,0,x,0,1]}
         function singleton(x){return [0,0,x,0,1]}
         function add_min_element(x,param)
          {if(param)
            {var r=param[3],v=param[2],l=param[1];
             return bal(add_min_element(x,l),v,r)}
           return singleton(x)}
         function add_max_element(x,param)
          {if(param)
            {var r=param[3],v=param[2],l=param[1];
             return bal(l,v,add_max_element(x,r))}
           return singleton(x)}
         function join(l,v,r)
          {if(l)
            {if(r)
              {var
                rh=r[4],
                rr=r[3],
                rv=r[2],
                rl=r[1],
                lh=l[4],
                lr=l[3],
                lv=l[2],
                ll=l[1];
               return (rh + 2 | 0) < lh
                       ?bal(ll,lv,join(lr,v,r))
                       :(lh + 2 | 0) < rh?bal(join(l,v,rl),rv,rr):create(l,v,r)}
             return add_max_element(v,l)}
           return add_min_element(v,r)}
         function min_elt(param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var _u4_=param$0[1];
               if(_u4_){var param$0=_u4_;continue}
               var v=param$0[2];
               return v}
             throw Not_found}}
         function min_elt_opt(param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var _u3_=param$0[1];
               if(_u3_){var param$0=_u3_;continue}
               var v=param$0[2];
               return [0,v]}
             return 0}}
         function max_elt(param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {if(param$0[3]){var param$1=param$0[3],param$0=param$1;continue}
               var v=param$0[2];
               return v}
             throw Not_found}}
         function max_elt_opt(param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {if(param$0[3]){var param$1=param$0[3],param$0=param$1;continue}
               var v=param$0[2];
               return [0,v]}
             return 0}}
         function remove_min_elt(param)
          {if(param)
            {var _u2_=param[1];
             if(_u2_)
              {var r=param[3],v=param[2];return bal(remove_min_elt(_u2_),v,r)}
             var r$0=param[3];
             return r$0}
           return invalid_arg(cst_Set_remove_min_elt)}
         function concat(t,match)
          {if(t)
            {if(match)
              {var _u1_=remove_min_elt(match);
               return join(t,min_elt(match),_u1_)}
             return t}
           return match}
         function split(x,param)
          {if(param)
            {var r=param[3],v=param[2],l=param[1],c=caml_call2(Ord[1],x,v);
             if(0 === c)return [0,l,1,r];
             if(0 <= c)
              {var match=split(x,r),rr=match[3],pres=match[2],lr=match[1];
               return [0,join(l,v,lr),pres,rr]}
             var
              match$0=split(x,l),
              rl=match$0[3],
              pres$0=match$0[2],
              ll=match$0[1];
             return [0,ll,pres$0,join(rl,v,r)]}
           return _G_}
         var empty=0;
         function is_empty(param){return param?0:1}
         function mem(x,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[3],
                v=param$0[2],
                l=param$0[1],
                c=caml_call2(Ord[1],x,v),
                _u0_=0 === c?1:0;
               if(_u0_)return _u0_;
               var param$1=0 <= c?r:l,param$0=param$1;
               continue}
             return 0}}
         function remove(x,t)
          {if(t)
            {var r=t[3],v=t[2],l=t[1],c=caml_call2(Ord[1],x,v);
             if(0 === c)
              {if(l)
                {if(r)
                  {var _uZ_=remove_min_elt(r);return bal(l,min_elt(r),_uZ_)}
                 return l}
               return r}
             if(0 <= c){var rr=remove(x,r);return r === rr?t:bal(l,v,rr)}
             var ll=remove(x,l);
             return l === ll?t:bal(ll,v,r)}
           return 0}
         function union(t1,match)
          {if(t1)
            {if(match)
              {var
                h2=match[4],
                r2=match[3],
                v2=match[2],
                l2=match[1],
                h1=t1[4],
                r1=t1[3],
                v1=t1[2],
                l1=t1[1];
               if(h2 <= h1)
                {if(1 === h2)return add(v2,t1);
                 var
                  match$0=split(v1,match),
                  r2$0=match$0[3],
                  l2$0=match$0[1],
                  _uX_=union(r1,r2$0);
                 return join(union(l1,l2$0),v1,_uX_)}
               if(1 === h1)return add(v1,match);
               var
                match$1=split(v2,t1),
                r1$0=match$1[3],
                l1$0=match$1[1],
                _uY_=union(r1$0,r2);
               return join(union(l1$0,l2),v2,_uY_)}
             return t1}
           return match}
         function inter(s1,match)
          {if(s1)
            {if(match)
              {var
                r1=s1[3],
                v1=s1[2],
                l1=s1[1],
                _uT_=split(v1,match),
                _uU_=_uT_[1];
               if(_uT_[2])
                {var r2=_uT_[3],_uV_=inter(r1,r2);
                 return join(inter(l1,_uU_),v1,_uV_)}
               var r2$0=_uT_[3],_uW_=inter(r1,r2$0);
               return concat(inter(l1,_uU_),_uW_)}
             return 0}
           return 0}
         function split_bis(x,param)
          {if(param)
            {var r=param[3],v=param[2],l=param[1],c=caml_call2(Ord[1],x,v);
             if(0 === c)return 0;
             if(0 <= c)
              {var match=split_bis(x,r);
               if(match)
                {var rr=match[2],lr=match[1];return [0,join(l,v,lr),rr]}
               return 0}
             var match$0=split_bis(x,l);
             if(match$0)
              {var rl=match$0[2],ll=match$0[1];
               return [0,
                       ll,
                       function(param){return join(caml_call1(rl,0),v,r)}]}
             return 0}
           return [0,0,function(param){return 0}]}
         function disjoint(s1,s2)
          {var s1$0=s1,s2$0=s2;
           for(;;)
            {if(s1$0 && s2$0)
              {var r1=s1$0[3],v1=s1$0[2],l1=s1$0[1];
               if(s1$0 === s2$0)return 0;
               var match=split_bis(v1,s2$0);
               if(match)
                {var r2=match[2],l2=match[1],_uS_=disjoint(l1,l2);
                 if(_uS_)
                  {var s2$1=caml_call1(r2,0),s1$0=r1,s2$0=s2$1;continue}
                 return _uS_}
               return 0}
             return 1}}
         function diff(t1,match)
          {if(t1)
            {if(match)
              {var
                r1=t1[3],
                v1=t1[2],
                l1=t1[1],
                _uO_=split(v1,match),
                _uP_=_uO_[1];
               if(_uO_[2])
                {var r2=_uO_[3],_uQ_=diff(r1,r2);
                 return concat(diff(l1,_uP_),_uQ_)}
               var r2$0=_uO_[3],_uR_=diff(r1,r2$0);
               return join(diff(l1,_uP_),v1,_uR_)}
             return t1}
           return 0}
         function cons_enum(s,e)
          {var s$0=s,e$0=e;
           for(;;)
            {if(s$0)
              {var
                r=s$0[3],
                v=s$0[2],
                s$1=s$0[1],
                e$1=[0,v,r,e$0],
                s$0=s$1,
                e$0=e$1;
               continue}
             return e$0}}
         function compare(s1,s2)
          {var e2$2=cons_enum(s2,0),e1$2=cons_enum(s1,0),e1=e1$2,e2=e2$2;
           for(;;)
            {if(e1)
              {if(e2)
                {var
                  e2$0=e2[3],
                  r2=e2[2],
                  v2=e2[1],
                  e1$0=e1[3],
                  r1=e1[2],
                  v1=e1[1],
                  c=caml_call2(Ord[1],v1,v2);
                 if(0 === c)
                  {var
                    e2$1=cons_enum(r2,e2$0),
                    e1$1=cons_enum(r1,e1$0),
                    e1=e1$1,
                    e2=e2$1;
                   continue}
                 return c}
               return 1}
             return e2?-1:0}}
         function equal(s1,s2){return 0 === compare(s1,s2)?1:0}
         function subset(s1,s2)
          {var s1$0=s1,s2$0=s2;
           for(;;)
            {if(s1$0)
              {if(s2$0)
                {var
                  r2=s2$0[3],
                  v2=s2$0[2],
                  l2=s2$0[1],
                  r1=s1$0[3],
                  v1=s1$0[2],
                  l1=s1$0[1],
                  c=caml_call2(Ord[1],v1,v2);
                 if(0 === c)
                  {var _uL_=subset(l1,l2);
                   if(_uL_){var s1$0=r1,s2$0=r2;continue}
                   return _uL_}
                 if(0 <= c)
                  {var _uM_=subset([0,0,v1,r1,0],r2);
                   if(_uM_){var s1$0=l1;continue}
                   return _uM_}
                 var _uN_=subset([0,l1,v1,0,0],l2);
                 if(_uN_){var s1$0=r1;continue}
                 return _uN_}
               return 0}
             return 1}}
         function iter(f,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var r=param$0[3],v=param$0[2],l=param$0[1];
               iter(f,l);
               caml_call1(f,v);
               var param$0=r;
               continue}
             return 0}}
         function fold(f,s,accu)
          {var s$0=s,accu$0=accu;
           for(;;)
            {if(s$0)
              {var
                r=s$0[3],
                v=s$0[2],
                l=s$0[1],
                accu$1=caml_call2(f,v,fold(f,l,accu$0)),
                s$0=r,
                accu$0=accu$1;
               continue}
             return accu$0}}
         function for_all(p,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[3],
                v=param$0[2],
                l=param$0[1],
                _uI_=caml_call1(p,v);
               if(_uI_)
                {var _uJ_=for_all(p,l);
                 if(_uJ_){var param$0=r;continue}
                 var _uK_=_uJ_}
               else
                var _uK_=_uI_;
               return _uK_}
             return 1}}
         function exists(p,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[3],
                v=param$0[2],
                l=param$0[1],
                _uF_=caml_call1(p,v);
               if(_uF_)
                var _uG_=_uF_;
               else
                {var _uH_=exists(p,l);
                 if(! _uH_){var param$0=r;continue}
                 var _uG_=_uH_}
               return _uG_}
             return 0}}
         function filter(p,t)
          {if(t)
            {var
              r=t[3],
              v=t[2],
              l=t[1],
              l$0=filter(p,l),
              pv=caml_call1(p,v),
              r$0=filter(p,r);
             if(pv){if(l === l$0 && r === r$0)return t;return join(l$0,v,r$0)}
             return concat(l$0,r$0)}
           return 0}
         function partition(p,param)
          {if(param)
            {var
              r=param[3],
              v=param[2],
              l=param[1],
              match=partition(p,l),
              lf=match[2],
              lt=match[1],
              pv=caml_call1(p,v),
              match$0=partition(p,r),
              rf=match$0[2],
              rt=match$0[1];
             if(pv){var _uD_=concat(lf,rf);return [0,join(lt,v,rt),_uD_]}
             var _uE_=join(lf,v,rf);
             return [0,concat(lt,rt),_uE_]}
           return _H_}
         function cardinal(param)
          {if(param)
            {var r=param[3],l=param[1],_uC_=cardinal(r);
             return (cardinal(l) + 1 | 0) + _uC_ | 0}
           return 0}
         function elements_aux(accu,param)
          {var accu$0=accu,param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[3],
                v=param$0[2],
                l=param$0[1],
                accu$1=[0,v,elements_aux(accu$0,r)],
                accu$0=accu$1,
                param$0=l;
               continue}
             return accu$0}}
         function elements(s){return elements_aux(0,s)}
         function find(x,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[3],
                v=param$0[2],
                l=param$0[1],
                c=caml_call2(Ord[1],x,v);
               if(0 === c)return v;
               var param$1=0 <= c?r:l,param$0=param$1;
               continue}
             throw Not_found}}
         function find_first(f,param$0)
          {var param$1=param$0;
           for(;;)
            {if(param$1)
              {var r$0=param$1[3],v$0=param$1[2],l$0=param$1[1];
               if(caml_call1(f,v$0))
                {var v0=v$0,param=l$0;
                 for(;;)
                  {if(param)
                    {var r=param[3],v=param[2],l=param[1];
                     if(caml_call1(f,v)){var v0=v,param=l;continue}
                     var param=r;
                     continue}
                   return v0}}
               var param$1=r$0;
               continue}
             throw Not_found}}
         function find_first_opt(f,param$0)
          {var param$1=param$0;
           for(;;)
            {if(param$1)
              {var r$0=param$1[3],v$0=param$1[2],l$0=param$1[1];
               if(caml_call1(f,v$0))
                {var v0=v$0,param=l$0;
                 for(;;)
                  {if(param)
                    {var r=param[3],v=param[2],l=param[1];
                     if(caml_call1(f,v)){var v0=v,param=l;continue}
                     var param=r;
                     continue}
                   return [0,v0]}}
               var param$1=r$0;
               continue}
             return 0}}
         function find_last(f,param$0)
          {var param$1=param$0;
           for(;;)
            {if(param$1)
              {var r$0=param$1[3],v$0=param$1[2],l$0=param$1[1];
               if(caml_call1(f,v$0))
                {var v0=v$0,param=r$0;
                 for(;;)
                  {if(param)
                    {var r=param[3],v=param[2],l=param[1];
                     if(caml_call1(f,v)){var v0=v,param=r;continue}
                     var param=l;
                     continue}
                   return v0}}
               var param$1=l$0;
               continue}
             throw Not_found}}
         function find_last_opt(f,param$0)
          {var param$1=param$0;
           for(;;)
            {if(param$1)
              {var r$0=param$1[3],v$0=param$1[2],l$0=param$1[1];
               if(caml_call1(f,v$0))
                {var v0=v$0,param=r$0;
                 for(;;)
                  {if(param)
                    {var r=param[3],v=param[2],l=param[1];
                     if(caml_call1(f,v)){var v0=v,param=r;continue}
                     var param=l;
                     continue}
                   return [0,v0]}}
               var param$1=l$0;
               continue}
             return 0}}
         function find_opt(x,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[3],
                v=param$0[2],
                l=param$0[1],
                c=caml_call2(Ord[1],x,v);
               if(0 === c)return [0,v];
               var param$1=0 <= c?r:l,param$0=param$1;
               continue}
             return 0}}
         function map(f,t)
          {if(t)
            {var
              r=t[3],
              v=t[2],
              l=t[1],
              l$0=map(f,l),
              v$0=caml_call1(f,v),
              r$0=map(f,r);
             if(l === l$0 && v === v$0 && r === r$0)return t;
             var switch$0=0;
             if(0 !== l$0)
              {var _uB_=max_elt(l$0);
               if(0 <= caml_call2(Ord[1],_uB_,v$0))switch$0 = 1}
             if(! switch$0)
              {var switch$1=0;
               if(0 !== r$0)
                {var _uA_=min_elt(r$0);
                 if(0 <= caml_call2(Ord[1],v$0,_uA_))switch$1 = 1}
               if(! switch$1)return join(l$0,v$0,r$0)}
             return union(l$0,add(v$0,r$0))}
           return 0}
         function of_list(l)
          {if(l)
            {var _up_=l[2],_uq_=l[1];
             if(_up_)
              {var _ur_=_up_[2],_us_=_up_[1];
               if(_ur_)
                {var _ut_=_ur_[2],_uu_=_ur_[1];
                 if(_ut_)
                  {var _uv_=_ut_[2],_uw_=_ut_[1];
                   if(_uv_)
                    {if(_uv_[2])
                      {var
                        l$0=sort_uniq(Ord[1],l),
                        sub=
                         function(n,l)
                          {if(! (3 < n >>> 0))
                            switch(n)
                             {case 0:return [0,0,l];
                              case 1:
                               if(l){var l$3=l[2],x0=l[1];return [0,[0,0,x0,0,1],l$3]}
                               break;
                              case 2:
                               if(l)
                                {var _ux_=l[2];
                                 if(_ux_)
                                  {var l$4=_ux_[2],x1=_ux_[1],x0$0=l[1];
                                   return [0,[0,[0,0,x0$0,0,1],x1,0,2],l$4]}}
                               break;
                              default:
                               if(l)
                                {var _uy_=l[2];
                                 if(_uy_)
                                  {var _uz_=_uy_[2];
                                   if(_uz_)
                                    {var l$5=_uz_[2],x2=_uz_[1],x1$0=_uy_[1],x0$1=l[1];
                                     return [0,[0,[0,0,x0$1,0,1],x1$0,[0,0,x2,0,1],2],l$5]}}}}
                           var nl=n / 2 | 0,match=sub(nl,l),l$0=match[2],left=match[1];
                           if(l$0)
                            {var
                              l$1=l$0[2],
                              mid=l$0[1],
                              match$0=sub((n - nl | 0) - 1 | 0,l$1),
                              l$2=match$0[2],
                              right=match$0[1];
                             return [0,create(left,mid,right),l$2]}
                           throw [0,Assert_failure,_I_]};
                       return sub(length(l$0),l$0)[1]}
                     var x4=_uv_[1];
                     return add(x4,add(_uw_,add(_uu_,add(_us_,singleton(_uq_)))))}
                   return add(_uw_,add(_uu_,add(_us_,singleton(_uq_))))}
                 return add(_uu_,add(_us_,singleton(_uq_)))}
               return add(_us_,singleton(_uq_))}
             return singleton(_uq_)}
           return empty}
         function add_seq(i,m)
          {return fold_left(function(s,x){return add(x,s)},m,i)}
         function of_seq(i){return add_seq(i,empty)}
         function seq_of_enum(c,param)
          {if(c)
            {var rest=c[3],t=c[2],x=c[1],_un_=cons_enum(t,rest);
             return [0,x,function(_uo_){return seq_of_enum(_un_,_uo_)}]}
           return 0}
         function to_seq(c)
          {var _ul_=cons_enum(c,0);
           return function(_um_){return seq_of_enum(_ul_,_um_)}}
         function to_seq_from(low,s)
          {var s$0=s,c=0;
           for(;;)
            {if(s$0)
              {var r=s$0[3],v=s$0[2],l=s$0[1],n=caml_call2(Ord[1],v,low);
               if(0 !== n)
                {if(0 <= n){var c$0=[0,v,r,c],s$0=l,c=c$0;continue}
                 var s$0=r;
                 continue}
               var _uj_=[0,v,r,c]}
             else
              var _uj_=c;
             return function(_uk_){return seq_of_enum(_uj_,_uk_)}}}
         return [0,
                 empty,
                 is_empty,
                 mem,
                 add,
                 singleton,
                 remove,
                 union,
                 inter,
                 disjoint,
                 diff,
                 compare,
                 equal,
                 subset,
                 iter,
                 map,
                 fold,
                 for_all,
                 exists,
                 filter,
                 partition,
                 cardinal,
                 elements,
                 min_elt,
                 min_elt_opt,
                 max_elt,
                 max_elt_opt,
                 min_elt,
                 min_elt_opt,
                 split,
                 find,
                 find_opt,
                 find_first,
                 find_first_opt,
                 find_last,
                 find_last_opt,
                 of_list,
                 to_seq_from,
                 to_seq,
                 add_seq,
                 of_seq]}];
    caml_register_global(770,Stdlib_set,"Stdlib__set");
    var
     Stdlib_map=
      [0,
       function(Ord)
        {function height(param){if(param){var h=param[5];return h}return 0}
         function create(l,x,d,r)
          {var hl=height(l),hr=height(r),_ui_=hr <= hl?hl + 1 | 0:hr + 1 | 0;
           return [0,l,x,d,r,_ui_]}
         function singleton(x,d){return [0,0,x,d,0,1]}
         function bal(l,x,d,r)
          {if(l)var h=l[5],hl=h;else var hl=0;
           if(r)var h$0=r[5],hr=h$0;else var hr=0;
           if((hr + 2 | 0) < hl)
            {if(l)
              {var lr=l[4],ld=l[3],lv=l[2],ll=l[1],_ud_=height(lr);
               if(_ud_ <= height(ll))return create(ll,lv,ld,create(lr,x,d,r));
               if(lr)
                {var
                  lrr=lr[4],
                  lrd=lr[3],
                  lrv=lr[2],
                  lrl=lr[1],
                  _ue_=create(lrr,x,d,r);
                 return create(create(ll,lv,ld,lrl),lrv,lrd,_ue_)}
               return invalid_arg(cst_Map_bal)}
             return invalid_arg(cst_Map_bal$0)}
           if((hl + 2 | 0) < hr)
            {if(r)
              {var rr=r[4],rd=r[3],rv=r[2],rl=r[1],_uf_=height(rl);
               if(_uf_ <= height(rr))return create(create(l,x,d,rl),rv,rd,rr);
               if(rl)
                {var
                  rlr=rl[4],
                  rld=rl[3],
                  rlv=rl[2],
                  rll=rl[1],
                  _ug_=create(rlr,rv,rd,rr);
                 return create(create(l,x,d,rll),rlv,rld,_ug_)}
               return invalid_arg(cst_Map_bal$1)}
             return invalid_arg(cst_Map_bal$2)}
           var _uh_=hr <= hl?hl + 1 | 0:hr + 1 | 0;
           return [0,l,x,d,r,_uh_]}
         var empty=0;
         function is_empty(param){return param?0:1}
         function add(x,data,m)
          {if(m)
            {var h=m[5],r=m[4],d=m[3],v=m[2],l=m[1],c=caml_call2(Ord[1],x,v);
             if(0 === c)return d === data?m:[0,l,x,data,r,h];
             if(0 <= c){var rr=add(x,data,r);return r === rr?m:bal(l,v,d,rr)}
             var ll=add(x,data,l);
             return l === ll?m:bal(ll,v,d,r)}
           return [0,0,x,data,0,1]}
         function find(x,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[4],
                d=param$0[3],
                v=param$0[2],
                l=param$0[1],
                c=caml_call2(Ord[1],x,v);
               if(0 === c)return d;
               var param$1=0 <= c?r:l,param$0=param$1;
               continue}
             throw Not_found}}
         function find_first(f,param$0)
          {var param$1=param$0;
           for(;;)
            {if(param$1)
              {var
                r$0=param$1[4],
                d$0=param$1[3],
                v$0=param$1[2],
                l$0=param$1[1];
               if(caml_call1(f,v$0))
                {var v0=v$0,d0=d$0,param=l$0;
                 for(;;)
                  {if(param)
                    {var r=param[4],d=param[3],v=param[2],l=param[1];
                     if(caml_call1(f,v)){var v0=v,d0=d,param=l;continue}
                     var param=r;
                     continue}
                   return [0,v0,d0]}}
               var param$1=r$0;
               continue}
             throw Not_found}}
         function find_first_opt(f,param$0)
          {var param$1=param$0;
           for(;;)
            {if(param$1)
              {var
                r$0=param$1[4],
                d$0=param$1[3],
                v$0=param$1[2],
                l$0=param$1[1];
               if(caml_call1(f,v$0))
                {var v0=v$0,d0=d$0,param=l$0;
                 for(;;)
                  {if(param)
                    {var r=param[4],d=param[3],v=param[2],l=param[1];
                     if(caml_call1(f,v)){var v0=v,d0=d,param=l;continue}
                     var param=r;
                     continue}
                   return [0,[0,v0,d0]]}}
               var param$1=r$0;
               continue}
             return 0}}
         function find_last(f,param$0)
          {var param$1=param$0;
           for(;;)
            {if(param$1)
              {var
                r$0=param$1[4],
                d$0=param$1[3],
                v$0=param$1[2],
                l$0=param$1[1];
               if(caml_call1(f,v$0))
                {var v0=v$0,d0=d$0,param=r$0;
                 for(;;)
                  {if(param)
                    {var r=param[4],d=param[3],v=param[2],l=param[1];
                     if(caml_call1(f,v)){var v0=v,d0=d,param=r;continue}
                     var param=l;
                     continue}
                   return [0,v0,d0]}}
               var param$1=l$0;
               continue}
             throw Not_found}}
         function find_last_opt(f,param$0)
          {var param$1=param$0;
           for(;;)
            {if(param$1)
              {var
                r$0=param$1[4],
                d$0=param$1[3],
                v$0=param$1[2],
                l$0=param$1[1];
               if(caml_call1(f,v$0))
                {var v0=v$0,d0=d$0,param=r$0;
                 for(;;)
                  {if(param)
                    {var r=param[4],d=param[3],v=param[2],l=param[1];
                     if(caml_call1(f,v)){var v0=v,d0=d,param=r;continue}
                     var param=l;
                     continue}
                   return [0,[0,v0,d0]]}}
               var param$1=l$0;
               continue}
             return 0}}
         function find_opt(x,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[4],
                d=param$0[3],
                v=param$0[2],
                l=param$0[1],
                c=caml_call2(Ord[1],x,v);
               if(0 === c)return [0,d];
               var param$1=0 <= c?r:l,param$0=param$1;
               continue}
             return 0}}
         function mem(x,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[4],
                v=param$0[2],
                l=param$0[1],
                c=caml_call2(Ord[1],x,v),
                _uc_=0 === c?1:0;
               if(_uc_)return _uc_;
               var param$1=0 <= c?r:l,param$0=param$1;
               continue}
             return 0}}
         function min_binding(param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var _ub_=param$0[1];
               if(_ub_){var param$0=_ub_;continue}
               var d=param$0[3],v=param$0[2];
               return [0,v,d]}
             throw Not_found}}
         function min_binding_opt(param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var _ua_=param$0[1];
               if(_ua_){var param$0=_ua_;continue}
               var d=param$0[3],v=param$0[2];
               return [0,[0,v,d]]}
             return 0}}
         function max_binding(param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {if(param$0[4]){var param$1=param$0[4],param$0=param$1;continue}
               var d=param$0[3],v=param$0[2];
               return [0,v,d]}
             throw Not_found}}
         function max_binding_opt(param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {if(param$0[4]){var param$1=param$0[4],param$0=param$1;continue}
               var d=param$0[3],v=param$0[2];
               return [0,[0,v,d]]}
             return 0}}
         function remove_min_binding(param)
          {if(param)
            {var _t$_=param[1];
             if(_t$_)
              {var r=param[4],d=param[3],v=param[2];
               return bal(remove_min_binding(_t$_),v,d,r)}
             var r$0=param[4];
             return r$0}
           return invalid_arg(cst_Map_remove_min_elt)}
         function _tO_(t,match)
          {if(t)
            {if(match)
              {var match$0=min_binding(match),d=match$0[2],x=match$0[1];
               return bal(t,x,d,remove_min_binding(match))}
             return t}
           return match}
         function remove(x,m)
          {if(m)
            {var r=m[4],d=m[3],v=m[2],l=m[1],c=caml_call2(Ord[1],x,v);
             if(0 === c)return _tO_(l,r);
             if(0 <= c){var rr=remove(x,r);return r === rr?m:bal(l,v,d,rr)}
             var ll=remove(x,l);
             return l === ll?m:bal(ll,v,d,r)}
           return 0}
         function update(x,f,m)
          {if(m)
            {var h=m[5],r=m[4],d=m[3],v=m[2],l=m[1],c=caml_call2(Ord[1],x,v);
             if(0 === c)
              {var match=caml_call1(f,[0,d]);
               if(match)
                {var data=match[1];return d === data?m:[0,l,x,data,r,h]}
               return _tO_(l,r)}
             if(0 <= c){var rr=update(x,f,r);return r === rr?m:bal(l,v,d,rr)}
             var ll=update(x,f,l);
             return l === ll?m:bal(ll,v,d,r)}
           var match$0=caml_call1(f,0);
           if(match$0){var data$0=match$0[1];return [0,0,x,data$0,0,1]}
           return 0}
         function iter(f,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var r=param$0[4],d=param$0[3],v=param$0[2],l=param$0[1];
               iter(f,l);
               caml_call2(f,v,d);
               var param$0=r;
               continue}
             return 0}}
         function map(f,param)
          {if(param)
            {var
              h=param[5],
              r=param[4],
              d=param[3],
              v=param[2],
              l=param[1],
              l$0=map(f,l),
              d$0=caml_call1(f,d),
              r$0=map(f,r);
             return [0,l$0,v,d$0,r$0,h]}
           return 0}
         function mapi(f,param)
          {if(param)
            {var
              h=param[5],
              r=param[4],
              d=param[3],
              v=param[2],
              l=param[1],
              l$0=mapi(f,l),
              d$0=caml_call2(f,v,d),
              r$0=mapi(f,r);
             return [0,l$0,v,d$0,r$0,h]}
           return 0}
         function fold(f,m,accu)
          {var m$0=m,accu$0=accu;
           for(;;)
            {if(m$0)
              {var
                r=m$0[4],
                d=m$0[3],
                v=m$0[2],
                l=m$0[1],
                accu$1=caml_call3(f,v,d,fold(f,l,accu$0)),
                m$0=r,
                accu$0=accu$1;
               continue}
             return accu$0}}
         function for_all(p,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[4],
                d=param$0[3],
                v=param$0[2],
                l=param$0[1],
                _t8_=caml_call2(p,v,d);
               if(_t8_)
                {var _t9_=for_all(p,l);
                 if(_t9_){var param$0=r;continue}
                 var _t__=_t9_}
               else
                var _t__=_t8_;
               return _t__}
             return 1}}
         function exists(p,param)
          {var param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[4],
                d=param$0[3],
                v=param$0[2],
                l=param$0[1],
                _t5_=caml_call2(p,v,d);
               if(_t5_)
                var _t6_=_t5_;
               else
                {var _t7_=exists(p,l);
                 if(! _t7_){var param$0=r;continue}
                 var _t6_=_t7_}
               return _t6_}
             return 0}}
         function add_min_binding(k,x,param)
          {if(param)
            {var r=param[4],d=param[3],v=param[2],l=param[1];
             return bal(add_min_binding(k,x,l),v,d,r)}
           return singleton(k,x)}
         function add_max_binding(k,x,param)
          {if(param)
            {var r=param[4],d=param[3],v=param[2],l=param[1];
             return bal(l,v,d,add_max_binding(k,x,r))}
           return singleton(k,x)}
         function join(l,v,d,r)
          {if(l)
            {if(r)
              {var
                rh=r[5],
                rr=r[4],
                rd=r[3],
                rv=r[2],
                rl=r[1],
                lh=l[5],
                lr=l[4],
                ld=l[3],
                lv=l[2],
                ll=l[1];
               return (rh + 2 | 0) < lh
                       ?bal(ll,lv,ld,join(lr,v,d,r))
                       :(lh + 2 | 0) < rh
                         ?bal(join(l,v,d,rl),rv,rd,rr)
                         :create(l,v,d,r)}
             return add_max_binding(v,d,l)}
           return add_min_binding(v,d,r)}
         function concat(t,match)
          {if(t)
            {if(match)
              {var match$0=min_binding(match),d=match$0[2],x=match$0[1];
               return join(t,x,d,remove_min_binding(match))}
             return t}
           return match}
         function concat_or_join(t1,v,d,t2)
          {if(d){var d$0=d[1];return join(t1,v,d$0,t2)}return concat(t1,t2)}
         function split(x,param)
          {if(param)
            {var
              r=param[4],
              d=param[3],
              v=param[2],
              l=param[1],
              c=caml_call2(Ord[1],x,v);
             if(0 === c)return [0,l,[0,d],r];
             if(0 <= c)
              {var match=split(x,r),rr=match[3],pres=match[2],lr=match[1];
               return [0,join(l,v,d,lr),pres,rr]}
             var
              match$0=split(x,l),
              rl=match$0[3],
              pres$0=match$0[2],
              ll=match$0[1];
             return [0,ll,pres$0,join(rl,v,d,r)]}
           return _J_}
         function merge(f,s1,s2)
          {if(s1)
            {var h1=s1[5],r1=s1[4],d1=s1[3],v1=s1[2],l1=s1[1];
             if(height(s2) <= h1)
              {var
                match=split(v1,s2),
                r2=match[3],
                d2=match[2],
                l2=match[1],
                _t1_=merge(f,r1,r2),
                _t2_=caml_call3(f,v1,[0,d1],d2);
               return concat_or_join(merge(f,l1,l2),v1,_t2_,_t1_)}}
           else
            if(! s2)return 0;
           if(s2)
            {var
              r2$0=s2[4],
              d2$0=s2[3],
              v2=s2[2],
              l2$0=s2[1],
              match$0=split(v2,s1),
              r1$0=match$0[3],
              d1$0=match$0[2],
              l1$0=match$0[1],
              _t3_=merge(f,r1$0,r2$0),
              _t4_=caml_call3(f,v2,d1$0,[0,d2$0]);
             return concat_or_join(merge(f,l1$0,l2$0),v2,_t4_,_t3_)}
           throw [0,Assert_failure,_K_]}
         function union(f,s1,s2)
          {if(s1)
            {if(s2)
              {var
                h2=s2[5],
                r2=s2[4],
                d2=s2[3],
                v2=s2[2],
                l2=s2[1],
                h1=s1[5],
                r1=s1[4],
                d1=s1[3],
                v1=s1[2],
                l1=s1[1];
               if(h2 <= h1)
                {var
                  match=split(v1,s2),
                  r2$0=match[3],
                  d2$0=match[2],
                  l2$0=match[1],
                  l=union(f,l1,l2$0),
                  r=union(f,r1,r2$0);
                 if(d2$0)
                  {var d2$1=d2$0[1];
                   return concat_or_join(l,v1,caml_call3(f,v1,d1,d2$1),r)}
                 return join(l,v1,d1,r)}
               var
                match$0=split(v2,s1),
                r1$0=match$0[3],
                d1$0=match$0[2],
                l1$0=match$0[1],
                l$0=union(f,l1$0,l2),
                r$0=union(f,r1$0,r2);
               if(d1$0)
                {var d1$1=d1$0[1];
                 return concat_or_join(l$0,v2,caml_call3(f,v2,d1$1,d2),r$0)}
               return join(l$0,v2,d2,r$0)}
             var s=s1}
           else
            var s=s2;
           return s}
         function filter(p,m)
          {if(m)
            {var
              r=m[4],
              d=m[3],
              v=m[2],
              l=m[1],
              l$0=filter(p,l),
              pvd=caml_call2(p,v,d),
              r$0=filter(p,r);
             if(pvd)
              {if(l === l$0 && r === r$0)return m;return join(l$0,v,d,r$0)}
             return concat(l$0,r$0)}
           return 0}
         function partition(p,param)
          {if(param)
            {var
              r=param[4],
              d=param[3],
              v=param[2],
              l=param[1],
              match=partition(p,l),
              lf=match[2],
              lt=match[1],
              pvd=caml_call2(p,v,d),
              match$0=partition(p,r),
              rf=match$0[2],
              rt=match$0[1];
             if(pvd){var _tZ_=concat(lf,rf);return [0,join(lt,v,d,rt),_tZ_]}
             var _t0_=join(lf,v,d,rf);
             return [0,concat(lt,rt),_t0_]}
           return _L_}
         function cons_enum(m,e)
          {var m$0=m,e$0=e;
           for(;;)
            {if(m$0)
              {var
                r=m$0[4],
                d=m$0[3],
                v=m$0[2],
                m$1=m$0[1],
                e$1=[0,v,d,r,e$0],
                m$0=m$1,
                e$0=e$1;
               continue}
             return e$0}}
         function compare(cmp,m1,m2)
          {var e2$2=cons_enum(m2,0),e1$2=cons_enum(m1,0),e1=e1$2,e2=e2$2;
           for(;;)
            {if(e1)
              {if(e2)
                {var
                  e2$0=e2[4],
                  r2=e2[3],
                  d2=e2[2],
                  v2=e2[1],
                  e1$0=e1[4],
                  r1=e1[3],
                  d1=e1[2],
                  v1=e1[1],
                  c=caml_call2(Ord[1],v1,v2);
                 if(0 === c)
                  {var c$0=caml_call2(cmp,d1,d2);
                   if(0 === c$0)
                    {var
                      e2$1=cons_enum(r2,e2$0),
                      e1$1=cons_enum(r1,e1$0),
                      e1=e1$1,
                      e2=e2$1;
                     continue}
                   return c$0}
                 return c}
               return 1}
             return e2?-1:0}}
         function equal(cmp,m1,m2)
          {var e2$2=cons_enum(m2,0),e1$2=cons_enum(m1,0),e1=e1$2,e2=e2$2;
           for(;;)
            {if(e1)
              {if(e2)
                {var
                  e2$0=e2[4],
                  r2=e2[3],
                  d2=e2[2],
                  v2=e2[1],
                  e1$0=e1[4],
                  r1=e1[3],
                  d1=e1[2],
                  v1=e1[1],
                  _tW_=0 === caml_call2(Ord[1],v1,v2)?1:0;
                 if(_tW_)
                  {var _tX_=caml_call2(cmp,d1,d2);
                   if(_tX_)
                    {var
                      e2$1=cons_enum(r2,e2$0),
                      e1$1=cons_enum(r1,e1$0),
                      e1=e1$1,
                      e2=e2$1;
                     continue}
                   var _tY_=_tX_}
                 else
                  var _tY_=_tW_;
                 return _tY_}
               return 0}
             return e2?0:1}}
         function cardinal(param)
          {if(param)
            {var r=param[4],l=param[1],_tV_=cardinal(r);
             return (cardinal(l) + 1 | 0) + _tV_ | 0}
           return 0}
         function bindings_aux(accu,param)
          {var accu$0=accu,param$0=param;
           for(;;)
            {if(param$0)
              {var
                r=param$0[4],
                d=param$0[3],
                v=param$0[2],
                l=param$0[1],
                accu$1=[0,[0,v,d],bindings_aux(accu$0,r)],
                accu$0=accu$1,
                param$0=l;
               continue}
             return accu$0}}
         function bindings(s){return bindings_aux(0,s)}
         function add_seq(i,m)
          {return fold_left
                   (function(m,param)
                     {var v=param[2],k=param[1];return add(k,v,m)},
                    m,
                    i)}
         function of_seq(i){return add_seq(i,empty)}
         function seq_of_enum(c,param)
          {if(c)
            {var rest=c[4],t=c[3],v=c[2],k=c[1],_tT_=cons_enum(t,rest);
             return [0,[0,k,v],function(_tU_){return seq_of_enum(_tT_,_tU_)}]}
           return 0}
         function to_seq(m)
          {var _tR_=cons_enum(m,0);
           return function(_tS_){return seq_of_enum(_tR_,_tS_)}}
         function to_seq_from(low,m)
          {var m$0=m,c=0;
           for(;;)
            {if(m$0)
              {var
                r=m$0[4],
                d=m$0[3],
                v=m$0[2],
                l=m$0[1],
                n=caml_call2(Ord[1],v,low);
               if(0 !== n)
                {if(0 <= n){var c$0=[0,v,d,r,c],m$0=l,c=c$0;continue}
                 var m$0=r;
                 continue}
               var _tP_=[0,v,d,r,c]}
             else
              var _tP_=c;
             return function(_tQ_){return seq_of_enum(_tP_,_tQ_)}}}
         return [0,
                 empty,
                 is_empty,
                 mem,
                 add,
                 update,
                 singleton,
                 remove,
                 merge,
                 union,
                 compare,
                 equal,
                 iter,
                 fold,
                 for_all,
                 exists,
                 filter,
                 partition,
                 cardinal,
                 bindings,
                 min_binding,
                 min_binding_opt,
                 max_binding,
                 max_binding_opt,
                 min_binding,
                 min_binding_opt,
                 split,
                 find,
                 find_opt,
                 find_first,
                 find_first_opt,
                 find_last,
                 find_last_opt,
                 map,
                 mapi,
                 to_seq,
                 to_seq_from,
                 add_seq,
                 of_seq]}];
    caml_register_global(771,Stdlib_map,"Stdlib__map");
    var Empty=[248,cst_Stdlib_Stack_Empty,caml_fresh_oo_id(0)];
    function create$0(param){return [0,0,0]}
    function clear(s){s[1] = 0;s[2] = 0;return 0}
    function copy$3(s){return [0,s[1],s[2]]}
    function push(x,s){s[1] = [0,x,s[1]];s[2] = s[2] + 1 | 0;return 0}
    function pop(s)
     {var _tN_=s[1];
      if(_tN_)
       {var tl=_tN_[2],hd=_tN_[1];s[1] = tl;s[2] = s[2] - 1 | 0;return hd}
      throw Empty}
    function pop_opt(s)
     {var _tM_=s[1];
      if(_tM_)
       {var tl=_tM_[2],hd=_tM_[1];s[1] = tl;s[2] = s[2] - 1 | 0;return [0,hd]}
      return 0}
    function top(s)
     {var _tL_=s[1];if(_tL_){var hd=_tL_[1];return hd}throw Empty}
    function top_opt(s)
     {var _tK_=s[1];if(_tK_){var hd=_tK_[1];return [0,hd]}return 0}
    function is_empty(s){return 0 === s[1]?1:0}
    function length$1(s){return s[2]}
    function iter$7(f,s){return iter$2(f,s[1])}
    function fold$1(f,acc,s){return fold_left$0(f,acc,s[1])}
    function to_seq$6(s){return to_seq$1(s[1])}
    function add_seq(q,i){return iter(function(x){return push(x,q)},i)}
    function of_seq$4(g){var s=create$0(0);add_seq(s,g);return s}
    var
     Stdlib_stack=
      [0,
       Empty,
       create$0,
       push,
       pop,
       pop_opt,
       top,
       top_opt,
       clear,
       copy$3,
       is_empty,
       length$1,
       iter$7,
       fold$1,
       to_seq$6,
       add_seq,
       of_seq$4];
    caml_register_global(772,Stdlib_stack,"Stdlib__stack");
    var Empty$0=[248,cst_Stdlib_Queue_Empty,caml_fresh_oo_id(0)];
    function create$1(param){return [0,0,0,0]}
    function clear$0(q){q[1] = 0;q[2] = 0;q[3] = 0;return 0}
    function add(x,q)
     {var cell=[0,x,0],_tJ_=q[3];
      return _tJ_
              ?(q[1] = q[1] + 1 | 0,_tJ_[2] = cell,q[3] = cell,0)
              :(q[1] = 1,q[2] = cell,q[3] = cell,0)}
    function peek(q)
     {var _tI_=q[2];if(_tI_){var content=_tI_[1];return content}throw Empty$0}
    function peek_opt(q)
     {var _tH_=q[2];if(_tH_){var content=_tH_[1];return [0,content]}return 0}
    function take(q)
     {var _tF_=q[2];
      if(_tF_)
       {var _tG_=_tF_[1];
        if(_tF_[2])
         {var next=_tF_[2];q[1] = q[1] - 1 | 0;q[2] = next;return _tG_}
        clear$0(q);
        return _tG_}
      throw Empty$0}
    function take_opt(q)
     {var _tD_=q[2];
      if(_tD_)
       {var _tE_=_tD_[1];
        if(_tD_[2])
         {var next=_tD_[2];q[1] = q[1] - 1 | 0;q[2] = next;return [0,_tE_]}
        clear$0(q);
        return [0,_tE_]}
      return 0}
    function copy$4(q)
     {var q_res=[0,q[1],0,0],prev=0,cell=q[2];
      for(;;)
       {if(cell)
         {var content=cell[1],next=cell[2],res=[0,content,0];
          if(prev)prev[2] = res;else q_res[2] = res;
          var prev=res,cell=next;
          continue}
        q_res[3] = prev;
        return q_res}}
    function is_empty$0(q){return 0 === q[1]?1:0}
    function length$2(q){return q[1]}
    function iter$8(f,q)
     {var cell=q[2];
      for(;;)
       {if(cell)
         {var content=cell[1],next=cell[2];
          caml_call1(f,content);
          var cell=next;
          continue}
        return 0}}
    function fold$2(f,accu$1,q)
     {var accu=accu$1,cell=q[2];
      for(;;)
       {if(cell)
         {var
           content=cell[1],
           next=cell[2],
           accu$0=caml_call2(f,accu,content),
           accu=accu$0,
           cell=next;
          continue}
        return accu}}
    function transfer(q1,q2)
     {var _tB_=0 < q1[1]?1:0;
      if(_tB_)
       {var _tC_=q2[3];
        return _tC_
                ?(q2[1]
                  =
                  q2[1]
                  +
                  q1[1]
                  |
                  0,
                  _tC_[2]
                  =
                  q1[2],
                  q2[3]
                  =
                  q1[3],
                  clear$0(q1))
                :(q2[1] = q1[1],q2[2] = q1[2],q2[3] = q1[3],clear$0(q1))}
      return _tB_}
    function to_seq$7(q)
     {function aux(c,param)
       {if(c)
         {var x=c[1],next=c[2];
          return [0,x,function(_tA_){return aux(next,_tA_)}]}
        return 0}
      var _ty_=q[2];
      return function(_tz_){return aux(_ty_,_tz_)}}
    function add_seq$0(q,i){return iter(function(x){return add(x,q)},i)}
    function of_seq$5(g){var q=create$1(0);add_seq$0(q,g);return q}
    var
     Stdlib_queue=
      [0,
       Empty$0,
       create$1,
       add,
       add,
       take,
       take_opt,
       take,
       peek,
       peek_opt,
       peek,
       clear$0,
       copy$4,
       is_empty$0,
       length$2,
       iter$8,
       fold$2,
       transfer,
       to_seq$7,
       add_seq$0,
       of_seq$5];
    caml_register_global(773,Stdlib_queue,"Stdlib__queue");
    var Undefined=[248,cst_CamlinternalLazy_Undefined,caml_fresh_oo_id(0)];
    function raise_undefined(param){throw Undefined}
    function force_lazy_block(blk)
     {var closure=blk[1];
      blk[1] = raise_undefined;
      try
       {var result=caml_call1(closure,0);
        caml_obj_make_forward(blk,result);
        return result}
      catch(e)
       {e = caml_wrap_exception(e);blk[1] = function(param){throw e};throw e}}
    function force_val_lazy_block(blk)
     {var closure=blk[1];
      blk[1] = raise_undefined;
      var result=caml_call1(closure,0);
      caml_obj_make_forward(blk,result);
      return result}
    function force(lzv)
     {var t=caml_obj_tag(lzv);
      return t === 250?lzv[1]:t !== 246?lzv:force_lazy_block(lzv)}
    function force_val(lzv)
     {var t=caml_obj_tag(lzv);
      return t === 250?lzv[1]:t !== 246?lzv:force_val_lazy_block(lzv)}
    var
     CamlinternalLazy=
      [0,Undefined,force_lazy_block,force_val_lazy_block,force,force_val];
    caml_register_global(774,CamlinternalLazy,"CamlinternalLazy");
    function from_fun(f){var x=caml_obj_block(246,1);x[1] = f;return x}
    function from_val(v)
     {var t=caml_obj_tag(v);
      if(t !== 250 && t !== 246 && t !== 253)return v;
      return runtime.caml_lazy_make_forward(v)}
    function is_val(l){return caml_obj_tag(l) !== 246?1:0}
    var
     Stdlib_lazy=
      [0,
       Undefined,
       force_val,
       from_fun,
       from_val,
       is_val,
       from_fun,
       from_val,
       is_val];
    caml_register_global(775,Stdlib_lazy,"Stdlib__lazy");
    var
     Failure$0=[248,cst_Stdlib_Stream_Failure,caml_fresh_oo_id(0)],
     Error=[248,cst_Stdlib_Stream_Error,caml_fresh_oo_id(0)];
    function count(param)
     {if(param){var match=param[1],count=match[1];return count}return 0}
    function data(param)
     {if(param){var match=param[1],data=match[2];return data}return 0}
    function fill_buff(b)
     {b[3] = input(b[1],b[2],0,caml_ml_bytes_length(b[2]));b[4] = 0;return 0}
    function get_data(count,d)
     {var d$0=d;
      for(;;)
       {if(typeof d$0 !== "number")
         switch(d$0[0])
          {case 1:
            var d2=d$0[2],d1=d$0[1],match=get_data(count,d1);
            if(typeof match === "number")
             {var d$0=d2;continue}
            else
             {if(0 === match[0])
               {var d11=match[2],a=match[1];return [0,a,[1,d11,d2]]}
              throw [0,Assert_failure,_M_]}
           case 2:
            var
             f=d$0[1],
             _tu_=caml_obj_tag(f),
             d$1=250 === _tu_?f[1]:246 === _tu_?force_lazy_block(f):f,
             d$0=d$1;
            continue;
           case 3:
            var _tv_=d$0[1],_tw_=_tv_[1];
            if(_tw_)
             {var _tx_=_tw_[1];
              if(_tx_){var a$0=_tx_[1];_tv_[1] = 0;return [0,a$0,d$0]}
              return 0}
            var match$0=caml_call1(_tv_[2],count);
            if(match$0){var a$1=match$0[1];return [0,a$1,d$0]}
            _tv_[1] = _N_;
            return 0;
           case 4:
            var b=d$0[1];
            if(b[3] <= b[4])fill_buff(b);
            if(0 === b[3])return 0;
            var r=caml_bytes_unsafe_get(b[2],b[4]);
            b[4] = b[4] + 1 | 0;
            return [0,r,d$0]
           }
        return d$0}}
    function peek_data(s)
     {for(;;)
       {var _tp_=s[2];
        if(typeof _tp_ === "number")
         return 0;
        else
         switch(_tp_[0])
          {case 0:var a=_tp_[1];return [0,a];
           case 1:
            var d=get_data(s[1],s[2]);
            if(typeof d === "number")
             return 0;
            else
             {if(0 === d[0]){var a$0=d[1];s[2] = d;return [0,a$0]}
              throw [0,Assert_failure,_O_]}
           case 2:
            var
             f=_tp_[1],
             _tq_=caml_obj_tag(f),
             _tr_=250 === _tq_?f[1]:246 === _tq_?force_lazy_block(f):f;
            s[2] = _tr_;
            continue;
           case 3:
            var _ts_=_tp_[1],_tt_=_ts_[1];
            if(_tt_){var a$1=_tt_[1];return a$1}
            var x=caml_call1(_ts_[2],s[1]);
            _ts_[1] = [0,x];
            return x;
           default:
            var b=_tp_[1];
            if(b[3] <= b[4])fill_buff(b);
            return 0 === b[3]
                    ?(s[2] = 0,0)
                    :[0,caml_bytes_unsafe_get(b[2],b[4])]}}}
    function peek$0(param)
     {if(param){var s=param[1];return peek_data(s)}return 0}
    function junk_data(s)
     {for(;;)
       {var _tn_=s[2];
        if(typeof _tn_ !== "number")
         switch(_tn_[0])
          {case 0:var d=_tn_[2];s[1] = s[1] + 1 | 0;s[2] = d;return 0;
           case 3:
            var _to_=_tn_[1];
            if(_to_[1]){s[1] = s[1] + 1 | 0;_to_[1] = 0;return 0}
            break;
           case 4:
            var b=_tn_[1];
            if(b[3] <= b[4])fill_buff(b);
            return 0 === b[3]
                    ?(s[2] = 0,0)
                    :(s[1] = s[1] + 1 | 0,b[4] = b[4] + 1 | 0,0)
           }
        var match=peek_data(s);
        if(match)continue;
        return 0}}
    function junk(param)
     {if(param){var data=param[1];return junk_data(data)}return 0}
    function nget_data(n,s)
     {if(0 < n)
       {var match=peek_data(s);
        if(match)
         {var a=match[1];
          junk_data(s);
          var
           match$0=nget_data(n - 1 | 0,s),
           k=match$0[3],
           d=match$0[2],
           al=match$0[1];
          return [0,[0,a,al],[0,a,d],k + 1 | 0]}
        return [0,0,s[2],0]}
      return [0,0,s[2],0]}
    function npeek(n,param)
     {if(param)
       {var
         d$0=param[1],
         match=nget_data(n,d$0),
         len=match[3],
         d=match[2],
         al=match[1];
        d$0[1] = d$0[1] - len | 0;
        d$0[2] = d;
        return al}
      return 0}
    function next(s)
     {var match=peek$0(s);
      if(match){var a=match[1];junk(s);return a}
      throw Failure$0}
    function empty$1(s){var match=peek$0(s);if(match)throw Failure$0;return 0}
    function iter$9(f,strm)
     {for(;;)
       {var match=peek$0(strm);
        if(match){var a=match[1];junk(strm);caml_call1(f,a);continue}
        return 0}}
    function from(f){return [0,[0,0,[3,[0,0,f]]]]}
    function of_list$1(l)
     {var _tm_=0;
      return [0,[0,0,fold_right(function(x,l){return [0,x,l]},l,_tm_)]]}
    function of_string$0(s)
     {var count=[0,0];
      return from
              (function(param)
                {var c=count[1];
                 return c < caml_ml_string_length(s)
                         ?(count[1]++,[0,caml_string_get(s,c)])
                         :0})}
    function of_bytes(s)
     {var count=[0,0];
      return from
              (function(param)
                {var c=count[1];
                 return c < caml_ml_bytes_length(s)
                         ?(count[1]++,[0,caml_bytes_get(s,c)])
                         :0})}
    function of_channel(ic)
     {return [0,[0,0,[4,[0,ic,caml_create_bytes(4096),0,0]]]]}
    function iapp(i,s){var _tl_=data(s);return [0,[0,0,[1,data(i),_tl_]]]}
    function icons(i,s){return [0,[0,0,[0,i,data(s)]]]}
    function ising(i){return [0,[0,0,[0,i,0]]]}
    function lapp(f,s)
     {return [0,
              [0,
               0,
               [2,
                [246,
                 function(_tj_)
                  {var _tk_=data(s);return [1,data(caml_call1(f,0)),_tk_]}]]]]}
    function lcons(f,s)
     {return [0,
              [0,
               0,
               [2,
                [246,
                 function(_th_)
                  {var _ti_=data(s);return [0,caml_call1(f,0),_ti_]}]]]]}
    function lsing(f)
     {return [0,[0,0,[2,[246,function(_tg_){return [0,caml_call1(f,0),0]}]]]]}
    var sempty=0;
    function slazy(f)
     {return [0,[0,0,[2,[246,function(_tf_){return data(caml_call1(f,0))}]]]]}
    function dump(f,s)
     {print_string(cst_count);
      print_int(count(s));
      print_string(cst_data);
      dump_data(f,data(s));
      print_string(cst$6);
      return print_newline(0)}
    function dump_data(f,param)
     {if(typeof param === "number")
       return print_string(cst_Sempty);
      else
       switch(param[0])
        {case 0:
          var d=param[2],a=param[1];
          print_string(cst_Scons);
          caml_call1(f,a);
          print_string(cst$7);
          dump_data(f,d);
          return print_string(cst$8);
         case 1:
          var d2=param[2],d1=param[1];
          print_string(cst_Sapp);
          dump_data(f,d1);
          print_string(cst$9);
          dump_data(f,d2);
          return print_string(cst$10);
         case 2:return print_string(cst_Slazy);
         case 3:return print_string(cst_Sgen);
         default:return print_string(cst_Sbuffio)}}
    var
     Stdlib_stream=
      [0,
       Failure$0,
       Error,
       from,
       of_list$1,
       of_string$0,
       of_bytes,
       of_channel,
       iter$9,
       next,
       empty$1,
       peek$0,
       junk,
       count,
       npeek,
       iapp,
       icons,
       ising,
       lapp,
       lcons,
       lsing,
       sempty,
       slazy,
       dump];
    caml_register_global(776,Stdlib_stream,"Stdlib__stream");
    function create$2(n)
     {var
       n$0=1 <= n?n:1,
       n$1=max_string_length < n$0?max_string_length:n$0,
       s=caml_create_bytes(n$1);
      return [0,s,0,n$1,s]}
    function contents(b){return sub_string(b[1],0,b[2])}
    function to_bytes(b){return sub(b[1],0,b[2])}
    function sub$3(b,ofs,len)
     {if(0 <= ofs && 0 <= len && ! ((b[2] - len | 0) < ofs))
       return sub_string(b[1],ofs,len);
      return invalid_arg(cst_Buffer_sub)}
    function blit$3(src,srcoff,dst,dstoff,len)
     {if
       (0
        <=
        len
        &&
        0
        <=
        srcoff
        &&
        !
        ((src[2] - len | 0) < srcoff)
        &&
        0
        <=
        dstoff
        &&
        !
        ((caml_ml_bytes_length(dst) - len | 0) < dstoff))
       return caml_blit_bytes(src[1],srcoff,dst,dstoff,len);
      return invalid_arg(cst_Buffer_blit)}
    function nth$0(b,ofs)
     {if(0 <= ofs && ! (b[2] <= ofs))return caml_bytes_unsafe_get(b[1],ofs);
      return invalid_arg(cst_Buffer_nth)}
    function length$3(b){return b[2]}
    function clear$1(b){b[2] = 0;return 0}
    function reset(b)
     {b[2] = 0;b[1] = b[4];b[3] = caml_ml_bytes_length(b[1]);return 0}
    function resize(b,more)
     {var old_pos=b[2],old_len=b[3],new_len=[0,old_len];
      for(;;)
       {if(new_len[1] < (old_pos + more | 0))
         {new_len[1] = 2 * new_len[1] | 0;continue}
        if(max_string_length < new_len[1])
         if((old_pos + more | 0) <= max_string_length)
          new_len[1] = max_string_length;
         else
          failwith(cst_Buffer_add_cannot_grow_buf);
        var new_buffer=caml_create_bytes(new_len[1]);
        blit(b[1],0,new_buffer,0,b[2]);
        b[1] = new_buffer;
        b[3] = new_len[1];
        if((b[2] + more | 0) <= b[3])
         {if((old_pos + more | 0) <= b[3])return 0;
          throw [0,Assert_failure,_P_]}
        throw [0,Assert_failure,_Q_]}}
    function add_char(b,c)
     {var pos=b[2];
      if(b[3] <= pos)resize(b,1);
      caml_bytes_unsafe_set(b[1],pos,c);
      b[2] = pos + 1 | 0;
      return 0}
    function add_utf_8_uchar(b,u)
     {if(0 <= u)
       {if(127 < u)
         {if(2047 < u)
           {if(65535 < u)
             {if(1114111 < u)throw [0,Assert_failure,_R_];
              var pos=b[2];
              if(b[3] < (pos + 4 | 0))resize(b,4);
              caml_bytes_unsafe_set(b[1],pos,240 | u >>> 18 | 0);
              caml_bytes_unsafe_set
               (b[1],pos + 1 | 0,128 | (u >>> 12 | 0) & 63);
              caml_bytes_unsafe_set(b[1],pos + 2 | 0,128 | (u >>> 6 | 0) & 63);
              caml_bytes_unsafe_set(b[1],pos + 3 | 0,128 | u & 63);
              b[2] = pos + 4 | 0;
              return 0}
            var pos$0=b[2];
            if(b[3] < (pos$0 + 3 | 0))resize(b,3);
            caml_bytes_unsafe_set(b[1],pos$0,224 | u >>> 12 | 0);
            caml_bytes_unsafe_set(b[1],pos$0 + 1 | 0,128 | (u >>> 6 | 0) & 63);
            caml_bytes_unsafe_set(b[1],pos$0 + 2 | 0,128 | u & 63);
            b[2] = pos$0 + 3 | 0;
            return 0}
          var pos$1=b[2];
          if(b[3] < (pos$1 + 2 | 0))resize(b,2);
          caml_bytes_unsafe_set(b[1],pos$1,192 | u >>> 6 | 0);
          caml_bytes_unsafe_set(b[1],pos$1 + 1 | 0,128 | u & 63);
          b[2] = pos$1 + 2 | 0;
          return 0}
        return add_char(b,u)}
      throw [0,Assert_failure,_S_]}
    function add_utf_16be_uchar(b,u)
     {if(0 <= u)
       {if(65535 < u)
         {if(1114111 < u)throw [0,Assert_failure,_T_];
          var
           u$0=u - 65536 | 0,
           hi=55296 | u$0 >>> 10 | 0,
           lo=56320 | u$0 & 1023,
           pos=b[2];
          if(b[3] < (pos + 4 | 0))resize(b,4);
          caml_bytes_unsafe_set(b[1],pos,hi >>> 8 | 0);
          caml_bytes_unsafe_set(b[1],pos + 1 | 0,hi & 255);
          caml_bytes_unsafe_set(b[1],pos + 2 | 0,lo >>> 8 | 0);
          caml_bytes_unsafe_set(b[1],pos + 3 | 0,lo & 255);
          b[2] = pos + 4 | 0;
          return 0}
        var pos$0=b[2];
        if(b[3] < (pos$0 + 2 | 0))resize(b,2);
        caml_bytes_unsafe_set(b[1],pos$0,u >>> 8 | 0);
        caml_bytes_unsafe_set(b[1],pos$0 + 1 | 0,u & 255);
        b[2] = pos$0 + 2 | 0;
        return 0}
      throw [0,Assert_failure,_U_]}
    function add_utf_16le_uchar(b,u)
     {if(0 <= u)
       {if(65535 < u)
         {if(1114111 < u)throw [0,Assert_failure,_V_];
          var
           u$0=u - 65536 | 0,
           hi=55296 | u$0 >>> 10 | 0,
           lo=56320 | u$0 & 1023,
           pos=b[2];
          if(b[3] < (pos + 4 | 0))resize(b,4);
          caml_bytes_unsafe_set(b[1],pos,hi & 255);
          caml_bytes_unsafe_set(b[1],pos + 1 | 0,hi >>> 8 | 0);
          caml_bytes_unsafe_set(b[1],pos + 2 | 0,lo & 255);
          caml_bytes_unsafe_set(b[1],pos + 3 | 0,lo >>> 8 | 0);
          b[2] = pos + 4 | 0;
          return 0}
        var pos$0=b[2];
        if(b[3] < (pos$0 + 2 | 0))resize(b,2);
        caml_bytes_unsafe_set(b[1],pos$0,u & 255);
        caml_bytes_unsafe_set(b[1],pos$0 + 1 | 0,u >>> 8 | 0);
        b[2] = pos$0 + 2 | 0;
        return 0}
      throw [0,Assert_failure,_W_]}
    function add_substring(b,s,offset,len)
     {var _tc_=offset < 0?1:0;
      if(_tc_)
       var _td_=_tc_;
      else
       var
        _te_=len < 0?1:0,
        _td_=_te_ || ((caml_ml_string_length(s) - len | 0) < offset?1:0);
      if(_td_)invalid_arg(cst_Buffer_add_substring_add_s);
      var new_position=b[2] + len | 0;
      if(b[3] < new_position)resize(b,len);
      caml_blit_string(s,offset,b[1],b[2],len);
      b[2] = new_position;
      return 0}
    function add_subbytes(b,s,offset,len)
     {return add_substring(b,caml_string_of_bytes(s),offset,len)}
    function add_string(b,s)
     {var len=caml_ml_string_length(s),new_position=b[2] + len | 0;
      if(b[3] < new_position)resize(b,len);
      caml_blit_string(s,0,b[1],b[2],len);
      b[2] = new_position;
      return 0}
    function add_bytes(b,s){return add_string(b,caml_string_of_bytes(s))}
    function add_buffer(b,bs){return add_subbytes(b,bs[1],0,bs[2])}
    function add_channel(b,ic,len)
     {var _ta_=len < 0?1:0,_tb_=_ta_ || (max_string_length < len?1:0);
      if(_tb_)invalid_arg(cst_Buffer_add_channel);
      if(b[3] < (b[2] + len | 0))resize(b,len);
      var already_read=0,ofs=b[2],to_read=len,_s$_=b[1];
      for(;;)
       {if(0 !== to_read)
         {var r=input(ic,_s$_,ofs,to_read);
          if(0 !== r)
           {var
             already_read$0=already_read + r | 0,
             ofs$0=ofs + r | 0,
             to_read$0=to_read - r | 0,
             already_read=already_read$0,
             ofs=ofs$0,
             to_read=to_read$0;
            continue}}
        if((b[2] + already_read | 0) <= b[3])
         {b[2] = b[2] + already_read | 0;
          if(already_read < len)throw End_of_file;
          return 0}
        throw [0,Assert_failure,_X_]}}
    function output_buffer(oc,b){return output(oc,b[1],0,b[2])}
    function add_substitute(b,f,s)
     {var lim$1=caml_ml_string_length(s),previous=32,i$7=0;
      for(;;)
       {if(i$7 < lim$1)
         {var current=caml_string_get(s,i$7);
          if(36 === current)
           {if(92 === previous)
             {add_char(b,current);
              var i$8=i$7 + 1 | 0,previous=32,i$7=i$8;
              continue}
            var start=i$7 + 1 | 0;
            if(lim$1 <= start)throw Not_found;
            var opening=caml_string_get(s,start),switch$0=0;
            if(40 !== opening && 123 !== opening)
             {var i$6=start + 1 | 0,lim$0=caml_ml_string_length(s),i$3=i$6;
              for(;;)
               {if(lim$0 <= i$3)
                 var stop=lim$0;
                else
                 {var match=caml_string_get(s,i$3),switch$1=0;
                  if(91 <= match)
                   {if(97 <= match)
                     {if(! (123 <= match))switch$1 = 1}
                    else
                     if(95 === match)switch$1 = 1}
                  else
                   if(58 <= match)
                    {if(65 <= match)switch$1 = 1}
                   else
                    if(48 <= match)switch$1 = 1;
                  if(switch$1){var i$4=i$3 + 1 | 0,i$3=i$4;continue}
                  var stop=i$3}
                var match$0=[0,sub$0(s,start,stop - start | 0),stop];
                switch$0 = 1;
                break}}
            if(! switch$0)
             {var i$5=start + 1 | 0,k$2=0;
              if(40 === opening)
               var _s9_=41;
              else
               {if(123 !== opening)throw [0,Assert_failure,_Y_];var _s9_=125}
              var lim=caml_ml_string_length(s),k=k$2,i=i$5;
              for(;;)
               {if(lim <= i)throw Not_found;
                if(caml_string_get(s,i) === opening)
                 {var i$0=i + 1 | 0,k$0=k + 1 | 0,k=k$0,i=i$0;continue}
                if(caml_string_get(s,i) !== _s9_)
                 {var i$2=i + 1 | 0,i=i$2;continue}
                if(0 !== k)
                 {var i$1=i + 1 | 0,k$1=k - 1 | 0,k=k$1,i=i$1;continue}
                var
                 match$0=
                  [0,sub$0(s,i$5,(i - start | 0) - 1 | 0),i + 1 | 0];
                break}}
            var next_i=match$0[2],ident=match$0[1];
            add_string(b,caml_call1(f,ident));
            var previous=32,i$7=next_i;
            continue}
          if(92 === previous)
           {add_char(b,92);
            add_char(b,current);
            var i$9=i$7 + 1 | 0,previous=32,i$7=i$9;
            continue}
          if(92 === current)
           {var i$10=i$7 + 1 | 0,previous=current,i$7=i$10;continue}
          add_char(b,current);
          var i$11=i$7 + 1 | 0,previous=current,i$7=i$11;
          continue}
        var _s__=92 === previous?1:0;
        return _s__?add_char(b,previous):_s__}}
    function truncate(b,len)
     {if(0 <= len && ! (b[2] < len)){b[2] = len;return 0}
      return invalid_arg(cst_Buffer_truncate)}
    function to_seq$8(b)
     {function aux(i,param)
       {if(b[2] <= i)return 0;
        var x=caml_bytes_unsafe_get(b[1],i),_s7_=i + 1 | 0;
        return [0,x,function(_s8_){return aux(_s7_,_s8_)}]}
      var _s5_=0;
      return function(_s6_){return aux(_s5_,_s6_)}}
    function to_seqi$3(b)
     {function aux(i,param)
       {if(b[2] <= i)return 0;
        var x=caml_bytes_unsafe_get(b[1],i),_s3_=i + 1 | 0;
        return [0,[0,i,x],function(_s4_){return aux(_s3_,_s4_)}]}
      var _s1_=0;
      return function(_s2_){return aux(_s1_,_s2_)}}
    function add_seq$1(b,seq)
     {return iter(function(_s0_){return add_char(b,_s0_)},seq)}
    function of_seq$6(i){var b=create$2(32);add_seq$1(b,i);return b}
    function add_int8(b,x)
     {var new_position=b[2] + 1 | 0;
      if(b[3] < new_position)resize(b,1);
      caml_bytes_unsafe_set(b[1],b[2],x);
      b[2] = new_position;
      return 0}
    function add_int16_ne(b,x)
     {var new_position=b[2] + 2 | 0;
      if(b[3] < new_position)resize(b,2);
      caml_bytes_set16(b[1],b[2],x);
      b[2] = new_position;
      return 0}
    function add_int32_ne(b,x)
     {var new_position=b[2] + 4 | 0;
      if(b[3] < new_position)resize(b,4);
      caml_bytes_set32(b[1],b[2],x);
      b[2] = new_position;
      return 0}
    function add_int64_ne(b,x)
     {var new_position=b[2] + 8 | 0;
      if(b[3] < new_position)resize(b,8);
      caml_bytes_set64(b[1],b[2],x);
      b[2] = new_position;
      return 0}
    function add_int16_le(b,x){return add_int16_ne(b,x)}
    function add_int16_be(b,x)
     {var x$0=caml_bswap16(x);return add_int16_ne(b,x$0)}
    function add_int32_le(b,x){return add_int32_ne(b,x)}
    function add_int32_be(b,x)
     {var x$0=caml_int32_bswap(x);return add_int32_ne(b,x$0)}
    function add_int64_le(b,x){return add_int64_ne(b,x)}
    function add_int64_be(b,x)
     {var x$0=caml_int64_bswap(x);return add_int64_ne(b,x$0)}
    var
     Stdlib_buffer=
      [0,
       create$2,
       contents,
       to_bytes,
       sub$3,
       blit$3,
       nth$0,
       length$3,
       clear$1,
       reset,
       add_char,
       add_utf_8_uchar,
       add_utf_16le_uchar,
       add_utf_16be_uchar,
       add_string,
       add_bytes,
       add_substring,
       add_subbytes,
       add_substitute,
       add_buffer,
       add_channel,
       output_buffer,
       truncate,
       to_seq$8,
       to_seqi$3,
       add_seq$1,
       of_seq$6,
       add_int8,
       add_int8,
       add_int16_ne,
       add_int16_be,
       add_int16_le,
       add_int16_ne,
       add_int16_be,
       add_int16_le,
       add_int32_ne,
       add_int32_be,
       add_int32_le,
       add_int64_ne,
       add_int64_be,
       add_int64_le];
    caml_register_global(777,Stdlib_buffer,"Stdlib__buffer");
    function create_char_set(param){return make(32,0)}
    function add_in_char_set(char_set,c)
     {var str_ind=c >>> 3 | 0,mask=1 << (c & 7);
      return caml_bytes_set
              (char_set,
               str_ind,
               char_of_int(caml_bytes_get(char_set,str_ind) | mask))}
    function freeze_char_set(char_set){return to_string$1(char_set)}
    function rev_char_set(char_set)
     {var char_set$0=create_char_set(0),i=0;
      for(;;)
       {caml_bytes_set
         (char_set$0,i,char_of_int(caml_string_get(char_set,i) ^ 255));
        var _sZ_=i + 1 | 0;
        if(31 !== i){var i=_sZ_;continue}
        return caml_string_of_bytes(char_set$0)}}
    function is_in_char_set(char_set,c)
     {var str_ind=c >>> 3 | 0,mask=1 << (c & 7);
      return 0 !== (caml_string_get(char_set,str_ind) & mask)?1:0}
    function pad_of_pad_opt(pad_opt)
     {if(pad_opt){var width=pad_opt[1];return [0,1,width]}return 0}
    function param_format_of_ignored_format(ign,fmt)
     {if(typeof ign === "number")
       switch(ign)
        {case 0:return [0,[0,fmt]];
         case 1:return [0,[1,fmt]];
         case 2:return [0,[19,fmt]];
         default:return [0,[22,fmt]]}
      else
       switch(ign[0])
        {case 0:var pad_opt=ign[1];return [0,[2,pad_of_pad_opt(pad_opt),fmt]];
         case 1:
          var pad_opt$0=ign[1];return [0,[3,pad_of_pad_opt(pad_opt$0),fmt]];
         case 2:
          var pad_opt$1=ign[2],iconv=ign[1];
          return [0,[4,iconv,pad_of_pad_opt(pad_opt$1),0,fmt]];
         case 3:
          var pad_opt$2=ign[2],iconv$0=ign[1];
          return [0,[5,iconv$0,pad_of_pad_opt(pad_opt$2),0,fmt]];
         case 4:
          var pad_opt$3=ign[2],iconv$1=ign[1];
          return [0,[6,iconv$1,pad_of_pad_opt(pad_opt$3),0,fmt]];
         case 5:
          var pad_opt$4=ign[2],iconv$2=ign[1];
          return [0,[7,iconv$2,pad_of_pad_opt(pad_opt$4),0,fmt]];
         case 6:
          var prec_opt=ign[2],pad_opt$5=ign[1];
          if(prec_opt)var ndec=prec_opt[1],_sY_=[0,ndec];else var _sY_=0;
          return [0,[8,_Z_,pad_of_pad_opt(pad_opt$5),_sY_,fmt]];
         case 7:
          var pad_opt$6=ign[1];return [0,[9,pad_of_pad_opt(pad_opt$6),fmt]];
         case 8:
          var fmtty=ign[2],pad_opt$7=ign[1];
          return [0,[13,pad_opt$7,fmtty,fmt]];
         case 9:
          var fmtty$0=ign[2],pad_opt$8=ign[1];
          return [0,[14,pad_opt$8,fmtty$0,fmt]];
         case 10:
          var char_set=ign[2],width_opt=ign[1];
          return [0,[20,width_opt,char_set,fmt]];
         default:var counter=ign[1];return [0,[21,counter,fmt]]}}
    function default_float_precision(fconv){return 5 === fconv[2]?12:-6}
    function buffer_create(init_size)
     {return [0,0,caml_create_bytes(init_size)]}
    function buffer_check_size(buf,overhead)
     {var
       len=caml_ml_bytes_length(buf[2]),
       min_len=buf[1] + overhead | 0,
       _sW_=len < min_len?1:0;
      if(_sW_)
       {var
         new_len=max(len * 2 | 0,min_len),
         new_str=caml_create_bytes(new_len);
        blit(buf[2],0,new_str,0,len);
        buf[2] = new_str;
        var _sX_=0}
      else
       var _sX_=_sW_;
      return _sX_}
    function buffer_add_char(buf,c)
     {buffer_check_size(buf,1);
      caml_bytes_set(buf[2],buf[1],c);
      buf[1] = buf[1] + 1 | 0;
      return 0}
    function buffer_add_string(buf,s)
     {var str_len=caml_ml_string_length(s);
      buffer_check_size(buf,str_len);
      blit$0(s,0,buf[2],buf[1],str_len);
      buf[1] = buf[1] + str_len | 0;
      return 0}
    function buffer_contents(buf){return sub_string(buf[2],0,buf[1])}
    function char_of_iconv(iconv)
     {switch(iconv)
       {case 6:
        case 7:return 120;
        case 8:
        case 9:return 88;
        case 10:
        case 11:return 111;
        case 12:
        case 15:return 117;
        case 0:
        case 1:
        case 2:
        case 13:return 100;
        default:return 105}}
    function char_of_fconv(opt,fconv)
     {if(opt)var sth=opt[1],cF=sth;else var cF=70;
      switch(fconv[2])
       {case 0:return 102;
        case 1:return 101;
        case 2:return 69;
        case 3:return 103;
        case 4:return 71;
        case 5:return cF;
        case 6:return 104;
        case 7:return 72;
        default:return 70}}
    function bprint_padty(buf,padty)
     {switch(padty)
       {case 0:return buffer_add_char(buf,45);
        case 1:return 0;
        default:return buffer_add_char(buf,48)}}
    function bprint_ignored_flag(buf,ign_flag)
     {return ign_flag?buffer_add_char(buf,95):ign_flag}
    function bprint_pad_opt(buf,pad_opt)
     {if(pad_opt)
       {var width=pad_opt[1];
        return buffer_add_string(buf,caml_string_of_jsbytes("" + width))}
      return 0}
    function bprint_padding(buf,pad)
     {if(typeof pad === "number")
       return 0;
      else
       {if(0 === pad[0])
         {var n=pad[2],padty=pad[1];
          bprint_padty(buf,padty);
          return buffer_add_string(buf,caml_string_of_jsbytes("" + n))}
        var padty$0=pad[1];
        bprint_padty(buf,padty$0);
        return buffer_add_char(buf,42)}}
    function bprint_precision(buf,prec)
     {if(typeof prec === "number")return prec?buffer_add_string(buf,cst$11):0;
      var n=prec[1];
      buffer_add_char(buf,46);
      return buffer_add_string(buf,caml_string_of_jsbytes("" + n))}
    function bprint_iconv_flag(buf,iconv)
     {switch(iconv)
       {case 1:
        case 4:return buffer_add_char(buf,43);
        case 2:
        case 5:return buffer_add_char(buf,32);
        case 7:
        case 9:
        case 11:
        case 13:
        case 14:
        case 15:return buffer_add_char(buf,35);
        default:return 0}}
    function bprint_altint_fmt(buf,ign_flag,iconv,pad,prec,c)
     {buffer_add_char(buf,37);
      bprint_ignored_flag(buf,ign_flag);
      bprint_iconv_flag(buf,iconv);
      bprint_padding(buf,pad);
      bprint_precision(buf,prec);
      buffer_add_char(buf,c);
      return buffer_add_char(buf,char_of_iconv(iconv))}
    function bprint_fconv_flag(buf,fconv)
     {switch(fconv[1])
       {case 0:break;
        case 1:buffer_add_char(buf,43);break;
        default:buffer_add_char(buf,32)}
      return 8 <= fconv[2]?buffer_add_char(buf,35):0}
    function string_of_formatting_lit(formatting_lit)
     {if(typeof formatting_lit === "number")
       switch(formatting_lit)
        {case 0:return cst$12;
         case 1:return cst$13;
         case 2:return cst$14;
         case 3:return cst$15;
         case 4:return cst$16;
         case 5:return cst$17;
         default:return cst$18}
      else
       switch(formatting_lit[0])
        {case 0:var str=formatting_lit[1];return str;
         case 1:var str$0=formatting_lit[1];return str$0;
         default:var c=formatting_lit[1];return symbol(cst$19,make$0(1,c))}}
    function bprint_char_literal(buf,chr)
     {return 37 === chr?buffer_add_string(buf,cst$20):buffer_add_char(buf,chr)}
    function bprint_string_literal(buf,str)
     {var _sU_=caml_ml_string_length(str) - 1 | 0,_sT_=0;
      if(! (_sU_ < 0))
       {var i=_sT_;
        for(;;)
         {bprint_char_literal(buf,caml_string_get(str,i));
          var _sV_=i + 1 | 0;
          if(_sU_ !== i){var i=_sV_;continue}
          break}}
      return 0}
    function bprint_fmtty(buf,fmtty)
     {var fmtty$0=fmtty;
      for(;;)
       if(typeof fmtty$0 === "number")
        return 0;
       else
        switch(fmtty$0[0])
         {case 0:
           var rest=fmtty$0[1];
           buffer_add_string(buf,cst_c);
           var fmtty$0=rest;
           continue;
          case 1:
           var rest$0=fmtty$0[1];
           buffer_add_string(buf,cst_s);
           var fmtty$0=rest$0;
           continue;
          case 2:
           var rest$1=fmtty$0[1];
           buffer_add_string(buf,cst_i);
           var fmtty$0=rest$1;
           continue;
          case 3:
           var rest$2=fmtty$0[1];
           buffer_add_string(buf,cst_li);
           var fmtty$0=rest$2;
           continue;
          case 4:
           var rest$3=fmtty$0[1];
           buffer_add_string(buf,cst_ni);
           var fmtty$0=rest$3;
           continue;
          case 5:
           var rest$4=fmtty$0[1];
           buffer_add_string(buf,cst_Li);
           var fmtty$0=rest$4;
           continue;
          case 6:
           var rest$5=fmtty$0[1];
           buffer_add_string(buf,cst_f);
           var fmtty$0=rest$5;
           continue;
          case 7:
           var rest$6=fmtty$0[1];
           buffer_add_string(buf,cst_B);
           var fmtty$0=rest$6;
           continue;
          case 8:
           var rest$7=fmtty$0[2],sub_fmtty=fmtty$0[1];
           buffer_add_string(buf,cst$21);
           bprint_fmtty(buf,sub_fmtty);
           buffer_add_string(buf,cst$22);
           var fmtty$0=rest$7;
           continue;
          case 9:
           var rest$8=fmtty$0[3],sub_fmtty$0=fmtty$0[1];
           buffer_add_string(buf,cst$23);
           bprint_fmtty(buf,sub_fmtty$0);
           buffer_add_string(buf,cst$24);
           var fmtty$0=rest$8;
           continue;
          case 10:
           var rest$9=fmtty$0[1];
           buffer_add_string(buf,cst_a);
           var fmtty$0=rest$9;
           continue;
          case 11:
           var rest$10=fmtty$0[1];
           buffer_add_string(buf,cst_t$0);
           var fmtty$0=rest$10;
           continue;
          case 12:
           var rest$11=fmtty$0[1];
           buffer_add_string(buf,cst$25);
           var fmtty$0=rest$11;
           continue;
          case 13:
           var rest$12=fmtty$0[1];
           buffer_add_string(buf,cst_r$0);
           var fmtty$0=rest$12;
           continue;
          default:
           var rest$13=fmtty$0[1];
           buffer_add_string(buf,cst_r$1);
           var fmtty$0=rest$13;
           continue}}
    function int_of_custom_arity(param)
     {if(param){var x=param[1];return 1 + int_of_custom_arity(x) | 0}return 0}
    function string_of_fmt(fmt$1)
     {var buf=buffer_create(16),fmt=fmt$1,ign_flag=0;
      a:
      for(;;)
       if(typeof fmt === "number")
        return buffer_contents(buf);
       else
        switch(fmt[0])
         {case 0:
           var rest=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           buffer_add_char(buf,99);
           var fmt=rest,ign_flag=0;
           continue;
          case 1:
           var rest$0=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           buffer_add_char(buf,67);
           var fmt=rest$0,ign_flag=0;
           continue;
          case 2:
           var rest$1=fmt[2],pad=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_padding(buf,pad);
           buffer_add_char(buf,115);
           var fmt=rest$1,ign_flag=0;
           continue;
          case 3:
           var rest$2=fmt[2],pad$0=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_padding(buf,pad$0);
           buffer_add_char(buf,83);
           var fmt=rest$2,ign_flag=0;
           continue;
          case 4:
           var rest$3=fmt[4],prec=fmt[3],pad$1=fmt[2],iconv=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_iconv_flag(buf,iconv);
           bprint_padding(buf,pad$1);
           bprint_precision(buf,prec);
           buffer_add_char(buf,char_of_iconv(iconv));
           var fmt=rest$3,ign_flag=0;
           continue;
          case 5:
           var rest$4=fmt[4],prec$0=fmt[3],pad$2=fmt[2],iconv$0=fmt[1];
           bprint_altint_fmt(buf,ign_flag,iconv$0,pad$2,prec$0,108);
           var fmt=rest$4,ign_flag=0;
           continue;
          case 6:
           var rest$5=fmt[4],prec$1=fmt[3],pad$3=fmt[2],iconv$1=fmt[1];
           bprint_altint_fmt(buf,ign_flag,iconv$1,pad$3,prec$1,110);
           var fmt=rest$5,ign_flag=0;
           continue;
          case 7:
           var rest$6=fmt[4],prec$2=fmt[3],pad$4=fmt[2],iconv$2=fmt[1];
           bprint_altint_fmt(buf,ign_flag,iconv$2,pad$4,prec$2,76);
           var fmt=rest$6,ign_flag=0;
           continue;
          case 8:
           var rest$7=fmt[4],prec$3=fmt[3],pad$5=fmt[2],fconv=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_fconv_flag(buf,fconv);
           bprint_padding(buf,pad$5);
           bprint_precision(buf,prec$3);
           buffer_add_char(buf,char_of_fconv(0,fconv));
           var fmt=rest$7,ign_flag=0;
           continue;
          case 9:
           var rest$8=fmt[2],pad$6=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_padding(buf,pad$6);
           buffer_add_char(buf,66);
           var fmt=rest$8,ign_flag=0;
           continue;
          case 10:
           var rest$9=fmt[1];
           buffer_add_string(buf,cst$26);
           var fmt=rest$9;
           continue;
          case 11:
           var rest$10=fmt[2],str=fmt[1];
           bprint_string_literal(buf,str);
           var fmt=rest$10;
           continue;
          case 12:
           var rest$11=fmt[2],chr$0=fmt[1];
           bprint_char_literal(buf,chr$0);
           var fmt=rest$11;
           continue;
          case 13:
           var rest$12=fmt[3],fmtty=fmt[2],pad_opt=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_pad_opt(buf,pad_opt);
           buffer_add_char(buf,123);
           bprint_fmtty(buf,fmtty);
           buffer_add_char(buf,37);
           buffer_add_char(buf,125);
           var fmt=rest$12,ign_flag=0;
           continue;
          case 14:
           var rest$13=fmt[3],fmtty$0=fmt[2],pad_opt$0=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_pad_opt(buf,pad_opt$0);
           buffer_add_char(buf,40);
           bprint_fmtty(buf,fmtty$0);
           buffer_add_char(buf,37);
           buffer_add_char(buf,41);
           var fmt=rest$13,ign_flag=0;
           continue;
          case 15:
           var rest$14=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           buffer_add_char(buf,97);
           var fmt=rest$14,ign_flag=0;
           continue;
          case 16:
           var rest$15=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           buffer_add_char(buf,116);
           var fmt=rest$15,ign_flag=0;
           continue;
          case 17:
           var rest$16=fmt[2],fmting_lit=fmt[1];
           bprint_string_literal(buf,string_of_formatting_lit(fmting_lit));
           var fmt=rest$16;
           continue;
          case 18:
           var rest$17=fmt[2],fmting_gen=fmt[1];
           if(0 === fmting_gen[0])
            {var match$1=fmting_gen[1],str$0=match$1[2];
             buffer_add_string(buf,cst$27);
             buffer_add_string(buf,str$0)}
           else
            {var match$2=fmting_gen[1],str$1=match$2[2];
             buffer_add_string(buf,cst$28);
             buffer_add_string(buf,str$1)}
           var fmt=rest$17;
           continue;
          case 19:
           var rest$18=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           buffer_add_char(buf,114);
           var fmt=rest$18,ign_flag=0;
           continue;
          case 20:
           var rest$19=fmt[3],char_set=fmt[2],width_opt=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_pad_opt(buf,width_opt);
           var
            print_char=
             function(buf,i)
              {var c=char_of_int(i);
               return 37 === c
                       ?(buffer_add_char(buf,37),buffer_add_char(buf,37))
                       :64 === c
                         ?(buffer_add_char(buf,37),buffer_add_char(buf,64))
                         :buffer_add_char(buf,c)};
           buffer_add_char(buf,91);
           var
            _sJ_=
             is_in_char_set(char_set,0)
              ?(buffer_add_char(buf,94),rev_char_set(char_set))
              :char_set,
            is_alone$0=
             function(_sO_)
              {function is_alone(c)
                {var
                  after=chr(c + 1 | 0),
                  before=chr(c - 1 | 0),
                  _sP_=is_in_char_set(_sO_,c);
                 if(_sP_)
                  var
                   _sQ_=is_in_char_set(_sO_,before),
                   _sR_=_sQ_?is_in_char_set(_sO_,after):_sQ_,
                   _sS_=1 - _sR_;
                 else
                  var _sS_=_sP_;
                 return _sS_}
               return is_alone},
            is_alone=is_alone$0(_sJ_);
           if(is_alone(93))buffer_add_char(buf,93);
           var i=1;
           b:
           for(;;)
            {if(i < 256)
              {if(! is_in_char_set(_sJ_,char_of_int(i)))
                {var i$0=i + 1 | 0,i=i$0;continue}
               var match=char_of_int(i),switcher=match - 45 | 0,switch$0=0;
               if(48 < switcher >>> 0)
                if(210 <= switcher)print_char(buf,255);else switch$0 = 1;
               else
                {var switcher$0=switcher - 1 | 0;
                 if(46 < switcher$0 >>> 0){var i$2=i + 1 | 0,i=i$2;continue}
                 switch$0 = 1}
               if(switch$0)
                {var i$1=i + 1 | 0;
                 if(! is_in_char_set(_sJ_,char_of_int(i$1)))
                  {print_char(buf,i$1 - 1 | 0);
                   var i$6=i$1 + 1 | 0,i=i$6;
                   continue}
                 var
                  match$0=char_of_int(i$1),
                  switcher$1=match$0 - 45 | 0,
                  switch$1=0;
                 if(48 < switcher$1 >>> 0)
                  if(210 <= switcher$1)
                   {print_char(buf,254);print_char(buf,255)}
                  else
                   switch$1 = 1;
                 else
                  {var switcher$2=switcher$1 - 1 | 0;
                   if(46 < switcher$2 >>> 0)
                    {if(! is_in_char_set(_sJ_,char_of_int(i$1 + 1 | 0)))
                      {print_char(buf,i$1 - 1 | 0);
                       var i$5=i$1 + 1 | 0,i=i$5;
                       continue}
                     switch$1 = 1}
                   else
                    switch$1 = 1}
                 if(switch$1)
                  {if(! is_in_char_set(_sJ_,char_of_int(i$1 + 1 | 0)))
                    {print_char(buf,i$1 - 1 | 0);
                     print_char(buf,i$1);
                     var i$4=i$1 + 2 | 0,i=i$4;
                     continue}
                   var j=i$1 + 2 | 0,i$3=i$1 - 1 | 0,j$0=j;
                   for(;;)
                    {if(256 !== j$0 && is_in_char_set(_sJ_,char_of_int(j$0)))
                      {var j$1=j$0 + 1 | 0,j$0=j$1;continue}
                     print_char(buf,i$3);
                     print_char(buf,45);
                     print_char(buf,j$0 - 1 | 0);
                     if(j$0 < 256){var i$7=j$0 + 1 | 0,i=i$7;continue b}
                     break}}}}
             if(is_alone(45))buffer_add_char(buf,45);
             buffer_add_char(buf,93);
             var fmt=rest$19,ign_flag=0;
             continue a}
          case 21:
           var rest$20=fmt[2],counter=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           switch(counter)
            {case 0:var _sK_=108;break;
             case 1:var _sK_=110;break;
             default:var _sK_=78}
           buffer_add_char(buf,_sK_);
           var fmt=rest$20,ign_flag=0;
           continue;
          case 22:
           var rest$21=fmt[1];
           buffer_add_char(buf,37);
           bprint_ignored_flag(buf,ign_flag);
           bprint_string_literal(buf,cst_0c);
           var fmt=rest$21,ign_flag=0;
           continue;
          case 23:
           var
            rest$22=fmt[2],
            ign=fmt[1],
            match$3=param_format_of_ignored_format(ign,rest$22),
            fmt$0=match$3[1],
            fmt=fmt$0,
            ign_flag=1;
           continue;
          default:
           var
            rest$23=fmt[3],
            arity=fmt[1],
            _sM_=int_of_custom_arity(arity),
            _sL_=1;
           if(! (_sM_ < 1))
            {var i$8=_sL_;
             for(;;)
              {buffer_add_char(buf,37);
               bprint_ignored_flag(buf,ign_flag);
               buffer_add_char(buf,63);
               var _sN_=i$8 + 1 | 0;
               if(_sM_ !== i$8){var i$8=_sN_;continue}
               break}}
           var fmt=rest$23,ign_flag=0;
           continue}}
    function symm(param)
     {if(typeof param === "number")
       return 0;
      else
       switch(param[0])
        {case 0:var rest=param[1];return [0,symm(rest)];
         case 1:var rest$0=param[1];return [1,symm(rest$0)];
         case 2:var rest$1=param[1];return [2,symm(rest$1)];
         case 3:var rest$2=param[1];return [3,symm(rest$2)];
         case 4:var rest$3=param[1];return [4,symm(rest$3)];
         case 5:var rest$4=param[1];return [5,symm(rest$4)];
         case 6:var rest$5=param[1];return [6,symm(rest$5)];
         case 7:var rest$6=param[1];return [7,symm(rest$6)];
         case 8:var rest$7=param[2],ty=param[1];return [8,ty,symm(rest$7)];
         case 9:
          var rest$8=param[3],ty2=param[2],ty1=param[1];
          return [9,ty2,ty1,symm(rest$8)];
         case 10:var rest$9=param[1];return [10,symm(rest$9)];
         case 11:var rest$10=param[1];return [11,symm(rest$10)];
         case 12:var rest$11=param[1];return [12,symm(rest$11)];
         case 13:var rest$12=param[1];return [13,symm(rest$12)];
         default:var rest$13=param[1];return [14,symm(rest$13)]}}
    function fmtty_rel_det(param)
     {if(typeof param === "number")
       {var
         _sl_=function(param){return 0},
         _sm_=function(param){return 0},
         _sn_=function(param){return 0};
        return [0,function(param){return 0},_sn_,_sm_,_sl_]}
      else
       switch(param[0])
        {case 0:
          var
           rest=param[1],
           match=fmtty_rel_det(rest),
           de=match[4],
           ed=match[3],
           af=match[2],
           fa=match[1],
           _so_=function(param){caml_call1(af,0);return 0};
          return [0,function(param){caml_call1(fa,0);return 0},_so_,ed,de];
         case 1:
          var
           rest$0=param[1],
           match$0=fmtty_rel_det(rest$0),
           de$0=match$0[4],
           ed$0=match$0[3],
           af$0=match$0[2],
           fa$0=match$0[1],
           _sp_=function(param){caml_call1(af$0,0);return 0};
          return [0,
                  function(param){caml_call1(fa$0,0);return 0},
                  _sp_,
                  ed$0,
                  de$0];
         case 2:
          var
           rest$1=param[1],
           match$1=fmtty_rel_det(rest$1),
           de$1=match$1[4],
           ed$1=match$1[3],
           af$1=match$1[2],
           fa$1=match$1[1],
           _sq_=function(param){caml_call1(af$1,0);return 0};
          return [0,
                  function(param){caml_call1(fa$1,0);return 0},
                  _sq_,
                  ed$1,
                  de$1];
         case 3:
          var
           rest$2=param[1],
           match$2=fmtty_rel_det(rest$2),
           de$2=match$2[4],
           ed$2=match$2[3],
           af$2=match$2[2],
           fa$2=match$2[1],
           _sr_=function(param){caml_call1(af$2,0);return 0};
          return [0,
                  function(param){caml_call1(fa$2,0);return 0},
                  _sr_,
                  ed$2,
                  de$2];
         case 4:
          var
           rest$3=param[1],
           match$3=fmtty_rel_det(rest$3),
           de$3=match$3[4],
           ed$3=match$3[3],
           af$3=match$3[2],
           fa$3=match$3[1],
           _ss_=function(param){caml_call1(af$3,0);return 0};
          return [0,
                  function(param){caml_call1(fa$3,0);return 0},
                  _ss_,
                  ed$3,
                  de$3];
         case 5:
          var
           rest$4=param[1],
           match$4=fmtty_rel_det(rest$4),
           de$4=match$4[4],
           ed$4=match$4[3],
           af$4=match$4[2],
           fa$4=match$4[1],
           _st_=function(param){caml_call1(af$4,0);return 0};
          return [0,
                  function(param){caml_call1(fa$4,0);return 0},
                  _st_,
                  ed$4,
                  de$4];
         case 6:
          var
           rest$5=param[1],
           match$5=fmtty_rel_det(rest$5),
           de$5=match$5[4],
           ed$5=match$5[3],
           af$5=match$5[2],
           fa$5=match$5[1],
           _su_=function(param){caml_call1(af$5,0);return 0};
          return [0,
                  function(param){caml_call1(fa$5,0);return 0},
                  _su_,
                  ed$5,
                  de$5];
         case 7:
          var
           rest$6=param[1],
           match$6=fmtty_rel_det(rest$6),
           de$6=match$6[4],
           ed$6=match$6[3],
           af$6=match$6[2],
           fa$6=match$6[1],
           _sv_=function(param){caml_call1(af$6,0);return 0};
          return [0,
                  function(param){caml_call1(fa$6,0);return 0},
                  _sv_,
                  ed$6,
                  de$6];
         case 8:
          var
           rest$7=param[2],
           match$7=fmtty_rel_det(rest$7),
           de$7=match$7[4],
           ed$7=match$7[3],
           af$7=match$7[2],
           fa$7=match$7[1],
           _sw_=function(param){caml_call1(af$7,0);return 0};
          return [0,
                  function(param){caml_call1(fa$7,0);return 0},
                  _sw_,
                  ed$7,
                  de$7];
         case 9:
          var
           rest$8=param[3],
           ty2=param[2],
           ty1=param[1],
           match$8=fmtty_rel_det(rest$8),
           de$8=match$8[4],
           ed$8=match$8[3],
           af$8=match$8[2],
           fa$8=match$8[1],
           ty=trans(symm(ty1),ty2),
           match$9=fmtty_rel_det(ty),
           jd=match$9[4],
           dj=match$9[3],
           ga=match$9[2],
           ag=match$9[1],
           _sx_=function(param){caml_call1(jd,0);caml_call1(de$8,0);return 0},
           _sy_=function(param){caml_call1(ed$8,0);caml_call1(dj,0);return 0},
           _sz_=function(param){caml_call1(ga,0);caml_call1(af$8,0);return 0};
          return [0,
                  function(param)
                   {caml_call1(fa$8,0);caml_call1(ag,0);return 0},
                  _sz_,
                  _sy_,
                  _sx_];
         case 10:
          var
           rest$9=param[1],
           match$10=fmtty_rel_det(rest$9),
           de$9=match$10[4],
           ed$9=match$10[3],
           af$9=match$10[2],
           fa$9=match$10[1],
           _sA_=function(param){caml_call1(af$9,0);return 0};
          return [0,
                  function(param){caml_call1(fa$9,0);return 0},
                  _sA_,
                  ed$9,
                  de$9];
         case 11:
          var
           rest$10=param[1],
           match$11=fmtty_rel_det(rest$10),
           de$10=match$11[4],
           ed$10=match$11[3],
           af$10=match$11[2],
           fa$10=match$11[1],
           _sB_=function(param){caml_call1(af$10,0);return 0};
          return [0,
                  function(param){caml_call1(fa$10,0);return 0},
                  _sB_,
                  ed$10,
                  de$10];
         case 12:
          var
           rest$11=param[1],
           match$12=fmtty_rel_det(rest$11),
           de$11=match$12[4],
           ed$11=match$12[3],
           af$11=match$12[2],
           fa$11=match$12[1],
           _sC_=function(param){caml_call1(af$11,0);return 0};
          return [0,
                  function(param){caml_call1(fa$11,0);return 0},
                  _sC_,
                  ed$11,
                  de$11];
         case 13:
          var
           rest$12=param[1],
           match$13=fmtty_rel_det(rest$12),
           de$12=match$13[4],
           ed$12=match$13[3],
           af$12=match$13[2],
           fa$12=match$13[1],
           _sD_=function(param){caml_call1(de$12,0);return 0},
           _sE_=function(param){caml_call1(ed$12,0);return 0},
           _sF_=function(param){caml_call1(af$12,0);return 0};
          return [0,
                  function(param){caml_call1(fa$12,0);return 0},
                  _sF_,
                  _sE_,
                  _sD_];
         default:
          var
           rest$13=param[1],
           match$14=fmtty_rel_det(rest$13),
           de$13=match$14[4],
           ed$13=match$14[3],
           af$13=match$14[2],
           fa$13=match$14[1],
           _sG_=function(param){caml_call1(de$13,0);return 0},
           _sH_=function(param){caml_call1(ed$13,0);return 0},
           _sI_=function(param){caml_call1(af$13,0);return 0};
          return [0,
                  function(param){caml_call1(fa$13,0);return 0},
                  _sI_,
                  _sH_,
                  _sG_]}}
    function trans(ty1,match)
     {var switch$0=0;
      if(typeof ty1 === "number")
       if(typeof match === "number")
        return 0;
       else
        switch(match[0])
         {case 10:break;
          case 11:switch$0 = 1;break;
          case 12:switch$0 = 2;break;
          case 13:switch$0 = 3;break;
          case 14:switch$0 = 4;break;
          case 8:switch$0 = 5;break;
          case 9:switch$0 = 6;break;
          default:throw [0,Assert_failure,___]}
      else
       switch(ty1[0])
        {case 0:
          var switch$1=0,_r4_=ty1[1];
          if(typeof match !== "number")
           switch(match[0])
            {case 0:var rest2=match[1];return [0,trans(_r4_,rest2)];
             case 8:switch$0 = 5;switch$1 = 1;break;
             case 9:switch$0 = 6;switch$1 = 1;break;
             case 10:switch$1 = 1;break;
             case 11:switch$0 = 1;switch$1 = 1;break;
             case 12:switch$0 = 2;switch$1 = 1;break;
             case 13:switch$0 = 3;switch$1 = 1;break;
             case 14:switch$0 = 4;switch$1 = 1;break
             }
          if(! switch$1)switch$0 = 7;
          break;
         case 1:
          var switch$2=0,_r5_=ty1[1];
          if(typeof match !== "number")
           switch(match[0])
            {case 1:var rest2$0=match[1];return [1,trans(_r5_,rest2$0)];
             case 8:switch$0 = 5;switch$2 = 1;break;
             case 9:switch$0 = 6;switch$2 = 1;break;
             case 10:switch$2 = 1;break;
             case 11:switch$0 = 1;switch$2 = 1;break;
             case 12:switch$0 = 2;switch$2 = 1;break;
             case 13:switch$0 = 3;switch$2 = 1;break;
             case 14:switch$0 = 4;switch$2 = 1;break
             }
          if(! switch$2)switch$0 = 7;
          break;
         case 2:
          var switch$3=0,_r6_=ty1[1];
          if(typeof match === "number")
           switch$3 = 1;
          else
           switch(match[0])
            {case 2:var rest2$1=match[1];return [2,trans(_r6_,rest2$1)];
             case 8:switch$0 = 5;break;
             case 9:switch$0 = 6;break;
             case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:switch$0 = 4;break;
             default:switch$3 = 1}
          if(switch$3)switch$0 = 7;
          break;
         case 3:
          var switch$4=0,_r7_=ty1[1];
          if(typeof match === "number")
           switch$4 = 1;
          else
           switch(match[0])
            {case 3:var rest2$2=match[1];return [3,trans(_r7_,rest2$2)];
             case 8:switch$0 = 5;break;
             case 9:switch$0 = 6;break;
             case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:switch$0 = 4;break;
             default:switch$4 = 1}
          if(switch$4)switch$0 = 7;
          break;
         case 4:
          var switch$5=0,_r8_=ty1[1];
          if(typeof match === "number")
           switch$5 = 1;
          else
           switch(match[0])
            {case 4:var rest2$3=match[1];return [4,trans(_r8_,rest2$3)];
             case 8:switch$0 = 5;break;
             case 9:switch$0 = 6;break;
             case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:switch$0 = 4;break;
             default:switch$5 = 1}
          if(switch$5)switch$0 = 7;
          break;
         case 5:
          var switch$6=0,_r9_=ty1[1];
          if(typeof match === "number")
           switch$6 = 1;
          else
           switch(match[0])
            {case 5:var rest2$4=match[1];return [5,trans(_r9_,rest2$4)];
             case 8:switch$0 = 5;break;
             case 9:switch$0 = 6;break;
             case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:switch$0 = 4;break;
             default:switch$6 = 1}
          if(switch$6)switch$0 = 7;
          break;
         case 6:
          var switch$7=0,_r__=ty1[1];
          if(typeof match === "number")
           switch$7 = 1;
          else
           switch(match[0])
            {case 6:var rest2$5=match[1];return [6,trans(_r__,rest2$5)];
             case 8:switch$0 = 5;break;
             case 9:switch$0 = 6;break;
             case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:switch$0 = 4;break;
             default:switch$7 = 1}
          if(switch$7)switch$0 = 7;
          break;
         case 7:
          var switch$8=0,_r$_=ty1[1];
          if(typeof match === "number")
           switch$8 = 1;
          else
           switch(match[0])
            {case 7:var rest2$6=match[1];return [7,trans(_r$_,rest2$6)];
             case 8:switch$0 = 5;break;
             case 9:switch$0 = 6;break;
             case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:switch$0 = 4;break;
             default:switch$8 = 1}
          if(switch$8)switch$0 = 7;
          break;
         case 8:
          var switch$9=0,_sa_=ty1[2],_sb_=ty1[1];
          if(typeof match === "number")
           switch$9 = 1;
          else
           switch(match[0])
            {case 8:
              var rest2$7=match[2],ty2=match[1],_sc_=trans(_sa_,rest2$7);
              return [8,trans(_sb_,ty2),_sc_];
             case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:switch$0 = 4;break;
             default:switch$9 = 1}
          if(switch$9)throw [0,Assert_failure,_ah_];
          break;
         case 9:
          var switch$10=0,_sd_=ty1[3],_se_=ty1[2],_sf_=ty1[1];
          if(typeof match === "number")
           switch$10 = 1;
          else
           switch(match[0])
            {case 8:switch$0 = 5;break;
             case 9:
              var
               rest2$8=match[3],
               ty22=match[2],
               ty21=match[1],
               ty=trans(symm(_se_),ty21),
               match$0=fmtty_rel_det(ty),
               f4=match$0[4],
               f2=match$0[2];
              caml_call1(f2,0);
              caml_call1(f4,0);
              return [9,_sf_,ty22,trans(_sd_,rest2$8)];
             case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:switch$0 = 4;break;
             default:switch$10 = 1}
          if(switch$10)throw [0,Assert_failure,_ai_];
          break;
         case 10:
          var _sg_=ty1[1];
          if(typeof match !== "number" && 10 === match[0])
           {var rest2$9=match[1];return [10,trans(_sg_,rest2$9)]}
          throw [0,Assert_failure,_aj_];
         case 11:
          var switch$11=0,_sh_=ty1[1];
          if(typeof match === "number")
           switch$11 = 1;
          else
           switch(match[0])
            {case 10:break;
             case 11:var rest2$10=match[1];return [11,trans(_sh_,rest2$10)];
             default:switch$11 = 1}
          if(switch$11)throw [0,Assert_failure,_ak_];
          break;
         case 12:
          var switch$12=0,_si_=ty1[1];
          if(typeof match === "number")
           switch$12 = 1;
          else
           switch(match[0])
            {case 10:break;
             case 11:switch$0 = 1;break;
             case 12:var rest2$11=match[1];return [12,trans(_si_,rest2$11)];
             default:switch$12 = 1}
          if(switch$12)throw [0,Assert_failure,_al_];
          break;
         case 13:
          var switch$13=0,_sj_=ty1[1];
          if(typeof match === "number")
           switch$13 = 1;
          else
           switch(match[0])
            {case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:var rest2$12=match[1];return [13,trans(_sj_,rest2$12)];
             default:switch$13 = 1}
          if(switch$13)throw [0,Assert_failure,_am_];
          break;
         default:
          var switch$14=0,_sk_=ty1[1];
          if(typeof match === "number")
           switch$14 = 1;
          else
           switch(match[0])
            {case 10:break;
             case 11:switch$0 = 1;break;
             case 12:switch$0 = 2;break;
             case 13:switch$0 = 3;break;
             case 14:var rest2$13=match[1];return [14,trans(_sk_,rest2$13)];
             default:switch$14 = 1}
          if(switch$14)throw [0,Assert_failure,_an_]}
      switch(switch$0)
       {case 0:throw [0,Assert_failure,_ab_];
        case 1:throw [0,Assert_failure,_ac_];
        case 2:throw [0,Assert_failure,_ad_];
        case 3:throw [0,Assert_failure,_ae_];
        case 4:throw [0,Assert_failure,_af_];
        case 5:throw [0,Assert_failure,_$_];
        case 6:throw [0,Assert_failure,_aa_];
        default:throw [0,Assert_failure,_ag_]}}
    function fmtty_of_padding_fmtty(pad,fmtty)
     {return typeof pad === "number"?fmtty:0 === pad[0]?fmtty:[2,fmtty]}
    function fmtty_of_custom(arity,fmtty)
     {if(arity)
       {var arity$0=arity[1];return [12,fmtty_of_custom(arity$0,fmtty)]}
      return fmtty}
    function fmtty_of_fmt(fmtty)
     {var fmtty$0=fmtty;
      for(;;)
       if(typeof fmtty$0 === "number")
        return 0;
       else
        switch(fmtty$0[0])
         {case 0:var rest=fmtty$0[1];return [0,fmtty_of_fmt(rest)];
          case 1:var rest$0=fmtty$0[1];return [0,fmtty_of_fmt(rest$0)];
          case 2:
           var rest$1=fmtty$0[2],pad=fmtty$0[1];
           return fmtty_of_padding_fmtty(pad,[1,fmtty_of_fmt(rest$1)]);
          case 3:
           var rest$2=fmtty$0[2],pad$0=fmtty$0[1];
           return fmtty_of_padding_fmtty(pad$0,[1,fmtty_of_fmt(rest$2)]);
          case 4:
           var
            rest$3=fmtty$0[4],
            prec=fmtty$0[3],
            pad$1=fmtty$0[2],
            ty_rest=fmtty_of_fmt(rest$3),
            prec_ty=fmtty_of_precision_fmtty(prec,[2,ty_rest]);
           return fmtty_of_padding_fmtty(pad$1,prec_ty);
          case 5:
           var
            rest$4=fmtty$0[4],
            prec$0=fmtty$0[3],
            pad$2=fmtty$0[2],
            ty_rest$0=fmtty_of_fmt(rest$4),
            prec_ty$0=fmtty_of_precision_fmtty(prec$0,[3,ty_rest$0]);
           return fmtty_of_padding_fmtty(pad$2,prec_ty$0);
          case 6:
           var
            rest$5=fmtty$0[4],
            prec$1=fmtty$0[3],
            pad$3=fmtty$0[2],
            ty_rest$1=fmtty_of_fmt(rest$5),
            prec_ty$1=fmtty_of_precision_fmtty(prec$1,[4,ty_rest$1]);
           return fmtty_of_padding_fmtty(pad$3,prec_ty$1);
          case 7:
           var
            rest$6=fmtty$0[4],
            prec$2=fmtty$0[3],
            pad$4=fmtty$0[2],
            ty_rest$2=fmtty_of_fmt(rest$6),
            prec_ty$2=fmtty_of_precision_fmtty(prec$2,[5,ty_rest$2]);
           return fmtty_of_padding_fmtty(pad$4,prec_ty$2);
          case 8:
           var
            rest$7=fmtty$0[4],
            prec$3=fmtty$0[3],
            pad$5=fmtty$0[2],
            ty_rest$3=fmtty_of_fmt(rest$7),
            prec_ty$3=fmtty_of_precision_fmtty(prec$3,[6,ty_rest$3]);
           return fmtty_of_padding_fmtty(pad$5,prec_ty$3);
          case 9:
           var rest$8=fmtty$0[2],pad$6=fmtty$0[1];
           return fmtty_of_padding_fmtty(pad$6,[7,fmtty_of_fmt(rest$8)]);
          case 10:var fmtty$1=fmtty$0[1],fmtty$0=fmtty$1;continue;
          case 11:var fmtty$2=fmtty$0[2],fmtty$0=fmtty$2;continue;
          case 12:var fmtty$3=fmtty$0[2],fmtty$0=fmtty$3;continue;
          case 13:
           var rest$9=fmtty$0[3],ty=fmtty$0[2];
           return [8,ty,fmtty_of_fmt(rest$9)];
          case 14:
           var rest$10=fmtty$0[3],ty$0=fmtty$0[2];
           return [9,ty$0,ty$0,fmtty_of_fmt(rest$10)];
          case 15:var rest$11=fmtty$0[1];return [10,fmtty_of_fmt(rest$11)];
          case 16:var rest$12=fmtty$0[1];return [11,fmtty_of_fmt(rest$12)];
          case 17:var fmtty$4=fmtty$0[2],fmtty$0=fmtty$4;continue;
          case 18:
           var
            rest$13=fmtty$0[2],
            fmting_gen=fmtty$0[1],
            _r2_=fmtty_of_fmt(rest$13);
           if(0 === fmting_gen[0])
            var match=fmting_gen[1],fmt=match[1],_r3_=fmtty_of_fmt(fmt);
           else
            var
             match$0=fmting_gen[1],
             fmt$0=match$0[1],
             _r3_=fmtty_of_fmt(fmt$0);
           return concat_fmtty(_r3_,_r2_);
          case 19:var rest$14=fmtty$0[1];return [13,fmtty_of_fmt(rest$14)];
          case 20:var rest$15=fmtty$0[3];return [1,fmtty_of_fmt(rest$15)];
          case 21:var rest$16=fmtty$0[2];return [2,fmtty_of_fmt(rest$16)];
          case 22:var rest$17=fmtty$0[1];return [0,fmtty_of_fmt(rest$17)];
          case 23:
           var rest$18=fmtty$0[2],ign=fmtty$0[1];
           if(typeof ign === "number")
            switch(ign)
             {case 0:var fmtty$0=rest$18;continue;
              case 1:var fmtty$0=rest$18;continue;
              case 2:return [14,fmtty_of_fmt(rest$18)];
              default:var fmtty$0=rest$18;continue}
           else
            switch(ign[0])
             {case 0:var fmtty$0=rest$18;continue;
              case 1:var fmtty$0=rest$18;continue;
              case 2:var fmtty$0=rest$18;continue;
              case 3:var fmtty$0=rest$18;continue;
              case 4:var fmtty$0=rest$18;continue;
              case 5:var fmtty$0=rest$18;continue;
              case 6:var fmtty$0=rest$18;continue;
              case 7:var fmtty$0=rest$18;continue;
              case 8:var fmtty$0=rest$18;continue;
              case 9:
               var fmtty$5=ign[2];
               return concat_fmtty(fmtty$5,fmtty_of_fmt(rest$18));
              case 10:var fmtty$0=rest$18;continue;
              default:var fmtty$0=rest$18;continue}
          default:
           var rest$19=fmtty$0[3],arity=fmtty$0[1];
           return fmtty_of_custom(arity,fmtty_of_fmt(rest$19))}}
    function fmtty_of_precision_fmtty(prec,fmtty)
     {return typeof prec === "number"?prec?[2,fmtty]:fmtty:fmtty}
    var
     Type_mismatch=
      [248,cst_CamlinternalFormat_Type_mi,caml_fresh_oo_id(0)];
    function type_padding(pad,match)
     {if(typeof pad === "number")
       return [0,0,match];
      else
       {if(0 === pad[0])
         {var w=pad[2],padty=pad[1];return [0,[0,padty,w],match]}
        if(typeof match !== "number" && 2 === match[0])
         {var rest=match[1],padty$0=pad[1];return [0,[1,padty$0],rest]}
        throw Type_mismatch}}
    function type_padprec(pad,prec,fmtty)
     {var match=type_padding(pad,fmtty);
      if(typeof prec === "number")
       {if(prec)
         {var _r1_=match[2];
          if(typeof _r1_ !== "number" && 2 === _r1_[0])
           {var rest=_r1_[1],pad$0=match[1];return [0,pad$0,1,rest]}
          throw Type_mismatch}
        var rest$0=match[2],pad$1=match[1];
        return [0,pad$1,0,rest$0]}
      var rest$1=match[2],pad$2=match[1],p=prec[1];
      return [0,pad$2,[0,p],rest$1]}
    function type_format(fmt,fmtty)
     {var _r0_=type_format_gen(fmt,fmtty);
      if(typeof _r0_[2] === "number"){var fmt$0=_r0_[1];return fmt$0}
      throw Type_mismatch}
    function type_ignored_param_one(ign,fmt,fmtty)
     {var match=type_format_gen(fmt,fmtty),fmtty$0=match[2],fmt$0=match[1];
      return [0,[23,ign,fmt$0],fmtty$0]}
    function type_format_gen(fmt,fmtty)
     {if(typeof fmt === "number")
       return [0,0,fmtty];
      else
       switch(fmt[0])
        {case 0:
          if(typeof fmtty !== "number" && 0 === fmtty[0])
           {var
             fmtty_rest=fmtty[1],
             fmt_rest=fmt[1],
             match=type_format_gen(fmt_rest,fmtty_rest),
             fmtty$0=match[2],
             fmt$0=match[1];
            return [0,[0,fmt$0],fmtty$0]}
          break;
         case 1:
          if(typeof fmtty !== "number" && 0 === fmtty[0])
           {var
             fmtty_rest$0=fmtty[1],
             fmt_rest$0=fmt[1],
             match$0=type_format_gen(fmt_rest$0,fmtty_rest$0),
             fmtty$1=match$0[2],
             fmt$1=match$0[1];
            return [0,[1,fmt$1],fmtty$1]}
          break;
         case 2:
          var
           fmt_rest$1=fmt[2],
           pad=fmt[1],
           match$1=type_padding(pad,fmtty),
           _rJ_=match$1[2],
           _rI_=match$1[1];
          if(typeof _rJ_ !== "number" && 1 === _rJ_[0])
           {var
             fmtty_rest$1=_rJ_[1],
             match$2=type_format_gen(fmt_rest$1,fmtty_rest$1),
             fmtty$2=match$2[2],
             fmt$2=match$2[1];
            return [0,[2,_rI_,fmt$2],fmtty$2]}
          throw Type_mismatch;
         case 3:
          var
           fmt_rest$2=fmt[2],
           pad$0=fmt[1],
           match$3=type_padding(pad$0,fmtty),
           _rL_=match$3[2],
           _rK_=match$3[1];
          if(typeof _rL_ !== "number" && 1 === _rL_[0])
           {var
             fmtty_rest$2=_rL_[1],
             match$4=type_format_gen(fmt_rest$2,fmtty_rest$2),
             fmtty$3=match$4[2],
             fmt$3=match$4[1];
            return [0,[3,_rK_,fmt$3],fmtty$3]}
          throw Type_mismatch;
         case 4:
          var
           fmt_rest$3=fmt[4],
           prec=fmt[3],
           pad$1=fmt[2],
           iconv=fmt[1],
           match$5=type_padprec(pad$1,prec,fmtty),
           _rN_=match$5[3],
           _rM_=match$5[1];
          if(typeof _rN_ !== "number" && 2 === _rN_[0])
           {var
             fmtty_rest$3=_rN_[1],
             prec$0=match$5[2],
             match$6=type_format_gen(fmt_rest$3,fmtty_rest$3),
             fmtty$4=match$6[2],
             fmt$4=match$6[1];
            return [0,[4,iconv,_rM_,prec$0,fmt$4],fmtty$4]}
          throw Type_mismatch;
         case 5:
          var
           fmt_rest$4=fmt[4],
           prec$1=fmt[3],
           pad$2=fmt[2],
           iconv$0=fmt[1],
           match$7=type_padprec(pad$2,prec$1,fmtty),
           _rP_=match$7[3],
           _rO_=match$7[1];
          if(typeof _rP_ !== "number" && 3 === _rP_[0])
           {var
             fmtty_rest$4=_rP_[1],
             prec$2=match$7[2],
             match$8=type_format_gen(fmt_rest$4,fmtty_rest$4),
             fmtty$5=match$8[2],
             fmt$5=match$8[1];
            return [0,[5,iconv$0,_rO_,prec$2,fmt$5],fmtty$5]}
          throw Type_mismatch;
         case 6:
          var
           fmt_rest$5=fmt[4],
           prec$3=fmt[3],
           pad$3=fmt[2],
           iconv$1=fmt[1],
           match$9=type_padprec(pad$3,prec$3,fmtty),
           _rR_=match$9[3],
           _rQ_=match$9[1];
          if(typeof _rR_ !== "number" && 4 === _rR_[0])
           {var
             fmtty_rest$5=_rR_[1],
             prec$4=match$9[2],
             match$10=type_format_gen(fmt_rest$5,fmtty_rest$5),
             fmtty$6=match$10[2],
             fmt$6=match$10[1];
            return [0,[6,iconv$1,_rQ_,prec$4,fmt$6],fmtty$6]}
          throw Type_mismatch;
         case 7:
          var
           fmt_rest$6=fmt[4],
           prec$5=fmt[3],
           pad$4=fmt[2],
           iconv$2=fmt[1],
           match$11=type_padprec(pad$4,prec$5,fmtty),
           _rT_=match$11[3],
           _rS_=match$11[1];
          if(typeof _rT_ !== "number" && 5 === _rT_[0])
           {var
             fmtty_rest$6=_rT_[1],
             prec$6=match$11[2],
             match$12=type_format_gen(fmt_rest$6,fmtty_rest$6),
             fmtty$7=match$12[2],
             fmt$7=match$12[1];
            return [0,[7,iconv$2,_rS_,prec$6,fmt$7],fmtty$7]}
          throw Type_mismatch;
         case 8:
          var
           fmt_rest$7=fmt[4],
           prec$7=fmt[3],
           pad$5=fmt[2],
           fconv=fmt[1],
           match$13=type_padprec(pad$5,prec$7,fmtty),
           _rV_=match$13[3],
           _rU_=match$13[1];
          if(typeof _rV_ !== "number" && 6 === _rV_[0])
           {var
             fmtty_rest$7=_rV_[1],
             prec$8=match$13[2],
             match$14=type_format_gen(fmt_rest$7,fmtty_rest$7),
             fmtty$8=match$14[2],
             fmt$8=match$14[1];
            return [0,[8,fconv,_rU_,prec$8,fmt$8],fmtty$8]}
          throw Type_mismatch;
         case 9:
          var
           fmt_rest$8=fmt[2],
           pad$6=fmt[1],
           match$15=type_padding(pad$6,fmtty),
           _rX_=match$15[2],
           _rW_=match$15[1];
          if(typeof _rX_ !== "number" && 7 === _rX_[0])
           {var
             fmtty_rest$8=_rX_[1],
             match$16=type_format_gen(fmt_rest$8,fmtty_rest$8),
             fmtty$9=match$16[2],
             fmt$9=match$16[1];
            return [0,[9,_rW_,fmt$9],fmtty$9]}
          throw Type_mismatch;
         case 10:
          var
           fmt_rest$9=fmt[1],
           match$17=type_format_gen(fmt_rest$9,fmtty),
           fmtty$10=match$17[2],
           fmt$10=match$17[1];
          return [0,[10,fmt$10],fmtty$10];
         case 11:
          var
           fmt_rest$10=fmt[2],
           str=fmt[1],
           match$18=type_format_gen(fmt_rest$10,fmtty),
           fmtty$11=match$18[2],
           fmt$11=match$18[1];
          return [0,[11,str,fmt$11],fmtty$11];
         case 12:
          var
           fmt_rest$11=fmt[2],
           chr=fmt[1],
           match$19=type_format_gen(fmt_rest$11,fmtty),
           fmtty$12=match$19[2],
           fmt$12=match$19[1];
          return [0,[12,chr,fmt$12],fmtty$12];
         case 13:
          if(typeof fmtty !== "number" && 8 === fmtty[0])
           {var
             fmtty_rest$9=fmtty[2],
             sub_fmtty=fmtty[1],
             fmt_rest$12=fmt[3],
             sub_fmtty$0=fmt[2],
             pad_opt=fmt[1];
            if(caml_notequal([0,sub_fmtty$0],[0,sub_fmtty]))
             throw Type_mismatch;
            var
             match$20=type_format_gen(fmt_rest$12,fmtty_rest$9),
             fmtty$13=match$20[2],
             fmt$13=match$20[1];
            return [0,[13,pad_opt,sub_fmtty,fmt$13],fmtty$13]}
          break;
         case 14:
          if(typeof fmtty !== "number" && 9 === fmtty[0])
           {var
             fmtty_rest$10=fmtty[3],
             sub_fmtty1=fmtty[1],
             fmt_rest$13=fmt[3],
             sub_fmtty$1=fmt[2],
             pad_opt$0=fmt[1],
             _rY_=[0,erase_rel(sub_fmtty1)];
            if(caml_notequal([0,erase_rel(sub_fmtty$1)],_rY_))
             throw Type_mismatch;
            var
             match$21=type_format_gen(fmt_rest$13,erase_rel(fmtty_rest$10)),
             fmtty$14=match$21[2],
             fmt$14=match$21[1];
            return [0,[14,pad_opt$0,sub_fmtty1,fmt$14],fmtty$14]}
          break;
         case 15:
          if(typeof fmtty !== "number" && 10 === fmtty[0])
           {var
             fmtty_rest$11=fmtty[1],
             fmt_rest$14=fmt[1],
             match$22=type_format_gen(fmt_rest$14,fmtty_rest$11),
             fmtty$15=match$22[2],
             fmt$15=match$22[1];
            return [0,[15,fmt$15],fmtty$15]}
          break;
         case 16:
          if(typeof fmtty !== "number" && 11 === fmtty[0])
           {var
             fmtty_rest$12=fmtty[1],
             fmt_rest$15=fmt[1],
             match$23=type_format_gen(fmt_rest$15,fmtty_rest$12),
             fmtty$16=match$23[2],
             fmt$16=match$23[1];
            return [0,[16,fmt$16],fmtty$16]}
          break;
         case 17:
          var
           fmt_rest$16=fmt[2],
           formatting_lit=fmt[1],
           match$24=type_format_gen(fmt_rest$16,fmtty),
           fmtty$17=match$24[2],
           fmt$17=match$24[1];
          return [0,[17,formatting_lit,fmt$17],fmtty$17];
         case 18:
          var fmt_rest$17=fmt[2],formatting_gen=fmt[1];
          if(0 === formatting_gen[0])
           {var
             match$28=formatting_gen[1],
             str$0=match$28[2],
             fmt1=match$28[1],
             match$29=type_format_gen(fmt1,fmtty),
             fmtty2=match$29[2],
             fmt2=match$29[1],
             match$30=type_format_gen(fmt_rest$17,fmtty2),
             fmtty3=match$30[2],
             fmt3=match$30[1];
            return [0,[18,[0,[0,fmt2,str$0]],fmt3],fmtty3]}
          var
           match$31=formatting_gen[1],
           str$1=match$31[2],
           fmt1$0=match$31[1],
           match$32=type_format_gen(fmt1$0,fmtty),
           fmtty2$0=match$32[2],
           fmt2$0=match$32[1],
           match$33=type_format_gen(fmt_rest$17,fmtty2$0),
           fmtty3$0=match$33[2],
           fmt3$0=match$33[1];
          return [0,[18,[1,[0,fmt2$0,str$1]],fmt3$0],fmtty3$0];
         case 19:
          if(typeof fmtty !== "number" && 13 === fmtty[0])
           {var
             fmtty_rest$13=fmtty[1],
             fmt_rest$18=fmt[1],
             match$25=type_format_gen(fmt_rest$18,fmtty_rest$13),
             fmtty$18=match$25[2],
             fmt$18=match$25[1];
            return [0,[19,fmt$18],fmtty$18]}
          break;
         case 20:
          if(typeof fmtty !== "number" && 1 === fmtty[0])
           {var
             fmtty_rest$14=fmtty[1],
             fmt_rest$19=fmt[3],
             char_set=fmt[2],
             width_opt=fmt[1],
             match$26=type_format_gen(fmt_rest$19,fmtty_rest$14),
             fmtty$19=match$26[2],
             fmt$19=match$26[1];
            return [0,[20,width_opt,char_set,fmt$19],fmtty$19]}
          break;
         case 21:
          if(typeof fmtty !== "number" && 2 === fmtty[0])
           {var
             fmtty_rest$15=fmtty[1],
             fmt_rest$20=fmt[2],
             counter=fmt[1],
             match$27=type_format_gen(fmt_rest$20,fmtty_rest$15),
             fmtty$20=match$27[2],
             fmt$20=match$27[1];
            return [0,[21,counter,fmt$20],fmtty$20]}
          break;
         case 23:
          var rest=fmt[2],ign=fmt[1];
          if(typeof ign === "number")
           switch(ign)
            {case 0:return type_ignored_param_one(ign,rest,fmtty);
             case 1:return type_ignored_param_one(ign,rest,fmtty);
             case 2:
              if(typeof fmtty !== "number" && 14 === fmtty[0])
               {var
                 fmtty_rest$16=fmtty[1],
                 match$34=type_format_gen(rest,fmtty_rest$16),
                 fmtty$21=match$34[2],
                 fmt$21=match$34[1];
                return [0,[23,2,fmt$21],fmtty$21]}
              throw Type_mismatch;
             default:return type_ignored_param_one(ign,rest,fmtty)}
          else
           switch(ign[0])
            {case 0:return type_ignored_param_one(ign,rest,fmtty);
             case 1:return type_ignored_param_one(ign,rest,fmtty);
             case 2:return type_ignored_param_one(ign,rest,fmtty);
             case 3:return type_ignored_param_one(ign,rest,fmtty);
             case 4:return type_ignored_param_one(ign,rest,fmtty);
             case 5:return type_ignored_param_one(ign,rest,fmtty);
             case 6:return type_ignored_param_one(ign,rest,fmtty);
             case 7:return type_ignored_param_one(ign,rest,fmtty);
             case 8:
              var sub_fmtty$2=ign[2],pad_opt$1=ign[1];
              return type_ignored_param_one
                      ([8,pad_opt$1,sub_fmtty$2],rest,fmtty);
             case 9:
              var
               sub_fmtty$3=ign[2],
               pad_opt$2=ign[1],
               _rZ_=type_ignored_format_substituti(sub_fmtty$3,rest,fmtty),
               match$35=_rZ_[2],
               fmtty$22=match$35[2],
               fmt$22=match$35[1],
               sub_fmtty$4=_rZ_[1];
              return [0,[23,[9,pad_opt$2,sub_fmtty$4],fmt$22],fmtty$22];
             case 10:return type_ignored_param_one(ign,rest,fmtty);
             default:return type_ignored_param_one(ign,rest,fmtty)}
         }
      throw Type_mismatch}
    function type_ignored_format_substituti(sub_fmtty,fmt,match)
     {if(typeof sub_fmtty === "number")
       return [0,0,type_format_gen(fmt,match)];
      else
       switch(sub_fmtty[0])
        {case 0:
          if(typeof match !== "number" && 0 === match[0])
           {var
             fmtty_rest=match[1],
             sub_fmtty_rest=sub_fmtty[1],
             match$0=
              type_ignored_format_substituti(sub_fmtty_rest,fmt,fmtty_rest),
             fmt$0=match$0[2],
             sub_fmtty_rest$0=match$0[1];
            return [0,[0,sub_fmtty_rest$0],fmt$0]}
          break;
         case 1:
          if(typeof match !== "number" && 1 === match[0])
           {var
             fmtty_rest$0=match[1],
             sub_fmtty_rest$1=sub_fmtty[1],
             match$1=
              type_ignored_format_substituti
               (sub_fmtty_rest$1,fmt,fmtty_rest$0),
             fmt$1=match$1[2],
             sub_fmtty_rest$2=match$1[1];
            return [0,[1,sub_fmtty_rest$2],fmt$1]}
          break;
         case 2:
          if(typeof match !== "number" && 2 === match[0])
           {var
             fmtty_rest$1=match[1],
             sub_fmtty_rest$3=sub_fmtty[1],
             match$2=
              type_ignored_format_substituti
               (sub_fmtty_rest$3,fmt,fmtty_rest$1),
             fmt$2=match$2[2],
             sub_fmtty_rest$4=match$2[1];
            return [0,[2,sub_fmtty_rest$4],fmt$2]}
          break;
         case 3:
          if(typeof match !== "number" && 3 === match[0])
           {var
             fmtty_rest$2=match[1],
             sub_fmtty_rest$5=sub_fmtty[1],
             match$3=
              type_ignored_format_substituti
               (sub_fmtty_rest$5,fmt,fmtty_rest$2),
             fmt$3=match$3[2],
             sub_fmtty_rest$6=match$3[1];
            return [0,[3,sub_fmtty_rest$6],fmt$3]}
          break;
         case 4:
          if(typeof match !== "number" && 4 === match[0])
           {var
             fmtty_rest$3=match[1],
             sub_fmtty_rest$7=sub_fmtty[1],
             match$4=
              type_ignored_format_substituti
               (sub_fmtty_rest$7,fmt,fmtty_rest$3),
             fmt$4=match$4[2],
             sub_fmtty_rest$8=match$4[1];
            return [0,[4,sub_fmtty_rest$8],fmt$4]}
          break;
         case 5:
          if(typeof match !== "number" && 5 === match[0])
           {var
             fmtty_rest$4=match[1],
             sub_fmtty_rest$9=sub_fmtty[1],
             match$5=
              type_ignored_format_substituti
               (sub_fmtty_rest$9,fmt,fmtty_rest$4),
             fmt$5=match$5[2],
             sub_fmtty_rest$10=match$5[1];
            return [0,[5,sub_fmtty_rest$10],fmt$5]}
          break;
         case 6:
          if(typeof match !== "number" && 6 === match[0])
           {var
             fmtty_rest$5=match[1],
             sub_fmtty_rest$11=sub_fmtty[1],
             match$6=
              type_ignored_format_substituti
               (sub_fmtty_rest$11,fmt,fmtty_rest$5),
             fmt$6=match$6[2],
             sub_fmtty_rest$12=match$6[1];
            return [0,[6,sub_fmtty_rest$12],fmt$6]}
          break;
         case 7:
          if(typeof match !== "number" && 7 === match[0])
           {var
             fmtty_rest$6=match[1],
             sub_fmtty_rest$13=sub_fmtty[1],
             match$7=
              type_ignored_format_substituti
               (sub_fmtty_rest$13,fmt,fmtty_rest$6),
             fmt$7=match$7[2],
             sub_fmtty_rest$14=match$7[1];
            return [0,[7,sub_fmtty_rest$14],fmt$7]}
          break;
         case 8:
          if(typeof match !== "number" && 8 === match[0])
           {var
             fmtty_rest$7=match[2],
             sub2_fmtty=match[1],
             sub_fmtty_rest$15=sub_fmtty[2],
             sub2_fmtty$0=sub_fmtty[1];
            if(caml_notequal([0,sub2_fmtty$0],[0,sub2_fmtty]))
             throw Type_mismatch;
            var
             match$8=
              type_ignored_format_substituti
               (sub_fmtty_rest$15,fmt,fmtty_rest$7),
             fmt$8=match$8[2],
             sub_fmtty_rest$16=match$8[1];
            return [0,[8,sub2_fmtty,sub_fmtty_rest$16],fmt$8]}
          break;
         case 9:
          if(typeof match !== "number" && 9 === match[0])
           {var
             fmtty_rest$8=match[3],
             sub2_fmtty$1=match[2],
             sub1_fmtty=match[1],
             sub_fmtty_rest$17=sub_fmtty[3],
             sub2_fmtty$2=sub_fmtty[2],
             sub1_fmtty$0=sub_fmtty[1],
             _rG_=[0,erase_rel(sub1_fmtty)];
            if(caml_notequal([0,erase_rel(sub1_fmtty$0)],_rG_))
             throw Type_mismatch;
            var _rH_=[0,erase_rel(sub2_fmtty$1)];
            if(caml_notequal([0,erase_rel(sub2_fmtty$2)],_rH_))
             throw Type_mismatch;
            var
             sub_fmtty$0=trans(symm(sub1_fmtty),sub2_fmtty$1),
             match$9=fmtty_rel_det(sub_fmtty$0),
             f4=match$9[4],
             f2=match$9[2];
            caml_call1(f2,0);
            caml_call1(f4,0);
            var
             match$10=
              type_ignored_format_substituti
               (erase_rel(sub_fmtty_rest$17),fmt,fmtty_rest$8),
             fmt$9=match$10[2],
             sub_fmtty_rest$18=match$10[1];
            return [0,
                    [9,sub1_fmtty,sub2_fmtty$1,symm(sub_fmtty_rest$18)],
                    fmt$9]}
          break;
         case 10:
          if(typeof match !== "number" && 10 === match[0])
           {var
             fmtty_rest$9=match[1],
             sub_fmtty_rest$19=sub_fmtty[1],
             match$11=
              type_ignored_format_substituti
               (sub_fmtty_rest$19,fmt,fmtty_rest$9),
             fmt$10=match$11[2],
             sub_fmtty_rest$20=match$11[1];
            return [0,[10,sub_fmtty_rest$20],fmt$10]}
          break;
         case 11:
          if(typeof match !== "number" && 11 === match[0])
           {var
             fmtty_rest$10=match[1],
             sub_fmtty_rest$21=sub_fmtty[1],
             match$12=
              type_ignored_format_substituti
               (sub_fmtty_rest$21,fmt,fmtty_rest$10),
             fmt$11=match$12[2],
             sub_fmtty_rest$22=match$12[1];
            return [0,[11,sub_fmtty_rest$22],fmt$11]}
          break;
         case 13:
          if(typeof match !== "number" && 13 === match[0])
           {var
             fmtty_rest$11=match[1],
             sub_fmtty_rest$23=sub_fmtty[1],
             match$13=
              type_ignored_format_substituti
               (sub_fmtty_rest$23,fmt,fmtty_rest$11),
             fmt$12=match$13[2],
             sub_fmtty_rest$24=match$13[1];
            return [0,[13,sub_fmtty_rest$24],fmt$12]}
          break;
         case 14:
          if(typeof match !== "number" && 14 === match[0])
           {var
             fmtty_rest$12=match[1],
             sub_fmtty_rest$25=sub_fmtty[1],
             match$14=
              type_ignored_format_substituti
               (sub_fmtty_rest$25,fmt,fmtty_rest$12),
             fmt$13=match$14[2],
             sub_fmtty_rest$26=match$14[1];
            return [0,[14,sub_fmtty_rest$26],fmt$13]}
          break
         }
      throw Type_mismatch}
    function recast(fmt,fmtty){return type_format(fmt,erase_rel(symm(fmtty)))}
    function fix_padding(padty,width,str)
     {var
       len=caml_ml_string_length(str),
       padty$0=0 <= width?padty:0,
       width$0=abs(width);
      if(width$0 <= len)return str;
      var _rF_=2 === padty$0?48:32,res=make(width$0,_rF_);
      switch(padty$0)
       {case 0:blit$0(str,0,res,0,len);break;
        case 1:blit$0(str,0,res,width$0 - len | 0,len);break;
        default:
         var switch$0=0;
         if(0 < len)
          {var switch$1=0;
           if
            (43
             !==
             caml_string_get(str,0)
             &&
             45
             !==
             caml_string_get(str,0)
             &&
             32
             !==
             caml_string_get(str,0))
            {switch$0 = 1;switch$1 = 1}
           if(! switch$1)
            {caml_bytes_set(res,0,caml_string_get(str,0));
             blit$0(str,1,res,(width$0 - len | 0) + 1 | 0,len - 1 | 0)}}
         else
          switch$0 = 1;
         if(switch$0)
          {var switch$2=0;
           if(1 < len && 48 === caml_string_get(str,0))
            {var switch$3=0;
             if
              (120
               !==
               caml_string_get(str,1)
               &&
               88
               !==
               caml_string_get(str,1))
              {switch$2 = 1;switch$3 = 1}
             if(! switch$3)
              {caml_bytes_set(res,1,caml_string_get(str,1));
               blit$0(str,2,res,(width$0 - len | 0) + 2 | 0,len - 2 | 0)}}
           else
            switch$2 = 1;
           if(switch$2)blit$0(str,0,res,width$0 - len | 0,len)}}
      return caml_string_of_bytes(res)}
    function fix_int_precision(prec,str)
     {var
       prec$0=abs(prec),
       len=caml_ml_string_length(str),
       c=caml_string_get(str,0),
       switch$0=0;
      if(58 <= c)
       {if(71 <= c)
         {if(! (5 < (c - 97 | 0) >>> 0))switch$0 = 1}
        else
         if(65 <= c)switch$0 = 1}
      else
       {var switch$1=0;
        if(32 !== c)
         if(43 <= c)
          {var switcher=c - 43 | 0;
           switch(switcher)
            {case 5:
              if(len < (prec$0 + 2 | 0) && 1 < len)
               {var switch$2=0;
                if
                 (120
                  ===
                  caml_string_get(str,1)
                  ||
                  88
                  ===
                  caml_string_get(str,1))
                 switch$2 = 1;
                if(switch$2)
                 {var res$1=make(prec$0 + 2 | 0,48);
                  caml_bytes_set(res$1,1,caml_string_get(str,1));
                  blit$0(str,2,res$1,(prec$0 - len | 0) + 4 | 0,len - 2 | 0);
                  return caml_string_of_bytes(res$1)}}
              switch$0 = 1;
              switch$1 = 1;
              break;
             case 0:
             case 2:break;
             case 1:
             case 3:
             case 4:switch$1 = 1;break;
             default:switch$0 = 1;switch$1 = 1}}
         else
          switch$1 = 1;
        if(! switch$1 && len < (prec$0 + 1 | 0))
         {var res$0=make(prec$0 + 1 | 0,48);
          caml_bytes_set(res$0,0,c);
          blit$0(str,1,res$0,(prec$0 - len | 0) + 2 | 0,len - 1 | 0);
          return caml_string_of_bytes(res$0)}}
      if(switch$0 && len < prec$0)
       {var res=make(prec$0,48);
        blit$0(str,0,res,prec$0 - len | 0,len);
        return caml_string_of_bytes(res)}
      return str}
    function string_to_caml_string(str)
     {var
       str$0=escaped$1(str),
       l=caml_ml_string_length(str$0),
       res=make(l + 2 | 0,34);
      caml_blit_string(str$0,0,res,1,l);
      return caml_string_of_bytes(res)}
    function format_of_fconv(fconv,prec)
     {var
       prec$0=abs(prec),
       symb=char_of_fconv(_ao_,fconv),
       buf=buffer_create(16);
      buffer_add_char(buf,37);
      bprint_fconv_flag(buf,fconv);
      buffer_add_char(buf,46);
      buffer_add_string(buf,caml_string_of_jsbytes("" + prec$0));
      buffer_add_char(buf,symb);
      return buffer_contents(buf)}
    function transform_int_alt(iconv,s)
     {if(13 <= iconv)
       {var n=[0,0],_rA_=caml_ml_string_length(s) - 1 | 0,_rz_=0;
        if(! (_rA_ < 0))
         {var i$0=_rz_;
          for(;;)
           {var match=caml_string_unsafe_get(s,i$0),switcher$0=match - 48 | 0;
            if(! (9 < switcher$0 >>> 0))n[1]++;
            var _rE_=i$0 + 1 | 0;
            if(_rA_ !== i$0){var i$0=_rE_;continue}
            break}}
        var
         digits=n[1],
         buf=
          caml_create_bytes
           (caml_ml_string_length(s) + ((digits - 1 | 0) / 3 | 0) | 0),
         pos=[0,0],
         put=function(c){caml_bytes_set(buf,pos[1],c);pos[1]++;return 0},
         left=[0,((digits - 1 | 0) % 3 | 0) + 1 | 0],
         _rC_=caml_ml_string_length(s) - 1 | 0,
         _rB_=0;
        if(! (_rC_ < 0))
         {var i=_rB_;
          for(;;)
           {var c=caml_string_unsafe_get(s,i),switcher=c - 48 | 0;
            if(9 < switcher >>> 0)
             put(c);
            else
             {if(0 === left[1]){put(95);left[1] = 3}left[1] += -1;put(c)}
            var _rD_=i + 1 | 0;
            if(_rC_ !== i){var i=_rD_;continue}
            break}}
        return caml_string_of_bytes(buf)}
      return s}
    function convert_int(iconv,n)
     {switch(iconv)
       {case 1:var _ry_=cst_d$3;break;
        case 2:var _ry_=cst_d$4;break;
        case 4:var _ry_=cst_i$1;break;
        case 5:var _ry_=cst_i$2;break;
        case 6:var _ry_=cst_x;break;
        case 7:var _ry_=cst_x$0;break;
        case 8:var _ry_=cst_X$0;break;
        case 9:var _ry_=cst_X$1;break;
        case 10:var _ry_=cst_o;break;
        case 11:var _ry_=cst_o$0;break;
        case 0:
        case 13:var _ry_=cst_d$2;break;
        case 3:
        case 14:var _ry_=cst_i$0;break;
        default:var _ry_=cst_u}
      return transform_int_alt(iconv,caml_format_int(_ry_,n))}
    function convert_int32(iconv,n)
     {switch(iconv)
       {case 1:var _rx_=cst_ld$0;break;
        case 2:var _rx_=cst_ld$1;break;
        case 4:var _rx_=cst_li$1;break;
        case 5:var _rx_=cst_li$2;break;
        case 6:var _rx_=cst_lx;break;
        case 7:var _rx_=cst_lx$0;break;
        case 8:var _rx_=cst_lX;break;
        case 9:var _rx_=cst_lX$0;break;
        case 10:var _rx_=cst_lo;break;
        case 11:var _rx_=cst_lo$0;break;
        case 0:
        case 13:var _rx_=cst_ld;break;
        case 3:
        case 14:var _rx_=cst_li$0;break;
        default:var _rx_=cst_lu}
      return transform_int_alt(iconv,caml_format_int(_rx_,n))}
    function convert_nativeint(iconv,n)
     {switch(iconv)
       {case 1:var _rw_=cst_nd$0;break;
        case 2:var _rw_=cst_nd$1;break;
        case 4:var _rw_=cst_ni$1;break;
        case 5:var _rw_=cst_ni$2;break;
        case 6:var _rw_=cst_nx;break;
        case 7:var _rw_=cst_nx$0;break;
        case 8:var _rw_=cst_nX;break;
        case 9:var _rw_=cst_nX$0;break;
        case 10:var _rw_=cst_no;break;
        case 11:var _rw_=cst_no$0;break;
        case 0:
        case 13:var _rw_=cst_nd;break;
        case 3:
        case 14:var _rw_=cst_ni$0;break;
        default:var _rw_=cst_nu}
      return transform_int_alt(iconv,caml_format_int(_rw_,n))}
    function convert_int64(iconv,n)
     {switch(iconv)
       {case 1:var _rv_=cst_Ld$0;break;
        case 2:var _rv_=cst_Ld$1;break;
        case 4:var _rv_=cst_Li$1;break;
        case 5:var _rv_=cst_Li$2;break;
        case 6:var _rv_=cst_Lx;break;
        case 7:var _rv_=cst_Lx$0;break;
        case 8:var _rv_=cst_LX;break;
        case 9:var _rv_=cst_LX$0;break;
        case 10:var _rv_=cst_Lo;break;
        case 11:var _rv_=cst_Lo$0;break;
        case 0:
        case 13:var _rv_=cst_Ld;break;
        case 3:
        case 14:var _rv_=cst_Li$0;break;
        default:var _rv_=cst_Lu}
      return transform_int_alt(iconv,caml_int64_format(_rv_,n))}
    function convert_float(fconv,prec,x)
     {function hex(param)
       {switch(fconv[1])
         {case 0:var sign=45;break;
          case 1:var sign=43;break;
          default:var sign=32}
        return runtime.caml_hexstring_of_float(x,prec,sign)}
      function caml_special_val(str)
       {var match=runtime.caml_classify_float(x);
        return 3 === match
                ?x < 0.?cst_neg_infinity:cst_infinity
                :4 <= match?cst_nan:str}
      switch(fconv[2])
       {case 5:
         var
          str=caml_format_float(format_of_fconv(fconv,prec),x),
          len=caml_ml_string_length(str),
          i=0;
         for(;;)
          {if(i === len)
            var _rt_=0;
           else
            {var match=caml_string_get(str,i),_rs_=match - 46 | 0,switch$0=0;
             if(23 < _rs_ >>> 0)
              {if(55 === _rs_)switch$0 = 1}
             else
              if(21 < (_rs_ - 1 | 0) >>> 0)switch$0 = 1;
             if(! switch$0){var i$0=i + 1 | 0,i=i$0;continue}
             var _rt_=1}
           var _ru_=_rt_?str:symbol(str,cst$29);
           return caml_special_val(_ru_)}
        case 6:return hex(0);
        case 7:return uppercase_ascii$1(hex(0));
        case 8:return caml_special_val(hex(0));
        default:return caml_format_float(format_of_fconv(fconv,prec),x)}}
    function string_of_fmtty(fmtty)
     {var buf=buffer_create(16);
      bprint_fmtty(buf,fmtty);
      return buffer_contents(buf)}
    function make_int_padding_precision(k,acc,fmt,pad,match,trans,iconv)
     {if(typeof pad === "number")
       {if(typeof match === "number")
         return match
                 ?function(p,x)
                   {var str=fix_int_precision(p,caml_call2(trans,iconv,x));
                    return make_printf(k,[4,acc,str],fmt)}
                 :function(x)
                   {var str=caml_call2(trans,iconv,x);
                    return make_printf(k,[4,acc,str],fmt)};
        var p=match[1];
        return function(x)
         {var str=fix_int_precision(p,caml_call2(trans,iconv,x));
          return make_printf(k,[4,acc,str],fmt)}}
      else
       {if(0 === pad[0])
         {var _rp_=pad[2],_rq_=pad[1];
          if(typeof match === "number")
           return match
                   ?function(p,x)
                     {var
                       str=
                        fix_padding
                         (_rq_,_rp_,fix_int_precision(p,caml_call2(trans,iconv,x)));
                      return make_printf(k,[4,acc,str],fmt)}
                   :function(x)
                     {var str=fix_padding(_rq_,_rp_,caml_call2(trans,iconv,x));
                      return make_printf(k,[4,acc,str],fmt)};
          var p$0=match[1];
          return function(x)
           {var
             str=
              fix_padding
               (_rq_,_rp_,fix_int_precision(p$0,caml_call2(trans,iconv,x)));
            return make_printf(k,[4,acc,str],fmt)}}
        var _rr_=pad[1];
        if(typeof match === "number")
         return match
                 ?function(w,p,x)
                   {var
                     str=
                      fix_padding
                       (_rr_,w,fix_int_precision(p,caml_call2(trans,iconv,x)));
                    return make_printf(k,[4,acc,str],fmt)}
                 :function(w,x)
                   {var str=fix_padding(_rr_,w,caml_call2(trans,iconv,x));
                    return make_printf(k,[4,acc,str],fmt)};
        var p$1=match[1];
        return function(w,x)
         {var
           str=
            fix_padding
             (_rr_,w,fix_int_precision(p$1,caml_call2(trans,iconv,x)));
          return make_printf(k,[4,acc,str],fmt)}}}
    function make_padding(k,acc,fmt,pad,trans)
     {if(typeof pad === "number")
       return function(x)
        {var new_acc=[4,acc,caml_call1(trans,x)];
         return make_printf(k,new_acc,fmt)};
      else
       {if(0 === pad[0])
         {var width=pad[2],padty=pad[1];
          return function(x)
           {var new_acc=[4,acc,fix_padding(padty,width,caml_call1(trans,x))];
            return make_printf(k,new_acc,fmt)}}
        var padty$0=pad[1];
        return function(w,x)
         {var new_acc=[4,acc,fix_padding(padty$0,w,caml_call1(trans,x))];
          return make_printf(k,new_acc,fmt)}}}
    function make_printf$0(counter,k,acc,fmt)
     {var k$0=k,acc$0=acc,fmt$0=fmt;
      for(;;)
       if(typeof fmt$0 === "number")
        return caml_call1(k$0,acc$0);
       else
        switch(fmt$0[0])
         {case 0:
           var rest=fmt$0[1];
           return function(c)
            {var new_acc=[5,acc$0,c];return make_printf(k$0,new_acc,rest)};
          case 1:
           var rest$0=fmt$0[1];
           return function(c)
            {var
              str=escaped(c),
              l=caml_ml_string_length(str),
              res=make(l + 2 | 0,39);
             caml_blit_string(str,0,res,1,l);
             var new_acc=[4,acc$0,caml_string_of_bytes(res)];
             return make_printf(k$0,new_acc,rest$0)};
          case 2:
           var rest$1=fmt$0[2],pad=fmt$0[1];
           return make_padding(k$0,acc$0,rest$1,pad,function(str){return str});
          case 3:
           var rest$2=fmt$0[2],pad$0=fmt$0[1];
           return make_padding(k$0,acc$0,rest$2,pad$0,string_to_caml_string);
          case 4:
           var rest$3=fmt$0[4],prec=fmt$0[3],pad$1=fmt$0[2],iconv=fmt$0[1];
           return make_int_padding_precision
                   (k$0,acc$0,rest$3,pad$1,prec,convert_int,iconv);
          case 5:
           var
            rest$4=fmt$0[4],
            prec$0=fmt$0[3],
            pad$2=fmt$0[2],
            iconv$0=fmt$0[1];
           return make_int_padding_precision
                   (k$0,acc$0,rest$4,pad$2,prec$0,convert_int32,iconv$0);
          case 6:
           var
            rest$5=fmt$0[4],
            prec$1=fmt$0[3],
            pad$3=fmt$0[2],
            iconv$1=fmt$0[1];
           return make_int_padding_precision
                   (k$0,acc$0,rest$5,pad$3,prec$1,convert_nativeint,iconv$1);
          case 7:
           var
            rest$6=fmt$0[4],
            prec$2=fmt$0[3],
            pad$4=fmt$0[2],
            iconv$2=fmt$0[1];
           return make_int_padding_precision
                   (k$0,acc$0,rest$6,pad$4,prec$2,convert_int64,iconv$2);
          case 8:
           var rest$7=fmt$0[4],prec$3=fmt$0[3],pad$5=fmt$0[2],fconv=fmt$0[1];
           if(typeof pad$5 === "number")
            {if(typeof prec$3 === "number")
              return prec$3
                      ?function(p,x)
                        {var str=convert_float(fconv,p,x);
                         return make_printf(k$0,[4,acc$0,str],rest$7)}
                      :function(x)
                        {var
                          str=
                           convert_float(fconv,default_float_precision(fconv),x);
                         return make_printf(k$0,[4,acc$0,str],rest$7)};
             var p=prec$3[1];
             return function(x)
              {var str=convert_float(fconv,p,x);
               return make_printf(k$0,[4,acc$0,str],rest$7)}}
           else
            {if(0 === pad$5[0])
              {var _rm_=pad$5[2],_rn_=pad$5[1];
               if(typeof prec$3 === "number")
                return prec$3
                        ?function(p,x)
                          {var str=fix_padding(_rn_,_rm_,convert_float(fconv,p,x));
                           return make_printf(k$0,[4,acc$0,str],rest$7)}
                        :function(x)
                          {var
                            str=convert_float(fconv,default_float_precision(fconv),x),
                            str$0=fix_padding(_rn_,_rm_,str);
                           return make_printf(k$0,[4,acc$0,str$0],rest$7)};
               var p$0=prec$3[1];
               return function(x)
                {var str=fix_padding(_rn_,_rm_,convert_float(fconv,p$0,x));
                 return make_printf(k$0,[4,acc$0,str],rest$7)}}
             var _ro_=pad$5[1];
             if(typeof prec$3 === "number")
              return prec$3
                      ?function(w,p,x)
                        {var str=fix_padding(_ro_,w,convert_float(fconv,p,x));
                         return make_printf(k$0,[4,acc$0,str],rest$7)}
                      :function(w,x)
                        {var
                          str=convert_float(fconv,default_float_precision(fconv),x),
                          str$0=fix_padding(_ro_,w,str);
                         return make_printf(k$0,[4,acc$0,str$0],rest$7)};
             var p$1=prec$3[1];
             return function(w,x)
              {var str=fix_padding(_ro_,w,convert_float(fconv,p$1,x));
               return make_printf(k$0,[4,acc$0,str],rest$7)}}
          case 9:
           var rest$8=fmt$0[2],pad$6=fmt$0[1];
           return make_padding(k$0,acc$0,rest$8,pad$6,string_of_bool);
          case 10:
           var fmt$1=fmt$0[1],acc$1=[7,acc$0],acc$0=acc$1,fmt$0=fmt$1;
           continue;
          case 11:
           var
            fmt$2=fmt$0[2],
            str=fmt$0[1],
            acc$2=[2,acc$0,str],
            acc$0=acc$2,
            fmt$0=fmt$2;
           continue;
          case 12:
           var
            fmt$3=fmt$0[2],
            chr=fmt$0[1],
            acc$3=[3,acc$0,chr],
            acc$0=acc$3,
            fmt$0=fmt$3;
           continue;
          case 13:
           var
            rest$9=fmt$0[3],
            sub_fmtty=fmt$0[2],
            ty=string_of_fmtty(sub_fmtty);
           return function(str){return make_printf(k$0,[4,acc$0,ty],rest$9)};
          case 14:
           var rest$10=fmt$0[3],fmtty=fmt$0[2];
           return function(param)
            {var fmt=param[1];
             return make_printf
                     (k$0,acc$0,concat_fmt(recast(fmt,fmtty),rest$10))};
          case 15:
           var rest$11=fmt$0[1];
           return function(f,x)
            {return make_printf
                     (k$0,
                      [6,acc$0,function(o){return caml_call2(f,o,x)}],
                      rest$11)};
          case 16:
           var rest$12=fmt$0[1];
           return function(f){return make_printf(k$0,[6,acc$0,f],rest$12)};
          case 17:
           var
            fmt$4=fmt$0[2],
            fmting_lit=fmt$0[1],
            acc$4=[0,acc$0,fmting_lit],
            acc$0=acc$4,
            fmt$0=fmt$4;
           continue;
          case 18:
           var _rk_=fmt$0[1];
           if(0 === _rk_[0])
            {var
              rest$13=fmt$0[2],
              match=_rk_[1],
              fmt$5=match[1],
              k$3=
               function(acc,k,rest)
                {function k$0(kacc)
                  {return make_printf(k,[1,acc,[0,kacc]],rest)}
                 return k$0},
              k$1=k$3(acc$0,k$0,rest$13),
              k$0=k$1,
              acc$0=0,
              fmt$0=fmt$5;
             continue}
           var
            rest$14=fmt$0[2],
            match$0=_rk_[1],
            fmt$6=match$0[1],
            k$4=
             function(acc,k,rest)
              {function k$0(kacc){return make_printf(k,[1,acc,[1,kacc]],rest)}
               return k$0},
            k$2=k$4(acc$0,k$0,rest$14),
            k$0=k$2,
            acc$0=0,
            fmt$0=fmt$6;
           continue;
          case 19:throw [0,Assert_failure,_ap_];
          case 20:
           var rest$15=fmt$0[3],new_acc=[8,acc$0,cst_Printf_bad_conversion];
           return function(param){return make_printf(k$0,new_acc,rest$15)};
          case 21:
           var rest$16=fmt$0[2];
           return function(n)
            {var new_acc=[4,acc$0,caml_format_int(cst_u$0,n)];
             return make_printf(k$0,new_acc,rest$16)};
          case 22:
           var rest$17=fmt$0[1];
           return function(c)
            {var new_acc=[5,acc$0,c];return make_printf(k$0,new_acc,rest$17)};
          case 23:
           var rest$18=fmt$0[2],ign=fmt$0[1];
           if(counter < 50)
            {var counter$1=counter + 1 | 0;
             return make_ignored_param$0(counter$1,k$0,acc$0,ign,rest$18)}
           return caml_trampoline_return
                   (make_ignored_param$0,[0,k$0,acc$0,ign,rest$18]);
          default:
           var
            rest$19=fmt$0[3],
            f=fmt$0[2],
            arity=fmt$0[1],
            _rl_=caml_call1(f,0);
           if(counter < 50)
            {var counter$0=counter + 1 | 0;
             return make_custom$0(counter$0,k$0,acc$0,rest$19,arity,_rl_)}
           return caml_trampoline_return
                   (make_custom$0,[0,k$0,acc$0,rest$19,arity,_rl_])}}
    function make_ignored_param$0(counter,k,acc,ign,fmt)
     {if(typeof ign === "number")
       switch(ign)
        {case 0:
          if(counter < 50)
           {var counter$0=counter + 1 | 0;
            return make_invalid_arg(counter$0,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 1:
          if(counter < 50)
           {var counter$1=counter + 1 | 0;
            return make_invalid_arg(counter$1,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 2:throw [0,Assert_failure,_aq_];
         default:
          if(counter < 50)
           {var counter$2=counter + 1 | 0;
            return make_invalid_arg(counter$2,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt])}
      else
       switch(ign[0])
        {case 0:
          if(counter < 50)
           {var counter$3=counter + 1 | 0;
            return make_invalid_arg(counter$3,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 1:
          if(counter < 50)
           {var counter$4=counter + 1 | 0;
            return make_invalid_arg(counter$4,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 2:
          if(counter < 50)
           {var counter$5=counter + 1 | 0;
            return make_invalid_arg(counter$5,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 3:
          if(counter < 50)
           {var counter$6=counter + 1 | 0;
            return make_invalid_arg(counter$6,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 4:
          if(counter < 50)
           {var counter$7=counter + 1 | 0;
            return make_invalid_arg(counter$7,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 5:
          if(counter < 50)
           {var counter$8=counter + 1 | 0;
            return make_invalid_arg(counter$8,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 6:
          if(counter < 50)
           {var counter$9=counter + 1 | 0;
            return make_invalid_arg(counter$9,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 7:
          if(counter < 50)
           {var counter$10=counter + 1 | 0;
            return make_invalid_arg(counter$10,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 8:
          if(counter < 50)
           {var counter$11=counter + 1 | 0;
            return make_invalid_arg(counter$11,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         case 9:
          var fmtty=ign[2];
          if(counter < 50)
           {var counter$14=counter + 1 | 0;
            return make_from_fmtty$0(counter$14,k,acc,fmtty,fmt)}
          return caml_trampoline_return(make_from_fmtty$0,[0,k,acc,fmtty,fmt]);
         case 10:
          if(counter < 50)
           {var counter$12=counter + 1 | 0;
            return make_invalid_arg(counter$12,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt]);
         default:
          if(counter < 50)
           {var counter$13=counter + 1 | 0;
            return make_invalid_arg(counter$13,k,acc,fmt)}
          return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt])}}
    function make_from_fmtty$0(counter,k,acc,fmtty,fmt)
     {if(typeof fmtty === "number")
       {if(counter < 50)
         {var counter$0=counter + 1 | 0;
          return make_invalid_arg(counter$0,k,acc,fmt)}
        return caml_trampoline_return(make_invalid_arg,[0,k,acc,fmt])}
      else
       switch(fmtty[0])
        {case 0:
          var rest=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest,fmt)};
         case 1:
          var rest$0=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$0,fmt)};
         case 2:
          var rest$1=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$1,fmt)};
         case 3:
          var rest$2=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$2,fmt)};
         case 4:
          var rest$3=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$3,fmt)};
         case 5:
          var rest$4=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$4,fmt)};
         case 6:
          var rest$5=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$5,fmt)};
         case 7:
          var rest$6=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$6,fmt)};
         case 8:
          var rest$7=fmtty[2];
          return function(param){return make_from_fmtty(k,acc,rest$7,fmt)};
         case 9:
          var
           rest$8=fmtty[3],
           ty2=fmtty[2],
           ty1=fmtty[1],
           ty=trans(symm(ty1),ty2);
          return function(param)
           {return make_from_fmtty(k,acc,concat_fmtty(ty,rest$8),fmt)};
         case 10:
          var rest$9=fmtty[1];
          return function(param,_rj_)
           {return make_from_fmtty(k,acc,rest$9,fmt)};
         case 11:
          var rest$10=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$10,fmt)};
         case 12:
          var rest$11=fmtty[1];
          return function(param){return make_from_fmtty(k,acc,rest$11,fmt)};
         case 13:throw [0,Assert_failure,_ar_];
         default:throw [0,Assert_failure,_as_]}}
    function make_invalid_arg(counter,k,acc,fmt)
     {var _ri_=[8,acc,cst_Printf_bad_conversion$0];
      if(counter < 50)
       {var counter$0=counter + 1 | 0;
        return make_printf$0(counter$0,k,_ri_,fmt)}
      return caml_trampoline_return(make_printf$0,[0,k,_ri_,fmt])}
    function make_custom$0(counter,k,acc,rest,arity,f)
     {if(arity)
       {var arity$0=arity[1];
        return function(x)
         {return make_custom(k,acc,rest,arity$0,caml_call1(f,x))}}
      var _rh_=[4,acc,f];
      if(counter < 50)
       {var counter$0=counter + 1 | 0;
        return make_printf$0(counter$0,k,_rh_,rest)}
      return caml_trampoline_return(make_printf$0,[0,k,_rh_,rest])}
    function make_printf(k,acc,fmt)
     {return caml_trampoline(make_printf$0(0,k,acc,fmt))}
    function make_ignored_param(k,acc,ign,fmt)
     {return caml_trampoline(make_ignored_param$0(0,k,acc,ign,fmt))}
    function make_from_fmtty(k,acc,fmtty,fmt)
     {return caml_trampoline(make_from_fmtty$0(0,k,acc,fmtty,fmt))}
    function make_custom(k,acc,rest,arity,f)
     {return caml_trampoline(make_custom$0(0,k,acc,rest,arity,f))}
    function fn_of_padding_precision(k,o,fmt,pad,prec)
     {if(typeof pad === "number")
       {if(typeof prec === "number")
         {if(prec)
           {var _qP_=make_iprintf(k,o,fmt),_qQ_=function(_q7_){return _qP_};
            return function(_q6_){return _qQ_}}
          var _qR_=make_iprintf(k,o,fmt);
          return function(_q5_){return _qR_}}
        var _qS_=make_iprintf(k,o,fmt);
        return function(_q4_){return _qS_}}
      else
       {if(0 === pad[0])
         {if(typeof prec === "number")
           {if(prec)
             {var _qT_=make_iprintf(k,o,fmt),_qU_=function(_rg_){return _qT_};
              return function(_rf_){return _qU_}}
            var _qV_=make_iprintf(k,o,fmt);
            return function(_re_){return _qV_}}
          var _qW_=make_iprintf(k,o,fmt);
          return function(_rd_){return _qW_}}
        if(typeof prec === "number")
         {if(prec)
           {var
             _qX_=make_iprintf(k,o,fmt),
             _qY_=function(_rc_){return _qX_},
             _qZ_=function(_rb_){return _qY_};
            return function(_ra_){return _qZ_}}
          var _q0_=make_iprintf(k,o,fmt),_q1_=function(_q$_){return _q0_};
          return function(_q__){return _q1_}}
        var _q2_=make_iprintf(k,o,fmt),_q3_=function(_q9_){return _q2_};
        return function(_q8_){return _q3_}}}
    function make_iprintf$0(counter,k,o,fmt)
     {var k$0=k,fmt$0=fmt;
      for(;;)
       if(typeof fmt$0 === "number")
        return caml_call1(k$0,o);
       else
        switch(fmt$0[0])
         {case 0:
           var rest=fmt$0[1],_p6_=make_iprintf(k$0,o,rest);
           return function(_qO_){return _p6_};
          case 1:
           var rest$0=fmt$0[1],_p7_=make_iprintf(k$0,o,rest$0);
           return function(_qN_){return _p7_};
          case 2:
           var _p8_=fmt$0[1];
           if(typeof _p8_ === "number")
            {var rest$1=fmt$0[2],_p9_=make_iprintf(k$0,o,rest$1);
             return function(_qJ_){return _p9_}}
           else
            {if(0 === _p8_[0])
              {var rest$2=fmt$0[2],_p__=make_iprintf(k$0,o,rest$2);
               return function(_qM_){return _p__}}
             var
              rest$3=fmt$0[2],
              _p$_=make_iprintf(k$0,o,rest$3),
              _qa_=function(_qL_){return _p$_};
             return function(_qK_){return _qa_}}
          case 3:
           var _qb_=fmt$0[1];
           if(typeof _qb_ === "number")
            {var rest$4=fmt$0[2],_qc_=make_iprintf(k$0,o,rest$4);
             return function(_qF_){return _qc_}}
           else
            {if(0 === _qb_[0])
              {var rest$5=fmt$0[2],_qd_=make_iprintf(k$0,o,rest$5);
               return function(_qI_){return _qd_}}
             var
              rest$6=fmt$0[2],
              _qe_=make_iprintf(k$0,o,rest$6),
              _qf_=function(_qH_){return _qe_};
             return function(_qG_){return _qf_}}
          case 4:
           var rest$7=fmt$0[4],prec=fmt$0[3],pad=fmt$0[2];
           return fn_of_padding_precision(k$0,o,rest$7,pad,prec);
          case 5:
           var rest$8=fmt$0[4],prec$0=fmt$0[3],pad$0=fmt$0[2];
           return fn_of_padding_precision(k$0,o,rest$8,pad$0,prec$0);
          case 6:
           var rest$9=fmt$0[4],prec$1=fmt$0[3],pad$1=fmt$0[2];
           return fn_of_padding_precision(k$0,o,rest$9,pad$1,prec$1);
          case 7:
           var rest$10=fmt$0[4],prec$2=fmt$0[3],pad$2=fmt$0[2];
           return fn_of_padding_precision(k$0,o,rest$10,pad$2,prec$2);
          case 8:
           var rest$11=fmt$0[4],prec$3=fmt$0[3],pad$3=fmt$0[2];
           return fn_of_padding_precision(k$0,o,rest$11,pad$3,prec$3);
          case 9:
           var _qg_=fmt$0[1];
           if(typeof _qg_ === "number")
            {var rest$12=fmt$0[2],_qh_=make_iprintf(k$0,o,rest$12);
             return function(_qB_){return _qh_}}
           else
            {if(0 === _qg_[0])
              {var rest$13=fmt$0[2],_qi_=make_iprintf(k$0,o,rest$13);
               return function(_qE_){return _qi_}}
             var
              rest$14=fmt$0[2],
              _qj_=make_iprintf(k$0,o,rest$14),
              _qk_=function(_qD_){return _qj_};
             return function(_qC_){return _qk_}}
          case 10:var fmt$1=fmt$0[1],fmt$0=fmt$1;continue;
          case 11:var fmt$2=fmt$0[2],fmt$0=fmt$2;continue;
          case 12:var fmt$3=fmt$0[2],fmt$0=fmt$3;continue;
          case 13:
           var rest$15=fmt$0[3],_ql_=make_iprintf(k$0,o,rest$15);
           return function(_qA_){return _ql_};
          case 14:
           var rest$16=fmt$0[3],fmtty=fmt$0[2];
           return function(param)
            {var fmt=param[1];
             return make_iprintf(k$0,o,concat_fmt(recast(fmt,fmtty),rest$16))};
          case 15:
           var
            rest$17=fmt$0[1],
            _qm_=make_iprintf(k$0,o,rest$17),
            _qn_=function(_qz_){return _qm_};
           return function(_qy_){return _qn_};
          case 16:
           var rest$18=fmt$0[1],_qo_=make_iprintf(k$0,o,rest$18);
           return function(_qx_){return _qo_};
          case 17:var fmt$4=fmt$0[2],fmt$0=fmt$4;continue;
          case 18:
           var _qp_=fmt$0[1];
           if(0 === _qp_[0])
            {var
              rest$19=fmt$0[2],
              match=_qp_[1],
              fmt$5=match[1],
              k$3=
               function(k,rest)
                {function k$0(koc){return make_iprintf(k,koc,rest)}return k$0},
              k$1=k$3(k$0,rest$19),
              k$0=k$1,
              fmt$0=fmt$5;
             continue}
           var
            rest$20=fmt$0[2],
            match$0=_qp_[1],
            fmt$6=match$0[1],
            k$4=
             function(k,rest)
              {function k$0(koc){return make_iprintf(k,koc,rest)}return k$0},
            k$2=k$4(k$0,rest$20),
            k$0=k$2,
            fmt$0=fmt$6;
           continue;
          case 19:throw [0,Assert_failure,_at_];
          case 20:
           var rest$21=fmt$0[3],_qq_=make_iprintf(k$0,o,rest$21);
           return function(_qw_){return _qq_};
          case 21:
           var rest$22=fmt$0[2],_qr_=make_iprintf(k$0,o,rest$22);
           return function(_qv_){return _qr_};
          case 22:
           var rest$23=fmt$0[1],_qs_=make_iprintf(k$0,o,rest$23);
           return function(_qu_){return _qs_};
          case 23:
           var rest$24=fmt$0[2],ign=fmt$0[1],_qt_=0;
           return make_ignored_param
                   (function(param){return caml_call1(k$0,o)},_qt_,ign,rest$24);
          default:
           var rest$25=fmt$0[3],arity=fmt$0[1];
           if(counter < 50)
            {var counter$0=counter + 1 | 0;
             return fn_of_custom_arity$0(counter$0,k$0,o,rest$25,arity)}
           return caml_trampoline_return
                   (fn_of_custom_arity$0,[0,k$0,o,rest$25,arity])}}
    function fn_of_custom_arity$0(counter,k,o,fmt,param)
     {if(param)
       {var arity=param[1],_p4_=fn_of_custom_arity(k,o,fmt,arity);
        return function(_p5_){return _p4_}}
      if(counter < 50)
       {var counter$0=counter + 1 | 0;
        return make_iprintf$0(counter$0,k,o,fmt)}
      return caml_trampoline_return(make_iprintf$0,[0,k,o,fmt])}
    function make_iprintf(k,o,fmt)
     {return caml_trampoline(make_iprintf$0(0,k,o,fmt))}
    function fn_of_custom_arity(k,o,fmt,param)
     {return caml_trampoline(fn_of_custom_arity$0(0,k,o,fmt,param))}
    function output_acc(o,acc)
     {var acc$0=acc;
      for(;;)
       if(typeof acc$0 === "number")
        return 0;
       else
        switch(acc$0[0])
         {case 0:
           var
            fmting_lit=acc$0[2],
            p=acc$0[1],
            s=string_of_formatting_lit(fmting_lit);
           output_acc(o,p);
           return output_string(o,s);
          case 1:
           var _p2_=acc$0[2],_p3_=acc$0[1];
           if(0 === _p2_[0])
            {var acc$1=_p2_[1];
             output_acc(o,_p3_);
             output_string(o,cst$30);
             var acc$0=acc$1;
             continue}
           var acc$2=_p2_[1];
           output_acc(o,_p3_);
           output_string(o,cst$31);
           var acc$0=acc$2;
           continue;
          case 6:
           var f=acc$0[2],p$2=acc$0[1];
           output_acc(o,p$2);
           return caml_call1(f,o);
          case 7:var p$3=acc$0[1];output_acc(o,p$3);return caml_ml_flush(o);
          case 8:
           var msg=acc$0[2],p$4=acc$0[1];
           output_acc(o,p$4);
           return invalid_arg(msg);
          case 2:
          case 4:
           var s$0=acc$0[2],p$0=acc$0[1];
           output_acc(o,p$0);
           return output_string(o,s$0);
          default:
           var c=acc$0[2],p$1=acc$0[1];
           output_acc(o,p$1);
           return caml_ml_output_char(o,c)}}
    function bufput_acc(b,acc)
     {var acc$0=acc;
      for(;;)
       if(typeof acc$0 === "number")
        return 0;
       else
        switch(acc$0[0])
         {case 0:
           var
            fmting_lit=acc$0[2],
            p=acc$0[1],
            s=string_of_formatting_lit(fmting_lit);
           bufput_acc(b,p);
           return add_string(b,s);
          case 1:
           var _p0_=acc$0[2],_p1_=acc$0[1];
           if(0 === _p0_[0])
            {var acc$1=_p0_[1];
             bufput_acc(b,_p1_);
             add_string(b,cst$32);
             var acc$0=acc$1;
             continue}
           var acc$2=_p0_[1];
           bufput_acc(b,_p1_);
           add_string(b,cst$33);
           var acc$0=acc$2;
           continue;
          case 6:
           var f=acc$0[2],p$2=acc$0[1];
           bufput_acc(b,p$2);
           return caml_call1(f,b);
          case 7:var acc$3=acc$0[1],acc$0=acc$3;continue;
          case 8:
           var msg=acc$0[2],p$3=acc$0[1];
           bufput_acc(b,p$3);
           return invalid_arg(msg);
          case 2:
          case 4:
           var s$0=acc$0[2],p$0=acc$0[1];
           bufput_acc(b,p$0);
           return add_string(b,s$0);
          default:
           var c=acc$0[2],p$1=acc$0[1];bufput_acc(b,p$1);return add_char(b,c)}}
    function strput_acc(b,acc)
     {var acc$0=acc;
      for(;;)
       if(typeof acc$0 === "number")
        return 0;
       else
        switch(acc$0[0])
         {case 0:
           var
            fmting_lit=acc$0[2],
            p=acc$0[1],
            s=string_of_formatting_lit(fmting_lit);
           strput_acc(b,p);
           return add_string(b,s);
          case 1:
           var _pY_=acc$0[2],_pZ_=acc$0[1];
           if(0 === _pY_[0])
            {var acc$1=_pY_[1];
             strput_acc(b,_pZ_);
             add_string(b,cst$34);
             var acc$0=acc$1;
             continue}
           var acc$2=_pY_[1];
           strput_acc(b,_pZ_);
           add_string(b,cst$35);
           var acc$0=acc$2;
           continue;
          case 6:
           var f=acc$0[2],p$2=acc$0[1];
           strput_acc(b,p$2);
           return add_string(b,caml_call1(f,0));
          case 7:var acc$3=acc$0[1],acc$0=acc$3;continue;
          case 8:
           var msg=acc$0[2],p$3=acc$0[1];
           strput_acc(b,p$3);
           return invalid_arg(msg);
          case 2:
          case 4:
           var s$0=acc$0[2],p$0=acc$0[1];
           strput_acc(b,p$0);
           return add_string(b,s$0);
          default:
           var c=acc$0[2],p$1=acc$0[1];strput_acc(b,p$1);return add_char(b,c)}}
    function failwith_message(param)
     {var fmt=param[1],buf=create$2(256);
      function k(acc){strput_acc(buf,acc);return failwith(contents(buf))}
      return make_printf(k,0,fmt)}
    function open_box_of_string(str)
     {if(caml_string_equal(str,cst$36))return _au_;
      var len=caml_ml_string_length(str);
      function invalid_box(param)
       {return caml_call1(failwith_message(_av_),str)}
      function parse_spaces(i)
       {var i$0=i;
        for(;;)
         {if(i$0 === len)return i$0;
          var match=caml_string_get(str,i$0);
          if(9 !== match && 32 !== match)return i$0;
          var i$1=i$0 + 1 | 0,i$0=i$1;
          continue}}
      function parse_lword(i,j)
       {var j$0=j;
        for(;;)
         {if(j$0 === len)return j$0;
          var match=caml_string_get(str,j$0),switcher=match - 97 | 0;
          if(25 < switcher >>> 0)return j$0;
          var j$1=j$0 + 1 | 0,j$0=j$1;
          continue}}
      function parse_int(i,j)
       {var j$0=j;
        for(;;)
         {if(j$0 === len)return j$0;
          var match=caml_string_get(str,j$0),switch$0=0;
          if(48 <= match)
           {if(! (58 <= match))switch$0 = 1}
          else
           if(45 === match)switch$0 = 1;
          if(switch$0){var j$1=j$0 + 1 | 0,j$0=j$1;continue}
          return j$0}}
      var
       wstart=parse_spaces(0),
       wend=parse_lword(wstart,wstart),
       box_name=sub$0(str,wstart,wend - wstart | 0),
       nstart=parse_spaces(wend),
       nend=parse_int(nstart,nstart);
      if(nstart === nend)
       var indent=0;
      else
       try
        {var
          _pW_=caml_int_of_string(sub$0(str,nstart,nend - nstart | 0)),
          indent=_pW_}
       catch(_pX_)
        {_pX_ = caml_wrap_exception(_pX_);
         if(_pX_[1] !== Failure)throw _pX_;
         var indent=invalid_box(0)}
      var exp_end=parse_spaces(nend);
      if(exp_end !== len)invalid_box(0);
      var switch$0=0;
      if
       (caml_string_notequal(box_name,cst$37)
        &&
        caml_string_notequal(box_name,cst_b$0))
       var
        box_type=
         caml_string_notequal(box_name,cst_h)
          ?caml_string_notequal(box_name,cst_hov)
            ?caml_string_notequal(box_name,cst_hv)
              ?caml_string_notequal(box_name,cst_v)?invalid_box(0):1
              :2
            :3
          :0;
      else
       switch$0 = 1;
      if(switch$0)var box_type=4;
      return [0,indent,box_type]}
    function make_padding_fmt_ebb(pad,fmt)
     {if(typeof pad === "number")
       return [0,0,fmt];
      else
       {if(0 === pad[0]){var w=pad[2],s=pad[1];return [0,[0,s,w],fmt]}
        var s$0=pad[1];
        return [0,[1,s$0],fmt]}}
    function make_padprec_fmt_ebb(pad,prec,fmt)
     {if(typeof prec === "number")
       var match=prec?[0,1,fmt]:[0,0,fmt];
      else
       var p=prec[1],match=[0,[0,p],fmt];
      var prec$0=match[1];
      if(typeof pad === "number")
       return [0,0,prec$0,fmt];
      else
       {if(0 === pad[0]){var w=pad[2],s=pad[1];return [0,[0,s,w],prec$0,fmt]}
        var s$0=pad[1];
        return [0,[1,s$0],prec$0,fmt]}}
    function fmt_ebb_of_string(legacy_behavior,str)
     {if(legacy_behavior)
       var flag=legacy_behavior[1],legacy_behavior$0=flag;
      else
       var legacy_behavior$0=1;
      function invalid_format_message(str_ind,msg)
       {return caml_call3(failwith_message(_aw_),str,str_ind,msg)}
      function unexpected_end_of_format(end_ind)
       {return invalid_format_message(end_ind,cst_unexpected_end_of_format)}
      function invalid_format_without(str_ind,c,s)
       {return caml_call4(failwith_message(_ax_),str,str_ind,c,s)}
      function expected_character(str_ind,expected,read)
       {return caml_call4(failwith_message(_ay_),str,str_ind,expected,read)}
      function add_literal(lit_start,str_ind,fmt)
       {var size=str_ind - lit_start | 0;
        return 0 === size
                ?[0,fmt]
                :1 === size
                  ?[0,[12,caml_string_get(str,lit_start),fmt]]
                  :[0,[11,sub$0(str,lit_start,size),fmt]]}
      function parse(lit_start,end_ind)
       {var str_ind=lit_start;
        for(;;)
         {if(str_ind === end_ind)return add_literal(lit_start,str_ind,0);
          var match=caml_string_get(str,str_ind);
          if(37 === match)
           {var str_ind$2=str_ind + 1 | 0;
            if(str_ind$2 === end_ind)unexpected_end_of_format(end_ind);
            var
             match$1=caml_string_get(str,str_ind$2),
             _pV_=
              95 === match$1
               ?parse_flags(str_ind,str_ind$2 + 1 | 0,end_ind,1)
               :parse_flags(str_ind,str_ind$2,end_ind,0),
             fmt_rest=_pV_[1];
            return add_literal(lit_start,str_ind,fmt_rest)}
          if(64 === match)
           {var str_ind$0=str_ind + 1 | 0;
            if(str_ind$0 === end_ind)
             var match$0=_aK_;
            else
             {var c=caml_string_get(str,str_ind$0),switch$0=0;
              if(65 <= c)
               if(94 <= c)
                {var switcher=c - 123 | 0;
                 if(2 < switcher >>> 0)
                  switch$0 = 1;
                 else
                  switch(switcher)
                   {case 0:
                     var match$0=parse_tag(1,str_ind$0 + 1 | 0,end_ind);break;
                    case 1:switch$0 = 1;break;
                    default:
                     var
                      match$3=parse(str_ind$0 + 1 | 0,end_ind),
                      fmt_rest$2=match$3[1],
                      match$0=[0,[17,1,fmt_rest$2]]}}
               else
                if(91 <= c)
                 {var switcher$0=c - 91 | 0;
                  switch(switcher$0)
                   {case 0:
                     var match$0=parse_tag(0,str_ind$0 + 1 | 0,end_ind);break;
                    case 1:switch$0 = 1;break;
                    default:
                     var
                      match$4=parse(str_ind$0 + 1 | 0,end_ind),
                      fmt_rest$3=match$4[1],
                      match$0=[0,[17,0,fmt_rest$3]]}}
                else
                 switch$0 = 1;
              else
               if(10 === c)
                var
                 match$5=parse(str_ind$0 + 1 | 0,end_ind),
                 fmt_rest$4=match$5[1],
                 match$0=[0,[17,3,fmt_rest$4]];
               else
                if(32 <= c)
                 {var switcher$1=c - 32 | 0;
                  switch(switcher$1)
                   {case 0:
                     var
                      match$6=parse(str_ind$0 + 1 | 0,end_ind),
                      fmt_rest$5=match$6[1],
                      match$0=[0,[17,_aL_,fmt_rest$5]];
                     break;
                    case 5:
                     var switch$1=0;
                     if
                      ((str_ind$0 + 1 | 0)
                       <
                       end_ind
                       &&
                       37
                       ===
                       caml_string_get(str,str_ind$0 + 1 | 0))
                      {var
                        match$7=parse(str_ind$0 + 2 | 0,end_ind),
                        fmt_rest$6=match$7[1],
                        match$0=[0,[17,6,fmt_rest$6]];
                       switch$1 = 1}
                     if(! switch$1)
                      var
                       match$8=parse(str_ind$0,end_ind),
                       fmt_rest$7=match$8[1],
                       match$0=[0,[12,64,fmt_rest$7]];
                     break;
                    case 12:
                     var
                      match$9=parse(str_ind$0 + 1 | 0,end_ind),
                      fmt_rest$8=match$9[1],
                      match$0=[0,[17,_aM_,fmt_rest$8]];
                     break;
                    case 14:
                     var
                      match$10=parse(str_ind$0 + 1 | 0,end_ind),
                      fmt_rest$9=match$10[1],
                      match$0=[0,[17,4,fmt_rest$9]];
                     break;
                    case 27:
                     var match$0=parse_good_break(str_ind$0 + 1 | 0,end_ind);
                     break;
                    case 28:
                     var match$0=parse_magic_size(str_ind$0 + 1 | 0,end_ind);
                     break;
                    case 31:
                     var
                      match$11=parse(str_ind$0 + 1 | 0,end_ind),
                      fmt_rest$10=match$11[1],
                      match$0=[0,[17,2,fmt_rest$10]];
                     break;
                    case 32:
                     var
                      match$12=parse(str_ind$0 + 1 | 0,end_ind),
                      fmt_rest$11=match$12[1],
                      match$0=[0,[17,5,fmt_rest$11]];
                     break;
                    default:switch$0 = 1}}
                else
                 switch$0 = 1;
              if(switch$0)
               var
                match$2=parse(str_ind$0 + 1 | 0,end_ind),
                fmt_rest$1=match$2[1],
                match$0=[0,[17,[2,c],fmt_rest$1]]}
            var fmt_rest$0=match$0[1];
            return add_literal(lit_start,str_ind,fmt_rest$0)}
          var str_ind$1=str_ind + 1 | 0,str_ind=str_ind$1;
          continue}}
      function parse_conversion
       (pct_ind,str_ind,end_ind,plus,hash,space,ign,pad,prec,padprec,symb)
       {var
         plus_used=[0,0],
         hash_used=[0,0],
         space_used=[0,0],
         ign_used=[0,0],
         pad_used=[0,0],
         prec_used=[0,0];
        function get_plus(param){plus_used[1] = 1;return plus}
        function get_hash(param){hash_used[1] = 1;return hash}
        function get_space(param){space_used[1] = 1;return space}
        function get_ign(param){ign_used[1] = 1;return ign}
        function get_pad(param){pad_used[1] = 1;return pad}
        function get_prec(param){prec_used[1] = 1;return prec}
        function get_padprec(param){pad_used[1] = 1;return padprec}
        function get_int_pad(param)
         {var pad=get_pad(0),match=get_prec(0);
          if(typeof match === "number" && ! match)return pad;
          if(typeof pad === "number")
           return 0;
          else
           {if(0 === pad[0])
             {if(2 <= pad[1])
               {var n=pad[2];
                return legacy_behavior$0
                        ?[0,1,n]
                        :incompatible_flag(pct_ind,str_ind,48,cst_precision$0)}
              return pad}
            return 2 <= pad[1]
                    ?legacy_behavior$0
                      ?_aE_
                      :incompatible_flag(pct_ind,str_ind,48,cst_precision$1)
                    :pad}}
        function check_no_0(symb,pad)
         {if(typeof pad === "number")
           return pad;
          else
           {if(0 === pad[0])
             {if(2 <= pad[1])
               {var width=pad[2];
                return legacy_behavior$0
                        ?[0,1,width]
                        :incompatible_flag(pct_ind,str_ind,symb,cst_0$0)}
              return pad}
            return 2 <= pad[1]
                    ?legacy_behavior$0
                      ?_aF_
                      :incompatible_flag(pct_ind,str_ind,symb,cst_0$1)
                    :pad}}
        function opt_of_pad(c,pad)
         {if(typeof pad === "number")
           return 0;
          else
           {if(0 === pad[0])
             switch(pad[1])
              {case 0:
                var width=pad[2];
                return legacy_behavior$0
                        ?[0,width]
                        :incompatible_flag(pct_ind,str_ind,c,cst$38);
               case 1:var width$0=pad[2];return [0,width$0];
               default:
                var width$1=pad[2];
                return legacy_behavior$0
                        ?[0,width$1]
                        :incompatible_flag(pct_ind,str_ind,c,cst_0$2)}
            return incompatible_flag(pct_ind,str_ind,c,cst$39)}}
        function get_pad_opt(c){return opt_of_pad(c,get_pad(0))}
        function get_padprec_opt(c){return opt_of_pad(c,get_padprec(0))}
        var switch$0=0;
        if(124 <= symb)
         switch$0 = 1;
        else
         switch(symb)
          {case 33:
            var
             match$6=parse(str_ind,end_ind),
             fmt_rest$5=match$6[1],
             fmt_result=[0,[10,fmt_rest$5]];
            break;
           case 40:
            var
             sub_end=search_subformat_end(str_ind,end_ind,41),
             match$8=parse(sub_end + 2 | 0,end_ind),
             fmt_rest$7=match$8[1],
             match$9=parse(str_ind,sub_end),
             sub_fmt=match$9[1],
             sub_fmtty=fmtty_of_fmt(sub_fmt);
            if(get_ign(0))
             var
              ignored$2=[9,get_pad_opt(95),sub_fmtty],
              _ps_=[0,[23,ignored$2,fmt_rest$7]];
            else
             var _ps_=[0,[14,get_pad_opt(40),sub_fmtty,fmt_rest$7]];
            var fmt_result=_ps_;
            break;
           case 44:var fmt_result=parse(str_ind,end_ind);break;
           case 67:
            var
             match$12=parse(str_ind,end_ind),
             fmt_rest$10=match$12[1],
             _pu_=get_ign(0)?[0,[23,1,fmt_rest$10]]:[0,[1,fmt_rest$10]],
             fmt_result=_pu_;
            break;
           case 78:
            var
             match$16=parse(str_ind,end_ind),
             fmt_rest$14=match$16[1],
             counter$0=2;
            if(get_ign(0))
             var ignored$6=[11,counter$0],_pA_=[0,[23,ignored$6,fmt_rest$14]];
            else
             var _pA_=[0,[21,counter$0,fmt_rest$14]];
            var fmt_result=_pA_;
            break;
           case 83:
            var
             pad$6=check_no_0(symb,get_padprec(0)),
             match$17=parse(str_ind,end_ind),
             fmt_rest$15=match$17[1];
            if(get_ign(0))
             var
              ignored$7=[1,get_padprec_opt(95)],
              _pB_=[0,[23,ignored$7,fmt_rest$15]];
            else
             var
              match$18=make_padding_fmt_ebb(pad$6,fmt_rest$15),
              fmt_rest$16=match$18[2],
              pad$7=match$18[1],
              _pB_=[0,[3,pad$7,fmt_rest$16]];
            var fmt_result=_pB_;
            break;
           case 91:
            if(str_ind === end_ind)unexpected_end_of_format(end_ind);
            var
             char_set=create_char_set(0),
             add_char=function(c){return add_in_char_set(char_set,c)},
             add_range=
              function(c$0,c)
               {if(! (c < c$0))
                 {var i=c$0;
                  for(;;)
                   {add_in_char_set(char_set,char_of_int(i));
                    var _pU_=i + 1 | 0;
                    if(c !== i){var i=_pU_;continue}
                    break}}
                return 0},
             fail_single_percent=
              function(str_ind)
               {return caml_call2(failwith_message(_aO_),str,str_ind)},
             parse_char_set_content=
              function(counter,str_ind,end_ind)
               {var str_ind$0=str_ind;
                for(;;)
                 {if(str_ind$0 === end_ind)unexpected_end_of_format(end_ind);
                  var c=caml_string_get(str,str_ind$0);
                  if(45 === c)
                   {add_char(45);
                    var str_ind$1=str_ind$0 + 1 | 0,str_ind$0=str_ind$1;
                    continue}
                  if(93 === c)return str_ind$0 + 1 | 0;
                  var _pT_=str_ind$0 + 1 | 0;
                  if(counter < 50)
                   {var counter$0=counter + 1 | 0;
                    return parse_char_set_after_char$0(counter$0,_pT_,end_ind,c)}
                  return caml_trampoline_return
                          (parse_char_set_after_char$0,[0,_pT_,end_ind,c])}},
             parse_char_set_after_char$0=
              function(counter,str_ind,end_ind,c)
               {var str_ind$0=str_ind,c$0=c;
                for(;;)
                 {if(str_ind$0 === end_ind)unexpected_end_of_format(end_ind);
                  var c$1=caml_string_get(str,str_ind$0),switch$0=0;
                  if(46 <= c$1)
                   {if(64 === c$1)
                     switch$0 = 1;
                    else
                     if(93 === c$1){add_char(c$0);return str_ind$0 + 1 | 0}}
                  else
                   if(37 === c$1)
                    switch$0 = 1;
                   else
                    if(45 <= c$1)
                     {var str_ind$2=str_ind$0 + 1 | 0;
                      if(str_ind$2 === end_ind)unexpected_end_of_format(end_ind);
                      var c$2=caml_string_get(str,str_ind$2);
                      if(37 === c$2)
                       {if((str_ind$2 + 1 | 0) === end_ind)
                         unexpected_end_of_format(end_ind);
                        var c$3=caml_string_get(str,str_ind$2 + 1 | 0);
                        if(37 !== c$3 && 64 !== c$3)
                         return fail_single_percent(str_ind$2);
                        add_range(c$0,c$3);
                        var _pR_=str_ind$2 + 2 | 0;
                        if(counter < 50)
                         {var counter$2=counter + 1 | 0;
                          return parse_char_set_content(counter$2,_pR_,end_ind)}
                        return caml_trampoline_return
                                (parse_char_set_content,[0,_pR_,end_ind])}
                      if(93 === c$2)
                       {add_char(c$0);add_char(45);return str_ind$2 + 1 | 0}
                      add_range(c$0,c$2);
                      var _pS_=str_ind$2 + 1 | 0;
                      if(counter < 50)
                       {var counter$1=counter + 1 | 0;
                        return parse_char_set_content(counter$1,_pS_,end_ind)}
                      return caml_trampoline_return
                              (parse_char_set_content,[0,_pS_,end_ind])}
                  if(switch$0 && 37 === c$0)
                   {add_char(c$1);
                    var _pQ_=str_ind$0 + 1 | 0;
                    if(counter < 50)
                     {var counter$0=counter + 1 | 0;
                      return parse_char_set_content(counter$0,_pQ_,end_ind)}
                    return caml_trampoline_return
                            (parse_char_set_content,[0,_pQ_,end_ind])}
                  if(37 === c$0)fail_single_percent(str_ind$0);
                  add_char(c$0);
                  var str_ind$1=str_ind$0 + 1 | 0,str_ind$0=str_ind$1,c$0=c$1;
                  continue}},
             parse_char_set_after_char=
              function(str_ind,end_ind,c)
               {return caml_trampoline
                        (parse_char_set_after_char$0(0,str_ind,end_ind,c))};
            if(str_ind === end_ind)unexpected_end_of_format(end_ind);
            var match$31=caml_string_get(str,str_ind);
            if(94 === match$31)
             var str_ind$0=str_ind + 1 | 0,reverse=1,str_ind$1=str_ind$0;
            else
             var reverse=0,str_ind$1=str_ind;
            if(str_ind$1 === end_ind)unexpected_end_of_format(end_ind);
            var
             c=caml_string_get(str,str_ind$1),
             next_ind=parse_char_set_after_char(str_ind$1 + 1 | 0,end_ind,c),
             char_set$0=freeze_char_set(char_set),
             char_set$1=reverse?rev_char_set(char_set$0):char_set$0,
             match$21=parse(next_ind,end_ind),
             fmt_rest$19=match$21[1];
            if(get_ign(0))
             var
              ignored$9=[10,get_pad_opt(95),char_set$1],
              _pG_=[0,[23,ignored$9,fmt_rest$19]];
            else
             var _pG_=[0,[20,get_pad_opt(91),char_set$1,fmt_rest$19]];
            var fmt_result=_pG_;
            break;
           case 97:
            var
             match$22=parse(str_ind,end_ind),
             fmt_rest$20=match$22[1],
             fmt_result=[0,[15,fmt_rest$20]];
            break;
           case 99:
            var
             char_format=
              function(fmt_rest)
               {return get_ign(0)?[0,[23,0,fmt_rest]]:[0,[0,fmt_rest]]},
             match$23=parse(str_ind,end_ind),
             fmt_rest$21=match$23[1],
             match$24=get_pad_opt(99);
            if(match$24)
             {if(0 === match$24[1])
               var
                _pH_=get_ign(0)?[0,[23,3,fmt_rest$21]]:[0,[22,fmt_rest$21]],
                _pI_=_pH_;
              else
               var
                _pI_=
                 legacy_behavior$0
                  ?char_format(fmt_rest$21)
                  :invalid_format_message
                    (str_ind,cst_non_zero_widths_are_unsupp);
              var _pJ_=_pI_}
            else
             var _pJ_=char_format(fmt_rest$21);
            var fmt_result=_pJ_;
            break;
           case 114:
            var
             match$25=parse(str_ind,end_ind),
             fmt_rest$22=match$25[1],
             _pK_=get_ign(0)?[0,[23,2,fmt_rest$22]]:[0,[19,fmt_rest$22]],
             fmt_result=_pK_;
            break;
           case 115:
            var
             pad$9=check_no_0(symb,get_padprec(0)),
             match$26=parse(str_ind,end_ind),
             fmt_rest$23=match$26[1];
            if(get_ign(0))
             var
              ignored$10=[0,get_padprec_opt(95)],
              _pL_=[0,[23,ignored$10,fmt_rest$23]];
            else
             var
              match$27=make_padding_fmt_ebb(pad$9,fmt_rest$23),
              fmt_rest$24=match$27[2],
              pad$10=match$27[1],
              _pL_=[0,[2,pad$10,fmt_rest$24]];
            var fmt_result=_pL_;
            break;
           case 116:
            var
             match$28=parse(str_ind,end_ind),
             fmt_rest$25=match$28[1],
             fmt_result=[0,[16,fmt_rest$25]];
            break;
           case 123:
            var
             sub_end$0=search_subformat_end(str_ind,end_ind,125),
             match$29=parse(str_ind,sub_end$0),
             sub_fmt$0=match$29[1],
             match$30=parse(sub_end$0 + 2 | 0,end_ind),
             fmt_rest$26=match$30[1],
             sub_fmtty$0=fmtty_of_fmt(sub_fmt$0);
            if(get_ign(0))
             var
              ignored$11=[8,get_pad_opt(95),sub_fmtty$0],
              _pM_=[0,[23,ignored$11,fmt_rest$26]];
            else
             var _pM_=[0,[13,get_pad_opt(123),sub_fmtty$0,fmt_rest$26]];
            var fmt_result=_pM_;
            break;
           case 66:
           case 98:
            var
             pad$3=check_no_0(symb,get_padprec(0)),
             match$10=parse(str_ind,end_ind),
             fmt_rest$8=match$10[1];
            if(get_ign(0))
             var
              ignored$3=[7,get_padprec_opt(95)],
              _pt_=[0,[23,ignored$3,fmt_rest$8]];
            else
             var
              match$11=make_padding_fmt_ebb(pad$3,fmt_rest$8),
              fmt_rest$9=match$11[2],
              pad$4=match$11[1],
              _pt_=[0,[9,pad$4,fmt_rest$9]];
            var fmt_result=_pt_;
            break;
           case 37:
           case 64:
            var
             match$7=parse(str_ind,end_ind),
             fmt_rest$6=match$7[1],
             fmt_result=[0,[12,symb,fmt_rest$6]];
            break;
           case 76:
           case 108:
           case 110:
            var switch$1=0;
            if(str_ind !== end_ind)
             {var
               symb$0=caml_string_get(str,str_ind),
               _pN_=symb$0 - 88 | 0,
               switch$2=0;
              if(! (32 < _pN_ >>> 0))
               switch(_pN_)
                {case 0:
                 case 12:
                 case 17:
                 case 23:
                 case 29:
                 case 32:var _pz_=1;switch$2 = 1;break
                 }
              if(! switch$2)var _pz_=0;
              if(_pz_){switch$0 = 1;switch$1 = 1}}
            if(! switch$1)
             {var
               match$15=parse(str_ind,end_ind),
               fmt_rest$13=match$15[1],
               switch$3=0;
              if(108 <= symb)
               {if(! (111 <= symb))
                 {var switcher$0=symb - 108 | 0;
                  switch(switcher$0)
                   {case 0:var counter=0;switch$3 = 1;break;
                    case 1:break;
                    default:var counter=1;switch$3 = 1}}}
              else
               if(76 === symb){var counter=2;switch$3 = 1}
              if(! switch$3)throw [0,Assert_failure,_aS_];
              if(get_ign(0))
               var ignored$5=[11,counter],_py_=[0,[23,ignored$5,fmt_rest$13]];
              else
               var _py_=[0,[21,counter,fmt_rest$13]];
              var fmt_result=_py_}
            break;
           case 32:
           case 35:
           case 43:
           case 45:
           case 95:
            var
             fmt_result=
              caml_call3(failwith_message(_aJ_),str,pct_ind,symb);
            break;
           case 88:
           case 100:
           case 105:
           case 111:
           case 117:
           case 120:
            var
             _pC_=get_space(0),
             _pD_=get_hash(0),
             iconv$2=
              compute_int_conv(pct_ind,str_ind,get_plus(0),_pD_,_pC_,symb),
             match$19=parse(str_ind,end_ind),
             fmt_rest$17=match$19[1];
            if(get_ign(0))
             var
              ignored$8=[2,iconv$2,get_pad_opt(95)],
              _pE_=[0,[23,ignored$8,fmt_rest$17]];
            else
             var
              _pF_=get_prec(0),
              match$20=make_padprec_fmt_ebb(get_int_pad(0),_pF_,fmt_rest$17),
              fmt_rest$18=match$20[3],
              prec$4=match$20[2],
              pad$8=match$20[1],
              _pE_=[0,[4,iconv$2,pad$8,prec$4,fmt_rest$18]];
            var fmt_result=_pE_;
            break;
           case 69:
           case 70:
           case 71:
           case 72:
           case 101:
           case 102:
           case 103:
           case 104:
            var
             space$1=get_space(0),
             hash$1=get_hash(0),
             plus$2=get_plus(0),
             flag=
              plus$2
               ?space$1
                 ?legacy_behavior$0
                   ?1
                   :incompatible_flag(pct_ind,str_ind,32,cst$50)
                 :1
               :space$1?2:0,
             switch$4=0;
            if(73 <= symb)
             {var switcher$1=symb - 101 | 0;
              if(3 < switcher$1 >>> 0)
               switch$4 = 1;
              else
               {switch(switcher$1)
                 {case 0:var _pO_=1;break;
                  case 1:var _pO_=0;break;
                  case 2:var _pO_=3;break;
                  default:var _pO_=6}
                var kind=_pO_}}
            else
             if(69 <= symb)
              {var switcher$2=symb - 69 | 0,switch$5=0;
               switch(switcher$2)
                {case 0:var _pP_=2;break;
                 case 1:switch$4 = 1;switch$5 = 1;break;
                 case 2:var _pP_=4;break;
                 default:var _pP_=7}
               if(! switch$5)var kind=_pP_}
             else
              switch$4 = 1;
            if(switch$4)
             {var switch$6=0;
              if(hash$1)
               if(70 === symb)var kind=8;else switch$6 = 1;
              else
               if(70 === symb)var kind=5;else switch$6 = 1;
              if(switch$6)throw [0,Assert_failure,_aU_]}
            var
             fconv=[0,flag,kind],
             match$13=parse(str_ind,end_ind),
             fmt_rest$11=match$13[1];
            if(get_ign(0))
             {var match=get_prec(0);
              if(typeof match === "number")
               var _pv_=match?incompatible_flag(pct_ind,str_ind,95,cst$40):0;
              else
               var ndec=match[1],_pv_=[0,ndec];
              var
               ignored$4=[6,get_pad_opt(95),_pv_],
               _pw_=[0,[23,ignored$4,fmt_rest$11]]}
            else
             var
              _px_=get_prec(0),
              match$14=make_padprec_fmt_ebb(get_pad(0),_px_,fmt_rest$11),
              fmt_rest$12=match$14[3],
              prec$3=match$14[2],
              pad$5=match$14[1],
              _pw_=[0,[8,fconv,pad$5,prec$3,fmt_rest$12]];
            var fmt_result=_pw_;
            break;
           default:switch$0 = 1}
        if(switch$0)
         {var switch$7=0;
          if(108 <= symb)
           if(111 <= symb)
            switch$7 = 1;
           else
            {var switcher=symb - 108 | 0,switch$8=0;
             switch(switcher)
              {case 0:
                var
                 _pc_=caml_string_get(str,str_ind),
                 _pd_=get_space(0),
                 _pe_=get_hash(0),
                 iconv=
                  compute_int_conv
                   (pct_ind,str_ind + 1 | 0,get_plus(0),_pe_,_pd_,_pc_),
                 match$0=parse(str_ind + 1 | 0,end_ind),
                 fmt_rest=match$0[1];
                if(get_ign(0))
                 var
                  ignored=[3,iconv,get_pad_opt(95)],
                  _pf_=[0,[23,ignored,fmt_rest]];
                else
                 var
                  _ph_=get_prec(0),
                  match$1=make_padprec_fmt_ebb(get_int_pad(0),_ph_,fmt_rest),
                  fmt_rest$0=match$1[3],
                  prec$0=match$1[2],
                  pad$0=match$1[1],
                  _pf_=[0,[5,iconv,pad$0,prec$0,fmt_rest$0]];
                var _pg_=_pf_;
                break;
               case 1:switch$7 = 1;switch$8 = 1;break;
               default:
                var
                 _pi_=caml_string_get(str,str_ind),
                 _pj_=get_space(0),
                 _pk_=get_hash(0),
                 iconv$0=
                  compute_int_conv
                   (pct_ind,str_ind + 1 | 0,get_plus(0),_pk_,_pj_,_pi_),
                 match$2=parse(str_ind + 1 | 0,end_ind),
                 fmt_rest$1=match$2[1];
                if(get_ign(0))
                 var
                  ignored$0=[4,iconv$0,get_pad_opt(95)],
                  _pl_=[0,[23,ignored$0,fmt_rest$1]];
                else
                 var
                  _pm_=get_prec(0),
                  match$3=make_padprec_fmt_ebb(get_int_pad(0),_pm_,fmt_rest$1),
                  fmt_rest$2=match$3[3],
                  prec$1=match$3[2],
                  pad$1=match$3[1],
                  _pl_=[0,[6,iconv$0,pad$1,prec$1,fmt_rest$2]];
                var _pg_=_pl_}
             if(! switch$8)var fmt_result=_pg_}
          else
           if(76 === symb)
            {var
              _pn_=caml_string_get(str,str_ind),
              _po_=get_space(0),
              _pp_=get_hash(0),
              iconv$1=
               compute_int_conv
                (pct_ind,str_ind + 1 | 0,get_plus(0),_pp_,_po_,_pn_),
              match$4=parse(str_ind + 1 | 0,end_ind),
              fmt_rest$3=match$4[1];
             if(get_ign(0))
              var
               ignored$1=[5,iconv$1,get_pad_opt(95)],
               _pq_=[0,[23,ignored$1,fmt_rest$3]];
             else
              var
               _pr_=get_prec(0),
               match$5=make_padprec_fmt_ebb(get_int_pad(0),_pr_,fmt_rest$3),
               fmt_rest$4=match$5[3],
               prec$2=match$5[2],
               pad$2=match$5[1],
               _pq_=[0,[7,iconv$1,pad$2,prec$2,fmt_rest$4]];
             var fmt_result=_pq_}
           else
            switch$7 = 1;
          if(switch$7)
           var
            fmt_result=
             caml_call3(failwith_message(_aG_),str,str_ind - 1 | 0,symb)}
        if(1 - legacy_behavior$0)
         {var _o5_=1 - plus_used[1],plus$0=_o5_?plus:_o5_;
          if(plus$0)incompatible_flag(pct_ind,str_ind,symb,cst$41);
          var _o6_=1 - hash_used[1],hash$0=_o6_?hash:_o6_;
          if(hash$0)incompatible_flag(pct_ind,str_ind,symb,cst$42);
          var _o7_=1 - space_used[1],space$0=_o7_?space:_o7_;
          if(space$0)incompatible_flag(pct_ind,str_ind,symb,cst$43);
          var _o8_=1 - pad_used[1],_o9_=_o8_?caml_notequal([0,pad],_aH_):_o8_;
          if(_o9_)incompatible_flag(pct_ind,str_ind,symb,cst_padding$0);
          var
           _o__=1 - prec_used[1],
           _o$_=_o__?caml_notequal([0,prec],_aI_):_o__;
          if(_o$_)
           {var _pa_=ign?95:symb;
            incompatible_flag(pct_ind,str_ind,_pa_,cst_precision$2)}
          var plus$1=ign?plus:ign;
          if(plus$1)incompatible_flag(pct_ind,str_ind,95,cst$44)}
        var _pb_=1 - ign_used[1],ign$0=_pb_?ign:_pb_;
        if(ign$0)
         {var switch$9=0;
          if(38 <= symb)
           {if(44 !== symb && 64 !== symb)switch$9 = 1}
          else
           if(33 !== symb && ! (37 <= symb))switch$9 = 1;
          var switch$10=0;
          if(switch$9 || ! legacy_behavior$0)switch$10 = 1;
          if(switch$10)incompatible_flag(pct_ind,str_ind,symb,cst$45)}
        return fmt_result}
      function parse_after_precision
       (pct_ind,str_ind,end_ind,minus,plus,hash,space,ign,pad,match)
       {if(str_ind === end_ind)unexpected_end_of_format(end_ind);
        function parse_conv(padprec)
         {return parse_conversion
                  (pct_ind,
                   str_ind + 1 | 0,
                   end_ind,
                   plus,
                   hash,
                   space,
                   ign,
                   pad,
                   match,
                   padprec,
                   caml_string_get(str,str_ind))}
        if(typeof pad === "number")
         {if(typeof match === "number" && ! match)return parse_conv(0);
          if(minus)
           {if(typeof match === "number")return parse_conv(_aC_);
            var n=match[1];
            return parse_conv([0,0,n])}
          if(typeof match === "number")return parse_conv(_aD_);
          var n$0=match[1];
          return parse_conv([0,1,n$0])}
        return parse_conv(pad)}
      function parse_after_padding
       (pct_ind,str_ind,end_ind,minus,plus,hash,space,ign,pad)
       {if(str_ind === end_ind)unexpected_end_of_format(end_ind);
        var symb=caml_string_get(str,str_ind);
        if(46 === symb)
         {var str_ind$0=str_ind + 1 | 0;
          if(str_ind$0 === end_ind)unexpected_end_of_format(end_ind);
          var
           parse_literal=
            function(minus,str_ind)
             {var
               match=parse_positive(str_ind,end_ind,0),
               prec=match[2],
               new_ind=match[1];
              return parse_after_precision
                      (pct_ind,
                       new_ind,
                       end_ind,
                       minus,
                       plus,
                       hash,
                       space,
                       ign,
                       pad,
                       [0,prec])},
           symb$0=caml_string_get(str,str_ind$0);
          if(48 <= symb$0)
           {if(! (58 <= symb$0))return parse_literal(minus,str_ind$0)}
          else
           if(42 <= symb$0)
            {var switcher=symb$0 - 42 | 0;
             switch(switcher)
              {case 0:
                return parse_after_precision
                        (pct_ind,
                         str_ind$0 + 1 | 0,
                         end_ind,
                         minus,
                         plus,
                         hash,
                         space,
                         ign,
                         pad,
                         1);
               case 1:
               case 3:
                if(legacy_behavior$0)
                 {var
                   _o4_=str_ind$0 + 1 | 0,
                   minus$0=minus || (45 === symb$0?1:0);
                  return parse_literal(minus$0,_o4_)}
                break
               }}
          return legacy_behavior$0
                  ?parse_after_precision
                    (pct_ind,
                     str_ind$0,
                     end_ind,
                     minus,
                     plus,
                     hash,
                     space,
                     ign,
                     pad,
                     _aB_)
                  :invalid_format_without(str_ind$0 - 1 | 0,46,cst_precision)}
        return parse_conversion
                (pct_ind,
                 str_ind + 1 | 0,
                 end_ind,
                 plus,
                 hash,
                 space,
                 ign,
                 pad,
                 0,
                 pad,
                 symb)}
      function parse_flags(pct_ind,str_ind,end_ind,ign)
       {var zero=[0,0],minus=[0,0],plus=[0,0],space=[0,0],hash=[0,0];
        function set_flag(str_ind,flag)
         {var _o1_=flag[1],_o2_=_o1_?1 - legacy_behavior$0:_o1_;
          if(_o2_)
           {var _o3_=caml_string_get(str,str_ind);
            caml_call3(failwith_message(_az_),str,str_ind,_o3_)}
          flag[1] = 1;
          return 0}
        var str_ind$0=str_ind;
        for(;;)
         {if(str_ind$0 === end_ind)unexpected_end_of_format(end_ind);
          var match=caml_string_get(str,str_ind$0),switcher=match - 32 | 0;
          if(! (16 < switcher >>> 0))
           switch(switcher)
            {case 0:
              set_flag(str_ind$0,space);
              var str_ind$1=str_ind$0 + 1 | 0,str_ind$0=str_ind$1;
              continue;
             case 3:
              set_flag(str_ind$0,hash);
              var str_ind$2=str_ind$0 + 1 | 0,str_ind$0=str_ind$2;
              continue;
             case 11:
              set_flag(str_ind$0,plus);
              var str_ind$3=str_ind$0 + 1 | 0,str_ind$0=str_ind$3;
              continue;
             case 13:
              set_flag(str_ind$0,minus);
              var str_ind$4=str_ind$0 + 1 | 0,str_ind$0=str_ind$4;
              continue;
             case 16:
              set_flag(str_ind$0,zero);
              var str_ind$5=str_ind$0 + 1 | 0,str_ind$0=str_ind$5;
              continue
             }
          var
           _oW_=space[1],
           _oX_=hash[1],
           _oY_=plus[1],
           _oZ_=minus[1],
           _o0_=zero[1];
          if(str_ind$0 === end_ind)unexpected_end_of_format(end_ind);
          var
           padty=
            _o0_
             ?_oZ_
               ?legacy_behavior$0
                 ?0
                 :incompatible_flag(pct_ind,str_ind$0,45,cst_0)
               :2
             :_oZ_?0:1,
           match$0=caml_string_get(str,str_ind$0);
          if(48 <= match$0)
           {if(! (58 <= match$0))
             {var
               match$1=parse_positive(str_ind$0,end_ind,0),
               width=match$1[2],
               new_ind=match$1[1];
              return parse_after_padding
                      (pct_ind,
                       new_ind,
                       end_ind,
                       _oZ_,
                       _oY_,
                       _oX_,
                       _oW_,
                       ign,
                       [0,padty,width])}}
          else
           if(42 === match$0)
            return parse_after_padding
                    (pct_ind,
                     str_ind$0 + 1 | 0,
                     end_ind,
                     _oZ_,
                     _oY_,
                     _oX_,
                     _oW_,
                     ign,
                     [1,padty]);
          switch(padty)
           {case 0:
             if(1 - legacy_behavior$0)
              invalid_format_without(str_ind$0 - 1 | 0,45,cst_padding);
             return parse_after_padding
                     (pct_ind,str_ind$0,end_ind,_oZ_,_oY_,_oX_,_oW_,ign,0);
            case 1:
             return parse_after_padding
                     (pct_ind,str_ind$0,end_ind,_oZ_,_oY_,_oX_,_oW_,ign,0);
            default:
             return parse_after_padding
                     (pct_ind,str_ind$0,end_ind,_oZ_,_oY_,_oX_,_oW_,ign,_aA_)}}}
      function parse_tag(is_open_tag,str_ind,end_ind)
       {try
         {if(str_ind === end_ind)throw Not_found;
          var match$0=caml_string_get(str,str_ind);
          if(60 === match$0)
           {var ind=index_from$0(str,str_ind + 1 | 0,62);
            if(end_ind <= ind)throw Not_found;
            var
             sub_str=sub$0(str,str_ind,(ind - str_ind | 0) + 1 | 0),
             match$1=parse(ind + 1 | 0,end_ind),
             fmt_rest$0=match$1[1],
             match$2=parse(str_ind,ind + 1 | 0),
             sub_fmt=match$2[1],
             sub_format$0=[0,sub_fmt,sub_str],
             formatting$0=is_open_tag?[0,sub_format$0]:[1,sub_format$0],
             _oU_=[0,[18,formatting$0,fmt_rest$0]];
            return _oU_}
          throw Not_found}
        catch(_oV_)
         {_oV_ = caml_wrap_exception(_oV_);
          if(_oV_ === Not_found)
           {var
             match=parse(str_ind,end_ind),
             fmt_rest=match[1],
             formatting=is_open_tag?[0,sub_format]:[1,sub_format];
            return [0,[18,formatting,fmt_rest]]}
          throw _oV_}}
      function parse_good_break(str_ind,end_ind)
       {try
         {var
           _oN_=str_ind === end_ind?1:0,
           _oO_=_oN_ || (60 !== caml_string_get(str,str_ind)?1:0);
          if(_oO_)throw Not_found;
          var
           str_ind_1=parse_spaces(str_ind + 1 | 0,end_ind),
           match$0=caml_string_get(str,str_ind_1),
           switch$0=0;
          if(48 <= match$0)
           {if(! (58 <= match$0))switch$0 = 1}
          else
           if(45 === match$0)switch$0 = 1;
          if(! switch$0)throw Not_found;
          var
           match$1=parse_integer(str_ind_1,end_ind),
           width=match$1[2],
           str_ind_2=match$1[1],
           str_ind_3=parse_spaces(str_ind_2,end_ind),
           match$2=caml_string_get(str,str_ind_3),
           switcher=match$2 - 45 | 0,
           switch$1=0;
          if(12 < switcher >>> 0)
           if(17 === switcher)
            var
             s=sub$0(str,str_ind - 2 | 0,(str_ind_3 - str_ind | 0) + 3 | 0),
             _oP_=[0,s,width,0],
             _oQ_=str_ind_3 + 1 | 0,
             formatting_lit$0=_oP_,
             next_ind=_oQ_;
           else
            switch$1 = 1;
          else
           {var switcher$0=switcher - 1 | 0;
            if(1 < switcher$0 >>> 0)
             {var
               match$3=parse_integer(str_ind_3,end_ind),
               offset=match$3[2],
               str_ind_4=match$3[1],
               str_ind_5=parse_spaces(str_ind_4,end_ind);
              if(62 !== caml_string_get(str,str_ind_5))throw Not_found;
              var
               s$0=
                sub$0(str,str_ind - 2 | 0,(str_ind_5 - str_ind | 0) + 3 | 0),
               _oR_=[0,s$0,width,offset],
               _oS_=str_ind_5 + 1 | 0,
               formatting_lit$0=_oR_,
               next_ind=_oS_}
            else
             switch$1 = 1}
          if(switch$1)throw Not_found}
        catch(_oT_)
         {_oT_ = caml_wrap_exception(_oT_);
          if(_oT_ !== Not_found && _oT_[1] !== Failure)throw _oT_;
          var formatting_lit$0=formatting_lit,next_ind=str_ind}
        var match=parse(next_ind,end_ind),fmt_rest=match[1];
        return [0,[17,formatting_lit$0,fmt_rest]]}
      function parse_magic_size(str_ind,end_ind)
       {try
         {var
           str_ind_1=parse_spaces(str_ind,end_ind),
           match$2=caml_string_get(str,str_ind_1),
           switch$0=0;
          if(48 <= match$2)
           {if(! (58 <= match$2))switch$0 = 1}
          else
           if(45 === match$2)switch$0 = 1;
          if(switch$0)
           {var
             match$3=parse_integer(str_ind_1,end_ind),
             size=match$3[2],
             str_ind_2=match$3[1],
             str_ind_3=parse_spaces(str_ind_2,end_ind);
            if(62 !== caml_string_get(str,str_ind_3))throw Not_found;
            var
             s=sub$0(str,str_ind - 2 | 0,(str_ind_3 - str_ind | 0) + 3 | 0),
             _oL_=[0,[0,str_ind_3 + 1 | 0,[1,s,size]]]}
          else
           var _oL_=0;
          var _oK_=_oL_}
        catch(_oM_)
         {_oM_ = caml_wrap_exception(_oM_);
          if(_oM_ !== Not_found && _oM_[1] !== Failure)throw _oM_;
          var _oK_=0}
        if(_oK_)
         {var
           match=_oK_[1],
           formatting_lit=match[2],
           next_ind=match[1],
           match$0=parse(next_ind,end_ind),
           fmt_rest=match$0[1];
          return [0,[17,formatting_lit,fmt_rest]]}
        var match$1=parse(str_ind,end_ind),fmt_rest$0=match$1[1];
        return [0,[17,_aN_,fmt_rest$0]]}
      function parse_spaces(str_ind,end_ind)
       {var str_ind$0=str_ind;
        for(;;)
         {if(str_ind$0 === end_ind)unexpected_end_of_format(end_ind);
          if(32 === caml_string_get(str,str_ind$0))
           {var str_ind$1=str_ind$0 + 1 | 0,str_ind$0=str_ind$1;continue}
          return str_ind$0}}
      function parse_positive(str_ind,end_ind,acc)
       {var str_ind$0=str_ind,acc$0=acc;
        for(;;)
         {if(str_ind$0 === end_ind)unexpected_end_of_format(end_ind);
          var c=caml_string_get(str,str_ind$0),switcher=c - 48 | 0;
          if(9 < switcher >>> 0)return [0,str_ind$0,acc$0];
          var acc$1=(acc$0 * 10 | 0) + (c - 48 | 0) | 0;
          if(max_string_length < acc$1)
           return caml_call3
                   (failwith_message(_aP_),str,acc$1,max_string_length);
          var str_ind$1=str_ind$0 + 1 | 0,str_ind$0=str_ind$1,acc$0=acc$1;
          continue}}
      function parse_integer(str_ind,end_ind)
       {if(str_ind === end_ind)unexpected_end_of_format(end_ind);
        var match=caml_string_get(str,str_ind);
        if(48 <= match)
         {if(! (58 <= match))return parse_positive(str_ind,end_ind,0)}
        else
         if(45 === match)
          {if((str_ind + 1 | 0) === end_ind)unexpected_end_of_format(end_ind);
           var c=caml_string_get(str,str_ind + 1 | 0),switcher=c - 48 | 0;
           if(9 < switcher >>> 0)
            return expected_character(str_ind + 1 | 0,cst_digit,c);
           var
            match$0=parse_positive(str_ind + 1 | 0,end_ind,0),
            n=match$0[2],
            next_ind=match$0[1];
           return [0,next_ind,- n | 0]}
        throw [0,Assert_failure,_aQ_]}
      function search_subformat_end(str_ind,end_ind,c)
       {var str_ind$0=str_ind;
        for(;;)
         {if(str_ind$0 === end_ind)
           caml_call3(failwith_message(_aR_),str,c,end_ind);
          var match=caml_string_get(str,str_ind$0);
          if(37 === match)
           {if((str_ind$0 + 1 | 0) === end_ind)
             unexpected_end_of_format(end_ind);
            if(caml_string_get(str,str_ind$0 + 1 | 0) === c)return str_ind$0;
            var match$0=caml_string_get(str,str_ind$0 + 1 | 0);
            if(95 <= match$0)
             {if(123 <= match$0)
               {if(! (126 <= match$0))
                 {var switcher=match$0 - 123 | 0;
                  switch(switcher)
                   {case 0:
                     var
                      sub_end=search_subformat_end(str_ind$0 + 2 | 0,end_ind,125),
                      str_ind$2=sub_end + 2 | 0,
                      str_ind$0=str_ind$2;
                     continue;
                    case 1:break;
                    default:
                     return expected_character
                             (str_ind$0 + 1 | 0,cst_character,125)}}}
              else
               if(! (96 <= match$0))
                {if((str_ind$0 + 2 | 0) === end_ind)
                  unexpected_end_of_format(end_ind);
                 var match$1=caml_string_get(str,str_ind$0 + 2 | 0);
                 if(40 === match$1)
                  {var
                    sub_end$0=search_subformat_end(str_ind$0 + 3 | 0,end_ind,41),
                    str_ind$3=sub_end$0 + 2 | 0,
                    str_ind$0=str_ind$3;
                   continue}
                 if(123 === match$1)
                  {var
                    sub_end$1=
                     search_subformat_end(str_ind$0 + 3 | 0,end_ind,125),
                    str_ind$4=sub_end$1 + 2 | 0,
                    str_ind$0=str_ind$4;
                   continue}
                 var str_ind$5=str_ind$0 + 3 | 0,str_ind$0=str_ind$5;
                 continue}}
            else
             {if(40 === match$0)
               {var
                 sub_end$2=search_subformat_end(str_ind$0 + 2 | 0,end_ind,41),
                 str_ind$6=sub_end$2 + 2 | 0,
                 str_ind$0=str_ind$6;
                continue}
              if(41 === match$0)
               return expected_character(str_ind$0 + 1 | 0,cst_character$0,41)}
            var str_ind$1=str_ind$0 + 2 | 0,str_ind$0=str_ind$1;
            continue}
          var str_ind$7=str_ind$0 + 1 | 0,str_ind$0=str_ind$7;
          continue}}
      function incompatible_flag(pct_ind,str_ind,symb,option)
       {var subfmt=sub$0(str,pct_ind,str_ind - pct_ind | 0);
        return caml_call5
                (failwith_message(_aV_),str,pct_ind,option,symb,subfmt)}
      function compute_int_conv(pct_ind,str_ind,plus,hash,space,symb)
       {var plus$0=plus,hash$0=hash,space$0=space;
        for(;;)
         {var switch$0=0;
          if(plus$0)
           {if(hash$0)
             switch$0 = 1;
            else
             if(! space$0){if(100 === symb)return 1;if(105 === symb)return 4}}
          else
           if(hash$0)
            if(space$0)
             switch$0 = 1;
            else
             {var switcher$0=symb - 88 | 0;
              if(32 < switcher$0 >>> 0)
               switch$0 = 1;
              else
               switch(switcher$0)
                {case 0:return 9;
                 case 12:return 13;
                 case 17:return 14;
                 case 23:return 11;
                 case 29:return 15;
                 case 32:return 7;
                 default:switch$0 = 1}}
           else
            if(space$0)
             {if(100 === symb)return 2;if(105 === symb)return 5}
            else
             {var switcher$1=symb - 88 | 0;
              if(! (32 < switcher$1 >>> 0))
               switch(switcher$1)
                {case 0:return 8;
                 case 12:return 0;
                 case 17:return 3;
                 case 23:return 10;
                 case 29:return 12;
                 case 32:return 6
                 }}
          if(switch$0)
           {var switcher=symb - 88 | 0;
            if(! (32 < switcher >>> 0))
             switch(switcher)
              {case 0:if(legacy_behavior$0)return 9;break;
               case 23:if(legacy_behavior$0)return 11;break;
               case 32:if(legacy_behavior$0)return 7;break;
               case 12:
               case 17:
               case 29:
                if(legacy_behavior$0){var hash$0=0;continue}
                return incompatible_flag(pct_ind,str_ind,symb,cst$49)
               }}
          if(plus$0)
           {if(space$0)
             {if(legacy_behavior$0){var space$0=0;continue}
              return incompatible_flag(pct_ind,str_ind,32,cst$46)}
            if(legacy_behavior$0){var plus$0=0;continue}
            return incompatible_flag(pct_ind,str_ind,symb,cst$47)}
          if(space$0)
           {if(legacy_behavior$0){var space$0=0;continue}
            return incompatible_flag(pct_ind,str_ind,symb,cst$48)}
          throw [0,Assert_failure,_aT_]}}
      return parse(0,caml_ml_string_length(str))}
    function format_of_string_fmtty(str,fmtty)
     {var match=fmt_ebb_of_string(0,str),fmt=match[1];
      try
       {var _oI_=[0,type_format(fmt,fmtty),str];return _oI_}
      catch(_oJ_)
       {_oJ_ = caml_wrap_exception(_oJ_);
        if(_oJ_ === Type_mismatch)
         {var _oH_=string_of_fmtty(fmtty);
          return caml_call2(failwith_message(_aW_),str,_oH_)}
        throw _oJ_}}
    function format_of_string_format(str,param)
     {var
       str$0=param[2],
       fmt=param[1],
       match=fmt_ebb_of_string(0,str),
       fmt$0=match[1];
      try
       {var _oF_=[0,type_format(fmt$0,fmtty_of_fmt(fmt)),str];return _oF_}
      catch(_oG_)
       {_oG_ = caml_wrap_exception(_oG_);
        if(_oG_ === Type_mismatch)
         return caml_call2(failwith_message(_aX_),str,str$0);
        throw _oG_}}
    var
     CamlinternalFormat=
      [0,
       is_in_char_set,
       rev_char_set,
       create_char_set,
       add_in_char_set,
       freeze_char_set,
       param_format_of_ignored_format,
       make_printf,
       make_iprintf,
       output_acc,
       bufput_acc,
       strput_acc,
       type_format,
       fmt_ebb_of_string,
       format_of_string_fmtty,
       format_of_string_format,
       char_of_iconv,
       string_of_formatting_lit,
       string_of_fmtty,
       string_of_fmt,
       open_box_of_string,
       symm,
       trans,
       recast];
    caml_register_global(778,CamlinternalFormat,"CamlinternalFormat");
    function kfprintf(k,o,param)
     {var fmt=param[1],_oE_=0;
      return make_printf
              (function(acc){output_acc(o,acc);return caml_call1(k,o)},
               _oE_,
               fmt)}
    function kbprintf(k,b,param)
     {var fmt=param[1],_oD_=0;
      return make_printf
              (function(acc){bufput_acc(b,acc);return caml_call1(k,b)},
               _oD_,
               fmt)}
    function ikfprintf(k,oc,param)
     {var fmt=param[1];return make_iprintf(k,oc,fmt)}
    function fprintf(oc,fmt){return kfprintf(function(_oC_){return 0},oc,fmt)}
    function bprintf(b,fmt){return kbprintf(function(_oB_){return 0},b,fmt)}
    function ifprintf(oc,fmt)
     {return ikfprintf(function(_oA_){return 0},oc,fmt)}
    function printf(fmt){return fprintf(stdout,fmt)}
    function eprintf(fmt){return fprintf(stderr,fmt)}
    function ksprintf(k,param)
     {var fmt=param[1];
      function k$0(acc)
       {var buf=create$2(64);
        strput_acc(buf,acc);
        return caml_call1(k,contents(buf))}
      return make_printf(k$0,0,fmt)}
    function sprintf(fmt){return ksprintf(function(s){return s},fmt)}
    var
     Stdlib_printf=
      [0,
       fprintf,
       printf,
       eprintf,
       sprintf,
       bprintf,
       ifprintf,
       kfprintf,
       ikfprintf,
       ksprintf,
       kbprintf,
       ksprintf];
    caml_register_global(779,Stdlib_printf,"Stdlib__printf");
    var
     Bad=[248,cst_Stdlib_Arg_Bad,caml_fresh_oo_id(0)],
     Help=[248,cst_Stdlib_Arg_Help,caml_fresh_oo_id(0)],
     Stop=[248,cst_Stdlib_Arg_Stop,caml_fresh_oo_id(0)];
    function assoc3(x,l)
     {var l$0=l;
      for(;;)
       {if(l$0)
         {var match=l$0[1],y2=match[2],y1=match[1];
          if(caml_equal(y1,x))return y2;
          var l$1=l$0[2],l$0=l$1;
          continue}
        throw Not_found}}
    function split$0(s)
     {var
       i=index$0(s,61),
       len=caml_ml_string_length(s),
       _oz_=sub$0(s,i + 1 | 0,len - (i + 1 | 0) | 0);
      return [0,sub$0(s,0,i),_oz_]}
    function make_symlist(prefix,sep,suffix,l)
     {if(l)
       {var t=l[2],h=l[1],_oy_=symbol(prefix,h);
        return symbol
                (fold_left$0
                  (function(x,y){return symbol(x,symbol(sep,y))},_oy_,t),
                 suffix)}
      return cst_none}
    function help_action(param){throw [0,Stop,_a0_]}
    function add_help(speclist)
     {try
       {assoc3(cst_help$2,speclist);var _ov_=0,_ot_=_ov_}
      catch(_ox_)
       {_ox_ = caml_wrap_exception(_ox_);
        if(_ox_ !== Not_found)throw _ox_;
        var
         _ot_=
          [0,[0,cst_help,[0,help_action],cst_Display_this_list_of_optio],0]}
      try
       {assoc3(cst_help$1,speclist);var _ou_=0,add2=_ou_}
      catch(_ow_)
       {_ow_ = caml_wrap_exception(_ow_);
        if(_ow_ !== Not_found)throw _ow_;
        var
         add2=
          [0,
           [0,cst_help$0,[0,help_action],cst_Display_this_list_of_optio$0],
           0]}
      return append(speclist,append(_ot_,add2))}
    function usage_b(buf,speclist,errmsg)
     {caml_call1(bprintf(buf,_a1_),errmsg);
      var _oq_=add_help(speclist);
      return iter$2
              (function(param)
                {var
                  doc=param[3],
                  spec=param[2],
                  key=param[1],
                  _or_=0 < caml_ml_string_length(doc)?1:0;
                 if(_or_)
                  {if(11 === spec[0])
                    {var l=spec[1],_os_=make_symlist(cst$53,cst$52,cst$51,l);
                     return caml_call3(bprintf(buf,_aZ_),key,_os_,doc)}
                   return caml_call2(bprintf(buf,_aY_),key,doc)}
                 return _or_},
               _oq_)}
    function usage_string(speclist,errmsg)
     {var b=create$2(200);usage_b(b,speclist,errmsg);return contents(b)}
    function usage(speclist,errmsg)
     {var _op_=usage_string(speclist,errmsg);
      return caml_call1(eprintf(_a2_),_op_)}
    var current=[0,0];
    function bool_of_string_opt$0(x)
     {try
       {var _on_=[0,bool_of_string(x)];return _on_}
      catch(_oo_)
       {_oo_ = caml_wrap_exception(_oo_);
        if(_oo_[1] === Invalid_argument)return 0;
        throw _oo_}}
    function int_of_string_opt$0(x)
     {try
       {var _ol_=[0,caml_int_of_string(x)];return _ol_}
      catch(_om_)
       {_om_ = caml_wrap_exception(_om_);
        if(_om_[1] === Failure)return 0;
        throw _om_}}
    function float_of_string_opt(x)
     {try
       {var _oj_=[0,caml_float_of_string(x)];return _oj_}
      catch(_ok_)
       {_ok_ = caml_wrap_exception(_ok_);
        if(_ok_[1] === Failure)return 0;
        throw _ok_}}
    function parse_and_expand_argv_dynamic_
     (allow_expand,current,argv,speclist,anonfun,errmsg)
     {var initpos=current[1];
      function convert_error(error)
       {var
         b=create$2(200),
         progname=
          initpos < argv[1].length - 1
           ?caml_check_bound(argv[1],initpos)[1 + initpos]
           :cst$54;
        switch(error[0])
         {case 0:
           var _oi_=error[1];
           if
            (caml_string_notequal(_oi_,cst_help$3)
             &&
             caml_string_notequal(_oi_,cst_help$4))
            caml_call2(bprintf(b,_a3_),progname,_oi_);
           break;
          case 1:
           var expected=error[3],arg=error[2],opt=error[1];
           caml_call4(bprintf(b,_a6_),progname,arg,opt,expected);
           break;
          case 2:var s=error[1];caml_call2(bprintf(b,_a7_),progname,s);break;
          default:var s$0=error[1];caml_call2(bprintf(b,_a8_),progname,s$0)}
        usage_b(b,speclist[1],errmsg);
        if(! caml_equal(error,_a4_) && ! caml_equal(error,_a5_))
         return [0,Bad,contents(b)];
        return [0,Help,contents(b)]}
      current[1]++;
      for(;;)
       {if(current[1] < argv[1].length - 1)
         {try
           {var
             _n$_=current[1],
             s=caml_check_bound(argv[1],_n$_)[1 + _n$_],
             switch$0=0;
            if(1 <= caml_ml_string_length(s) && 45 === caml_string_get(s,0))
             {try
               {var
                 follow$1=0,
                 _ob_=assoc3(s,speclist[1]),
                 follow$0=follow$1,
                 action=_ob_}
              catch(_og_)
               {_og_ = caml_wrap_exception(_og_);
                if(_og_ !== Not_found)throw _og_;
                try
                 {var
                   match=split$0(s),
                   arg=match[2],
                   keyword=match[1],
                   follow=[0,arg],
                   _oa_=assoc3(keyword,speclist[1])}
                catch(_oh_)
                 {_oh_ = caml_wrap_exception(_oh_);
                  if(_oh_ === Not_found)throw [0,Stop,[0,s]];
                  throw _oh_;
                  var _oc_=_oh_}
                var follow$0=follow,action=_oa_,_od_=_og_}
              var
               no_arg$0=
                function(s,follow)
                 {function no_arg(param)
                   {if(follow)
                     {var arg=follow[1];throw [0,Stop,[1,s,arg,cst_no_argument]]}
                    return 0}
                  return no_arg},
               no_arg=no_arg$0(s,follow$0),
               get_arg$0=
                function(s,follow)
                 {function get_arg(param)
                   {if(follow){var arg=follow[1];return arg}
                    if((current[1] + 1 | 0) < argv[1].length - 1)
                     {var _of_=current[1] + 1 | 0;
                      return caml_check_bound(argv[1],_of_)[1 + _of_]}
                    throw [0,Stop,[2,s]]}
                  return get_arg},
               get_arg=get_arg$0(s,follow$0),
               consume_arg$0=
                function(follow)
                 {function consume_arg(param)
                   {return follow?0:(current[1]++,0)}
                  return consume_arg},
               consume_arg=consume_arg$0(follow$0),
               treat_action$0=
                function(s,no_arg,get_arg,consume_arg)
                 {function treat_action(param)
                   {switch(param[0])
                     {case 0:var f=param[1];no_arg(0);return caml_call1(f,0);
                      case 1:
                       var
                        f$0=param[1],
                        arg=get_arg(0),
                        match=bool_of_string_opt$0(arg);
                       if(match)
                        {var s$0=match[1];caml_call1(f$0,s$0);return consume_arg(0)}
                       throw [0,Stop,[1,s,arg,cst_a_boolean]];
                      case 2:var r=param[1];no_arg(0);r[1] = 1;return 0;
                      case 3:var r$0=param[1];no_arg(0);r$0[1] = 0;return 0;
                      case 4:
                       var f$1=param[1],arg$0=get_arg(0);
                       caml_call1(f$1,arg$0);
                       return consume_arg(0);
                      case 5:
                       var r$1=param[1];r$1[1] = get_arg(0);return consume_arg(0);
                      case 6:
                       var
                        f$2=param[1],
                        arg$1=get_arg(0),
                        match$0=int_of_string_opt$0(arg$1);
                       if(match$0)
                        {var x=match$0[1];caml_call1(f$2,x);return consume_arg(0)}
                       throw [0,Stop,[1,s,arg$1,cst_an_integer]];
                      case 7:
                       var
                        r$2=param[1],
                        arg$2=get_arg(0),
                        match$1=int_of_string_opt$0(arg$2);
                       if(match$1)
                        {var x$0=match$1[1];r$2[1] = x$0;return consume_arg(0)}
                       throw [0,Stop,[1,s,arg$2,cst_an_integer$0]];
                      case 8:
                       var
                        f$3=param[1],
                        arg$3=get_arg(0),
                        match$2=float_of_string_opt(arg$3);
                       if(match$2)
                        {var x$1=match$2[1];
                         caml_call1(f$3,x$1);
                         return consume_arg(0)}
                       throw [0,Stop,[1,s,arg$3,cst_a_float]];
                      case 9:
                       var
                        r$3=param[1],
                        arg$4=get_arg(0),
                        match$3=float_of_string_opt(arg$4);
                       if(match$3)
                        {var x$2=match$3[1];r$3[1] = x$2;return consume_arg(0)}
                       throw [0,Stop,[1,s,arg$4,cst_a_float$0]];
                      case 10:
                       var specs=param[1];
                       no_arg(0);
                       return iter$2(treat_action,specs);
                      case 11:
                       var f$4=param[2],symb=param[1],arg$5=get_arg(0);
                       if(mem(arg$5,symb))
                        {caml_call1(f$4,arg$5);return consume_arg(0)}
                       throw [0,
                              Stop,
                              [1,
                               s,
                               arg$5,
                               symbol(cst_one_of,make_symlist(cst$57,cst$56,cst$55,symb))]];
                      case 12:
                       var f$5=param[1];
                       no_arg(0);
                       for(;;)
                        {if(current[1] < (argv[1].length - 1 - 1 | 0))
                          {var _oe_=current[1] + 1 | 0;
                           caml_call1(f$5,caml_check_bound(argv[1],_oe_)[1 + _oe_]);
                           consume_arg(0);
                           continue}
                         return 0}
                      default:
                       var f$6=param[1];
                       if(1 - allow_expand)
                        throw [0,Invalid_argument,cst_Arg_Expand_is_is_only_allo];
                       var arg$6=get_arg(0),newarg=caml_call1(f$6,arg$6);
                       consume_arg(0);
                       var
                        before=sub$1(argv[1],0,current[1] + 1 | 0),
                        after=
                         sub$1
                          (argv[1],
                           current[1] + 1 | 0,
                           (argv[1].length - 1 - current[1] | 0) - 1 | 0);
                       argv[1]
                       =
                       caml_array_concat([0,before,[0,newarg,[0,after,0]]]);
                       return 0}}
                  return treat_action},
               treat_action=treat_action$0(s,no_arg,get_arg,consume_arg);
              treat_action(action);
              switch$0 = 1}
            if(! switch$0)caml_call1(anonfun,s)}
          catch(exn$0)
           {exn$0 = caml_wrap_exception(exn$0);
            if(exn$0[1] === Bad){var m=exn$0[2];throw convert_error([3,m])}
            if(exn$0[1] === Stop){var e=exn$0[2];throw convert_error(e)}
            throw exn$0;
            var exn=exn$0}
          current[1]++;
          continue}
        return 0}}
    function parse_and_expand_argv_dynamic
     (current,argv,speclist,anonfun,errmsg)
     {return parse_and_expand_argv_dynamic_
              (1,current,argv,speclist,anonfun,errmsg)}
    function parse_argv_dynamic(opt,argv,speclist,anonfun,errmsg)
     {if(opt)var sth=opt[1],current$0=sth;else var current$0=current;
      return parse_and_expand_argv_dynamic_
              (0,current$0,[0,argv],speclist,anonfun,errmsg)}
    function parse_argv(opt,argv,speclist,anonfun,errmsg)
     {if(opt)var sth=opt[1],current$0=sth;else var current$0=current;
      return parse_argv_dynamic
              ([0,current$0],argv,[0,speclist],anonfun,errmsg)}
    function parse(l,f,msg)
     {try
       {var _n__=parse_argv(0,caml_sys_argv(0),l,f,msg);return _n__}
      catch(exn)
       {exn = caml_wrap_exception(exn);
        if(exn[1] === Bad)
         {var msg$0=exn[2];caml_call1(eprintf(_a9_),msg$0);return exit(2)}
        if(exn[1] === Help)
         {var msg$1=exn[2];caml_call1(printf(_a__),msg$1);return exit(0)}
        throw exn}}
    function parse_dynamic(l,f,msg)
     {try
       {var _n9_=parse_argv_dynamic(0,caml_sys_argv(0),l,f,msg);return _n9_}
      catch(exn)
       {exn = caml_wrap_exception(exn);
        if(exn[1] === Bad)
         {var msg$0=exn[2];caml_call1(eprintf(_a$_),msg$0);return exit(2)}
        if(exn[1] === Help)
         {var msg$1=exn[2];caml_call1(printf(_ba_),msg$1);return exit(0)}
        throw exn}}
    function parse_expand(l,f,msg)
     {try
       {var
         argv=[0,caml_sys_argv(0)],
         spec=[0,l],
         current$0=[0,current[1]],
         _n8_=parse_and_expand_argv_dynamic(current$0,argv,spec,f,msg);
        return _n8_}
      catch(exn)
       {exn = caml_wrap_exception(exn);
        if(exn[1] === Bad)
         {var msg$0=exn[2];caml_call1(eprintf(_bb_),msg$0);return exit(2)}
        if(exn[1] === Help)
         {var msg$1=exn[2];caml_call1(printf(_bc_),msg$1);return exit(0)}
        throw exn}}
    function second_word(s)
     {var len=caml_ml_string_length(s);
      function loop(n)
       {var n$0=n;
        for(;;)
         {if(len <= n$0)return len;
          if(32 === caml_string_get(s,n$0))
           {var n$1=n$0 + 1 | 0,n$0=n$1;continue}
          return n$0}}
      try
       {var n$0=index$0(s,9)}
      catch(_n6_)
       {_n6_ = caml_wrap_exception(_n6_);
        if(_n6_ === Not_found)
         {try
           {var n=index$0(s,32)}
          catch(_n7_)
           {_n7_ = caml_wrap_exception(_n7_);
            if(_n7_ === Not_found)return len;
            throw _n7_}
          return loop(n + 1 | 0)}
        throw _n6_}
      return loop(n$0 + 1 | 0)}
    function max_arg_len(cur,param)
     {var doc=param[3],spec=param[2],kwd=param[1];
      return 11 === spec[0]
              ?max(cur,caml_ml_string_length(kwd))
              :max(cur,caml_ml_string_length(kwd) + second_word(doc) | 0)}
    function replace_leading_tab(s)
     {var seen=[0,0];
      return map$4
              (function(c)
                {if(9 === c && ! seen[1]){seen[1] = 1;return 32}return c},
               s)}
    function align(opt,speclist)
     {if(opt)var sth=opt[1],limit=sth;else var limit=max_int;
      var
       completed=add_help(speclist),
       len=fold_left$0(max_arg_len,0,completed),
       len$0=min(len,limit);
      return map$2
              (function(ksd)
                {var _n4_=ksd[1],_n5_=ksd[2];
                 if(caml_string_notequal(ksd[3],cst$58))
                  {if(11 === _n5_[0])
                    {var
                      msg$0=ksd[3],
                      cutcol$0=second_word(msg$0),
                      spaces$0=make$0(max(0,len$0 - cutcol$0 | 0) + 3 | 0,32);
                     return [0,
                             _n4_,
                             _n5_,
                             symbol(cst$59,symbol(spaces$0,replace_leading_tab(msg$0)))]}
                   var
                    msg=ksd[3],
                    spec=ksd[2],
                    cutcol=second_word(msg),
                    kwd_len=caml_ml_string_length(_n4_),
                    diff=(len$0 - kwd_len | 0) - cutcol | 0;
                   if(0 < diff)
                    {var
                      spaces=make$0(diff,32),
                      prefix=sub$0(replace_leading_tab(msg),0,cutcol),
                      suffix=
                       sub$0(msg,cutcol,caml_ml_string_length(msg) - cutcol | 0);
                     return [0,_n4_,spec,symbol(prefix,symbol(spaces,suffix))]}
                   return [0,_n4_,spec,replace_leading_tab(msg)]}
                 return ksd},
               completed)}
    function read_aux(trim,sep,file)
     {var ic=open_in_bin(file),buf=create$2(200),words=[0,0];
      function stash(param)
       {var s=contents(buf);
        if(trim)
         {var len=caml_ml_string_length(s),switch$0=0;
          if(0 < len && 13 === caml_string_get(s,len - 1 | 0))
           {var _n3_=sub$0(s,0,len - 1 | 0);switch$0 = 1}
          if(! switch$0)var _n3_=s;
          var word=_n3_}
        else
         var word=s;
        words[1] = [0,word,words[1]];
        return clear$1(buf)}
      try
       {for(;;)
         {var c=caml_ml_input_char(ic);
          if(c === sep)stash(0);else add_char(buf,c);
          continue}}
      catch(_n2_)
       {_n2_ = caml_wrap_exception(_n2_);
        if(_n2_ === End_of_file)
         {if(0 < buf[2])stash(0);
          caml_ml_close_channel(ic);
          return of_list(rev(words[1]))}
        throw _n2_}}
    var _bd_=10,_be_=1;
    function read_arg(_n1_){return read_aux(_be_,_bd_,_n1_)}
    var _bf_=0,_bg_=0;
    function read_arg0(_n0_){return read_aux(_bg_,_bf_,_n0_)}
    function write_aux(sep,file,args)
     {var oc=open_out_bin(file);
      iter$5(function(s){return caml_call2(fprintf(oc,_bh_),s,sep)},args);
      return close_out(oc)}
    var _bi_=10;
    function write_arg(_nY_,_nZ_){return write_aux(_bi_,_nY_,_nZ_)}
    var _bj_=0;
    function write_arg0(_nW_,_nX_){return write_aux(_bj_,_nW_,_nX_)}
    var
     Stdlib_arg=
      [0,
       parse,
       parse_dynamic,
       parse_argv,
       parse_argv_dynamic,
       parse_and_expand_argv_dynamic,
       parse_expand,
       Help,
       Bad,
       usage,
       usage_string,
       align,
       current,
       read_arg,
       read_arg0,
       write_arg,
       write_arg0];
    caml_register_global(780,Stdlib_arg,"Stdlib__arg");
    var printers=[0,0];
    function field(x,i)
     {var f=x[1 + i];
      return is_block(f)
              ?caml_obj_tag(f) === 252
                ?caml_call1(sprintf(_bk_),f)
                :caml_obj_tag(f) === 253?to_string(f):cst$60
              :caml_call1(sprintf(_bl_),f)}
    function other_fields(x,i)
     {if(x.length - 1 <= i)return cst$61;
      var _nU_=other_fields(x,i + 1 | 0),_nV_=field(x,i);
      return caml_call2(sprintf(_bm_),_nV_,_nU_)}
    function use_printers(x)
     {function conv(param)
       {var param$0=param;
        for(;;)
         {if(param$0)
           {var tl=param$0[2],hd=param$0[1];
            try
             {var switch$0=0,val=caml_call1(hd,x);switch$0 = 1}
            catch(_nT_){}
            if(switch$0 && val){var s=val[1];return [0,s]}
            var param$0=tl;
            continue}
          return 0}}
      return conv(printers[1])}
    function to_string_default(x)
     {if(x === Out_of_memory)return cst_Out_of_memory;
      if(x === Stack_overflow)return cst_Stack_overflow;
      if(x[1] === Match_failure)
       {var match$0=x[2],char$0=match$0[3],line=match$0[2],file=match$0[1];
        return caml_call5
                (sprintf(locfmt),
                 file,
                 line,
                 char$0,
                 char$0 + 5 | 0,
                 cst_Pattern_matching_failed)}
      if(x[1] === Assert_failure)
       {var
         match$1=x[2],
         char$1=match$1[3],
         line$0=match$1[2],
         file$0=match$1[1];
        return caml_call5
                (sprintf(locfmt),
                 file$0,
                 line$0,
                 char$1,
                 char$1 + 6 | 0,
                 cst_Assertion_failed)}
      if(x[1] === Undefined_recursive_module)
       {var
         match$2=x[2],
         char$2=match$2[3],
         line$1=match$2[2],
         file$1=match$2[1];
        return caml_call5
                (sprintf(locfmt),
                 file$1,
                 line$1,
                 char$2,
                 char$2 + 6 | 0,
                 cst_Undefined_recursive_module)}
      if(0 === caml_obj_tag(x))
       {var constructor=x[1][1],match=x.length - 1;
        if(2 < match >>> 0)
         var
          _nP_=other_fields(x,2),
          _nQ_=field(x,1),
          _nS_=caml_call2(sprintf(_bn_),_nQ_,_nP_);
        else
         switch(match)
          {case 0:var _nS_=cst$62;break;
           case 1:var _nS_=cst$63;break;
           default:var _nR_=field(x,1),_nS_=caml_call1(sprintf(_bo_),_nR_)}
        return symbol(constructor,_nS_)}
      return x[1]}
    function to_string$7(e)
     {var match=use_printers(e);
      if(match){var s=match[1];return s}
      return to_string_default(e)}
    function print(fct,arg)
     {try
       {var _nO_=caml_call1(fct,arg);return _nO_}
      catch(x)
       {x = caml_wrap_exception(x);
        var _nN_=to_string$7(x);
        caml_call1(eprintf(_bp_),_nN_);
        caml_ml_flush(stderr);
        throw x}}
    function catch$0(fct,arg)
     {try
       {var _nM_=caml_call1(fct,arg);return _nM_}
      catch(x)
       {x = caml_wrap_exception(x);
        caml_ml_flush(stdout);
        var _nL_=to_string$7(x);
        caml_call1(eprintf(_bq_),_nL_);
        return exit(2)}}
    function convert_raw_backtrace(bt)
     {return [0,runtime.caml_convert_raw_backtrace(bt)]}
    function format_backtrace_slot(pos,slot)
     {function info(is_raise)
       {return is_raise
                ?0 === pos?cst_Raised_at:cst_Re_raised_at
                :0 === pos?cst_Raised_by_primitive_operat:cst_Called_from}
      if(0 === slot[0])
       {var
         _nE_=slot[5],
         _nF_=slot[4],
         _nG_=slot[3],
         _nH_=slot[6]?cst_inlined:cst$64,
         _nI_=slot[2],
         _nJ_=info(slot[1]);
        return [0,caml_call6(sprintf(_br_),_nJ_,_nI_,_nH_,_nG_,_nF_,_nE_)]}
      if(slot[1])return 0;
      var _nK_=info(0);
      return [0,caml_call1(sprintf(_bs_),_nK_)]}
    function print_raw_backtrace(outchan,raw_backtrace)
     {var backtrace=convert_raw_backtrace(raw_backtrace);
      if(backtrace)
       {var a=backtrace[1],_nC_=a.length - 1 - 1 | 0,_nB_=0;
        if(! (_nC_ < 0))
         {var i=_nB_;
          for(;;)
           {var match=format_backtrace_slot(i,caml_check_bound(a,i)[1 + i]);
            if(match){var str=match[1];caml_call1(fprintf(outchan,_bt_),str)}
            var _nD_=i + 1 | 0;
            if(_nC_ !== i){var i=_nD_;continue}
            break}}
        return 0}
      return fprintf(outchan,_bu_)}
    function print_backtrace(outchan)
     {return print_raw_backtrace(outchan,caml_get_exception_raw_backtra(0))}
    function raw_backtrace_to_string(raw_backtrace)
     {var backtrace=convert_raw_backtrace(raw_backtrace);
      if(backtrace)
       {var a=backtrace[1],b=create$2(1024),_nz_=a.length - 1 - 1 | 0,_ny_=0;
        if(! (_nz_ < 0))
         {var i=_ny_;
          for(;;)
           {var match=format_backtrace_slot(i,caml_check_bound(a,i)[1 + i]);
            if(match){var str=match[1];caml_call1(bprintf(b,_bv_),str)}
            var _nA_=i + 1 | 0;
            if(_nz_ !== i){var i=_nA_;continue}
            break}}
        return contents(b)}
      return cst_Program_not_linked_with_g_}
    function backtrace_slot_is_raise(param)
     {return 0 === param[0]?param[1]:param[1]}
    function backtrace_slot_is_inline(param){return 0 === param[0]?param[6]:0}
    function backtrace_slot_location(param)
     {return 0 === param[0]?[0,[0,param[2],param[3],param[4],param[5]]]:0}
    function backtrace_slots(raw_backtrace)
     {var match=convert_raw_backtrace(raw_backtrace);
      if(match)
       {var backtrace=match[1],i$1=backtrace.length - 1 - 1 | 0,i=i$1;
        for(;;)
         {if(-1 === i)
           var _nx_=0;
          else
           {var
             param=caml_check_bound(backtrace,i)[1 + i],
             _nw_=0 === param[0]?1:0;
            if(! _nw_){var i$0=i - 1 | 0,i=i$0;continue}
            var _nx_=_nw_}
          return _nx_?[0,backtrace]:0}}
      return 0}
    function get_backtrace(param)
     {return raw_backtrace_to_string(caml_get_exception_raw_backtra(0))}
    function register_printer(fn){printers[1] = [0,fn,printers[1]];return 0}
    function exn_slot(x){return 0 === caml_obj_tag(x)?x[1]:x}
    function exn_slot_id(x){var slot=exn_slot(x);return slot[2]}
    function exn_slot_name(x){var slot=exn_slot(x);return slot[1]}
    var uncaught_exception_handler=[0,0];
    function set_uncaught_exception_handler(fn)
     {uncaught_exception_handler[1] = [0,fn];return 0}
    function _bw_(_nv_){return runtime.caml_raw_backtrace_next_slot(_nv_)}
    function _bx_(_nu_){return runtime.caml_convert_raw_backtrace_slot(_nu_)}
    function _by_(_nt_,_ns_)
     {return runtime.caml_raw_backtrace_slot(_nt_,_ns_)}
    function _bz_(_nr_){return runtime.caml_raw_backtrace_length(_nr_)}
    var
     _bA_=
      [0,
       backtrace_slot_is_raise,
       backtrace_slot_is_inline,
       backtrace_slot_location,
       format_backtrace_slot];
    function _bB_(_nq_){return caml_get_exception_raw_backtra(_nq_)}
    function _bC_(_np_){return runtime.caml_backtrace_status(_np_)}
    var
     Stdlib_printexc=
      [0,
       to_string$7,
       to_string_default,
       print,
       catch$0,
       print_backtrace,
       get_backtrace,
       function(_no_){return runtime.caml_record_backtrace(_no_)},
       _bC_,
       register_printer,
       use_printers,
       _bB_,
       print_raw_backtrace,
       raw_backtrace_to_string,
       set_uncaught_exception_handler,
       backtrace_slots,
       _bA_,
       _bz_,
       _by_,
       _bx_,
       _bw_,
       exn_slot_id,
       exn_slot_name];
    caml_register_global(781,Stdlib_printexc,"Stdlib__printexc");
    function const$0(c,param){return c}
    function flip(f,x,y){return caml_call2(f,y,x)}
    function negate(p,v){return 1 - caml_call1(p,v)}
    var
     Finally_raised=
      [248,cst_Stdlib_Fun_Finally_raised,caml_fresh_oo_id(0)];
    function protect(finally$0,work)
     {function finally_no_exn(param)
       {try
         {var _nn_=caml_call1(finally$0,0);return _nn_}
        catch(e)
         {e = caml_wrap_exception(e);
          var bt=caml_get_exception_raw_backtra(0),exn=[0,Finally_raised,e];
          caml_restore_raw_backtrace(exn,bt);
          throw exn}}
      try
       {var result=caml_call1(work,0)}
      catch(work_exn)
       {work_exn = caml_wrap_exception(work_exn);
        var work_bt=caml_get_exception_raw_backtra(0);
        finally_no_exn(0);
        caml_restore_raw_backtrace(work_exn,work_bt);
        throw work_exn}
      finally_no_exn(0);
      return result}
    var Stdlib_fun=[0,const$0,flip,negate,protect,Finally_raised];
    caml_register_global(782,Stdlib_fun,"Stdlib__fun");
    function print_stat(c)
     {var st=runtime.caml_gc_stat(0),_m8_=st[4];
      caml_call1(fprintf(c,_bD_),_m8_);
      var _m9_=st[5];
      caml_call1(fprintf(c,_bE_),_m9_);
      var _m__=st[14];
      caml_call1(fprintf(c,_bF_),_m__);
      fprintf(c,_bG_);
      var
       _m$_=st[1],
       l1=caml_ml_string_length(caml_call1(sprintf(_bH_),_m$_)),
       _na_=st[1];
      caml_call2(fprintf(c,_bI_),l1,_na_);
      var _nb_=st[2];
      caml_call2(fprintf(c,_bJ_),l1,_nb_);
      var _nc_=st[3];
      caml_call2(fprintf(c,_bK_),l1,_nc_);
      fprintf(c,_bL_);
      var
       _nd_=st[15],
       l2=caml_ml_string_length(caml_call1(sprintf(_bM_),_nd_)),
       _ne_=st[15];
      caml_call2(fprintf(c,_bN_),l2,_ne_);
      var _nf_=st[6];
      caml_call2(fprintf(c,_bO_),l2,_nf_);
      var _ng_=st[8];
      caml_call2(fprintf(c,_bP_),l2,_ng_);
      var _nh_=st[10];
      caml_call2(fprintf(c,_bQ_),l2,_nh_);
      var _ni_=st[12];
      caml_call2(fprintf(c,_bR_),l2,_ni_);
      var _nj_=st[13];
      caml_call2(fprintf(c,_bS_),l2,_nj_);
      fprintf(c,_bT_);
      var _nk_=st[9];
      caml_call1(fprintf(c,_bU_),_nk_);
      var _nl_=st[11];
      caml_call1(fprintf(c,_bV_),_nl_);
      var _nm_=st[7];
      return caml_call1(fprintf(c,_bW_),_nm_)}
    function allocated_bytes(param)
     {var
       match=runtime.caml_gc_counters(0),
       ma=match[3],
       pro=match[2],
       mi=match[1];
      return (mi + ma - pro) * 4}
    function create_alarm(f){return [0,1]}
    function delete_alarm(a){a[1] = 0;return 0}
    function _bX_(_m7_){return runtime.caml_final_release(_m7_)}
    function _bY_(_m6_,_m5_)
     {return runtime.caml_final_register_called_without_value(_m6_,_m5_)}
    var
     Stdlib_gc=
      [0,
       print_stat,
       allocated_bytes,
       function(_m4_,_m3_){return runtime.caml_final_register(_m4_,_m3_)},
       _bY_,
       _bX_,
       create_alarm,
       delete_alarm];
    caml_register_global(783,Stdlib_gc,"Stdlib__gc");
    function string(str)
     {return caml_md5_string(str,0,caml_ml_string_length(str))}
    function bytes(b){return string(caml_string_of_bytes(b))}
    function substring(str,ofs,len)
     {if
       (0
        <=
        ofs
        &&
        0
        <=
        len
        &&
        !
        ((caml_ml_string_length(str) - len | 0) < ofs))
       return caml_md5_string(str,ofs,len);
      return invalid_arg(cst_Digest_substring)}
    function subbytes(b,ofs,len)
     {return substring(caml_string_of_bytes(b),ofs,len)}
    function file(filename)
     {var ic=open_in_bin(filename);
      try
       {var d=runtime.caml_md5_chan(ic,-1)}
      catch(e){e = caml_wrap_exception(e);caml_ml_close_channel(ic);throw e}
      caml_ml_close_channel(ic);
      return d}
    function output$0(chan,digest){return output_string(chan,digest)}
    function input$0(chan){return really_input_string(chan,16)}
    function char_hex(n){var _m2_=10 <= n?87:48;return n + _m2_ | 0}
    function to_hex(d)
     {if(16 !== caml_ml_string_length(d))invalid_arg(cst_Digest_to_hex);
      var result=caml_create_bytes(32),i=0;
      for(;;)
       {var x=caml_string_get(d,i);
        caml_bytes_unsafe_set(result,i * 2 | 0,char_hex(x >>> 4 | 0));
        caml_bytes_unsafe_set(result,(i * 2 | 0) + 1 | 0,char_hex(x & 15));
        var _m1_=i + 1 | 0;
        if(15 !== i){var i=_m1_;continue}
        return caml_string_of_bytes(result)}}
    function from_hex(s)
     {if(32 !== caml_ml_string_length(s))invalid_arg(cst_Digest_from_hex);
      function digit(c)
       {if(65 <= c)
         {if(97 <= c)
           {if(! (103 <= c))return (c - 97 | 0) + 10 | 0}
          else
           if(! (71 <= c))return (c - 65 | 0) + 10 | 0}
        else
         {var switcher=c - 48 | 0;if(! (9 < switcher >>> 0))return c - 48 | 0}
        throw [0,Invalid_argument,cst_Digest_from_hex$0]}
      var result=caml_create_bytes(16),i=0;
      for(;;)
       {var i$0=2 * i | 0,_mZ_=digit(caml_string_get(s,i$0 + 1 | 0));
        caml_bytes_set
         (result,i,chr((digit(caml_string_get(s,i$0)) << 4) + _mZ_ | 0));
        var _m0_=i + 1 | 0;
        if(15 !== i){var i=_m0_;continue}
        return caml_string_of_bytes(result)}}
    var
     Stdlib_digest=
      [0,
       compare$5,
       equal$5,
       string,
       bytes,
       substring,
       subbytes,
       file,
       output$0,
       input$0,
       to_hex,
       from_hex];
    caml_register_global(784,Stdlib_digest,"Stdlib__digest");
    function new_state(param){return [0,caml_make_vect(55,0),0]}
    function assign(st1,st2)
     {blit$1(st2[1],0,st1[1],0,55);st1[2] = st2[2];return 0}
    function full_init(s,seed)
     {var seed$0=0 === seed.length - 1?[0,0]:seed,l=seed$0.length - 1,i$0=0;
      for(;;)
       {caml_check_bound(s[1],i$0)[1 + i$0] = i$0;
        var _mY_=i$0 + 1 | 0;
        if(54 !== i$0){var i$0=_mY_;continue}
        var accu=[0,cst_x$1],_mU_=54 + max(55,l) | 0,_mT_=0;
        if(! (_mU_ < 0))
         {var i=_mT_;
          for(;;)
           {var
             j=i % 55 | 0,
             k=caml_mod(i,l),
             x=caml_check_bound(seed$0,k)[1 + k];
            accu[1] = string(symbol(accu[1],caml_string_of_jsbytes("" + x)));
            var
             _mV_=accu[1],
             _mP_=caml_string_get(_mV_,3) << 24,
             _mQ_=caml_string_get(_mV_,2) << 16,
             _mR_=caml_string_get(_mV_,1) << 8,
             _mS_=((caml_string_get(_mV_,0) + _mR_ | 0) + _mQ_ | 0) + _mP_ | 0,
             _mW_=(caml_check_bound(s[1],j)[1 + j] ^ _mS_) & 1073741823;
            caml_check_bound(s[1],j)[1 + j] = _mW_;
            var _mX_=i + 1 | 0;
            if(_mU_ !== i){var i=_mX_;continue}
            break}}
        s[2] = 0;
        return 0}}
    function make$2(seed)
     {var result=new_state(0);full_init(result,seed);return result}
    function make_self_init(param){return make$2(caml_sys_random_seed(0))}
    function copy$5(s){var result=new_state(0);assign(result,s);return result}
    function bits(s)
     {s[2] = (s[2] + 1 | 0) % 55 | 0;
      var
       _mM_=s[2],
       curval=caml_check_bound(s[1],_mM_)[1 + _mM_],
       _mN_=(s[2] + 24 | 0) % 55 | 0,
       newval=
        caml_check_bound(s[1],_mN_)[1 + _mN_]
        +
        (curval ^ (curval >>> 25 | 0) & 31)
        |
        0,
       newval30=newval & 1073741823,
       _mO_=s[2];
      caml_check_bound(s[1],_mO_)[1 + _mO_] = newval30;
      return newval30}
    function int$0(s,bound)
     {if(! (1073741823 < bound) && 0 < bound)
       for(;;)
        {var r=bits(s),v=caml_mod(r,bound);
         if(((1073741823 - bound | 0) + 1 | 0) < (r - v | 0))continue;
         return v}
      return invalid_arg(cst_Random_int)}
    function int32(s,bound)
     {if(caml_lessequal(bound,0))return invalid_arg(cst_Random_int32);
      for(;;)
       {var b1=bits(s),b2=(bits(s) & 1) << 30,r=b1 | b2,v=caml_mod(r,bound);
        if(caml_greaterthan(r - v | 0,(2147483647 - bound | 0) + 1 | 0))
         continue;
        return v}}
    function int64(s,bound)
     {if(caml_lessequal(bound,_b0_))return invalid_arg(cst_Random_int64);
      for(;;)
       {var
         b1=caml_int64_of_int32(bits(s)),
         b2=caml_int64_shift_left(caml_int64_of_int32(bits(s)),30),
         b3=caml_int64_shift_left(caml_int64_of_int32(bits(s) & 7),60),
         r=caml_int64_or(b1,caml_int64_or(b2,b3)),
         v=runtime.caml_int64_mod(r,bound);
        if
         (caml_greaterthan
           (caml_int64_sub(r,v),
            caml_int64_add(caml_int64_sub(max_int$2,bound),_bZ_)))
         continue;
        return v}}
    function nativeint(s,bound){return int32(s,bound)}
    function float$0(s,bound)
     {var r1=bits(s),r2=bits(s);
      return (r1 / 1073741824. + r2) / 1073741824. * bound}
    function bool(s){return 0 === (bits(s) & 1)?1:0}
    var default$0=[0,_b1_.slice(),0];
    function bits$0(param){return bits(default$0)}
    function int$1(bound){return int$0(default$0,bound)}
    function int32$0(bound){return int32(default$0,bound)}
    function nativeint$0(bound){return nativeint(default$0,bound)}
    function int64$0(bound){return int64(default$0,bound)}
    function float$1(scale){return float$0(default$0,scale)}
    function bool$0(param){return bool(default$0)}
    function full_init$0(seed){return full_init(default$0,seed)}
    function init$4(seed){return full_init(default$0,[0,seed])}
    function self_init(param){return full_init$0(caml_sys_random_seed(0))}
    function get_state(param){return copy$5(default$0)}
    function set_state(s){return assign(default$0,s)}
    var
     _b2_=
      [0,
       make$2,
       make_self_init,
       copy$5,
       bits,
       int$0,
       int32,
       nativeint,
       int64,
       float$0,
       bool],
     Stdlib_random=
      [0,
       init$4,
       full_init$0,
       self_init,
       bits$0,
       int$1,
       int32$0,
       nativeint$0,
       int64$0,
       float$1,
       bool$0,
       _b2_,
       get_state,
       set_state];
    caml_register_global(785,Stdlib_random,"Stdlib__random");
    function ongoing_traversal(h)
     {var _mK_=h.length - 1 < 4?1:0,_mL_=_mK_ || (h[4] < 0?1:0);return _mL_}
    function flip_ongoing_traversal(h){h[4] = - h[4] | 0;return 0}
    try
     {var _cI_=caml_sys_getenv(cst_OCAMLRUNPARAM),params=_cI_}
    catch(_mI_)
     {_mI_ = caml_wrap_exception(_mI_);
      if(_mI_ !== Not_found)throw _mI_;
      try
       {var _cH_=caml_sys_getenv(cst_CAMLRUNPARAM),_b3_=_cH_}
      catch(_mJ_)
       {_mJ_ = caml_wrap_exception(_mJ_);
        if(_mJ_ !== Not_found)throw _mJ_;
        var _b3_=cst$65}
      var params=_b3_}
    var
     randomized_default=contains$0(params,82),
     randomized=[0,randomized_default];
    function randomize(param){randomized[1] = 1;return 0}
    function is_randomized(param){return randomized[1]}
    var prng=[246,function(_mH_){return caml_call1(_b2_[2],0)}];
    function create$3(opt,initial_size)
     {if(opt)var sth=opt[1],random=sth;else var random=randomized[1];
      var x=16;
      for(;;)
       {if(! (initial_size <= x) && ! (max_array_length < (x * 2 | 0)))
         {var x$0=x * 2 | 0,x=x$0;continue}
        if(random)
         var
          _mF_=caml_obj_tag(prng),
          _mG_=250 === _mF_?prng[1]:246 === _mF_?force_lazy_block(prng):prng,
          seed=caml_call1(_b2_[4],_mG_);
        else
         var seed=0;
        return [0,0,caml_make_vect(x,0),seed,x]}}
    function clear$2(h)
     {var _mE_=0 < h[1]?1:0;
      return _mE_?(h[1] = 0,fill$0(h[2],0,h[2].length - 1,0)):_mE_}
    function reset$0(h)
     {var len=h[2].length - 1;
      if(4 <= h.length - 1 && len !== abs(h[4]))
       {h[1] = 0;h[2] = caml_make_vect(abs(h[4]),0);return 0}
      return clear$2(h)}
    function copy_bucketlist(param)
     {if(param)
       {var
         key=param[1],
         data=param[2],
         next=param[3],
         prec$0=[0,key,data,next],
         prec=prec$0,
         param$0=next;
        for(;;)
         {if(param$0)
           {var
             key$0=param$0[1],
             data$0=param$0[2],
             next$0=param$0[3],
             r=[0,key$0,data$0,next$0];
            if(prec){prec[3] = r;var prec=r,param$0=next$0;continue}
            throw [0,Assert_failure,_b4_]}
          return prec$0}}
      return 0}
    function copy$6(init)
     {var _mB_=init[4],_mC_=init[3],_mD_=map$5(copy_bucketlist,init[2]);
      return [0,init[1],_mD_,_mC_,_mB_]}
    function length$4(h){return h[1]}
    function resize$0(indexfun,h)
     {var
       odata=h[2],
       osize=odata.length - 1,
       nsize=osize * 2 | 0,
       _ms_=nsize < max_array_length?1:0;
      if(_ms_)
       {var
         ndata=caml_make_vect(nsize,0),
         ndata_tail=caml_make_vect(nsize,0),
         inplace=1 - ongoing_traversal(h);
        h[2] = ndata;
        var _mu_=osize - 1 | 0,_mt_=0;
        if(! (_mu_ < 0))
         {var i$0=_mt_;
          a:
          for(;;)
           {var cell$1=caml_check_bound(odata,i$0)[1 + i$0],cell=cell$1;
            for(;;)
             {if(cell)
               {var
                 key=cell[1],
                 data=cell[2],
                 next=cell[3],
                 cell$0=inplace?cell:[0,key,data,0],
                 nidx=caml_call2(indexfun,h,key),
                 match=caml_check_bound(ndata_tail,nidx)[1 + nidx];
                if(match)
                 match[3] = cell$0;
                else
                 caml_check_bound(ndata,nidx)[1 + nidx] = cell$0;
                caml_check_bound(ndata_tail,nidx)[1 + nidx] = cell$0;
                var cell=next;
                continue}
              var _mA_=i$0 + 1 | 0;
              if(_mu_ !== i$0){var i$0=_mA_;continue a}
              break}
            break}}
        if(inplace)
         {var _mw_=nsize - 1 | 0,_mv_=0;
          if(! (_mw_ < 0))
           {var i=_mv_;
            for(;;)
             {var match$0=caml_check_bound(ndata_tail,i)[1 + i];
              if(match$0)match$0[3] = 0;
              var _mz_=i + 1 | 0;
              if(_mw_ !== i){var i=_mz_;continue}
              break}}
          var _mx_=0}
        else
         var _mx_=inplace;
        var _my_=_mx_}
      else
       var _my_=_ms_;
      return _my_}
    function iter$10(f,h)
     {function do_bucket(param)
       {var param$0=param;
        for(;;)
         {if(param$0)
           {var key=param$0[1],data=param$0[2],next=param$0[3];
            caml_call2(f,key,data);
            var param$0=next;
            continue}
          return 0}}
      var old_trav=ongoing_traversal(h);
      if(1 - old_trav)flip_ongoing_traversal(h);
      try
       {var d=h[2],_mo_=d.length - 1 - 1 | 0,_mn_=0;
        if(! (_mo_ < 0))
         {var i=_mn_;
          for(;;)
           {do_bucket(caml_check_bound(d,i)[1 + i]);
            var _mr_=i + 1 | 0;
            if(_mo_ !== i){var i=_mr_;continue}
            break}}
        var _mp_=1 - old_trav,_mq_=_mp_?flip_ongoing_traversal(h):_mp_;
        return _mq_}
      catch(exn)
       {exn = caml_wrap_exception(exn);
        if(old_trav)throw exn;
        flip_ongoing_traversal(h);
        throw exn}}
    function filter_map_inplace_bucket(f,h,i,prec,slot)
     {var prec$0=prec,slot$0=slot;
      for(;;)
       {if(slot$0)
         {var
           key=slot$0[1],
           data=slot$0[2],
           next=slot$0[3],
           match=caml_call2(f,key,data);
          if(match)
           {var data$0=match[1];
            if(prec$0)
             prec$0[3] = slot$0;
            else
             caml_check_bound(h[2],i)[1 + i] = slot$0;
            slot$0[2] = data$0;
            var prec$0=slot$0,slot$0=next;
            continue}
          h[1] = h[1] - 1 | 0;
          var slot$0=next;
          continue}
        return prec$0
                ?(prec$0[3] = 0,0)
                :(caml_check_bound(h[2],i)[1 + i] = 0,0)}}
    function filter_map_inplace(f,h)
     {var d=h[2],old_trav=ongoing_traversal(h);
      if(1 - old_trav)flip_ongoing_traversal(h);
      try
       {var _mk_=d.length - 1 - 1 | 0,_mj_=0;
        if(! (_mk_ < 0))
         {var i=_mj_;
          for(;;)
           {filter_map_inplace_bucket(f,h,i,0,caml_check_bound(h[2],i)[1 + i]);
            var _mm_=i + 1 | 0;
            if(_mk_ !== i){var i=_mm_;continue}
            break}}
        var _ml_=0;
        return _ml_}
      catch(exn)
       {exn = caml_wrap_exception(exn);
        if(old_trav)throw exn;
        flip_ongoing_traversal(h);
        throw exn}}
    function fold$3(f,h,init)
     {function do_bucket(b,accu)
       {var b$0=b,accu$0=accu;
        for(;;)
         {if(b$0)
           {var
             key=b$0[1],
             data=b$0[2],
             next=b$0[3],
             accu$1=caml_call3(f,key,data,accu$0),
             b$0=next,
             accu$0=accu$1;
            continue}
          return accu$0}}
      var old_trav=ongoing_traversal(h);
      if(1 - old_trav)flip_ongoing_traversal(h);
      try
       {var d=h[2],accu=[0,init],_mf_=d.length - 1 - 1 | 0,_me_=0;
        if(! (_mf_ < 0))
         {var i=_me_;
          for(;;)
           {var _mh_=accu[1];
            accu[1] = do_bucket(caml_check_bound(d,i)[1 + i],_mh_);
            var _mi_=i + 1 | 0;
            if(_mf_ !== i){var i=_mi_;continue}
            break}}
        if(1 - old_trav)flip_ongoing_traversal(h);
        var _mg_=accu[1];
        return _mg_}
      catch(exn)
       {exn = caml_wrap_exception(exn);
        if(old_trav)throw exn;
        flip_ongoing_traversal(h);
        throw exn}}
    function bucket_length(accu,param)
     {var accu$0=accu,param$0=param;
      for(;;)
       {if(param$0)
         {var
           param$1=param$0[3],
           accu$1=accu$0 + 1 | 0,
           accu$0=accu$1,
           param$0=param$1;
          continue}
        return accu$0}}
    function stats(h)
     {var
       _mb_=h[2],
       _mc_=0,
       mbl=
        fold_left$1(function(m,b){return max(m,bucket_length(0,b))},_mc_,_mb_),
       histo=caml_make_vect(mbl + 1 | 0,0),
       _md_=h[2];
      iter$5
       (function(b)
         {var l=bucket_length(0,b);
          histo[1 + l] = caml_check_bound(histo,l)[1 + l] + 1 | 0;
          return 0},
        _md_);
      return [0,h[1],h[2].length - 1,mbl,histo]}
    function to_seq$9(tbl)
     {var tbl_data=tbl[2];
      function aux(i,buck,param)
       {var i$0=i,buck$0=buck;
        for(;;)
         {if(buck$0)
           {var key=buck$0[1],data=buck$0[2],next=buck$0[3];
            return [0,[0,key,data],function(_ma_){return aux(i$0,next,_ma_)}]}
          if(i$0 === tbl_data.length - 1)return 0;
          var
           buck$1=caml_check_bound(tbl_data,i$0)[1 + i$0],
           i$1=i$0 + 1 | 0,
           i$0=i$1,
           buck$0=buck$1;
          continue}}
      var _l9_=0,_l__=0;
      return function(_l$_){return aux(_l__,_l9_,_l$_)}}
    function to_seq_keys(m)
     {var _l5_=to_seq$9(m);
      function _l6_(_l8_){return _l8_[1]}
      return function(_l7_){return map(_l6_,_l5_,_l7_)}}
    function to_seq_values(m)
     {var _l1_=to_seq$9(m);
      function _l2_(_l4_){return _l4_[2]}
      return function(_l3_){return map(_l2_,_l1_,_l3_)}}
    function MakeSeeded(H)
     {function key_index(h,key)
       {var _l0_=h[2].length - 1 - 1 | 0;
        return caml_call2(H[2],h[3],key) & _l0_}
      function add(h,key,data)
       {var
         i=key_index(h,key),
         bucket=[0,key,data,caml_check_bound(h[2],i)[1 + i]];
        caml_check_bound(h[2],i)[1 + i] = bucket;
        h[1] = h[1] + 1 | 0;
        var _lZ_=h[2].length - 1 << 1 < h[1]?1:0;
        return _lZ_?resize$0(key_index,h):_lZ_}
      function remove(h,key)
       {var
         i=key_index(h,key),
         c$0=caml_check_bound(h[2],i)[1 + i],
         prec=0,
         c=c$0;
        for(;;)
         {if(c)
           {var k=c[1],next=c[3];
            if(caml_call2(H[1],k,key))
             {h[1] = h[1] - 1 | 0;
              return prec
                      ?(prec[3] = next,0)
                      :(caml_check_bound(h[2],i)[1 + i] = next,0)}
            var prec=c,c=next;
            continue}
          return 0}}
      function find(h,key)
       {var _lY_=key_index(h,key),match=caml_check_bound(h[2],_lY_)[1 + _lY_];
        if(match)
         {var k1=match[1],d1=match[2],next1=match[3];
          if(caml_call2(H[1],key,k1))return d1;
          if(next1)
           {var k2=next1[1],d2=next1[2],next2=next1[3];
            if(caml_call2(H[1],key,k2))return d2;
            if(next2)
             {var k3=next2[1],d3=next2[2],next3=next2[3];
              if(caml_call2(H[1],key,k3))return d3;
              var param=next3;
              for(;;)
               {if(param)
                 {var k=param[1],data=param[2],next=param[3];
                  if(caml_call2(H[1],key,k))return data;
                  var param=next;
                  continue}
                throw Not_found}}
            throw Not_found}
          throw Not_found}
        throw Not_found}
      function find_opt(h,key)
       {var _lX_=key_index(h,key),match=caml_check_bound(h[2],_lX_)[1 + _lX_];
        if(match)
         {var k1=match[1],d1=match[2],next1=match[3];
          if(caml_call2(H[1],key,k1))return [0,d1];
          if(next1)
           {var k2=next1[1],d2=next1[2],next2=next1[3];
            if(caml_call2(H[1],key,k2))return [0,d2];
            if(next2)
             {var k3=next2[1],d3=next2[2],next3=next2[3];
              if(caml_call2(H[1],key,k3))return [0,d3];
              var param=next3;
              for(;;)
               {if(param)
                 {var k=param[1],data=param[2],next=param[3];
                  if(caml_call2(H[1],key,k))return [0,data];
                  var param=next;
                  continue}
                return 0}}
            return 0}
          return 0}
        return 0}
      function find_all(h,key)
       {function find_in_bucket(param)
         {var param$0=param;
          for(;;)
           {if(param$0)
             {var k=param$0[1],d=param$0[2],next=param$0[3];
              if(caml_call2(H[1],k,key))return [0,d,find_in_bucket(next)];
              var param$0=next;
              continue}
            return 0}}
        var _lW_=key_index(h,key);
        return find_in_bucket(caml_check_bound(h[2],_lW_)[1 + _lW_])}
      function replace(h,key,data)
       {var
         i=key_index(h,key),
         param$0=caml_check_bound(h[2],i)[1 + i],
         param=param$0;
        for(;;)
         {if(param)
           {var k=param[1],next=param[3];
            if(! caml_call2(H[1],k,key)){var param=next;continue}
            param[1] = key;
            param[2] = data;
            var _lT_=0}
          else
           var _lT_=1;
          if(_lT_)
           {caml_check_bound(h[2],i)[1 + i] = [0,key,data,param$0];
            h[1] = h[1] + 1 | 0;
            var _lU_=h[2].length - 1 << 1 < h[1]?1:0;
            if(_lU_)return resize$0(key_index,h);
            var _lV_=_lU_}
          else
           var _lV_=_lT_;
          return _lV_}}
      function mem(h,key)
       {var
         _lS_=key_index(h,key),
         param$0=caml_check_bound(h[2],_lS_)[1 + _lS_],
         param=param$0;
        for(;;)
         {if(param)
           {var k=param[1],next=param[3],_lR_=caml_call2(H[1],k,key);
            if(_lR_)return _lR_;
            var param=next;
            continue}
          return 0}}
      function add_seq(tbl,i)
       {return iter
                (function(param)
                  {var v=param[2],k=param[1];return add(tbl,k,v)},
                 i)}
      function replace_seq(tbl,i)
       {return iter
                (function(param)
                  {var v=param[2],k=param[1];return replace(tbl,k,v)},
                 i)}
      function of_seq(i){var tbl=create$3(0,16);replace_seq(tbl,i);return tbl}
      return [0,
              create$3,
              clear$2,
              reset$0,
              copy$6,
              add,
              remove,
              find,
              find_opt,
              find_all,
              replace,
              mem,
              iter$10,
              filter_map_inplace,
              fold$3,
              length$4,
              stats,
              to_seq$9,
              to_seq_keys,
              to_seq_values,
              add_seq,
              replace_seq,
              of_seq]}
    function Make$0(H)
     {var equal=H[1];
      function hash(seed,x){return caml_call1(H[2],x)}
      var
       include=MakeSeeded([0,equal,hash]),
       clear=include[2],
       reset=include[3],
       copy=include[4],
       add=include[5],
       remove=include[6],
       find=include[7],
       find_opt=include[8],
       find_all=include[9],
       replace=include[10],
       mem=include[11],
       iter=include[12],
       filter_map_inplace=include[13],
       fold=include[14],
       length=include[15],
       stats=include[16],
       to_seq=include[17],
       to_seq_keys=include[18],
       to_seq_values=include[19],
       add_seq=include[20],
       replace_seq=include[21],
       _lQ_=include[1];
      function create(sz){return caml_call2(_lQ_,_b5_,sz)}
      function of_seq(i)
       {var tbl=create(16);caml_call2(replace_seq,tbl,i);return tbl}
      return [0,
              create,
              clear,
              reset,
              copy,
              add,
              remove,
              find,
              find_opt,
              find_all,
              replace,
              mem,
              iter,
              filter_map_inplace,
              fold,
              length,
              stats,
              to_seq,
              to_seq_keys,
              to_seq_values,
              add_seq,
              replace_seq,
              of_seq]}
    function hash$1(x){return caml_hash(10,100,0,x)}
    function hash_param(n1,n2,x){return caml_hash(n1,n2,0,x)}
    function seeded_hash(seed,x){return caml_hash(10,100,seed,x)}
    function key_index(h,key)
     {return 3 <= h.length - 1
              ?caml_hash(10,100,h[3],key) & (h[2].length - 1 - 1 | 0)
              :caml_mod
                (runtime.caml_hash_univ_param(10,100,key),h[2].length - 1)}
    function add$0(h,key,data)
     {var
       i=key_index(h,key),
       bucket=[0,key,data,caml_check_bound(h[2],i)[1 + i]];
      caml_check_bound(h[2],i)[1 + i] = bucket;
      h[1] = h[1] + 1 | 0;
      var _lP_=h[2].length - 1 << 1 < h[1]?1:0;
      return _lP_?resize$0(key_index,h):_lP_}
    function remove(h,key)
     {var i=key_index(h,key),c$0=caml_check_bound(h[2],i)[1 + i],prec=0,c=c$0;
      for(;;)
       {if(c)
         {var k=c[1],next=c[3];
          if(0 === caml_compare(k,key))
           {h[1] = h[1] - 1 | 0;
            return prec
                    ?(prec[3] = next,0)
                    :(caml_check_bound(h[2],i)[1 + i] = next,0)}
          var prec=c,c=next;
          continue}
        return 0}}
    function find$0(h,key)
     {var _lO_=key_index(h,key),match=caml_check_bound(h[2],_lO_)[1 + _lO_];
      if(match)
       {var k1=match[1],d1=match[2],next1=match[3];
        if(0 === caml_compare(key,k1))return d1;
        if(next1)
         {var k2=next1[1],d2=next1[2],next2=next1[3];
          if(0 === caml_compare(key,k2))return d2;
          if(next2)
           {var k3=next2[1],d3=next2[2],next3=next2[3];
            if(0 === caml_compare(key,k3))return d3;
            var param=next3;
            for(;;)
             {if(param)
               {var k=param[1],data=param[2],next=param[3];
                if(0 === caml_compare(key,k))return data;
                var param=next;
                continue}
              throw Not_found}}
          throw Not_found}
        throw Not_found}
      throw Not_found}
    function find_opt$0(h,key)
     {var _lN_=key_index(h,key),match=caml_check_bound(h[2],_lN_)[1 + _lN_];
      if(match)
       {var k1=match[1],d1=match[2],next1=match[3];
        if(0 === caml_compare(key,k1))return [0,d1];
        if(next1)
         {var k2=next1[1],d2=next1[2],next2=next1[3];
          if(0 === caml_compare(key,k2))return [0,d2];
          if(next2)
           {var k3=next2[1],d3=next2[2],next3=next2[3];
            if(0 === caml_compare(key,k3))return [0,d3];
            var param=next3;
            for(;;)
             {if(param)
               {var k=param[1],data=param[2],next=param[3];
                if(0 === caml_compare(key,k))return [0,data];
                var param=next;
                continue}
              return 0}}
          return 0}
        return 0}
      return 0}
    function find_all$0(h,key)
     {function find_in_bucket(param)
       {var param$0=param;
        for(;;)
         {if(param$0)
           {var k=param$0[1],data=param$0[2],next=param$0[3];
            if(0 === caml_compare(k,key))return [0,data,find_in_bucket(next)];
            var param$0=next;
            continue}
          return 0}}
      var _lM_=key_index(h,key);
      return find_in_bucket(caml_check_bound(h[2],_lM_)[1 + _lM_])}
    function replace(h,key,data)
     {var
       i=key_index(h,key),
       param$0=caml_check_bound(h[2],i)[1 + i],
       param=param$0;
      for(;;)
       {if(param)
         {var k=param[1],next=param[3];
          if(0 !== caml_compare(k,key)){var param=next;continue}
          param[1] = key;
          param[2] = data;
          var _lJ_=0}
        else
         var _lJ_=1;
        if(_lJ_)
         {caml_check_bound(h[2],i)[1 + i] = [0,key,data,param$0];
          h[1] = h[1] + 1 | 0;
          var _lK_=h[2].length - 1 << 1 < h[1]?1:0;
          if(_lK_)return resize$0(key_index,h);
          var _lL_=_lK_}
        else
         var _lL_=_lJ_;
        return _lL_}}
    function mem$2(h,key)
     {var
       _lI_=key_index(h,key),
       param$0=caml_check_bound(h[2],_lI_)[1 + _lI_],
       param=param$0;
      for(;;)
       {if(param)
         {var k=param[1],next=param[3],_lH_=0 === caml_compare(k,key)?1:0;
          if(_lH_)return _lH_;
          var param=next;
          continue}
        return 0}}
    function add_seq$2(tbl,i)
     {return iter
              (function(param)
                {var v=param[2],k=param[1];return add$0(tbl,k,v)},
               i)}
    function replace_seq(tbl,i)
     {return iter
              (function(param)
                {var v=param[2],k=param[1];return replace(tbl,k,v)},
               i)}
    function of_seq$7(i){var tbl=create$3(0,16);replace_seq(tbl,i);return tbl}
    var
     Stdlib_hashtbl=
      [0,
       create$3,
       clear$2,
       reset$0,
       copy$6,
       add$0,
       find$0,
       find_opt$0,
       find_all$0,
       mem$2,
       remove,
       replace,
       iter$10,
       filter_map_inplace,
       fold$3,
       length$4,
       randomize,
       is_randomized,
       stats,
       to_seq$9,
       to_seq_keys,
       to_seq_values,
       add_seq$2,
       replace_seq,
       of_seq$7,
       Make$0,
       MakeSeeded,
       hash$1,
       seeded_hash,
       hash_param,
       caml_hash];
    caml_register_global(786,Stdlib_hashtbl,"Stdlib__hashtbl");
    function weak_create(l)
     {var _lF_=0 <= l?1:0,_lG_=_lF_?l <= _r_[15]?1:0:_lF_;
      if(1 - _lG_)invalid_arg(cst_Weak_create);
      return runtime.caml_weak_create(l)}
    function length$5(x){return x.length - 1 - 2 | 0}
    function raise_if_invalid_offset$0(e,o,msg)
     {var _lC_=0 <= o?1:0,_lD_=_lC_?o < length$5(e)?1:0:_lC_,_lE_=1 - _lD_;
      return _lE_?invalid_arg(msg):_lE_}
    function set(e,o,x)
     {raise_if_invalid_offset$0(e,o,cst_Weak_set);
      if(x){var x$0=x[1];return caml_ephe_set_key(e,o,x$0)}
      return caml_ephe_unset_key(e,o)}
    function get$0(e,o)
     {raise_if_invalid_offset$0(e,o,cst_Weak_get);
      return runtime.caml_weak_get(e,o)}
    function get_copy(e,o)
     {raise_if_invalid_offset$0(e,o,cst_Weak_get_copy);
      return runtime.caml_weak_get_copy(e,o)}
    function check$0(e,o)
     {raise_if_invalid_offset$0(e,o,cst_Weak_check);
      return runtime.caml_weak_check(e,o)}
    function blit$4(e1,o1,e2,o2,l)
     {if
       (0
        <=
        l
        &&
        0
        <=
        o1
        &&
        !
        ((length$5(e1) - l | 0) < o1)
        &&
        0
        <=
        o2
        &&
        !
        ((length$5(e2) - l | 0) < o2))
       {var
         _lA_=0 !== l?1:0,
         _lB_=_lA_?runtime.caml_weak_blit(e1,o1,e2,o2,l):_lA_;
        return _lB_}
      return invalid_arg(cst_Weak_blit)}
    function fill$2(ar,ofs,len,x)
     {if(0 <= ofs && 0 <= len && ! ((length$5(ar) - len | 0) < ofs))
       {var _ly_=(ofs + len | 0) - 1 | 0;
        if(! (_ly_ < ofs))
         {var i=ofs;
          for(;;)
           {set(ar,i,x);
            var _lz_=i + 1 | 0;
            if(_ly_ !== i){var i=_lz_;continue}
            break}}
        return 0}
      throw [0,Invalid_argument,cst_Weak_fill]}
    function Make$1(H)
     {var emptybucket=weak_create(0);
      function get_index(t,h){return caml_mod(h & 2147483647,t[1].length - 1)}
      var limit=7;
      function create(sz)
       {var
         sz$0=7 <= sz?sz:7,
         sz$1=max_array_length < sz$0?max_array_length:sz$0;
        return [0,
                caml_make_vect(sz$1,emptybucket),
                caml_make_vect(sz$1,[0]),
                limit,
                0,
                0]}
      function clear(t)
       {var _lw_=t[1].length - 1 - 1 | 0,_lv_=0;
        if(! (_lw_ < 0))
         {var i=_lv_;
          for(;;)
           {caml_check_bound(t[1],i)[1 + i] = emptybucket;
            caml_check_bound(t[2],i)[1 + i] = [0];
            var _lx_=i + 1 | 0;
            if(_lw_ !== i){var i=_lx_;continue}
            break}}
        t[3] = limit;
        t[4] = 0;
        return 0}
      function fold(f,t,init)
       {var _lu_=t[1],i=0;
        return fold_right$0
                (function(b,accu$1)
                  {var i$0=i,accu=accu$1;
                   for(;;)
                    {if(length$5(b) <= i$0)return accu;
                     var match=get$0(b,i$0);
                     if(match)
                      {var
                        v=match[1],
                        accu$0=caml_call2(f,v,accu),
                        i$1=i$0 + 1 | 0,
                        i$0=i$1,
                        accu=accu$0;
                       continue}
                     var i$2=i$0 + 1 | 0,i$0=i$2;
                     continue}},
                 _lu_,
                 init)}
      function iter(f,t)
       {var _lt_=t[1],i=0;
        return iter$5
                (function(b)
                  {var i$0=i;
                   for(;;)
                    {if(length$5(b) <= i$0)return 0;
                     var match=get$0(b,i$0);
                     if(match)
                      {var v=match[1];
                       caml_call1(f,v);
                       var i$1=i$0 + 1 | 0,i$0=i$1;
                       continue}
                     var i$2=i$0 + 1 | 0,i$0=i$2;
                     continue}},
                 _lt_)}
      function count_bucket(i,b,accu)
       {var i$0=i,accu$0=accu;
        for(;;)
         {if(length$5(b) <= i$0)return accu$0;
          var
           _ls_=check$0(b,i$0)?1:0,
           accu$1=accu$0 + _ls_ | 0,
           i$1=i$0 + 1 | 0,
           i$0=i$1,
           accu$0=accu$1;
          continue}}
      function count(t)
       {var _ln_=0,_lo_=t[1],_lp_=0;
        return fold_right$0
                (function(_lq_,_lr_){return count_bucket(_lp_,_lq_,_lr_)},
                 _lo_,
                 _ln_)}
      function add_aux(t,setter,d,h,index)
       {var
         bucket$0=caml_check_bound(t[1],index)[1 + index],
         hashes=caml_check_bound(t[2],index)[1 + index],
         sz=length$5(bucket$0),
         i$3=0;
        for(;;)
         {if(sz <= i$3)
           {var
             newsz=
              min(((3 * sz | 0) / 2 | 0) + 3 | 0,max_array_length - 2 | 0);
            if(newsz <= sz)failwith(cst_Weak_Make_hash_bucket_cann);
            var
             newbucket$0=weak_create(newsz),
             newhashes=caml_make_vect(newsz,0);
            blit$4(bucket$0,0,newbucket$0,0,sz);
            blit$1(hashes,0,newhashes,0,sz);
            caml_call3(setter,newbucket$0,sz,d);
            caml_check_bound(newhashes,sz)[1 + sz] = h;
            caml_check_bound(t[1],index)[1 + index] = newbucket$0;
            caml_check_bound(t[2],index)[1 + index] = newhashes;
            var _lj_=sz <= t[3]?1:0,_lk_=_lj_?t[3] < newsz?1:0:_lj_;
            if(_lk_)
             {t[4] = t[4] + 1 | 0;
              var i$4=0;
              for(;;)
               {var
                 _k$_=t[5],
                 bucket=caml_check_bound(t[1],_k$_)[1 + _k$_],
                 _la_=t[5],
                 hbucket=caml_check_bound(t[2],_la_)[1 + _la_],
                 n=length$5(bucket),
                 prev_len=(((n - 3 | 0) * 2 | 0) + 2 | 0) / 3 | 0,
                 live=count_bucket(0,bucket,0);
                if(live <= prev_len)
                 {var j$2=length$5(bucket) - 1 | 0,i$0=0,j=j$2;
                  for(;;)
                   {if(prev_len <= j)
                     {if(check$0(bucket,i$0))
                       {var i$1=i$0 + 1 | 0,i$0=i$1;continue}
                      if(check$0(bucket,j))
                       {blit$4(bucket,j,bucket,i$0,1);
                        var _lb_=caml_check_bound(hbucket,j)[1 + j];
                        caml_check_bound(hbucket,i$0)[1 + i$0] = _lb_;
                        var j$0=j - 1 | 0,i$2=i$0 + 1 | 0,i$0=i$2,j=j$0;
                        continue}
                      var j$1=j - 1 | 0,j=j$1;
                      continue}
                    if(0 === prev_len)
                     {var _lc_=t[5];
                      caml_check_bound(t[1],_lc_)[1 + _lc_] = emptybucket;
                      var _ld_=t[5];
                      caml_check_bound(t[2],_ld_)[1 + _ld_] = [0]}
                    else
                     {var newbucket=weak_create(prev_len);
                      blit$4(bucket,0,newbucket,0,prev_len);
                      var _lg_=t[5];
                      caml_check_bound(t[1],_lg_)[1 + _lg_] = newbucket;
                      var _lh_=sub$1(hbucket,0,prev_len),_li_=t[5];
                      caml_check_bound(t[2],_li_)[1 + _li_] = _lh_}
                    var _le_=t[3] < n?1:0,_lf_=_le_?prev_len <= t[3]?1:0:_le_;
                    if(_lf_)t[4] = t[4] - 1 | 0;
                    break}}
                t[5] = caml_mod(t[5] + 1 | 0,t[1].length - 1);
                var _lm_=i$4 + 1 | 0;
                if(2 !== i$4){var i$4=_lm_;continue}
                break}}
            var _ll_=((t[1].length - 1) / 2 | 0) < t[4]?1:0;
            if(_ll_)
             {var
               n$0=t[1].length - 1,
               newlen=min(((3 * n$0 | 0) / 2 | 0) + 3 | 0,max_array_length);
              if(n$0 < newlen)
               {var newt=create(newlen),_k__=t[1],i=0;
                iteri$2
                 (function(j,ob)
                   {var i$0=i;
                    for(;;)
                     {if(length$5(ob) <= i$0)return 0;
                      var match=check$0(ob,i$0);
                      if(match)
                       {var
                         oh=caml_check_bound(t[2],j)[1 + j],
                         setter$0=
                          function(i)
                           {function setter(nb,ni,param){return blit$4(ob,i,nb,ni,1)}
                            return setter},
                         setter=setter$0(i$0),
                         h=caml_check_bound(oh,i$0)[1 + i$0];
                        add_aux(newt,setter,0,h,get_index(newt,h));
                        var i$1=i$0 + 1 | 0,i$0=i$1;
                        continue}
                      var i$2=i$0 + 1 | 0,i$0=i$2;
                      continue}},
                  _k__);
                t[1] = newt[1];
                t[2] = newt[2];
                t[3] = newt[3];
                t[4] = newt[4];
                t[5] = caml_mod(t[5],newt[1].length - 1);
                return 0}
              t[3] = max_int;
              t[4] = 0;
              return 0}
            return _ll_}
          if(check$0(bucket$0,i$3)){var i$5=i$3 + 1 | 0,i$3=i$5;continue}
          caml_call3(setter,bucket$0,i$3,d);
          caml_check_bound(hashes,i$3)[1 + i$3] = h;
          return 0}}
      function add(t,d)
       {var h=caml_call1(H[2],d);return add_aux(t,set,[0,d],h,get_index(t,h))}
      function find_or(t,d,ifnotfound)
       {var
         h=caml_call1(H[2],d),
         index=get_index(t,h),
         bucket=caml_check_bound(t[1],index)[1 + index],
         hashes=caml_check_bound(t[2],index)[1 + index],
         sz=length$5(bucket),
         i=0;
        for(;;)
         {if(sz <= i)return caml_call2(ifnotfound,h,index);
          if(h === caml_check_bound(hashes,i)[1 + i])
           {var match=get_copy(bucket,i);
            if(match)
             {var v=match[1];
              if(caml_call2(H[1],v,d))
               {var match$0=get$0(bucket,i);
                if(match$0){var v$0=match$0[1];return v$0}
                var i$0=i + 1 | 0,i=i$0;
                continue}}
            var i$1=i + 1 | 0,i=i$1;
            continue}
          var i$2=i + 1 | 0,i=i$2;
          continue}}
      function merge(t,d)
       {return find_or
                (t,d,function(h,index){add_aux(t,set,[0,d],h,index);return d})}
      function find(t,d)
       {return find_or(t,d,function(h,index){throw Not_found})}
      function find_opt(t,d)
       {var
         h=caml_call1(H[2],d),
         index=get_index(t,h),
         bucket=caml_check_bound(t[1],index)[1 + index],
         hashes=caml_check_bound(t[2],index)[1 + index],
         sz=length$5(bucket),
         i=0;
        for(;;)
         {if(sz <= i)return 0;
          if(h === caml_check_bound(hashes,i)[1 + i])
           {var match=get_copy(bucket,i);
            if(match)
             {var v=match[1];
              if(caml_call2(H[1],v,d))
               {var v$0=get$0(bucket,i);
                if(v$0)return v$0;
                var i$0=i + 1 | 0,i=i$0;
                continue}}
            var i$1=i + 1 | 0,i=i$1;
            continue}
          var i$2=i + 1 | 0,i=i$2;
          continue}}
      function find_shadow(t,d,iffound,ifnotfound)
       {var
         h=caml_call1(H[2],d),
         index=get_index(t,h),
         bucket=caml_check_bound(t[1],index)[1 + index],
         hashes=caml_check_bound(t[2],index)[1 + index],
         sz=length$5(bucket),
         i=0;
        for(;;)
         {if(sz <= i)return ifnotfound;
          if(h === caml_check_bound(hashes,i)[1 + i])
           {var match=get_copy(bucket,i);
            if(match)
             {var v=match[1];
              if(caml_call2(H[1],v,d))return caml_call2(iffound,bucket,i)}
            var i$0=i + 1 | 0,i=i$0;
            continue}
          var i$1=i + 1 | 0,i=i$1;
          continue}}
      function remove(t,d)
       {var _k9_=0;
        return find_shadow(t,d,function(w,i){return set(w,i,0)},_k9_)}
      function mem(t,d)
       {var _k8_=0;return find_shadow(t,d,function(w,i){return 1},_k8_)}
      function find_all(t,d)
       {var
         h=caml_call1(H[2],d),
         index=get_index(t,h),
         bucket=caml_check_bound(t[1],index)[1 + index],
         hashes=caml_check_bound(t[2],index)[1 + index],
         sz=length$5(bucket),
         i=0,
         accu=0;
        for(;;)
         {if(sz <= i)return accu;
          if(h === caml_check_bound(hashes,i)[1 + i])
           {var match=get_copy(bucket,i);
            if(match)
             {var v=match[1];
              if(caml_call2(H[1],v,d))
               {var match$0=get$0(bucket,i);
                if(match$0)
                 {var
                   v$0=match$0[1],
                   accu$0=[0,v$0,accu],
                   i$0=i + 1 | 0,
                   i=i$0,
                   accu=accu$0;
                  continue}
                var i$1=i + 1 | 0,i=i$1;
                continue}}
            var i$2=i + 1 | 0,i=i$2;
            continue}
          var i$3=i + 1 | 0,i=i$3;
          continue}}
      function stats(t)
       {var len=t[1].length - 1,lens=map$5(length$5,t[1]);
        sort(caml_int_compare,lens);
        var
         _k0_=0,
         totlen=
          fold_left$1(function(_k7_,_k6_){return _k7_ + _k6_ | 0},_k0_,lens),
         _k1_=len - 1 | 0,
         _k3_=len / 2 | 0,
         _k2_=caml_check_bound(lens,_k1_)[1 + _k1_],
         _k4_=caml_check_bound(lens,_k3_)[1 + _k3_],
         _k5_=caml_check_bound(lens,0)[1];
        return [0,len,count(t),totlen,_k5_,_k4_,_k2_]}
      return [0,
              create,
              clear,
              merge,
              add,
              remove,
              find,
              find_opt,
              find_all,
              mem,
              iter,
              fold,
              count,
              stats]}
    var
     Stdlib_weak=
      [0,weak_create,length$5,set,get$0,get_copy,check$0,fill$2,blit$4,Make$1];
    caml_register_global(787,Stdlib_weak,"Stdlib__weak");
    function id$0(x){return x}
    var
     String_tag=[248,cst_Stdlib_Format_String_tag,caml_fresh_oo_id(0)],
     size=0,
     unknown=-1;
    function pp_enqueue(state,token)
     {state[13] = state[13] + token[3] | 0;return add(token,state[28])}
    var pp_infinity=1000000010;
    function pp_output_string(state,s)
     {return caml_call3(state[17],s,0,caml_ml_string_length(s))}
    function pp_output_newline(state){return caml_call1(state[19],0)}
    function format_pp_text(state,size,text)
     {state[9] = state[9] - size | 0;
      pp_output_string(state,text);
      state[11] = 0;
      return 0}
    function format_string(state,s)
     {var _kZ_=caml_string_notequal(s,cst$66);
      return _kZ_?format_pp_text(state,caml_ml_string_length(s),s):_kZ_}
    function break_new_line(state,param,width)
     {var after=param[3],offset=param[2],before=param[1];
      format_string(state,before);
      pp_output_newline(state);
      state[11] = 1;
      var
       indent=(state[6] - width | 0) + offset | 0,
       real_indent=min(state[8],indent);
      state[10] = real_indent;
      state[9] = state[6] - state[10] | 0;
      caml_call1(state[21],state[10]);
      return format_string(state,after)}
    function break_line(state,width){return break_new_line(state,_b6_,width)}
    function break_same_line(state,param)
     {var after=param[3],width=param[2],before=param[1];
      format_string(state,before);
      state[9] = state[9] - width | 0;
      caml_call1(state[20],width);
      return format_string(state,after)}
    function advance_left(state)
     {for(;;)
       {var match$12=peek_opt(state[28]);
        if(match$12)
         {var
           match$13=match$12[1],
           size$0=match$13[1],
           length$0=match$13[3],
           token=match$13[2],
           pending_count=state[13] - state[12] | 0,
           _kX_=0 <= size$0?1:0,
           _kY_=_kX_ || (state[9] <= pending_count?1:0);
          if(_kY_)
           {take(state[28]);
            var size$1=0 <= size$0?size$0:pp_infinity;
            if(typeof token === "number")
             switch(token)
              {case 0:
                var match$3=top_opt(state[3]);
                if(match$3)
                 {var
                   match$4=match$3[1],
                   tabs=match$4[1],
                   add_tab=
                    function(n,ls)
                     {if(ls)
                       {var l=ls[2],x=ls[1];
                        return caml_lessthan(n,x)?[0,n,ls]:[0,x,add_tab(n,l)]}
                      return [0,n,0]};
                  tabs[1] = add_tab(state[6] - state[9] | 0,tabs[1])}
                break;
               case 1:pop_opt(state[2]);break;
               case 2:pop_opt(state[3]);break;
               case 3:
                var match$5=top_opt(state[2]);
                if(match$5)
                 {var match$6=match$5[1],width$0=match$6[2];
                  break_line(state,width$0)}
                else
                 pp_output_newline(state);
                break;
               case 4:
                if(state[10] !== (state[6] - state[9] | 0))
                 {var match$1=take_opt(state[28]);
                  if(match$1)
                   {var match$2=match$1[1],size=match$2[1],length=match$2[3];
                    state[12] = state[12] - length | 0;
                    state[9] = state[9] + size | 0}}
                break;
               default:
                var match$7=pop_opt(state[5]);
                if(match$7)
                 {var
                   tag_name=match$7[1],
                   marker=caml_call1(state[25],tag_name);
                  pp_output_string(state,marker)}}
            else
             switch(token[0])
              {case 0:var s=token[1];format_pp_text(state,size$1,s);break;
               case 1:
                var
                 breaks=token[2],
                 fits=token[1],
                 off=breaks[2],
                 before=breaks[1],
                 match$8=top_opt(state[2]);
                if(match$8)
                 {var
                   match$9=match$8[1],
                   width$1=match$9[2],
                   box_type$0=match$9[1];
                  switch(box_type$0)
                   {case 0:break_same_line(state,fits);break;
                    case 1:break_new_line(state,breaks,width$1);break;
                    case 2:break_new_line(state,breaks,width$1);break;
                    case 3:
                     if(state[9] < (size$1 + caml_ml_string_length(before) | 0))
                      break_new_line(state,breaks,width$1);
                     else
                      break_same_line(state,fits);
                     break;
                    case 4:
                     if(state[11])
                      break_same_line(state,fits);
                     else
                      if(state[9] < (size$1 + caml_ml_string_length(before) | 0))
                       break_new_line(state,breaks,width$1);
                      else
                       if(((state[6] - width$1 | 0) + off | 0) < state[10])
                        break_new_line(state,breaks,width$1);
                       else
                        break_same_line(state,fits);
                     break;
                    default:break_same_line(state,fits)}}
                break;
               case 2:
                var
                 off$0=token[2],
                 n=token[1],
                 insertion_point=state[6] - state[9] | 0,
                 match$10=top_opt(state[3]);
                if(match$10)
                 {var match$11=match$10[1],tabs$0=match$11[1],_kV_=tabs$0[1];
                  if(_kV_)
                   {var first=_kV_[1],param=tabs$0[1];
                    for(;;)
                     {if(param)
                       {var tail=param[2],head=param[1];
                        if(! (insertion_point <= head)){var param=tail;continue}
                        var _kW_=head}
                      else
                       var _kW_=first;
                      var tab=_kW_;
                      break}}
                  else
                   var tab=insertion_point;
                  var offset=tab - insertion_point | 0;
                  if(0 <= offset)
                   break_same_line(state,[0,cst$68,offset + n | 0,cst$67]);
                  else
                   break_new_line
                    (state,[0,cst$70,tab + off$0 | 0,cst$69],state[6])}
                break;
               case 3:
                var
                 ty=token[2],
                 off$1=token[1],
                 insertion_point$0=state[6] - state[9] | 0;
                if(state[8] < insertion_point$0)
                 {var match=top_opt(state[2]);
                  if(match)
                   {var match$0=match[1],width=match$0[2],box_type=match$0[1];
                    if(state[9] < width)
                     {var switcher=box_type - 1 | 0;
                      if(! (3 < switcher >>> 0))break_line(state,width)}}
                  else
                   pp_output_newline(state)}
                var
                 width$2=state[9] - off$1 | 0,
                 box_type$1=1 === ty?1:state[9] < size$1?ty:5;
                push([0,box_type$1,width$2],state[2]);
                break;
               case 4:var tbox=token[1];push(tbox,state[3]);break;
               default:
                var
                 tag_name$0=token[1],
                 marker$0=caml_call1(state[24],tag_name$0);
                pp_output_string(state,marker$0);
                push(tag_name$0,state[5])}
            state[12] = length$0 + state[12] | 0;
            continue}
          return _kY_}
        return 0}}
    function enqueue_advance(state,tok)
     {pp_enqueue(state,tok);return advance_left(state)}
    function enqueue_string_as(state,size,s)
     {return enqueue_advance(state,[0,size,[0,s],size])}
    function initialize_scan_stack(stack)
     {clear(stack);
      var queue_elem=[0,unknown,_b7_,0];
      return push([0,-1,queue_elem],stack)}
    function set_size(state,ty)
     {var match=top_opt(state[1]);
      if(match)
       {var
         match$0=match[1],
         queue_elem=match$0[2],
         left_total=match$0[1],
         _kS_=queue_elem[1];
        if(left_total < state[12])return initialize_scan_stack(state[1]);
        var _kT_=queue_elem[2];
        if(typeof _kT_ !== "number")
         switch(_kT_[0])
          {case 3:
            var _kU_=1 - ty;
            return _kU_
                    ?(queue_elem[1] = state[13] + _kS_ | 0,pop_opt(state[1]),0)
                    :_kU_;
           case 1:
           case 2:
            return ty
                    ?(queue_elem[1] = state[13] + _kS_ | 0,pop_opt(state[1]),0)
                    :ty
           }
        return 0}
      return 0}
    function scan_push(state,b,token)
     {pp_enqueue(state,token);
      if(b)set_size(state,1);
      var elem=[0,state[13],token];
      return push(elem,state[1])}
    function pp_open_box_gen(state,indent,br_ty)
     {state[14] = state[14] + 1 | 0;
      if(state[14] < state[15])
       {var size=- state[13] | 0,elem=[0,size,[3,indent,br_ty],0];
        return scan_push(state,0,elem)}
      var _kQ_=state[14] === state[15]?1:0;
      if(_kQ_)
       {var _kR_=state[16];
        return enqueue_string_as(state,caml_ml_string_length(_kR_),_kR_)}
      return _kQ_}
    function pp_close_box(state,param)
     {var _kO_=1 < state[14]?1:0;
      if(_kO_)
       {if(state[14] < state[15])
         {pp_enqueue(state,[0,size,1,0]);set_size(state,1);set_size(state,0)}
        state[14] = state[14] - 1 | 0;
        var _kP_=0}
      else
       var _kP_=_kO_;
      return _kP_}
    function pp_open_stag(state,tag_name)
     {if(state[22]){push(tag_name,state[4]);caml_call1(state[26],tag_name)}
      var _kN_=state[23];
      if(_kN_)
       {var token=[5,tag_name];return pp_enqueue(state,[0,size,token,0])}
      return _kN_}
    function pp_close_stag(state,param)
     {if(state[23])pp_enqueue(state,[0,size,5,0]);
      var _kL_=state[22];
      if(_kL_)
       {var match=pop_opt(state[4]);
        if(match){var tag_name=match[1];return caml_call1(state[27],tag_name)}
        var _kM_=0}
      else
       var _kM_=_kL_;
      return _kM_}
    function pp_open_tag(state,s){return pp_open_stag(state,[0,String_tag,s])}
    function pp_close_tag(state,param){return pp_close_stag(state,0)}
    function pp_set_print_tags(state,b){state[22] = b;return 0}
    function pp_set_mark_tags(state,b){state[23] = b;return 0}
    function pp_get_print_tags(state,param){return state[22]}
    function pp_get_mark_tags(state,param){return state[23]}
    function pp_set_tags(state,b)
     {pp_set_print_tags(state,b);return pp_set_mark_tags(state,b)}
    function pp_get_formatter_stag_function(state,param)
     {return [0,state[24],state[25],state[26],state[27]]}
    function pp_set_formatter_stag_function(state,param)
     {var pct=param[4],pot=param[3],mct=param[2],mot=param[1];
      state[24] = mot;
      state[25] = mct;
      state[26] = pot;
      state[27] = pct;
      return 0}
    function pp_rinit(state)
     {state[12] = 1;
      state[13] = 1;
      clear$0(state[28]);
      initialize_scan_stack(state[1]);
      clear(state[2]);
      clear(state[3]);
      clear(state[4]);
      clear(state[5]);
      state[10] = 0;
      state[14] = 0;
      state[9] = state[6];
      return pp_open_box_gen(state,0,3)}
    function pp_flush_queue(state,b)
     {var _kK_=state[4];
      iter$7(function(param){return pp_close_tag(state,0)},_kK_);
      for(;;)
       {if(1 < state[14]){pp_close_box(state,0);continue}
        state[13] = pp_infinity;
        advance_left(state);
        if(b)pp_output_newline(state);
        return pp_rinit(state)}}
    function pp_print_as_size(state,size,s)
     {var _kJ_=state[14] < state[15]?1:0;
      return _kJ_?enqueue_string_as(state,size,s):_kJ_}
    function pp_print_as(state,isize,s)
     {return pp_print_as_size(state,isize,s)}
    function pp_print_string(state,s)
     {return pp_print_as(state,caml_ml_string_length(s),s)}
    function pp_print_int(state,i)
     {return pp_print_string(state,caml_string_of_jsbytes("" + i))}
    function pp_print_float(state,f)
     {return pp_print_string(state,to_string(f))}
    function pp_print_bool(state,b)
     {return pp_print_string(state,string_of_bool(b))}
    function pp_print_char(state,c){return pp_print_as(state,1,make$0(1,c))}
    function pp_open_hbox(state,param){return pp_open_box_gen(state,0,0)}
    function pp_open_vbox(state,indent)
     {return pp_open_box_gen(state,indent,1)}
    function pp_open_hvbox(state,indent)
     {return pp_open_box_gen(state,indent,2)}
    function pp_open_hovbox(state,indent)
     {return pp_open_box_gen(state,indent,3)}
    function pp_open_box(state,indent){return pp_open_box_gen(state,indent,4)}
    function pp_print_newline(state,param)
     {pp_flush_queue(state,1);return caml_call1(state[18],0)}
    function pp_print_flush(state,param)
     {pp_flush_queue(state,0);return caml_call1(state[18],0)}
    function pp_force_newline(state,param)
     {var _kI_=state[14] < state[15]?1:0;
      return _kI_?enqueue_advance(state,[0,size,3,0]):_kI_}
    function pp_print_if_newline(state,param)
     {var _kH_=state[14] < state[15]?1:0;
      return _kH_?enqueue_advance(state,[0,size,4,0]):_kH_}
    function pp_print_custom_break(state,fits,breaks)
     {var
       after=fits[3],
       width=fits[2],
       before=fits[1],
       _kG_=state[14] < state[15]?1:0;
      if(_kG_)
       {var
         size=- state[13] | 0,
         token=[1,fits,breaks],
         length=
          (caml_ml_string_length(before) + width | 0)
          +
          caml_ml_string_length(after)
          |
          0,
         elem=[0,size,token,length];
        return scan_push(state,1,elem)}
      return _kG_}
    function pp_print_break(state,width,offset)
     {return pp_print_custom_break
              (state,[0,cst$74,width,cst$73],[0,cst$72,offset,cst$71])}
    function pp_print_space(state,param){return pp_print_break(state,1,0)}
    function pp_print_cut(state,param){return pp_print_break(state,0,0)}
    function pp_open_tbox(state,param)
     {state[14] = state[14] + 1 | 0;
      var _kF_=state[14] < state[15]?1:0;
      if(_kF_)
       {var elem=[0,size,[4,[0,[0,0]]],0];return enqueue_advance(state,elem)}
      return _kF_}
    function pp_close_tbox(state,param)
     {var _kC_=1 < state[14]?1:0;
      if(_kC_)
       {var _kD_=state[14] < state[15]?1:0;
        if(_kD_)
         {var elem=[0,size,2,0];
          enqueue_advance(state,elem);
          state[14] = state[14] - 1 | 0;
          var _kE_=0}
        else
         var _kE_=_kD_}
      else
       var _kE_=_kC_;
      return _kE_}
    function pp_print_tbreak(state,width,offset)
     {var _kB_=state[14] < state[15]?1:0;
      if(_kB_)
       {var size=- state[13] | 0,elem=[0,size,[2,width,offset],width];
        return scan_push(state,1,elem)}
      return _kB_}
    function pp_print_tab(state,param){return pp_print_tbreak(state,0,0)}
    function pp_set_tab(state,param)
     {var _kA_=state[14] < state[15]?1:0;
      if(_kA_){var elem=[0,size,0,0];return enqueue_advance(state,elem)}
      return _kA_}
    function pp_set_max_boxes(state,n)
     {var _ky_=1 < n?1:0,_kz_=_ky_?(state[15] = n,0):_ky_;return _kz_}
    function pp_get_max_boxes(state,param){return state[15]}
    function pp_over_max_boxes(state,param)
     {return state[14] === state[15]?1:0}
    function pp_set_ellipsis_text(state,s){state[16] = s;return 0}
    function pp_get_ellipsis_text(state,param){return state[16]}
    function pp_limit(n){return n < 1000000010?n:1000000009}
    function pp_set_max_indent(state,n$0)
     {var _kx_=1 < n$0?1:0;
      if(_kx_)
       {var n$1=state[6] - n$0 | 0,_kw_=1 <= n$1?1:0;
        if(_kw_)
         {var n=pp_limit(n$1);
          state[7] = n;
          state[8] = state[6] - state[7] | 0;
          return pp_rinit(state)}
        return _kw_}
      return _kx_}
    function pp_get_max_indent(state,param){return state[8]}
    function pp_set_margin(state,n)
     {var _kv_=1 <= n?1:0;
      if(_kv_)
       {var n$0=pp_limit(n);
        state[6] = n$0;
        var
         new_max_indent=
          state[8] <= state[6]
           ?state[8]
           :max(max(state[6] - state[7] | 0,state[6] / 2 | 0),1);
        return pp_set_max_indent(state,new_max_indent)}
      return _kv_}
    function check_geometry(geometry)
     {var
       _kt_=1 < geometry[1]?1:0,
       _ku_=_kt_?geometry[1] < geometry[2]?1:0:_kt_;
      return _ku_}
    function pp_get_margin(state,param){return state[6]}
    function pp_set_geometry(state,max_indent,margin)
     {if(2 <= max_indent)
       {if(margin <= max_indent)
         throw [0,Invalid_argument,cst_Format_pp_set_geometry_mar];
        pp_set_margin(state,margin);
        return pp_set_max_indent(state,max_indent)}
      throw [0,Invalid_argument,cst_Format_pp_set_geometry_max]}
    function pp_safe_set_geometry(state,max_indent,margin)
     {return check_geometry([0,max_indent,margin])
              ?pp_set_geometry(state,max_indent,margin)
              :0}
    function pp_get_geometry(state,param){return [0,state[8],state[6]]}
    function pp_set_formatter_out_functions(state,param)
     {var j=param[5],i=param[4],h=param[3],g=param[2],f=param[1];
      state[17] = f;
      state[18] = g;
      state[19] = h;
      state[20] = i;
      state[21] = j;
      return 0}
    function pp_get_formatter_out_functions(state,param)
     {return [0,state[17],state[18],state[19],state[20],state[21]]}
    function pp_set_formatter_output_functi(state,f,g)
     {state[17] = f;state[18] = g;return 0}
    function pp_get_formatter_output_functi(state,param)
     {return [0,state[17],state[18]]}
    function display_newline(state,param)
     {return caml_call3(state[17],cst$75,0,1)}
    var blank_line=make$0(80,32);
    function display_indent(state,n)
     {var n$0=n;
      for(;;)
       {var _ks_=0 < n$0?1:0;
        if(_ks_)
         {if(80 < n$0)
           {caml_call3(state[17],blank_line,0,80);
            var n$1=n$0 - 80 | 0,n$0=n$1;
            continue}
          return caml_call3(state[17],blank_line,0,n$0)}
        return _ks_}}
    function pp_set_formatter_out_channel(state,oc)
     {state[17]
      =
      function(_kp_,_kq_,_kr_){return output_substring(oc,_kp_,_kq_,_kr_)};
      state[18] = function(param){return caml_ml_flush(oc)};
      state[19] = function(_ko_){return display_newline(state,_ko_)};
      state[20] = function(_kn_){return display_indent(state,_kn_)};
      state[21] = function(_km_){return display_indent(state,_km_)};
      return 0}
    function default_pp_mark_open_tag(param)
     {if(param[1] === String_tag)
       {var s=param[2];return symbol(cst$77,symbol(s,cst$76))}
      return cst$78}
    function default_pp_mark_close_tag(param)
     {if(param[1] === String_tag)
       {var s=param[2];return symbol(cst$80,symbol(s,cst$79))}
      return cst$81}
    function default_pp_print_open_tag(_kl_){return 0}
    function default_pp_print_close_tag(_kk_){return 0}
    function pp_make_formatter(f,g,h,i,j)
     {var pp_queue=create$1(0),sys_tok=[0,unknown,_b8_,0];
      add(sys_tok,pp_queue);
      var scan_stack=create$0(0);
      initialize_scan_stack(scan_stack);
      push([0,1,sys_tok],scan_stack);
      var _kh_=create$0(0),_ki_=create$0(0),_kj_=create$0(0);
      return [0,
              scan_stack,
              create$0(0),
              _kj_,
              _ki_,
              _kh_,
              78,
              10,
              68,
              78,
              0,
              1,
              1,
              1,
              1,
              max_int,
              cst$82,
              f,
              g,
              h,
              i,
              j,
              0,
              0,
              default_pp_mark_open_tag,
              default_pp_mark_close_tag,
              default_pp_print_open_tag,
              default_pp_print_close_tag,
              pp_queue]}
    function formatter_of_out_functions(out_funs)
     {return pp_make_formatter
              (out_funs[1],out_funs[2],out_funs[3],out_funs[4],out_funs[5])}
    function make_formatter(output,flush)
     {function _j$_(_kg_){return 0}
      function _ka_(_kf_){return 0}
      var
       ppf=
        pp_make_formatter(output,flush,function(_ke_){return 0},_ka_,_j$_);
      ppf[19] = function(_kd_){return display_newline(ppf,_kd_)};
      ppf[20] = function(_kc_){return display_indent(ppf,_kc_)};
      ppf[21] = function(_kb_){return display_indent(ppf,_kb_)};
      return ppf}
    function formatter_of_out_channel(oc)
     {function _j7_(param){return caml_ml_flush(oc)}
      return make_formatter
              (function(_j8_,_j9_,_j__)
                {return output_substring(oc,_j8_,_j9_,_j__)},
               _j7_)}
    function formatter_of_buffer(b)
     {function _j2_(_j6_){return 0}
      return make_formatter
              (function(_j3_,_j4_,_j5_)
                {return add_substring(b,_j3_,_j4_,_j5_)},
               _j2_)}
    var pp_buffer_size=512;
    function pp_make_buffer(param){return create$2(pp_buffer_size)}
    var
     stdbuf=pp_make_buffer(0),
     std_formatter=formatter_of_out_channel(stdout),
     err_formatter=formatter_of_out_channel(stderr),
     str_formatter=formatter_of_buffer(stdbuf);
    function flush_buffer_formatter(buf,ppf)
     {pp_flush_queue(ppf,0);var s=contents(buf);reset(buf);return s}
    function flush_str_formatter(param)
     {return flush_buffer_formatter(stdbuf,str_formatter)}
    function make_symbolic_output_buffer(param){return [0,0]}
    function clear_symbolic_output_buffer(sob){sob[1] = 0;return 0}
    function get_symbolic_output_buffer(sob){return rev(sob[1])}
    function flush_symbolic_output_buffer(sob)
     {var items=get_symbolic_output_buffer(sob);
      clear_symbolic_output_buffer(sob);
      return items}
    function add_symbolic_output_item(sob,item)
     {sob[1] = [0,item,sob[1]];return 0}
    function formatter_of_symbolic_output_b(sob)
     {function f(s,i,n){return add_symbolic_output_item(sob,[0,sub$0(s,i,n)])}
      function g(_j1_){return add_symbolic_output_item(sob,0)}
      function h(_j0_){return add_symbolic_output_item(sob,1)}
      function i(n){return add_symbolic_output_item(sob,[1,n])}
      function j(n){return add_symbolic_output_item(sob,[2,n])}
      return pp_make_formatter(f,g,h,i,j)}
    function open_hbox(_jZ_){return pp_open_hbox(std_formatter,_jZ_)}
    function open_vbox(_jY_){return pp_open_vbox(std_formatter,_jY_)}
    function open_hvbox(_jX_){return pp_open_hvbox(std_formatter,_jX_)}
    function open_hovbox(_jW_){return pp_open_hovbox(std_formatter,_jW_)}
    function open_box(_jV_){return pp_open_box(std_formatter,_jV_)}
    function close_box(_jU_){return pp_close_box(std_formatter,_jU_)}
    function open_tag(_jT_){return pp_open_tag(std_formatter,_jT_)}
    function close_tag(_jS_){return pp_close_tag(std_formatter,_jS_)}
    function open_stag(_jR_){return pp_open_stag(std_formatter,_jR_)}
    function close_stag(_jQ_){return pp_close_stag(std_formatter,_jQ_)}
    function print_as(_jO_,_jP_){return pp_print_as(std_formatter,_jO_,_jP_)}
    function print_string$0(_jN_){return pp_print_string(std_formatter,_jN_)}
    function print_int$0(_jM_){return pp_print_int(std_formatter,_jM_)}
    function print_float$0(_jL_){return pp_print_float(std_formatter,_jL_)}
    function print_char$0(_jK_){return pp_print_char(std_formatter,_jK_)}
    function print_bool(_jJ_){return pp_print_bool(std_formatter,_jJ_)}
    function print_break(_jH_,_jI_)
     {return pp_print_break(std_formatter,_jH_,_jI_)}
    function print_cut(_jG_){return pp_print_cut(std_formatter,_jG_)}
    function print_space(_jF_){return pp_print_space(std_formatter,_jF_)}
    function force_newline(_jE_){return pp_force_newline(std_formatter,_jE_)}
    function print_flush(_jD_){return pp_print_flush(std_formatter,_jD_)}
    function print_newline$0(_jC_)
     {return pp_print_newline(std_formatter,_jC_)}
    function print_if_newline(_jB_)
     {return pp_print_if_newline(std_formatter,_jB_)}
    function open_tbox(_jA_){return pp_open_tbox(std_formatter,_jA_)}
    function close_tbox(_jz_){return pp_close_tbox(std_formatter,_jz_)}
    function print_tbreak(_jx_,_jy_)
     {return pp_print_tbreak(std_formatter,_jx_,_jy_)}
    function set_tab(_jw_){return pp_set_tab(std_formatter,_jw_)}
    function print_tab(_jv_){return pp_print_tab(std_formatter,_jv_)}
    function set_margin(_ju_){return pp_set_margin(std_formatter,_ju_)}
    function get_margin(_jt_){return std_formatter[6]}
    function set_max_indent(_js_)
     {return pp_set_max_indent(std_formatter,_js_)}
    function get_max_indent(_jr_){return std_formatter[8]}
    function set_geometry(_jp_,_jq_)
     {return pp_set_geometry(std_formatter,_jp_,_jq_)}
    function safe_set_geometry(_jn_,_jo_)
     {return pp_safe_set_geometry(std_formatter,_jn_,_jo_)}
    function get_geometry(_jm_){return pp_get_geometry(std_formatter,_jm_)}
    function set_max_boxes(_jl_){return pp_set_max_boxes(std_formatter,_jl_)}
    function get_max_boxes(_jk_){return std_formatter[15]}
    function over_max_boxes(_jj_)
     {return pp_over_max_boxes(std_formatter,_jj_)}
    function set_ellipsis_text(_ji_)
     {return pp_set_ellipsis_text(std_formatter,_ji_)}
    function get_ellipsis_text(_jh_){return std_formatter[16]}
    function set_formatter_out_channel(_jg_)
     {return pp_set_formatter_out_channel(std_formatter,_jg_)}
    function set_formatter_out_functions(_jf_)
     {return pp_set_formatter_out_functions(std_formatter,_jf_)}
    function get_formatter_out_functions(_je_)
     {return pp_get_formatter_out_functions(std_formatter,_je_)}
    function set_formatter_output_functions(_jc_,_jd_)
     {return pp_set_formatter_output_functi(std_formatter,_jc_,_jd_)}
    function get_formatter_output_functions(_jb_)
     {return pp_get_formatter_output_functi(std_formatter,_jb_)}
    function set_formatter_stag_functions(_ja_)
     {return pp_set_formatter_stag_function(std_formatter,_ja_)}
    function get_formatter_stag_functions(_i$_)
     {return pp_get_formatter_stag_function(std_formatter,_i$_)}
    function set_print_tags(_i__)
     {return pp_set_print_tags(std_formatter,_i__)}
    function get_print_tags(_i9_){return std_formatter[22]}
    function set_mark_tags(_i8_){return pp_set_mark_tags(std_formatter,_i8_)}
    function get_mark_tags(_i7_){return std_formatter[23]}
    function set_tags(_i6_){return pp_set_tags(std_formatter,_i6_)}
    function pp_print_list(opt,pp_v,ppf,param)
     {var opt$0=opt,param$0=param;
      for(;;)
       {if(opt$0)var sth=opt$0[1],pp_sep=sth;else var pp_sep=pp_print_cut;
        if(param$0)
         {var _i5_=param$0[1];
          if(param$0[2])
           {var vs=param$0[2];
            caml_call2(pp_v,ppf,_i5_);
            caml_call2(pp_sep,ppf,0);
            var opt$1=[0,pp_sep],opt$0=opt$1,param$0=vs;
            continue}
          return caml_call2(pp_v,ppf,_i5_)}
        return 0}}
    function pp_print_text(ppf,s)
     {var len=caml_ml_string_length(s),left=[0,0],right=[0,0];
      function flush(param)
       {pp_print_string(ppf,sub$0(s,left[1],right[1] - left[1] | 0));
        right[1]++;
        left[1] = right[1];
        return 0}
      for(;;)
       {if(right[1] !== len)
         {var match=caml_string_get(s,right[1]);
          if(10 === match)
           {flush(0);pp_force_newline(ppf,0)}
          else
           if(32 === match){flush(0);pp_print_space(ppf,0)}else right[1]++;
          continue}
        var _i4_=left[1] !== len?1:0;
        return _i4_?flush(0):_i4_}}
    function pp_print_option(opt,pp_v,ppf,param)
     {if(opt)
       var sth=opt[1],none=sth;
      else
       var none=function(param,_i3_){return 0};
      if(param){var v=param[1];return caml_call2(pp_v,ppf,v)}
      return caml_call2(none,ppf,0)}
    function pp_print_result(ok,error,ppf,param)
     {if(0 === param[0]){var v=param[1];return caml_call2(ok,ppf,v)}
      var e=param[1];
      return caml_call2(error,ppf,e)}
    function compute_tag(output,tag_acc)
     {var buf=create$2(16),ppf=formatter_of_buffer(buf);
      caml_call2(output,ppf,tag_acc);
      pp_print_flush(ppf,0);
      var len=buf[2];
      return 2 <= len?sub$3(buf,1,len - 2 | 0):contents(buf)}
    function output_formatting_lit(ppf,fmting_lit)
     {if(typeof fmting_lit === "number")
       switch(fmting_lit)
        {case 0:return pp_close_box(ppf,0);
         case 1:return pp_close_tag(ppf,0);
         case 2:return pp_print_flush(ppf,0);
         case 3:return pp_force_newline(ppf,0);
         case 4:return pp_print_newline(ppf,0);
         case 5:return pp_print_char(ppf,64);
         default:return pp_print_char(ppf,37)}
      else
       switch(fmting_lit[0])
        {case 0:
          var offset=fmting_lit[3],width=fmting_lit[2];
          return pp_print_break(ppf,width,offset);
         case 1:return 0;
         default:
          var c=fmting_lit[1];
          pp_print_char(ppf,64);
          return pp_print_char(ppf,c)}}
    function output_acc$0(ppf,acc)
     {var switch$0=0;
      if(typeof acc === "number")
       return 0;
      else
       switch(acc[0])
        {case 0:
          var f=acc[2],p=acc[1];
          output_acc$0(ppf,p);
          return output_formatting_lit(ppf,f);
         case 1:
          var _iT_=acc[2],_iU_=acc[1];
          if(0 === _iT_[0])
           {var acc$0=_iT_[1];
            output_acc$0(ppf,_iU_);
            return pp_open_stag
                    (ppf,[0,String_tag,compute_tag(output_acc$0,acc$0)])}
          var acc$1=_iT_[1];
          output_acc$0(ppf,_iU_);
          var
           match=open_box_of_string(compute_tag(output_acc$0,acc$1)),
           bty=match[2],
           indent=match[1];
          return pp_open_box_gen(ppf,indent,bty);
         case 2:
          var _iV_=acc[1],switch$1=0;
          if(typeof _iV_ !== "number" && 0 === _iV_[0])
           {var _iW_=_iV_[2],switch$2=0;
            if(typeof _iW_ !== "number" && 1 === _iW_[0])
             {var s$0=acc[2],size=_iW_[2],p$1=_iV_[1];
              switch$1 = 1;
              switch$2 = 1}}
          if(! switch$1){var s=acc[2],p$0=_iV_;switch$0 = 2}
          break;
         case 3:
          var _iX_=acc[1],switch$3=0;
          if(typeof _iX_ !== "number" && 0 === _iX_[0])
           {var _iY_=_iX_[2],switch$4=0;
            if(typeof _iY_ !== "number" && 1 === _iY_[0])
             {var c$0=acc[2],size$0=_iY_[2],p$3=_iX_[1];
              switch$0 = 1;
              switch$3 = 1;
              switch$4 = 1}}
          if(! switch$3){var c=acc[2],p$2=_iX_;switch$0 = 3}
          break;
         case 4:
          var _iZ_=acc[1],switch$5=0;
          if(typeof _iZ_ !== "number" && 0 === _iZ_[0])
           {var _i0_=_iZ_[2],switch$6=0;
            if(typeof _i0_ !== "number" && 1 === _i0_[0])
             {var s$0=acc[2],size=_i0_[2],p$1=_iZ_[1];
              switch$5 = 1;
              switch$6 = 1}}
          if(! switch$5){var s=acc[2],p$0=_iZ_;switch$0 = 2}
          break;
         case 5:
          var _i1_=acc[1],switch$7=0;
          if(typeof _i1_ === "number" || ! (0 === _i1_[0]))
           switch$7 = 1;
          else
           {var _i2_=_i1_[2],switch$8=0;
            if(typeof _i2_ !== "number" && 1 === _i2_[0])
             {var c$0=acc[2],size$0=_i2_[2],p$3=_i1_[1];
              switch$0 = 1;
              switch$8 = 1}
            if(! switch$8)switch$7 = 1}
          if(switch$7){var c=acc[2],p$2=_i1_;switch$0 = 3}
          break;
         case 6:
          var f$0=acc[2],p$4=acc[1];
          output_acc$0(ppf,p$4);
          return caml_call1(f$0,ppf);
         case 7:
          var p$5=acc[1];output_acc$0(ppf,p$5);return pp_print_flush(ppf,0);
         default:
          var msg=acc[2],p$6=acc[1];
          output_acc$0(ppf,p$6);
          return invalid_arg(msg)}
      switch(switch$0)
       {case 0:output_acc$0(ppf,p$1);return pp_print_as_size(ppf,size,s$0);
        case 1:
         output_acc$0(ppf,p$3);
         return pp_print_as_size(ppf,size$0,make$0(1,c$0));
        case 2:output_acc$0(ppf,p$0);return pp_print_string(ppf,s);
        default:output_acc$0(ppf,p$2);return pp_print_char(ppf,c)}}
    function strput_acc$0(ppf,acc)
     {var switch$0=0;
      if(typeof acc === "number")
       return 0;
      else
       switch(acc[0])
        {case 0:
          var f=acc[2],p=acc[1];
          strput_acc$0(ppf,p);
          return output_formatting_lit(ppf,f);
         case 1:
          var _iH_=acc[2],_iI_=acc[1];
          if(0 === _iH_[0])
           {var acc$0=_iH_[1];
            strput_acc$0(ppf,_iI_);
            return pp_open_stag
                    (ppf,[0,String_tag,compute_tag(strput_acc$0,acc$0)])}
          var acc$1=_iH_[1];
          strput_acc$0(ppf,_iI_);
          var
           match=open_box_of_string(compute_tag(strput_acc$0,acc$1)),
           bty=match[2],
           indent=match[1];
          return pp_open_box_gen(ppf,indent,bty);
         case 2:
          var _iJ_=acc[1],switch$1=0;
          if(typeof _iJ_ !== "number" && 0 === _iJ_[0])
           {var _iK_=_iJ_[2],switch$2=0;
            if(typeof _iK_ !== "number" && 1 === _iK_[0])
             {var s$0=acc[2],size=_iK_[2],p$1=_iJ_[1];
              switch$1 = 1;
              switch$2 = 1}}
          if(! switch$1){var s=acc[2],p$0=_iJ_;switch$0 = 2}
          break;
         case 3:
          var _iL_=acc[1],switch$3=0;
          if(typeof _iL_ !== "number" && 0 === _iL_[0])
           {var _iM_=_iL_[2],switch$4=0;
            if(typeof _iM_ !== "number" && 1 === _iM_[0])
             {var c$0=acc[2],size$0=_iM_[2],p$3=_iL_[1];
              switch$0 = 1;
              switch$3 = 1;
              switch$4 = 1}}
          if(! switch$3){var c=acc[2],p$2=_iL_;switch$0 = 3}
          break;
         case 4:
          var _iN_=acc[1],switch$5=0;
          if(typeof _iN_ !== "number" && 0 === _iN_[0])
           {var _iO_=_iN_[2],switch$6=0;
            if(typeof _iO_ !== "number" && 1 === _iO_[0])
             {var s$0=acc[2],size=_iO_[2],p$1=_iN_[1];
              switch$5 = 1;
              switch$6 = 1}}
          if(! switch$5){var s=acc[2],p$0=_iN_;switch$0 = 2}
          break;
         case 5:
          var _iP_=acc[1],switch$7=0;
          if(typeof _iP_ === "number" || ! (0 === _iP_[0]))
           switch$7 = 1;
          else
           {var _iQ_=_iP_[2],switch$8=0;
            if(typeof _iQ_ !== "number" && 1 === _iQ_[0])
             {var c$0=acc[2],size$0=_iQ_[2],p$3=_iP_[1];
              switch$0 = 1;
              switch$8 = 1}
            if(! switch$8)switch$7 = 1}
          if(switch$7){var c=acc[2],p$2=_iP_;switch$0 = 3}
          break;
         case 6:
          var _iR_=acc[1];
          if(typeof _iR_ !== "number" && 0 === _iR_[0])
           {var _iS_=_iR_[2];
            if(typeof _iS_ !== "number" && 1 === _iS_[0])
             {var f$1=acc[2],size$1=_iS_[2],p$4=_iR_[1];
              strput_acc$0(ppf,p$4);
              return pp_print_as_size(ppf,size$1,caml_call1(f$1,0))}}
          var f$0=acc[2];
          strput_acc$0(ppf,_iR_);
          return pp_print_string(ppf,caml_call1(f$0,0));
         case 7:
          var p$5=acc[1];strput_acc$0(ppf,p$5);return pp_print_flush(ppf,0);
         default:
          var msg=acc[2],p$6=acc[1];
          strput_acc$0(ppf,p$6);
          return invalid_arg(msg)}
      switch(switch$0)
       {case 0:strput_acc$0(ppf,p$1);return pp_print_as_size(ppf,size,s$0);
        case 1:
         strput_acc$0(ppf,p$3);
         return pp_print_as_size(ppf,size$0,make$0(1,c$0));
        case 2:strput_acc$0(ppf,p$0);return pp_print_string(ppf,s);
        default:strput_acc$0(ppf,p$2);return pp_print_char(ppf,c)}}
    function kfprintf$0(k,ppf,param)
     {var fmt=param[1],_iG_=0;
      return make_printf
              (function(acc){output_acc$0(ppf,acc);return caml_call1(k,ppf)},
               _iG_,
               fmt)}
    function ikfprintf$0(k,ppf,param)
     {var fmt=param[1];return make_iprintf(k,ppf,fmt)}
    function ifprintf$0(ppf,param)
     {var fmt=param[1],_iE_=0;
      return make_iprintf(function(_iF_){return 0},_iE_,fmt)}
    function fprintf$0(ppf)
     {function _iB_(_iD_){return 0}
      return function(_iC_){return kfprintf$0(_iB_,ppf,_iC_)}}
    function printf$0(fmt){return caml_call1(fprintf$0(std_formatter),fmt)}
    function eprintf$0(fmt){return caml_call1(fprintf$0(err_formatter),fmt)}
    function kdprintf(k,param)
     {var fmt=param[1],_iA_=0;
      return make_printf
              (function(acc)
                {return caml_call1
                         (k,function(ppf){return output_acc$0(ppf,acc)})},
               _iA_,
               fmt)}
    function dprintf(fmt){return kdprintf(function(i){return i},fmt)}
    function kprintf(k,param)
     {var fmt=param[1],b=pp_make_buffer(0),ppf=formatter_of_buffer(b);
      function k$0(acc)
       {strput_acc$0(ppf,acc);
        return caml_call1(k,flush_buffer_formatter(b,ppf))}
      return make_printf(k$0,0,fmt)}
    function sprintf$0(fmt){return kprintf(id$0,fmt)}
    function kasprintf(k,param)
     {var fmt=param[1],b=pp_make_buffer(0),ppf=formatter_of_buffer(b);
      function k$0(acc)
       {output_acc$0(ppf,acc);
        return caml_call1(k,flush_buffer_formatter(b,ppf))}
      return make_printf(k$0,0,fmt)}
    function asprintf(fmt){return kasprintf(id$0,fmt)}
    function flush_standard_formatters(param)
     {pp_print_flush(std_formatter,0);return pp_print_flush(err_formatter,0)}
    at_exit(flush_standard_formatters);
    function pp_set_all_formatter_output_fu(state,f,g,h,i)
     {pp_set_formatter_output_functi(state,f,g);
      state[19] = h;
      state[20] = i;
      return 0}
    function pp_get_all_formatter_output_fu(state,param)
     {return [0,state[17],state[18],state[19],state[20]]}
    function set_all_formatter_output_funct(_iw_,_ix_,_iy_,_iz_)
     {return pp_set_all_formatter_output_fu(std_formatter,_iw_,_ix_,_iy_,_iz_)}
    function get_all_formatter_output_funct(_iv_)
     {return pp_get_all_formatter_output_fu(std_formatter,_iv_)}
    function bprintf$0(b,param)
     {var fmt=param[1],ppf=formatter_of_buffer(b);
      function k(acc){output_acc$0(ppf,acc);return pp_flush_queue(ppf,0)}
      return make_printf(k,0,fmt)}
    function pp_set_formatter_tag_functions(state,param)
     {var pct=param[4],pot=param[3],mct=param[2],mot=param[1];
      function stringify(f,e,param)
       {if(param[1] === String_tag){var s=param[2];return caml_call1(f,s)}
        return e}
      state[24] = function(_iu_){return stringify(mot,cst$83,_iu_)};
      state[25] = function(_it_){return stringify(mct,cst$84,_it_)};
      var _ip_=0;
      state[26] = function(_is_){return stringify(pot,_ip_,_is_)};
      var _iq_=0;
      state[27] = function(_ir_){return stringify(pct,_iq_,_ir_)};
      return 0}
    function pp_get_formatter_tag_functions(fmt,param)
     {var funs=pp_get_formatter_stag_function(fmt,0);
      function mark_open_tag(s){return caml_call1(funs[1],[0,String_tag,s])}
      function mark_close_tag(s){return caml_call1(funs[2],[0,String_tag,s])}
      function print_open_tag(s){return caml_call1(funs[3],[0,String_tag,s])}
      function print_close_tag(s){return caml_call1(funs[4],[0,String_tag,s])}
      return [0,mark_open_tag,mark_close_tag,print_open_tag,print_close_tag]}
    function set_formatter_tag_functions(_io_)
     {return pp_set_formatter_tag_functions(std_formatter,_io_)}
    function get_formatter_tag_functions(_in_)
     {return pp_get_formatter_tag_functions(std_formatter,_in_)}
    var
     Stdlib_format=
      [0,
       pp_open_box,
       open_box,
       pp_close_box,
       close_box,
       pp_open_hbox,
       open_hbox,
       pp_open_vbox,
       open_vbox,
       pp_open_hvbox,
       open_hvbox,
       pp_open_hovbox,
       open_hovbox,
       pp_print_string,
       print_string$0,
       pp_print_as,
       print_as,
       pp_print_int,
       print_int$0,
       pp_print_float,
       print_float$0,
       pp_print_char,
       print_char$0,
       pp_print_bool,
       print_bool,
       pp_print_space,
       print_space,
       pp_print_cut,
       print_cut,
       pp_print_break,
       print_break,
       pp_print_custom_break,
       pp_force_newline,
       force_newline,
       pp_print_if_newline,
       print_if_newline,
       pp_print_flush,
       print_flush,
       pp_print_newline,
       print_newline$0,
       pp_set_margin,
       set_margin,
       pp_get_margin,
       get_margin,
       pp_set_max_indent,
       set_max_indent,
       pp_get_max_indent,
       get_max_indent,
       check_geometry,
       pp_set_geometry,
       set_geometry,
       pp_safe_set_geometry,
       safe_set_geometry,
       pp_get_geometry,
       get_geometry,
       pp_set_max_boxes,
       set_max_boxes,
       pp_get_max_boxes,
       get_max_boxes,
       pp_over_max_boxes,
       over_max_boxes,
       pp_open_tbox,
       open_tbox,
       pp_close_tbox,
       close_tbox,
       pp_set_tab,
       set_tab,
       pp_print_tab,
       print_tab,
       pp_print_tbreak,
       print_tbreak,
       pp_set_ellipsis_text,
       set_ellipsis_text,
       pp_get_ellipsis_text,
       get_ellipsis_text,
       String_tag,
       pp_open_stag,
       open_stag,
       pp_close_stag,
       close_stag,
       pp_set_tags,
       set_tags,
       pp_set_print_tags,
       set_print_tags,
       pp_set_mark_tags,
       set_mark_tags,
       pp_get_print_tags,
       get_print_tags,
       pp_get_mark_tags,
       get_mark_tags,
       pp_set_formatter_out_channel,
       set_formatter_out_channel,
       pp_set_formatter_output_functi,
       set_formatter_output_functions,
       pp_get_formatter_output_functi,
       get_formatter_output_functions,
       pp_set_formatter_out_functions,
       set_formatter_out_functions,
       pp_get_formatter_out_functions,
       get_formatter_out_functions,
       pp_set_formatter_stag_function,
       set_formatter_stag_functions,
       pp_get_formatter_stag_function,
       get_formatter_stag_functions,
       formatter_of_out_channel,
       std_formatter,
       err_formatter,
       formatter_of_buffer,
       stdbuf,
       str_formatter,
       flush_str_formatter,
       make_formatter,
       formatter_of_out_functions,
       make_symbolic_output_buffer,
       clear_symbolic_output_buffer,
       get_symbolic_output_buffer,
       flush_symbolic_output_buffer,
       add_symbolic_output_item,
       formatter_of_symbolic_output_b,
       pp_print_list,
       pp_print_text,
       pp_print_option,
       pp_print_result,
       fprintf$0,
       printf$0,
       eprintf$0,
       sprintf$0,
       asprintf,
       dprintf,
       ifprintf$0,
       kfprintf$0,
       kdprintf,
       ikfprintf$0,
       kprintf,
       kasprintf,
       bprintf$0,
       kprintf,
       set_all_formatter_output_funct,
       get_all_formatter_output_funct,
       pp_set_all_formatter_output_fu,
       pp_get_all_formatter_output_fu,
       pp_open_tag,
       open_tag,
       pp_close_tag,
       close_tag,
       pp_set_formatter_tag_functions,
       set_formatter_tag_functions,
       pp_get_formatter_tag_functions,
       get_formatter_tag_functions];
    caml_register_global(788,Stdlib_format,"Stdlib__format");
    var null_char=0;
    function next_char(ib)
     {try
       {var c=caml_call1(ib[7],0);
        ib[2] = c;
        ib[3] = 1;
        ib[4] = ib[4] + 1 | 0;
        if(10 === c)ib[5] = ib[5] + 1 | 0;
        return c}
      catch(_im_)
       {_im_ = caml_wrap_exception(_im_);
        if(_im_ === End_of_file)
         {ib[2] = null_char;ib[3] = 0;ib[1] = 1;return null_char}
        throw _im_}}
    function peek_char(ib){return ib[3]?ib[2]:next_char(ib)}
    function checked_peek_char(ib)
     {var c=peek_char(ib);if(ib[1])throw End_of_file;return c}
    function end_of_input(ib){peek_char(ib);return ib[1]}
    function beginning_of_input(ib){return 0 === ib[4]?1:0}
    function name_of_input(ib)
     {var _il_=ib[9];
      if(typeof _il_ === "number")
       return 0 === _il_?cst_unnamed_function:cst_unnamed_character_string;
      else
       {if(0 === _il_[0])return cst_unnamed_Stdlib_input_chann;
        var fname=_il_[1];
        return fname}}
    function char_count(ib){return ib[3]?ib[4] - 1 | 0:ib[4]}
    function reset_token(ib){return reset(ib[8])}
    function invalidate_current_char(ib){ib[3] = 0;return 0}
    function token_string(ib)
     {var token_buffer=ib[8],tok=contents(token_buffer);
      clear$1(token_buffer);
      ib[6] = ib[6] + 1 | 0;
      return tok}
    function skip_char(width,ib){invalidate_current_char(ib);return width}
    function ignore_char(width,ib){return skip_char(width - 1 | 0,ib)}
    function store_char(width,ib,c)
     {add_char(ib[8],c);return ignore_char(width,ib)}
    var default_token_buffer_size=1024;
    function create$4(iname,next)
     {return [0,
              0,
              null_char,
              0,
              0,
              0,
              0,
              next,
              create$2(default_token_buffer_size),
              iname]}
    function from_string$1(s)
     {var i=[0,0],len=caml_ml_string_length(s);
      function next(param)
       {if(len <= i[1])throw End_of_file;
        var c=caml_string_get(s,i[1]);
        i[1]++;
        return c}
      return create$4(1,next)}
    var _b9_=0;
    function from_function$0(_ik_){return create$4(_b9_,_ik_)}
    var len=1024;
    function scan_close_at_end(ic)
     {caml_ml_close_channel(ic);throw End_of_file}
    function scan_raise_at_end(ic){throw End_of_file}
    function from_ic(scan_close_ic,iname,ic)
     {var buf=caml_create_bytes(1024),i=[0,0],lim=[0,0],eof=[0,0];
      function next(param)
       {if(i[1] < lim[1]){var c=caml_bytes_get(buf,i[1]);i[1]++;return c}
        if(eof[1])throw End_of_file;
        lim[1] = input(ic,buf,0,len);
        return 0 === lim[1]
                ?(eof[1] = 1,caml_call1(scan_close_ic,ic))
                :(i[1] = 1,caml_bytes_get(buf,0))}
      return create$4(iname,next)}
    var stdib=from_ic(scan_raise_at_end,[1,cst$85,stdin],stdin);
    function open_in_file(open_in,fname)
     {if(caml_string_notequal(fname,cst$86))
       {var ic=caml_call1(open_in,fname);
        return from_ic(scan_close_at_end,[1,fname,ic],ic)}
      return stdib}
    function from_file(_ij_){return open_in_file(open_in,_ij_)}
    function from_file_bin(_ii_){return open_in_file(open_in_bin,_ii_)}
    function from_channel$0(ic){return from_ic(scan_raise_at_end,[0,ic],ic)}
    function close_in$0(ib)
     {var _ih_=ib[9];
      if(typeof _ih_ === "number")
       return 0;
      else
       {if(0 === _ih_[0]){var ic=_ih_[1];return caml_ml_close_channel(ic)}
        var ic$0=_ih_[2];
        return caml_ml_close_channel(ic$0)}}
    var memo=[0,0];
    function memo_from_ic(scan_close_ic,ic)
     {try
       {var _if_=assq(ic,memo[1]);return _if_}
      catch(_ig_)
       {_ig_ = caml_wrap_exception(_ig_);
        if(_ig_ === Not_found)
         {var ib=from_ic(scan_close_ic,[0,ic],ic);
          memo[1] = [0,[0,ic,ib],memo[1]];
          return ib}
        throw _ig_}}
    function memo_from_channel(_ie_)
     {return memo_from_ic(scan_raise_at_end,_ie_)}
    var Scan_failure=[248,cst_Stdlib_Scanf_Scan_failure,caml_fresh_oo_id(0)];
    function bad_input(s){throw [0,Scan_failure,s]}
    function bad_input_escape(c)
     {return bad_input(caml_call1(sprintf(_b__),c))}
    function bad_token_length(message)
     {return bad_input(caml_call1(sprintf(_b$_),message))}
    function bad_float(param)
     {return bad_input(cst_no_dot_or_exponent_part_fo)}
    function bad_hex_float(param)
     {return bad_input(cst_not_a_valid_float_in_hexad)}
    function character_mismatch(c,ci)
     {return bad_input(caml_call2(sprintf(_cb_),c,ci))}
    function check_this_char(ib,c)
     {var ci=checked_peek_char(ib);
      return ci === c?invalidate_current_char(ib):character_mismatch(c,ci)}
    function check_char(ib,c$0)
     {if(10 === c$0)
       {var ci=checked_peek_char(ib);
        return 10 === ci
                ?invalidate_current_char(ib)
                :13 === ci
                  ?(invalidate_current_char(ib),check_this_char(ib,10))
                  :character_mismatch(10,ci)}
      if(32 === c$0)
       for(;;)
        {var c=peek_char(ib),_ic_=1 - ib[1];
         if(_ic_)
          {var _id_=c - 9 | 0,switch$0=0;
           if(4 < _id_ >>> 0)
            {if(23 === _id_)switch$0 = 1}
           else
            if(1 < (_id_ - 2 | 0) >>> 0)switch$0 = 1;
           if(switch$0){invalidate_current_char(ib);continue}
           return 0}
         return _ic_}
      return check_this_char(ib,c$0)}
    function token_char(ib){return caml_string_get(token_string(ib),0)}
    function token_bool(ib)
     {var s=token_string(ib);
      return caml_string_notequal(s,cst_false$3)
              ?caml_string_notequal(s,cst_true$3)
                ?bad_input(caml_call1(sprintf(_cc_),s))
                :1
              :0}
    function integer_conversion_of_char(param)
     {var switcher=param - 88 | 0;
      if(! (32 < switcher >>> 0))
       switch(switcher)
        {case 10:return 0;
         case 12:return 1;
         case 17:return 2;
         case 23:return 3;
         case 29:return 4;
         case 0:
         case 32:return 5
         }
      throw [0,Assert_failure,_cd_]}
    function token_int_literal(conv,ib)
     {switch(conv)
       {case 0:var tok=symbol(cst_0b,token_string(ib));break;
        case 3:var tok=symbol(cst_0o,token_string(ib));break;
        case 4:var tok=symbol(cst_0u,token_string(ib));break;
        case 5:var tok=symbol(cst_0x,token_string(ib));break;
        default:var tok=token_string(ib)}
      var l=caml_ml_string_length(tok);
      if(0 !== l && 43 === caml_string_get(tok,0))
       return sub$0(tok,1,l - 1 | 0);
      return tok}
    function token_float(ib){return caml_float_of_string(token_string(ib))}
    function scan_decimal_digit_star(width,ib)
     {var width$0=width;
      for(;;)
       {if(0 === width$0)return width$0;
        var c=peek_char(ib);
        if(ib[1])return width$0;
        if(58 <= c)
         {if(95 === c)
           {var width$1=ignore_char(width$0,ib),width$0=width$1;continue}}
        else
         if(48 <= c)
          {var width$2=store_char(width$0,ib,c),width$0=width$2;continue}
        return width$0}}
    function scan_unsigned_decimal_int(width,ib)
     {if(0 === width)return bad_token_length(cst_decimal_digits);
      var c=checked_peek_char(ib),switcher=c - 48 | 0;
      if(9 < switcher >>> 0)return bad_input(caml_call1(sprintf(_ce_),c));
      var width$0=store_char(width,ib,c);
      return scan_decimal_digit_star(width$0,ib)}
    function scan_digit_plus(basis,digitp,width$2,ib)
     {if(0 === width$2)return bad_token_length(cst_digits);
      var c$0=checked_peek_char(ib);
      if(caml_call1(digitp,c$0))
       {var width$3=store_char(width$2,ib,c$0),width=width$3;
        for(;;)
         {if(0 === width)return width;
          var c=peek_char(ib);
          if(ib[1])return width;
          if(caml_call1(digitp,c))
           {var width$0=store_char(width,ib,c),width=width$0;continue}
          if(95 === c)
           {var width$1=ignore_char(width,ib),width=width$1;continue}
          return width}}
      return bad_input(caml_call2(sprintf(_cf_),c$0,basis))}
    function is_binary_digit(param)
     {var switcher=param - 48 | 0;return 1 < switcher >>> 0?0:1}
    function scan_binary_int(_ia_,_ib_)
     {return scan_digit_plus(cst_binary,is_binary_digit,_ia_,_ib_)}
    function is_octal_digit(param)
     {var switcher=param - 48 | 0;return 7 < switcher >>> 0?0:1}
    function scan_octal_int(_h__,_h$_)
     {return scan_digit_plus(cst_octal,is_octal_digit,_h__,_h$_)}
    function is_hexa_digit(param)
     {var _h9_=param - 48 | 0,switch$0=0;
      if(22 < _h9_ >>> 0)
       {if(! (5 < (_h9_ - 49 | 0) >>> 0))switch$0 = 1}
      else
       if(6 < (_h9_ - 10 | 0) >>> 0)switch$0 = 1;
      return switch$0?1:0}
    function scan_hexadecimal_int(_h7_,_h8_)
     {return scan_digit_plus(cst_hexadecimal,is_hexa_digit,_h7_,_h8_)}
    function scan_sign(width,ib)
     {var c=checked_peek_char(ib),switcher=c - 43 | 0;
      if(! (2 < switcher >>> 0))
       switch(switcher)
        {case 0:return store_char(width,ib,c);
         case 1:break;
         default:return store_char(width,ib,c)}
      return width}
    function scan_optionally_signed_decimal(width,ib)
     {var width$0=scan_sign(width,ib);
      return scan_unsigned_decimal_int(width$0,ib)}
    function scan_int_conversion(conv,width$1,ib)
     {switch(conv)
       {case 0:return scan_binary_int(width$1,ib);
        case 1:return scan_optionally_signed_decimal(width$1,ib);
        case 2:
         var width$0=scan_sign(width$1,ib),c=checked_peek_char(ib);
         if(48 === c)
          {var width=store_char(width$0,ib,c);
           if(0 === width)return width;
           var c$0=peek_char(ib);
           if(ib[1])return width;
           var switch$0=0;
           if(99 <= c$0)
            {if(111 === c$0)
              return scan_octal_int(store_char(width,ib,c$0),ib);
             if(120 === c$0)switch$0 = 1}
           else
            if(88 === c$0)
             switch$0 = 1;
            else
             if(98 <= c$0)return scan_binary_int(store_char(width,ib,c$0),ib);
           return switch$0
                   ?scan_hexadecimal_int(store_char(width,ib,c$0),ib)
                   :scan_decimal_digit_star(width,ib)}
         return scan_unsigned_decimal_int(width$0,ib);
        case 3:return scan_octal_int(width$1,ib);
        case 4:return scan_unsigned_decimal_int(width$1,ib);
        default:return scan_hexadecimal_int(width$1,ib)}}
    function scan_fractional_part(width,ib)
     {if(0 === width)return width;
      var c=peek_char(ib);
      if(ib[1])return width;
      var switcher=c - 48 | 0;
      return 9 < switcher >>> 0
              ?width
              :scan_decimal_digit_star(store_char(width,ib,c),ib)}
    function scan_exponent_part(width,ib)
     {if(0 === width)return width;
      var c=peek_char(ib);
      if(ib[1])return width;
      if(69 !== c && 101 !== c)return width;
      return scan_optionally_signed_decimal(store_char(width,ib,c),ib)}
    function scan_float(width$1,precision,ib)
     {var
       width=scan_sign(width$1,ib),
       width$0=scan_decimal_digit_star(width,ib);
      if(0 === width$0)return [0,width$0,precision];
      var c=peek_char(ib);
      if(ib[1])return [0,width$0,precision];
      if(46 === c)
       {var
         width$2=store_char(width$0,ib,c),
         precision$0=min(width$2,precision),
         width$3=
          width$2
          -
          (precision$0 - scan_fractional_part(precision$0,ib) | 0)
          |
          0;
        return [0,scan_exponent_part(width$3,ib),precision$0]}
      return [0,scan_exponent_part(width$0,ib),precision]}
    function check_case_insensitive_string(width,ib,error,str)
     {function lowercase(c)
       {var switcher=c - 65 | 0;
        return 25 < switcher >>> 0?c:char_of_int((c - 65 | 0) + 97 | 0)}
      var
       len=caml_ml_string_length(str),
       width$0=[0,width],
       _h4_=len - 1 | 0,
       _h3_=0;
      if(! (_h4_ < 0))
       {var i=_h3_;
        for(;;)
         {var c=peek_char(ib),_h5_=lowercase(caml_string_get(str,i));
          if(lowercase(c) !== _h5_)caml_call1(error,0);
          if(0 === width$0[1])caml_call1(error,0);
          width$0[1] = store_char(width$0[1],ib,c);
          var _h6_=i + 1 | 0;
          if(_h4_ !== i){var i=_h6_;continue}
          break}}
      return width$0[1]}
    function scan_hex_float(width,precision,ib)
     {var _hQ_=0 === width?1:0,_hR_=_hQ_ || end_of_input(ib);
      if(_hR_)bad_hex_float(0);
      var
       width$0=scan_sign(width,ib),
       _hS_=0 === width$0?1:0,
       _hT_=_hS_ || end_of_input(ib);
      if(_hT_)bad_hex_float(0);
      var c=peek_char(ib),switch$0=0;
      if(78 <= c)
       {var switcher=c - 79 | 0;
        if(30 < switcher >>> 0)
         {if(! (32 <= switcher))
           {var
             width$1=store_char(width$0,ib,c),
             _hU_=0 === width$1?1:0,
             _hV_=_hU_ || end_of_input(ib);
            if(_hV_)bad_hex_float(0);
            return check_case_insensitive_string
                    (width$1,ib,bad_hex_float,cst_an)}}
        else
         if(26 === switcher)switch$0 = 1}
      else
       {if(48 === c)
         {var
           width$3=store_char(width$0,ib,c),
           _hY_=0 === width$3?1:0,
           _hZ_=_hY_ || end_of_input(ib);
          if(_hZ_)bad_hex_float(0);
          var
           width$4=
            check_case_insensitive_string(width$3,ib,bad_hex_float,cst_x$2);
          if(0 !== width$4 && ! end_of_input(ib))
           {var match=peek_char(ib),_h0_=match - 46 | 0,switch$1=0;
            if(34 < _h0_ >>> 0)
             {if(66 === _h0_)switch$1 = 1}
            else
             if(32 < (_h0_ - 1 | 0) >>> 0)switch$1 = 1;
            var width$5=switch$1?width$4:scan_hexadecimal_int(width$4,ib);
            if(0 !== width$5 && ! end_of_input(ib))
             {var c$0=peek_char(ib);
              if(46 === c$0)
               {var width$6=store_char(width$5,ib,c$0),switch$2=0;
                if(0 !== width$6 && ! end_of_input(ib))
                 {var match$0=peek_char(ib),switch$3=0;
                  if(80 !== match$0 && 112 !== match$0)
                   {var
                     precision$0=min(width$6,precision),
                     width$10=
                      width$6
                      -
                      (precision$0 - scan_hexadecimal_int(precision$0,ib) | 0)
                      |
                      0;
                    switch$3 = 1}
                  if(! switch$3)var width$10=width$6;
                  var width$7=width$10;
                  switch$2 = 1}
                if(! switch$2)var width$7=width$6;
                var width$8=width$7}
              else
               var width$8=width$5;
              if(0 !== width$8 && ! end_of_input(ib))
               {var c$1=peek_char(ib);
                if(80 !== c$1 && 112 !== c$1)return width$8;
                var
                 width$9=store_char(width$8,ib,c$1),
                 _h1_=0 === width$9?1:0,
                 _h2_=_h1_ || end_of_input(ib);
                if(_h2_)bad_hex_float(0);
                return scan_optionally_signed_decimal(width$9,ib)}
              return width$8}
            return width$5}
          return width$4}
        if(73 === c)switch$0 = 1}
      if(switch$0)
       {var
         width$2=store_char(width$0,ib,c),
         _hW_=0 === width$2?1:0,
         _hX_=_hW_ || end_of_input(ib);
        if(_hX_)bad_hex_float(0);
        return check_case_insensitive_string
                (width$2,ib,bad_hex_float,cst_nfinity)}
      return bad_hex_float(0)}
    function scan_caml_float_rest(width,precision,ib)
     {var _hM_=0 === width?1:0,_hN_=_hM_ || end_of_input(ib);
      if(_hN_)bad_float(0);
      var
       width$0=scan_decimal_digit_star(width,ib),
       _hO_=0 === width$0?1:0,
       _hP_=_hO_ || end_of_input(ib);
      if(_hP_)bad_float(0);
      var c=peek_char(ib),switcher=c - 69 | 0;
      if(32 < switcher >>> 0)
       {if(-23 === switcher)
         {var
           width$1=store_char(width$0,ib,c),
           precision$0=min(width$1,precision),
           width_precision=scan_fractional_part(precision$0,ib),
           frac_width=precision$0 - width_precision | 0,
           width$2=width$1 - frac_width | 0;
          return scan_exponent_part(width$2,ib)}}
      else
       {var switcher$0=switcher - 1 | 0;
        if(30 < switcher$0 >>> 0)return scan_exponent_part(width$0,ib)}
      return bad_float(0)}
    function scan_caml_float(width,precision,ib)
     {var _hy_=0 === width?1:0,_hz_=_hy_ || end_of_input(ib);
      if(_hz_)bad_float(0);
      var
       width$0=scan_sign(width,ib),
       _hA_=0 === width$0?1:0,
       _hB_=_hA_ || end_of_input(ib);
      if(_hB_)bad_float(0);
      var c=peek_char(ib);
      if(49 <= c)
       {if(! (58 <= c))
         {var
           width$1=store_char(width$0,ib,c),
           _hC_=0 === width$1?1:0,
           _hD_=_hC_ || end_of_input(ib);
          if(_hD_)bad_float(0);
          return scan_caml_float_rest(width$1,precision,ib)}}
      else
       if(48 <= c)
        {var
          width$2=store_char(width$0,ib,c),
          _hE_=0 === width$2?1:0,
          _hF_=_hE_ || end_of_input(ib);
         if(_hF_)bad_float(0);
         var c$0=peek_char(ib);
         if(88 !== c$0 && 120 !== c$0)
          return scan_caml_float_rest(width$2,precision,ib);
         var
          width$3=store_char(width$2,ib,c$0),
          _hG_=0 === width$3?1:0,
          _hH_=_hG_ || end_of_input(ib);
         if(_hH_)bad_float(0);
         var
          width$4=scan_hexadecimal_int(width$3,ib),
          _hI_=0 === width$4?1:0,
          _hJ_=_hI_ || end_of_input(ib);
         if(_hJ_)bad_float(0);
         var c$1=peek_char(ib),switcher=c$1 - 80 | 0,switch$0=0;
         if(32 < switcher >>> 0)
          if(-34 === switcher)
           {var width$5=store_char(width$4,ib,c$1),switch$1=0;
            if(0 !== width$5 && ! end_of_input(ib))
             {var match=peek_char(ib),switch$2=0;
              if(80 !== match && 112 !== match)
               {var
                 precision$0=min(width$5,precision),
                 width$10=
                  width$5
                  -
                  (precision$0 - scan_hexadecimal_int(precision$0,ib) | 0)
                  |
                  0;
                switch$2 = 1}
              if(! switch$2)var width$10=width$5;
              var width$6=width$10;
              switch$1 = 1}
            if(! switch$1)var width$6=width$5;
            var width$7=width$6}
          else
           switch$0 = 1;
         else
          {var switcher$0=switcher - 1 | 0;
           if(30 < switcher$0 >>> 0)var width$7=width$4;else switch$0 = 1}
         var width$8=switch$0?bad_float(0):width$7;
         if(0 !== width$8 && ! end_of_input(ib))
          {var c$2=peek_char(ib);
           if(80 !== c$2 && 112 !== c$2)return width$8;
           var
            width$9=store_char(width$8,ib,c$2),
            _hK_=0 === width$9?1:0,
            _hL_=_hK_ || end_of_input(ib);
           if(_hL_)bad_hex_float(0);
           return scan_optionally_signed_decimal(width$9,ib)}
         return width$8}
      return bad_float(0)}
    function scan_string(stp,width,ib)
     {var width$0=width;
      for(;;)
       {if(0 === width$0)return width$0;
        var c=peek_char(ib);
        if(ib[1])return width$0;
        if(stp)
         {var c$0=stp[1];
          if(c === c$0)return skip_char(width$0,ib);
          var width$1=store_char(width$0,ib,c),width$0=width$1;
          continue}
        var _hx_=c - 9 | 0,switch$0=0;
        if(4 < _hx_ >>> 0)
         {if(23 === _hx_)switch$0 = 1}
        else
         if(1 < (_hx_ - 2 | 0) >>> 0)switch$0 = 1;
        if(switch$0)return width$0;
        var width$2=store_char(width$0,ib,c),width$0=width$2;
        continue}}
    function scan_char(width,ib)
     {return store_char(width,ib,checked_peek_char(ib))}
    function hexadecimal_value_of_char(d)
     {return 97 <= d?d - 87 | 0:65 <= d?d - 55 | 0:d - 48 | 0}
    function check_next_char(message,width,ib)
     {if(0 === width)return bad_token_length(message);
      var c=peek_char(ib);
      return ib[1]?bad_input(caml_call1(sprintf(_ca_),message)):c}
    function check_next_char_for_char(_hv_,_hw_)
     {return check_next_char(cst_a_Char,_hv_,_hw_)}
    function check_next_char_for_string(_ht_,_hu_)
     {return check_next_char(cst_a_String,_ht_,_hu_)}
    function scan_backslash_char(width,ib)
     {var c0=check_next_char_for_char(width,ib),switch$0=0;
      if(40 <= c0)
       {if(58 <= c0)
         {var switcher$0=c0 - 92 | 0;
          if(! (28 < switcher$0 >>> 0))
           switch(switcher$0)
            {case 28:
              var
               get_digit=
                function(param)
                 {var c=next_char(ib),_hs_=c - 48 | 0,switch$0=0;
                  if(22 < _hs_ >>> 0)
                   {if(! (5 < (_hs_ - 49 | 0) >>> 0))switch$0 = 1}
                  else
                   if(6 < (_hs_ - 10 | 0) >>> 0)switch$0 = 1;
                  return switch$0?c:bad_input_escape(c)},
               c1=get_digit(0),
               c2=get_digit(0),
               _ho_=hexadecimal_value_of_char(c2),
               c$0=(16 * hexadecimal_value_of_char(c1) | 0) + _ho_ | 0,
               switch$1=0;
              if(0 <= c$0 && ! (255 < c$0))
               {var _hq_=char_of_int(c$0);switch$1 = 1}
              if(! switch$1)
               var _hq_=bad_input(caml_call2(sprintf(_ch_),c1,c2));
              return store_char(width - 2 | 0,ib,_hq_);
             case 0:
             case 6:
             case 18:
             case 22:
             case 24:switch$0 = 1;break
             }}
        else
         if(48 <= c0)
          {var
            get_digit$0=
             function(param)
              {var c=next_char(ib),switcher=c - 48 | 0;
               return 9 < switcher >>> 0?bad_input_escape(c):c},
            c1$0=get_digit$0(0),
            c2$0=get_digit$0(0),
            c=
             ((100 * (c0 - 48 | 0) | 0) + (10 * (c1$0 - 48 | 0) | 0) | 0)
             +
             (c2$0 - 48 | 0)
             |
             0,
            switch$2=0;
           if(0 <= c && ! (255 < c)){var _hr_=char_of_int(c);switch$2 = 1}
           if(! switch$2)
            var _hr_=bad_input(caml_call3(sprintf(_cg_),c0,c1$0,c2$0));
           return store_char(width - 2 | 0,ib,_hr_)}}
      else
       if(34 === c0 || 39 <= c0)switch$0 = 1;
      if(switch$0)
       {var switch$3=0;
        if(110 <= c0)
         if(117 <= c0)
          switch$3 = 1;
         else
          {var switcher=c0 - 110 | 0;
           switch(switcher)
            {case 0:var _hp_=10;break;
             case 4:var _hp_=13;break;
             case 6:var _hp_=9;break;
             default:switch$3 = 1}}
        else
         if(98 === c0)var _hp_=8;else switch$3 = 1;
        if(switch$3)var _hp_=c0;
        return store_char(width,ib,_hp_)}
      return bad_input_escape(c0)}
    function scan_caml_char(width,ib)
     {function find_stop(width)
       {var c=check_next_char_for_char(width,ib);
        return 39 === c?ignore_char(width,ib):character_mismatch(39,c)}
      var c=checked_peek_char(ib);
      if(39 === c)
       {var
         width$0=ignore_char(width,ib),
         c$0=check_next_char_for_char(width$0,ib);
        return 92 === c$0
                ?find_stop(scan_backslash_char(ignore_char(width$0,ib),ib))
                :find_stop(store_char(width$0,ib,c$0))}
      return character_mismatch(39,c)}
    function scan_caml_string(width,ib)
     {function find_stop$0(counter,width)
       {var width$0=width;
        for(;;)
         {var c=check_next_char_for_string(width$0,ib);
          if(34 === c)return ignore_char(width$0,ib);
          if(92 === c)
           {var
             width$1=ignore_char(width$0,ib),
             match=check_next_char_for_string(width$1,ib);
            if(10 === match)
             {var _hm_=ignore_char(width$1,ib);
              if(counter < 50)
               {var counter$0=counter + 1 | 0;
                return skip_spaces(counter$0,_hm_)}
              return caml_trampoline_return(skip_spaces,[0,_hm_])}
            if(13 === match)
             {var
               width$3=ignore_char(width$1,ib),
               match$0=check_next_char_for_string(width$3,ib);
              if(10 === match$0)
               {var _hn_=ignore_char(width$3,ib);
                if(counter < 50)
                 {var counter$1=counter + 1 | 0;
                  return skip_spaces(counter$1,_hn_)}
                return caml_trampoline_return(skip_spaces,[0,_hn_])}
              var width$5=store_char(width$3,ib,13),width$0=width$5;
              continue}
            var width$4=scan_backslash_char(width$1,ib),width$0=width$4;
            continue}
          var width$2=store_char(width$0,ib,c),width$0=width$2;
          continue}}
      function skip_spaces(counter,width)
       {var width$0=width;
        for(;;)
         {var match=check_next_char_for_string(width$0,ib);
          if(32 === match)
           {var width$1=ignore_char(width$0,ib),width$0=width$1;continue}
          if(counter < 50)
           {var counter$0=counter + 1 | 0;
            return find_stop$0(counter$0,width$0)}
          return caml_trampoline_return(find_stop$0,[0,width$0])}}
      function find_stop(width){return caml_trampoline(find_stop$0(0,width))}
      var c=checked_peek_char(ib);
      return 34 === c
              ?find_stop(ignore_char(width,ib))
              :character_mismatch(34,c)}
    function scan_chars_in_char_set(char_set,scan_indic,width,ib)
     {function scan_chars(i,stp)
       {var i$0=i;
        for(;;)
         {var c=peek_char(ib),_hi_=0 < i$0?1:0;
          if(_hi_)
           {var _hj_=1 - ib[1];
            if(_hj_)
             var _hk_=is_in_char_set(char_set,c),_hl_=_hk_?c !== stp?1:0:_hk_;
            else
             var _hl_=_hj_}
          else
           var _hl_=_hi_;
          if(_hl_)
           {store_char(max_int,ib,c);var i$1=i$0 - 1 | 0,i$0=i$1;continue}
          return _hl_}}
      if(scan_indic)
       {var c=scan_indic[1];
        scan_chars(width,c);
        var _hh_=1 - ib[1];
        if(_hh_)
         {var ci=peek_char(ib);
          return c === ci?invalidate_current_char(ib):character_mismatch(c,ci)}
        return _hh_}
      return scan_chars(width,-1)}
    function scanf_bad_input(ib,x)
     {if(x[1] === Scan_failure)
       var s=x[2];
      else
       {if(x[1] !== Failure)throw x;var s=x[2]}
      var i=char_count(ib);
      return bad_input(caml_call2(sprintf(_cj_),i,s))}
    function get_counter(ib,counter)
     {switch(counter)
       {case 0:return ib[5];case 1:return char_count(ib);default:return ib[6]}}
    function width_of_pad_opt(pad_opt)
     {if(pad_opt){var width=pad_opt[1];return width}return max_int}
    function stopper_of_formatting_lit(fmting)
     {if(6 === fmting)return _ck_;
      var
       str=string_of_formatting_lit(fmting),
       stp=caml_string_get(str,1),
       sub_str=sub$0(str,2,caml_ml_string_length(str) - 2 | 0);
      return [0,stp,sub_str]}
    function take_format_readers$0(counter,k,fmt)
     {var fmt$0=fmt;
      for(;;)
       if(typeof fmt$0 === "number")
        return caml_call1(k,0);
       else
        switch(fmt$0[0])
         {case 0:var fmt$1=fmt$0[1],fmt$0=fmt$1;continue;
          case 1:var fmt$2=fmt$0[1],fmt$0=fmt$2;continue;
          case 2:var fmt$3=fmt$0[2],fmt$0=fmt$3;continue;
          case 3:var fmt$4=fmt$0[2],fmt$0=fmt$4;continue;
          case 4:var fmt$5=fmt$0[4],fmt$0=fmt$5;continue;
          case 5:var fmt$6=fmt$0[4],fmt$0=fmt$6;continue;
          case 6:var fmt$7=fmt$0[4],fmt$0=fmt$7;continue;
          case 7:var fmt$8=fmt$0[4],fmt$0=fmt$8;continue;
          case 8:var fmt$9=fmt$0[4],fmt$0=fmt$9;continue;
          case 9:var fmt$10=fmt$0[2],fmt$0=fmt$10;continue;
          case 10:var fmt$11=fmt$0[1],fmt$0=fmt$11;continue;
          case 11:var fmt$12=fmt$0[2],fmt$0=fmt$12;continue;
          case 12:var fmt$13=fmt$0[2],fmt$0=fmt$13;continue;
          case 13:var fmt$14=fmt$0[3],fmt$0=fmt$14;continue;
          case 14:
           var rest=fmt$0[3],fmtty=fmt$0[2],_hf_=erase_rel(symm(fmtty));
           if(counter < 50)
            {var counter$0=counter + 1 | 0;
             return take_fmtty_format_readers$0(counter$0,k,_hf_,rest)}
           return caml_trampoline_return
                   (take_fmtty_format_readers$0,[0,k,_hf_,rest]);
          case 15:var fmt$15=fmt$0[1],fmt$0=fmt$15;continue;
          case 16:var fmt$16=fmt$0[1],fmt$0=fmt$16;continue;
          case 17:var fmt$17=fmt$0[2],fmt$0=fmt$17;continue;
          case 18:
           var _hg_=fmt$0[1];
           if(0 === _hg_[0])
            {var
              rest$0=fmt$0[2],
              match=_hg_[1],
              fmt$18=match[1],
              fmt$19=concat_fmt(fmt$18,rest$0),
              fmt$0=fmt$19;
             continue}
           var
            rest$1=fmt$0[2],
            match$0=_hg_[1],
            fmt$20=match$0[1],
            fmt$21=concat_fmt(fmt$20,rest$1),
            fmt$0=fmt$21;
           continue;
          case 19:
           var fmt_rest=fmt$0[1];
           return function(reader)
            {function new_k(readers_rest)
              {return caml_call1(k,[0,reader,readers_rest])}
             return take_format_readers(new_k,fmt_rest)};
          case 20:var fmt$22=fmt$0[3],fmt$0=fmt$22;continue;
          case 21:var fmt$23=fmt$0[2],fmt$0=fmt$23;continue;
          case 22:var fmt$24=fmt$0[1],fmt$0=fmt$24;continue;
          case 23:
           var rest$2=fmt$0[2],ign=fmt$0[1];
           if(typeof ign === "number")
            switch(ign)
             {case 0:var fmt$0=rest$2;continue;
              case 1:var fmt$0=rest$2;continue;
              case 2:
               return function(reader)
                {function new_k(readers_rest)
                  {return caml_call1(k,[0,reader,readers_rest])}
                 return take_format_readers(new_k,rest$2)};
              default:var fmt$0=rest$2;continue}
           else
            switch(ign[0])
             {case 0:var fmt$0=rest$2;continue;
              case 1:var fmt$0=rest$2;continue;
              case 2:var fmt$0=rest$2;continue;
              case 3:var fmt$0=rest$2;continue;
              case 4:var fmt$0=rest$2;continue;
              case 5:var fmt$0=rest$2;continue;
              case 6:var fmt$0=rest$2;continue;
              case 7:var fmt$0=rest$2;continue;
              case 8:var fmt$0=rest$2;continue;
              case 9:
               var fmtty$0=ign[2];
               if(counter < 50)
                {var counter$1=counter + 1 | 0;
                 return take_fmtty_format_readers$0
                         (counter$1,k,fmtty$0,rest$2)}
               return caml_trampoline_return
                       (take_fmtty_format_readers$0,[0,k,fmtty$0,rest$2]);
              case 10:var fmt$0=rest$2;continue;
              default:var fmt$0=rest$2;continue}
          default:var fmt$25=fmt$0[3],fmt$0=fmt$25;continue}}
    function take_fmtty_format_readers$0(counter,k,fmtty,fmt)
     {var fmtty$0=fmtty;
      for(;;)
       if(typeof fmtty$0 === "number")
        {if(counter < 50)
          {var counter$0=counter + 1 | 0;
           return take_format_readers$0(counter$0,k,fmt)}
         return caml_trampoline_return(take_format_readers$0,[0,k,fmt])}
       else
        switch(fmtty$0[0])
         {case 0:var fmtty$1=fmtty$0[1],fmtty$0=fmtty$1;continue;
          case 1:var fmtty$2=fmtty$0[1],fmtty$0=fmtty$2;continue;
          case 2:var fmtty$3=fmtty$0[1],fmtty$0=fmtty$3;continue;
          case 3:var fmtty$4=fmtty$0[1],fmtty$0=fmtty$4;continue;
          case 4:var fmtty$5=fmtty$0[1],fmtty$0=fmtty$5;continue;
          case 5:var fmtty$6=fmtty$0[1],fmtty$0=fmtty$6;continue;
          case 6:var fmtty$7=fmtty$0[1],fmtty$0=fmtty$7;continue;
          case 7:var fmtty$8=fmtty$0[1],fmtty$0=fmtty$8;continue;
          case 8:var fmtty$9=fmtty$0[2],fmtty$0=fmtty$9;continue;
          case 9:
           var
            rest=fmtty$0[3],
            ty2=fmtty$0[2],
            ty1=fmtty$0[1],
            ty=trans(symm(ty1),ty2),
            fmtty$10=concat_fmtty(ty,rest),
            fmtty$0=fmtty$10;
           continue;
          case 10:var fmtty$11=fmtty$0[1],fmtty$0=fmtty$11;continue;
          case 11:var fmtty$12=fmtty$0[1],fmtty$0=fmtty$12;continue;
          case 12:var fmtty$13=fmtty$0[1],fmtty$0=fmtty$13;continue;
          case 13:
           var fmt_rest=fmtty$0[1];
           return function(reader)
            {function new_k(readers_rest)
              {return caml_call1(k,[0,reader,readers_rest])}
             return take_fmtty_format_readers(new_k,fmt_rest,fmt)};
          default:
           var fmt_rest$0=fmtty$0[1];
           return function(reader)
            {function new_k(readers_rest)
              {return caml_call1(k,[0,reader,readers_rest])}
             return take_fmtty_format_readers(new_k,fmt_rest$0,fmt)}}}
    function take_format_readers(k,fmt)
     {return caml_trampoline(take_format_readers$0(0,k,fmt))}
    function take_fmtty_format_readers(k,fmtty,fmt)
     {return caml_trampoline(take_fmtty_format_readers$0(0,k,fmtty,fmt))}
    function pad_prec_scanf(ib,fmt,readers,pad,prec,scan,token)
     {if(typeof pad === "number")
       {if(typeof prec === "number")
         {if(prec)return invalid_arg(cst_scanf_bad_conversion);
          caml_call3(scan,max_int,max_int,ib);
          var x=caml_call1(token,ib);
          return [0,x,make_scanf(ib,fmt,readers)]}
        var p=prec[1];
        caml_call3(scan,max_int,p,ib);
        var x$0=caml_call1(token,ib);
        return [0,x$0,make_scanf(ib,fmt,readers)]}
      else
       {if(0 === pad[0])
         {if(pad[1])
           {var _he_=pad[2];
            if(typeof prec === "number")
             {if(prec)return invalid_arg(cst_scanf_bad_conversion$0);
              caml_call3(scan,_he_,max_int,ib);
              var x$1=caml_call1(token,ib);
              return [0,x$1,make_scanf(ib,fmt,readers)]}
            var p$0=prec[1];
            caml_call3(scan,_he_,p$0,ib);
            var x$2=caml_call1(token,ib);
            return [0,x$2,make_scanf(ib,fmt,readers)]}
          return invalid_arg(cst_scanf_bad_conversion$1)}
        return invalid_arg(cst_scanf_bad_conversion$2)}}
    function make_scanf(ib,fmt,readers)
     {var fmt$0=fmt;
      for(;;)
       if(typeof fmt$0 === "number")
        return 0;
       else
        switch(fmt$0[0])
         {case 0:
           var rest=fmt$0[1];
           scan_char(0,ib);
           var c=token_char(ib);
           return [0,c,make_scanf(ib,rest,readers)];
          case 1:
           var rest$0=fmt$0[1];
           scan_caml_char(0,ib);
           var c$0=token_char(ib);
           return [0,c$0,make_scanf(ib,rest$0,readers)];
          case 2:
           var _g3_=fmt$0[1],_g4_=fmt$0[2];
           if(typeof _g4_ !== "number")
            switch(_g4_[0])
             {case 17:
               var
                rest$2=_g4_[2],
                fmting_lit=_g4_[1],
                match=stopper_of_formatting_lit(fmting_lit),
                str=match[2],
                stp=match[1],
                scan$0=
                 function(width,param,ib)
                  {return scan_string([0,stp],width,ib)},
                str_rest=[11,str,rest$2];
               return pad_prec_scanf
                       (ib,str_rest,readers,_g3_,0,scan$0,token_string);
              case 18:
               var _g5_=_g4_[1];
               if(0 === _g5_[0])
                {var
                  rest$3=_g4_[2],
                  match$0=_g5_[1],
                  fmt$1=match$0[1],
                  scan$1=
                   function(width,param,ib){return scan_string(_cl_,width,ib)};
                 return pad_prec_scanf
                         (ib,
                          concat_fmt(fmt$1,rest$3),
                          readers,
                          _g3_,
                          0,
                          scan$1,
                          token_string)}
               var
                rest$4=_g4_[2],
                match$1=_g5_[1],
                fmt$2=match$1[1],
                scan$2=
                 function(width,param,ib){return scan_string(_cm_,width,ib)};
               return pad_prec_scanf
                       (ib,
                        concat_fmt(fmt$2,rest$4),
                        readers,
                        _g3_,
                        0,
                        scan$2,
                        token_string)
              }
           var
            rest$1=fmt$0[2],
            scan=function(width,param,ib){return scan_string(0,width,ib)};
           return pad_prec_scanf(ib,rest$1,readers,_g3_,0,scan,token_string);
          case 3:
           var
            rest$5=fmt$0[2],
            pad=fmt$0[1],
            scan$3=function(width,param,ib){return scan_caml_string(width,ib)};
           return pad_prec_scanf(ib,rest$5,readers,pad,0,scan$3,token_string);
          case 4:
           var
            rest$6=fmt$0[4],
            prec=fmt$0[3],
            pad$0=fmt$0[2],
            iconv=fmt$0[1],
            conv=integer_conversion_of_char(char_of_iconv(iconv)),
            scan$4=
             function(width,param,ib)
              {return scan_int_conversion(conv,width,ib)};
           return pad_prec_scanf
                   (ib,
                    rest$6,
                    readers,
                    pad$0,
                    prec,
                    scan$4,
                    function(ib)
                     {return caml_int_of_string(token_int_literal(conv,ib))});
          case 5:
           var
            rest$7=fmt$0[4],
            prec$0=fmt$0[3],
            pad$1=fmt$0[2],
            iconv$0=fmt$0[1],
            conv$0=integer_conversion_of_char(char_of_iconv(iconv$0)),
            scan$5=
             function(width,param,ib)
              {return scan_int_conversion(conv$0,width,ib)};
           return pad_prec_scanf
                   (ib,
                    rest$7,
                    readers,
                    pad$1,
                    prec$0,
                    scan$5,
                    function(ib)
                     {return caml_int_of_string(token_int_literal(conv$0,ib))});
          case 6:
           var
            rest$8=fmt$0[4],
            prec$1=fmt$0[3],
            pad$2=fmt$0[2],
            iconv$1=fmt$0[1],
            conv$1=integer_conversion_of_char(char_of_iconv(iconv$1)),
            scan$6=
             function(width,param,ib)
              {return scan_int_conversion(conv$1,width,ib)};
           return pad_prec_scanf
                   (ib,
                    rest$8,
                    readers,
                    pad$2,
                    prec$1,
                    scan$6,
                    function(ib)
                     {return caml_int_of_string(token_int_literal(conv$1,ib))});
          case 7:
           var
            rest$9=fmt$0[4],
            prec$2=fmt$0[3],
            pad$3=fmt$0[2],
            iconv$2=fmt$0[1],
            conv$2=integer_conversion_of_char(char_of_iconv(iconv$2)),
            scan$7=
             function(width,param,ib)
              {return scan_int_conversion(conv$2,width,ib)};
           return pad_prec_scanf
                   (ib,
                    rest$9,
                    readers,
                    pad$3,
                    prec$2,
                    scan$7,
                    function(ib)
                     {return caml_int64_of_string(token_int_literal(conv$2,ib))});
          case 8:
           switch(fmt$0[1][2])
            {case 5:
             case 8:
              var rest$11=fmt$0[4],prec$4=fmt$0[3],pad$5=fmt$0[2];
              return pad_prec_scanf
                      (ib,
                       rest$11,
                       readers,
                       pad$5,
                       prec$4,
                       scan_caml_float,
                       token_float);
             case 6:
             case 7:
              var rest$12=fmt$0[4],prec$5=fmt$0[3],pad$6=fmt$0[2];
              return pad_prec_scanf
                      (ib,rest$12,readers,pad$6,prec$5,scan_hex_float,token_float);
             default:
              var rest$10=fmt$0[4],prec$3=fmt$0[3],pad$4=fmt$0[2];
              return pad_prec_scanf
                      (ib,rest$10,readers,pad$4,prec$3,scan_float,token_float)}
          case 9:
           var
            rest$13=fmt$0[2],
            pad$7=fmt$0[1],
            scan$8=
             function(param,_hd_,ib)
              {var
                c=checked_peek_char(ib),
                m=
                 102 === c
                  ?5
                  :116 === c?4:bad_input(caml_call1(sprintf(_ci_),c));
               return scan_string(0,m,ib)};
           return pad_prec_scanf(ib,rest$13,readers,pad$7,0,scan$8,token_bool);
          case 10:
           var rest$14=fmt$0[1];
           if(end_of_input(ib)){var fmt$0=rest$14;continue}
           return bad_input(cst_end_of_input_not_found);
          case 11:
           var rest$15=fmt$0[2],str$0=fmt$0[1];
           iter$4(function(_hc_){return check_char(ib,_hc_)},str$0);
           var fmt$0=rest$15;
           continue;
          case 12:
           var rest$16=fmt$0[2],chr=fmt$0[1];
           check_char(ib,chr);
           var fmt$0=rest$16;
           continue;
          case 13:
           var rest$17=fmt$0[3],fmtty=fmt$0[2],pad_opt=fmt$0[1];
           scan_caml_string(width_of_pad_opt(pad_opt),ib);
           var s=token_string(ib);
           try
            {var _g6_=format_of_string_fmtty(s,fmtty),fmt$3=_g6_}
           catch(exn)
            {exn = caml_wrap_exception(exn);
             if(exn[1] !== Failure)throw exn;
             var msg=exn[2],fmt$3=bad_input(msg)}
           return [0,fmt$3,make_scanf(ib,rest$17,readers)];
          case 14:
           var rest$18=fmt$0[3],fmtty$0=fmt$0[2],pad_opt$0=fmt$0[1];
           scan_caml_string(width_of_pad_opt(pad_opt$0),ib);
           var s$0=token_string(ib);
           try
            {var
              match$2=fmt_ebb_of_string(0,s$0),
              fmt$6=match$2[1],
              match$3=fmt_ebb_of_string(0,s$0),
              fmt$7=match$3[1],
              fmt$8=type_format(fmt$7,erase_rel(symm(fmtty$0))),
              _g8_=type_format(fmt$6,erase_rel(fmtty$0)),
              fmt$5=fmt$8,
              fmt$4=_g8_}
           catch(exn)
            {exn = caml_wrap_exception(exn);
             if(exn[1] !== Failure)throw exn;
             var
              msg$0=exn[2],
              _g7_=bad_input(msg$0),
              fmt$5=_g7_[2],
              fmt$4=_g7_[1]}
           return [0,
                   [0,fmt$4,s$0],
                   make_scanf(ib,concat_fmt(fmt$5,rest$18),readers)];
          case 15:return invalid_arg(cst_scanf_bad_conversion_a);
          case 16:return invalid_arg(cst_scanf_bad_conversion_t);
          case 17:
           var
            rest$19=fmt$0[2],
            formatting_lit=fmt$0[1],
            _g9_=string_of_formatting_lit(formatting_lit);
           iter$4(function(_hb_){return check_char(ib,_hb_)},_g9_);
           var fmt$0=rest$19;
           continue;
          case 18:
           var _g__=fmt$0[1];
           if(0 === _g__[0])
            {var rest$20=fmt$0[2],match$4=_g__[1],fmt$9=match$4[1];
             check_char(ib,64);
             check_char(ib,123);
             var fmt$10=concat_fmt(fmt$9,rest$20),fmt$0=fmt$10;
             continue}
           var rest$21=fmt$0[2],match$5=_g__[1],fmt$11=match$5[1];
           check_char(ib,64);
           check_char(ib,91);
           var fmt$12=concat_fmt(fmt$11,rest$21),fmt$0=fmt$12;
           continue;
          case 19:
           var fmt_rest=fmt$0[1];
           if(readers)
            {var
              readers_rest=readers[2],
              reader=readers[1],
              x=caml_call1(reader,ib);
             return [0,x,make_scanf(ib,fmt_rest,readers_rest)]}
           return invalid_arg(cst_scanf_missing_reader);
          case 20:
           var _g$_=fmt$0[1],_ha_=fmt$0[3];
           if(typeof _ha_ !== "number" && 17 === _ha_[0])
            {var
              rest$23=_ha_[2],
              fmting_lit$0=_ha_[1],
              char_set$0=fmt$0[2],
              match$6=stopper_of_formatting_lit(fmting_lit$0),
              str$1=match$6[2],
              stp$0=match$6[1],
              width$0=width_of_pad_opt(_g$_);
             scan_chars_in_char_set(char_set$0,[0,stp$0],width$0,ib);
             var s$2=token_string(ib),str_rest$0=[11,str$1,rest$23];
             return [0,s$2,make_scanf(ib,str_rest$0,readers)]}
           var
            rest$22=fmt$0[3],
            char_set=fmt$0[2],
            width=width_of_pad_opt(_g$_);
           scan_chars_in_char_set(char_set,0,width,ib);
           var s$1=token_string(ib);
           return [0,s$1,make_scanf(ib,rest$22,readers)];
          case 21:
           var
            rest$24=fmt$0[2],
            counter=fmt$0[1],
            count=get_counter(ib,counter);
           return [0,count,make_scanf(ib,rest$24,readers)];
          case 22:
           var rest$25=fmt$0[1],c$1=checked_peek_char(ib);
           return [0,c$1,make_scanf(ib,rest$25,readers)];
          case 23:
           var
            rest$26=fmt$0[2],
            ign=fmt$0[1],
            match$7=param_format_of_ignored_format(ign,rest$26),
            fmt$13=match$7[1],
            match$8=make_scanf(ib,fmt$13,readers);
           if(match$8){var arg_rest=match$8[2];return arg_rest}
           throw [0,Assert_failure,_cn_];
          default:return invalid_arg(cst_scanf_bad_conversion_custo)}}
    function kscanf(ib,ef,param)
     {var str=param[2],fmt=param[1];
      function apply(f,args)
       {var f$0=f,args$0=args;
        for(;;)
         {if(args$0)
           {var
             r=args$0[2],
             x=args$0[1],
             f$1=caml_call1(f$0,x),
             f$0=f$1,
             args$0=r;
            continue}
          return f$0}}
      function k(readers,f)
       {reset_token(ib);
        try
         {var _g2_=[0,make_scanf(ib,fmt,readers)],_g1_=_g2_}
        catch(exc)
         {exc = caml_wrap_exception(exc);
          var switch$0=0;
          if
           (exc[1]
            !==
            Scan_failure
            &&
            exc[1]
            !==
            Failure
            &&
            exc
            !==
            End_of_file)
           {if(exc[1] !== Invalid_argument)throw exc;
            var
             msg=exc[2],
             _g0_=
              invalid_arg
               (symbol
                 (msg,symbol(cst_in_format,symbol(escaped$1(str),cst$87))));
            switch$0 = 1}
          if(! switch$0)var _g0_=[1,exc];
          var _g1_=_g0_}
        if(0 === _g1_[0]){var args=_g1_[1];return apply(f,args)}
        var exc=_g1_[1];
        return caml_call2(ef,ib,exc)}
      return take_format_readers(k,fmt)}
    function bscanf(ib,fmt){return kscanf(ib,scanf_bad_input,fmt)}
    function ksscanf(s,ef,fmt){return kscanf(from_string$1(s),ef,fmt)}
    function sscanf(s,fmt)
     {return kscanf(from_string$1(s),scanf_bad_input,fmt)}
    function scanf(fmt){return kscanf(stdib,scanf_bad_input,fmt)}
    function bscanf_format(ib,format,f)
     {scan_caml_string(max_int,ib);
      var str=token_string(ib);
      try
       {var _gZ_=format_of_string_format(str,format),fmt=_gZ_}
      catch(exn)
       {exn = caml_wrap_exception(exn);
        if(exn[1] !== Failure)throw exn;
        var msg=exn[2],fmt=bad_input(msg)}
      return caml_call1(f,fmt)}
    function sscanf_format(s,format,f)
     {return bscanf_format(from_string$1(s),format,f)}
    function format_from_string(s,fmt)
     {function _gY_(x){return x}
      return sscanf_format
              (symbol(cst$89,symbol(escaped$1(s),cst$88)),fmt,_gY_)}
    function unescaped(s)
     {function _gX_(x){return x}
      return caml_call1(sscanf(symbol(cst$91,symbol(s,cst$90)),_co_),_gX_)}
    function kfscanf(ic,ef,fmt){return kscanf(memo_from_channel(ic),ef,fmt)}
    function fscanf(ic,fmt)
     {return kscanf(memo_from_channel(ic),scanf_bad_input,fmt)}
    var
     Stdlib_scanf=
      [0,
       [0,
        stdib,
        from_file,
        from_file_bin,
        close_in$0,
        from_file,
        from_file_bin,
        from_string$1,
        from_function$0,
        from_channel$0,
        end_of_input,
        beginning_of_input,
        name_of_input,
        stdib],
       Scan_failure,
       bscanf,
       sscanf,
       scanf,
       kscanf,
       ksscanf,
       bscanf_format,
       sscanf_format,
       format_from_string,
       unescaped,
       fscanf,
       kfscanf];
    caml_register_global(789,Stdlib_scanf,"Stdlib__scanf");
    var register=caml_register_named_value;
    function register_exception(name,exn)
     {var slot=caml_obj_tag(exn) === 248?exn:exn[1];
      return caml_register_named_value(name,slot)}
    var Stdlib_callback=[0,register,register_exception];
    caml_register_global(790,Stdlib_callback,"Stdlib__callback");
    function copy$7(o){var o$0=o.slice();return caml_set_oo_id(o$0)}
    var params$0=[0,1,1,1,3,16],initial_object_size=2,dummy_item=0;
    function public_method_label(s)
     {var accu=[0,0],_gU_=caml_ml_string_length(s) - 1 | 0,_gT_=0;
      if(! (_gU_ < 0))
       {var i=_gT_;
        for(;;)
         {var _gV_=caml_string_get(s,i);
          accu[1] = (223 * accu[1] | 0) + _gV_ | 0;
          var _gW_=i + 1 | 0;
          if(_gU_ !== i){var i=_gW_;continue}
          break}}
      accu[1] = accu[1] & 2147483647;
      var tag=1073741823 < accu[1]?accu[1] + 2147483648 | 0:accu[1];
      return tag}
    var
     compare$11=caml_string_compare,
     Vars=caml_call1(Stdlib_map[1],[0,compare$11]),
     compare$12=caml_string_compare,
     Meths=caml_call1(Stdlib_map[1],[0,compare$12]),
     compare$13=caml_int_compare,
     Labs=caml_call1(Stdlib_map[1],[0,compare$13]),
     dummy_table=[0,0,[0,dummy_item],Meths[1],Labs[1],0,0,Vars[1],0],
     table_count=[0,0],
     dummy_met=caml_obj_block(0,0);
    function fit_size(n){return 2 < n?fit_size((n + 1 | 0) / 2 | 0) * 2 | 0:n}
    function new_table(pub_labels)
     {table_count[1]++;
      var
       len=pub_labels.length - 1,
       methods=caml_make_vect((len * 2 | 0) + 2 | 0,dummy_met);
      caml_check_bound(methods,0)[1] = len;
      var _gN_=((fit_size(len) * 32 | 0) / 8 | 0) - 1 | 0;
      caml_check_bound(methods,1)[2] = _gN_;
      var _gP_=len - 1 | 0,_gO_=0;
      if(! (_gP_ < 0))
       {var i=_gO_;
        for(;;)
         {var
           _gR_=(i * 2 | 0) + 3 | 0,
           _gQ_=caml_check_bound(pub_labels,i)[1 + i];
          caml_check_bound(methods,_gR_)[1 + _gR_] = _gQ_;
          var _gS_=i + 1 | 0;
          if(_gP_ !== i){var i=_gS_;continue}
          break}}
      return [0,initial_object_size,methods,Meths[1],Labs[1],0,0,Vars[1],0]}
    function resize$1(array,new_size)
     {var old_size=array[2].length - 1,_gL_=old_size < new_size?1:0;
      if(_gL_)
       {var new_buck=caml_make_vect(new_size,dummy_met);
        blit$1(array[2],0,new_buck,0,old_size);
        array[2] = new_buck;
        var _gM_=0}
      else
       var _gM_=_gL_;
      return _gM_}
    var method_count=[0,0],inst_var_count=[0,0];
    function new_method(table)
     {var index=table[2].length - 1;
      resize$1(table,index + 1 | 0);
      return index}
    function get_method_label(table,name)
     {try
       {var _gJ_=caml_call2(Meths[27],name,table[3]);return _gJ_}
      catch(_gK_)
       {_gK_ = caml_wrap_exception(_gK_);
        if(_gK_ === Not_found)
         {var label=new_method(table);
          table[3] = caml_call3(Meths[4],name,label,table[3]);
          table[4] = caml_call3(Labs[4],label,1,table[4]);
          return label}
        throw _gK_}}
    function get_method_labels(table,names)
     {return map$5(function(_gI_){return get_method_label(table,_gI_)},names)}
    function set_method(table,label,element)
     {method_count[1]++;
      return caml_call2(Labs[27],label,table[4])
              ?(resize$1(table,label + 1 | 0),
                caml_check_bound(table[2],label)[1 + label]
                =
                element,
                0)
              :(table[6] = [0,[0,label,element],table[6]],0)}
    function get_method(table,label)
     {try
       {var _gG_=assoc(label,table[6]);return _gG_}
      catch(_gH_)
       {_gH_ = caml_wrap_exception(_gH_);
        if(_gH_ === Not_found)
         return caml_check_bound(table[2],label)[1 + label];
        throw _gH_}}
    function to_list$3(arr){return 0 === arr?0:to_list$1(arr)}
    function narrow(table,vars,virt_meths,concr_meths)
     {var
       vars$0=to_list$3(vars),
       virt_meths$0=to_list$3(virt_meths),
       concr_meths$0=to_list$3(concr_meths),
       virt_meth_labs=
        map$2
         (function(_gF_){return get_method_label(table,_gF_)},virt_meths$0),
       concr_meth_labs=
        map$2
         (function(_gE_){return get_method_label(table,_gE_)},concr_meths$0);
      table[5]
      =
      [0,
       [0,table[3],table[4],table[6],table[7],virt_meth_labs,vars$0],
       table[5]];
      var _gv_=Vars[1],_gw_=table[7];
      function _gx_(lab,info,tvars)
       {return mem(lab,vars$0)?caml_call3(Vars[4],lab,info,tvars):tvars}
      table[7] = caml_call3(Vars[13],_gx_,_gw_,_gv_);
      var by_name=[0,Meths[1]],by_label=[0,Labs[1]];
      iter2
       (function(met,label)
         {by_name[1] = caml_call3(Meths[4],met,label,by_name[1]);
          var _gA_=by_label[1];
          try
           {var _gC_=caml_call2(Labs[27],label,table[4]),_gB_=_gC_}
          catch(_gD_)
           {_gD_ = caml_wrap_exception(_gD_);
            if(_gD_ !== Not_found)throw _gD_;
            var _gB_=1}
          by_label[1] = caml_call3(Labs[4],label,_gB_,_gA_);
          return 0},
        concr_meths$0,
        concr_meth_labs);
      iter2
       (function(met,label)
         {by_name[1] = caml_call3(Meths[4],met,label,by_name[1]);
          by_label[1] = caml_call3(Labs[4],label,0,by_label[1]);
          return 0},
        virt_meths$0,
        virt_meth_labs);
      table[3] = by_name[1];
      table[4] = by_label[1];
      var _gy_=0,_gz_=table[6];
      table[6]
      =
      fold_right
       (function(met,hm)
         {var lab=met[1];return mem(lab,virt_meth_labs)?hm:[0,met,hm]},
        _gz_,
        _gy_);
      return 0}
    function widen(table)
     {var
       match=hd(table[5]),
       vars=match[6],
       virt_meths=match[5],
       saved_vars=match[4],
       saved_hidden_meths=match[3],
       by_label=match[2],
       by_name=match[1];
      table[5] = tl(table[5]);
      table[7]
      =
      fold_left$0
       (function(s,v)
         {var _gu_=caml_call2(Vars[27],v,table[7]);
          return caml_call3(Vars[4],v,_gu_,s)},
        saved_vars,
        vars);
      table[3] = by_name;
      table[4] = by_label;
      var _gt_=table[6];
      table[6]
      =
      fold_right
       (function(met,hm)
         {var lab=met[1];return mem(lab,virt_meths)?hm:[0,met,hm]},
        _gt_,
        saved_hidden_meths);
      return 0}
    function new_slot(table)
     {var index=table[1];table[1] = index + 1 | 0;return index}
    function new_variable(table,name)
     {try
       {var _gr_=caml_call2(Vars[27],name,table[7]);return _gr_}
      catch(_gs_)
       {_gs_ = caml_wrap_exception(_gs_);
        if(_gs_ === Not_found)
         {var index=new_slot(table);
          if(caml_string_notequal(name,cst$92))
           table[7] = caml_call3(Vars[4],name,index,table[7]);
          return index}
        throw _gs_}}
    function to_array(arr){return caml_equal(arr,0)?[0]:arr}
    function new_methods_variables(table,meths,vals)
     {var
       meths$0=to_array(meths),
       nmeths=meths$0.length - 1,
       nvals=vals.length - 1,
       res=caml_make_vect(nmeths + nvals | 0,0),
       _gj_=nmeths - 1 | 0,
       _gi_=0;
      if(! (_gj_ < 0))
       {var i$0=_gi_;
        for(;;)
         {var
           _gp_=
            get_method_label(table,caml_check_bound(meths$0,i$0)[1 + i$0]);
          caml_check_bound(res,i$0)[1 + i$0] = _gp_;
          var _gq_=i$0 + 1 | 0;
          if(_gj_ !== i$0){var i$0=_gq_;continue}
          break}}
      var _gl_=nvals - 1 | 0,_gk_=0;
      if(! (_gl_ < 0))
       {var i=_gk_;
        for(;;)
         {var
           _gn_=i + nmeths | 0,
           _gm_=new_variable(table,caml_check_bound(vals,i)[1 + i]);
          caml_check_bound(res,_gn_)[1 + _gn_] = _gm_;
          var _go_=i + 1 | 0;
          if(_gl_ !== i){var i=_go_;continue}
          break}}
      return res}
    function get_variable(table,name)
     {try
       {var _gg_=caml_call2(Vars[27],name,table[7]);return _gg_}
      catch(_gh_)
       {_gh_ = caml_wrap_exception(_gh_);
        if(_gh_ === Not_found)throw [0,Assert_failure,_cp_];
        throw _gh_}}
    function get_variables(table,names)
     {return map$5(function(_gf_){return get_variable(table,_gf_)},names)}
    function add_initializer(table,f){table[8] = [0,f,table[8]];return 0}
    function create_table(public_methods)
     {if(0 === public_methods)return new_table([0]);
      var
       tags=map$5(public_method_label,public_methods),
       table=new_table(tags);
      iteri$2
       (function(i,met)
         {var lab=(i * 2 | 0) + 2 | 0;
          table[3] = caml_call3(Meths[4],met,lab,table[3]);
          table[4] = caml_call3(Labs[4],lab,1,table[4]);
          return 0},
        public_methods);
      return table}
    function init_class(table)
     {inst_var_count[1] = (inst_var_count[1] + table[1] | 0) - 1 | 0;
      table[8] = rev(table[8]);
      return resize$1
              (table,
               3 + ((caml_check_bound(table[2],1)[2] * 16 | 0) / 32 | 0) | 0)}
    function inherits(cla,vals,virt_meths,concr_meths,param,top)
     {var env=param[4],super$0=param[2];
      narrow(cla,vals,virt_meths,concr_meths);
      var init=top?caml_call2(super$0,cla,env):caml_call1(super$0,cla);
      widen(cla);
      var
       _ga_=0,
       _gb_=to_array(concr_meths),
       _gc_=
        [0,
         map$5
          (function(nm){return get_method(cla,get_method_label(cla,nm))},_gb_),
         _ga_],
       _gd_=to_array(vals);
      return caml_array_concat
              ([0,
                [0,init],
                [0,
                 map$5(function(_ge_){return get_variable(cla,_ge_)},_gd_),
                 _gc_]])}
    function make_class(pub_meths,class_init)
     {var table=create_table(pub_meths),env_init=caml_call1(class_init,table);
      init_class(table);
      return [0,caml_call1(env_init,0),class_init,env_init,0]}
    function make_class_store(pub_meths,class_init,init_table)
     {var table=create_table(pub_meths),env_init=caml_call1(class_init,table);
      init_class(table);
      init_table[2] = class_init;
      init_table[1] = env_init;
      return 0}
    function dummy_class(loc)
     {function undef(param){throw [0,Undefined_recursive_module,loc]}
      return [0,undef,undef,undef,0]}
    function create_object(table)
     {var obj=caml_obj_block(248,table[1]);
      obj[1] = table[2];
      return caml_set_oo_id(obj)}
    function create_object_opt(obj_0,table)
     {if(obj_0)return obj_0;
      var obj=caml_obj_block(248,table[1]);
      obj[1] = table[2];
      return caml_set_oo_id(obj)}
    function iter_f(obj,param)
     {var param$0=param;
      for(;;)
       {if(param$0)
         {var l=param$0[2],f=param$0[1];
          caml_call1(f,obj);
          var param$0=l;
          continue}
        return 0}}
    function run_initializers(obj,table)
     {var inits=table[8],_f$_=0 !== inits?1:0;
      return _f$_?iter_f(obj,inits):_f$_}
    function run_initializers_opt(obj_0,obj,table)
     {if(obj_0)return obj;
      var inits=table[8];
      if(0 !== inits)iter_f(obj,inits);
      return obj}
    function create_object_and_run_initiali(obj_0,table)
     {if(obj_0)return obj_0;
      var obj=create_object(table);
      run_initializers(obj,table);
      return obj}
    function get_data$0(param)
     {if(param)return param[2];throw [0,Assert_failure,_ct_]}
    function build_path(n,keys,tables)
     {var res=[0,0,0,0],r=[0,res],_f7_=0;
      if(! (n < 0))
       {var i=_f7_;
        for(;;)
         {var _f9_=r[1];
          r[1] = [0,caml_check_bound(keys,i)[1 + i],_f9_,0];
          var _f__=i + 1 | 0;
          if(n !== i){var i=_f__;continue}
          break}}
      var _f8_=r[1];
      if(tables){tables[2] = _f8_;return res}
      throw [0,Assert_failure,_cq_]}
    function lookup_tables(root,keys)
     {var tables$2=get_data$0(root);
      if(tables$2)
       {var i$1=keys.length - 1 - 1 | 0,i=i$1,tables=tables$2;
        a:
        for(;;)
         {if(0 <= i)
           {var key=caml_check_bound(keys,i)[1 + i],tables$0=tables;
            for(;;)
             {if(tables$0)
               {if(tables$0[1] === key)
                 {var tables$1=get_data$0(tables$0);
                  if(tables$1)
                   {var i$0=i - 1 | 0,i=i$0,tables=tables$1;continue a}
                  throw [0,Assert_failure,_cv_]}
                if(tables$0)
                 {var _f6_=tables$0[3];
                  if(_f6_){var tables$0=_f6_;continue}
                  var v=[0,key,0,0];
                  if(tables$0)
                   {tables$0[3] = v;return build_path(i - 1 | 0,keys,v)}
                  throw [0,Assert_failure,_cr_]}
                throw [0,Assert_failure,_cu_]}
              throw [0,Assert_failure,_cs_]}}
          return tables}}
      return build_path(keys.length - 1 - 1 | 0,keys,root)}
    function new_cache(table)
     {var n=new_method(table),switch$0=0;
      if
       (0
        !==
        (n % 2 | 0)
        &&
        !
        ((2 + ((caml_check_bound(table[2],1)[2] * 16 | 0) / 32 | 0) | 0) < n))
       {var n$0=new_method(table);switch$0 = 1}
      if(! switch$0)var n$0=n;
      caml_check_bound(table[2],n$0)[1 + n$0] = 0;
      return n$0}
    function set_methods(table,methods)
     {var len=methods.length - 1,i=[0,0];
      for(;;)
       {if(i[1] < len)
         {var
           _f0_=i[1],
           label=caml_check_bound(methods,_f0_)[1 + _f0_],
           next=
            function(param)
             {i[1]++;
              var _f5_=i[1];
              return caml_check_bound(methods,_f5_)[1 + _f5_]},
           clo=next(0);
          if(typeof clo === "number")
           switch(clo)
            {case 0:
              var
               x=next(0),
               clo$0=function(x){return function(obj){return x}}(x);
              break;
             case 1:
              var
               n=next(0),
               clo$0=function(n){return function(obj){return obj[1 + n]}}(n);
              break;
             case 2:
              var
               e=next(0),
               n$0=next(0),
               clo$0=
                function(e,n){return function(obj){return obj[1 + e][1 + n]}}
                 (e,n$0);
              break;
             case 3:
              var
               n$1=next(0),
               clo$0=
                function(n)
                  {return function(obj){return caml_call1(obj[1][1 + n],obj)}}
                 (n$1);
              break;
             case 4:
              var
               n$2=next(0),
               clo$0=
                function(n){return function(obj,x){obj[1 + n] = x;return 0}}
                 (n$2);
              break;
             case 5:
              var
               f=next(0),
               x$0=next(0),
               clo$0=
                function(f,x){return function(obj){return caml_call1(f,x)}}
                 (f,x$0);
              break;
             case 6:
              var
               f$0=next(0),
               n$3=next(0),
               clo$0=
                function(f,n)
                  {return function(obj){return caml_call1(f,obj[1 + n])}}
                 (f$0,n$3);
              break;
             case 7:
              var
               f$1=next(0),
               e$0=next(0),
               n$4=next(0),
               clo$0=
                function(f,e,n)
                  {return function(obj)
                    {return caml_call1(f,obj[1 + e][1 + n])}}
                 (f$1,e$0,n$4);
              break;
             case 8:
              var
               f$2=next(0),
               n$5=next(0),
               clo$0=
                function(f,n)
                  {return function(obj)
                    {return caml_call1(f,caml_call1(obj[1][1 + n],obj))}}
                 (f$2,n$5);
              break;
             case 9:
              var
               f$3=next(0),
               x$1=next(0),
               y=next(0),
               clo$0=
                function(f,x,y)
                  {return function(obj){return caml_call2(f,x,y)}}
                 (f$3,x$1,y);
              break;
             case 10:
              var
               f$4=next(0),
               x$2=next(0),
               n$6=next(0),
               clo$0=
                function(f,x,n)
                  {return function(obj){return caml_call2(f,x,obj[1 + n])}}
                 (f$4,x$2,n$6);
              break;
             case 11:
              var
               f$5=next(0),
               x$3=next(0),
               e$1=next(0),
               n$7=next(0),
               clo$0=
                function(f,x,e,n)
                  {return function(obj)
                    {return caml_call2(f,x,obj[1 + e][1 + n])}}
                 (f$5,x$3,e$1,n$7);
              break;
             case 12:
              var
               f$6=next(0),
               x$4=next(0),
               n$8=next(0),
               clo$0=
                function(f,x,n)
                  {return function(obj)
                    {return caml_call2(f,x,caml_call1(obj[1][1 + n],obj))}}
                 (f$6,x$4,n$8);
              break;
             case 13:
              var
               f$7=next(0),
               n$9=next(0),
               x$5=next(0),
               clo$0=
                function(f,n,x)
                  {return function(obj){return caml_call2(f,obj[1 + n],x)}}
                 (f$7,n$9,x$5);
              break;
             case 14:
              var
               f$8=next(0),
               e$2=next(0),
               n$10=next(0),
               x$6=next(0),
               clo$0=
                function(f,e,n,x)
                  {return function(obj)
                    {return caml_call2(f,obj[1 + e][1 + n],x)}}
                 (f$8,e$2,n$10,x$6);
              break;
             case 15:
              var
               f$9=next(0),
               n$11=next(0),
               x$7=next(0),
               clo$0=
                function(f,n,x)
                  {return function(obj)
                    {return caml_call2(f,caml_call1(obj[1][1 + n],obj),x)}}
                 (f$9,n$11,x$7);
              break;
             case 16:
              var
               n$12=next(0),
               x$8=next(0),
               clo$0=
                function(n,x)
                  {return function(obj)
                    {return caml_call2(obj[1][1 + n],obj,x)}}
                 (n$12,x$8);
              break;
             case 17:
              var
               n$13=next(0),
               m=next(0),
               clo$0=
                function(n,m)
                  {return function(obj)
                    {return caml_call2(obj[1][1 + n],obj,obj[1 + m])}}
                 (n$13,m);
              break;
             case 18:
              var
               n$14=next(0),
               e$3=next(0),
               m$0=next(0),
               clo$0=
                function(n,e,m)
                  {return function(obj)
                    {return caml_call2(obj[1][1 + n],obj,obj[1 + e][1 + m])}}
                 (n$14,e$3,m$0);
              break;
             case 19:
              var
               n$15=next(0),
               m$1=next(0),
               clo$0=
                function(n,m)
                  {return function(obj)
                    {var _f3_=caml_call1(obj[1][1 + m],obj);
                     return caml_call2(obj[1][1 + n],obj,_f3_)}}
                 (n$15,m$1);
              break;
             case 20:
              var
               m$2=next(0),
               x$9=next(0),
               c=new_cache(table),
               clo$0=
                function(m,x,c)
                  {return function(obj)
                    {return caml_call2(caml_get_public_method(x,m,0),x,c)}}
                 (m$2,x$9,c);
              break;
             case 21:
              var
               m$3=next(0),
               n$16=next(0),
               c$0=new_cache(table),
               clo$0=
                function(m,n,c)
                  {return function(obj)
                    {var _f2_=obj[1 + n];
                     return caml_call2(caml_get_public_method(_f2_,m,0),_f2_,c)}}
                 (m$3,n$16,c$0);
              break;
             case 22:
              var
               m$4=next(0),
               e$4=next(0),
               n$17=next(0),
               c$1=new_cache(table),
               clo$0=
                function(m,e,n,c)
                  {return function(obj)
                    {var _f1_=obj[1 + e][1 + n];
                     return caml_call2(caml_get_public_method(_f1_,m,0),_f1_,c)}}
                 (m$4,e$4,n$17,c$1);
              break;
             default:
              var
               m$5=next(0),
               n$18=next(0),
               c$2=new_cache(table),
               clo$0=
                function(m,n,c)
                  {return function(obj)
                    {var _f4_=caml_call1(obj[1][1 + n],obj);
                     return caml_call2(caml_get_public_method(_f4_,m,0),_f4_,c)}}
                 (m$5,n$18,c$2)}
          else
           var clo$0=clo;
          set_method(table,label,clo$0);
          i[1]++;
          continue}
        return 0}}
    function stats$0(param)
     {return [0,table_count[1],method_count[1],inst_var_count[1]]}
    var
     CamlinternalOO=
      [0,
       public_method_label,
       new_method,
       new_variable,
       new_methods_variables,
       get_variable,
       get_variables,
       get_method_label,
       get_method_labels,
       get_method,
       set_method,
       set_methods,
       narrow,
       widen,
       add_initializer,
       dummy_table,
       create_table,
       init_class,
       inherits,
       make_class,
       make_class_store,
       dummy_class,
       copy$7,
       create_object,
       create_object_opt,
       run_initializers,
       run_initializers_opt,
       create_object_and_run_initiali,
       lookup_tables,
       params$0,
       stats$0];
    caml_register_global(791,CamlinternalOO,"CamlinternalOO");
    var Stdlib_oo=[0,copy$7,public_method_label,public_method_label];
    caml_register_global(792,Stdlib_oo,"Stdlib__oo");
    var
     update_mod=runtime.caml_CamlinternalMod_update_mod,
     init_mod=runtime.caml_CamlinternalMod_init_mod,
     CamlinternalMod=[0,init_mod,update_mod];
    caml_register_global(793,CamlinternalMod,"CamlinternalMod");
    var
     initial_buffer=caml_create_bytes(32),
     buffer=[0,initial_buffer],
     bufpos=[0,0];
    function reset_buffer(param)
     {buffer[1] = initial_buffer;bufpos[1] = 0;return 0}
    function store(c)
     {if(caml_ml_bytes_length(buffer[1]) <= bufpos[1])
       {var newbuffer=caml_create_bytes(2 * bufpos[1] | 0);
        blit(buffer[1],0,newbuffer,0,bufpos[1]);
        buffer[1] = newbuffer}
      caml_bytes_set(buffer[1],bufpos[1],c);
      bufpos[1]++;
      return 0}
    function get_string(param)
     {var s=sub_string(buffer[1],0,bufpos[1]);
      buffer[1] = initial_buffer;
      return s}
    function make_lexer(keywords)
     {var kwd_table=caml_call2(Stdlib_hashtbl[1],0,17);
      iter$2
       (function(s){return caml_call3(Stdlib_hashtbl[5],kwd_table,s,[0,s])},
        keywords);
      function ident_or_keyword(id)
       {try
         {var _fY_=caml_call2(Stdlib_hashtbl[6],kwd_table,id);return _fY_}
        catch(_fZ_)
         {_fZ_ = caml_wrap_exception(_fZ_);
          if(_fZ_ === Not_found)return [1,id];
          throw _fZ_}}
      function keyword_or_error(c)
       {var s=make$0(1,c);
        try
         {var _fW_=caml_call2(Stdlib_hashtbl[6],kwd_table,s);return _fW_}
        catch(_fX_)
         {_fX_ = caml_wrap_exception(_fX_);
          if(_fX_ === Not_found)
           throw [0,Error,symbol(cst_Illegal_character,s)];
          throw _fX_}}
      function end_exponent_part(strm)
       {for(;;)
         {var match=peek$0(strm);
          if(match)
           {var _fV_=match[1],switcher=_fV_ - 48 | 0;
            if(! (9 < switcher >>> 0)){junk(strm);store(_fV_);continue}}
          return [0,[3,caml_float_of_string(get_string(0))]]}}
      function exponent_part(strm)
       {var match=peek$0(strm);
        if(match)
         {var _fU_=match[1],switch$0=0;
          if(43 !== _fU_ && 45 !== _fU_)switch$0 = 1;
          if(! switch$0)
           {junk(strm);store(_fU_);return end_exponent_part(strm)}}
        return end_exponent_part(strm)}
      function number(s)
       {for(;;)
         {var match=peek$0(s);
          if(match)
           {var _fR_=match[1];
            if(58 <= _fR_)
             {var switch$0=0;
              if(69 === _fR_ || 101 === _fR_)switch$0 = 1;
              if(switch$0){junk(s);store(69);return exponent_part(s)}}
            else
             {if(46 === _fR_)
               {junk(s);
                store(46);
                for(;;)
                 {var match$0=peek$0(s);
                  if(match$0)
                   {var _fS_=match$0[1],_fT_=_fS_ - 69 | 0;
                    if(32 < _fT_ >>> 0)
                     {var switcher=_fT_ + 21 | 0;
                      if(! (9 < switcher >>> 0)){junk(s);store(_fS_);continue}}
                    else
                     {var switcher$0=_fT_ - 1 | 0;
                      if(30 < switcher$0 >>> 0)
                       {junk(s);store(69);return exponent_part(s)}}}
                  return [0,[3,caml_float_of_string(get_string(0))]]}}
              if(48 <= _fR_){junk(s);store(_fR_);continue}}}
          return [0,[2,caml_int_of_string(get_string(0))]]}}
      function ident2(strm)
       {for(;;)
         {var match=peek$0(strm);
          if(match)
           {var _fP_=match[1],switch$0=0;
            if(94 <= _fP_)
             {var _fQ_=_fP_ - 95 | 0;
              if(30 < _fQ_ >>> 0)
               {if(! (32 <= _fQ_))switch$0 = 1}
              else
               if(29 === _fQ_)switch$0 = 1}
            else
             if(65 <= _fP_)
              {if(92 === _fP_)switch$0 = 1}
             else
              if(33 <= _fP_)
               switch(_fP_ - 33 | 0)
                {case 0:
                 case 2:
                 case 3:
                 case 4:
                 case 5:
                 case 9:
                 case 10:
                 case 12:
                 case 14:
                 case 25:
                 case 27:
                 case 28:
                 case 29:
                 case 30:
                 case 31:switch$0 = 1;break
                 }
            if(switch$0){junk(strm);store(_fP_);continue}}
          return [0,ident_or_keyword(get_string(0))]}}
      function neg_number(s)
       {var match=peek$0(s);
        if(match)
         {var _fO_=match[1],switcher=_fO_ - 48 | 0;
          if(! (9 < switcher >>> 0))
           {junk(s);reset_buffer(0);store(45);store(_fO_);return number(s)}}
        reset_buffer(0);
        store(45);
        return ident2(s)}
      function ident(strm)
       {for(;;)
         {var match=peek$0(strm);
          if(match)
           {var _fM_=match[1],switch$0=0;
            if(91 <= _fM_)
             {var _fN_=_fM_ - 95 | 0;
              if(27 < _fN_ >>> 0)
               {if(97 <= _fN_)switch$0 = 1}
              else
               if(1 !== _fN_)switch$0 = 1}
            else
             if(48 <= _fM_)
              {if(6 < (_fM_ - 58 | 0) >>> 0)switch$0 = 1}
             else
              if(39 === _fM_)switch$0 = 1;
            if(switch$0){junk(strm);store(_fM_);continue}}
          return [0,ident_or_keyword(get_string(0))]}}
      function next_token$0(counter,strm)
       {for(;;)
         {var match=peek$0(strm);
          if(match)
           {var _fC_=match[1],switch$0=0;
            if(124 <= _fC_)
             {if(127 <= _fC_)
               {if(192 <= _fC_)switch$0 = 1}
              else
               if(125 !== _fC_)switch$0 = 2}
            else
             {var _fD_=_fC_ - 65 | 0;
              if(57 < _fD_ >>> 0)
               {if(! (58 <= _fD_))
                 {var switcher=_fD_ + 65 | 0;
                  switch(switcher)
                   {case 34:
                     junk(strm);
                     reset_buffer(0);
                     for(;;)
                      {var match$1=peek$0(strm);
                       if(match$1)
                        {var _fF_=match$1[1];
                         if(34 === _fF_){junk(strm);return [0,[4,get_string(0)]]}
                         if(92 === _fF_)
                          {junk(strm);
                           try
                            {var c$0=escape(strm)}
                           catch(_fL_)
                            {_fL_ = caml_wrap_exception(_fL_);
                             if(_fL_ === Failure$0)throw [0,Error,cst$95];
                             throw _fL_;
                             var _fI_=_fL_}
                           store(c$0);
                           continue}
                         junk(strm);
                         store(_fF_);
                         continue}
                       throw Failure$0}
                    case 39:
                     junk(strm);
                     try
                      {var match$2=peek$0(strm);
                       if(! match$2)throw Failure$0;
                       var _fG_=match$2[1];
                       if(92 === _fG_)
                        {junk(strm);
                         try
                          {var _fH_=escape(strm)}
                         catch(_fK_)
                          {_fK_ = caml_wrap_exception(_fK_);
                           if(_fK_ === Failure$0)throw [0,Error,cst$96];
                           throw _fK_}
                         var c=_fH_}
                       else
                        {junk(strm);var c=_fG_}}
                     catch(_fJ_)
                      {_fJ_ = caml_wrap_exception(_fJ_);
                       if(_fJ_ === Failure$0)throw [0,Error,cst$93];
                       throw _fJ_}
                     var match$0=peek$0(strm);
                     if(match$0 && 39 === match$0[1])
                      {junk(strm);return [0,[5,c]]}
                     throw [0,Error,cst$94];
                    case 40:
                     junk(strm);
                     if(counter < 50)
                      {var counter$0=counter + 1 | 0;
                       return maybe_comment(counter$0,strm)}
                     return caml_trampoline_return(maybe_comment,[0,strm]);
                    case 45:junk(strm);return neg_number(strm);
                    case 9:
                    case 10:
                    case 12:
                    case 13:
                    case 26:
                    case 32:junk(strm);continue;
                    case 48:
                    case 49:
                    case 50:
                    case 51:
                    case 52:
                    case 53:
                    case 54:
                    case 55:
                    case 56:
                    case 57:
                     junk(strm);reset_buffer(0);store(_fC_);return number(strm);
                    case 33:
                    case 35:
                    case 36:
                    case 37:
                    case 38:
                    case 42:
                    case 43:
                    case 47:
                    case 58:
                    case 60:
                    case 61:
                    case 62:
                    case 63:
                    case 64:switch$0 = 2;break
                    }}}
              else
               {var _fE_=_fD_ - 26 | 0;
                if(5 < _fE_ >>> 0)
                 switch$0 = 1;
                else
                 switch(_fE_)
                  {case 4:switch$0 = 1;break;case 1:case 3:switch$0 = 2;break}}}
            switch(switch$0)
             {case 0:junk(strm);return [0,keyword_or_error(_fC_)];
              case 1:
               junk(strm);reset_buffer(0);store(_fC_);return ident(strm);
              default:
               junk(strm);reset_buffer(0);store(_fC_);return ident2(strm)}}
          return 0}}
      function maybe_comment(counter,strm)
       {var match=peek$0(strm);
        if(match && 42 === match[1])
         {junk(strm);
          comment(strm);
          if(counter < 50)
           {var counter$0=counter + 1 | 0;return next_token$0(counter$0,strm)}
          return caml_trampoline_return(next_token$0,[0,strm])}
        return [0,keyword_or_error(40)]}
      function next_token(strm){return caml_trampoline(next_token$0(0,strm))}
      function escape(strm)
       {var match=peek$0(strm);
        if(match)
         {var _fz_=match[1];
          if(58 <= _fz_)
           {var switcher=_fz_ - 110 | 0;
            if(! (6 < switcher >>> 0))
             switch(switcher)
              {case 0:junk(strm);return 10;
               case 4:junk(strm);return 13;
               case 6:junk(strm);return 9
               }}
          else
           if(48 <= _fz_)
            {junk(strm);
             var match$0=peek$0(strm);
             if(match$0)
              {var _fA_=match$0[1],switcher$0=_fA_ - 48 | 0;
               if(! (9 < switcher$0 >>> 0))
                {junk(strm);
                 var match$1=peek$0(strm);
                 if(match$1)
                  {var _fB_=match$1[1],switcher$1=_fB_ - 48 | 0;
                   if(! (9 < switcher$1 >>> 0))
                    {junk(strm);
                     return chr
                             ((((_fz_ - 48 | 0) * 100 | 0)
                               +
                               ((_fA_ - 48 | 0) * 10 | 0)
                               |
                               0)
                              +
                              (_fB_ - 48 | 0)
                              |
                              0)}}
                 throw [0,Error,cst$98]}}
             throw [0,Error,cst$97]}
          junk(strm);
          return _fz_}
        throw Failure$0}
      function comment(strm)
       {a:
        for(;;)
         {var match=peek$0(strm);
          if(match)
           {var switcher=match[1] - 40 | 0;
            if(! (2 < switcher >>> 0))
             switch(switcher)
              {case 0:
                junk(strm);
                var match$0=peek$0(strm);
                if(match$0)
                 {if(42 === match$0[1]){junk(strm);comment(strm);continue}
                  junk(strm);
                  continue}
                throw Failure$0;
               case 1:break;
               default:
                junk(strm);
                for(;;)
                 {var match$1=peek$0(strm);
                  if(match$1)
                   {var _fy_=match$1[1];
                    if(41 === _fy_){junk(strm);return 0}
                    if(42 === _fy_){junk(strm);continue}
                    junk(strm);
                    continue a}
                  throw Failure$0}}
            junk(strm);
            continue}
          throw Failure$0}}
      return function(input)
       {return from(function(count){return next_token(input)})}}
    var Stdlib_genlex=[0,make_lexer];
    caml_register_global(794,Stdlib_genlex,"Stdlib__genlex");
    function MakeSeeded$0(H)
     {var prng=[246,function(_fx_){return caml_call1(_b2_[2],0)}];
      function create(opt,initial_size)
       {if(opt)
         var sth=opt[1],random=sth;
        else
         var random=caml_call1(Stdlib_hashtbl[17],0);
        var x=16;
        for(;;)
         {if(! (initial_size <= x) && ! (max_array_length < (x * 2 | 0)))
           {var x$0=x * 2 | 0,x=x$0;continue}
          if(random)
           var
            _fv_=caml_obj_tag(prng),
            _fw_=250 === _fv_?prng[1]:246 === _fv_?force_lazy_block(prng):prng,
            seed=caml_call1(_b2_[4],_fw_);
          else
           var seed=0;
          return [0,0,caml_make_vect(x,0),seed,x]}}
      function clear(h)
       {h[1] = 0;
        var len=h[2].length - 1,_ft_=len - 1 | 0,_fs_=0;
        if(! (_ft_ < 0))
         {var i=_fs_;
          for(;;)
           {caml_check_bound(h[2],i)[1 + i] = 0;
            var _fu_=i + 1 | 0;
            if(_ft_ !== i){var i=_fu_;continue}
            break}}
        return 0}
      function reset(h)
       {var len=h[2].length - 1;
        return len === h[4]
                ?clear(h)
                :(h[1] = 0,h[2] = caml_make_vect(h[4],0),0)}
      function copy(init)
       {var _fp_=init[4],_fq_=init[3],_fr_=copy$1(init[2]);
        return [0,init[1],_fr_,_fq_,_fp_]}
      function key_index(h,hkey){return hkey & (h[2].length - 1 - 1 | 0)}
      function clean(h)
       {function do_bucket(param)
         {var param$0=param;
          for(;;)
           {if(param$0)
             {var hkey=param$0[1],rest=param$0[3],c=param$0[2];
              if(caml_call1(H[7],c))
               {var rest$0=param$0[3],c$0=param$0[2];
                return [0,hkey,c$0,do_bucket(rest$0)]}
              h[1] = h[1] - 1 | 0;
              var param$0=rest;
              continue}
            return 0}}
        var d=h[2],_fm_=d.length - 1 - 1 | 0,_fl_=0;
        if(! (_fm_ < 0))
         {var i=_fl_;
          for(;;)
           {var _fn_=do_bucket(caml_check_bound(d,i)[1 + i]);
            caml_check_bound(d,i)[1 + i] = _fn_;
            var _fo_=i + 1 | 0;
            if(_fm_ !== i){var i=_fo_;continue}
            break}}
        return 0}
      function resize(h)
       {var odata=h[2],osize=odata.length - 1,nsize=osize * 2 | 0;
        clean(h);
        var
         _ff_=nsize < max_array_length?1:0,
         _fg_=_ff_?(osize >>> 1 | 0) <= h[1]?1:0:_ff_;
        if(_fg_)
         {var ndata=caml_make_vect(nsize,0);
          h[2] = ndata;
          var
           insert_bucket=
            function(param)
             {if(param)
               {var rest=param[3],data=param[2],hkey=param[1];
                insert_bucket(rest);
                var nidx=key_index(h,hkey);
                ndata[1 + nidx]
                =
                [0,hkey,data,caml_check_bound(ndata,nidx)[1 + nidx]];
                return 0}
              return 0},
           _fi_=osize - 1 | 0,
           _fh_=0;
          if(! (_fi_ < 0))
           {var i=_fh_;
            for(;;)
             {insert_bucket(caml_check_bound(odata,i)[1 + i]);
              var _fk_=i + 1 | 0;
              if(_fi_ !== i){var i=_fk_;continue}
              break}}
          var _fj_=0}
        else
         var _fj_=_fg_;
        return _fj_}
      function add(h,key,info)
       {var
         hkey=caml_call2(H[2],h[3],key),
         i=key_index(h,hkey),
         container=caml_call2(H[1],key,info),
         bucket=[0,hkey,container,caml_check_bound(h[2],i)[1 + i]];
        caml_check_bound(h[2],i)[1 + i] = bucket;
        h[1] = h[1] + 1 | 0;
        var _fe_=h[2].length - 1 << 1 < h[1]?1:0;
        return _fe_?resize(h):_fe_}
      function remove(h,key)
       {var hkey=caml_call2(H[2],h[3],key);
        function remove_bucket(param)
         {var param$0=param;
          for(;;)
           {if(param$0)
             {var hk=param$0[1],next=param$0[3],c=param$0[2];
              if(hkey === hk)
               {var match=caml_call2(H[3],c,key);
                switch(match)
                 {case 0:h[1] = h[1] - 1 | 0;return next;
                  case 1:return [0,hk,c,remove_bucket(next)];
                  default:h[1] = h[1] - 1 | 0;var param$0=next;continue}}
              var next$0=param$0[3],c$0=param$0[2];
              return [0,hk,c$0,remove_bucket(next$0)]}
            return 0}}
        var
         i=key_index(h,hkey),
         _fd_=remove_bucket(caml_check_bound(h[2],i)[1 + i]);
        caml_check_bound(h[2],i)[1 + i] = _fd_;
        return 0}
      function find(h,key)
       {var
         hkey=caml_call2(H[2],h[3],key),
         _fc_=key_index(h,hkey),
         param$1=caml_check_bound(h[2],_fc_)[1 + _fc_],
         param=param$1;
        for(;;)
         {if(param)
           {var hk=param[1],rest=param[3],c=param[2];
            if(hkey === hk)
             {var match=caml_call2(H[3],c,key);
              switch(match)
               {case 0:
                 var match$0=caml_call1(H[4],c);
                 if(match$0){var d=match$0[1];return d}
                 var param=rest;
                 continue;
                case 1:var param=rest;continue;
                default:var param=rest;continue}}
            var param$0=param[3],param=param$0;
            continue}
          throw Not_found}}
      function find_opt(h,key)
       {var
         hkey=caml_call2(H[2],h[3],key),
         _fb_=key_index(h,hkey),
         param$1=caml_check_bound(h[2],_fb_)[1 + _fb_],
         param=param$1;
        for(;;)
         {if(param)
           {var hk=param[1],rest=param[3],c=param[2];
            if(hkey === hk)
             {var match=caml_call2(H[3],c,key);
              switch(match)
               {case 0:
                 var d=caml_call1(H[4],c);
                 if(d)return d;
                 var param=rest;
                 continue;
                case 1:var param=rest;continue;
                default:var param=rest;continue}}
            var param$0=param[3],param=param$0;
            continue}
          return 0}}
      function find_all(h,key)
       {var hkey=caml_call2(H[2],h[3],key);
        function find_in_bucket(param)
         {var param$0=param;
          for(;;)
           {if(param$0)
             {var hk=param$0[1],rest=param$0[3],c=param$0[2];
              if(hkey === hk)
               {var match=caml_call2(H[3],c,key);
                switch(match)
                 {case 0:
                   var match$0=caml_call1(H[4],c);
                   if(match$0)
                    {var d=match$0[1];return [0,d,find_in_bucket(rest)]}
                   var param$0=rest;
                   continue;
                  case 1:var param$0=rest;continue;
                  default:var param$0=rest;continue}}
              var param$1=param$0[3],param$0=param$1;
              continue}
            return 0}}
        var _fa_=key_index(h,hkey);
        return find_in_bucket(caml_check_bound(h[2],_fa_)[1 + _fa_])}
      function replace(h,key,info)
       {var hkey=caml_call2(H[2],h[3],key);
        function replace_bucket(param)
         {var param$0=param;
          for(;;)
           {if(param$0)
             {var hk=param$0[1],next=param$0[3],c=param$0[2];
              if(hkey === hk)
               {var match=caml_call2(H[3],c,key);
                if(match){var param$0=next;continue}
                return caml_call3(H[6],c,key,info)}
              var param$1=param$0[3],param$0=param$1;
              continue}
            throw Not_found}}
        var i=key_index(h,hkey),l=caml_check_bound(h[2],i)[1 + i];
        try
         {var _e__=replace_bucket(l);return _e__}
        catch(_e$_)
         {_e$_ = caml_wrap_exception(_e$_);
          if(_e$_ === Not_found)
           {var container=caml_call2(H[1],key,info);
            caml_check_bound(h[2],i)[1 + i] = [0,hkey,container,l];
            h[1] = h[1] + 1 | 0;
            var _e9_=h[2].length - 1 << 1 < h[1]?1:0;
            return _e9_?resize(h):_e9_}
          throw _e$_}}
      function mem(h,key)
       {var
         hkey=caml_call2(H[2],h[3],key),
         _e8_=key_index(h,hkey),
         param$1=caml_check_bound(h[2],_e8_)[1 + _e8_],
         param=param$1;
        for(;;)
         {if(param)
           {var hk=param[1],rest=param[3],c=param[2];
            if(hk === hkey)
             {var match=caml_call2(H[3],c,key);
              if(match){var param=rest;continue}
              return 1}
            var param$0=param[3],param=param$0;
            continue}
          return 0}}
      function iter$0(f,h)
       {var d$0=h[2],_e6_=d$0.length - 1 - 1 | 0,_e5_=0;
        if(! (_e6_ < 0))
         {var i=_e5_;
          a:
          for(;;)
           {var param$0=caml_check_bound(d$0,i)[1 + i],param=param$0;
            for(;;)
             {if(param)
               {var
                 rest=param[3],
                 c=param[2],
                 match=caml_call1(H[5],c),
                 match$0=caml_call1(H[4],c),
                 switch$0=0;
                if(match && match$0)
                 {var d=match$0[1],k=match[1];caml_call2(f,k,d);switch$0 = 1}
                var param=rest;
                continue}
              var _e7_=i + 1 | 0;
              if(_e6_ !== i){var i=_e7_;continue a}
              break}
            break}}
        return 0}
      function fold(f,h,init)
       {var d$0=h[2],accu$1=[0,init],_e2_=d$0.length - 1 - 1 | 0,_e1_=0;
        if(! (_e2_ < 0))
         {var i=_e1_;
          a:
          for(;;)
           {var
             _e3_=accu$1[1],
             b$0=caml_check_bound(d$0,i)[1 + i],
             b=b$0,
             accu=_e3_;
            for(;;)
             {if(b)
               {var
                 rest=b[3],
                 c=b[2],
                 match=caml_call1(H[5],c),
                 match$0=caml_call1(H[4],c),
                 switch$0=0;
                if(match && match$0)
                 {var d=match$0[1],k=match[1],accu$0=caml_call3(f,k,d,accu);
                  switch$0 = 1}
                if(! switch$0)var accu$0=accu;
                var b=rest,accu=accu$0;
                continue}
              accu$1[1] = accu;
              var _e4_=i + 1 | 0;
              if(_e2_ !== i){var i=_e4_;continue a}
              break}
            break}}
        return accu$1[1]}
      function filter_map_inplace(f,h)
       {function do_bucket(param)
         {var param$0=param;
          for(;;)
           {if(param$0)
             {var
               rest=param$0[3],
               c=param$0[2],
               hk=param$0[1],
               match=caml_call1(H[5],c),
               match$0=caml_call1(H[4],c);
              if(match && match$0)
               {var d=match$0[1],k=match[1],match$1=caml_call2(f,k,d);
                if(match$1)
                 {var new_d=match$1[1];
                  caml_call3(H[6],c,k,new_d);
                  return [0,hk,c,do_bucket(rest)]}
                var param$0=rest;
                continue}
              var param$0=rest;
              continue}
            return 0}}
        var d=h[2],_eY_=d.length - 1 - 1 | 0,_eX_=0;
        if(! (_eY_ < 0))
         {var i=_eX_;
          for(;;)
           {var _eZ_=do_bucket(caml_check_bound(d,i)[1 + i]);
            caml_check_bound(d,i)[1 + i] = _eZ_;
            var _e0_=i + 1 | 0;
            if(_eY_ !== i){var i=_e0_;continue}
            break}}
        return 0}
      function length(h){return h[1]}
      function bucket_length(accu,param)
       {var accu$0=accu,param$0=param;
        for(;;)
         {if(param$0)
           {var
             param$1=param$0[3],
             accu$1=accu$0 + 1 | 0,
             accu$0=accu$1,
             param$0=param$1;
            continue}
          return accu$0}}
      function stats(h)
       {var
         _eU_=h[2],
         _eV_=0,
         mbl=
          fold_left$1
           (function(m,b){return max(m,bucket_length(0,b))},_eV_,_eU_),
         histo=caml_make_vect(mbl + 1 | 0,0),
         _eW_=h[2];
        iter$5
         (function(b)
           {var l=bucket_length(0,b);
            histo[1 + l] = caml_check_bound(histo,l)[1 + l] + 1 | 0;
            return 0},
          _eW_);
        return [0,h[1],h[2].length - 1,mbl,histo]}
      function bucket_length_alive(accu,param)
       {var accu$0=accu,param$0=param;
        for(;;)
         {if(param$0)
           {var rest=param$0[3],c=param$0[2];
            if(caml_call1(H[7],c))
             {var accu$1=accu$0 + 1 | 0,accu$0=accu$1,param$0=rest;continue}
            var param$1=param$0[3],param$0=param$1;
            continue}
          return accu$0}}
      function stats_alive(h)
       {var
         size=[0,0],
         _eR_=h[2],
         _eS_=0,
         mbl=
          fold_left$1
           (function(m,b){return max(m,bucket_length_alive(0,b))},_eS_,_eR_),
         histo=caml_make_vect(mbl + 1 | 0,0),
         _eT_=h[2];
        iter$5
         (function(b)
           {var l=bucket_length_alive(0,b);
            size[1] = size[1] + l | 0;
            histo[1 + l] = caml_check_bound(histo,l)[1 + l] + 1 | 0;
            return 0},
          _eT_);
        return [0,size[1],h[2].length - 1,mbl,histo]}
      function to_seq(tbl)
       {var tbl_data=tbl[2];
        function aux(i,buck,param)
         {var i$0=i,buck$0=buck;
          for(;;)
           {if(buck$0)
             {var
               next=buck$0[3],
               c=buck$0[2],
               match=caml_call1(H[5],c),
               match$0=caml_call1(H[4],c);
              if(match && match$0)
               {var data=match$0[1],key=match[1];
                return [0,
                        [0,key,data],
                        function(_eQ_){return aux(i$0,next,_eQ_)}]}
              var buck$0=next;
              continue}
            if(i$0 === tbl_data.length - 1)return 0;
            var
             buck$1=caml_check_bound(tbl_data,i$0)[1 + i$0],
             i$1=i$0 + 1 | 0,
             i$0=i$1,
             buck$0=buck$1;
            continue}}
        var _eN_=0,_eO_=0;
        return function(_eP_){return aux(_eO_,_eN_,_eP_)}}
      function to_seq_keys(m)
       {var _eJ_=to_seq(m);
        function _eK_(_eM_){return _eM_[1]}
        return function(_eL_){return map(_eK_,_eJ_,_eL_)}}
      function to_seq_values(m)
       {var _eF_=to_seq(m);
        function _eG_(_eI_){return _eI_[2]}
        return function(_eH_){return map(_eG_,_eF_,_eH_)}}
      function add_seq(tbl,i)
       {return iter
                (function(param)
                  {var v=param[2],k=param[1];return add(tbl,k,v)},
                 i)}
      function replace_seq(tbl,i)
       {return iter
                (function(param)
                  {var v=param[2],k=param[1];return replace(tbl,k,v)},
                 i)}
      function of_seq(i){var tbl=create(0,16);replace_seq(tbl,i);return tbl}
      return [0,
              create,
              clear,
              reset,
              copy,
              add,
              remove,
              find,
              find_opt,
              find_all,
              replace,
              mem,
              iter$0,
              filter_map_inplace,
              fold,
              length,
              stats,
              to_seq,
              to_seq_keys,
              to_seq_values,
              add_seq,
              replace_seq,
              of_seq,
              clean,
              stats_alive]}
    function create$5(param){return caml_call1(_r_[1],1)}
    function get_key$0(t){return caml_call2(_r_[3],t,0)}
    function get_key_copy$0(t){return caml_call2(_r_[4],t,0)}
    function set_key$0(t,k){return caml_call3(_r_[5],t,0,k)}
    function unset_key$0(t){return caml_call2(_r_[6],t,0)}
    function check_key$0(t){return caml_call2(_r_[7],t,0)}
    function blit_key$0(t1,t2){return caml_call5(_r_[8],t1,0,t2,0,1)}
    function get_data$1(t){return caml_call1(_r_[9],t)}
    function get_data_copy(t){return caml_call1(_r_[10],t)}
    function set_data(t,d){return caml_call2(_r_[11],t,d)}
    function unset_data(t){return caml_call1(_r_[12],t)}
    function check_data(t){return caml_call1(_r_[13],t)}
    function blit_data(t1,t2){return caml_call2(_r_[14],t1,t2)}
    function MakeSeeded$1(H)
     {function create(k,d)
       {var c=create$5(0);set_data(c,d);set_key$0(c,k);return c}
      var hash=H[2];
      function equal(c,k)
       {var match=get_key$0(c);
        if(match){var k$0=match[1];return caml_call2(H[1],k,k$0)?0:1}
        return 2}
      function set_key_data(c,k,d)
       {unset_data(c);set_key$0(c,k);return set_data(c,d)}
      return MakeSeeded$0
              ([0,
                create,
                hash,
                equal,
                get_data$1,
                get_key$0,
                set_key_data,
                check_key$0])}
    function Make$2(H)
     {var equal=H[1];
      function hash(seed,x){return caml_call1(H[2],x)}
      var
       include=MakeSeeded$1([0,equal,hash]),
       clear=include[2],
       reset=include[3],
       copy=include[4],
       add=include[5],
       remove=include[6],
       find=include[7],
       find_opt=include[8],
       find_all=include[9],
       replace=include[10],
       mem=include[11],
       iter=include[12],
       filter_map_inplace=include[13],
       fold=include[14],
       length=include[15],
       stats=include[16],
       to_seq=include[17],
       to_seq_keys=include[18],
       to_seq_values=include[19],
       add_seq=include[20],
       replace_seq=include[21],
       clean=include[23],
       stats_alive=include[24],
       _eE_=include[1];
      function create(sz){return caml_call2(_eE_,_cw_,sz)}
      function of_seq(i)
       {var tbl=create(16);caml_call2(replace_seq,tbl,i);return tbl}
      return [0,
              create,
              clear,
              reset,
              copy,
              add,
              remove,
              find,
              find_opt,
              find_all,
              replace,
              mem,
              iter,
              filter_map_inplace,
              fold,
              length,
              stats,
              to_seq,
              to_seq_keys,
              to_seq_values,
              add_seq,
              replace_seq,
              of_seq,
              clean,
              stats_alive]}
    function create$6(param){return caml_call1(_r_[1],2)}
    function get_key1(t){return caml_call2(_r_[3],t,0)}
    function get_key1_copy(t){return caml_call2(_r_[4],t,0)}
    function set_key1(t,k){return caml_call3(_r_[5],t,0,k)}
    function unset_key1(t){return caml_call2(_r_[6],t,0)}
    function check_key1(t){return caml_call2(_r_[7],t,0)}
    function get_key2(t){return caml_call2(_r_[3],t,1)}
    function get_key2_copy(t){return caml_call2(_r_[4],t,1)}
    function set_key2(t,k){return caml_call3(_r_[5],t,1,k)}
    function unset_key2(t){return caml_call2(_r_[6],t,1)}
    function check_key2(t){return caml_call2(_r_[7],t,1)}
    function blit_key1(t1,t2){return caml_call5(_r_[8],t1,0,t2,0,1)}
    function blit_key2(t1,t2){return caml_call5(_r_[8],t1,1,t2,1,1)}
    function blit_key12(t1,t2){return caml_call5(_r_[8],t1,0,t2,0,2)}
    function get_data$2(t){return caml_call1(_r_[9],t)}
    function get_data_copy$0(t){return caml_call1(_r_[10],t)}
    function set_data$0(t,d){return caml_call2(_r_[11],t,d)}
    function unset_data$0(t){return caml_call1(_r_[12],t)}
    function check_data$0(t){return caml_call1(_r_[13],t)}
    function blit_data$0(t1,t2){return caml_call2(_r_[14],t1,t2)}
    function MakeSeeded$2(H1,H2)
     {function create(param,d)
       {var k2=param[2],k1=param[1],c=create$6(0);
        set_data$0(c,d);
        set_key1(c,k1);
        set_key2(c,k2);
        return c}
      function hash(seed,param)
       {var
         k2=param[2],
         k1=param[1],
         _eD_=caml_call2(H2[2],seed,k2) * 65599 | 0;
        return caml_call2(H1[2],seed,k1) + _eD_ | 0}
      function equal(c,param)
       {var k2=param[2],k1=param[1],match=get_key1(c),match$0=get_key2(c);
        if(match && match$0)
         {var k2$0=match$0[1],k1$0=match[1];
          if(caml_call2(H1[1],k1,k1$0) && caml_call2(H2[1],k2,k2$0))return 0;
          return 1}
        return 2}
      function get_key(c)
       {var match=get_key1(c),match$0=get_key2(c);
        if(match && match$0)
         {var k2=match$0[1],k1=match[1];return [0,[0,k1,k2]]}
        return 0}
      function set_key_data(c,param,d)
       {var k2=param[2],k1=param[1];
        unset_data$0(c);
        set_key1(c,k1);
        set_key2(c,k2);
        return set_data$0(c,d)}
      function check_key(c)
       {var _eC_=check_key1(c);return _eC_?check_key2(c):_eC_}
      return MakeSeeded$0
              ([0,create,hash,equal,get_data$2,get_key,set_key_data,check_key])}
    function Make$3(H1,H2)
     {var equal=H2[1];
      function hash(seed,x){return caml_call1(H2[2],x)}
      var equal$0=H1[1],_eA_=[0,equal,hash];
      function hash$0(seed,x){return caml_call1(H1[2],x)}
      var
       include=MakeSeeded$2([0,equal$0,hash$0],_eA_),
       clear=include[2],
       reset=include[3],
       copy=include[4],
       add=include[5],
       remove=include[6],
       find=include[7],
       find_opt=include[8],
       find_all=include[9],
       replace=include[10],
       mem=include[11],
       iter=include[12],
       filter_map_inplace=include[13],
       fold=include[14],
       length=include[15],
       stats=include[16],
       to_seq=include[17],
       to_seq_keys=include[18],
       to_seq_values=include[19],
       add_seq=include[20],
       replace_seq=include[21],
       clean=include[23],
       stats_alive=include[24],
       _eB_=include[1];
      function create(sz){return caml_call2(_eB_,_cx_,sz)}
      function of_seq(i)
       {var tbl=create(16);caml_call2(replace_seq,tbl,i);return tbl}
      return [0,
              create,
              clear,
              reset,
              copy,
              add,
              remove,
              find,
              find_opt,
              find_all,
              replace,
              mem,
              iter,
              filter_map_inplace,
              fold,
              length,
              stats,
              to_seq,
              to_seq_keys,
              to_seq_values,
              add_seq,
              replace_seq,
              of_seq,
              clean,
              stats_alive]}
    function create$7(n){return caml_call1(_r_[1],n)}
    function length$6(k){return caml_call1(_r_[2],k)}
    function get_key$1(t,n){return caml_call2(_r_[3],t,n)}
    function get_key_copy$1(t,n){return caml_call2(_r_[4],t,n)}
    function set_key$1(t,n,k){return caml_call3(_r_[5],t,n,k)}
    function unset_key$1(t,n){return caml_call2(_r_[6],t,n)}
    function check_key$1(t,n){return caml_call2(_r_[7],t,n)}
    function blit_key$1(t1,o1,t2,o2,l)
     {return caml_call5(_r_[8],t1,o1,t2,o2,l)}
    function get_data$3(t){return caml_call1(_r_[9],t)}
    function get_data_copy$1(t){return caml_call1(_r_[10],t)}
    function set_data$1(t,d){return caml_call2(_r_[11],t,d)}
    function unset_data$1(t){return caml_call1(_r_[12],t)}
    function check_data$1(t){return caml_call1(_r_[13],t)}
    function blit_data$1(t1,t2){return caml_call2(_r_[14],t1,t2)}
    function MakeSeeded$3(H)
     {function create(k,d)
       {var c=create$7(k.length - 1);
        set_data$1(c,d);
        var _ey_=k.length - 1 - 1 | 0,_ex_=0;
        if(! (_ey_ < 0))
         {var i=_ex_;
          for(;;)
           {set_key$1(c,i,caml_check_bound(k,i)[1 + i]);
            var _ez_=i + 1 | 0;
            if(_ey_ !== i){var i=_ez_;continue}
            break}}
        return c}
      function hash(seed,k)
       {var h=[0,0],_et_=k.length - 1 - 1 | 0,_es_=0;
        if(! (_et_ < 0))
         {var i=_es_;
          for(;;)
           {var _eu_=h[1],_ev_=caml_check_bound(k,i)[1 + i];
            h[1] = (caml_call2(H[2],seed,_ev_) * 65599 | 0) + _eu_ | 0;
            var _ew_=i + 1 | 0;
            if(_et_ !== i){var i=_ew_;continue}
            break}}
        return h[1]}
      function equal(c,k)
       {var len=k.length - 1,len$0=length$6(c);
        if(len !== len$0)return 1;
        var i$1=len - 1 | 0,i=i$1;
        for(;;)
         {if(0 <= i)
           {var match=get_key$1(c,i);
            if(match)
             {var ki=match[1],_er_=caml_check_bound(k,i)[1 + i];
              if(caml_call2(H[1],_er_,ki)){var i$0=i - 1 | 0,i=i$0;continue}
              return 1}
            return 2}
          return 0}}
      function get_key(c)
       {var len=length$6(c);
        if(0 === len)return [0,[0]];
        var match=get_key$1(c,0);
        if(match)
         {var k0=match[1],a=caml_make_vect(len,k0),i$1=len - 1 | 0,i=i$1;
          for(;;)
           {if(1 <= i)
             {var match$0=get_key$1(c,i);
              if(match$0)
               {var ki=match$0[1];
                caml_check_bound(a,i)[1 + i] = ki;
                var i$0=i - 1 | 0,i=i$0;
                continue}
              return 0}
            return [0,a]}}
        return 0}
      function set_key_data(c,k,d)
       {unset_data$1(c);
        var _ep_=k.length - 1 - 1 | 0,_eo_=0;
        if(! (_ep_ < 0))
         {var i=_eo_;
          for(;;)
           {set_key$1(c,i,caml_check_bound(k,i)[1 + i]);
            var _eq_=i + 1 | 0;
            if(_ep_ !== i){var i=_eq_;continue}
            break}}
        return set_data$1(c,d)}
      function check_key(c)
       {var i$1=length$6(c) - 1 | 0,i=i$1;
        for(;;)
         {var _el_=i < 0?1:0;
          if(_el_)
           var _em_=_el_;
          else
           {var _en_=check_key$1(c,i);
            if(_en_){var i$0=i - 1 | 0,i=i$0;continue}
            var _em_=_en_}
          return _em_}}
      return MakeSeeded$0
              ([0,create,hash,equal,get_data$3,get_key,set_key_data,check_key])}
    function Make$4(H)
     {var equal=H[1];
      function hash(seed,x){return caml_call1(H[2],x)}
      var
       include=MakeSeeded$3([0,equal,hash]),
       clear=include[2],
       reset=include[3],
       copy=include[4],
       add=include[5],
       remove=include[6],
       find=include[7],
       find_opt=include[8],
       find_all=include[9],
       replace=include[10],
       mem=include[11],
       iter=include[12],
       filter_map_inplace=include[13],
       fold=include[14],
       length=include[15],
       stats=include[16],
       to_seq=include[17],
       to_seq_keys=include[18],
       to_seq_values=include[19],
       add_seq=include[20],
       replace_seq=include[21],
       clean=include[23],
       stats_alive=include[24],
       _ek_=include[1];
      function create(sz){return caml_call2(_ek_,_cy_,sz)}
      function of_seq(i)
       {var tbl=create(16);caml_call2(replace_seq,tbl,i);return tbl}
      return [0,
              create,
              clear,
              reset,
              copy,
              add,
              remove,
              find,
              find_opt,
              find_all,
              replace,
              mem,
              iter,
              filter_map_inplace,
              fold,
              length,
              stats,
              to_seq,
              to_seq_keys,
              to_seq_values,
              add_seq,
              replace_seq,
              of_seq,
              clean,
              stats_alive]}
    var
     Stdlib_ephemeron=
      [0,
       [0,
        create$5,
        get_key$0,
        get_key_copy$0,
        set_key$0,
        unset_key$0,
        check_key$0,
        blit_key$0,
        get_data$1,
        get_data_copy,
        set_data,
        unset_data,
        check_data,
        blit_data,
        Make$2,
        MakeSeeded$1],
       [0,
        create$6,
        get_key1,
        get_key1_copy,
        set_key1,
        unset_key1,
        check_key1,
        get_key2,
        get_key2_copy,
        set_key2,
        unset_key2,
        check_key2,
        blit_key1,
        blit_key2,
        blit_key12,
        get_data$2,
        get_data_copy$0,
        set_data$0,
        unset_data$0,
        check_data$0,
        blit_data$0,
        Make$3,
        MakeSeeded$2],
       [0,
        create$7,
        get_key$1,
        get_key_copy$1,
        set_key$1,
        unset_key$1,
        check_key$1,
        blit_key$1,
        get_data$3,
        get_data_copy$1,
        set_data$1,
        unset_data$1,
        check_data$1,
        blit_data$1,
        Make$4,
        MakeSeeded$3],
       [0,
        function(_ej_)
         {return MakeSeeded$0
                  ([0,_ej_[3],_ej_[1],_ej_[2],_ej_[5],_ej_[4],_ej_[6],_ej_[7]])}]];
    caml_register_global(795,Stdlib_ephemeron,"Stdlib__ephemeron");
    function generic_basename(is_dir_sep,current_dir_name,name)
     {if(caml_string_equal(name,cst$99))return current_dir_name;
      var n$3=caml_ml_string_length(name) - 1 | 0,n=n$3;
      for(;;)
       {if(0 <= n)
         {if(caml_call2(is_dir_sep,name,n)){var n$0=n - 1 | 0,n=n$0;continue}
          var p=n + 1 | 0,n$1=n;
          for(;;)
           {if(0 <= n$1)
             {if(caml_call2(is_dir_sep,name,n$1))
               return sub$0(name,n$1 + 1 | 0,(p - n$1 | 0) - 1 | 0);
              var n$2=n$1 - 1 | 0,n$1=n$2;
              continue}
            return sub$0(name,0,p)}}
        return sub$0(name,0,1)}}
    function generic_dirname(is_dir_sep,current_dir_name,name)
     {if(caml_string_equal(name,cst$100))return current_dir_name;
      var n$5=caml_ml_string_length(name) - 1 | 0,n=n$5;
      for(;;)
       {if(0 <= n)
         {if(caml_call2(is_dir_sep,name,n)){var n$0=n - 1 | 0,n=n$0;continue}
          var n$1=n;
          for(;;)
           {if(0 <= n$1)
             {if(caml_call2(is_dir_sep,name,n$1))
               {var n$3=n$1;
                for(;;)
                 {if(0 <= n$3)
                   {if(caml_call2(is_dir_sep,name,n$3))
                     {var n$4=n$3 - 1 | 0,n$3=n$4;continue}
                    return sub$0(name,0,n$3 + 1 | 0)}
                  return sub$0(name,0,1)}}
              var n$2=n$1 - 1 | 0,n$1=n$2;
              continue}
            return current_dir_name}}
        return sub$0(name,0,1)}}
    function is_dir_sep(s,i){return 47 === caml_string_get(s,i)?1:0}
    function is_relative(n)
     {var
       _eh_=caml_ml_string_length(n) < 1?1:0,
       _ei_=_eh_ || (47 !== caml_string_get(n,0)?1:0);
      return _ei_}
    function is_implicit(n)
     {var _ec_=is_relative(n);
      if(_ec_)
       {var
         _ed_=caml_ml_string_length(n) < 2?1:0,
         _ee_=_ed_ || caml_string_notequal(sub$0(n,0,2),cst$102);
        if(_ee_)
         var
          _ef_=caml_ml_string_length(n) < 3?1:0,
          _eg_=_ef_ || caml_string_notequal(sub$0(n,0,3),cst$101);
        else
         var _eg_=_ee_}
      else
       var _eg_=_ec_;
      return _eg_}
    function check_suffix(name,suff)
     {var
       _ea_=caml_ml_string_length(suff) <= caml_ml_string_length(name)?1:0,
       _eb_=
        _ea_
         ?caml_string_equal
           (sub$0
             (name,
              caml_ml_string_length(name) - caml_ml_string_length(suff) | 0,
              caml_ml_string_length(suff)),
            suff)
         :_ea_;
      return _eb_}
    function chop_suffix_opt(suffix,filename)
     {var
       len_s=caml_ml_string_length(suffix),
       len_f=caml_ml_string_length(filename);
      if(len_s <= len_f)
       {var r=sub$0(filename,len_f - len_s | 0,len_s);
        return caml_string_equal(r,suffix)
                ?[0,sub$0(filename,0,len_f - len_s | 0)]
                :0}
      return 0}
    try
     {var _cG_=caml_sys_getenv(cst_TMPDIR),_cz_=_cG_}
    catch(_d$_)
     {_d$_ = caml_wrap_exception(_d$_);
      if(_d$_ !== Not_found)throw _d$_;
      var _cz_=cst_tmp}
    function quote(s)
     {var l=caml_ml_string_length(s),b=create$2(l + 20 | 0);
      add_char(b,39);
      var _d9_=l - 1 | 0,_d8_=0;
      if(! (_d9_ < 0))
       {var i=_d8_;
        for(;;)
         {if(39 === caml_string_get(s,i))
           add_string(b,quotequote);
          else
           add_char(b,caml_string_get(s,i));
          var _d__=i + 1 | 0;
          if(_d9_ !== i){var i=_d__;continue}
          break}}
      add_char(b,39);
      return contents(b)}
    function quote_command(cmd,stdin,stdout,stderr,args)
     {if(stderr)
       var
        f=stderr[1],
        _d2_=caml_equal(stderr,stdout)?cst_2_1:symbol(cst_2,quote(f)),
        _d3_=_d2_;
      else
       var _d3_=cst$108;
      if(stdout)
       var f$0=stdout[1],_d4_=symbol(cst$103,quote(f$0));
      else
       var _d4_=cst$107;
      var _d5_=symbol(_d4_,_d3_);
      if(stdin)
       var f$1=stdin[1],_d6_=symbol(cst$104,quote(f$1));
      else
       var _d6_=cst$106;
      var _d7_=symbol(_d6_,_d5_);
      return symbol(concat$0(cst$105,map$2(quote,[0,cmd,args])),_d7_)}
    function basename(_d1_)
     {return generic_basename(is_dir_sep,current_dir_name,_d1_)}
    function dirname(_d0_)
     {return generic_dirname(is_dir_sep,current_dir_name,_d0_)}
    var
     Unix=
      [0,
       null$0,
       current_dir_name,
       parent_dir_name,
       dir_sep,
       is_dir_sep,
       is_relative,
       is_implicit,
       check_suffix,
       chop_suffix_opt,
       _cz_,
       quote,
       quote_command,
       basename,
       dirname];
    function is_dir_sep$0(s,i)
     {var c=caml_string_get(s,i),_dX_=47 === c?1:0;
      if(_dX_)
       var _dY_=_dX_;
      else
       var _dZ_=92 === c?1:0,_dY_=_dZ_ || (58 === c?1:0);
      return _dY_}
    function is_relative$0(n)
     {var
       _dR_=caml_ml_string_length(n) < 1?1:0,
       _dS_=_dR_ || (47 !== caml_string_get(n,0)?1:0);
      if(_dS_)
       {var
         _dT_=caml_ml_string_length(n) < 1?1:0,
         _dU_=_dT_ || (92 !== caml_string_get(n,0)?1:0);
        if(_dU_)
         var
          _dV_=caml_ml_string_length(n) < 2?1:0,
          _dW_=_dV_ || (58 !== caml_string_get(n,1)?1:0);
        else
         var _dW_=_dU_}
      else
       var _dW_=_dS_;
      return _dW_}
    function is_implicit$0(n)
     {var _dI_=is_relative$0(n);
      if(_dI_)
       {var
         _dJ_=caml_ml_string_length(n) < 2?1:0,
         _dK_=_dJ_ || caml_string_notequal(sub$0(n,0,2),cst$112);
        if(_dK_)
         {var
           _dL_=caml_ml_string_length(n) < 2?1:0,
           _dM_=_dL_ || caml_string_notequal(sub$0(n,0,2),cst$111);
          if(_dM_)
           {var
             _dN_=caml_ml_string_length(n) < 3?1:0,
             _dO_=_dN_ || caml_string_notequal(sub$0(n,0,3),cst$110);
            if(_dO_)
             var
              _dP_=caml_ml_string_length(n) < 3?1:0,
              _dQ_=_dP_ || caml_string_notequal(sub$0(n,0,3),cst$109);
            else
             var _dQ_=_dO_}
          else
           var _dQ_=_dM_}
        else
         var _dQ_=_dK_}
      else
       var _dQ_=_dI_;
      return _dQ_}
    function check_suffix$0(name,suff)
     {var _dF_=caml_ml_string_length(suff) <= caml_ml_string_length(name)?1:0;
      if(_dF_)
       var
        s=
         sub$0
          (name,
           caml_ml_string_length(name) - caml_ml_string_length(suff) | 0,
           caml_ml_string_length(suff)),
        _dG_=lowercase_ascii$1(suff),
        _dH_=caml_string_equal(lowercase_ascii$1(s),_dG_);
      else
       var _dH_=_dF_;
      return _dH_}
    function chop_suffix_opt$0(suffix,filename)
     {var
       len_s=caml_ml_string_length(suffix),
       len_f=caml_ml_string_length(filename);
      if(len_s <= len_f)
       {var
         r=sub$0(filename,len_f - len_s | 0,len_s),
         _dE_=lowercase_ascii$1(suffix);
        return caml_string_equal(lowercase_ascii$1(r),_dE_)
                ?[0,sub$0(filename,0,len_f - len_s | 0)]
                :0}
      return 0}
    try
     {var _cF_=caml_sys_getenv(cst_TEMP),temp_dir_name=_cF_}
    catch(_dD_)
     {_dD_ = caml_wrap_exception(_dD_);
      if(_dD_ !== Not_found)throw _dD_;
      var temp_dir_name=cst$113}
    function quote$0(s)
     {var l=caml_ml_string_length(s),b=create$2(l + 20 | 0);
      add_char(b,34);
      function add_bs(n)
       {var _dB_=1;
        if(! (n < 1))
         {var j=_dB_;
          for(;;)
           {add_char(b,92);
            var _dC_=j + 1 | 0;
            if(n !== j){var j=_dC_;continue}
            break}}
        return 0}
      function loop$0(counter,i)
       {var i$0=i;
        for(;;)
         {if(i$0 === l)return add_char(b,34);
          var c=caml_string_get(s,i$0);
          if(34 === c)
           {var _dz_=0;
            if(counter < 50)
             {var counter$1=counter + 1 | 0;
              return loop_bs(counter$1,_dz_,i$0)}
            return caml_trampoline_return(loop_bs,[0,_dz_,i$0])}
          if(92 === c)
           {var _dA_=0;
            if(counter < 50)
             {var counter$0=counter + 1 | 0;
              return loop_bs(counter$0,_dA_,i$0)}
            return caml_trampoline_return(loop_bs,[0,_dA_,i$0])}
          add_char(b,c);
          var i$1=i$0 + 1 | 0,i$0=i$1;
          continue}}
      function loop_bs(counter,n,i)
       {var n$0=n,i$0=i;
        for(;;)
         {if(i$0 === l){add_char(b,34);return add_bs(n$0)}
          var match=caml_string_get(s,i$0);
          if(34 === match)
           {add_bs((2 * n$0 | 0) + 1 | 0);
            add_char(b,34);
            var _dy_=i$0 + 1 | 0;
            if(counter < 50)
             {var counter$1=counter + 1 | 0;return loop$0(counter$1,_dy_)}
            return caml_trampoline_return(loop$0,[0,_dy_])}
          if(92 === match)
           {var i$1=i$0 + 1 | 0,n$1=n$0 + 1 | 0,n$0=n$1,i$0=i$1;continue}
          add_bs(n$0);
          if(counter < 50)
           {var counter$0=counter + 1 | 0;return loop$0(counter$0,i$0)}
          return caml_trampoline_return(loop$0,[0,i$0])}}
      function loop(i){return caml_trampoline(loop$0(0,i))}
      loop(0);
      return contents(b)}
    function quote_cmd_filename(f)
     {if(! contains$0(f,34) && ! contains$0(f,37))
       return contains$0(f,32)?symbol(cst$115,symbol(f,cst$114)):f;
      return failwith(symbol(cst_Filename_quote_command_bad,f))}
    function quote_command$0(cmd,stdin,stdout,stderr,args)
     {if(stderr)
       var
        f=stderr[1],
        _dp_=
         caml_equal(stderr,stdout)
          ?cst_2_1$0
          :symbol(cst_2$0,quote_cmd_filename(f)),
        _dq_=_dp_;
      else
       var _dq_=cst$124;
      var _dr_=[0,_dq_,_cA_];
      if(stdout)
       var f$0=stdout[1],_ds_=symbol(cst$116,quote_cmd_filename(f$0));
      else
       var _ds_=cst$123;
      var _dt_=[0,_ds_,_dr_];
      if(stdin)
       var f$1=stdin[1],_du_=symbol(cst$117,quote_cmd_filename(f$1));
      else
       var _du_=cst$122;
      var
       s=concat$0(cst$118,map$2(quote$0,args)),
       b=create$2(caml_ml_string_length(s) + 20 | 0),
       _dv_=[0,_du_,_dt_];
      iter$4
       (function(c)
         {var switch$0=0;
          if(62 <= c)
           {var _dx_=c - 63 | 0;
            if(60 < _dx_ >>> 0)
             {if(! (62 <= _dx_))switch$0 = 1}
            else
             if(31 === _dx_)switch$0 = 1}
          else
           if(42 <= c)
            {if(60 === c)switch$0 = 1}
           else
            if(33 <= c)
             switch(c - 33 | 0)
              {case 2:case 3:case 6:break;default:switch$0 = 1}
          return switch$0?(add_char(b,94),add_char(b,c)):add_char(b,c)},
        s);
      var _dw_=[0,cst$119,[0,contents(b),_dv_]];
      return concat$0(cst$121,[0,cst$120,[0,quote_cmd_filename(cmd),_dw_]])}
    function drive_and_path(s)
     {var _dl_=2 <= caml_ml_string_length(s)?1:0;
      if(_dl_)
       {var param=caml_string_get(s,0),switch$0=0;
        if(91 <= param)
         {if(! (25 < (param - 97 | 0) >>> 0))switch$0 = 1}
        else
         if(65 <= param)switch$0 = 1;
        var _dm_=switch$0?1:0,_dn_=_dm_?58 === caml_string_get(s,1)?1:0:_dm_}
      else
       var _dn_=_dl_;
      if(_dn_)
       {var _do_=sub$0(s,2,caml_ml_string_length(s) - 2 | 0);
        return [0,sub$0(s,0,2),_do_]}
      return [0,cst$125,s]}
    function dirname$0(s)
     {var
       match=drive_and_path(s),
       path=match[2],
       drive=match[1],
       dir=generic_dirname(is_dir_sep$0,current_dir_name$0,path);
      return symbol(drive,dir)}
    function basename$0(s)
     {var match=drive_and_path(s),path=match[2];
      return generic_basename(is_dir_sep$0,current_dir_name$0,path)}
    var
     Win32=
      [0,
       null$1,
       current_dir_name$0,
       parent_dir_name$0,
       dir_sep$0,
       is_dir_sep$0,
       is_relative$0,
       is_implicit$0,
       check_suffix$0,
       chop_suffix_opt$0,
       temp_dir_name,
       quote$0,
       quote_command$0,
       basename$0,
       dirname$0];
    function basename$1(_dk_)
     {return generic_basename(is_dir_sep$0,current_dir_name$1,_dk_)}
    function dirname$1(_dj_)
     {return generic_dirname(is_dir_sep$0,current_dir_name$1,_dj_)}
    var
     Cygwin=
      [0,
       null$2,
       current_dir_name$1,
       parent_dir_name$1,
       dir_sep$1,
       is_dir_sep$0,
       is_relative$0,
       is_implicit$0,
       check_suffix$0,
       chop_suffix_opt$0,
       _cz_,
       quote,
       quote_command,
       basename$1,
       dirname$1],
     Sysdeps=
      caml_string_notequal(os_type,cst_Cygwin)
       ?caml_string_notequal(os_type,cst_Win32)?Unix:Win32
       :Cygwin,
     null$3=Sysdeps[1],
     current_dir_name$2=Sysdeps[2],
     parent_dir_name$2=Sysdeps[3],
     dir_sep$2=Sysdeps[4],
     is_dir_sep$1=Sysdeps[5],
     is_relative$1=Sysdeps[6],
     is_implicit$1=Sysdeps[7],
     check_suffix$1=Sysdeps[8],
     chop_suffix_opt$1=Sysdeps[9],
     temp_dir_name$0=Sysdeps[10],
     quote$1=Sysdeps[11],
     quote_command$1=Sysdeps[12],
     basename$2=Sysdeps[13],
     dirname$2=Sysdeps[14];
    function concat$3(dirname,filename)
     {var l=caml_ml_string_length(dirname);
      if(0 !== l && ! is_dir_sep$1(dirname,l - 1 | 0))
       return symbol(dirname,symbol(dir_sep$2,filename));
      return symbol(dirname,filename)}
    function chop_suffix(name,suff)
     {var n=caml_ml_string_length(name) - caml_ml_string_length(suff) | 0;
      return 0 <= n?sub$0(name,0,n):invalid_arg(cst_Filename_chop_suffix)}
    function extension_len(name)
     {var i$4=caml_ml_string_length(name) - 1 | 0,i$1=i$4;
      for(;;)
       {if(0 <= i$1 && ! is_dir_sep$1(name,i$1))
         {if(46 === caml_string_get(name,i$1))
           {var i$2=i$1 - 1 | 0,i=i$2;
            for(;;)
             {if(0 <= i && ! is_dir_sep$1(name,i))
               {if(46 === caml_string_get(name,i))
                 {var i$0=i - 1 | 0,i=i$0;continue}
                return caml_ml_string_length(name) - i$1 | 0}
              return 0}}
          var i$3=i$1 - 1 | 0,i$1=i$3;
          continue}
        return 0}}
    function extension(name)
     {var l=extension_len(name);
      return 0 === l?cst$126:sub$0(name,caml_ml_string_length(name) - l | 0,l)}
    function chop_extension(name)
     {var l=extension_len(name);
      return 0 === l
              ?invalid_arg(cst_Filename_chop_extension)
              :sub$0(name,0,caml_ml_string_length(name) - l | 0)}
    function remove_extension(name)
     {var l=extension_len(name);
      return 0 === l?name:sub$0(name,0,caml_ml_string_length(name) - l | 0)}
    var prng$0=[246,function(_di_){return caml_call1(_b2_[2],0)}];
    function temp_file_name(temp_dir,prefix,suffix)
     {var
       _dg_=caml_obj_tag(prng$0),
       _dh_=
        250 === _dg_?prng$0[1]:246 === _dg_?force_lazy_block(prng$0):prng$0,
       rnd=caml_call1(_b2_[4],_dh_) & 16777215;
      return concat$3(temp_dir,caml_call3(sprintf(_cB_),prefix,rnd,suffix))}
    var current_temp_dir_name=[0,temp_dir_name$0];
    function set_temp_dir_name(s){current_temp_dir_name[1] = s;return 0}
    function get_temp_dir_name(param){return current_temp_dir_name[1]}
    function temp_file(opt,prefix,suffix)
     {if(opt)
       var sth=opt[1],temp_dir=sth;
      else
       var temp_dir=current_temp_dir_name[1];
      function try_name(counter)
       {var counter$0=counter;
        for(;;)
         {var name=temp_file_name(temp_dir,prefix,suffix);
          try
           {runtime.caml_sys_close(caml_sys_open(name,_cC_,384));return name}
          catch(e)
           {e = caml_wrap_exception(e);
            if(e[1] === Sys_error)
             {if(1000 <= counter$0)throw e;
              var counter$1=counter$0 + 1 | 0,counter$0=counter$1;
              continue}
            throw e}}}
      return try_name(0)}
    function open_temp_file(opt,_de_,_dd_,prefix,suffix)
     {if(opt)var sth=opt[1],mode=sth;else var mode=_cD_;
      if(_de_)var sth$0=_de_[1],perms=sth$0;else var perms=384;
      if(_dd_)
       var sth$1=_dd_[1],temp_dir=sth$1;
      else
       var temp_dir=current_temp_dir_name[1];
      function try_name(counter)
       {var counter$0=counter;
        for(;;)
         {var name=temp_file_name(temp_dir,prefix,suffix);
          try
           {var _df_=[0,name,open_out_gen([0,1,[0,3,[0,5,mode]]],perms,name)];
            return _df_}
          catch(e)
           {e = caml_wrap_exception(e);
            if(e[1] === Sys_error)
             {if(1000 <= counter$0)throw e;
              var counter$1=counter$0 + 1 | 0,counter$0=counter$1;
              continue}
            throw e}}}
      return try_name(0)}
    var
     Stdlib_filename=
      [0,
       current_dir_name$2,
       parent_dir_name$2,
       dir_sep$2,
       concat$3,
       is_relative$1,
       is_implicit$1,
       check_suffix$1,
       chop_suffix,
       chop_suffix_opt$1,
       extension,
       remove_extension,
       chop_extension,
       basename$2,
       dirname$2,
       null$3,
       temp_file,
       open_temp_file,
       get_temp_dir_name,
       set_temp_dir_name,
       temp_dir_name$0,
       quote$1,
       quote_command$1];
    caml_register_global(796,Stdlib_filename,"Stdlib__filename");
    function add$1(x,y){return [254,x[1] + y[1],x[2] + y[2]]}
    function sub$4(x,y){return [254,x[1] - y[1],x[2] - y[2]]}
    function neg(x){return [254,- x[1],- x[2]]}
    function conj(x){return [254,x[1],- x[2]]}
    function mul(x,y)
     {return [254,x[1] * y[1] - x[2] * y[2],x[1] * y[2] + x[2] * y[1]]}
    function div(x,y)
     {if(Math.abs(y[2]) <= Math.abs(y[1]))
       {var r=y[2] / y[1],d=y[1] + r * y[2];
        return [254,(x[1] + r * x[2]) / d,(x[2] - r * x[1]) / d]}
      var r$0=y[1] / y[2],d$0=y[2] + r$0 * y[1];
      return [254,(r$0 * x[1] + x[2]) / d$0,(r$0 * x[2] - x[1]) / d$0]}
    function inv(x){return div(one$4,x)}
    function norm2(x){return x[1] * x[1] + x[2] * x[2]}
    function norm(x)
     {var r=Math.abs(x[1]),i=Math.abs(x[2]);
      if(r == 0.)return i;
      if(i == 0.)return r;
      if(i <= r){var q=i / r;return r * Math.sqrt(1. + q * q)}
      var q$0=r / i;
      return i * Math.sqrt(1. + q$0 * q$0)}
    function arg(x){return Math.atan2(x[2],x[1])}
    function polar(n,a){return [254,Math.cos(a) * n,Math.sin(a) * n]}
    function sqrt(x)
     {if(x[1] == 0. && x[2] == 0.)return _cE_;
      var r=Math.abs(x[1]),i=Math.abs(x[2]);
      if(i <= r)
       var
        q=i / r,
        w=Math.sqrt(r) * Math.sqrt(0.5 * (1. + Math.sqrt(1. + q * q)));
      else
       var
        q$0=r / i,
        w=Math.sqrt(i) * Math.sqrt(0.5 * (q$0 + Math.sqrt(1. + q$0 * q$0)));
      if(0. <= x[1])return [254,w,0.5 * x[2] / w];
      var w$0=0. <= x[2]?w:- w;
      return [254,0.5 * i / w,w$0]}
    function exp(x)
     {var e=Math.exp(x[1]);return [254,e * Math.cos(x[2]),e * Math.sin(x[2])]}
    function log(x)
     {var _dc_=Math.atan2(x[2],x[1]);return [254,Math.log(norm(x)),_dc_]}
    function pow(x,y){return exp(mul(y,log(x)))}
    var
     Stdlib_complex=
      [0,
       zero$4,
       one$4,
       i,
       neg,
       conj,
       add$1,
       sub$4,
       mul,
       inv,
       div,
       sqrt,
       norm2,
       norm,
       arg,
       polar,
       exp,
       log,
       pow];
    caml_register_global(797,Stdlib_complex,"Stdlib__complex");
    var
     Stdlib_arrayLabels=
      [0,
       init$2,
       create_matrix,
       create_matrix,
       append$0,
       concat$1,
       sub$1,
       copy$1,
       fill$0,
       blit$1,
       to_list$1,
       of_list,
       iter$5,
       map$5,
       iteri$2,
       mapi$2,
       fold_left$1,
       fold_right$0,
       iter2$0,
       map2$0,
       exists$0,
       for_all$0,
       mem$0,
       memq$0,
       make_float,
       sort,
       fast_sort$0,
       fast_sort$0,
       to_seq$4,
       to_seqi$1,
       of_seq$2,
       Floatarray];
    caml_register_global(798,Stdlib_arrayLabels,"Stdlib__arrayLabels");
    var
     Stdlib_listLabels=
      [0,
       length,
       hd,
       compare_lengths,
       compare_length_with,
       cons,
       tl,
       nth,
       nth_opt,
       rev,
       init,
       append,
       rev_append,
       flatten,
       flatten,
       iter$2,
       iteri,
       map$2,
       mapi,
       rev_map,
       filter_map$0,
       concat_map,
       fold_left$0,
       fold_right,
       iter2,
       map2,
       rev_map2,
       fold_left2,
       fold_right2,
       for_all,
       exists,
       for_all2,
       exists2,
       mem,
       memq,
       find,
       find_opt,
       find_map,
       find_all,
       find_all,
       partition,
       assoc,
       assoc_opt,
       assq,
       assq_opt,
       mem_assoc,
       mem_assq,
       remove_assoc,
       remove_assq,
       split,
       combine,
       fast_sort,
       fast_sort,
       fast_sort,
       sort_uniq,
       merge,
       to_seq$1,
       of_seq];
    caml_register_global(799,Stdlib_listLabels,"Stdlib__listLabels");
    var
     Stdlib_bytesLabels=
      [0,
       make,
       init$0,
       empty$0,
       copy,
       of_string,
       to_string$1,
       sub,
       sub_string,
       extend,
       fill,
       blit,
       blit$0,
       concat,
       cat,
       iter$3,
       iteri$0,
       map$3,
       mapi$0,
       trim,
       escaped$0,
       index,
       index_opt,
       rindex,
       rindex_opt,
       index_from,
       index_from_opt,
       rindex_from,
       rindex_from_opt,
       contains,
       contains_from,
       rcontains_from,
       uppercase$0,
       lowercase$0,
       capitalize,
       uncapitalize,
       uppercase_ascii$0,
       lowercase_ascii$0,
       capitalize_ascii,
       uncapitalize_ascii,
       compare$4,
       equal$4,
       to_seq$2,
       to_seqi,
       of_seq$0,
       get_uint8,
       get_int8,
       get_uint16_ne,
       get_uint16_be,
       get_uint16_le,
       get_int16_ne,
       get_int16_be,
       get_int16_le,
       get_int32_ne,
       get_int32_be,
       get_int32_le,
       get_int64_ne,
       get_int64_be,
       get_int64_le,
       set_uint8,
       set_int8,
       set_uint16_ne,
       set_int16_be,
       set_int16_le,
       set_int16_ne,
       set_int16_be,
       set_int16_le,
       set_int32_ne,
       set_int32_be,
       set_int32_le,
       set_int64_ne,
       set_int64_be,
       set_int64_le,
       unsafe_to_string,
       unsafe_of_string];
    caml_register_global(800,Stdlib_bytesLabels,"Stdlib__bytesLabels");
    var
     Stdlib_stringLabels=
      [0,
       make$0,
       init$1,
       copy$0,
       sub$0,
       fill,
       blit$0,
       concat$0,
       iter$4,
       iteri$1,
       map$4,
       mapi$1,
       trim$0,
       escaped$1,
       index$0,
       index_opt$0,
       rindex$0,
       rindex_opt$0,
       index_from$0,
       index_from_opt$0,
       rindex_from$0,
       rindex_from_opt$0,
       contains$0,
       contains_from$0,
       rcontains_from$0,
       uppercase$1,
       lowercase$1,
       capitalize$0,
       uncapitalize$0,
       uppercase_ascii$1,
       lowercase_ascii$1,
       capitalize_ascii$0,
       uncapitalize_ascii$0,
       compare$5,
       equal$5,
       split_on_char,
       to_seq$3,
       to_seqi$0,
       of_seq$1];
    caml_register_global(801,Stdlib_stringLabels,"Stdlib__stringLabels");
    var Stdlib_moreLabels=[0,Stdlib_hashtbl,Stdlib_map,Stdlib_set];
    caml_register_global(802,Stdlib_moreLabels,"Stdlib__moreLabels");
    var Stdlib_stdLabels=[0];
    caml_register_global(803,Stdlib_stdLabels,"Stdlib__stdLabels");
    var enabled=caml_spacetime_enabled(0);
    function if_spacetime_enabled(f){return enabled?caml_call1(f,0):0}
    function create$8(path)
     {if(caml_spacetime_enabled(0))
       {var channel=open_out(path),t=[0,channel,0];
        caml_spacetime_only_works_for_(t[1]);
        return t}
      return [0,stdout,1]}
    function save_event(time,t,event_name)
     {return if_spacetime_enabled
              (function(param)
                {return caml_spacetime_only_works_for_(time,t[1],event_name)})}
    function save_and_close(time,t)
     {return if_spacetime_enabled
              (function(param)
                {if(t[2])failwith(cst_Series_is_closed);
                 caml_spacetime_only_works_for_(time,t[1]);
                 close_out(t[1]);
                 t[2] = 1;
                 return 0})}
    var Series=[0,create$8,save_event,save_and_close];
    function take$0(time,param)
     {var channel=param[1],closed=param[2];
      return if_spacetime_enabled
              (function(param)
                {if(closed)failwith(cst_Series_is_closed$0);
                 runtime.caml_gc_minor(0);
                 return caml_spacetime_only_works_for_(time,channel)})}
    var Snapshot=[0,take$0];
    function save_event_for_automatic_snaps(event_name)
     {return if_spacetime_enabled
              (function(param)
                {return caml_spacetime_only_works_for_(event_name)})}
    var
     Stdlib_spacetime=
      [0,enabled,Series,Snapshot,save_event_for_automatic_snaps];
    caml_register_global(804,Stdlib_spacetime,"Stdlib__spacetime");
    var
     float32=0,
     float64=1,
     int8_signed=2,
     int8_unsigned=3,
     int16_signed=4,
     int16_unsigned=5,
     int32$1=6,
     int64$1=7,
     int$2=8,
     nativeint$1=9,
     complex32=10,
     complex64=11,
     char$0=12;
    function kind_size_in_bytes(param)
     {switch(param)
       {case 0:return 4;
        case 1:return 8;
        case 2:return 1;
        case 3:return 1;
        case 4:return 2;
        case 5:return 2;
        case 6:return 4;
        case 7:return 8;
        case 8:return 4;
        case 9:return 4;
        case 10:return 8;
        case 11:return 16;
        default:return 1}}
    var c_layout=0,fortran_layout=1;
    function dims(a)
     {var n=caml_ba_num_dims(a),d=caml_make_vect(n,0),_c$_=n - 1 | 0,_c__=0;
      if(! (_c$_ < 0))
       {var i=_c__;
        for(;;)
         {var _da_=runtime.caml_ba_dim(a,i);
          caml_check_bound(d,i)[1 + i] = _da_;
          var _db_=i + 1 | 0;
          if(_c$_ !== i){var i=_db_;continue}
          break}}
      return d}
    function size_in_bytes(arr)
     {var _c9_=fold_left$1(caml_mul,1,dims(arr));
      return caml_mul(kind_size_in_bytes(caml_ba_kind(arr)),_c9_)}
    var Genarray=[0,dims,size_in_bytes];
    function create$9(kind,layout){return caml_ba_create(kind,layout,[0])}
    function get$1(arr){return runtime.caml_ba_get_generic(arr,[0])}
    function set$0(arr)
     {var _c7_=[0];
      return function(_c8_){return runtime.caml_ba_set_generic(arr,_c7_,_c8_)}}
    function size_in_bytes$0(arr)
     {return kind_size_in_bytes(caml_ba_kind(arr))}
    function of_value(kind,layout,v)
     {var a=create$9(kind,layout);caml_call1(set$0(a),v);return a}
    function create$10(kind,layout,dim)
     {return caml_ba_create(kind,layout,[0,dim])}
    function size_in_bytes$1(arr)
     {var _c6_=caml_ba_dim_1(arr);
      return caml_mul(kind_size_in_bytes(caml_ba_kind(arr)),_c6_)}
    function slice(a,n)
     {var match=runtime.caml_ba_layout(a);
      return match?caml_ba_slice(a,[0,n]):caml_ba_slice(a,[0,n])}
    function of_array(kind,layout,data)
     {var
       ba=create$10(kind,layout,data.length - 1),
       ofs=layout?1:0,
       _c4_=data.length - 1 - 1 | 0,
       _c3_=0;
      if(! (_c4_ < 0))
       {var i=_c3_;
        for(;;)
         {runtime.caml_ba_set_1
           (ba,i + ofs | 0,caml_check_bound(data,i)[1 + i]);
          var _c5_=i + 1 | 0;
          if(_c4_ !== i){var i=_c5_;continue}
          break}}
      return ba}
    function create$11(kind,layout,dim1,dim2)
     {return caml_ba_create(kind,layout,[0,dim1,dim2])}
    function size_in_bytes$2(arr)
     {var _c1_=caml_ba_dim_2(arr),_c2_=caml_ba_dim_1(arr);
      return caml_mul
              (caml_mul(kind_size_in_bytes(caml_ba_kind(arr)),_c2_),_c1_)}
    function slice_left(a,n){return caml_ba_slice(a,[0,n])}
    function slice_right(a,n){return caml_ba_slice(a,[0,n])}
    function of_array$0(kind,layout,data)
     {var
       dim1=data.length - 1,
       dim2=0 === dim1?0:caml_check_bound(data,0)[1].length - 1,
       ba=create$11(kind,layout,dim1,dim2),
       ofs=layout?1:0,
       _cW_=dim1 - 1 | 0,
       _cV_=0;
      if(! (_cW_ < 0))
       {var i=_cV_;
        for(;;)
         {var row=caml_check_bound(data,i)[1 + i];
          if(row.length - 1 !== dim2)
           invalid_arg(cst_Bigarray_Array2_of_array_n);
          var _cY_=dim2 - 1 | 0,_cX_=0;
          if(! (_cY_ < 0))
           {var j=_cX_;
            for(;;)
             {runtime.caml_ba_set_2
               (ba,i + ofs | 0,j + ofs | 0,caml_check_bound(row,j)[1 + j]);
              var _c0_=j + 1 | 0;
              if(_cY_ !== j){var j=_c0_;continue}
              break}}
          var _cZ_=i + 1 | 0;
          if(_cW_ !== i){var i=_cZ_;continue}
          break}}
      return ba}
    function create$12(kind,layout,dim1,dim2,dim3)
     {return caml_ba_create(kind,layout,[0,dim1,dim2,dim3])}
    function size_in_bytes$3(arr)
     {var
       _cS_=runtime.caml_ba_dim_3(arr),
       _cT_=caml_ba_dim_2(arr),
       _cU_=caml_ba_dim_1(arr);
      return caml_mul
              (caml_mul
                (caml_mul(kind_size_in_bytes(caml_ba_kind(arr)),_cU_),_cT_),
               _cS_)}
    function slice_left_1(a,n,m){return caml_ba_slice(a,[0,n,m])}
    function slice_right_1(a,n,m){return caml_ba_slice(a,[0,n,m])}
    function slice_left_2(a,n){return caml_ba_slice(a,[0,n])}
    function slice_right_2(a,n){return caml_ba_slice(a,[0,n])}
    function of_array$1(kind,layout,data)
     {var
       dim1=data.length - 1,
       dim2=0 === dim1?0:caml_check_bound(data,0)[1].length - 1,
       dim3=
        0 === dim2
         ?0
         :caml_check_bound(caml_check_bound(data,0)[1],0)[1].length - 1,
       ba=create$12(kind,layout,dim1,dim2,dim3),
       ofs=layout?1:0,
       _cK_=dim1 - 1 | 0,
       _cJ_=0;
      if(! (_cK_ < 0))
       {var i=_cJ_;
        for(;;)
         {var row=caml_check_bound(data,i)[1 + i];
          if(row.length - 1 !== dim2)
           invalid_arg(cst_Bigarray_Array3_of_array_n);
          var _cM_=dim2 - 1 | 0,_cL_=0;
          if(! (_cM_ < 0))
           {var j=_cL_;
            for(;;)
             {var col=caml_check_bound(row,j)[1 + j];
              if(col.length - 1 !== dim3)
               invalid_arg(cst_Bigarray_Array3_of_array_n$0);
              var _cP_=dim3 - 1 | 0,_cO_=0;
              if(! (_cP_ < 0))
               {var k=_cO_;
                for(;;)
                 {runtime.caml_ba_set_3
                   (ba,
                    i + ofs | 0,
                    j + ofs | 0,
                    k + ofs | 0,
                    caml_check_bound(col,k)[1 + k]);
                  var _cR_=k + 1 | 0;
                  if(_cP_ !== k){var k=_cR_;continue}
                  break}}
              var _cQ_=j + 1 | 0;
              if(_cM_ !== j){var j=_cQ_;continue}
              break}}
          var _cN_=i + 1 | 0;
          if(_cK_ !== i){var i=_cN_;continue}
          break}}
      return ba}
    function array0_of_genarray(a)
     {return 0 === caml_ba_num_dims(a)
              ?a
              :invalid_arg(cst_Bigarray_array0_of_genarra)}
    function array1_of_genarray(a)
     {return 1 === caml_ba_num_dims(a)
              ?a
              :invalid_arg(cst_Bigarray_array1_of_genarra)}
    function array2_of_genarray(a)
     {return 2 === caml_ba_num_dims(a)
              ?a
              :invalid_arg(cst_Bigarray_array2_of_genarra)}
    function array3_of_genarray(a)
     {return 3 === caml_ba_num_dims(a)
              ?a
              :invalid_arg(cst_Bigarray_array3_of_genarra)}
    function reshape_0(a){return caml_ba_reshape(a,[0])}
    function reshape_1(a,dim1){return caml_ba_reshape(a,[0,dim1])}
    function reshape_2(a,dim1,dim2){return caml_ba_reshape(a,[0,dim1,dim2])}
    function reshape_3(a,dim1,dim2,dim3)
     {return caml_ba_reshape(a,[0,dim1,dim2,dim3])}
    var
     Stdlib_bigarray=
      [0,
       float32,
       float64,
       complex32,
       complex64,
       int8_signed,
       int8_unsigned,
       int16_signed,
       int16_unsigned,
       int$2,
       int32$1,
       int64$1,
       nativeint$1,
       char$0,
       kind_size_in_bytes,
       c_layout,
       fortran_layout,
       Genarray,
       [0,create$9,caml_ba_change_layout,size_in_bytes$0,get$1,set$0,of_value],
       [0,create$10,caml_ba_change_layout,size_in_bytes$1,slice,of_array],
       [0,
        create$11,
        caml_ba_change_layout,
        size_in_bytes$2,
        slice_left,
        slice_right,
        of_array$0],
       [0,
        create$12,
        caml_ba_change_layout,
        size_in_bytes$3,
        slice_left_1,
        slice_right_1,
        slice_left_2,
        slice_right_2,
        of_array$1],
       array0_of_genarray,
       array1_of_genarray,
       array2_of_genarray,
       array3_of_genarray,
       caml_ba_reshape,
       reshape_0,
       reshape_1,
       reshape_2,
       reshape_3];
    caml_register_global(805,Stdlib_bigarray,"Stdlib__bigarray");
    return}
  (function(){return this}()));


//# 1 "../../.js/zarith_stubs_js/zarith_stubs_js.cma.js"
(function(joo_global_object)
   {"use strict";
    var runtime=joo_global_object.jsoo_runtime,Zarith_stubs_js=[0];
    runtime.caml_register_global(0,Zarith_stubs_js,"Zarith_stubs_js");
    return}
  (function(){return this}()));


//# 1 "../../.js/js_of_ocaml/js_of_ocaml.cma.js"
(function(joo_global_object)
   {"use strict";
    var
     runtime=joo_global_object.jsoo_runtime,
     caml_float_of_string=runtime.caml_float_of_string,
     caml_fresh_oo_id=runtime.caml_fresh_oo_id,
     caml_int_of_string=runtime.caml_int_of_string,
     caml_js_from_array=runtime.caml_js_from_array,
     caml_js_get=runtime.caml_js_get,
     caml_js_html_escape=runtime.caml_js_html_escape,
     caml_js_set=runtime.caml_js_set,
     caml_js_wrap_callback=runtime.caml_js_wrap_callback,
     caml_js_wrap_meth_callback=runtime.caml_js_wrap_meth_callback,
     caml_jsbytes_of_string=runtime.caml_jsbytes_of_string,
     caml_jsstring_of_string=runtime.caml_jsstring_of_string,
     caml_list_of_js_array=runtime.caml_list_of_js_array,
     caml_ml_string_length=runtime.caml_ml_string_length,
     caml_register_global=runtime.caml_register_global,
     caml_string_compare=runtime.caml_string_compare,
     caml_string_notequal=runtime.caml_string_notequal,
     caml_string_of_array=runtime.caml_string_of_array,
     caml_string_of_jsbytes=runtime.caml_string_of_jsbytes,
     caml_string_of_jsstring=runtime.caml_string_of_jsstring,
     caml_wrap_exception=runtime.caml_wrap_exception;
    function caml_call1(f,a0)
     {return f.length == 1?f(a0):runtime.caml_call_gen(f,[a0])}
    function caml_call2(f,a0,a1)
     {return f.length == 2?f(a0,a1):runtime.caml_call_gen(f,[a0,a1])}
    function caml_call3(f,a0,a1,a2)
     {return f.length == 3?f(a0,a1,a2):runtime.caml_call_gen(f,[a0,a1,a2])}
    function caml_call4(f,a0,a1,a2,a3)
     {return f.length == 4
              ?f(a0,a1,a2,a3)
              :runtime.caml_call_gen(f,[a0,a1,a2,a3])}
    function caml_call5(f,a0,a1,a2,a3,a4)
     {return f.length == 5
              ?f(a0,a1,a2,a3,a4)
              :runtime.caml_call_gen(f,[a0,a1,a2,a3,a4])}
    var
     global_data=runtime.caml_get_global_data(),
     cst_parseFloat=caml_string_of_jsbytes("parseFloat"),
     cst_parseInt=caml_string_of_jsbytes("parseInt"),
     cst_Js_of_ocaml_Js_Error=caml_string_of_jsbytes("Js_of_ocaml__Js.Error"),
     cst_jsError=caml_string_of_jsbytes("jsError"),
     cst_can_t_retrieve_file_name_n=
      caml_string_of_jsbytes("can't retrieve file name: not implemented"),
     cst_endings=caml_string_of_jsbytes("endings"),
     cst_type=caml_string_of_jsbytes("type"),
     cst_loadstart=caml_string_of_jsbytes("loadstart"),
     cst_progress=caml_string_of_jsbytes("progress"),
     cst_abort=caml_string_of_jsbytes("abort"),
     cst_error=caml_string_of_jsbytes("error"),
     cst_load=caml_string_of_jsbytes("load"),
     cst_loadend=caml_string_of_jsbytes("loadend"),
     cst_a$1=caml_string_of_jsbytes("a"),
     cst_area$1=caml_string_of_jsbytes("area"),
     cst_audio$1=caml_string_of_jsbytes("audio"),
     cst_base$1=caml_string_of_jsbytes("base"),
     cst_blockquote$1=caml_string_of_jsbytes("blockquote"),
     cst_body$1=caml_string_of_jsbytes("body"),
     cst_br$1=caml_string_of_jsbytes("br"),
     cst_button$1=caml_string_of_jsbytes("button"),
     cst_canvas$1=caml_string_of_jsbytes("canvas"),
     cst_caption$1=caml_string_of_jsbytes("caption"),
     cst_col$1=caml_string_of_jsbytes("col"),
     cst_colgroup$1=caml_string_of_jsbytes("colgroup"),
     cst_del$1=caml_string_of_jsbytes("del"),
     cst_div$1=caml_string_of_jsbytes("div"),
     cst_dl$1=caml_string_of_jsbytes("dl"),
     cst_embed$1=caml_string_of_jsbytes("embed"),
     cst_fieldset$1=caml_string_of_jsbytes("fieldset"),
     cst_form$1=caml_string_of_jsbytes("form"),
     cst_frame$1=caml_string_of_jsbytes("frame"),
     cst_frameset$1=caml_string_of_jsbytes("frameset"),
     cst_h1$1=caml_string_of_jsbytes("h1"),
     cst_h2$1=caml_string_of_jsbytes("h2"),
     cst_h3$1=caml_string_of_jsbytes("h3"),
     cst_h4$1=caml_string_of_jsbytes("h4"),
     cst_h5$1=caml_string_of_jsbytes("h5"),
     cst_h6$1=caml_string_of_jsbytes("h6"),
     cst_head$1=caml_string_of_jsbytes("head"),
     cst_hr$1=caml_string_of_jsbytes("hr"),
     cst_html$1=caml_string_of_jsbytes("html"),
     cst_iframe$1=caml_string_of_jsbytes("iframe"),
     cst_img$1=caml_string_of_jsbytes("img"),
     cst_input$2=caml_string_of_jsbytes("input"),
     cst_ins$1=caml_string_of_jsbytes("ins"),
     cst_label$1=caml_string_of_jsbytes("label"),
     cst_legend$1=caml_string_of_jsbytes("legend"),
     cst_li$1=caml_string_of_jsbytes("li"),
     cst_link$1=caml_string_of_jsbytes("link"),
     cst_map$1=caml_string_of_jsbytes("map"),
     cst_meta$1=caml_string_of_jsbytes("meta"),
     cst_object$1=caml_string_of_jsbytes("object"),
     cst_ol$1=caml_string_of_jsbytes("ol"),
     cst_optgroup$1=caml_string_of_jsbytes("optgroup"),
     cst_option$1=caml_string_of_jsbytes("option"),
     cst_p$1=caml_string_of_jsbytes("p"),
     cst_param$1=caml_string_of_jsbytes("param"),
     cst_pre$1=caml_string_of_jsbytes("pre"),
     cst_q$1=caml_string_of_jsbytes("q"),
     cst_script$1=caml_string_of_jsbytes("script"),
     cst_select$2=caml_string_of_jsbytes("select"),
     cst_style$1=caml_string_of_jsbytes("style"),
     cst_table$1=caml_string_of_jsbytes("table"),
     cst_tbody$1=caml_string_of_jsbytes("tbody"),
     cst_td$1=caml_string_of_jsbytes("td"),
     cst_textarea$1=caml_string_of_jsbytes("textarea"),
     cst_tfoot$1=caml_string_of_jsbytes("tfoot"),
     cst_th$1=caml_string_of_jsbytes("th"),
     cst_thead$1=caml_string_of_jsbytes("thead"),
     cst_title$1=caml_string_of_jsbytes("title"),
     cst_tr$1=caml_string_of_jsbytes("tr"),
     cst_ul$1=caml_string_of_jsbytes("ul"),
     cst_video$1=caml_string_of_jsbytes("video"),
     cst_KeyH=caml_string_of_jsbytes("KeyH"),
     cst_Digit6=caml_string_of_jsbytes("Digit6"),
     cst_BrowserRefresh=caml_string_of_jsbytes("BrowserRefresh"),
     cst_Backslash=caml_string_of_jsbytes("Backslash"),
     cst_AltLeft=caml_string_of_jsbytes("AltLeft"),
     cst_AltRight=caml_string_of_jsbytes("AltRight"),
     cst_ArrowDown=caml_string_of_jsbytes("ArrowDown"),
     cst_ArrowLeft=caml_string_of_jsbytes("ArrowLeft"),
     cst_ArrowRight=caml_string_of_jsbytes("ArrowRight"),
     cst_ArrowUp=caml_string_of_jsbytes("ArrowUp"),
     cst_Backquote=caml_string_of_jsbytes("Backquote"),
     cst_Backspace=caml_string_of_jsbytes("Backspace"),
     cst_BracketLeft=caml_string_of_jsbytes("BracketLeft"),
     cst_BracketRight=caml_string_of_jsbytes("BracketRight"),
     cst_BrowserBack=caml_string_of_jsbytes("BrowserBack"),
     cst_BrowserFavorites=caml_string_of_jsbytes("BrowserFavorites"),
     cst_BrowserForward=caml_string_of_jsbytes("BrowserForward"),
     cst_BrowserHome=caml_string_of_jsbytes("BrowserHome"),
     cst_Delete=caml_string_of_jsbytes("Delete"),
     cst_BrowserSearch=caml_string_of_jsbytes("BrowserSearch"),
     cst_BrowserStop=caml_string_of_jsbytes("BrowserStop"),
     cst_CapsLock=caml_string_of_jsbytes("CapsLock"),
     cst_Comma=caml_string_of_jsbytes("Comma"),
     cst_ContextMenu=caml_string_of_jsbytes("ContextMenu"),
     cst_ControlLeft=caml_string_of_jsbytes("ControlLeft"),
     cst_ControlRight=caml_string_of_jsbytes("ControlRight"),
     cst_Digit0=caml_string_of_jsbytes("Digit0"),
     cst_Digit1=caml_string_of_jsbytes("Digit1"),
     cst_Digit2=caml_string_of_jsbytes("Digit2"),
     cst_Digit3=caml_string_of_jsbytes("Digit3"),
     cst_Digit4=caml_string_of_jsbytes("Digit4"),
     cst_Digit5=caml_string_of_jsbytes("Digit5"),
     cst_F6=caml_string_of_jsbytes("F6"),
     cst_F1=caml_string_of_jsbytes("F1"),
     cst_Digit7=caml_string_of_jsbytes("Digit7"),
     cst_Digit8=caml_string_of_jsbytes("Digit8"),
     cst_Digit9=caml_string_of_jsbytes("Digit9"),
     cst_End=caml_string_of_jsbytes("End"),
     cst_Enter=caml_string_of_jsbytes("Enter"),
     cst_Equal=caml_string_of_jsbytes("Equal"),
     cst_Escape=caml_string_of_jsbytes("Escape"),
     cst_F10=caml_string_of_jsbytes("F10"),
     cst_F11=caml_string_of_jsbytes("F11"),
     cst_F12=caml_string_of_jsbytes("F12"),
     cst_F2=caml_string_of_jsbytes("F2"),
     cst_F3=caml_string_of_jsbytes("F3"),
     cst_F4=caml_string_of_jsbytes("F4"),
     cst_F5=caml_string_of_jsbytes("F5"),
     cst_KeyA=caml_string_of_jsbytes("KeyA"),
     cst_F7=caml_string_of_jsbytes("F7"),
     cst_F8=caml_string_of_jsbytes("F8"),
     cst_F9=caml_string_of_jsbytes("F9"),
     cst_Home=caml_string_of_jsbytes("Home"),
     cst_Insert=caml_string_of_jsbytes("Insert"),
     cst_IntlBackslash=caml_string_of_jsbytes("IntlBackslash"),
     cst_IntlYen=caml_string_of_jsbytes("IntlYen"),
     cst_KeyB=caml_string_of_jsbytes("KeyB"),
     cst_KeyC=caml_string_of_jsbytes("KeyC"),
     cst_KeyD=caml_string_of_jsbytes("KeyD"),
     cst_KeyE=caml_string_of_jsbytes("KeyE"),
     cst_KeyF=caml_string_of_jsbytes("KeyF"),
     cst_KeyG=caml_string_of_jsbytes("KeyG"),
     cst_Numpad4=caml_string_of_jsbytes("Numpad4"),
     cst_KeyX=caml_string_of_jsbytes("KeyX"),
     cst_KeyP=caml_string_of_jsbytes("KeyP"),
     cst_KeyI=caml_string_of_jsbytes("KeyI"),
     cst_KeyJ=caml_string_of_jsbytes("KeyJ"),
     cst_KeyK=caml_string_of_jsbytes("KeyK"),
     cst_KeyL=caml_string_of_jsbytes("KeyL"),
     cst_KeyM=caml_string_of_jsbytes("KeyM"),
     cst_KeyN=caml_string_of_jsbytes("KeyN"),
     cst_KeyO=caml_string_of_jsbytes("KeyO"),
     cst_KeyQ=caml_string_of_jsbytes("KeyQ"),
     cst_KeyR=caml_string_of_jsbytes("KeyR"),
     cst_KeyS=caml_string_of_jsbytes("KeyS"),
     cst_KeyT=caml_string_of_jsbytes("KeyT"),
     cst_KeyU=caml_string_of_jsbytes("KeyU"),
     cst_KeyV=caml_string_of_jsbytes("KeyV"),
     cst_KeyW=caml_string_of_jsbytes("KeyW"),
     cst_MetaRight=caml_string_of_jsbytes("MetaRight"),
     cst_KeyY=caml_string_of_jsbytes("KeyY"),
     cst_KeyZ=caml_string_of_jsbytes("KeyZ"),
     cst_MediaPlayPause=caml_string_of_jsbytes("MediaPlayPause"),
     cst_MediaStop=caml_string_of_jsbytes("MediaStop"),
     cst_MediaTrackNext=caml_string_of_jsbytes("MediaTrackNext"),
     cst_MediaTrackPrevious=caml_string_of_jsbytes("MediaTrackPrevious"),
     cst_MetaLeft=caml_string_of_jsbytes("MetaLeft"),
     cst_Minus=caml_string_of_jsbytes("Minus"),
     cst_NumLock=caml_string_of_jsbytes("NumLock"),
     cst_Numpad0=caml_string_of_jsbytes("Numpad0"),
     cst_Numpad1=caml_string_of_jsbytes("Numpad1"),
     cst_Numpad2=caml_string_of_jsbytes("Numpad2"),
     cst_Numpad3=caml_string_of_jsbytes("Numpad3"),
     cst_PageUp=caml_string_of_jsbytes("PageUp"),
     cst_NumpadDivide=caml_string_of_jsbytes("NumpadDivide"),
     cst_Numpad5=caml_string_of_jsbytes("Numpad5"),
     cst_Numpad6=caml_string_of_jsbytes("Numpad6"),
     cst_Numpad7=caml_string_of_jsbytes("Numpad7"),
     cst_Numpad8=caml_string_of_jsbytes("Numpad8"),
     cst_Numpad9=caml_string_of_jsbytes("Numpad9"),
     cst_NumpadAdd=caml_string_of_jsbytes("NumpadAdd"),
     cst_NumpadDecimal=caml_string_of_jsbytes("NumpadDecimal"),
     cst_NumpadEnter=caml_string_of_jsbytes("NumpadEnter"),
     cst_NumpadEqual=caml_string_of_jsbytes("NumpadEqual"),
     cst_NumpadMultiply=caml_string_of_jsbytes("NumpadMultiply"),
     cst_NumpadSubtract=caml_string_of_jsbytes("NumpadSubtract"),
     cst_OSLeft=caml_string_of_jsbytes("OSLeft"),
     cst_OSRight=caml_string_of_jsbytes("OSRight"),
     cst_PageDown=caml_string_of_jsbytes("PageDown"),
     cst_ShiftRight=caml_string_of_jsbytes("ShiftRight"),
     cst_Pause=caml_string_of_jsbytes("Pause"),
     cst_Period=caml_string_of_jsbytes("Period"),
     cst_PrintScreen=caml_string_of_jsbytes("PrintScreen"),
     cst_Quote=caml_string_of_jsbytes("Quote"),
     cst_ScrollLock=caml_string_of_jsbytes("ScrollLock"),
     cst_Semicolon=caml_string_of_jsbytes("Semicolon"),
     cst_ShiftLeft=caml_string_of_jsbytes("ShiftLeft"),
     cst_Slash=caml_string_of_jsbytes("Slash"),
     cst_Space=caml_string_of_jsbytes("Space"),
     cst_Tab=caml_string_of_jsbytes("Tab"),
     cst_VolumeDown=caml_string_of_jsbytes("VolumeDown"),
     cst_VolumeMute=caml_string_of_jsbytes("VolumeMute"),
     cst_VolumeUp=caml_string_of_jsbytes("VolumeUp"),
     cst_mouseout$0=caml_string_of_jsbytes("mouseout"),
     cst_mouseover$0=caml_string_of_jsbytes("mouseover"),
     cst_video$0=caml_string_of_jsbytes("video"),
     cst_audio$0=caml_string_of_jsbytes("audio"),
     cst_ul$0=caml_string_of_jsbytes("ul"),
     cst_tr$0=caml_string_of_jsbytes("tr"),
     cst_title$0=caml_string_of_jsbytes("title"),
     cst_thead$0=caml_string_of_jsbytes("thead"),
     cst_th$0=caml_string_of_jsbytes("th"),
     cst_tfoot$0=caml_string_of_jsbytes("tfoot"),
     cst_textarea$0=caml_string_of_jsbytes("textarea"),
     cst_td$0=caml_string_of_jsbytes("td"),
     cst_tbody$0=caml_string_of_jsbytes("tbody"),
     cst_table$0=caml_string_of_jsbytes("table"),
     cst_style$0=caml_string_of_jsbytes("style"),
     cst_select$1=caml_string_of_jsbytes("select"),
     cst_script$0=caml_string_of_jsbytes("script"),
     cst_q$0=caml_string_of_jsbytes("q"),
     cst_pre$0=caml_string_of_jsbytes("pre"),
     cst_param$0=caml_string_of_jsbytes("param"),
     cst_p$0=caml_string_of_jsbytes("p"),
     cst_option$0=caml_string_of_jsbytes("option"),
     cst_optgroup$0=caml_string_of_jsbytes("optgroup"),
     cst_ol$0=caml_string_of_jsbytes("ol"),
     cst_object$0=caml_string_of_jsbytes("object"),
     cst_meta$0=caml_string_of_jsbytes("meta"),
     cst_map$0=caml_string_of_jsbytes("map"),
     cst_link$0=caml_string_of_jsbytes("link"),
     cst_li$0=caml_string_of_jsbytes("li"),
     cst_legend$0=caml_string_of_jsbytes("legend"),
     cst_label$0=caml_string_of_jsbytes("label"),
     cst_ins$0=caml_string_of_jsbytes("ins"),
     cst_input$1=caml_string_of_jsbytes("input"),
     cst_img$0=caml_string_of_jsbytes("img"),
     cst_iframe$0=caml_string_of_jsbytes("iframe"),
     cst_html$0=caml_string_of_jsbytes("html"),
     cst_hr$0=caml_string_of_jsbytes("hr"),
     cst_head$0=caml_string_of_jsbytes("head"),
     cst_h6$0=caml_string_of_jsbytes("h6"),
     cst_h5$0=caml_string_of_jsbytes("h5"),
     cst_h4$0=caml_string_of_jsbytes("h4"),
     cst_h3$0=caml_string_of_jsbytes("h3"),
     cst_h2$0=caml_string_of_jsbytes("h2"),
     cst_h1$0=caml_string_of_jsbytes("h1"),
     cst_frame$0=caml_string_of_jsbytes("frame"),
     cst_frameset$0=caml_string_of_jsbytes("frameset"),
     cst_form$0=caml_string_of_jsbytes("form"),
     cst_embed$0=caml_string_of_jsbytes("embed"),
     cst_fieldset$0=caml_string_of_jsbytes("fieldset"),
     cst_dl$0=caml_string_of_jsbytes("dl"),
     cst_div$0=caml_string_of_jsbytes("div"),
     cst_del$0=caml_string_of_jsbytes("del"),
     cst_colgroup$0=caml_string_of_jsbytes("colgroup"),
     cst_col$0=caml_string_of_jsbytes("col"),
     cst_caption$0=caml_string_of_jsbytes("caption"),
     cst_canvas$0=caml_string_of_jsbytes("canvas"),
     cst_button$0=caml_string_of_jsbytes("button"),
     cst_br$0=caml_string_of_jsbytes("br"),
     cst_body$0=caml_string_of_jsbytes("body"),
     cst_blockquote$0=caml_string_of_jsbytes("blockquote"),
     cst_base$0=caml_string_of_jsbytes("base"),
     cst_area$0=caml_string_of_jsbytes("area"),
     cst_a$0=caml_string_of_jsbytes("a"),
     cst_canvas=caml_string_of_jsbytes("canvas"),
     cst_video=caml_string_of_jsbytes("video"),
     cst_audio=caml_string_of_jsbytes("audio"),
     cst_iframe=caml_string_of_jsbytes("iframe"),
     cst_frame=caml_string_of_jsbytes("frame"),
     cst_frameset=caml_string_of_jsbytes("frameset"),
     cst_address=caml_string_of_jsbytes("address"),
     cst_noscript=caml_string_of_jsbytes("noscript"),
     cst_dt=caml_string_of_jsbytes("dt"),
     cst_dd=caml_string_of_jsbytes("dd"),
     cst_abbr=caml_string_of_jsbytes("abbr"),
     cst_var=caml_string_of_jsbytes("var"),
     cst_kbd=caml_string_of_jsbytes("kbd"),
     cst_samp=caml_string_of_jsbytes("samp"),
     cst_code=caml_string_of_jsbytes("code"),
     cst_dfn=caml_string_of_jsbytes("dfn"),
     cst_cite=caml_string_of_jsbytes("cite"),
     cst_strong=caml_string_of_jsbytes("strong"),
     cst_em=caml_string_of_jsbytes("em"),
     cst_small=caml_string_of_jsbytes("small"),
     cst_big=caml_string_of_jsbytes("big"),
     cst_b=caml_string_of_jsbytes("b"),
     cst_i=caml_string_of_jsbytes("i"),
     cst_tt=caml_string_of_jsbytes("tt"),
     cst_span=caml_string_of_jsbytes("span"),
     cst_sup=caml_string_of_jsbytes("sup"),
     cst_sub=caml_string_of_jsbytes("sub"),
     cst_td=caml_string_of_jsbytes("td"),
     cst_th=caml_string_of_jsbytes("th"),
     cst_tr=caml_string_of_jsbytes("tr"),
     cst_tbody=caml_string_of_jsbytes("tbody"),
     cst_tfoot=caml_string_of_jsbytes("tfoot"),
     cst_thead=caml_string_of_jsbytes("thead"),
     cst_colgroup=caml_string_of_jsbytes("colgroup"),
     cst_col=caml_string_of_jsbytes("col"),
     cst_caption=caml_string_of_jsbytes("caption"),
     cst_table=caml_string_of_jsbytes("table"),
     cst_script=caml_string_of_jsbytes("script"),
     cst_area=caml_string_of_jsbytes("area"),
     cst_map=caml_string_of_jsbytes("map"),
     cst_param=caml_string_of_jsbytes("param"),
     cst_object=caml_string_of_jsbytes("object"),
     cst_img=caml_string_of_jsbytes("img"),
     cst_a=caml_string_of_jsbytes("a"),
     cst_del=caml_string_of_jsbytes("del"),
     cst_ins=caml_string_of_jsbytes("ins"),
     cst_hr=caml_string_of_jsbytes("hr"),
     cst_br=caml_string_of_jsbytes("br"),
     cst_pre=caml_string_of_jsbytes("pre"),
     cst_blockquote=caml_string_of_jsbytes("blockquote"),
     cst_q=caml_string_of_jsbytes("q"),
     cst_h6=caml_string_of_jsbytes("h6"),
     cst_h5=caml_string_of_jsbytes("h5"),
     cst_h4=caml_string_of_jsbytes("h4"),
     cst_h3=caml_string_of_jsbytes("h3"),
     cst_h2=caml_string_of_jsbytes("h2"),
     cst_h1=caml_string_of_jsbytes("h1"),
     cst_p=caml_string_of_jsbytes("p"),
     cst_embed=caml_string_of_jsbytes("embed"),
     cst_div=caml_string_of_jsbytes("div"),
     cst_li=caml_string_of_jsbytes("li"),
     cst_dl=caml_string_of_jsbytes("dl"),
     cst_ol=caml_string_of_jsbytes("ol"),
     cst_ul=caml_string_of_jsbytes("ul"),
     cst_legend=caml_string_of_jsbytes("legend"),
     cst_fieldset=caml_string_of_jsbytes("fieldset"),
     cst_label=caml_string_of_jsbytes("label"),
     cst_button=caml_string_of_jsbytes("button"),
     cst_textarea=caml_string_of_jsbytes("textarea"),
     cst_input$0=caml_string_of_jsbytes("input"),
     cst_select$0=caml_string_of_jsbytes("select"),
     cst_option=caml_string_of_jsbytes("option"),
     cst_optgroup=caml_string_of_jsbytes("optgroup"),
     cst_form=caml_string_of_jsbytes("form"),
     cst_body=caml_string_of_jsbytes("body"),
     cst_style=caml_string_of_jsbytes("style"),
     cst_base=caml_string_of_jsbytes("base"),
     cst_meta=caml_string_of_jsbytes("meta"),
     cst_title=caml_string_of_jsbytes("title"),
     cst_link=caml_string_of_jsbytes("link"),
     cst_head=caml_string_of_jsbytes("head"),
     cst_html=caml_string_of_jsbytes("html"),
     cst_click=caml_string_of_jsbytes("click"),
     cst_dblclick=caml_string_of_jsbytes("dblclick"),
     cst_mousedown=caml_string_of_jsbytes("mousedown"),
     cst_mouseup=caml_string_of_jsbytes("mouseup"),
     cst_mouseover=caml_string_of_jsbytes("mouseover"),
     cst_mousemove=caml_string_of_jsbytes("mousemove"),
     cst_mouseout=caml_string_of_jsbytes("mouseout"),
     cst_keypress=caml_string_of_jsbytes("keypress"),
     cst_keydown=caml_string_of_jsbytes("keydown"),
     cst_keyup=caml_string_of_jsbytes("keyup"),
     cst_mousewheel=caml_string_of_jsbytes("mousewheel"),
     cst_DOMMouseScroll=caml_string_of_jsbytes("DOMMouseScroll"),
     cst_touchstart=caml_string_of_jsbytes("touchstart"),
     cst_touchmove=caml_string_of_jsbytes("touchmove"),
     cst_touchend=caml_string_of_jsbytes("touchend"),
     cst_touchcancel=caml_string_of_jsbytes("touchcancel"),
     cst_dragstart=caml_string_of_jsbytes("dragstart"),
     cst_dragend=caml_string_of_jsbytes("dragend"),
     cst_dragenter=caml_string_of_jsbytes("dragenter"),
     cst_dragover=caml_string_of_jsbytes("dragover"),
     cst_dragleave=caml_string_of_jsbytes("dragleave"),
     cst_drag=caml_string_of_jsbytes("drag"),
     cst_drop=caml_string_of_jsbytes("drop"),
     cst_hashchange=caml_string_of_jsbytes("hashchange"),
     cst_change=caml_string_of_jsbytes("change"),
     cst_input=caml_string_of_jsbytes("input"),
     cst_timeupdate=caml_string_of_jsbytes("timeupdate"),
     cst_submit=caml_string_of_jsbytes("submit"),
     cst_scroll=caml_string_of_jsbytes("scroll"),
     cst_focus=caml_string_of_jsbytes("focus"),
     cst_blur=caml_string_of_jsbytes("blur"),
     cst_load$0=caml_string_of_jsbytes("load"),
     cst_unload=caml_string_of_jsbytes("unload"),
     cst_beforeunload=caml_string_of_jsbytes("beforeunload"),
     cst_resize=caml_string_of_jsbytes("resize"),
     cst_orientationchange=caml_string_of_jsbytes("orientationchange"),
     cst_popstate=caml_string_of_jsbytes("popstate"),
     cst_error$0=caml_string_of_jsbytes("error"),
     cst_abort$0=caml_string_of_jsbytes("abort"),
     cst_select=caml_string_of_jsbytes("select"),
     cst_online=caml_string_of_jsbytes("online"),
     cst_offline=caml_string_of_jsbytes("offline"),
     cst_checking=caml_string_of_jsbytes("checking"),
     cst_noupdate=caml_string_of_jsbytes("noupdate"),
     cst_downloading=caml_string_of_jsbytes("downloading"),
     cst_progress$0=caml_string_of_jsbytes("progress"),
     cst_updateready=caml_string_of_jsbytes("updateready"),
     cst_cached=caml_string_of_jsbytes("cached"),
     cst_obsolete=caml_string_of_jsbytes("obsolete"),
     cst_DOMContentLoaded=caml_string_of_jsbytes("DOMContentLoaded"),
     cst_animationstart=caml_string_of_jsbytes("animationstart"),
     cst_animationend=caml_string_of_jsbytes("animationend"),
     cst_animationiteration=caml_string_of_jsbytes("animationiteration"),
     cst_animationcancel=caml_string_of_jsbytes("animationcancel"),
     cst_canplay=caml_string_of_jsbytes("canplay"),
     cst_canplaythrough=caml_string_of_jsbytes("canplaythrough"),
     cst_durationchange=caml_string_of_jsbytes("durationchange"),
     cst_emptied=caml_string_of_jsbytes("emptied"),
     cst_ended=caml_string_of_jsbytes("ended"),
     cst_gotpointercapture=caml_string_of_jsbytes("gotpointercapture"),
     cst_loadeddata=caml_string_of_jsbytes("loadeddata"),
     cst_loadedmetadata=caml_string_of_jsbytes("loadedmetadata"),
     cst_loadstart$0=caml_string_of_jsbytes("loadstart"),
     cst_lostpointercapture=caml_string_of_jsbytes("lostpointercapture"),
     cst_pause=caml_string_of_jsbytes("pause"),
     cst_play=caml_string_of_jsbytes("play"),
     cst_playing=caml_string_of_jsbytes("playing"),
     cst_pointerenter=caml_string_of_jsbytes("pointerenter"),
     cst_pointercancel=caml_string_of_jsbytes("pointercancel"),
     cst_pointerdown=caml_string_of_jsbytes("pointerdown"),
     cst_pointerleave=caml_string_of_jsbytes("pointerleave"),
     cst_pointermove=caml_string_of_jsbytes("pointermove"),
     cst_pointerout=caml_string_of_jsbytes("pointerout"),
     cst_pointerover=caml_string_of_jsbytes("pointerover"),
     cst_pointerup=caml_string_of_jsbytes("pointerup"),
     cst_ratechange=caml_string_of_jsbytes("ratechange"),
     cst_seeked=caml_string_of_jsbytes("seeked"),
     cst_seeking=caml_string_of_jsbytes("seeking"),
     cst_stalled=caml_string_of_jsbytes("stalled"),
     cst_suspend=caml_string_of_jsbytes("suspend"),
     cst_volumechange=caml_string_of_jsbytes("volumechange"