"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.subscribe = exports.complete = exports.error = exports.next = exports.rxSandbox = void 0;
const rxjs_1 = require("rxjs");
const ColdObservable_1 = require("rxjs/internal/testing/ColdObservable");
const HotObservable_1 = require("rxjs/internal/testing/HotObservable");
const marbleAssert_1 = require("./assert/marbleAssert");
const parseObservableMarble_1 = require("./marbles/parseObservableMarble");
const parseSubscriptionMarble_1 = require("./marbles/parseSubscriptionMarble");
const TestMessage_1 = require("./message/TestMessage");
Object.defineProperty(exports, "complete", { enumerable: true, get: function () { return TestMessage_1.complete; } });
Object.defineProperty(exports, "error", { enumerable: true, get: function () { return TestMessage_1.error; } });
Object.defineProperty(exports, "next", { enumerable: true, get: function () { return TestMessage_1.next; } });
Object.defineProperty(exports, "subscribe", { enumerable: true, get: function () { return TestMessage_1.subscribe; } });
const TestScheduler_1 = require("./scheduler/TestScheduler");
//workaround TS4029 by explicitly import types and avoid unused import error
(() => rxjs_1.Observable.toString())();
(() => ColdObservable_1.ColdObservable.toString())();
(() => HotObservable_1.HotObservable.toString())();
const rxSandbox = {
    create: (autoFlush = false, frameTimeFactor = 1, maxFrameValue = 1000) => {
        const scheduler = new TestScheduler_1.TestScheduler(autoFlush, frameTimeFactor, Math.round(maxFrameValue / frameTimeFactor));
        return {
            scheduler,
            hot: scheduler.createHotObservable.bind(scheduler),
            cold: scheduler.createColdObservable.bind(scheduler),
            flush: scheduler.flush.bind(scheduler),
            advanceTo: scheduler.advanceTo.bind(scheduler),
            getMessages: scheduler.getMessages.bind(scheduler),
            e: (marble, value, error) => parseObservableMarble_1.parseObservableMarble(marble, value, error, true, frameTimeFactor, frameTimeFactor * maxFrameValue),
            s: (marble) => parseSubscriptionMarble_1.parseSubscriptionMarble(marble, frameTimeFactor, frameTimeFactor * maxFrameValue)
        };
    },
    marbleAssert: marbleAssert_1.marbleAssert
};
exports.rxSandbox = rxSandbox;
//# sourceMappingURL=index.js.map