"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.receiptFromOperation = void 0;
var bignumber_js_1 = require("bignumber.js");
var operation_errors_1 = require("../operations/operation-errors");
var receiptFromOperation = function (op, _a) {
    var _b = _a === void 0 ? {
        ALLOCATION_BURN: 257,
        ORIGINATION_BURN: 257,
    } : _a, ALLOCATION_BURN = _b.ALLOCATION_BURN, ORIGINATION_BURN = _b.ORIGINATION_BURN;
    var operationResults = operation_errors_1.flattenOperationResult({ contents: op });
    var totalGas = new bignumber_js_1.default(0);
    var totalStorage = new bignumber_js_1.default(0);
    var totalFee = new bignumber_js_1.default(0);
    var totalOriginationBurn = new bignumber_js_1.default(0);
    var totalAllocationBurn = new bignumber_js_1.default(0);
    var totalPaidStorageDiff = new bignumber_js_1.default(0);
    operationResults.forEach(function (result) {
        totalFee = totalFee.plus(result.fee || 0);
        totalOriginationBurn = totalOriginationBurn.plus(Array.isArray(result.originated_contracts)
            ? result.originated_contracts.length * ORIGINATION_BURN
            : 0);
        totalAllocationBurn = totalAllocationBurn.plus('allocated_destination_contract' in result ? ALLOCATION_BURN : 0);
        totalGas = totalGas.plus(result.consumed_gas || 0);
        totalPaidStorageDiff = totalPaidStorageDiff.plus('paid_storage_size_diff' in result ? Number(result.paid_storage_size_diff) || 0 : 0);
    });
    totalStorage = totalStorage
        .plus(totalAllocationBurn)
        .plus(totalOriginationBurn)
        .plus(totalPaidStorageDiff);
    return {
        totalFee: totalFee,
        totalGas: totalGas,
        totalStorage: totalStorage,
        totalAllocationBurn: totalAllocationBurn,
        totalOriginationBurn: totalOriginationBurn,
        totalPaidStorageDiff: totalPaidStorageDiff,
        totalStorageBurn: new bignumber_js_1.default(totalStorage.multipliedBy(1000)),
    };
};
exports.receiptFromOperation = receiptFromOperation;
//# sourceMappingURL=receipt.js.map