"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PollingSubscribeProvider = void 0;
var rxjs_1 = require("rxjs");
var operators_1 = require("rxjs/operators");
var filters_1 = require("./filters");
var observable_subscription_1 = require("./observable-subscription");
var getLastBlock = function (context) {
    return rxjs_1.from(context.rpc.getBlock()).pipe(operators_1.first());
};
var applyFilter = function (filter) {
    return operators_1.concatMap(function (block) {
        return new rxjs_1.Observable(function (sub) {
            var e_1, _a, e_2, _b, e_3, _c;
            try {
                for (var _d = __values(block.operations), _e = _d.next(); !_e.done; _e = _d.next()) {
                    var ops = _e.value;
                    try {
                        for (var ops_1 = (e_2 = void 0, __values(ops)), ops_1_1 = ops_1.next(); !ops_1_1.done; ops_1_1 = ops_1.next()) {
                            var op = ops_1_1.value;
                            try {
                                for (var _f = (e_3 = void 0, __values(op.contents)), _g = _f.next(); !_g.done; _g = _f.next()) {
                                    var content = _g.value;
                                    if (filters_1.evaluateFilter(__assign({ hash: op.hash }, content), filter)) {
                                        sub.next(__assign({ hash: op.hash }, content));
                                    }
                                }
                            }
                            catch (e_3_1) { e_3 = { error: e_3_1 }; }
                            finally {
                                try {
                                    if (_g && !_g.done && (_c = _f.return)) _c.call(_f);
                                }
                                finally { if (e_3) throw e_3.error; }
                            }
                        }
                    }
                    catch (e_2_1) { e_2 = { error: e_2_1 }; }
                    finally {
                        try {
                            if (ops_1_1 && !ops_1_1.done && (_b = ops_1.return)) _b.call(ops_1);
                        }
                        finally { if (e_2) throw e_2.error; }
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                }
                finally { if (e_1) throw e_1.error; }
            }
            sub.complete();
        });
    });
};
var PollingSubscribeProvider = /** @class */ (function () {
    function PollingSubscribeProvider(context, POLL_INTERVAL) {
        var _this = this;
        if (POLL_INTERVAL === void 0) { POLL_INTERVAL = 20000; }
        this.context = context;
        this.POLL_INTERVAL = POLL_INTERVAL;
        this.newBlock$ = rxjs_1.timer(0, this.POLL_INTERVAL).pipe(operators_1.map(function () { return _this.context; }), operators_1.switchMap(getLastBlock), operators_1.distinctUntilKeyChanged('hash'), operators_1.publishReplay(), operators_1.refCount());
    }
    PollingSubscribeProvider.prototype.subscribe = function (_filter) {
        return new observable_subscription_1.ObservableSubscription(this.newBlock$.pipe(operators_1.pluck('hash')), this.context.config.shouldObservableSubscriptionRetry, this.context.config.observableSubscriptionRetryFunction);
    };
    PollingSubscribeProvider.prototype.subscribeOperation = function (filter) {
        return new observable_subscription_1.ObservableSubscription(this.newBlock$.pipe(applyFilter(filter)), this.context.config.shouldObservableSubscriptionRetry, this.context.config.observableSubscriptionRetryFunction);
    };
    return PollingSubscribeProvider;
}());
exports.PollingSubscribeProvider = PollingSubscribeProvider;
//# sourceMappingURL=polling-provider.js.map