"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MichelCodecParser = void 0;
var michel_codec_1 = require("@taquito/michel-codec");
var errors_1 = require("../contract/errors");
var MichelCodecParser = /** @class */ (function () {
    function MichelCodecParser(context) {
        this.context = context;
    }
    MichelCodecParser.prototype.getNextProto = function () {
        return __awaiter(this, void 0, void 0, function () {
            var next_protocol;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.context.rpc.getBlockMetadata()];
                    case 1:
                        next_protocol = (_a.sent()).next_protocol;
                        return [2 /*return*/, next_protocol];
                }
            });
        });
    };
    MichelCodecParser.prototype.parseScript = function (src) {
        return __awaiter(this, void 0, void 0, function () {
            var parser, _a;
            var _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = michel_codec_1.Parser.bind;
                        _b = {};
                        return [4 /*yield*/, this.getNextProto()];
                    case 1:
                        parser = new (_a.apply(michel_codec_1.Parser, [void 0, (_b.protocol = _c.sent(), _b)]))();
                        return [2 /*return*/, parser.parseScript(src)];
                }
            });
        });
    };
    MichelCodecParser.prototype.parseMichelineExpression = function (src) {
        return __awaiter(this, void 0, void 0, function () {
            var parser, _a;
            var _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = michel_codec_1.Parser.bind;
                        _b = {};
                        return [4 /*yield*/, this.getNextProto()];
                    case 1:
                        parser = new (_a.apply(michel_codec_1.Parser, [void 0, (_b.protocol = _c.sent(), _b)]))();
                        return [2 /*return*/, parser.parseMichelineExpression(src)];
                }
            });
        });
    };
    MichelCodecParser.prototype.parseJSON = function (src) {
        return __awaiter(this, void 0, void 0, function () {
            var parser, _a;
            var _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        _a = michel_codec_1.Parser.bind;
                        _b = {};
                        return [4 /*yield*/, this.getNextProto()];
                    case 1:
                        parser = new (_a.apply(michel_codec_1.Parser, [void 0, (_b.protocol = _c.sent(), _b)]))();
                        return [2 /*return*/, parser.parseJSON(src)];
                }
            });
        });
    };
    MichelCodecParser.prototype.prepareCodeOrigination = function (params) {
        return __awaiter(this, void 0, void 0, function () {
            var parsedParams, _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        parsedParams = params;
                        _a = parsedParams;
                        return [4 /*yield*/, this.formatCodeParam(params.code)];
                    case 1:
                        _a.code = _c.sent();
                        if (!params.init) return [3 /*break*/, 3];
                        _b = parsedParams;
                        return [4 /*yield*/, this.formatInitParam(params.init)];
                    case 2:
                        _b.init = _c.sent();
                        _c.label = 3;
                    case 3: return [2 /*return*/, parsedParams];
                }
            });
        });
    };
    MichelCodecParser.prototype.formatCodeParam = function (code) {
        return __awaiter(this, void 0, void 0, function () {
            var parsedCode, c, c, order_1;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(typeof code === 'string')) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.parseScript(code)];
                    case 1:
                        c = _a.sent();
                        if (c === null) {
                            throw new errors_1.InvalidCodeParameter('Invalid code parameter', code);
                        }
                        parsedCode = c;
                        return [3 /*break*/, 4];
                    case 2: return [4 /*yield*/, this.parseJSON(code)];
                    case 3:
                        c = _a.sent();
                        order_1 = ['parameter', 'storage', 'code'];
                        // Ensure correct ordering for RPC
                        parsedCode = c.sort(function (a, b) { return order_1.indexOf(a.prim) - order_1.indexOf(b.prim); });
                        _a.label = 4;
                    case 4: return [2 /*return*/, parsedCode];
                }
            });
        });
    };
    MichelCodecParser.prototype.formatInitParam = function (init) {
        return __awaiter(this, void 0, void 0, function () {
            var parsedInit, c;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(typeof init === 'string')) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.parseMichelineExpression(init)];
                    case 1:
                        c = _a.sent();
                        if (c === null) {
                            throw new errors_1.InvalidInitParameter('Invalid init parameter', init);
                        }
                        parsedInit = c;
                        return [3 /*break*/, 4];
                    case 2: return [4 /*yield*/, this.parseJSON(init)];
                    case 3:
                        parsedInit = _a.sent();
                        _a.label = 4;
                    case 4: return [2 /*return*/, parsedInit];
                }
            });
        });
    };
    return MichelCodecParser;
}());
exports.MichelCodecParser = MichelCodecParser;
//# sourceMappingURL=michel-codec-parser.js.map