"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidInitParameter = exports.InvalidCodeParameter = exports.InvalidDelegationSource = exports.UndefinedLambdaContractError = exports.InvalidParameterError = void 0;
var InvalidParameterError = /** @class */ (function () {
    function InvalidParameterError(smartContractMethodName, sigs, args) {
        this.smartContractMethodName = smartContractMethodName;
        this.sigs = sigs;
        this.args = args;
        this.name = 'Invalid parameters error';
        this.message = smartContractMethodName + " Received " + args.length + " arguments while expecting one of the following signatures (" + JSON.stringify(sigs) + ")";
    }
    return InvalidParameterError;
}());
exports.InvalidParameterError = InvalidParameterError;
var UndefinedLambdaContractError = /** @class */ (function () {
    function UndefinedLambdaContractError() {
        this.name = 'Undefined LambdaContract error';
        this.message = "This might happen if you are using a sandbox. Please provide the address of a lambda contract as a parameter of the read method.";
    }
    return UndefinedLambdaContractError;
}());
exports.UndefinedLambdaContractError = UndefinedLambdaContractError;
var InvalidDelegationSource = /** @class */ (function () {
    function InvalidDelegationSource(source) {
        this.source = source;
        this.name = 'Invalid delegation source error';
        this.message = "Since Babylon delegation source can no longer be a contract address " + source + ". Please use the smart contract abstraction to set your delegate.";
    }
    return InvalidDelegationSource;
}());
exports.InvalidDelegationSource = InvalidDelegationSource;
var InvalidCodeParameter = /** @class */ (function () {
    function InvalidCodeParameter(message, data) {
        this.message = message;
        this.data = data;
        this.name = 'InvalidCodeParameter';
    }
    return InvalidCodeParameter;
}());
exports.InvalidCodeParameter = InvalidCodeParameter;
var InvalidInitParameter = /** @class */ (function () {
    function InvalidInitParameter(message, data) {
        this.message = message;
        this.data = data;
        this.name = 'InvalidInitParameter';
    }
    return InvalidInitParameter;
}());
exports.InvalidInitParameter = InvalidInitParameter;
//# sourceMappingURL=errors.js.map