import { Token, TokenFactory, TokenValidationError } from './token';
export declare class SaplingTransactionValidationError extends TokenValidationError {
    value: any;
    token: SaplingTransactionToken;
    name: string;
    constructor(value: any, token: SaplingTransactionToken, message: string);
}
export declare class SaplingTransactionToken extends Token {
    protected val: {
        prim: string;
        args: any[];
        annots: any[];
    };
    protected idx: number;
    protected fac: TokenFactory;
    static prim: string;
    constructor(val: {
        prim: string;
        args: any[];
        annots: any[];
    }, idx: number, fac: TokenFactory);
    Execute(_val: any): void;
    private validateBytes;
    private convertUint8ArrayToHexString;
    Encode(args: any[]): any;
    EncodeObject(val: string | Uint8Array): {
        bytes: string;
    };
    ExtractSchema(): {
        [x: string]: {
            'memo-size': number;
        };
    };
}
