import { Semantic, Token, TokenFactory, TokenValidationError } from './token';
export declare class SaplingStateValidationError extends TokenValidationError {
    value: any;
    token: SaplingStateToken;
    name: string;
    constructor(value: any, token: SaplingStateToken, message: string);
}
export declare class SaplingStateToken extends Token {
    protected val: {
        prim: string;
        args: any[];
        annots: any[];
    };
    protected idx: number;
    protected fac: TokenFactory;
    static prim: string;
    constructor(val: {
        prim: string;
        args: any[];
        annots: any[];
    }, idx: number, fac: TokenFactory);
    private isValid;
    Execute(val: {
        int: string;
    }, semantic?: Semantic): any;
    Encode(args: any[]): any;
    EncodeObject(val: any): any;
    ExtractSchema(): {
        [x: string]: {
            'memo-size': number;
        };
    };
}
